#include	<aes.h>
#include	<tos.h>
#include	<string.h>
#include	<portab.h>
#include	<stddef.h>
#include	"..\ass_prg\res.h"
#include	"..\ass_prg\icb.h"
#include	"acc_com.h"


#define	WAIT_TIME	10000L			/* Wartezeit nach Accstart */
#define	CYCLE			250				/* Schleifenzeit */


static WORD GetLowRes(RESOLUTION *res);
static WORD GetNormRes(RESOLUTION *res, ICB *icb);


static WORD appl_id;						/* ID des eigenen Programms */
static WORD	message[8];					/* Dummy-Message-Puffer */
												/* Fehlermeldung */
static BYTE	err_notprg[] = "[3][Start nur als|Accessory sinnvoll!]"
									"[Abbruch]";
static RESOLUTION *res;					/* Zeiger auf Auflsungstabelle */
static ICB *icb;							/* Zeiger auf NOVA-Control-Block */

static WORD low_res;						/* Index fr niedrigste Aufl. */
static WORD norm_res;					/* Index fr Norm-Auflsung */

static WORD	act_res;						/* Index der aktuellen Aufl. */
static WORD	change = 0;					/* Prellflag */

static WORD	old_planes;					/* Anzahl Planes */

WORD	main(void)
{
	WORD	i;

	appl_id = appl_init();				/* eigene ID bestimmen */
	
	if (appl_id != -1)					/* fehlerfrei? */
   {											/* ja: */
		if (!_app)							/* Falls das Programm als Accessory   */
												/* gestartet wurde, hat _app den      */
												/* Wert Null, sonst Eins.             */
		{
			icb = GetICB();				/* Adresse des ICB's bestimmen */
												/* Warten, bis alle Acc's */
												/* initialisiert sind */
			evnt_timer((WORD)(WAIT_TIME & 0xFFFF),
						  (WORD)(WAIT_TIME>>16));
			res = GetResAdr(appl_id);	/* Adresse der Auflsungen bestimmen */
			icb = GetICB();				/* Adresse des ICB's bestimmen */
			if ((res == NULL) ||			/* keine Auflsungen? */
				 (icb == NULL))			/* kein ICB? */
			{									/* ja, also nichts machen */
				for(;;)						/* endlos */
					evnt_mesag(message);	/* warten */
			}

			old_planes = icb->planes;	/* aktuelle Farbanzahl bernehmen */

			low_res = GetLowRes(res);	/* Index fr niedrigste Auflsung */
												/* Index fr aktuelle Auflsung */
			norm_res = GetNormRes(res, icb);

			if (low_res == norm_res)	/* beide identisch? */
			{									/* ja, also nichts machen */
				for(;;)						/* endlos */
					evnt_mesag(message);	/* warten */
			}

			act_res = norm_res;			/* am Anfang normale Auflsung */
			for (;;)
			{
				evnt_timer(CYCLE, 0);	/* etwas warten */
				i = (WORD)Kbshift(-1);	/* Sondertastenstatus */
				if ((i == 6) &&			/* Alt + links Shift? */
					 (!change))				/* und nicht gerade umgeschalten */
				{
												/* hat Res-Switch in der Zwischen- */
												/* zeit zugeschlagen? */
												/* d.h. hat sich Farbanzahl ge- */
												/* ndert? */
					if (old_planes != icb->planes)
					{
												/* Adresse der Auflsungen bestimmen */
						res = GetResAdr(appl_id);
												/* Index fr niedrigste Auflsung */
						low_res = GetLowRes(res);
												/* Index fr aktuelle Auflsung */
						norm_res = GetNormRes(res, icb);
												/* neue Farbanzahl bernehmen */
						old_planes = icb->planes;
					}
					if (act_res == norm_res)
					{
						SetRes(appl_id, low_res);
						act_res = low_res;
					}
					else						/* sonst: */
					{
												/* kleinste Auflsung setzen */
						SetRes(appl_id, norm_res);
						act_res = norm_res;
					}
					change = 1;
				}
				else if (i != 6)
					change = 0;				/* Auflsung nicht gewechselt */
			}
		}
		
		graf_mouse(0, NULL);				/* Mauszeiger als Pfeil */
		
		form_alert(1, err_notprg);		/* Fehlermeldung ausgeben */

		appl_exit();						/* Applikation abmelden */
   }
   return(0);								/* fehlerfrei */
}


static WORD GetLowRes(RESOLUTION *res)
{
	WORD	low_res;
	WORD	i,
			min_x = 5000;
	
												/* alle Auflsungen durchsuchen */
	for (i = 0; (i < 10) && (res->mode != -1); i++, res++)
	{
		if (res->real_x <= min_x)		/* x-Aufl. kleiner als bisher */
												/* kleinste? */
		{
			low_res = i;					/* ja, also Adresse merken */
			min_x = res->real_x;			/* neue kleinste merken */
		}
	}
	return(low_res);						/* Adresse zurckgeben */
}


static WORD GetNormRes(RESOLUTION *res, ICB *icb)
{
	WORD	i;

												/* alle Auflsungen durchsuchen */
	for (i = 0;
		  (i < 10) && (strcmp(res->name, icb->name));
		  i++, res++);

	return(i);								/* Adresse zurckgeben */
}
