/***************************************************************/
/* Aufbau der Kontrollstruktur fr NOVA-Grafikkarten				*/
/* all rights reserved														*/
/***************************************************************/
#ifndef __ICB
#define __ICB

#include	<portab.h>
#include	"RES.H"

/* alle Zeiger auf Routinen erwarten ihre Parameter im */
/* Turbo-/Pure-C-Format: WORD-Parameter in ihrer Reihenfolge in */
/* den Registern d0-d2, Zeiger in den Registern a0-a1 */
typedef struct
{
												/* Versionsnummer in ASCII */
	LONG	id;								/* erst ab Version 1.37 */
												/* Zeiger auf Routine zur  */
												/* Auflsungsumschaltung */
	VOID	(*p_chres)(RESOLUTION *res);
	WORD	mode;								/* Auflsungstyp: */
												/* 0: 16 Farben */
												/* 1: 2 Farben */
												/* 2: 256 Farben */
												/* 3: 32768 Farben */
												/* 4: 64536 Farben */
												/*	5: 16.7 Mio. (24 Bit) */
	WORD	bypl;								/* Bytes pro Bildschirmzeile */
	WORD	planes;							/* Anzahl Bildschirmplanes: */
												/* 1, 4, 8, 16 oder 24*/
	WORD	colors;							/* Anzahl Farben (VDI-Wert) */
	WORD	hc;								/* Hardcopymodus: */
												/* 0: 1 Bildpxl. = 1x1 Druckpxl. */
												/* 1: 1 Bildpxl. = 2x2 Druckpxl. */
												/* 2: 1 Bildpxl. = 4x4 Druckpxl. */
	WORD	max_x, max_y;					/* Bildschirmauflsung */
												/* fr virtuelle Bildschirm- */
												/* verwaltung: */
	WORD	rmn_x, rmx_x;					/* physikalisch auf dem Monitor */
	WORD	rmn_y, rmx_y;					/* dargestellter Bereich */

	UBYTE	*scr_base;						/* Zeiger auf physikalische */
												/* Bildschirmadresse */
	UBYTE	*reg_base;						/* Zeiger auf I/O-Adressen */
	BYTE	name[36];						/* Name der aktuellen Auflsung */

	LONG	bl_count;						/* Zhler fr Dunkelschaltung */
												/* Startwert fr Zhler in */
	LONG	bl_max;							/* 1/200stel Sekunden */
	WORD	bl_on;							/* != 0: Bildschirm ist dunkel */
	
	WORD	card;								/* Graphikkartentyp */
	UBYTE	speed_tab[12];					/* Maus-Beschleunigungstabelle */

												/* virtuelle Bildschirmverwaltung: */
												/* es wird getestet, ob der Punkt */
												/* (x;y) sich im dargestellten */
												/* Bildabschnitt befindet */
												/* falls nicht, wird der darge- */
												/* stellte Abschnitt so verschoben, */
												/* da der Punkt gerade sichtbar */
												/* wird */
	VOID	(*chng_vrt)(WORD x, WORD y);
	WORD	boot_drv;						/* Laufwerk, von dem der Nova- */
												/* Treiber gestartet wurde */
												/* Hier befindet sich auch die */
												/* Auflsungsdatei (im AUTO-Ordner) */

	LONG	(*set_vec)(VOID);				/* Ausgabevektoren neu setzen */
												/* mu im Supervisormodus auf- */
												/* gerufen werden */

	VOID	*main_work;						/* Zeiger auf 1. VDI-Wkst. */
	WORD	(*handler)(WORD x, LONG y);/* Zeiger auf Funktionshandler */
												/* ebenfalls im Supervisormodus */
												/* aufrufen */
	VOID	(*init_col)(VOID);			/* Zeiger auf Farbinitialisierung */
	UWORD	scrn_cnt;						/* Anzahl Bildschirme */
	LONG	scrn_sze;						/* Gre eines Bildschirms in Bytes */
	VOID	*base;							/* Adresse von Bildschirmseite 0 */
	VOID	(*p_setscr)(VOID *adr);		/* Zeiger auf Routine, die */
												/* neue physikalische Bildschirm- */
												/* adresse setzt */
	WORD	v_top, v_bottom,				/* Rnder fr virt. Speicherverwaltung */
			v_left, v_right;
} ICB;

#endif