/*
	Beispielapplikation	fr ACS

	"Menu"

	3.9.91		(c)	Stefan Bachert

*/

#include	<acs.h>
#include	<menue.h>		/* nicht wirklich notwendig in diesem Beispiel */

static Awindow *menu_make (void *not_used);
static int menu_service (Awindow *window, int task, void *in_out);

#define OBJ_1	(1)
#define OBJ_2	(2)
#define OBJ_3	(3)
#define OBJ_4	(4)

#include	<menue.ah>


static void set_menu (Awindow *window)
	/*
	 *	Setze Meneintrge je nach selektiertem Objekt
	 */
{
  AOBJECT *aob;
  OBJECT *menu;
  int nr;
  int count;
  int o1, o2, o3, o4;

  count = o1 = o2 = o3 = o4 = 0;

  Aselect. next = 0;
  while ((nr = Adr_next ()) >= 0) {		/* ermittele Zustand */
	count ++;

	aob = (AOBJECT *) window-> work + nr + 1;
	switch (aob-> type) {
	  case OBJ_1: o1 = 1; break;
	  case OBJ_2: o2 = 1; break;
	  case OBJ_3: o3 = 1; break;
	  case OBJ_4: o4 = 1; break;
	  default:
		break;
	};
  };

  menu = window-> menu;
  if (count == 0) menu [SEL_0]. ob_state &= ~DISABLED; else menu [SEL_0]. ob_state |= DISABLED;
  if (count == 1) menu [SEL_1]. ob_state &= ~DISABLED; else menu [SEL_1]. ob_state |= DISABLED;
  if (count > 0)  menu [SEL_ANY]. ob_state &= ~DISABLED; else menu [SEL_ANY]. ob_state |= DISABLED;

  if (o1)  menu [OBJ1]. ob_state &= ~DISABLED; else menu [OBJ1]. ob_state |= DISABLED;
  if (o2)  menu [OBJ2]. ob_state &= ~DISABLED; else menu [OBJ2]. ob_state |= DISABLED;
  if (o2 && o3)  menu [OBJ23]. ob_state &= ~DISABLED; else menu [OBJ23]. ob_state |= DISABLED;
  if (! o4)  menu [OBJnot4]. ob_state &= ~DISABLED; else menu [OBJnot4]. ob_state |= DISABLED;
  if (o3 ^ o4)  menu [OBJxor34]. ob_state &= ~DISABLED; else menu [OBJxor34]. ob_state |= DISABLED;
}

static int menu_service (Awindow *window, int task, void *in_out)
	/*
	 *	service Routine
	 */
{
  switch (task) {
	case AS_TERM:				/* fenster freigeben */
	  Awi_delete (window);
	  break;
	case AS_SELECTDEL:
	case AS_SELECTADD:
	  set_menu (window);
	  break;
	case AS_DELETE:
	  Adr_unselect ();
	  break;
	default:
	return FAIL;
  };
  return TRUE;
}


static Awindow *menu_make (void *not_used)
	/*
	 *	Erzeuge Hello World Fenster
	 */
{
  Awindow *wi;

  wi = Awi_create (&DEMO);
  if (wi == NULL) return NULL;
  
  (wi-> open) (wi);					/* ffne gleich */
  return wi;
}


int ACSinit (void)
	/*
	 *	Doppelklick auf NEU erzeugt ein neues Fenster
	 */
{
  Awindow *window;

  window = Awi_root ();						/* root window */
  if (window == NULL) return FAIL;			/* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &DEMO. create);

  return OK;
}
