/*
    Beispielapplikation fr ACS

    "Hello World" mit eigenem Desktop

    20.12.91         Stefan Bachert

*/

#include    <acs.h>
#include    <desk.h>

static Awindow *hello_make (void *not_used);
static Awindow *desk_make  (void *not_used);
static int desk_service (Awindow *window, int task, void *in_out);
static void new_window (void);
static void any_where (void);

#include    <desk.ah>


static void any_where (void)
	/*
	 *	frage
	 */
{
  Ame_popup (ev_window, &ASK, -1, -1);
}


static void new_window (void)
	/*
	 *	Weiteres Fenster
	 */
{
  HELLO. create (NULL);
}


static Awindow *desk_make (void *not_used)
    /*
     *  Erzeuge Desktop
     */
{
  Awindow *wi;

  wi = Awi_create (&MY_DESK);
  if (wi == NULL) return NULL;

  if (wi-> work == NULL) return wi;
  if (application) {
	wi-> work-> ob_x      = desk. x;
	wi-> work-> ob_y      = desk. y;
	wi-> work-> ob_width  = desk. w;
	wi-> work-> ob_height = desk. h;
  } else {
	wi-> work-> ob_x      = 0;
	wi-> work-> ob_y      = 0;
	wi-> work-> ob_width  = desk. w / 2;
	wi-> work-> ob_height = desk. h / 2;
  };

  return wi;
}


static Awindow *hello_make (void *not_used)
    /*
     *  Erzeuge Hello World Fenster
     */
{
  Awindow *wi;

  wi = Awi_create (&HELLO);
  if (wi == NULL) return NULL;
  if ((wi-> open) (wi)) {		/* ffne gleich, auch als accessory */
	Awi_delete (wi);
	return NULL;
  };
  return wi;
}


static void term (Awindow *window)
	/*
	 *	Terminiert dieses Window
	 */
{
  if (application) {
	Awi_delete (window);
  } else {
	Awi_closed (window);
  };
}


static int desk_service (Awindow *window, int task, void *in_out)
	/*
	 *
	 */
{
  switch (task) {
  case AS_TERM:
	term (window);
	break;
  default:
	return FALSE;
  };
  return TRUE;
}


int ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
  Awindow *window;

  window = Awi_root ();                 /* root window */

  if (window == NULL) return FAIL;      /* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &HELLO. create);

  window = &HELLO;
  (window-> create) (NULL);             /* sofort ein Fenster erzeugen */

  return OK;
}
