/*
		Beispielapplikation Digital-Uhr

		"DIGI_UHR" als nachladbares Modul

		18.11.92				 Stefan Bachert

*/

#define		__ACS_MODULE__

#include	<tos.h>
#include	<stdio.h>
#include	<acs.h>
#include	"digi_uhr.h"

static Awindow* digi_uhr (void* not_used);
static INT16 init_uhr (Awindow* window);
static INT16 digi_service (Awindow* wi, int task, void* in_out);

#include		"digi_uhr.ah"

static void set_digit (Awindow *window, INT16 index, INT16 digit)
		/*
		 *		Setzt Digit
		 */
{
	OBJECT *work;
	INT16 *olddata, *data;

	work = window-> work;
	olddata = work [index]. ob_spec. iconblk-> ib_pdata;
	switch (digit) {
	case 0:		data = DIGIT_0. ib_pdata; break;
	case 1:		data = DIGIT_1. ib_pdata; break;
	case 2:		data = DIGIT_2. ib_pdata; break;
	case 3:		data = DIGIT_3. ib_pdata; break;
	case 4:		data = DIGIT_4. ib_pdata; break;
	case 5:		data = DIGIT_5. ib_pdata; break;
	case 6:		data = DIGIT_6. ib_pdata; break;
	case 7:		data = DIGIT_7. ib_pdata; break;
	case 8:		data = DIGIT_8. ib_pdata; break;
	case 9:		data = DIGIT_9. ib_pdata; break;
	default:
		return;
	}
	if (olddata != data) {				/* nderung */
		work [index]. ob_spec. iconblk-> ib_pdata = data;
		(window-> obchange) (window, index, work [index]. ob_state);
	}
}

static INT16 init_uhr (Awindow *window)
		/*
		 *		Frischt die Anzeige auf
		 */
{
	static INT16 skipper;
	static unsigned long prev_time = 0;
	unsigned long act_time;
	INT16 t;

	window-> state |= AWS_LATEUPDATE;				/* immer wieder aufrufen */
	if ((skipper ++ & 1) != 0) return OK;		/* nur jedes zweite Mal */

	act_time = Gettime ();								/* Zeit holen ?? Tastatur hngt ?? */
	if (prev_time == act_time) return OK;
	prev_time = act_time;

	if (window-> work [D3_FRAME]. ob_state & SELECTED) {
		t = (INT16) (80 + (act_time >> 25)) % 100;/* Jahr */
		set_digit (window, SEC_1, t % 10);
		set_digit (window, SEC_2, t / 10);

		t = (INT16) (act_time >> 21) & 0xf;				/* Monat */
		set_digit (window, MIN_1, t % 10);
		set_digit (window, MIN_2, t / 10);

		t = (INT16) (act_time >> 16) & 0x1f;				/* Tag */
		set_digit (window, HOUR_1, t % 10);
		set_digit (window, HOUR_2, t / 10);
	} else {
		t = (INT16) (act_time & 0x1f) << 1;				/* Sekunden */
		set_digit (window, SEC_1, t % 10);
		set_digit (window, SEC_2, t / 10);

		t = (INT16) (act_time >> 5) & 0x3f;				/* Minuten */
		set_digit (window, MIN_1, t % 10);
		set_digit (window, MIN_2, t / 10);

		t = (INT16) (act_time >> 11) & 0x1f;				/* Stunden */
		set_digit (window, HOUR_1, t % 10);
		set_digit (window, HOUR_2, t / 10);
	};
	return OK;
}


static Awindow* digi_uhr (void *not_used)
		/*
		 *	Erzeuge Uhrfenster
		 */
{
	Awindow *wi;

	wi = Awi_create (&DIGI_UHR);
	(wi-> open) (wi);
	return wi;
}

static INT16 digi_service (Awindow* wi, int task, void* in_out)
		/*
		 *
		 */
{
	switch (task) {
		case AS_TERM:
			Awi_delete (wi);
			ACSmoduleterm ();
			break;
		case AS_INFO:								/* Info zeigen */
			A_dialog (&INFO_BOX); break;
		default:
			return FALSE;
	};
	return TRUE;
}

INT16 ACSinit (void)
		/*
		 *
		 */
{
	digi_uhr (NULL);
	return OK;
}