/*
		"MEM WATCH" als nachladbares Modul

		13.10.92				 Stefan Bachert

*/

#define __ACS_MODULE__

#include		<tos.h>
#include		<string.h>
#include		<stdio.h>
#include		<acs.h>
#include		<memwatch.h>

static INT16 service_mem (Awindow* wi, int task, void* in_out);
static Awindow* make_mem (void* not_used);
static INT16 init_mem (Awindow* window);

#include		<memwatch.ah>

#define N		(16)
typedef struct {
	void* address;
	long size;
	} MEMW;

static MEMW mems [N];

static INT16 init_mem (Awindow *window)
		/*
		 *		Frischt die Anzeige auf
		 */
{
	static INT16 skipper;
	char st [16];
	long size;
	INT16 i, obnr, chg;
	OBJECT* work;

	window-> state |= AWS_LATEUPDATE;				/* immer wieder aufrufen */
	if ((skipper ++ & 3) != 0) return OK;	/* nur jedes 16. Mal */

	chg = FALSE;
	for (i = 0; i < N; i ++) {
		size = (long) Malloc (-1);
		if (size > 0) {
			if (mems [i]. size != size) chg = TRUE;
			mems [i]. size = size;
			mems [i]. address = Malloc (size);
		} else {
			mems [i]. size = 0;
		}
	}
	for (i = N - 1; i >= 0; i --) {
		size = mems [i]. size;
		if (size > 0) {
			Mfree (mems [i]. address);
		}
	}

	if (! chg) return OK;

	work = window-> work;
	for (i = 0; i < N; i ++) {
		size = mems [i]. size;
		sprintf (st, "%2d:%8ld ", i + 1, size);
		switch (i) {
		case 0:	obnr = MEM1; break;
		case 1:	obnr = MEM2; break;
		case 2:	obnr = MEM3; break;
		case 3:	obnr = MEM4; break;
		case 4:	obnr = MEM5; break;
		case 5:	obnr = MEM6; break;
		case 6:	obnr = MEM7; break;
		case 7:	obnr = MEM8; break;
		case 8:	obnr = MEM9; break;
		case 9:	obnr = MEM10; break;
		case 10:	obnr = MEM11; break;
		case 11:	obnr = MEM12; break;
		case 12:	obnr = MEM13; break;
		case 13:	obnr = MEM14; break;
		case 14:	obnr = MEM15; break;
		case 15:	obnr = MEM16; break;
		default: obnr = MEM16; break;
		}
		strcpy (work [obnr]. ob_spec. free_string, st);
	}
	(window-> obchange) (window, 0, -1);
	return OK;
}


static Awindow* make_mem (void *not_used)
		/*
		 *	Erzeuge Memory Watch
		 */
{
	Awindow *wi;
	wi = Awi_create (&MEM);
	(wi-> open) (wi);
	return wi;
}

static INT16 service_mem (Awindow* wi, int task, void* in_out)
		/*
		 *
		 */
{
	switch (task) {
		case AS_TERM:								/* nur bei Systemterminierung Fenster freigeben */
			Awi_delete (wi);
			ACSmoduleterm ();
			break;
		case AS_INFO:								/* Info zeigen */
			A_dialog (&INFOBOX); break;
		default:
			return FALSE;
	};
	return TRUE;
}

INT16 ACSinit (void)
		/*
		 *
		 */
{
	make_mem (NULL);
	return OK;
}