/*
	Stefan Bachert
	View Key

	zeigt den gedrckten Tatenkode an

*/

#define		__ACS_MODULE__

#include	<stdio.h>
#include  <acs.h>
#include  "viewkey.h"

static Awindow* make_keys (void* not_used);
static void key_keys (Awindow *wi, INT16 kstate, INT16 key);
static INT16 service_keys (Awindow* wi, INT16 task, void* in_out);

#include    "viewkey.ah"

static void setf (Awindow *wi, INT16 obnr, INT16 state)
	/*
	 *	setzt Select entsprechend
	 */
{
  if (state) {
	(wi-> obchange) (wi, obnr, wi-> work [obnr]. ob_state | SELECTED);
  } else {
	(wi-> obchange) (wi, obnr, wi-> work [obnr]. ob_state & ~SELECTED);
  };
}


static void key_keys (Awindow *wi, INT16 kstate, INT16 key)
	/*
	 *	Zeigt key an
	 */
{
  OBJECT *work;
  unsigned char ascii, scan;

  ascii = (unsigned char) key;
  scan = (unsigned char) (key >> 8);
  work = wi-> work;

  sprintf (work [VASCII]. ob_spec. free_string, "%3d", ascii);
  sprintf (work [VHASCII]. ob_spec. free_string, "$%02X", ascii);
  sprintf (work [VSCAN]. ob_spec. free_string, "%3d", scan);
  sprintf (work [VHSCAN]. ob_spec. free_string, "$%02X", scan);

  (wi-> obchange) (wi, VUPDATE, -1);

  setf (wi, VLSHIFT, kstate & K_LSHIFT);
  setf (wi, VRSHIFT, kstate & K_RSHIFT);
  setf (wi, VCTRL, kstate & K_CTRL);
  setf (wi, VALT, kstate & K_ALT);
}


static Awindow* make_keys (void *not_used)
    /*
     *  Erzeuge Uhrfenster
     */
{
  Awindow *wi;

  wi = Awi_create (&VIEWKEY);
  (wi-> open) (wi);
  return wi;
}

static INT16 service_keys (Awindow* wi, INT16 task, void* in_out)
	/*
	 *
	 */
{
  switch (task) {
	case AS_TERM:				/* nur bei Systemterminierung Fenster freigeben */
		Awi_delete (wi);
		ACSmoduleterm ();
	  break;
	case AS_INFO:				/* Info zeigen */
	  A_dialog (&INFOBOX); break;
	default:
	  return FALSE;
  };
  return TRUE;
}

INT16 ACSinit (void)
    /*
     *
     */
{
  make_keys (NULL);
  return OK;
}