/*
    Beispielapplikation fr ACS

    "Abhngige Fenster"

    19.2.92         Stefan Bachert

*/

#include    <acs.h>
#include	<acsplus.h>
#include    <depend.h>

static Awindow *master_make (void *not_used);
static INT16 master_service (Awindow *window, INT16 task, void *in_out);
static INT16 master_open (Awindow *wi);
static void master_closed (Awindow *wi);

static Awindow *slave_make (void *not_used);
static INT16 slave_service (Awindow *window, INT16 task, void *in_out);
static INT16 slave_open (Awindow *wi);
static void slave_closed (Awindow *wi);

#include    <depend.ah>

/*
	SLAVE
*/


static INT16 slave_count = 0;
static Awindow *slave = NULL;


static Awindow *slave_make (void *not_used)
    /*
     *  Erzeuge Teilefenster (Slave)
     */
{
  Awindow *wi;

  wi = Awi_create (&SLAVE);
  if (wi == NULL) return NULL;
  return wi;
}


static INT16 slave_open (Awindow *wi)
	/*
	 *	ffnet
	 */
{
  if (slave_count ++ > 0) return OK;	/* schon offen */
  return Awi_open (wi);
}


static void slave_closed (Awindow *wi)
	/*
	 *	Schliesst Teile
	 */
{
  if (-- slave_count > 0) return;	/* noch offen */

  wi-> state |= AWS_TERM;			/* verhindert das Zeichnen des Icons */
  Awi_closed (wi);
  wi-> state &= ~AWS_TERM;
  slave_count = 0;			
}


static INT16 slave_service (Awindow *window, INT16 task, void *in_out)
	/*
	 *	Service Routine fr Slave
	 */
{
  Awindow *root;

  switch (task)	{						/* welche Routine */
	case AS_TERM:
	  if (appexit) {
		Awi_delete (window);			/* nur bei Systemtermination */
	  };
	  break;
	case AS_ACCLOSED:
	  slave_count = 0;			
	  if (window-> icon >= 0) {	/* nun doch iconifiziert */
		root = Awi_root ();
		(root-> service) (root, AS_REMICON, &window-> icon);
	  };
	  break;
	default:
	  return FALSE;				/* kein Wert */
  };
  return TRUE;					/* wurde durchgefhrt */
};


/*
	MASTER
*/


static Awindow *master_make (void *not_used)
    /*
     *  Erzeuge Arbeitsfenster (Master)
     */
{
  Awindow *wi;

  wi = Awi_create (&MASTER);
  if (wi == NULL) return NULL;
  (wi-> open) (wi);
  return wi;
}


static INT16 master_open (Awindow *wi)
	/*
	 *	ffne Fenster
	 */
{
  if (Awi_open (wi)) return FAIL;
  if ((slave-> open) (slave)) {		/* das nicht zu ffnen ist */
	(wi-> closed) (wi);
	return FAIL;
  };
  return OK;
}


static void master_closed (Awindow *wi)
	/*
	 *	Schliesse Fenster
	 */
{
  Awi_closed (wi);
  (slave-> closed) (slave);
}


static INT16 master_service (Awindow *window, INT16 task, void *in_out)
	/*
	 *	service Routine
	 */
{
  switch (task)	{				/* welche Routine */
	case AS_TERM:
	  Awi_delete (window);
	  break;
	case AS_ICONIZED:			/* schliesse Teilefenster*/
	  (slave-> closed) (slave);
	  break;
	default:
	  return FALSE;				/* kein Wert */
  };
  return TRUE;					/* wurde durchgefhrt */
}


Awindow* make_desk (void* not_used)
{
  return Awi_create (&DESK);
}

static void quit (void)
{
  Awi_sendall (AS_TERM, NULL);  /* erst freundlich anklopfen */
  Aev_quit ();									/* Nun haut das System krftig zu */
}

static void neu (void)
{
  MASTER. create (NULL);
}

INT16 ACSinit (void)
    /*
     *
     */
{
  slave = slave_make (NULL);
  if (slave == NULL) return FAIL;

  return OK;
}
