/*
    Beispielapplikation fr ACS

    "Plot"

    2.12.92         Stefan Bachert

*/

#include		<stdlib.h>
#include    <acs.h>
#include    <acsplus.h>
#include    "plot.h"
#include    "plot.ah"

static Awindow* plotter;
static INT16 count = 0;

static void clear (void)
{
	if (plotter != NULL) {
		w_clr (plotter);
	  w_update (plotter);
	}
}

static void area (void)
{
	INT16 handle;
	INT16 pxy [4];

	if (plotter != NULL) {
		count = 50;						/* Eine Weile Ruhe */
		(plotter-> service) (plotter, AS_PLOTHANDLE, &handle);

	  pxy [0] = pxy [2] = (63 & rand ()) << 2;
	  pxy [1] = pxy [3] = (63 & rand ()) << 2;
	  pxy [2] += ((15 & rand ()) << 2) + 15;
	  pxy [3] += ((15 & rand ()) << 2) + 15;

	  vswr_mode (handle, MD_REPLACE);
		vsf_color (handle, (rand () % (ncolors - 1)) + 1);
	  vsf_interior (handle, FIS_PATTERN);
	  vsf_style	(handle, (15 & rand ()) + 1);
	  vsf_perimeter	(handle, TRUE);

	  w_bar (plotter, pxy);
	  w_update (plotter);
	}
}

static void text (void)
{
	INT16 handle;
	char name [32];
	INT16 fontid, i;
	INT16 point, temp;
	INT16 x, y;

	if (plotter != NULL) {
		count = 50;						/* Eine Weile Ruhe */
		(plotter-> service) (plotter, AS_PLOTHANDLE, &handle);
		i = (rand () % ACSblk-> fonts) + 1;
		fontid = vqt_name (handle, i, name);
	  vst_font (handle, fontid);
		point = vst_point (handle, 99, &temp, &temp, &temp, &temp);
		if (point > 99 || point < 1) return;
		point = vst_point (handle, point >> 1, &temp, &temp, &temp, &temp);
	  x = (63 & rand ()) << 2;
	  y = (63 & rand ()) << 2;
	  vswr_mode (handle, MD_REPLACE);
		vst_color (handle, (rand () % (ncolors - 1)) + 1);
		vst_effects (handle, 0);
		vst_rotation (handle, 0);
		vst_alignment (handle, 0, 5, &temp, &temp);

	  w_gtext (plotter, x, y, "Textprobe");
	  w_update (plotter);
	}
}

static void circle (void)
{
	INT16 handle;
	INT16 x, y, xrad, yrad;

	if (plotter != NULL) {
		count = 50;						/* Eine Weile Ruhe */
		(plotter-> service) (plotter, AS_PLOTHANDLE, &handle);

	  x = (63 & rand ()) << 2;
	  y = (63 & rand ()) << 2;
	  xrad = ((15 & rand ()) << 1) + 7;
	  yrad = ((15 & rand ()) << 1) + 7;

	  vswr_mode (handle, MD_REPLACE);
		vsf_color (handle, (rand () % (ncolors - 1)) + 1);
	  vsf_interior (handle, FIS_PATTERN);
	  vsf_style	(handle, (15 & rand ()) + 1);
	  vsf_perimeter	(handle, TRUE);

	  w_ellipse (plotter, x, y, xrad, yrad);
	  w_update (plotter);
	}
}

static INT16 plot_init (Awindow* wi)
{
	static INT16 update = 0;
	INT16 handle;
	INT16 x, y;

	wi-> state |= AWS_LATEUPDATE;
	if (plotter == NULL) return OK;

	count --;
	if (count > 0) return OK;
	count = 0;

	(plotter-> service) (plotter, AS_PLOTHANDLE, &handle);

  x = (63 & rand ()) << 2;
  y = (63 & rand ()) << 2;

  vswr_mode (handle, MD_REPLACE);
	vsf_color (handle, BLACK);
  vsf_interior (handle, FIS_HOLLOW);
  vsf_perimeter	(handle, TRUE);

  w_circle (plotter, x, y, 5);
	update --;
	if (update <= 0) {
		update = 5;			/* Jeden 5. Hauptschleifendurchlauf updaten */
	  w_update (plotter);
	}
	return OK;
}


static Awindow *plot_make (void *not_used)
    /*
     *  Erzeuge Steuerfenster
     */
{
  Awindow *wi;

  wi = Awi_create (&CONTROL);
  if (wi == NULL) return NULL;
  (wi-> open) (wi);                 /* ffne gleich, auch als accessory */
  return wi;
}


INT16 ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
	plotter = PLOTTER. create (NULL);		/* Plotter erzeugen */

  CONTROL. create (NULL);           	/* sofort ein Fenster erzeugen */
	if (plotter != NULL) {
		(plotter-> open) (plotter);
	}
  return OK;
}
