/*
    Beispielapplikation fr ACS

    "Protocol"

    27.11.92         Stefan Bachert

*/

#include    <stdio.h>
#include    <math.h>
#include    <tos.h>
#include    <acs.h>
#include    <acsplus.h>
#include    "proto.h"
#include    "proto.ah"

static Awindow* protocol;

static void clear (void)
{
	if (protocol != NULL) {
		(protocol-> service) (protocol, AS_DELETE, NULL);
	}
}


static long timer_200Hz (void)
{
  return *((long *) 0x4BA);		/* holt 200Hz Timer */
}

static void zeit (void)
	/*
	 *	Dieser Teil ist ein recht interessantes Testprogramm geworden
	 *	Hier werden Unterschiede verschiedener Betriebsysteme deutlich
	 *	MultiGEM, MultiTOS, MAG!X, NVDI, WINX
	 *	Da das getopptes Fenster am Anfang langsamer ist, liegt
	 *	am Slider Update, der fast die Hlfte der Zeit nimmt (ca 17ms)
	 *	Warum allerdings eine gedrckte linke Maustaste auch Zeit
	 * 	kostet ist mir absolut schleierhaft (ca 18 ms)
	 *
	 */
{
	long timer, t_next, first;
	INT16 i, count;

	if (protocol != NULL) {
		count = 100;
		first = timer = Supexec (timer_200Hz);		/* merke Zeitpunkt */
		for (i = 1; i <= count; i ++)	{
			t_next = Supexec (timer_200Hz);		/* merke Zeitpunkt */
			wprintf (protocol, "\nZeit %3d: %4ld ms", i, (t_next - timer) * 5);
			timer = t_next;
		}
		timer = Supexec (timer_200Hz);		/* merke Zeitpunkt */
		wprintf (protocol, "\nAverage %ld ms", ((timer - first) * 5) / count);
	}
}

static void quadrat (void)
{
	INT16 i;

	if (protocol != NULL) {
		for (i = 1; i <= 20; i ++)	wprintf (protocol, "\nDas Quadrat von %d ist %d", i, i*i);
	}
}


static void sinus (void)
{
	INT16 i;

	if (protocol != NULL) {
		for (i = 0; i <= 90; i ++)	wprintf (protocol, "\nDer Sinus von %d Grad ist %f", i, sin (i * M_PI/180.0));
	}
}


static Awindow *proto_make (void *not_used)
    /*
     *  Erzeuge Steuerfenster
     */
{
  Awindow *wi;

  wi = Awi_create (&CONTROL);
  if (wi == NULL) return NULL;
  (wi-> open) (wi);                 /* ffne gleich, auch als accessory */
  return wi;
}


INT16 ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
#ifdef _PARAS_
	PROTOCOLDATA proto;

	proto. fontid = 273;								/* Monaco */
	proto. height = 13;									/* doppelt hoch */
	proto. col = 20;
	proto. row = 20;
	proto. tabsize = 4;
	proto. wrap = 200;
	proto. x = 40;
	proto. y = 40;

	protocol = PROTOCOL. create (&proto);	/* Protocol erzeugen */
#else
	protocol = PROTOCOL. create (NULL);		/* Protocol erzeugen */
#endif
  CONTROL. create (NULL);             	/* sofort ein Fenster erzeugen */
	if (protocol != NULL) {
		(protocol-> open) (protocol);
	}
  return OK;
}
