{	Beispielapplikation fr ACS
	"Directory"
	28.09.91 Stefan Bachert (Pure C)
	04.10.92 Michael Schlter (Pure Pascal)
	Letzte nderung: 01.01.93
}

PROGRAM directory;						{ Programmname }

{$X+}					{ Functionen knnen ohne Resultat aufgerufen werden }

USES ACS, GEM, TOS;						{ bentigte Units }

PROCEDURE new_drive; FORWARD;			{ Definitionen werden schon }
PROCEDURE new_dir; FORWARD;				{ in DIR.I gebraucht }
PROCEDURE ret_dir; FORWARD;
PROCEDURE make_work( window : AWindowPtr ); FORWARD;
FUNCTION file_make( not_used : POINTER ) : AWindowPtr; FORWARD;

{$I DIR.I}								{ Einladen der Definitionen }

CONST									{ Vordefinierte Werte }
		WIDTH	= 80;
		WIDTH2	= 40;
		HEIGHT	= 48;

TYPE
		TUserPtr	= ^TUser;
		TUser		= RECORD
			drives		:	LONGINT;
			act_drive	:	INTEGER;
			path		:	STRING;
		END;

CONST									{ Objectrecords zum spteren Zusammenbauen }
		back	:	ACSOBJECT = (aes:(ob_next:-1; ob_head:-1; ob_tail:-1; ob_type: G_BOX; ob_flags: NONE; ob_state: AOS_FIXED;ob_spec: (index: $0D);ob_x:  0; ob_y:  0; ob_width: 100; ob_height: 100));
		back0	:	ACSOBJECT = (acs:(ob_flags: AEO; key: $0000;userp1: NIL;userp2: NIL;mo_index: 0; aob_type: 0));
		drv		:	ACSOBJECT = (aes:(ob_next:-1; ob_head:-1; ob_tail:-1; ob_type: G_ICON; ob_flags: 5; ob_state: NORMAL;ob_spec: (icon_blk: @FLOPPY);ob_x:  0; ob_y:  0; ob_width: WIDTH2; ob_height: HEIGHT));
		drv0	:	ACSOBJECT = (acs:(click: new_drive; ob_flags: AEO; key: $0000;userp1: NIL;userp2: NIL;mo_index: 0; aob_type: 0));
		ret		:	ACSOBJECT = (aes:(ob_next:-1; ob_head:-1; ob_tail:-1; ob_type: G_ICON; ob_flags: 5; ob_state: NORMAL;ob_spec: (icon_blk: @DOTDOT);ob_x:  0; ob_y:  0; ob_width: WIDTH; ob_height: HEIGHT));
		ret0	:	ACSOBJECT = (acs:(click: ret_dir; ob_flags: AEO; key: $0000;userp1: NIL;userp2: NIL;mo_index: 0; aob_type: 0));
		dirs	:	ACSOBJECT = (aes:(ob_next:-1; ob_head:-1; ob_tail:-1; ob_type: G_ICON; ob_flags: 5; ob_state: NORMAL;ob_spec: (icon_blk: @DIRECTORY);ob_x:  0; ob_y:  0; ob_width: WIDTH; ob_height: HEIGHT));
		dirs0	:	ACSOBJECT = (acs:(click: new_dir; ob_flags: AEO; key: $0000;userp1: NIL;userp2: NIL;mo_index: 0; aob_type: 0));
		files	:	ACSOBJECT = (aes:(ob_next:-1; ob_head:-1; ob_tail:-1; ob_type: G_ICON; ob_flags: NONE; ob_state: NORMAL;ob_spec: (icon_blk: @FILER);ob_x:  0; ob_y:  0; ob_width: WIDTH; ob_height: HEIGHT));
		files0	:	ACSOBJECT = (acs:(ob_flags: AEO; key: $0000;userp1: NIL;userp2: NIL;mo_index: 0; aob_type: 0));

{ -------------------------------------------------------------	}
{ Wandelt einen C-String in einen Pascal-String um				}
{ -------------------------------------------------------------	}
PROCEDURE str_ctopas(VAR pas_str : STRING; c_str : STRING);
VAR		zaehler		: BYTE;				{ Zeichenzhler }
BEGIN
	zaehler := 0;						{ Auf Null setzten }
	REPEAT
		INC(zaehler);					{ Gleich erhhen }
		pas_str[zaehler] := c_str[zaehler-1];
										{ Zeichen umkopieren }
	UNTIL (c_str[zaehler-1] = CHR(0));	{ Wenn Zeichen = 0 dann Ende }
	pas_str[0] := CHR(zaehler);			{ Zeichenanzahl eintragen }
END;

{ -------------------------------------------------------------	}
{ Wechselt das Laufwerk											}
{ -------------------------------------------------------------	}
PROCEDURE new_drive;
VAR		window	: AWindowPtr;			{ Pointer auf Fensterrecord }
		user	: TUserPtr;				{ Pointer auf Userrecord }
BEGIN
	window := ev_window;				{ Fensterrecordpointer holen }
	user := window^.user;				{ Userrecordpointer holen }
	user^.act_drive := (ev_object^[ev_obnr].aes.ob_spec.icon_blk^.ib_char AND $FF) - ORD('A');
										{ Neues Laufwerk auf Icon holen }
	Dsetdrv(user^.act_drive);			{ Neues Laufwerk setzten }
	Dsetpath('\');						{ Auf obersten Pfad wechseln }
	make_work(window);					{ Fenster zusammenbauen }
	window^.sized(window, @window^.wi_act);
END;

{ -------------------------------------------------------------	}
{ Wechsel das Inhaltsverzeichnis								}
{ -------------------------------------------------------------	}
PROCEDURE new_dir;
VAR		window	: AWindowPtr;			{ Pointer auf Fensterrecord }
		user	: TUserPtr;				{ Pointer auf Userrecord }
		dirname	: STRING;				{ Name des neuen Inhaltsverz. }
BEGIN
	window := ev_window;				{ Fensterrecordpointer holen }
	user := window^.user;				{ Userrecordpointer holen }
	Dsetdrv(user^.act_drive);			{ Zum richtigen Laufwerk wechseln }
	Dsetpath(user^.path);				{ Zum richtigen Pfad wechseln }
	str_ctopas(dirname, STRING(window^.work^[ev_obnr].aes.ob_spec.icon_blk^.ib_ptext^));
										{ Name des neuen Inhaltsverz. aus Icon holen }
	Dsetpath(dirname);					{ Neuen Pfad setzten }
	make_work(window);					{ Fenster zusammenbauen }
	window^.sized(window, @window^.wi_act);
END;

{ -------------------------------------------------------------	}
{ Gehe ein Inhaltsverzeichnis hher								}
{ -------------------------------------------------------------	}
PROCEDURE ret_dir;
VAR		window	: AWindowPtr;			{ Pointer auf Fensterrecord }
		user	: TUserPtr;				{ Pointer auf Userrecord }
BEGIN
	window := ev_window;				{ Fensterrecordpointer holen }
	user := window^.user;				{ Userrecordpointer holen }
	Dsetdrv(user^.act_drive);			{ Zum richtigen Laufwerk wechseln }
	Dsetpath(user^.path);				{ Zum richtigen Pfad wechseln }
	Dsetpath('..');						{ Ein Inhaltsverz. hher }
	make_work(window);					{ Fenster zusammenbauen }
	window^.sized(window, @window^.wi_act);
END;

{ -------------------------------------------------------------	}
{ Baue das innere Workobject zusammen							}
{ -------------------------------------------------------------	}
PROCEDURE make_work( window : AWindowPtr );
LABEL	REDO;
VAR		user		: TUserPtr;			{ Pointer auf Userrecord }
		newdta		: DTA;				{ Neue DTA anlegen }
		olddta		: DTAPtr;			{ Ort der alten DTA speichern }
		work		: ACSTreePtr;		{ Zeiger auf ACSObjectrecord }
		path		: STRING;			{ Enthlt den Pfad }
		pathinfo	: STRING;			{ Enthlt den Pfad fr FENSTERINFO }
		i, n		: INTEGER;			{ Laufvariablen }
		drives		: LONGINT;			{ Alle vorhandenen Laufwerke }
		drive		: CHAR;				{ Buchstabe eines Laufwerkes }
		state		: INTEGER;			{ Rckgabewert von Fsfirst und Fsnext }
		first		: BOOLEAN;			{ Flag fr ersten Versuch }
BEGIN
	user := window^.user;				{ Fensterrecordpointer holen }
	olddta := Fgetdta;					{ Alte DTA retten }
	Fsetdta(@newdta);					{ Neue DTA setzten }
	first := TRUE;						{ Erste Durchgang }
REDO:
	path := 'A:';
	path[1] := CHR(ORD(path[1]) + user^.act_drive);
										{ Akt. Laufwerk ermitteln }
	Dgetpath(user^.path, 0);			{ Akt. Pfad holen }
	path := path + user^.path;			{ Laufwerk und Pfad zusammenbauen }
	pathinfo := path;					{ Als Infotext speichern }
	pathinfo[LENGTH(pathinfo)+1] := CHR(0);
										{ Fr C-Functionen Null-Terminieren }
	Ast_delete(window^.info);			{ Alten Infotext lschen }
	window^.info := Ast_create(@pathinfo[1]);
										{ Neuen Infotext erzeugen }
	path := path + '\*.*';				{ Nach allen Dateien suchen }
	n := 0;								{ Iconzhler = 0 }
	state := Fsfirst( path, FA_DIREC OR FA_RDONLY OR FA_SYSTEM OR FA_HIDDEN OR FA_ARCH);
										{ Suche nach allem }
	WHILE (state >= 0 ) DO				{ Solange etwas gefunden wurde }
	BEGIN
		INC(N);							{ Erhhe Anzahl }
		state := Fsnext;				{ Nchste suchen }
	END;
	IF (state = -33) AND (first = TRUE) THEN
	BEGIN								{ Wenn keine Datei gefunden und erster Durchgang }
		Dsetpath('\');					{ Oberstes Inhaltsverz. nehmen }
		first := FALSE;					{ Erste Durchgang beendet }
		GOTO REDO;						{ Und nocheinmal versuchen }
	END;
	IF (window^.wi_id > 0) THEN			{ Wenn Fenster schon auf }
		windsetinfo(window^.wi_id, pathinfo, STRING(window^.info^));
										{ Setzte den Infotext neu }
	work := Ax_malloc((n+17) * 2 * SizeOf(ACSOBJECT));
										{ Speicher fr das ACSObjectrecord bereitstellen }
	IF (work = NIL) THEN EXIT;			{ Wenn kein Speicher dann Ende }
	IF (window^.work <> NIL) THEN		{ Wenn noch ein altes ACSObject vorhanden }
		Aob_delete(window^.work);		{ wird es gelscht }
	window^.work := work;				{ Neue ACSObjectrecord eintragen }
	work^[0] := back;					{ Objectrecord des Hintergrundes einfgen }
	work^[1] := back0;					{  "" fr ACSObject }
	work^[0].aes.ob_head := 2;			{ Nchste Object }
	i := 2;								{ Objectrecordindex erhhen }
	drive := 'A';
	drives := user^.drives;
	n := 0;								{ Laufwerkezhler = 0 }
	while (drives > 0) DO				{ Solange noch ein Laufwerk vorhanden }
	BEGIN
		IF (drives AND 1) > 0 THEN		{ Wenn Laufwerkbit gesetzt }
		BEGIN
			work^[i] := drv;			{ Object fr Laufwerksicon Kopieren }
			work^[i+1] := drv0;			{ "" fr ACSObject }
			work^[i].aes.ob_spec.icon_blk := Aic_create(drv.aes.ob_spec.icon_blk);
										{ Erzeuge Icon }
			work^[i].aes.ob_spec.icon_blk^.ib_char := (work^[i].aes.ob_spec.icon_blk^.ib_char AND $FF00) + ORD(drive);
										{ Trage Laufwerkszeichen ein }
			work^[i].aes.ob_next := i + 2;
										{ Nchstes Object }
			INC(i, 2);					{ Objectrecordindex erhhen }
			INC(n);						{ Erhhe Laufwerkeanzahl }
		END;
		drives := drives DIV 2;			{ Bit lschen }
		drive := CHR(ORD(drive) + 1);	{ Laufwerkszeichen erhhen }
	END;
	IF (n AND 1) > 0 THEN				{ Wenn ungerade Anzahl an Laufwerken }
		work^[i-2].aes.ob_width := work^[i-2].aes.ob_width * 2;
										{ Letztes Icon doppelt so breit }
	state := Fsfirst(path, FA_DIREC);	{ Suche nach Inhaltsverzeichnissen }
	dirs.aes.ob_spec.icon_blk^.ib_ptext := @newdta.d_fname[1];
										{ Icontext ist der Dateiname }
	WHILE (state >= 0) DO				{ Wiederhole bis alle Inhaltsverzeichnis gelesen }
	BEGIN
		IF (newdta.d_fname <> '.') AND ((newdta.d_attrib AND FA_DIREC) > 0) THEN
		BEGIN							{ Wenn Dateiname nicht '.' oder kein Inhaltsverzeichnis }
			IF (newdta.d_fname = '..') THEN
			BEGIN						{ Wenn Dateiname '..' (zurck) }
				work^[i] := ret;		{ Object fr Zurckicon kopieren }
				work^[i+1] := ret0;		{ "" fr ACSObject }
			END
			ELSE
			BEGIN
				work^[i] := dirs;		{ Sonst Object fr Inhaltsverz. kopieren }
				work^[i+1] := dirs0;	{ "" fr ACSObject }
			END;
			work^[i].aes.ob_spec.icon_blk := Aic_create(work^[i].aes.ob_spec.icon_blk);
										{ Erzeuge Icon }
			work^[i].aes.ob_next := i + 2;
										{ Nchstes Object }
			INC(i, 2);					{ Objectrecordindex erhhen }
		END;
		state := Fsnext;				{ Nchste Inhaltsverzeichnis lesen }
	END;
	state := Fsfirst(path, $27);		{ Suche nache Filenamen }
	files.aes.ob_spec.icon_blk^.ib_ptext := @newdta.d_fname[1];
										{ Icontext ist Filename }
	WHILE (state >= 0) DO				{ Wiederhole bis alle Filenamen gelesen }
	BEGIN
		work^[i] := files;				{ Object fr Fileicon kopieren }
		work^[i+1] := files0;			{ "" fr ACSObject }
		work^[i].aes.ob_spec.icon_blk := Aic_create(files.aes.ob_spec.icon_blk);
										{ Erzeuge Icon }
		work^[i].aes.ob_next := i + 2;	{ Nchstes Object }
		INC(i, 2);						{ Objectrecordindex erhhen }
		state := Fsnext;				{ Nchsten Filenamen lesen }
	END;
	work^[i-2].aes.ob_next := 0;		{ Kein nchstes Object }
	work^[i-1].aes.ob_flags := work^[i-1].aes.ob_flags OR LASTOB;
										{ Object ist letztes Object }
	window^.work^[0].aes.ob_tail := i - 2;
										{ Letztes Object des Parent }
	Fsetdta(olddta);					{ Alte DTA setzten }
END;

{ -------------------------------------------------------------	}
{ ffne ein Fenster und was sonst noch gemacht werden mu		}
{ -------------------------------------------------------------	}
FUNCTION file_make( not_used : POINTER ) : AWindowPtr;
VAR		wi		: AWindowPtr;			{ Pointer auf FensterRecord }
		user	: TUserPtr;				{ Pointer auf UserRecord }
BEGIN
	user := Ax_malloc(SizeOf(TUser));	{ Speicher fr UserRecord bereitstellen }
	IF (user = NIL) THEN				{ Wenn nicht gengend Speicher }
		file_make := NIL				{ Dann Abbruch }
	ELSE
	BEGIN
		wi := Awi_create(@DIR_WI);		{ Sonst Fenster erzeugen }
		IF (wi = NIL) THEN
			file_make := NIL			{ Fehler beim Erzeugen }
		ELSE
		BEGIN
			wi^.user := user;			{ UserblkAdr in FensterRecord sichern }
			user^.act_drive := Dgetdrv;	{ Liefert das aktuelle Laufwerk }
			user^.drives := Dsetdrv(user^.act_drive);
										{ Liefert alle mglichen Laufwerke }
			user^.path[0] := CHR(0);	{ Bisher kein Pfad }
			make_work(wi);				{ Baue Workobject zusammen }
			wi^.open(wi);				{ Fenster gleich ffnen }
			file_make := wi;			{ Keine Fehler aufgetreten }
		END;
	END;
END;

{ -------------------------------------------------------------	}
{ Initialisieren der Applikation								}
{ -------------------------------------------------------------	}
FUNCTION init_acs : INTEGER;
VAR		window	: AWindowPtr;			{ Pointer auf Fensterrecord }
BEGIN
	window := Awi_root;					{ Hole Pointer auf Rootfenster }
	IF (window <> NIL) THEN
	BEGIN
		window^.service(window, AS_NEWCALL, @@DIR_WI.create);
										{ Routine fr Neu-Ikon einsetzten }
		window := @DIR_WI;				{ Hole Pointer auf Direc.-Fenster }
		window^.create(NIL);			{ Fenster sofort erzeugen }
		init_acs := OK;					{ Alles richtig gelaufen }
	END
	ELSE
		init_acs := FAIL;				{ Fehler aufgetreten }
END;

{ -------------------------------------------------------------	}
{ Hauptprogramm													}
{ -------------------------------------------------------------	}
BEGIN									{ Programmstart }
	start_acs(init_acs, @ACSdescr);		{ ACS starten }
END.									{ Programmende }