{	Beispielapplikation fr ACS
	"INPUT"
	02.09.91 Stefan Bachert (Pure C)
	02.01.93 Michael Schlter (Pure Pascal)
	15.01.93 Stefan Bachert
	Letzte nderung: 15.01.93
}

PROGRAM input;

{$X+}

USES GEM, ACS;

CONST	BNAME	: ARRAY [1..10] OF CHAR = '  Inputle'#0;

Type IntegerPtr = ^Integer;
FUNCTION inp_make(para: POINTER): AWindowPtr; FORWARD;
FUNCTION inp_service(wi: AWindowPtr; task: INTEGER; in_out: POINTER): BOOLEAN; FORWARD;

{$I INPUT.I}

{ ----------------------------------------------------------------- }
{ Erzeuge ein Inputfenster											}
{ ----------------------------------------------------------------- }
FUNCTION inp_make(para: POINTER): AWindowPtr;
VAR		wi		: AWindowPtr;
BEGIN
	wi := Awi_create(@INPUT);						{ Erzeuge das Fenster }
	IF wi <> NIL THEN
		wi^.open(wi);								{ ffne das Fenster }
	inp_make := wi;
END;

{ ----------------------------------------------------------------- }
{ Service-Routine													}
{ ----------------------------------------------------------------- }
FUNCTION inp_service(wi: AWindowPtr; task: INTEGER; in_out: POINTER): BOOLEAN;
VAR		obnr		: INTEGER;
		st			: STRING;
			ip: INTEGERPtr;
	{ ------------------------------------------------------------- }
	FUNCTION strup(VAR str : STRING) : STRING;	{ wandelt String in Grobuchstaben um }
	VAR		loop	: BYTE;
	BEGIN
		FOR loop := 1 TO LENGTH(str) DO
			str[loop] := UPCASE(str[loop]);
		strup := str;
	END;
	{ ------------------------------------------------------------- }
BEGIN
	CASE task OF
		AS_TERM:		Awi_delete(wi);			{ Nun ist Schlu }
		AS_FOCUSCHG: BEGIN
						obnr := wi^.ob_edit;{ ermittelt Objektnr. }
						IF obnr >= 0 THEN		{ Wenn Objekt vorhanden }
						BEGIN
							GetPText(AESTreePtr(wi^.work), obnr, st);
							IF st <> '' THEN	{ lese Text aus und kontrolliere ob Zeichen vorhanden }
							BEGIN
								strup(st);		{ Wandel Text in Grobuchstaben um }
								SetPText(AESTreePtr(wi^.work), obnr, st);
								wi^.obchange(wi, obnr, -1); 
												{ Text zurckschreiben und nderung sichtbar machen }
							END
							ELSE
							BEGIN
								ip := IntegerPtr (in_out);
								ip^ := wi^.ob_edit;{ Textcursor in das Objekt stellen }
							END;
						END;
					 END
		ELSE
		BEGIN
			inp_service := FALSE;				{ task konnte nicht bearbeitet werden }
			EXIT;								{ Abbrechen }
		END;
	END;
	inp_service := TRUE;						{ task wurde bearbeitet }
END;

{ ----------------------------------------------------------------- }
{ ACS Initialisieren und NEU-Ikon auf den Desktop legen				}
{ ----------------------------------------------------------------- }
FUNCTION init_acs: INTEGER;
VAR		wi		: AwindowPtr;
BEGIN
	wi := Awi_root;							{ Root window }
	IF (wi <> NIL) THEN						{ Wenn alles klar }
	BEGIN
		wi^.service (wi, AS_NEWCALL, @@INPUT.create);
		wi := @INPUT;
		wi^.create(NIL);					{ sofort Fenster erzeugen }
		init_acs := OK;						{ NEU-Ikon angelegt }
	END
	ELSE
	BEGIN
	  init_acs := FAIL;						{ Das ging daneben }
	END;
END;

{ ----------------------------------------------------------------- }
{ Ersetzt die ACSinit0-Routine										}
{ ----------------------------------------------------------------- }
FUNCTION my_init: INTEGER;
BEGIN
	MOVE(BNAME, ACSblk^.basename, LENGTH(BNAME)); { neuen Basenamen eintragen }
	my_init := OK;
END;

{ ----------------------------------------------------------------- }
{ Hauptprogramm														}
{ ----------------------------------------------------------------- }
BEGIN										{ ACS }
	ACSblk^. ACSinit0 := my_init;			{ eigenes ACSinit0 einbauen }
	start_acs (init_acs, @ACSdescr);		{ und los }
END.