/*
 *				ACS.H				(c) 1991, 1992 Stefan Bachert		
 *
 *				Revision:		19 OKT 1992
 *
 */

#ifndef __ACS__
#define __ACS__
#define __ACS1__  /* OLD style */

/* uses types out of the following includes */

#include		<aes.h>
#include		<vdi.h>

#ifdef		__TURBOC__								/* cdecl is TC, Pure C only */
#	define		INT16		int
#	define		CDECL		cdecl
#else
# ifdef		LATTICE
#	define		CDECL		__stdargs
#	define		INT16		short
# else
#	define		CDECL
#	define		INT16		short
# endif
#endif


#ifndef NULL
#define NULL ((void *) 0L)
#endif

#ifndef FALSE
#define FALSE		(0)								/* Function FALSE value						*/
#endif

#ifndef TRUE
#define TRUE		(1)								/* Function TRUE value						*/
#endif

#ifndef FAIL
#define FAIL		(-1)							/* Function failure return val		*/
#endif

#ifndef OK
#define OK			(0)								/* Function success return val		*/
#endif

/*
 *		Global Types
 */

#define		swd		struct wd				/* local #undef */
swd;														/* recursive use: Awindow */

typedef void (*Aaction) (void);
typedef swd* (*Acreate) (void *x);

typedef struct {								/* Extented Object */
		Aaction click;							/* action on exit, touchexit or dclick */
		Aaction drag;								/* action on drag */
		INT16 ob_flags;							/* ob_flags, must be same as in OBJECT */
																/* since it will be checked */
		INT16 key;									/* key for selecting */
		void* userp1;								/* user pointer */
		void* userp2;
		INT16 mo_index;							/* mouse index upon this field */
																/* contains title number for menues */
		INT16 type;									/* Object type (not AES type) */
		} AOBJECT;

typedef struct {								/* Extented USERBLK */
		INT16 CDECL (*ub_code) (PARMBLK* pb);		/* redraw code */
		long ub_parm;								/* passed parameter */
		INT16 (*ub_serv) (OBJECT *entry, INT16 task, void* in_out);		/* Object message handler */
		void *ub_ptr1;							/* Extra pointers, typicall data */
		void *ub_ptr2;							/* typically window */
		void *ub_ptr3;							/* typically obnr */
		} AUSERBLK;

typedef struct {								/* Mouse parameters */
		INT16 number;								/* Mousenumber 255=Userdef */
		MFORM* form;								/* Mouseform or NULL */
		} Amouse;

typedef struct {INT16 x,y,w,h;} Axywh;	/* Rectangle */

typedef	struct wd {							/* Windowobject */
				/* Users part */
		void* user;									/* Users object pointer */
		INT16 (*service) (swd* a,		/* Service call */
				 INT16 task, void* in_out);
		swd*	(*create) (void* a);	/* create window passing window specific parameters*/
		INT16 (* open) (swd* a);		/* open window return success */
		INT16 (* init) (swd* a);		/* init window return success */
		OBJECT* work;								/* Object within window */
		void* reserved;							/* reserved pointer */
		INT16 ob_edit, ob_col;			/* object nr and act column */
				/* GEM attributes */
		INT16 wi_id;								/* gem window id or -1 */
		INT16 wi_kind;							/* window attributes */
		Axywh wi_act;								/* actual outer coordinates */
		Axywh wi_normal;						/* normal outer coordinates */
		Axywh wi_work;							/* inner size without menu */
		Axywh wi_slider;						/* last set slider (init -1) */
		INT16 wi_nx, wi_ny;					/* normal offset zero or negative */
		INT16 snap_mask;						/* hi y lo x, snap mask due to pattern offset */
		char* name;									/* points to name */
		char* info;									/* points to info */
				/* ACS attributes */
		INT16 type;									/* type of this window */
		INT16 kind;									/* own attributes */
		INT16 state;								/* state of window */
		INT16 icon;									/* objectnr in root window, -1 if not */
		ICONBLK* iconblk;						/* defines the Iconimage, NULL means default Icon */
				/* Menue */
		OBJECT* menu;								/* menuetree OBJECT */
				/* Keyboard */
		void (* keys) (swd* x,			/* unknown key actions */
				INT16 kstate, INT16 key);
				/* mouse select */
		void (*obchange) (swd* a,		/* change state of this object */
				INT16 obnr, INT16 new_state);
				/* window attribute reactions */
		void (*redraw)	(swd* a, Axywh *b);			/* Redraw */
		void (*topped)	(swd* a);								/* Topped */
		void (*closed)	(swd* a);								/* closed */
		void (*fulled)	(swd* a);								/* fulled */
		void (*arrowed)	(swd* a, INT16 which);	/* arrowed */
		void (*hslid)		(swd* a, INT16 pos);		/* hslide */
		void (*vslid)		(swd* a, INT16 pos);		/* vslide */
		void (*sized)		(swd* a, Axywh* b);			/* size */
		void (*moved)		(swd* a, Axywh* b);			/* move */
		} Awindow;

typedef		struct {							/* Description start */
		char magic [8];							/* Magic "ACS 2.0" */
		INT16 version;							/* Version * 200 */
		INT16 dx,dy;								/* virtuell desktop increments */
		INT16 flags;								/* commom flags */
		char acc_reg [32];					/* Accessory register message */
		Awindow* root;							/* Root window */
		Awindow* acc;								/* Accessory first window */
		Amouse mouse [32];					/* 32 Mouseforms */
		} Adescr;

typedef struct {								/* list of selected Objects */
		Awindow* window;						/* the objects belong to this window */
		INT16 maxlen;								/* max entries in list */
		INT16 actlen;								/* actual count */
		INT16 next;									/* next entry return by Adr_next */
		INT16 dragback;							/* drag still selected object back to origin */
		INT16 x, y;									/* position during pick up */
		INT16 rx, ry;								/* relativ dragged distance */
		INT16* array;								/* points to array of obnr's */
		} Asel;

typedef struct {
		Awindow *window;
		OBJECT *entry;
		INT16 obnr;
} Awiob;

#define		__PS__		(127 + 1)				/* Pathsize */

typedef struct {
		/* Before ACSinit0() initialized !! */
		/* AES */
				INT16 gl_apid;					/* AES application ID */
				INT16 phys_handle;			/* workstation for aes */
				INT16 gl_wattr;					/* attribut width */
				INT16 gl_hattr;					/* attribut height */
				Axywh desk;							/* desktop limits XYWH */
		/* VDI */
				INT16 vdi_handle;				/* virtual VDI workstation for ACS */
				INT16 gl_wbox;					/* cell width of standard char */
				INT16 gl_hbox;					/* cell height of standard char */
				INT16 gl_wchar;					/* max width of standard char*/
				INT16 gl_hchar;					/* max height of standard char */
				INT16 ncolors;					/* number of colors (2=mono) */
				INT16 nplanes;					/* number of colors expressed in planes */
		/* Pathes */
				char appname [__PS__];			/* application complete name */
				char apppath [__PS__];			/* application path */
				char apppara [__PS__];			/* application parameter */
				char appfrom [__PS__];			/* application called from */
				char basename[20];			/* basename appname without extention */
		/* others */
				long ev_mtcount;				/* Timerintervall in milli sec (initial 500 ms) */
				INT16 application;			/* runs as an application */
				INT16 multitask;				/* more than 1 applications possible */
				INT16 appexit;					/* application is in system termination mode */
				Adescr* description;		/* surface description, pointer for late assignment */
				Asel Aselect;						/* list of selected objects */
		/* context during callback pointer values */
				Awindow* ev_window;			/* actual window */
				OBJECT* ev_object;			/* actual object tree */
				INT16	ev_obnr;					/* actaul objectnumber, index */
				INT16	ev_mmox, ev_mmoy;	/* Mouse position */
				INT16	ev_mmokstate;			/* Keyboard state */
				INT16	dia_abort;				/* Abort modal dialog */
				MFDB screenMFDB;				/* exactly this */
				INT16 apterm;						/* AP_TERM received */
				INT16* AESglobal;				/* points to initialized (AES) global */
				INT16 fonts;						/* count of available fonts */
				INT16	argc;							/* parameter passed to main routine */
				char **argv;						/* argument list */
				char **env;							/* environment */
				INT16 fontid;						/* Fontid for Userdefs */
				INT16 fheight;					/* Height for Userdeffonts */
				INT16 fontsid;					/* Fontid for Userdef (small) */
				INT16 fsheight;					/* Height for Userdeffonts (small) */
				void (*ACSterm) (void);		/* called before terminating ACS */
				void (*ACSaboutme) (void);	/* call used for 'about me' */
				void (*ACSclose) (void);		/* call used for 'Quit' */
				void (*ACSmessage) (INT16* ev_mmgpbuf);		/* handle unprocessed messages */
				void (*ACSmproto) (INT16* ev_mmgpbuf); 		/* filter unprocessed messages */
				void (*ACStimer) (void);			/* called at end of event loop */
				INT16 (*ACSinit0) (void);			/* pre init */
				INT16 dither;									/* dither config */
} Ablk;

/*
 *		Global Defines
 */

		/* Userdefined Objects Services */
#define AUO_CREATE			(1)					/* UObject can add or initialize data structs */
#define AUO_TERM				(2)					/* UObject can free data structs */
#define AUO_GETVAL			(3)					/* UObject returns value, char ** */
#define AUO_SETVAL			(4)					/* UObject sets value, char * */
#define AUO_UPDATE			(5)					/* UObject smart update */
#define AUO_FULLUPDATE	(6)					/* UObject no smart update */
#define AUO_SELF				(9)					/* tells own identity, Awiob * */
#define AUO_NEXT				(10)				/* inc pos		*/
#define AUO_PREV				(11)				/* dec pos		*/
#define AUO_NEXTPAGE		(12)				/* inc pos by 'step' */
#define AUO_PREVPAGE		(13)				/* dec pos		by 'step' */
#define AUO_BEGIN				(14)				/* pos = 0		*/
#define AUO_END					(15)				/* pos = max */
#define AUO_POS					(17)				/* set pos		*/

		/* description. flags */
#define AB_CLICKMENU		(0x0001)		/* menu drop down on click instead of touch */
#define AB_MOVIES				(0x0002)		/* draws moving, growing, shrink rectangle */
#define	AB_ACUSTIC			(0x0004)		/* acustic bell if user clicks outside of dialog */
#define AB_HIDEPOINTER	(0x0008)		/* hide pointer on key input */
#define	AB_CENTERDIALOG (0x0010)		/* center dialog */
#define	AB_GDOSFONT			(0x0020)		/* load and frees gdos fonts if available */
#define	AB_SMARTREDRAW	(0x0040)		/* use smart redraw */
#define	AB_MENUFIRST		(0x0080)		/* change key consume strategie */

		/* Awindow. service */		/* generic */
#define AS_ACCLOSED				(1)				/* accessory closed, initialize correctly */
#define AS_TERM						(2)				/* terminate */
#define AS_ICONIZED				(3)				/* the window was iconized (in order to receive a free window id) */
#define AS_MOUSE					(4)				/* Mouse is upon the window */
#define AS_SELECTADD			(5)				/* added object in select list */
#define AS_SELECTDEL			(6)				/* deleted object in select list */
#define AS_UNTOPPED				(7)				/* ACS does not handle UNTOPPED, maybe the window want it to know */
#define AS_FOCUSCHG				(8)				/* Input Focus changed within a window */
#define AS_CHECKDRAG			(9)				/* check if window will accept draglist (in) INT16 [0] = obnr, (out) INT16 [1] = TRUE/FALSE */

#define AS_OPEN						(10)			/* Open the selected list of objects */
#define AS_DELETE					(11)			/* delete selected list */
#define AS_CHECKDELETE		(12)			/* is list deleteable, INT16 * (TRUE/FALSE) */
#define AS_INFO						(15)			/* Info about Window */
#define AS_DRAGGED				(16)			/* Something dragged on windows ICON */
#define AS_CHECKDRAGGED		(17)			/* is list acceptable for this window icon, INT16 * (TRUE/FALSE) */
#define AS_CONFIGDRAG			(18)			/* Allows owner window to modify drag parameter like raster (see Doc), INT16 * */

		/* Awindow. kind */
#define	AW_ICON					(0x0001)		/* Iconizing Window instead of Terminating */
#define AW_GHOSTICON		(0x0002)		/* Ghost Icon from beginning */
#define AW_STAY					(0x0004)		/* do not change state of the window iconize/open */
#define AW_OBLIST				(0x0008)		/* inner object is a objects list */
#define AW_ICONACCEPT		(0x0010)		/* accept dragging on windows icon */
#define AW_UHSLIDER			(0x0020)		/* user administrated horizontal slider */
#define AW_UVSLIDER			(0x0040)		/* user administrated vertical slider */
#define AW_NOSCROLL			(0x0080)		/* no optimized scrolling */
#define AW_TOOLBOX			(0x0100)		/* do not top if access (AES 4.0 only) */

		/* Awindow. state */
#define AWS_FULL				(0x0001)		/* State full */
#define AWS_DIALOG			(0x0002)		/* dialog is activ */
#define AWS_MODIFIED		(0x0004)		/* dependend information was changed call init before open */
#define AWS_MODAL				(0x0008)		/* a modal dialog is open for this window */
#define AWS_FORCEREDRAW	(0x0010)		/* forces a redraw */
#define AWS_LATEUPDATE	(0x0020)		/* send AS_UPATE after returning to main loop */
#define AWS_TERM				(0x0100)		/* Terminatesequence active, skip iconizing */
#define AWS_INTERM			(0x0200)		/* USER set! window is term routine in progress, just to avoid double terminating and freeing memory */

		/* OBJECT. ob_flags */
#define AEO							(0x8000)		/* Extended Object */
#define AO_DEFABLE			(0x4000)		/* defaultable Object */
#define AO_DRAGABLE			(0x2000)		/* dragable Object */
#define AO_ACCEPT				(0x1000)		/* accept dragable Object */
#define AO_SILENT				(0x0800)		/* object will NOT visual react (AO_ACCEPT) */

		/* OBJECT. ob_state */
#define AOS_FIXED				(0x8000)		/* Object tree is alread{ fixed */
#define AOS_DCLICK			(0x4000)		/* last selection was a double click */
#define AOS_CONST				(0x2000)		/* Do not copy substructure, do not release (free) substructure */
#define AOS_LOCKED			(0x1000)		/* subtree is locked */
#define AOS_CLTOP				(0x0800)		/* Counterlock Top; is bound to Bottom of parent */
#define AOS_CLBOTTOM		(0x0400)		/* Counterlock Bottom */
#define AOS_CLLEFT			(0x0200)		/* Counterlock Left */
#define AOS_CLRIGHT			(0x0100)		/* Counterlock Right */

		/* AOBJECT. type */
#define AT_ICONWINDOW		(1)					/* iconized window */
#define AT_NEW					(2)					/* new object */
#define AT_TRASH				(3)					/* trash bin */

#define AT_MFDB					(10)				/* MFDB in userp1 */
#define AT_STRING				(11)				/* Nullterminated String in userp1 */

#define AT_FILE 				(20)				/* Nullterminated String in userp1, file path */

		/*		AOBJECT. key */
#define AO_SCANCODE				(0x8000)		/* contain scancode instead of vdi-code */

#undef swd														/* no one knows it any more */


/*
 *		Global Defines
 */

INT16 ACSinit (void);				/* init entry after ACS initializing */

/*
 *		Global Vars		(no Values)
 */

extern Ablk *ACSblk;

#ifndef __ACS_MODULE__

extern Adescr ACSdescr;
INT16 ACSinit0 (void);			/* pre init */
#else
void ACSmoduleterm (void);			/* this module should terminate, WARNING dangerous call*/
#endif

#ifdef __ACS1__
#define gl_apid				(ACSblk-> gl_apid)
#define phys_handle		(ACSblk-> phys_handle)
#define gl_wattr			(ACSblk-> gl_wattr)
#define gl_hattr			(ACSblk-> gl_hattr)
#define desk					(ACSblk-> desk)
		/* VDI */
#define vdi_handle		(ACSblk-> vdi_handle)
#define gl_wbox				(ACSblk-> gl_wbox)
#define gl_hbox				(ACSblk-> gl_hbox)
#define gl_wchar			(ACSblk-> gl_wchar)
#define gl_hchar			(ACSblk-> gl_hchar)
#define ncolors				(ACSblk-> ncolors)
#define nplanes				(ACSblk-> nplanes)
		/* Pathes */
#define appname 			(ACSblk-> appname)
#define apppath				(ACSblk-> apppath)
#define apppara 			(ACSblk-> apppara)
#define appfrom				(ACSblk-> appfrom)
#define basename			(ACSblk-> basename)
		/* others */
#define ev_mtcount		(ACSblk-> ev_mtcount)
#define application		(ACSblk-> application)
#define multitask			(ACSblk-> multitask)
#define appexit				(ACSblk-> appexit)
#define description 	(ACSblk-> description)
#define Aselect				(ACSblk-> Aselect)
		/* context during callback pointer values */
#define ev_window			(ACSblk-> ev_window)
#define ev_object			(ACSblk-> ev_object)
#define ev_obnr				(ACSblk-> ev_obnr)
#define ev_mmox				(ACSblk-> ev_mmox)
#define ev_mmoy				(ACSblk-> ev_mmoy)
#define ev_mmokstate 	(ACSblk-> ev_mmokstate)
#define dia_abort			(ACSblk-> dia_abort)
#define screenMFDB		(ACSblk-> screenMFDB)
#define apterm				(ACSblk-> apterm)
#define AESglobal			(ACSblk-> AESglobal)
#endif

/*
 *		Windowhandling common Routines
 */

Awindow* Awi_wid (const INT16 wid);			/* get window for gem window id */
Awindow* Awi_root (void);								/* return root window */
Awindow* Awi_list (void);								/* next window from total set */
void Awi_sendall												/* sends message to all windows */
		(INT16 task, void *in_out);
void Awi_down (void);										/* cycle down windows */
void Awi_up (void);											/* cycle up windows */
void Awi_show (Awindow *window);				/* show window */
INT16 Awi_init (Awindow *window);				/* Dummy init routine */
Awindow* Awi_create (const Awindow *x);	/* create a copy of window x */
INT16		Awi_open (Awindow *x);					/* open window */
void Awi_closed (Awindow *x);						/* close window */
void Awi_delete (Awindow *x);						/* free window */
void Awi_topped (Awindow *window);			/* top this window */
void Awi_fulled (Awindow *window);			/* fullsize window */
void Awi_sized (Awindow *window,				/* move/resize window */
				Axywh *new);
void Awi_moved (Awindow *window,				/* move/resize window */
				Axywh *new);
void Awi_diaend (void);									/* finish open dialog */
void Awi_diastart (void);								/* start dialog */
void Awi_keys (Awindow *window,					/* key input for dialog */
				INT16 kstate, INT16 key);
void Awi_obview (Awindow *window,				/* show area in work object coordinates */
				Axywh *xywh);
INT16 Awi_service (Awindow *window,			/* very simple service routine */
				INT16 task, void *in_out);
void Awi_scroll (Awindow *window,				/* intelligent scroll/update, x,y upper left edge BEFORE scrolling */
				INT16 x, INT16 y);

/*
 * Window: inner Objects
 */

void Awi_obchange (Awindow *window,			/* change the state of this object in work tree*/
				INT16 obnr, INT16 new_state);		/* ! changed behaviour to 1.0 */
void Awi_obredraw (Awindow *window,			/* redraws everthing in the area of obnr */
				INT16 obnr);										/* uses window-> redraw */
void Awi_redraw (Awindow *window,				/* redraw routine */
				Axywh *limit);
void Awi_arrowed (Awindow *window,			/* arrows */
				INT16 which);
void Awi_hslid (Awindow *window,				/* horizontal slider */
				INT16 pos);
void Awi_vslid (Awindow *window, 				/* vertical slider */
				INT16 pos);

/*
 * Events
 */

void Aev_quit (void);										/* Next eventloop will terminate */
void Aev_mess (void);										/* Accept and handle messages eg redraw */
void Aev_unhidepointer (void);					/* unhides hidden pointer */

/*
 *		Mousehandling
 */

void Amo_new (Amouse* mouse);						/* set new mouse */
void Amo_busy (void);										/* set busy indicator */
void Amo_unbusy (void);									/* remove busy indicator */
void Amo_hide (void);										/* hide mouse */
void Amo_show (void);										/* unhide mouse */

/*
 *		Objecthandling
 */

OBJECT* Aob_create (										/* creates a copy of parent */
				const OBJECT *parent);		
void Aob_delete (OBJECT *object);				/* frees object generated by Aob_create */
void Aob_fix (OBJECT *object);					/* fixes object */
void Aob_offset (Axywh *redraw,					/* calculate redraw rectangle for object */
				OBJECT *ob, INT16 entry);
MFDB* Aob_save (Axywh *rect);						/* save rectangle of desktop */
void Aob_restore (MFDB *save,						/* restore desktop previously save with Aob_save */
				Axywh *rect);
INT16 Aob_watch (Awindow *window,				/* watched object, select if pointer upon obnr */
				INT16 obnr);										/* returns TRUE if button was release upon obnr */
INT16 Aob_findflag (OBJECT *ob,					/* find obnr for which flagmask becomes true, obnr is start object */
				INT16 obnr, INT16 flag);
INT16 Aob_up (OBJECT* ob, INT16 obnr);	/* find parent objectnr, returns -1 on top level */

void Ame_namefix (OBJECT *menu);				/* fixes tree on different length of first title (name) */

INT16 Ame_popup (Awindow *window,				/* pop up a popup menu, x/y determs upper left edge */
		OBJECT *popup, INT16 x, INT16 y);		/* returns selected Obnr, If a callback is defined it will be called */
char* Ame_strpopup											/* Build a popup out of pstr, the entry chk will be checked */
		(Awindow* wi, char* pstr, char* chk,/* should be a substring of pstr, width is the pixel width of popup */
		 INT16 width, INT16 x, INT16 y);		/* returns the selected substring or NULL in none */

/*
 * Backplane Support
 */

MFDB* Abp_create (INT16 w, INT16 h);		/* Create Backplane with width w and height h */
void Abp_delete (MFDB *backplane);			/* free Backplane */
void Abp_start (MFDB *backplane);				/* start writing on backplane (all vdi and aes calls) */
void Abp_end (void);										/* stop writing on backplane, resume to screen */

/*
 * Drag support functions
 */

void Adr_box (INT16 x, INT16 y);				/* start drawing a box which select intersected objects */
void Adr_drag (INT16 x, INT16 y);				/* drag object list */
void Adr_start (void);									/* initialize start */
INT16 Adr_next (void);									/* returns next obnr from list */
																				/* init with Adr_start (), return -1 if no more object are available */
void Adr_add (Awindow *window,					/* add object in Aselect list */
		const INT16 obnr);									/* */
void Adr_del (Awindow *window,					/* delete object from Aselect list, did not update on screen ! */
		const INT16 obnr);									/* */
void Adr_unselect (void);								/* unselect all object in list, update screen ! */		

/*
 *		String support
 */

char* Ast_create (const char *parent);		/* create a copy of parent string */
void Ast_delete (char *string);						/* release this copy */

/*
 * ICON, Image Support
 */

ICONBLK* Aic_create											/* create a copy of icon, but not image part ! */
		(const ICONBLK *icon);
void Aic_delete (ICONBLK *icon);				/* release this copy */

BITBLK* Aim_create											/* create a bitblk copy, but not image */
		(const BITBLK *bitblk);
void Aim_delete (BITBLK *bitblk);				/* release copy */

/*
 *		USER defined Objects
 */

AUSERBLK* Aus_create 										/* create a copy */
		(const AUSERBLK *user);
void Aus_delete (AUSERBLK *user);				/* release this copy */

/*
 *		TEDINFO Support
 */

TEDINFO* Ate_create											/* create a copy */
		(const TEDINFO *tedi);
void Ate_delete (TEDINFO *tedi);				/* release this copy */

/*
 *		Xtra Functions
 */

void* Ax_malloc (long size);						/* ACS Malloc can be overwritten if linked before library */
void Ax_free (void* memory);						/* Mark memory as free */
void Ax_ifree (void* memory);						/* give memory immediate free (be very carefully) */

/*
 *		Dummy Routines
 */

void A_nokey (Awindow* w,								/* Zero Routine */
		INT16 kstate, INT16 key);

/*
 *		Utilities
 */
void Aob_alias (void);									/* Alias object, number in userp1 */
char* A_fileselect (char* title, 				/* calls fileselector */
				char* path,		char* ext);
INT16 A_dialog (OBJECT* dia);						/* Draw a dialogbox near the pointer, handle draw and redraw */
																				/* returns buttonnumber */
INT16 alert_str													/* display an alert box with one string parameter */
		(const char* alert,									/* alert must have the form [X][...%s....][Y] */
		 const char* para);

void intersect (Axywh* to, const Axywh* from);

/*
 *		Predefined "Userdefined Objects"
 */

INT16 CDECL A_checkbox (PARMBLK* pb);		/* checkboxes, parm simular to ob_spec for boxes ! */
INT16 CDECL A_radiobutton (PARMBLK* pb);/* rounded selectable elements, parm simular to ob_spec for boxes ! */
INT16 CDECL A_innerframe (PARMBLK* pb);	/* draws a frames half a character inside ! */
INT16 CDECL A_pattern (PARMBLK* pb);		/* draws general patterns */
INT16 CDECL A_arrows (PARMBLK* pb);			/* draws arrows */
INT16 CDECL A_select (PARMBLK* pb);			/* select in a frame instead of reverse */
INT16 CDECL A_ftext (PARMBLK* pb);			/* Formated multiline Text */
INT16 CDECL A_3Dbutton (PARMBLK *pb);		/* 3D-Style Buttons */
INT16 CDECL A_cycle (PARMBLK *pb);			/* Cycle Buttons */
INT16 CDECL A_picture (PARMBLK *pb);		/* draw picture */

/*
 *		USERDEFs Service routines
 */

/*
 *				Object Services for USERDEF 'A_ftext'
 */

#define AUO_FTFONT				(300)						/* Set Font, INT16 * */
#define AUO_FTHEIGHT			(301)						/* Set Height, INT16 * */
#define AUO_FTCOLOR				(302)						/* Set Color, INT16 * */
#define AUO_FTEFFECTS			(303)						/* Set Effects, INT16 * */
#define AUO_FTLEFT				(304)						/* Set leftalign */
#define AUO_FTRIGHT				(305)						/* Set right align */
#define AUO_FTCENTER			(306)						/* Set center align */
#define AUO_FTBLOCK				(307)						/* Set block align */
INT16 Auo_ftext (OBJECT* entry, INT16 task, void* in_out);
INT16 Auo_string (OBJECT* entry, INT16 task, void* in_out);

#define AUO_CYCPOPUP			(400)						/* set popup string */
#define AUO_CYCINDEX			(401)						/* set index, INT16 * */
#define AUO_CYCGETINDEX		(402)						/* return actual index, INT16 * */
INT16 Auo_cycle (OBJECT* entry, INT16 task, void* in_out);
void Aus_cycle (void);										/* click routine for cycle */

#define AUO_PICMFDB				(500)						/* take MFDB, will not copy MFDB */
INT16 Auo_picture (OBJECT* entry, INT16 task, void* in_out);

/*
 *	Shell feature(s)
 */

long Ash_prog (char* path,				/* call an other Program */
								char* command,		/* return retvalue of Pexec (Basepage) */
								char** env);

INT16 Ash_module (char* path);		/* load and initialize an ACS Module */
																	/* returns OK or FAIL */


#undef __PS__
#endif
