/*
 *	Copyright	(c) 1992 Stefan Bachert
 *
 *	6 DEC 1992
 *
 *		Extensions to ACS
 *
 *		Userdef Objects:
 *						(Wi)Sliders		100 .. 199
 *						Editor				200 .. 299
 *						(Ftext				300 .. 399)
 *						(Cycle				400 .. 499)
 *						(Picture			500 .. 599)
 *
 *		Predefined Windows, (Menu Calls)
 *						DESKTOP				100 .. 199
 *						EDITOR				200 .. 299
 *						PROTOCOL			200 .. 299
 *						PLOTTER				300 .. 399
 *
 *		Prefefined Dialogs
 *						Fontsel
 *
 */

#include		<stdarg.h>

/*
--------------------------------------------------------------
		Userdefined Objects
--------------------------------------------------------------
*/

/*
		SLIDER

		ub_code	= A_slider
		ub_parm = Bit 0 		0 = horizontal, 1 = vertical
		ub_serv = Auo_slider
		ub_ptr1 = 'object'
		ub_ptr2 = unused
		ub_ptr3 = unused

		click		= Aus_slider

		supports also:
				AUO_CREATE				AUO_TERM
				AUO_GETVAL				AUO_SETVAL
				AUO_UPDATE				AUO_WINDOW
				AUO_FULLUPDATE
*/

typedef struct {
	void (*call) (void* obj, long pos);
	void* obj;
} SLLIVE;

#define AUO_SLFULL				(100)		/*	set full */
#define AUO_SLSIZE				(101)		/*	set size */
#define AUO_SLSTEP				(102)		/*	set step */
#define AUO_SLCALL				(103)		/*	set display routine and its object */
#define AUO_SLLEN					(104)		/*	set display char length		*/
#define AUO_SLLIVE				(105)		/*	call live update routine */
#define AUO_SLGETPOS			(107)		/*	get actual pos */

INT16 CDECL A_slider (PARMBLK* pb);		/* Draw routine */
INT16 Auo_slider (OBJECT *entry, INT16 task, void* in_out);		/* Standard service routine */
void Aus_slider (void);								/* standard click routine */

/*
 *	Userdef controls Windowslider like slider (as far as possible)
 */

#define AUO_SLWIPOS				(106)		/*	accept pos as received from WM_HSLID / WM_VSLID, INT16 * */

INT16 CDECL A_wislider (PARMBLK* pb);		/* 'Draw' routine */
INT16 Auo_wislider (OBJECT *entry, INT16 task, void* in_out);		/* Standard service routine */

/*
		EDITOR

		ub_code	= A_editor
		ub_parm =
		ub_serv = Auo_editor
		ub_ptr1 = 'object'
		ub_ptr2 = unused
		ub_ptr3 = unused

		click		= Aus_editor

		supports also:
				AUO_CREATE				AUO_TERM
				AUO_GETVAL				AUO_SETVAL
				AUO_UPDATE
*/

typedef struct {
	long row1;				/* range of substitution */
	long col1;
	long row2;
	long col2;
	long nrow;				/* number of new lines */
	char **text;				/* all lines */
} EDITSUBS;

typedef struct {
	long row;					/* which line */
	long size;				/* char size of line */
	char *text;				/* pointer to line */
} EDITGETS;

typedef struct {
	void (*call) (void* obj, char* text);
	void* obj;
} EDITLIVE;

#define AUO_EDVERSLIDER		(200)				/* register vertical slider, Awiob * */
#define AUO_EDHORSLIDER		(201)				/* register horizontal slider, Awiob * */
#define AUO_EDGETROW			(202)				/* get pointer on line, EDITGETS * */
#define AUO_EDNEWLINE			(203)				/* append newline */
#define AUO_EDAPPLINE			(204)				/* append text, char * */
#define AUO_EDWRAP				(205)				/* set wrap lines, long * */
#define AUO_EDDELETE			(206)				/* delete all text */
#define AUO_EDFONT				(207)				/* font ID, INT16 * */
#define AUO_EDHEIGHT			(208)				/* font height, INT16 * */
#define AUO_EDCOLOR				(209)				/* font color, INT16 * */
#define AUO_EDCFULL				(210)				/* columns (max 512), INT16 * */
#define AUO_EDCURON				(211)				/* cursor on */
#define AUO_EDCUROFF			(212)				/* cursor off */
#define AUO_EDCURHIDE			(213)				/* hide cursor */
#define AUO_EDCURSHOW			(214)				/* show cursor */
#define AUO_EDCURPOS			(215)				/* set cursor pos, INT16 * */
#define AUO_EDGETPOS			(216)				/* get line, long * */
#define AUO_EDHCOL				(217)				/* set home col, long * */
#define AUO_EDHROW				(218)				/* set home row, long * */
#define AUO_EDVIEW				(219)				/* set cursor pos in visible range */
#define AUO_ED1SELECT			(220)				/* select exactly one */
#define AUO_ED01SELECT		(221)				/* select one or nothing */
#define AUO_EDNSELECT			(222)				/* select countinous */
#define AUO_EDNMSELECT		(223)				/* select discontinuos */
#define AUO_EDCHARSELECT	(224)				/* select charmode */
#define AUO_EDBLKSELECT		(225)				/* select blockchar mode */
#define AUO_EDUNSELECT		(226)				/* unselect */
#define AUO_EDGETSELECT		(227)				/* get selection block (row1,col1), (row2,col2), long [4] */
																			/* multi gets for discontinous, starting from prev */
#define AUO_EDSETSELECT		(228)				/* set selection block (row1,col1), (row2,col2), long [4] */
#define AUO_EDCALL				(229)				/* set live selection call */
#define AUO_EDLIVE				(230)				/* call live routine */
#define AUO_EDGETCURPOS		(231)				/* get cursor pos, long * */
#define AUO_EDGETLENGTH		(232)				/* get length of act line, long * */
#define AUO_EDGETROWS			(233)				/* get count of rows, long * */
#define AUO_EDSUB					(234)				/* substitute val, EDITSUBS * */
#define AUO_EDUNDO				(235)				/* UNDO */
#define AUO_EDTABSIZE			(236)				/* Tabsize (def = 4), INT16 * */
#define AUO_EDCLEARUNDO		(237)				/* Clear UNDO Buffer*/
#define AUO_EDRESIZE			(238)				/* Size has been modified, update internal vals */
#define AUO_EDUPDATE			(239)				/* update without sliders */
#define AUO_EDGETTABSIZE	(240)				/* get Tabsize, INT16 * */
#define AUO_EDBLOCKMODE		(241)				/* ? Blockmode, INT16 *, TRUE / FALSE */
#define AUO_EDFIND				(242)				/* Find string, char * */
#define AUO_EDBACKWARD		(243)				/* Find direction backwards */
#define AUO_EDFORWARD			(244)				/* Find direction forward */
#define AUO_EDCASE				(245)				/* Case sensitive */
#define AUO_EDNOCASE			(246)				/* Not Case sensitive */
#define AUO_EDWORD				(247)				/* Word search */
#define AUO_EDNOWORD			(248)				/* No word search */
#define AUO_EDRESET				(249)				/* Set to unchanged */
#define AUO_EDGETCHANGED	(250)				/* changed status, INT16 * */
#define AUO_EDGETNEED			(251)				/* returns byte count needed for save, long * */
#define AUO_EDSELECTWORD	(252)				/* select word at cursor pos */
#define AUO_EDSLIDERS			(253)				/* updates sliders */
#define AUO_EDCURSOR			(254)				/* set cursorform, INT16 * */

INT16 CDECL A_editor (PARMBLK *pb);				/* Draw routine */
INT16 Auo_editor (OBJECT *entry, INT16 task, void* in_out);		/* Standard service routine */
void Aus_editor (void);										/* standard click routine */
void Auok_editor 													/* keyroutine */
				(OBJECT* entry, INT16 kstate, INT16 key);

/*
 *		ACS Plus Windows
 */

														/* desktop */
#define AS_PLACEICON		(100)				/* place icon, in_out = the window */
#define AS_REMICON			(101)				/* remove icon, INT16 * */
#define AS_GHOSTICON		(102)				/* change to ghost icon, INT16 * */
#define AS_NORMICON			(103)				/* chance from ghost icon to normal icon, INT16 * */
#define AS_NEWCALL			(104)				/* set new call */
#define AS_BACKOBJECT		(105)				/* Set Background Objekt, (ob_type, ob_spec) ACSinit0 ! */
#define AS_ICONNEW			(106)				/* Set New-Icon, ACSinit0 ! (wi == NULL) */
#define AS_ICONTRASH		(107)				/* Set Trash-Icon, ACSinit0 ! (wi == NULL) */
#define AS_ICONWINDOW		(108)				/* Set Default-Icon, ACSinit0 ! (wi == NULL) */
#define AS_UPDATEICON		(109)				/* updates icon, INT16 * */

void Awd_quit (void); 
void Awd_open (void); 
void Awd_close (void);
void Awd_delete (void);
void Awd_info (void);
void Awd_hor (void); 
void Awd_list (void); 
void Awd_ver (void); 
void Awd_behaviour (void); 
void Awd_module (void); 

extern Awindow DESKTOP;

/*
	"printf"-Interface for 'EDITOR'
*/

INT16 uputs (char* text, OBJECT *entry);
INT16 uvprintf (OBJECT* entry, const char* format, va_list arglist);
INT16 uprintf (OBJECT* entry, const char* format, ... );

	/*
	 *	Routines from EDITOR-Menu
	 */

void Aed_wrap (void);
void Aed_toclip (void);
void Aed_fromclip (void);
void Aed_copy (void);
void Aed_cut (void);
void Aed_cutline (void);
void Aed_find (void);
void Aed_findnext (void);
void Aed_gotoline (void);
void Aed_info (void);
void Aed_open (void);
void Aed_merge (void);
void Aed_paste (void);
void Aed_quit (void);
void Aed_replace (void);
void Aed_replacenext (void);
void Aed_save (void);
void Aed_saveas (void);
void Aed_font (void);
void Aed_option (void);
void Aed_undo (void);

/*
 *		EDITOR
 */

#define AS_EDGETENTRY		(200)						/* return Editors OBJECT-Entry, OBJECT **	*/
#define AS_EDEXT				(201)						/* Set Extension, char * */
#define AS_EDLOADFILE		(202)						/* Load file, Path char * */
#define AS_EDTITLE			(203)						/* Set normal Title format %s will by substituted by filename, char * */
#define AS_EDTITLEDIRTY	(204)						/* Set dirty Title format %s will by substituted by filename, char * */
#define AS_EDPUTSTRING	(205)						/* Put NUL terminate string LineSep LF / CRLF, char * */
#define AS_EDGETSTRING	(206)						/* Get NUL terminate string LineSep LF / CRLF, char * */
#define AS_EDGETNEED		(207)						/* get memory size of string */
#define AS_EDWINDOW			(208)						/* set controlling window */
#define AS_EDTERM				(209)						/* send to controlling window, editor will terminate, Awindow* editor */
#define AS_EDSAVE				(210)						/* send to controlling window, editor/user wants to save, Awindow* editor */
#define AS_EDCLEAN			(211)						/* define contents clean/unmodified */
#define AS_EDHOME				(212)						/* set cursor at home position */
#define AS_EDICONTEXT		(213)						/* set icontext */

extern Awindow EDITOR;

/*
		Protocol Window
*/

typedef struct {
	INT16 fontid;
	INT16 height;
	INT16 col;
	INT16 row;
	INT16 tabsize;
	INT16 wrap;
	INT16 x;
	INT16 y;
} PROTOCOLDATA;

/*
	"printf"-Interface
*/
INT16 wputs (char *text, Awindow *wi);
INT16 wvprintf (Awindow *wi, const char *format, va_list arglist);
INT16 wprintf (Awindow *wi, const char *format, ... );
extern Awindow PROTOCOL;			/* parameter NULL, or PROTOCOLDATA */

/*
		Plotter Window
*/

/*
	VDI-like Interface
*/

void w_pline (Awindow *wi, INT16 count, INT16 *pxy);
void w_pmarker (Awindow *wi, INT16 count, INT16 *pxy);
void w_gtext (Awindow *wi, INT16 x, INT16 y, char* string);
void w_fillarea (Awindow *wi, INT16 count, INT16 *pxy);
void w_contourfill (Awindow *wi, INT16 x, INT16 y, INT16 index);
void wr_recfl (Awindow *wi, INT16 *pxy);
void w_bar (Awindow *wi, INT16 *pxy);
void w_arc (Awindow *wi, INT16 x, INT16 y, INT16 rad, INT16 begang, INT16 endang);
void w_pieslice (Awindow *wi, INT16 x, INT16 y, INT16 rad, INT16 begang, INT16 endang);
void w_circle (Awindow *wi, INT16 x, INT16 y, INT16 rad);
void w_ellipse (Awindow *wi, INT16 x, INT16 y, INT16 xrad, INT16 yrad);
void w_ellarc (Awindow *wi, INT16 x, INT16 y, INT16 xrad, INT16 yrad, INT16 begang, INT16 endang);
void w_ellpie (Awindow *wi, INT16 x, INT16 y, INT16 xrad, INT16 yrad, INT16 begang, INT16 endang);
void w_rbox (Awindow *wi, INT16 *pxy);
void w_rfbox (Awindow *wi, INT16 *pxy);
void w_justified (Awindow *wi, INT16 x, INT16 y, char* string, INT16 length, INT16 word_space, INT16 char_space);

void w_draw (Awindow *wi, INT16 x1, INT16 y1, INT16 x2, INT16 y2);
void w_update (Awindow *wi);			/* update */
void w_clr (Awindow *wi);				/* clear */
void w_inv (Awindow *wi);				/* invert */

#define	AS_PLOTHANDLE			(300)					/* Plot windows VDI-handle, INT16 *	*/
#define	AS_PLOTMFDB				(301)					/* Plot windows MFDB, MFDB**	*/
#define	AS_PLOTSIZE				(302)					/* resize MFDB, INT16 [2] (w, h) */

typedef struct {
	INT16 x;
	INT16 y;
	INT16 w;
	INT16 h;
} PLOTTERDATA;

extern Awindow PLOTTER;

/*
--------------------------------------------------------------
	Predefined Dialogs
--------------------------------------------------------------
*/

INT16 A_fontsel (INT16* fontid, INT16* height, INT16 prop);

/*
--------------------------------------------------------------
		useful goodies
--------------------------------------------------------------
*/

void read_multiline (char* dest, INT16 len, char** from, INT16 lines);
void write_multiline (char* dest, INT16 len, char** from, INT16 lines);
