/*
 *		(c) 1991 Stefan Bachert
 *
 *		ACS							Application Construction System
 *
 *		MODULE:					UEROTSTR
 *
 *		REVISION:				3 DEC 1992
 *
 *		DESCRIPTION:		Userobject Rotierter String
 *										Editor dazu
 *										
 *										
 *										
 */

/*
 * IMPORT / EXPORT Section
 */

#		include		<stdio.h>
#		include		<string.h>
#		include		<acs.h>
#		include		<UO_ACS.H>
#		include		"UEROTSTR.H"

extern INT16 CDECL A_rotstr (PARMBLK* pb);

/*
 *		Local Defines
 */

/*
 *		Local Types
 */

/*
 *		Local Prototypes
 */


static void replace (void);
static void trans (void);
static void rot_0 (void);
static void rot_90 (void);
static void rot_180 (void);
static void rot_270 (void);
static void ok (void);
static void abort (void);
static void update (void);

static OBJECT* object_tree (AUSER_DEF* aud, OBJECT* obdata);
static void test_it (AUSER_DEF* aud, AUSERBLK* userblk);
static void cleanup (OBJECT* tree);
static void minsize (AUSERBLK* auser, INT16* x, INT16* y);

/*
 *		Local Vars & exported const or initialize
 */

#		include		"UEROTSTR.AH"

/*
 *		Modul Initializiation/Termination
 */

/*
 *		Functions
 */

static AUSERBLK rotstr = 	{A_rotstr, 0x1, Auo_string, "ROT", NULL, NULL};
static OBJECT visual = 		{-1, -1, -1, G_USERDEF, NONE, OUTLINED, (long) &rotstr, 0, 0, 2, 2};
static OBJECT logical = 	{-1, -1, -1, G_USERDEF, NONE, NORMAL, 0L, 0, 0, 2, 2};


static AUSER_DEF maud = {
	"0x1L",
	"Auo_string",
	STR_PAR, "ROT", 0,
	NONE_PAR, NULL, 0,
	NONE_PAR, NULL, 0
};


static UODATAS data = {
	"A_rotstr",						/* Name */
	object_tree,
	test_it,
	ok,
	Aob_delete,
	&visual,
	&logical,
	&maud,
	minsize,
	NULL,
	title
};


static void minsize (AUSERBLK* auser, INT16* x, INT16* y)
		/*
		 *	Berechne empfohlene Mindestgre
		 */
{
	INT16 len;

	if (auser-> ub_ptr1 != NULL) {
		len = gl_wbox * (INT16) strlen (auser-> ub_ptr1);
	} else {
		len = 0;
	};

	switch ((INT16) (auser-> ub_parm & 3)) {
	case 2:		/* 180 */
	case 0:		/* 0 */
		*x = len; *y = gl_hbox;
		break;
	case 3:		/* 270 */
	case 1:		/* 90 */
		*x = gl_hbox; *y = len;
		break;
	}
}


void init_rotstr (Awindow *parts)
	/*
	 *		Eintrag in das Teilefenster
	 */
{
	INT16 h, w;

/* test string ist 90 Grad, 3*1 Zeichen Hoch */

	w = (gl_hbox + gl_wbox - 1) / gl_wbox;
	logical. ob_width = visual. ob_width = w;
	h = (gl_wbox * 3 + gl_hbox - 1) / gl_hbox;
	logical. ob_height = visual. ob_height = h;

	(parts-> service) (parts, AS_ACSADDPART, &data);
}

static OBJECT* object_tree (AUSER_DEF* aud, OBJECT* obdata)
		/*
		 *	gibt initialisierten Objectbaum zurck
		 */
{
	OBJECT* ob, *res, *wob;
	long parm;
	AUSERBLK* auser;

	ob = &ED_STRED;
	res = Aob_create (ob);
	if (res != NULL) {
		wob = res + EXAMPLE;
		wob-> ob_flags |= obdata-> ob_flags & (DEFAULT | EXIT | RBUTTON);
		wob-> ob_state |= obdata-> ob_state & (SELECTED | DISABLED | CROSSED | CHECKED | OUTLINED | SHADOWED);
		auser = (AUSERBLK *) wob-> ob_spec. userblk;
		sscanf (aud-> parm, "0x%lxL", &parm);
		auser-> ub_parm = parm;
		if (aud-> type1 == STR_PAR) {
			(auser-> ub_serv) (wob, AUO_SETVAL, aud-> data1);
			strncpy (res [TEXT]. ob_spec. tedinfo-> te_ptext, aud-> data1, 15);
		} else {
			(auser-> ub_serv) (wob, AUO_SETVAL, "");
			*res [TEXT]. ob_spec. tedinfo-> te_ptext = '\0';
		}
	}
	return res;
}

static void test_it (AUSER_DEF* aud, AUSERBLK* userblk)
		/*
		 *	
		 */
{
	userblk-> ub_code = A_rotstr;
	sscanf (aud-> parm, "0x%lxL", &userblk-> ub_parm);
	userblk-> ub_serv = Auo_string;
	if (aud-> type1 == STR_PAR) {
		userblk-> ub_ptr1 =	aud-> data1;
	} else {
		userblk-> ub_ptr1 =	NULL;
	}
	userblk-> ub_ptr2 =	userblk-> ub_ptr3 = NULL;
}


static void abort (void)
		/*
		 *		bertrgt die Modifizierten Werte
		 */
{
	(data. interface-> abort) ();
}

static void ok (void)
		/*
		 *		bertrgt die Modifizierten Werte
		 */
{
	static char parm [32];
	OBJECT* work;
	AUSERBLK* auser;
	AUSER_DEF aud;
	INT16 width, height, len;
	char *p;

	work = ev_window-> work;

	auser = (AUSERBLK *) work [EXAMPLE]. ob_spec. userblk;

	sprintf (parm, "0x%lxL", auser-> ub_parm);
	aud. parm = parm;
	aud. serv = "Auo_string";
	p = work [TEXT]. ob_spec. tedinfo-> te_ptext;
	if (*p != '\0') {
		aud. type1 = STR_PAR;
		aud. data1 = p;
		aud. len1	= 0;
		len = gl_wbox * (INT16) strlen (p);
	} else {
		aud. type1 = NONE_PAR;
		aud. data1 = NULL;
		aud. len1	= 0;
		len = 0;
	}

	switch ((INT16) auser-> ub_parm & 3) {
	case 2:		/* 180 */
	case 0:		/* 0 */
		width = len; height = gl_hbox;
		break;
	case 3:		/* 270 */
	case 1:		/* 90 */
		width = gl_hbox; height = len;
		break;
	}
	aud. type2 = aud. type3 = NONE_PAR;
	aud. data2 = aud. data3 = NULL;
	aud. len2	= aud. len3 = 0;

	(data. interface-> set) (&aud, width, height);
	abort ();
}

static void trans (void)
		/*
		 *	Transparent
		 */
{
	long* b;

	b = &ev_object [EXAMPLE]. ob_spec. userblk-> ub_parm;
	*b &= 0xfffffffbL;
	update ();
}


static void replace (void)
		/*
		 *	Deckend
		 */
{
	long* b;

	b = &ev_object [EXAMPLE]. ob_spec. userblk-> ub_parm;
	*b |= 0x4;
	update ();
}


static void rot_0 (void)
		/*
		 *	Rot 0 Grad
		 */
{
	long* b;

	b = &ev_object [EXAMPLE]. ob_spec. userblk-> ub_parm;
	*b &= 0xfffffffcL;
	update ();
}

static void rot_90 (void)
		/*
		 *	Rot 90 Grad
		 */
{
	long* b;

	b = &ev_object [EXAMPLE]. ob_spec. userblk-> ub_parm;
	*b = (*b & 0xfffffffcL) | 1;
	update ();
}

static void rot_180 (void)
		/*
		 *	Rot 180 Grad
		 */
{
	long* b;

	b = &ev_object [EXAMPLE]. ob_spec. userblk-> ub_parm;
	*b = (*b & 0xfffffffcL) | 2;
	update ();
}

static void rot_270 (void)
		/*
		 *	Rot 270 Grad
		 */
{
	long* b;

	b = &ev_object [EXAMPLE]. ob_spec. userblk-> ub_parm;
	*b = (*b & 0xfffffffcL) | 3;
	update ();
}


static void update (void)
{
	(ev_window-> obchange) (ev_window, UPDATE, -1);
}

/*
 *		This is the End my friend
 */
