#ifndef TCACHE__INCLUDED
#define TCACHE__INCLUDED
#include <tos.h>

/* Anzahl der mglichen Laufwerke */
/* Wenn nderung, dann auch bei virtuellen Laufwerken ntig */
#define MAXDRV		32

/* Anzahl der von TCache aktiv untersttzten Lw */
#define MAXAKTIV  16

/* bentigte Strukturen zur Parameterbergabe an TCache>=5.6 */

/* Parameterblock fr Funktion RBCache 815 */
typedef struct CACHEDATA
{
	int aktiv;
	int led;
	int memory;
	int hash_bits;
	int max_secs_read;
	int max_secs_write;
	int max_prefetch;
	int delay_time;
	int full;
	int percent;
	int locked; /* neu ab 6.3 */
}
CACHEDATA;

/* Unterstruktur fr RBInformation */
/* Das ist der Teil, der auch geschrieben werden kann */
typedef struct DRIVEDATA
{
	int prefetch;
	char cache_aktiv;
	char mediach;
	int write_aktiv;
	int delayed_aktiv;
	int write_protect;
	int calculate;
	int fat;
}
DRIVEDATA;

/* Parameter fr Funktion RBInformation 816 */
typedef struct INFODATA
{
	long reads;
	long read_hits;
	long writes;
	long write_hits;
	long errors;
	long odd;
	int recsize;
	DRIVEDATA data;
}
INFODATA;

/* Parameter fr RBHide 821 */
typedef struct HIDEDATA
{
	long passwort;
	int drives[MAXDRV];
}
HIDEDATA;

/* Parameter fr RBDrvA 822 */
typedef char DRVADATA[MAXDRV];

/* Parameter fr RBRam 823 */
typedef struct RBRAMDATA
{
	int ram_drv;
	int ram_ok;
	BPB ram_bpb;
	int ram_mem;
	long *ram_ptr;
	BASPAG *base_page;
	char resetfest;
	char reserved;
}
RBRAMDATA;

/* Parameter fr RBDefRamDrv 836 */
typedef struct RBRAMDEFDATA
{
	int ram_drv;
	int ram_size;
}
RBRAMDEFDATA;

/* Parameter fr RBAbortFehler 839 */
typedef struct RBFEHLERLOC
{
	int fehler_drv;
	long fehler_sec;
}
RBFEHLERLOC;

/* Parameter fr RBGetFehler 838 */
typedef struct RBFEHLERDATA
{
	int fehler_nummer;
	RBFEHLERLOC fehler_loc;
}
RBFEHLERDATA;

/* Parameter fr RBMore 841 */
typedef struct RBMOREDATA
{
	long abs_read;
	long abs_write;
	long write_error;
	long einzelsektor;
	long multisektor;
	long total;
	long saved;
	long reserved[10]; /* bis 6.2 */
}
RBMOREDATA;

/* Cookie-Funktionen von TCache */
/* Tcache installiert? */
#define TCache_There (call_tcache!=(void*)0)

/* Zeiger auf Routinen */
long cdecl (*call_tcache)(int,...);


#ifdef TEST
extern long cdecl do_deb_tcache(int,...);
#define Do_Call_tcache do_deb_tcache
#else
/* externes Modul, das die Register sichert */
extern long cdecl do_call_tcache(int,...);
#define Do_Call_tcache do_call_tcache
#endif

/* jetzt folgen alle Cookie-Funktionsnummern */
#define RBCacheN				815
#define RBInformationN	816
#define RBSaveN					817
#define RBLockN					818
#define RBFlushN 				819
#define RBClrN					820
#define RBHideN					821
#define RBDrvAN					822
#define RBRamN					823
#define RBUhrN					824
#define RBGemdosN				825
#define RBAccN					826
#define RBMemN					827
#define RBCacheHitN			828
#define RBWriteN				828
#define RBFlush_etvN		829
#define RBStepN					830
#define RBVirtuellN			831
#define RBXBRAchecN			832
#define RBDrvbitcheckN	833
#define RBPun_InfoN			834
#define RBNoxN					835
#define RBDefRamDrvN		836
#define RBStopN					837
#define RBGetFehlerN		838
#define RBAbortFehlerN	839
#define RBAbsolutN			840
#define RBMoreN					841
#define RBFlush_allN		842
#define RBSektor_testN	843
#define RBBoot_writeN		844
#define RBLRUN					845
#define RBDeldelayedN		846
#define RBTurboN				847

#define RBTestingN 		997
#define RBInstalledN	998
#define RBFmediachN		999
/* jetzt fertige Cookie-Funktionsaufrufe */
#define RBCache(flag,dataptr)\
	((int(*)(int,int,CACHEDATA*))Do_Call_tcache)(RBCacheN,flag,dataptr)

#define RBInformation(drv,flag,data)\
	((void(*)(int,int,int,INFODATA*))Do_Call_tcache)(RBInformationN,drv,flag,data);

#define RBSave(name)\
	((int(*)(int,char *))Do_Call_tcache)(RBSaveN,name)

#define RBLock(status)\
	((int(*)(int,int))Do_Call_tcache)(RBLockN,status)

#define RBFlush()\
	((void(*)(int))Do_Call_tcache)(RBFlushN)

#define RBClr()\
	((void(*)(int))Do_Call_tcache)(RBClrN)

#define RBHide(flag,data)\
	((void(*)(int,int,HIDEDATA*))Do_Call_tcache)(RBHideN,flag,data)

#define RBDrvA(flag,data)\
	((void(*)(int,int,DRVADATA))Do_Call_tcache)(RBDrvAN,flag,data)

#define RBRam(flag,data)\
	((void(*)(int,int,RBRAMDATA*))Do_Call_tcache)(RBRamN,flag,data)

#define RBUhr(status)\
	((int(*)(int,int))Do_Call_tcache)(RBUhrN,status)

#define RBGemdos(status)\
	((int(*)(int,int))Do_Call_tcache)(RBGemdosN,status)

#define RBAcc(status,name)\
	((int(*)(int,int,char*))Do_Call_tcache)(RBAccN,status,name)

#define RBMem()\
	((long(*)(int))Do_Call_tcache)(RBMemN)

#define RBCacheHit(status)\
	((int(*)(int,int))Do_Call_tcache)(RBCacheHitN,status)

#define RBWrite(status)\
	((int(*)(int,int))Do_Call_tcache)(RBWriteN,status)

#define RBFlush_etv(status)\
	((int(*)(int,int))Do_Call_tcache)(RBFlush_etvN,status)

#define RBStep(status,stellen,raten)\
	((int(*)(int,int,int,int*))Do_Call_tcache)(RBStepN,status,stellen,raten)

#define RBVirtuell(virtmap)\
	((unsigned int (*)(int,long))Do_Call_tcache)(RBVirtuellN,virtmap)

#define RBXBracheck(status)\
	((int(*)(int,int))Do_Call_tcache)(RBXBRAchecN,status)

#define RBDrvbitcheck(status)\
	((int(*)(int,int))Do_Call_tcache)(RBDrvbitcheckN,status)

#define RBInstalled()\
	((int(*)(int))Do_Call_tcache)(RBInstalledN)

#define RBFmediach(drive)\
	((void(*)(int,int))Do_Call_tcache)(RBFmediachN,drive)

#define RBPun_Info(status)\
	((int(*)(int,int))Do_Call_tcache)(RBPun_InfoN,status)

#define RBNox(status)\
	((int(*)(int,int))Do_Call_tcache)(RBNoxN,status)

#define RBDefRamDrv(flag,data)\
	((void(*)(int,int,RBRAMDEFDATA*))Do_Call_tcache)\
				(RBDefRamDrvN,flag,data)

#define RBStop(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBStopN,flag)

#define RBGetFehler(data)\
	((void(*)(int,RBFEHLERDATA*))Do_Call_tcache)\
				(RBGetFehlerN,data)

#define RBAbortFehler(data)\
	((void(*)(int,RBFEHLERLOC*))Do_Call_tcache)\
				(RBAbortFehlerN,data)

#define RBAbsolut(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBAbsolutN,flag)

#define RBMore(data)\
	((void(*)(int,RBMOREDATA*))Do_Call_tcache)(RBMoreN,data)

#define RBTesting(flag)\
	((int(*)(int))Do_Call_tcache)(RBTestingN,flag)

#define RBFlush_all(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBFlush_allN,flag)

#define RBSektor_test(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBSektor_testN,flag)

#define RBBoot_write(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBBoot_writeN,flag)

#define RBLRU(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBLRUN,flag)

#define RBDeldelayed(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBDeldelayedN,flag)

#define RBTurbo(flag)\
	((int(*)(int,int))Do_Call_tcache)(RBTurboN,flag)

#endif /* TCACHE__INCLUDED */
