
#include "proto.h"
#include <string.h>

#ifdef __MINT_LIB__
#define I_CAST	(char *)
#else

#ifdef __PUREC__
#define I_CAST	(int *)
#else
#define I_CAST	(short *)
#endif

#endif

#define ALERTFLY   1
#define ALERTICN   3
#define TEXTLINES  24
#define BUTTONS    5

static char alert_text[TEXTLINES] = {2,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26};
static char alert_btn[BUTTONS] = {27,29,31,33,35},string[] = "";

static int al_image[] = {
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FF8, 0x1FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 0x7FFC, 0x3FFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FF8, 0x1FFE, 0x7FE0, 0x07FE, 
0x7F80, 0x01FE, 0x7F00, 0x00FE, 0x7E00, 0x007E, 0x7E01, 0xC07E, 
0x7E03, 0xC07E, 0x7F07, 0x80FE, 0x7FFF, 0x01FE, 0x7FFE, 0x01FE, 
0x7FFC, 0x03FE, 0x7FF8, 0x07FE, 0x7FF8, 0x07FE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 0x7FFC, 0x3FFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FFE, 0x7FFE, 0x7FFC, 0x7FFE, 
0x7FE4, 0x4FFE, 0x7FC4, 0x47FE, 0x7FC4, 0x47FE, 0x7FC4, 0x47FE, 
0x7FC4, 0x47FE, 0x7F44, 0x47FE, 0x7E44, 0x47FE, 0x7E44, 0x47FE, 
0x7E44, 0x467E, 0x7E44, 0x447E, 0x7E44, 0x447E, 0x7E40, 0x047E, 
0x7E40, 0x047E, 0x7E40, 0x047E, 0x7E00, 0x087E, 0x7E00, 0x107E, 
0x7E00, 0x407E, 0x7E00, 0x007E, 0x7E01, 0x00FE, 0x7F00, 0x00FE, 
0x7F00, 0x01FE, 0x7F80, 0x03FE, 0x7FC0, 0x0FFE, 0x7FFF, 0xFFFE, 
0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,
0x3FFF, 0xFFFC, 0x7FFF, 0xFFFE, 0x7FFC, 0x3FFE, 0x7FF8, 0x1FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF8, 0x1FFE, 
0x7FFC, 0x3FFE, 0x7FFF, 0xFFFE, 0x7FFF, 0xFFFE, 0x7FC0, 0x1FFE, 
0x7F80, 0x0FFE, 0x7F80, 0x0FFE, 0x7FC0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 0x7FF0, 0x0FFE, 
0x7FF0, 0x0FFE, 0x7F80, 0x01FE, 0x7F00, 0x00FE, 0x7F00, 0x00FE, 
0x7F80, 0x01FE, 0x7FFF, 0xFFFE, 0x3FFF, 0xFFFC, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0xC790, 0x0000, 0xF844, 0x003D, 0xF830, 
0x01FF, 0xFCB2, 0x07FF, 0xFC00, 0x0FFF, 0xF848, 0x1F3F, 0xF800, 
0x1E67, 0xF800, 0x3FCF, 0xFC00, 0x3CFF, 0xFC00, 0x3C9F, 0xFC00, 
0x7F9F, 0xFE00, 0x7FFF, 0xFE00, 0x7FFF, 0xFE00, 0x7FFF, 0xFE00, 
0x3FFF, 0xFC00, 0x3FFF, 0xFC00, 0x3FFF, 0xFC00, 0x1FFF, 0xF800, 
0x1FFF, 0xF800, 0x0FFF, 0xF000, 0x07FF, 0xE000, 0x01FF, 0x8000, 
0x003C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FFF, 0xFDE0, 
0x1F80, 0x07F0, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 
0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1F80, 0xE7F8, 0x1FC0, 0x0FF8, 
0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 0x1FFF, 0xFFF8, 0x1C00, 0x0038, 
0x1C00, 0x0038, 0x1CF0, 0x0038, 0x1C00, 0x0038, 0x1CFF, 0x6038, 
0x1C00, 0x0038, 0x1CE4, 0x0038, 0x1C00, 0x0038, 0x1CFF, 0x9838, 
0x1C00, 0x0038, 0x14DF, 0x3038, 0x1400, 0x0038, 0x1C00, 0x0038, 
0x0FFF, 0xFFF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 
0x0000, 0xE000, 0x0001, 0xF000, 0x0003, 0xF800, 0x0005, 0xFC00, 
0x0008, 0xFE00, 0x0010, 0x7F00, 0x0020, 0x7F80, 0x0040, 0xFFC0, 
0x0087, 0xCF80, 0x010F, 0x8740, 0x010F, 0x82C0, 0x028F, 0x85C0, 
0x0347, 0x0BC0, 0x03A0, 0x17C0, 0x01D0, 0x2FC0, 0x0268, 0x5F80, 
0x0334, 0xBF00, 0x031B, 0x7E00, 0x018C, 0xFC00, 0x00CD, 0xF800, 
0x0065, 0xF000, 0x0039, 0xE000, 0x001D, 0xC000, 0x000D, 0x8000, 
0x0005, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x1FFF, 0xFFE0, 0x2C00, 0x00F0, 
0x3407, 0x80D8, 0x2C0F, 0xC0BC, 0x340C, 0xC0DC, 0x2C00, 0xC0BC, 
0x3401, 0x80DC, 0x2C03, 0x00BC, 0x3403, 0x00DC, 0x2C00, 0x00BC, 
0x3403, 0x00DC, 0x2C03, 0x00BC, 0x3400, 0x00DC, 0x2FFF, 0xFFBC, 
0x3555, 0x555C, 0x2AAA, 0xAABC, 0x35FF, 0xFD5C, 0x2B80, 0x06BC, 
0x3538, 0x035C, 0x2B38, 0x02BC, 0x3538, 0x035C, 0x2B38, 0x02BC, 
0x3538, 0x035C, 0x2B38, 0x02BC, 0x3500, 0x035C, 0x1FFF, 0xFFFC, 
0x0FFF, 0xFFFC, 0x07FF, 0xFFF8, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0001, 0x0000, 0x0003, 0x8000, 0x0007, 0xC000, 
0x0007, 0xE000, 0x000F, 0xF000, 0x000F, 0xF800, 0x002F, 0xFC00, 
0x006F, 0xFE00, 0x00DF, 0xFE00, 0x01BF, 0xFC00, 0x037F, 0xFC00, 
0x06FF, 0xF800, 0x037F, 0xFA00, 0x05BF, 0xFB00, 0x06DF, 0xF600, 
0x076F, 0xED00, 0x07B7, 0xDB00, 0x07DB, 0xB700, 0x07ED, 0x6F00, 
0x07F6, 0xDF00, 0x03FB, 0xBE00, 0x01FD, 0x7D80, 0x00FE, 0xFB80, 
0x007E, 0xFB80, 0x003E, 0xFB00, 0x001E, 0xF000, 0x000E, 0xE000, 
0x0006, 0xC000, 0x0002, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000

#ifndef SMALL_ALERT
,0x007F, 0xFC00, 0x0080, 0x0200, 0x017F, 0xFD00, 0x02FF, 0xFE80, 
0x05FF, 0xFF40, 0x0BFF, 0xFFA0, 0x17FF, 0xFFD0, 0x2FFF, 0xFFE8, 
0x5FFF, 0xFFF4, 0xBFFF, 0xFFFA, 0xBFFF, 0xFFFA, 0xB8C1, 0x8C3A, 
0xB777, 0x75DA, 0xB7F7, 0x75DA, 0xB7F7, 0x75DA, 0xB8F7, 0x743A, 
0xBF77, 0x75FA, 0xBF77, 0x75FA, 0xB777, 0x75FA, 0xB8F7, 0x8DFA, 
0xBFFF, 0xFFFA, 0xBFFF, 0xFFFA, 0x5FFF, 0xFFF4, 0x2FFF, 0xFFE8, 
0x17FF, 0xFFD0, 0x0BFF, 0xFFA0, 0x05FF, 0xFF40, 0x02FF, 0xFE80, 
0x017F, 0xFD00, 0x0080, 0x0200, 0x007F, 0xFC00, 0x0000, 0x0000,
0x0001, 0x8000, 0x0002, 0x4000, 0x0004, 0x2000, 0x0009, 0x9000, 
0x0013, 0xC800, 0x0027, 0xE400, 0x004F, 0xF200, 0x009F, 0xF900, 
0x013C, 0x3C80, 0x027C, 0x3E40, 0x04FC, 0x3F20, 0x09FC, 0x3F90, 
0x13FC, 0x3FC8, 0x27FC, 0x3FE4, 0x4FFC, 0x3FF2, 0x9FFC, 0x3FF9, 
0x9FFC, 0x3FF9, 0x4FFC, 0x3FF2, 0x27FC, 0x3FE4, 0x13FC, 0x3FC8, 
0x09FF, 0xFF90, 0x04FF, 0xFF20, 0x027C, 0x3E40, 0x013C, 0x3C80, 
0x009F, 0xF900, 0x004F, 0xF200, 0x0027, 0xE400, 0x0013, 0xC800, 
0x0009, 0x9000, 0x0004, 0x2000, 0x0002, 0x4000, 0x0001, 0x8000,
0x7FFF, 0xFFFE, 0x8000, 0x0001, 0x9FFF, 0xFFF9, 0x4FE0, 0x0FF2, 
0x4FC0, 0x07F2, 0x2787, 0xC3E4, 0x27FF, 0xE3E4, 0x13FF, 0xE3C8, 
0x13FF, 0xC7C8, 0x09FF, 0x0F90, 0x09FE, 0x1F90, 0x04FC, 0x3F20, 
0x04FC, 0x3F20, 0x027C, 0x3E40, 0x027C, 0x3E40, 0x013C, 0x3C80, 
0x013F, 0xFC80, 0x009F, 0xF900, 0x009C, 0x3900, 0x004C, 0x3200, 
0x004F, 0xF200, 0x0027, 0xE400, 0x0027, 0xE400, 0x0013, 0xC800, 
0x0013, 0xC800, 0x0009, 0x9000, 0x0009, 0x9000, 0x0004, 0x2000, 
0x0004, 0x2000, 0x0002, 0x4000, 0x0002, 0x4000, 0x0001, 0x8000,
0x007F, 0xFC00, 0x0080, 0x0200, 0x013F, 0xF900, 0x027F, 0xFC80, 
0x04FF, 0xFE40, 0x09FF, 0xFF20, 0x13FF, 0xFF90, 0x27FF, 0xFFC8, 
0x4FFF, 0xFFE4, 0x9FFF, 0xFFF2, 0x9FFF, 0xFFF2, 0x9FFF, 0xFFF2, 
0x98C1, 0x8C32, 0x9777, 0x75D2, 0x97F7, 0x75D2, 0x98F7, 0x7432, 
0x9F77, 0x75F2, 0x9777, 0x75F2, 0x98F7, 0x8DF2, 0x9FFF, 0xFFF2, 
0x9FFF, 0xFFF2, 0x9FFF, 0xFFF2, 0x4FFF, 0xFFE4, 0x27FF, 0xFFC8, 
0x13FF, 0xFF90, 0x09FF, 0xFF20, 0x04FF, 0xFE40, 0x027F, 0xFC80, 
0x013F, 0xF900, 0x0080, 0x0200, 0x007F, 0xFC00, 0x0000, 0x0000,
0x007F, 0xFE00, 0x00C0, 0x0300, 0x01BF, 0xFD80, 0x037F, 0xFEC0, 
0x06FF, 0xFF60, 0x0DFF, 0xFFB0, 0x1BFF, 0xFFD8, 0x37FF, 0xFFEC, 
0x6FFF, 0xFFF6, 0xDFFF, 0xFFFB, 0xB181, 0x860D, 0xA081, 0x0205, 
0xA4E7, 0x3265, 0xA7E7, 0x3265, 0xA3E7, 0x3265, 0xB1E7, 0x3205, 
0xB8E7, 0x320D, 0xBCE7, 0x327D, 0xA4E7, 0x327D, 0xA0E7, 0x027D, 
0xB1E7, 0x867D, 0xBFFF, 0xFFFD, 0xDFFF, 0xFFFB, 0x6FFF, 0xFFF6, 
0x37FF, 0xFFEC, 0x1BFF, 0xFFD8, 0x0DFF, 0xFFB0, 0x06FF, 0xFF60, 
0x037F, 0xFEC0, 0x01BF, 0xFD80, 0x00C0, 0x0300, 0x007F, 0xFE00,
0x0000, 0x0000, 0x0001, 0xC000, 0x0073, 0xE000, 0x00FB, 0xE700, 
0x00FB, 0xEF80, 0x1CFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 
0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 0x3EFB, 0xEF80, 
0x3EFB, 0xEF9C, 0x3EFB, 0xEFBC, 0x3EFB, 0xEFBC, 0x3FFF, 0xFF7C, 
0x3FFF, 0xFF7C, 0x3FFF, 0xFF7C, 0x3FFF, 0xFEFC, 0x3FFF, 0xF7F8, 
0x3FFF, 0xDFF8, 0x3FFF, 0x7FF0, 0x3FFF, 0xFFF0, 0x3FFD, 0xFFE0, 
0x1FFD, 0xFFC0, 0x0FFF, 0xFF80, 0x07FF, 0xFF00, 0x03FF, 0xFE00, 
0x03FF, 0xFE00, 0x03FF, 0xFE00, 0x03FF, 0xFE00, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0700, 0x0000, 0x0F80, 0x0000, 0x0F80, 
0x0000, 0x0F80, 0x0000, 0x0F80, 0x0000, 0x0F80, 0x0000, 0x0F80, 
0x0000, 0x0F80, 0x0000, 0x0F80, 0x0000, 0x0F80, 0x0079, 0xEF9C, 
0x0EFB, 0xEFBC, 0x1EFB, 0xEFBC, 0x1EFB, 0xEF7C, 0x16AA, 0xAF7C, 
0x1EFB, 0xEF7C, 0x0D75, 0xDCBC, 0x038E, 0x37F8, 0x1FFF, 0xDFF8, 
0x1FFF, 0x7FF0, 0x1FFF, 0xFFF0, 0x1FFD, 0xFFE0, 0x1FFF, 0xFFC0, 
0x0FFD, 0xFF80, 0x07FF, 0xFE00, 0x01FF, 0xF400, 0x015F, 0xFC00, 
0x01FF, 0xFC00, 0x01FF, 0xFC00, 0x0000, 0x0000, 0x0000, 0x0000,
0x0003, 0xC000, 0x0006, 0x6000, 0x000D, 0xB000, 0x001B, 0xD800, 
0x0037, 0xEC00, 0x006F, 0xF600, 0x00DC, 0x3B00, 0x01BC, 0x3D80, 
0x037C, 0x3EC0, 0x06FC, 0x3F60, 0x0DFC, 0x3FB0, 0x1BFC, 0x3FD8, 
0x37FC, 0x3FEC, 0x6FFC, 0x3FF6, 0xDFFC, 0x3FFB, 0xBFFC, 0x3FFD, 
0xBFFC, 0x3FFD, 0xDFFC, 0x3FFB, 0x6FFC, 0x3FF6, 0x37FC, 0x3FEC, 
0x1BFF, 0xFFD8, 0x0DFF, 0xFFB0, 0x06FC, 0x3F60, 0x037C, 0x3EC0, 
0x01BC, 0x3D80, 0x00DC, 0x3B00, 0x006F, 0xF600, 0x0037, 0xEC00, 
0x001B, 0xD800, 0x000D, 0xB000, 0x0006, 0x6000, 0x0003, 0xC000,
0x0000, 0x0000, 0x003F, 0xFC00, 0x00FF, 0xFF00, 0x01FF, 0xFF80, 
0x03FF, 0xFFC0, 0x03F0, 0x0FC0, 0x03E0, 0x07C0, 0x03E0, 0x07C0, 
0x01C0, 0x07C0, 0x0000, 0x0F80, 0x0000, 0x1F80, 0x0000, 0x3F00, 
0x0000, 0x7E00, 0x0000, 0xFC00, 0x0001, 0xF800, 0x0003, 0xF000, 
0x0007, 0xE000, 0x0007, 0xC000, 0x000F, 0x8000, 0x000F, 0x8000, 
0x000F, 0x8000, 0x000F, 0x8000, 0x000F, 0x8000, 0x0007, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000F, 0x8000, 
0x001F, 0xC000, 0x001F, 0xC000, 0x000F, 0x8000, 0x0000, 0x0000
#endif
};

static BITBLK alert_icn = {I_CAST &al_image[0],4,32*(X_ICN_MAX+1),0,0,1};

#ifndef SMALL_NO_XTEXT
#define ALERTTEXT	((ATTR_TEXT<<8)|G_STRING)
#else
#define ALERTTEXT	G_STRING
#endif

static OBJECT alert_tree[] = {
	{ -1, 1, 35, G_BOX, NONE, OUTLINED, CAST (0x21100L), 0,0, 52,14 },
	{ 2, -1, -1, (0x9<<8)+G_IBOX, SELECTABLE, NORMAL, CAST (0x57011100L), 50,0, 2,1 },
	{ 3, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,1, 1,1 },
	{ 4, -1, -1, G_IMAGE, NONE, NORMAL, CAST (&alert_icn), 2,1, 0,0 },
	{ 5, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,2, 1,1 },
	{ 6, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,3, 1,1 },
	{ 7, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,4, 1,1 },
	{ 8, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,5, 1,1 },
	{ 9, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,6, 1,1 },
	{ 10, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,7, 1,1 },
	{ 11, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,8, 1,1 },
	{ 12, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,9, 1,1 },
	{ 13, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,10, 2,1 },
	{ 14, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,11, 2,1 },
	{ 15, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,12, 2,1 },
	{ 16, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,13, 2,1 },
	{ 17, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,14, 2,1 },
	{ 18, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,15, 2,1 },
	{ 19, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 20, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 21, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 22, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 23, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 24, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 25, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 26, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 27, -1, -1, ALERTTEXT, NONE, NORMAL, CAST (string), 10,16, 2,1 },
	{ 29, 28, 28, G_BUTTON, 0x605, NORMAL, CAST (string), 2,12, 8,1 },
	{ 27, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 2,0, 1,1 },
	{ 31, 30, 30, G_BUTTON, 0x605, NORMAL, CAST (string), 12,12, 8,1 },
	{ 29, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 2,0, 1,1 },
	{ 33, 32, 32, G_BUTTON, 0x605, NORMAL, CAST (string), 32,12, 8,1 },
	{ 31, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 1,0, 1,1 },
	{ 35, 34, 34, G_BUTTON, 0x605, NORMAL, CAST (string), 22,12, 8,1 },
	{ 33, -1, -1, (0x5<<8)+G_IBOX, NONE, NORMAL, CAST (0x53011100L), 2,0, 1,1 },
	{ 0 , 36, 36, G_BUTTON, 0x605, NORMAL, CAST (string), 42,12, 8,1 },
	{ 35, -1, -1, (0x5<<8)+G_IBOX, LASTOB, NORMAL, CAST (0x53011100L), 1,0, 1,1 }
};

ALERT *MakeAlert(int def,int undo,int icn,BITBLK *usr_icn,int modal,int center,int width,char *title,char *txt,char *btns)
{
	static boolean fixed = 0;
	ALERT *al;
	BITBLK *image;
	char *buttons,*mem=NULL,*text,hot[BUTTONS];
#ifndef SMALL_NO_XTEXT
	X_TEXT *xtxt;
	reg int effect;
#endif
	reg OBJECT *tree,*obj;
	reg char *p,*q,*b;
	reg int i,k,m,w;
	int pos,x,y,c,user = (usr_icn!=NULL);

	if (!fixed)
	{
		rsrc_calc(alert_tree,NO_SCALING,8,16);
		alert_icn.bi_hl = 32;
		fixed++;
	}

	if (txt==NULL)
		return (NULL);

	if (btns==NULL || *btns=='\0')
		btns = "[Ok";

	i = (int) strlen(txt)+128;
	k = (int) strlen(btns)+16;

	if ((mem=malloc(i+k+sizeof(BITBLK)+sizeof(ALERT)))==NULL || (tree=ob_copy_tree(alert_tree))==NULL)
	{
		if (mem)
			free(mem);
		return (NULL);
	}

	al = (ALERT *) mem;
	al->mem = mem;
	al->tree = tree;
	al->valid = TRUE;

	image = (BITBLK *) &al[1];
	text = (char *) &image[1];
	buttons = &text[i];

	def--;undo--;

	obj = &tree[ALERTICN];
	obj->ob_x = x = gr_cw<<1;
	m = y = gr_ch;

	if (!user && icn>=0 && icn<=X_ICN_MAX)
	{
		usr_icn = &alert_icn;
		usr_icn->bi_pdata = (void *) &al_image[icn<<6];
	}

	if (usr_icn)
	{
		*image = *usr_icn;
		image->bi_color = _alert_color;
		obj->ob_spec.bitblk = image;
		obj->ob_flags &= ~HIDETREE;
		x += obj->ob_width = usr_icn->bi_x+(usr_icn->bi_wb<<3);
		obj->ob_height = usr_icn->bi_y+usr_icn->bi_hl;
		m += obj->ob_height+gr_ch;
		x += gr_cw<<1;
	}
	else
		obj->ob_flags |= HIDETREE;

	w = x;
	pos = x = (x + 7) & (~7);

	obj->ob_x += (x - w)>>1;

	if (title && modal==SYS_MODAL)
#ifndef SMALL_NO_XTEXT
		strcpy(strlcpy(strlcpy(strlcpy(text,"_ "),title),": ||"),txt);
#else
		strcpy(strlcpy(strlcpy(strlcpy(text," "),title),": ||"),txt);
#endif
	else
		strcpy(text,txt);

	for (i=w=0,q=text;i<TEXTLINES;i++)
	{
		if (q)
		{
			obj = &tree[k=alert_text[i]];
		#ifndef SMALL_NO_XTEXT
			xtxt = get_xtext(obj,0);

			for (effect=0;;)
			{
				switch (c=*q++)
				{
				case '_':
					effect |= X_UNDERLINED;continue;
				case '!':
					effect |= X_FAT;continue;
				case '@':
					effect |= X_SHADOWED;continue;
				case '~':
					effect |= X_LIGHT;continue;
				case '#':
					effect |= X_OUTLINED;continue;
				case '/':
					effect |= X_ITALICS;continue;
				case '%':
					effect |= X_3D;continue;
				case '<':
					xtxt->center = TE_LEFT;continue;
				case ':':
					xtxt->center = TE_CNTR;continue;
				case '>':
					xtxt->center = TE_RIGHT;continue;
				case '^':
					xtxt->font_id = small_font_id;
					xtxt->font_size = small_font;
					continue;
				default:
					q--;
				}
				break;
			}

			xtxt->effect = effect;
		#endif
			ob_set_text(tree,k,p=q);

			obj->ob_x = x;
			obj->ob_y = y;

			q = strchr(q,'|');
			if (q)
				*q++ = '\0';

			k = (int) strlen(p);
		#ifndef SMALL_NO_XTEXT
			if (xtxt->font_id==ibm_font_id && xtxt->font_size==ibm_font)
		#endif
			{
				k *= gr_cw;
				obj->ob_height = gr_ch;
			}
		#ifndef SMALL_NO_XTEXT
			else
			{
				k *= gr_sw;
				obj->ob_height = gr_sh+2;
			}
		#endif
			w = max(w,k);
			y += obj->ob_height;
		}
		else
			ob_set_text(tree,alert_text[i],string);
	}

	w = x+max(w,16*gr_cw)+gr_cw*2;

	if (user)
	{
		if ((y+=gr_ch)>=m)
			x = tree[ALERTICN].ob_x;
		else
			y = max(m-(gr_ch<<1),y);
	}
	else
	{
		y = max(y+=gr_ch,m);
		x = tree[ALERTICN].ob_x;
	}

	strcpy(q=buttons,btns);
	for (m=i=c=0;i<BUTTONS;i++)
	{
		if (q)
		{
			c = i;
			ob_set_text(tree,k=alert_btn[i],b=p=q);
			q = strchr(q,'|');
			if (q)
				*q++ = '\0';

			obj = &tree[k];
			obj->ob_y = y;

			obj->ob_flags &= ~HIDETREE;
			if (def==i)
				obj->ob_flags |= DEFAULT;
			else
				obj->ob_flags &= ~DEFAULT;

			if (undo==i)
				obj->ob_type = (UNDO_BTN<<8)|G_BUTTON;
			else
				obj->ob_type = G_BUTTON;

			if ((p=strchr(p,'['))!=NULL)
			{
				strcpy(p,p+1);
				hot[i] = *p;
			}
			else
				hot[i] = '\0';

			if (width)
				m = max(m,(int) strlen(b));
			else
				m += (obj->ob_width = max((int) strlen(b)+2,6)*gr_cw);
		}
		else
			ob_doflag(tree,alert_btn[i],HIDETREE);
	}

	al->buttons = c+1;

	if (c==0 && m<8)
		m = 8;

	if (width)
	{
		m = max(m+2,6)*gr_cw;
		k = x+(m+(gr_cw<<1))*(c+1);
	}
	else
		k = x+m+(gr_cw<<1)*(c+1);

	if (k<w)
	{
		if (center==BUTTONS_RIGHT)
			x += w-k;
		else if (center==BUTTONS_CENTERED)
			x += (w-k)>>1;
	}

	for (i=0;i<=c;i++)
	{
		obj = &tree[k=alert_btn[i]];
		obj->ob_x = x;
		if (width)
			obj->ob_width = m;
		x += obj->ob_width+(gr_cw<<1);
		ob_set_hotkey(tree,k,hot[i]);
	}

	tree->ob_width = w = max(x,w);
	tree->ob_height = y+tree[alert_btn[0]].ob_height+gr_ch;
	tree[ALERTFLY].ob_x = w-(gr_cw<<1)-1;

	for (i=TEXTLINES,w-=pos+gr_cw*2;--i>=0;)
		tree[alert_text[i]].ob_width = w;

	return (al);
}

int ExitAlert(ALERT *al,int exit)
{
	if (al && al->valid)
	{
		int i = al->buttons;
		for (exit=FormObject(exit);--i>=0 && exit!=alert_btn[i];);
		return (i);
	}
	else
		return (FAIL);
}

int xalert(int def,int undo,int icn,BITBLK *usr_icn,int modal,int center,int width,char *title,char *txt,char *btns)
{
	ALERT *al;
	int exit = -1;

	try_again:
	if ((al=MakeAlert(def,undo,icn,usr_icn,modal,center,width,title,txt,btns))!=NULL)
	{
		DIAINFO *info;
		int i = _nonsel_fly;

		if ((info=open_dialog(al->tree,title,NULL,NULL,DIA_MOUSEPOS,FALSE,modal==SYS_MODAL ? FLY_DIAL : WIN_DIAL|MODAL|NO_ICONIFY,0,NULL,NULL))!=NULL)
		{
			_nonsel_fly = TRUE;
			info->di_alert = al;
			if ((exit=X_Form_Do(NULL))!=W_ABANDON)
			{
				exit = ExitAlert(al,exit);
				close_dialog(info,FALSE);
			}
			_nonsel_fly = i;
		}
		else
		{
			free(al->tree);
			free(al->mem);
			if (modal!=SYS_MODAL)
			{
				modal = SYS_MODAL;
				goto try_again;
			}
		}
	}
	return (exit);
}
