/*


    EGON! MetaDOS Headerfile

    Das File enthlt DEFINES, Strukturen und Prototypen zum
    Umgang mit MetaDOS Funktionen.

    Copyright (c) EDV-Service Ch. Bontenackels
                  Beethovenstrae 5
                  52146 Wrselen

*/



/*
   Datenstrukturen, welche von den MetaDOS Funktionen
   bentigt werden.
*/

typedef struct
{
    unsigned char trackno, minute, second, frame;
} CD_TOC_ENTRY;

typedef struct
{
    unsigned char disctype;     /* 0: audio, 1: data */
    unsigned char firsttrack, lasttrack, curtrack;
    unsigned char relposz, relposm, relposs, relposf;
    unsigned char absposz, absposm, absposs, absposf;
    unsigned char endposz, endposm, endposs, endposf;
    unsigned char index, res[3];
    unsigned long reserved[123];
} CD_DISC_INFO;

typedef struct
{
    unsigned short mi_version;   /* z.B.: 0x230 == '02.30' */
    long           mi_magic;     /* '_MET' */
    const char     *mi_log2phys; /* maps DOS-IDs to MetaDOS XBIOS device numbers */
} META_INFO_2;

typedef struct
{
    unsigned long mi_drivemap;        /* Bitvektor Meta-DOS-Gertetreiber "A.."Z" (Bit 0: "A") */
    const char    *mi_version_string; /* Zeichenkette mit Namen und Versionsnummer von Meta-DOS */
    long          reserved;
    META_INFO_2   *mi_info;
} META_INFO_1;

typedef struct
{
    char    *mdr_name;
    long    res[3];
} META_DRVINFO;

typedef union
{
    struct {
        unsigned char reserved, minute, second, frame;
   } msf;
    long lba;
} cd_ad;

/*
   Von Metaioctl benutzte Datenstrukturen.
*/

struct cdrom_msf
{
    unsigned char cdmsf_min0;     /* start minute */
    unsigned char cdmsf_sec0;     /* start second */
    unsigned char cdmsf_frame0;   /* start frame */
    unsigned char cdmsf_min1;     /* end minute */
    unsigned char cdmsf_sec1;     /* end second */
    unsigned char cdmsf_frame1;   /* end frame */
};

struct cdrom_ti
{
    unsigned char cdti_trk0;      /* start track */
    unsigned char cdti_ind0;      /* start index */
    unsigned char cdti_trk1;      /* end track */
    unsigned char cdti_ind1;      /* end index */
};

struct cdrom_tochdr
{
    unsigned char cdth_trk0;      /* start track */
    unsigned char cdth_trk1;      /* end track */
};

struct cdrom_tocentry
{
    /* Eingabewerte */

    unsigned char cdte_track;     /* Tracknummer oder CDROM_LEADOUT */
    unsigned char cdte_format;    /* CDROM_LBA oder CDROM_MSF */

    /* Rckgabewerte */

    unsigned cdte_adr:4;     /* the SUBQ channel encodes 0: nothing,
                                 1: position data, 2: MCN, 3: ISRC,
                                 else: reserved */
    unsigned cdte_ctrl:4;    /* bit 0: audio with pre-emphasis,
                                 bit 1: digital copy permitted,
                                 bit 2: data track,
                                 bit 3: four channel */
    unsigned char cdte_datamode;        /* nicht benutzt */
     cd_ad    cdte_addr;          /* Anfang des Tracks */
};

struct cdrom_subchnl
{
    /* Eingabewerte */

    unsigned char cdsc_format;  /* CDROM_MSF oder CDROM_LBA */

    /* Rckgabewerte */

    unsigned char cdsc_audiostatus; /* see below */
    unsigned      cdsc_resvd: 8;    /* reserved */
    unsigned      cdsc_adr:   4;    /* see above */
    unsigned      cdsc_ctrl:  4;    /* see above */
    unsigned char cdsc_trk;         /* current track */
    unsigned char cdsc_ind;         /* current index */
    cd_ad         cdsc_absaddr;     /* absolute address */
    cd_ad         cdsc_reladdr;     /* track relative address */
};

struct cdrom_mcn
{
    unsigned char mcn_audiostatus;  /* see above */
    unsigned char mcn_mcn[23];      /* Media catalog number as ASCII string */
};

struct cdrom_tisrc
{
    /* Eingabewerte */

    unsigned char tisrc_track;      /* track number */

    /* Rckgabewerte */

    unsigned char tisrc_audiostatus;/* see above */
    unsigned char tisrc_tisrc[23];  /* Track International Standard Recording Code (ASCII) */
};

struct cdrom_volctrl
{
    unsigned char channel0;         /* volume level 0..255 */
    unsigned char channel1;
    unsigned char channel2;
    unsigned char channel3;
};

struct cdrom_audioctrl
{
    /* Eingabewerte */

    int set;    /* 0 == inquire only */

    /* Ein/Rckgabewerte */

    struct {
        unsigned char selection;
        unsigned char volume;
    } channel[4];
};

struct cdrom_read
{
    long cdread_lba;        /* logical block address */
    char *cdread_bufaddr;   /* buffer pointer */
    long cdread_buflen;     /* byte count */
};



/*
   Konstanten von MetaDOS
*/


/*
   Magic fr Metaioctl Funktion
*/

#define IOCTL_MAGIC  0x4643544cL    /* "FCTL" */


/* CD-ROM address types */

#define CDROM_LBA   0x01
#define CDROM_MSF   0x02

/* SUB Q control bits */

#define CDROM_AUDIO_EMPHASIS    0x01
#define CDROM_COPY_PERMITTED    0x02
#define CDROM_DATA_TRACK        0x04
#define CDROM_FOUR_CHANNEL      0x08

/* The leadout track is always 0xAA, regardless of # of tracks on disc */

#define CDROM_LEADOUT   0xAA

/* return value from READ SUBCHANNEL DATA */

#define CDROM_AUDIO_INVALID     0x00    /* audio status not supported */
#define CDROM_AUDIO_PLAY        0x11    /* audio play operation in progress */
#define CDROM_AUDIO_PAUSED      0x12    /* audio play operation paused */
#define CDROM_AUDIO_COMPLETED   0x13    /* audio play successfully completed */
#define CDROM_AUDIO_ERROR       0x14    /* audio play stopped due to error */
#define CDROM_AUDIO_NO_STATUS   0x15    /* no current audio status to return */

/* CD-ROM Fcntl opcodes */

/* Get block number of first sector in last session of a multisession
   CD. Argument points to a LONG. Used by iso9660f.dos */
#define CDROMREADOFFSET     (('C'<<8)|0x00)

/* Pause audio operation */
#define CDROMPAUSE          (('C'<<8)|0x01)

/* Resume audio operation */
#define CDROMRESUME         (('C'<<8)|0x02)

/* Play audio. Argument points to cdrom_msf structure */
#define CDROMPLAYMSF        (('C'<<8)|0x03)

/* Play audio. Argument points to cdrom_ti structure */
#define CDROMPLAYTRKIND     (('C'<<8)|0x04)

/* Read header of table of contents. Argument points to cdrom_tochdr
   structure */
#define CDROMREADTOCHDR     (('C'<<8)|0x05)

/* Read a toc entry. Argument points to cdrom_tocentry structure */
#define CDROMREADTOCENTRY   (('C'<<8)|0x06)

/* Stops spindle motor */
#define CDROMSTOP           (('C'<<8)|0x07)

/* Starts spindle motor */
#define CDROMSTART          (('C'<<8)|0x08)

/* Eject medium */
#define CDROMEJECT          (('C'<<8)|0x09)

/* Sets audio playback volume. Argument points to cdrom_volctrl
   structure. Only for compatibility to Unix drivers, see also
   CDROMAUDIOCTRL */
#define CDROMVOLCTRL        (('C'<<8)|0x0a)

/* Read subchannel information. Argument points to cdrom_subchnl
   structure. */
#define CDROMSUBCHNL        (('C'<<8)|0x0b)

/* Read Mode 2 or 1 sectors. Argument points to cdrom_read
   structure. Blocks have either 2336 or 2048 bytes. */
#define CDROMREADMODE2      (('C'<<8)|0x0c)
#define CDROMREADMODE1      (('C'<<8)|0x0d)

/* Lock eject mechanism */
#define CDROMPREVENTREMOVAL (('C'<<8)|0x0e)

/* Unlock eject mechanism */
#define CDROMALLOWREMOVAL   (('C'<<8)|0x0f)

/* Control audio settings. Argument points to cdrom_audioctrl
   structure */
#define CDROMAUDIOCTRL      (('C'<<8)|0x10)

/* Read Digital Audio (red book) sectors. Argument points to
   cdrom_read structure. Blocks have 2352 bytes. */
#define CDROMREADDA         (('C'<<8)|0x11)

/* Read media catalog number. Argument points to cdrom_mcn
   structure */
#define CDROMGETMCN         (('C'<<8)|0x13)

/* Read track international standard recording code. Argument points
   to cdrom_tisrc structure */
#define CDROMGETTISRC       (('C'<<8)|0x14)



/*
    Prototypen fr die MetaDOS Funktionen
*/

long Metainit (META_INFO_1 *buffer);
long Metaopen (int drive, META_DRVINFO *buffer);
long Metaclose (int drive);
long Metaread (int drive, void *buffer, long blockno, int count);
long Metawrite (int drive, void *buffer, long blockno, int count);
long Metaseek (int drive, long blockno);
long Metastatus (int drive, void *buffer);
long Metaioctl (int drive, long magic, int opcode, void *buffer);
long Metasetsongtime (int drive, int repeat, long start, long end);
long Metagettoc (int drive, int flag, CD_TOC_ENTRY *buffer);
long Metadiscinfo (int drive, CD_DISC_INFO *buffer);
long Metastartaudio (int drive, int flag, unsigned char *buffer);
long Metastopaudio (int drive);

/*
    Liefert zu einer Drivemap die entsprechende MetaDOS-ID
*/

int Metagetdriveno (long drivemap);


