#include <stdio.h>
#include <portab.h>
#include <tos.h>
#include "metados.h"

/*
  Variablen und Strukturen
*/

struct cdrom_msf       msf;
struct cdrom_ti        ti;
struct cdrom_tochdr    tochdr;
struct cdrom_tocentry  tocentry;
struct cdrom_subchnl   subchnl;
struct cdrom_mcn       mcn;
struct cdrom_tisrc     tisrc;
struct cdrom_volctrl   volctrl;
struct cdrom_audioctrl audioctrl;
struct cdrom_read      cd_read;

META_INFO_1 info;
META_DRVINFO buf;
CD_TOC_ENTRY toc[100];
CD_TOC_ENTRY toc1[100];
CD_DISC_INFO discinf;

unsigned char play[2];
long     start,stop,offset,dummy;
long     test[4];
int 	 drive,i,song;

union
{
	unsigned char c[4];
	long          l;
} foo;

/* 
   Prototypen
*/

void wait_4_key(void);

void wait_4_key(void)
{
	printf("*** Bitte RETURN drcken ***");
	Bconin(2);
	printf("\033M");
}

int main(void)
{
	
	/* zuerst einige allgemeine Daten ber das installierte MetaDOS */

	Metainit (&info);
	printf("\033EMetados Version:  %s\n", info.mi_version_string);
	printf("Versionsnummer:   %x\n", info.mi_info->mi_version);
	printf("MetaDOS Magic:    %lx\n", info.mi_info->mi_magic);
	drive = Metagetdriveno(info.mi_drivemap);
	printf("Metados Laufwerk: %c\n", drive);
	Metaopen (drive, &buf);
	printf("BOS Treiber:      %s\n", buf.mdr_name);
	printf("DOS-ID:           A B C D E F G H I J K L M N O P Q R S T U V W X\n");
	printf("MetaDOS-ID:       ");
	for (i=0; i<24; i++)
	{
		if (info.mi_info->mi_log2phys[i]!=0)
			printf("%c ",info.mi_info->mi_log2phys[i]);
		else
			printf("  ");
	}
	printf("\n");

	wait_4_key();

	/* Trackoffset einer Multi Session CD */  

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMREADOFFSET,&offset) == 0)
		printf("CDROMREADOFFSET: %lx\n",offset);
	else
		printf("*** Fehler bei CDROMREADOFFSET\n");

	wait_4_key();

	/* CD Rom anhalten */

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMSTOP,&dummy) == 0)
		printf("CD angehalten\n");
	else
		printf("*** Fehler bei CDROMSTOP\n");
		
	wait_4_key();

	/* CD Rom starten */

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMSTART,&dummy) == 0)
		printf("CD gestartet\n");
	else
		printf("*** Fehler bei CDROMSTAR\n");
		
	wait_4_key();

	/* CD auswerfen */

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMEJECT,&dummy) == 0)
		printf("CD ausgeworfen\n");
	else
		printf("*** Fehler bei CDROMEJECT\n");
		
	wait_4_key();

	/* CD Rom verriegeln */

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMPREVENTREMOVAL,&dummy) == 0)
		printf("CD verriegelt\n");
	else
		printf("*** Fehler bei CDROMPREVENTREMOVAL\n");
		
	wait_4_key();

	/* CD Rom entriegeln */

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMALLOWREMOVAL,&dummy) == 0)
		printf("CD entriegelt\n");
	else
		printf("*** Fehler bei CDROMALLOWREMOVAL\n");
		
	wait_4_key();
	
	/* Musikstck fr 15 Sekunden anspielen */

	msf.cdmsf_min0=0;
	msf.cdmsf_sec0=5;
	msf.cdmsf_frame0=0;		/* von 00:05:00 */
	msf.cdmsf_min1=0;
	msf.cdmsf_sec1=20;
	msf.cdmsf_frame1=74;	/* bis 00:20:74 */
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMPLAYMSF,&msf) == 0)
		printf("Spiele CD von %d:%d:%d bis %d:%d:%d\n",
			msf.cdmsf_min0,msf.cdmsf_sec0,msf.cdmsf_frame0,
			msf.cdmsf_min1,msf.cdmsf_sec1,msf.cdmsf_frame1);
	else
		printf("*** Fehler bei CDROMPLAYMSF\n");
		
	wait_4_key();	

	/* Track #2 spielen */
	
	ti.cdti_trk0=2;
	ti.cdti_ind0=1;		/* von Track 02, Index 01 */
	ti.cdti_trk1=2;
	ti.cdti_ind1=99;	/* bis Track 02, Index 99 */
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMPLAYTRKIND,&ti) == 0)
		printf("Spiele CD von %d, %d bis %d, %d\n",
			ti.cdti_trk0,ti.cdti_ind0,
			ti.cdti_trk1,ti.cdti_ind1);
	else
		printf("*** Fehler bei CDROMPLAYTRKIND\n");
		
	wait_4_key();	

	/* Lese TOC-Header */
	
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMREADTOCHDR,&tochdr) == 0)
		printf("Starttrack: %d   Endtrack: %d\n",
			tochdr.cdth_trk0,tochdr.cdth_trk1);
	else
		printf("*** Fehler bei CDROMREADTOCHDR\n");
	
	wait_4_key();

	/* Lese TOC-Entry von Track 7 */
	
	tocentry.cdte_track=7;
	tocentry.cdte_format=CDROM_LBA;
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMREADTOCENTRY,&tocentry) == 0)
		printf("Adr: %hx   Ctrl: %hx   Anfang: %lx\n",
			tocentry.cdte_adr,tocentry.cdte_ctrl,
			tocentry.cdte_addr.lba);
	else
		printf("*** Fehler bei CDROMREADTOCENTRY\n");
	
	wait_4_key();

	/* Lese CD Rom Subchannel */
	
	subchnl.cdsc_format=CDROM_LBA;
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMSUBCHNL,&subchnl) == 0)
	{
		printf("Audiostatus: %hx   Adr: %hx   Ctrl: %hx   ",
			subchnl.cdsc_audiostatus,subchnl.cdsc_adr,subchnl.cdsc_ctrl);
		printf("Track: %d   Index: %d   Abs.Adr: %lx   Rel.Adr: %lx\n",
			subchnl.cdsc_trk,subchnl.cdsc_ind,
			subchnl.cdsc_absaddr.lba,
			subchnl.cdsc_reladdr.lba);
	}
	else
		printf("*** Fehler bei CDROMSUBCHNL\n");
	
	wait_4_key();

	/* Lese Media Katalog Nummer */

	if (Metaioctl(drive,IOCTL_MAGIC,CDROMGETMCN,&mcn) == 0)
		printf("Audiostatus: %hx   Media Katalog Nummer: %s\n",
			mcn.mcn_audiostatus,mcn.mcn_mcn);
	else
		printf("*** Fehler bei CDROMGETMCN\n");
	
	wait_4_key();

	/* Lese International Standard Recording Code von Track 7 */

	tisrc.tisrc_track=7;
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMGETTISRC,&tisrc) == 0)
		printf("Audiostatus: %hx   ISRC: %s\n",
			tisrc.tisrc_audiostatus,tisrc.tisrc_tisrc);
	else
		printf("*** Fehler bei CDROMGETTISRC\n");
	
	wait_4_key();

	/* Setze Lautstrkewerte auf 150 */

	volctrl.channel0=150;
	volctrl.channel1=150;
	volctrl.channel2=150;
	volctrl.channel3=150;
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMVOLCTRL,&volctrl) == 0)
		printf("CDROMVOLCTRL OK\n");
	else
		printf("*** Fehler bei CDROMVOLCTRL\n");
	
	wait_4_key();

	/* Lese Lautstrkewerte aus */
	
	audioctrl.set=0;
	if (Metaioctl(drive,IOCTL_MAGIC,CDROMAUDIOCTRL,&audioctrl) == 0)
	{
		printf("Port 0 Control: %hd\n",audioctrl.channel[0].selection);
		printf("Port 0 Volume:  %hd\n",audioctrl.channel[0].volume);
		printf("Port 1 Control: %hd\n",audioctrl.channel[1].selection);
		printf("Port 1 Volume:  %hd\n",audioctrl.channel[1].volume);
		printf("Port 2 Control: %hd\n",audioctrl.channel[2].selection);
		printf("Port 2 Volume:  %hd\n",audioctrl.channel[2].volume);
		printf("Port 3 Control: %hd\n",audioctrl.channel[3].selection);
		printf("Port 3 Volume:  %hd\n",audioctrl.channel[3].volume);
	}
	else
		printf("*** Fehler bei CDROMAUDIOCTRL\n");
	
	wait_4_key();

/*
   Das waren die IOCTL-Funktionen, jetzt kommt MetaDOS
*/

	/* zuerst lesen wir die komplette TOC im MetaDOS-Format */
	 
	while (Metagettoc (drive, 0, toc) != 0l);
	while (Metagettoc (drive, 0, toc1) != 0l);

	/* ... und geben sie auf dem Bildschirm aus */
	
	i = 0;
	while (toc[i].trackno != 0xa2)
	{
		printf("Track %2hd: %02hx:%02hx:%02hx  (%lx)\n", 
			toc[i].trackno, toc[i].minute, toc[i].second, 
			toc[i].frame, toc1[i]);
		i++;
	}

	wait_4_key();
	
	/* Nun eine Beschreibung der eingelegten CD im MetaDOS-Format */
	
	if (Metadiscinfo(drive, &discinf) == 0)
	{
		printf("Art der CD:  %02x\n", discinf.disctype);
		printf("First Track: %02d\n", discinf.firsttrack);
		printf("Last Track:  %02d\n", discinf.lasttrack);
		printf("Akt. Track:  %02d\n", discinf.curtrack);
		printf("Rel. Adress: %02x:%02x:%02x\n",
			discinf.relposm, discinf.relposs, discinf.relposf);
		printf("Abs. Adress: %02x:%02x:%02x\n",
			discinf.absposm, discinf.absposs, discinf.absposf);
		printf("End of CD:   %02x:%02x:%02x\n",
			discinf.endposm, discinf.endposs, discinf.endposf);
		printf("Index No.:   %02d\n", discinf.index);
	}
	else
		printf("*** Fehler bei Metadiscinfo\n");
		
	/* Jetzt starten wir einen Track mittels Metasetsongtime */
	
	printf("Welches Lied ?");
	scanf("%d",&song);
	foo.c[0]=0;
	foo.c[1]=toc[song-1].minute; 
	foo.c[2]=toc[song-1].second; 
	foo.c[3]=toc[song-1].frame;
	start=foo.l; 
	foo.c[1]=toc[song].minute; 
	foo.c[2]=toc[song].second; 
	foo.c[3]=toc[song].frame;
	stop=foo.l; 
	if (Metasetsongtime (drive, 0, start, stop) == 0)
		printf("Titel %d luft (Metasetsongtime)\n", song);
	else
		printf("*** Fehler bei Metasetsongtime\n");
	
	wait_4_key();
	
	/* Audioplay wird abgebrochen */
	
	if (Metastopaudio(drive) !=0)
		printf("*** Fehler bei Metastopaudio\n");

	/*	... und jetzt einen Track mit Metastartaudio abspielen */
	
	printf("Welches Lied ?");
	scanf("%d",&song);
	play[0] = 1;
	play[1] = song;
	if (Metastartaudio (drive, 0, play) == 0)
		printf("Titel %d luft (Metastartaudio)\n", song);
	else
		printf("*** Fehler bei Metastartaudio\n");
		
	wait_4_key();

	/* Audioplay wird abgebrochen */
	
	if (Metastopaudio(drive)!=0)
		printf("*** Fehler bei Metastopaudio\n");

	/* T H E   E N D ! */
	
	printf("Ende der Vorfhrung !\n");
	
	wait_4_key();
	
	return (0);
}     	