#define	WIDTH	304
#define	HEIGHT	75

static unsigned short pFalconMask[385] = {
  0x7D0A, 0xB13A, 0x3407, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0x8901,
  0xF509, 0x0E14, 0x4306, 0xC501, 0x0C01, 0x1404, 0x4501, 0xC501,
  0x2402, 0x4401, 0xEB01, 0xFF00, 0x3101, 0xFF00, 0x3101, 0xFF00,
  0x3101, 0xFF00, 0x3701, 0xFF00, 0x2A01, 0xFF00, 0xFF00, 0xFF00,
  0x9301, 0xFF00, 0xFF00, 0xFF00, 0x9801, 0xFF00, 0xFF00, 0x5C01,
  0xFF00, 0x2005, 0xFF00, 0xFF00, 0xFF00, 0x9F05, 0x0C0B, 0x480B,
  0x230B, 0xA103, 0x0B03, 0x4203, 0x0B04, 0x1C03, 0x0B03, 0x1C09,
  0x090A, 0x6402, 0x1102, 0x3E02, 0x1202, 0x1802, 0x1102, 0x1307,
  0x0F03, 0x0A03, 0x5F02, 0x1502, 0x3A02, 0x1601, 0x1502, 0x1502,
  0x2601, 0x1002, 0x4101, 0x1A01, 0x0A05, 0x0A01, 0x3702, 0x0A06,
  0x0902, 0x1102, 0x0A05, 0x0A02, 0x2202, 0x1301, 0x5A01, 0x0803,
  0x0502, 0x0901, 0x3501, 0x0A02, 0x0603, 0x0801, 0x0F01, 0x0A02,
  0x0502, 0x0A01, 0x2001, 0x0804, 0x0A01, 0x3E01, 0x2102, 0x0A01,
  0x0901, 0x3301, 0x0A01, 0x0B02, 0x1501, 0x0902, 0x0902, 0x0901,
  0x1E01, 0x0702, 0x0401, 0x4701, 0x1A01, 0x0702, 0x0B01, 0x0901,
  0x3101, 0x0A01, 0x0C02, 0x0701, 0x0C01, 0x0901, 0x0D01, 0x0901,
  0x0C06, 0x0A01, 0x0602, 0x0701, 0x0901, 0x3A02, 0x2501, 0x1501,
  0x2F01, 0x0A01, 0x0C01, 0x1501, 0x0901, 0x0F01, 0x0901, 0x1101,
  0x0F01, 0x0A01, 0x370C, 0x3301, 0x3801, 0x0A01, 0x2C01, 0x1101,
  0x1B01, 0x0D01, 0x1501, 0x6D01, 0x4101, 0x2301, 0x2501, 0x1E01,
  0x8E01, 0x2C01, 0x2D01, 0x0901, 0x1301, 0x0901, 0x2B01, 0xB701,
  0x6801, 0x8601, 0x3401, 0x2D01, 0x0901, 0x1501, 0x0901, 0x610C,
  0xDD01, 0x5202, 0x1B01, 0x0901, 0x4101, 0x0A01, 0x1001, 0x0901,
  0xA201, 0x1B02, 0x0502, 0x5F02, 0x0502, 0x0801, 0x2B01, 0x6F01,
  0x1C05, 0x6305, 0x1401, 0x1701, 0x2201, 0xFF00, 0x8801, 0x2B06,
  0x3201, 0x0A01, 0x2201, 0x2D01, 0x9506, 0xFF00, 0x2803, 0xFF00,
  0x2B03, 0xFF00, 0x2C02, 0x1002, 0xFF00, 0x1B02, 0x0D05, 0xFF00,
  0x1C01, 0x0C03, 0xFF00, 0x0705, 0x1302, 0x0B02, 0xFF00, 0x2101,
  0x0C01, 0xFF00, 0x2F01, 0xFF00, 0x2301, 0x0B01, 0xFF00, 0x2301,
  0x0B01, 0x4C01, 0xE101, 0x1E05, 0x1F01, 0x2D01, 0x2D01, 0xFF00,
  0x0D01, 0x1701, 0x8F01, 0x0A01, 0x6705, 0xFF00, 0x1401, 0x2201,
  0x2B01, 0x8F01, 0x4501, 0x2101, 0xD901, 0x6C01, 0x1501, 0xE101,
  0x0A01, 0x2201, 0x2901, 0xA101, 0x5501, 0x0501, 0x0801, 0x0901,
  0x1301, 0x0901, 0x9101, 0x4701, 0x0A01, 0x1201, 0xD901, 0x3801,
  0x0A01, 0x1701, 0x0A01, 0x0901, 0x1101, 0x0901, 0x5701, 0x0B01,
  0x2F01, 0x0D01, 0x0C01, 0x0301, 0x2901, 0x0A01, 0x0F01, 0x1201,
  0x0901, 0x0F01, 0x0901, 0x5701, 0x0D02, 0x2201, 0x0B01, 0x0B01,
  0x2002, 0x0902, 0x0F01, 0x0A01, 0x0C02, 0x0601, 0x0D01, 0x0901,
  0x0D01, 0x0901, 0x1202, 0x0902, 0x0E02, 0x0902, 0x1509, 0x100A,
  0x1901, 0x0B01, 0x0901, 0x0601, 0x0801, 0x0101, 0x0501, 0x0306,
  0x0D06, 0x0A01, 0x0A01, 0x0A01, 0x0701, 0x0F01, 0x0902, 0x0902,
  0x0901, 0x0D06, 0x0D06, 0x0206, 0x0D06, 0x4C01, 0x0B02, 0x0502,
  0x0601, 0x0A01, 0x2E01, 0x0A02, 0x0503, 0x0701, 0x1101, 0x0A02,
  0x0502, 0x0A01, 0x8F01, 0x0C05, 0x0701, 0x0201, 0x0E01, 0x2902,
  0x0A05, 0x0901, 0x1302, 0x0A05, 0x0A02, 0x9102, 0x1501, 0x1101,
  0x2C01, 0x1601, 0x1601, 0x1701, 0x9502, 0x1102, 0x0502, 0x0A01,
  0x2E03, 0x1102, 0x1802, 0x1302, 0x5523, 0x2003, 0x0C02, 0x0901,
  0x0801, 0x0719, 0x1203, 0x0B03, 0x1C04, 0x0B04, 0x1419, 0x0219,
  0x0700 };

static unsigned short pFalconData[400] = {
  0xFF00, 0xAF08, 0xB338, 0x3607, 0xFF00, 0xFF00, 0xFF00, 0x1E09,
  0x0C16, 0x4306, 0xC501, 0x0A01, 0x1604, 0x0901, 0x3B01, 0xC501,
  0x2402, 0x4401, 0xEB01, 0xFF00, 0x3101, 0xFF00, 0x3101, 0xFF00,
  0x3101, 0xFF00, 0xFF00, 0x6201, 0xFF00, 0x3401, 0xFF00, 0xFF00,
  0x5E01, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xF501, 0x0201,
  0xFF00, 0xFF00, 0xFF00, 0x7F03, 0xFF00, 0x3F03, 0xFF00, 0xFF00,
  0x7009, 0x4A09, 0x2509, 0xA303, 0x0903, 0x4403, 0x0904, 0x1E03,
  0x0903, 0x1E07, 0x0B08, 0x6602, 0x0407, 0x0402, 0x4002, 0x0408,
  0x0402, 0x1A02, 0x0407, 0x0402, 0x1507, 0x0F03, 0x0803, 0x6102,
  0x0303, 0x0702, 0x0402, 0x3C02, 0x0402, 0x0803, 0x0301, 0x1702,
  0x0402, 0x0702, 0x0402, 0x2801, 0x0306, 0x0502, 0x4301, 0x1A01,
  0x0302, 0x0C01, 0x0501, 0x3902, 0x0501, 0x0D02, 0x0202, 0x1302,
  0x0402, 0x0B02, 0x0402, 0x2402, 0x0202, 0x0601, 0x0601, 0x5C01,
  0x0301, 0x0F01, 0x0501, 0x3701, 0x0601, 0x1001, 0x0301, 0x1101,
  0x0501, 0x0F01, 0x0501, 0x1006, 0x0C01, 0x0202, 0x0901, 0x0601,
  0x4001, 0x1E01, 0x1601, 0x3501, 0x0601, 0x1101, 0x1401, 0x0501,
  0x1101, 0x0501, 0x1501, 0x0A01, 0x0201, 0x0C01, 0x4501, 0x1A01,
  0x0502, 0x0E01, 0x0601, 0x3301, 0x0601, 0x1002, 0x0501, 0x0E01,
  0x0501, 0x1301, 0x0501, 0x1501, 0x0801, 0x0201, 0x1401, 0x3C02,
  0x2301, 0x0E01, 0x0601, 0x3101, 0x0601, 0x1001, 0x1501, 0x2101,
  0x1F01, 0x440E, 0x6C01, 0x3401, 0x1501, 0x2201, 0x1201, 0x0601,
  0xAE01, 0x2601, 0x2301, 0x1D01, 0x8801, 0x0601, 0x2E01, 0x2D01,
  0x0601, 0x1701, 0x0601, 0x1901, 0x480E, 0xDB01, 0x5402, 0x1B01,
  0x0701, 0x4401, 0x0701, 0x1201, 0x0701, 0x0A01, 0x2701, 0x7101,
  0x1B02, 0x0302, 0x6102, 0x0302, 0xA601, 0x1C03, 0x4601, 0x1E03,
  0x1401, 0x1901, 0x2001, 0xEC01, 0x2901, 0x7201, 0x6C01, 0xFF00,
  0xFF00, 0x2006, 0x3201, 0x2D01, 0x2B01, 0x9706, 0xFF00, 0x2803,
  0x0804, 0xFF00, 0x1F03, 0x0605, 0xFF00, 0x2102, 0x0603, 0xFF00,
  0x0903, 0x1802, 0x0602, 0xFF00, 0x2601, 0x0701, 0xFF00, 0x2602,
  0x0701, 0xFF00, 0x2601, 0x0801, 0xFF00, 0x2F01, 0xFF00, 0x2701,
  0x0701, 0x4401, 0x2D01, 0x2B01, 0x8701, 0x5601, 0xE001, 0x2103,
  0xFF00, 0x8101, 0x0701, 0x1901, 0x0701, 0x8701, 0x0701, 0x4701,
  0x2203, 0xFF00, 0x1401, 0xFF00, 0x2801, 0x2001, 0x0C01, 0x2701,
  0xA401, 0x5801, 0x0A01, 0x0601, 0x1701, 0x0601, 0xDB01, 0x0701,
  0xF001, 0x3701, 0x1D01, 0x0201, 0x0C01, 0x0601, 0x1501, 0x0601,
  0x9201, 0x1401, 0x3601, 0x0601, 0x1401, 0x1101, 0x2101, 0x8B01,
  0x1901, 0x3A01, 0x0601, 0x1601, 0x0F01, 0x0501, 0x1301, 0x0501,
  0x5B01, 0x0901, 0x2701, 0x0701, 0x0F01, 0x0201, 0x0101, 0x0501,
  0x0501, 0x0201, 0x2801, 0x0601, 0x1101, 0x0201, 0x1101, 0x0501,
  0x1101, 0x0501, 0x5B01, 0x0B02, 0x2601, 0x0701, 0x0D01, 0x0201,
  0x1D02, 0x0702, 0x1301, 0x0601, 0x0E02, 0x0201, 0x1301, 0x0501,
  0x0F01, 0x0501, 0x1602, 0x0702, 0x1002, 0x0702, 0x1709, 0x0E0A,
  0x1D01, 0x0701, 0x0B01, 0x0201, 0x0401, 0x0501, 0x0301, 0x0201,
  0x0606, 0x0B06, 0x0E02, 0x0501, 0x0C01, 0x0301, 0x1502, 0x0402,
  0x0B02, 0x0402, 0x1106, 0x0B06, 0x0406, 0x0B06, 0x5002, 0x0602,
  0x0702, 0x0201, 0x0C03, 0x0201, 0x2E01, 0x0502, 0x0703, 0x0301,
  0x1801, 0x0502, 0x0702, 0x0501, 0x9702, 0x0607, 0x0202, 0x0702,
  0x0801, 0x3003, 0x0407, 0x0402, 0x1A02, 0x0507, 0x0502, 0x5721,
  0x2203, 0x0A02, 0x0B01, 0x0601, 0x0917, 0x1403, 0x0903, 0x1E04,
  0x0904, 0x1617, 0x0417, 0x570A, 0x0E06, 0x3809, 0x2509, 0x5400 };


static long oldpalette[16],thesize,*thescr;

static void _show(unsigned char *ptr,int c,unsigned short *line,
                  int width,int planes)
{
	unsigned short	buffer[WIDTH/16];
	unsigned short	*word;
	int				runlength,mode;
	int				i,j,k,bit;
	unsigned short	data = 0;
	
	if ((runlength = *ptr) == 0) {runlength = *++ptr; mode = 1;}
	else mode = 0;
	for (k = WIDTH/16; k--; buffer[k] = 0);
	for (i = HEIGHT; i--; line += width/16*planes) {
		for (j = WIDTH/16, word = line; j--;) {
			for (k = 16; k--;) {
				data = (data << 1) | mode;
				if (!--runlength) {
					runlength = *++ptr;
					if (!runlength) runlength = *++ptr;
					else mode = 1-mode; } }
			buffer[j] = data ^= buffer[j];
			for (k = planes, bit = c?c:i*14/HEIGHT+2; k--; bit >>= 1) {
				if (bit & 1)
					*word++ |= data;
				else
					*word++ &=~data; } } }
}

void showlogo(int x,int y,unsigned short *scr,
              int width,int height,int planes)
{
	extern void		VsetRGB(int,int,long *);
	extern void		VgetRGB(int,int,long *);
	static long		mypalette[16] =
			{0x000040L,0x4B4B4BL,0xE11D15L,0xE16F15L,
			 0xE1C815L,0xA8E115L,0x56E115L,0x15E136L,
			 0x15E18FL,0x15E1E1L,0x158FE1L,0x1536E1L,
			 0x5615E1L,0xA815E1L,0xE115C8L,0xE1156FL};
	static int		lookup[9] = {1,1,2,2,0,0,0,0,0};
	unsigned short	*line;
	long			count,*ptr;

	VgetRGB(0,16,oldpalette);
	VsetRGB(0,16,mypalette);
	for (ptr = thescr = (long *)scr,
	     count = thesize = (long)width*height/32*planes; count--;
		 *ptr++ = 0L);
	x = (x+15)&~15;
	line = scr+((long)y*width+x)/16*planes;
	_show((unsigned char *)pFalconMask,1,line,width,planes);
	_show((unsigned char *)pFalconData,lookup[planes],line,width,planes);
	return;
}

void hidelogo(void)
{
	long			count,*ptr;

	for (ptr = thescr,count = thesize; count--; *ptr++ = 0L);
	VsetRGB(0,16,oldpalette);
	return;
}
