/**************************************************************************/
/* Module : FIRDEMO.C																									  	*/
/* Author : Frank Kiesow																									*/	
/* PURE C VERS. 26.02.92	Tabstop = 2,ohne 68881 (besser mit !)						*/
/* Date		: 08.03.93																											*/
/* Kurzbeschreibung :																											*/
/* Kleines FIR-Filter Demoprogramm:																				*/
/* 	Tiefpass,Hochpass,Bandpass und Bandsperre															*/
/*	Die Grenzfrequenzen knnen mit Slidern verndert und									*/
/* 	die Filterkoeffizienten mit Fensterfunktionen	gewichtet werden.				*/
/* Mgliche Erweiterungen:																								*/
/* 	Float to fixpoint - 68030 Asembler oder Konvertierung im DSP					*/
/*	Realtime slider(Dazu sollte der DSP die Koeffizienten berechnen)			*/
/*	3D Buttons,Submen fr Fensterfunktionen															*/
/* Bei Fehlern,Verbesserungen,Smalltalk ... 02331/22396										*/
/*																																				*/
/**************************************************************************/

#include <stdio.h>
#include <stdlib.h> 
#include <aes.h>
#include <tos.h>
#include <vdi.h>
#include <oblib.h>
#include <math.h>
#include <ext.h>
#include <string.h>
#include <sndbind.h>
#include <dspbind.h>

#include "FIRDEMO.H"

#define FALSE 		0
#define TRUE  		1
#define DEC				0
#define INC				1
#define WATCH			0
#define SET_NEW		1
#define	MAX_COEFF 80
#define XMT_COEFF 0L

#define		min(x,y)	(((x) < (y)) ? (x) : (y))
#define		max(x,y)	(((x) > (y)) ? (x) : (y))

typedef char DSP_WORD[3];

/*********************** Funktionsprototypen ******************************/

int 		x_mul_div(int m1,int m2,int d1);
void 		gem_init(void);
void 		show_mouse(void);
void 		hide_mouse(void);
void 		arrow(void);
void 		biene(void);
void		flathand(void);
char	  *objc_get_text(OBJECT *tree,int index);
int 		progr_init(void);
int 		snd_init(void);
void 		snd_exit(void);
void 		progr_exit(void);
int 		load_resource(void);
void 		do_tedinfo(void);
int 		inc_volume(OBJECT *tree,int parent,int child,int channel);
int 		dec_volume(OBJECT *tree,int parent,int child,int channel);
int 		chng_parm(OBJECT *tree,int parent,int child,int flag);
int  		watch_low_high(int flag);
int 		hndl_slider(OBJECT *tree,int parent,int child);

int 		new_filter(void);

int 		fpfix(float src,DSP_WORD dest);
void 		fir_tp(int n,double ta,double wg);
void   	fir_hp(int n,double ta,double wg);
int   	fir_bp(int n,double ta,double low_wg,double up_wg);
int   	fir_bs(int n,double ta,double low_wg,double up_wg);
void 		fir_hamming_win(int ordnung);
void 		fir_hanning_win(int ordnung);
void 		fir_blackman_win(int ordnung);
void 		fir_bartlett_win(int ordnung,double smpl_freq);
void 		fir_lanczos_win(int ordnung);
void 		fir_fejer_win(int ordnung);

/******************* Globale Vereinbarungen *******************************/

int 		contrl[12];   
int 		intin[128];   
int 		ptsin[128];    
int 		intout[128];      
int 		ptsout[128];
int 		work_in[12];	
int 		work_out[57];	
int 		x_work_out[128]; 
int 		vdi_handle;   

int 		ap_id;											/* Identifikationsnummer von GEM			*/
int  		gl_rmsg[8];									/* AES Message Buffer 								*/
int			gl_wchar,
				gl_hchar,
				gl_wbox,
				gl_hbox;
int			scrw,												/* Breite und													*/
				scrh,												/* Hhe in Pixeln											*/
				scrwl,											/* Anzahl Worte/ Zeile								*/
				scrnp;											/* Anzahl Planes im Raster						*/

OBJECT	*filterbox;				
GRECT		work;

int slide_obj[] = 
{
	LOWERINC ,LOWPARNT ,LOWCHILD,	INC,
	LOWERDEC ,LOWPARNT ,LOWCHILD,	DEC,
	UPPERINC ,UPPARNT	 ,UPCHILD,  INC,
	UPPERDEC ,UPPARNT	 ,UPCHILD,  DEC,
	ORDINC	 ,ORDPARNT ,ORDCHILD,	INC,
	ORDDEC	 ,ORDPARNT ,ORDCHILD,	DEC,	
	-1
};	
	
DSP_WORD coeff[MAX_COEFF]; 	/* Maximal xx Koeffizienten a' 3 Bytes		  	*/

long host_cmd[2];
	
char buffer[4000];		  		/* Puffer fr DSP Programm 										*/

double a_k[MAX_COEFF];			/* Maximal 100 Filterkoeffizienten						*/

long curadder,curadc;				/* Voriger Zustand des Soundsystems						*/

				
/************************** Fehlertexte ***********************************/				

char *err_msg[] =
{
	"[1][Die Anwendung konnte das | Resourcefile nicht finden!][ABBRUCH]",
	"[1][Wollen Sie das |Programm verlassen?][  OK  |ABBRUCH]",
	"[1][Soundsystem von anderer|Anwendung blockiert !][ABBRUCH]",
	"[1][DSP von anderer|Anwendung blockiert !][ABBRUCH]",
	"[1][Fehler bei Dsp_InStream(...)!|Programm bitte sofort beenden][ABBRUCH]",
	"[1][Kein freier Speicher verfgbar!|][ABBRUCH]"
};

	
int x_mul_div(int m1,int m2,int d1)	/* Division ohne float								*/
{										/* Quelle: DR Programmers Toolkit(GEM/3 MS-DOS)				*/
	int ret;
	long lm1,lm2,ld1;
	lm1 = m1;
	lm2 = m2;
	ld1 = d1;
	ret = (int)((((lm1 * 2L * lm2) / ld1) + 1L) / 2L);
	return ret;
}
	
void gem_init(void)										/* Anwendung anmelden...						*/
{
	int i;
	ap_id = appl_init();
	vdi_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	for(i=0;i<10;work_in[i++]=1)
		;
	work_in[10] = 2;
	v_opnvwk(work_in,&vdi_handle,work_out);
	scrw	= work_out[0] + 1;							/* Breite in Pixeln								*/
	scrh	= work_out[1] + 1;							/* Hhe in Pixeln									*/
	scrwl	= scrw / 16;										/* Worte / Bildschirmzeile				*/
	vq_extnd(vdi_handle, 1, x_work_out);
	scrnp	= x_work_out[4];								/* Bits/ Bildpunkt								*/
}    

void show_mouse(void)
{
	v_show_c(vdi_handle,0);
}

void hide_mouse(void)
{
	v_hide_c(vdi_handle);
}

void arrow(void)
{
	graf_mouse(ARROW,0x00);
}

void biene(void)
{
	graf_mouse(HOURGLASS,0x00);
}

void flathand(void)
{
	graf_mouse(FLAT_HAND,0x00);
}

char *objc_get_text(OBJECT *tree,int index)    /* Liefert (char *) von    */
{																							 /* Textobject zurck   		*/
  OBSPEC tedinfo_ptr;
  tedinfo_ptr = tree[index].ob_spec;
  return tedinfo_ptr.tedinfo->te_ptext; 
}  

int progr_init(void)
{
	gem_init();										/* Anwendung anmelden											*/
	if(!load_resource())
	{
		v_clsvwk(vdi_handle);       /* Virtuelle Arbeitstation schliessen     */
		appl_exit();                /* Anwendung abmelden                     */
	  return FALSE;
	}  
	if(snd_init())								/* Soundsystem initialisieren							*/
	  return TRUE;
	rsrc_free();  
	v_clsvwk(vdi_handle);       /* Virtuelle Arbeitstation schliessen     */
	appl_exit();                /* Anwendung abmelden                     */
  return FALSE;
}

int snd_init(void)
{
	long xav,yav;
	if(locksnd() == SNDLOCKED)
	{
	 form_alert(1,err_msg[2]);		/* Soundsystem blockiert									*/
	 return FALSE;
	} 		
	if(Dsp_Lock())
	{
	 form_alert(1,err_msg[3]);		/* DSP blockiert													*/
	 unlocksnd();
	 return FALSE;
	} 	
	Dsp_Available(&xav,&yav);
	Dsp_Reserve(xav,yav);
	Dsp_LoadProg("FIRDEMO.LOD",3,buffer);

	soundcmd(LTATTEN,0x80);			
	soundcmd(RTATTEN,0x80);			
	soundcmd(LTGAIN,0x80);		
	soundcmd(RTGAIN,0x80);		

	curadder=soundcmd(ADDERIN,INQUIRE);
	soundcmd(ADDERIN,2);			

	curadc=soundcmd(ADCINPUT,INQUIRE);			
	soundcmd(ADCINPUT,0);
				
	setmode(STEREO16);
	
	dsptristate(ENABLE,ENABLE);	

	devconnect (ADC,DSPRECV,CLK_25M,CLK33K,NO_SHAKE);
	devconnect (DSPXMIT,DAC,CLK_25M,CLK33K,NO_SHAKE);
	
	return TRUE;
}

void snd_exit(void)
{
	soundcmd(ADDERIN,curadder);
	soundcmd(ADCINPUT,curadc);
	dsptristate(TRISTATE,TRISTATE);	
	Dsp_Unlock();
	unlocksnd();
}	

int load_resource(void)                 /* Resourcefile laden und die     */
{                                       /* Adressen der verschiedenen     */
  if(rsrc_load("FIRDEMO.RSC") == 0)     /* OBJECT-Bume setzen            */
	{
		form_alert(1,err_msg[0]);         	/* Resourcefile nicht gefunden	  */
		return(FALSE);
	}
  rsrc_gaddr(R_TREE,FIRBOX,&filterbox);
  do_tedinfo();
	return TRUE;
}

void do_tedinfo(void)
{ 
	char string[6];
	int value;
		
	value = MAX_COEFF - x_mul_div(filterbox[ORDCHILD].ob_y,MAX_COEFF,
						filterbox[ORDPARNT].ob_height - filterbox[ORDCHILD].ob_height);
	if(value < 3)
	 value = 3;
	itoa(value,string,10); 
	strcpy(objc_get_text(filterbox,ORDINFO),string);
	value = 1500 - x_mul_div(filterbox[UPCHILD].ob_y,1500,
						filterbox[UPPARNT].ob_height - filterbox[UPCHILD].ob_height);
	if(value < 10)
	  value = 10;
	sprintf(string,"%.2lf",(double)value/100.0);
	strcpy(objc_get_text(filterbox,UPINFO),string);
	value = 1500 - x_mul_div(filterbox[LOWCHILD].ob_y,1500,
						filterbox[LOWPARNT].ob_height - filterbox[LOWCHILD].ob_height);
	if(value < 10)
	  value = 10;
	sprintf(string,"%.2lf",(double)value/100.0);
	strcpy(objc_get_text(filterbox,LOWINFO),string);
}	

void progr_exit(void)     
{ 
	snd_exit();
	rsrc_free();
  v_clsvwk(vdi_handle);       /* Virtuelle Arbeitstation schliessen       */
  appl_exit();                /* Anwendung abmelden                       */
}
/********************** */

int fpfix(float src,DSP_WORD dest)
{
	float x;
	unsigned long *y1;					/* Alias fr (float) x											*/
	unsigned long	y0;
	char *ptr;									/* Alias fr (unsigned long) y0							*/
	y1 = (unsigned long *)&x;
	ptr = (char *)&y0;
	if(fabs(src) >= 2.0e-7)
	{ 
		x = src;
		y0 = *y1<<8;							/* Mantisse (fast)ganz nach links schieben	*/
	
		*y1 >>= 23;								/* Exponent in LSB													*/
		*y1 &= 0xffL;							/* Vorzeichen rausschmeissen								*/
		*y1 = 0x7fL - *y1;				/* Anzahl der Rechtsshifts berechnen				*/
	
		y0 |= 0x80000000uL;				/* Fhrende '1' einfgen										*/
		y0 >>= *y1;					  		/* Denormalisieren...												*/
		if(src < 0.0)							/* (Float) x < 0.0 ?												*/
		  y0 = ~y0;								/* Dann 1'er Komplement bilden							*/
		y0 >>= 7;									/* ... 24 Bit Wert erzeugen									*/
		if(y0 & 0x01L)						/* Letzte rausgeschobene Stelle  = 1?				*/
			y0++;										/* ...dann aufrunden												*/	
		y0 >>= 1;	
	}	
	else
	  y0 = 0L;
	dest[0] = ptr[1];
	dest[1] = ptr[2];
	dest[2] = ptr[3];
	return 1; 
}


void fir_tp(int n, double ta, double wg)  /* FIR Tiefpass berechnen       */
{
  int k;
  double omega;
  double si;
  double si_k;
  double *coeff_ptr = a_k;
  omega = 2.0 * (wg/ta);
  si = M_PI * omega;
  *coeff_ptr++ = omega;       /* omega * Si(0) = omega * 1.0      				*/
  for(k=1;k<n;k++)
  {
  	si_k = (double)k * si;
    *coeff_ptr++ = omega * sin(si_k)/(si_k);
  } 
}

void fir_hp(int n, double ta, double wg) /* FIR Hochpass berechnen        */
{
  int k;
  fir_tp(n,ta,wg);                       /* Zuerst den entsprechenden     */
  a_k[0] = 1.0 - a_k[0]; 								 /* Tiefpass berechnen ... dann   */
  for (k=1;k<n;k++)                      /*  von Allpass(= 1)subtrahieren */
    a_k[k] = -a_k[k];
}

int fir_bp(int n, double ta, double low_wg,double up_wg)
{                               /* FIR Bandpass berechnen                 */
  int k;                        /* Ergibt sich als Differenz zweier       */
  double *h_vec;                /* Tiefpasse                              */  
  h_vec = (double *)Malloc((n+1) * sizeof(double));/* Hilfsvector erzeugen*/
  if(h_vec == 0L)
  {
  	form_alert(1,err_msg[5]);
    return FALSE;
  }  
  fir_tp(n,ta,low_wg);          /* Zuerst untere Grenzfrequenz berechnen  */
  for (k=0;k<n;k++)
    h_vec[k] = a_k[k];					/* ... und sichern                        */
  fir_tp(n,ta,up_wg);           /* Obere Grenzfrequenz berechnen          */
  for (k=0;k<n;k++)
    a_k[k] -= h_vec[k];						/* Differenz bilden                     */
  Mfree(h_vec);
  return TRUE;
}

int fir_bs(int n, double ta, double low_wg,double up_wg)
{                               /* FIR Bandsperre berechnen               */
  int k;                        /* Ergibt sich aus der Differenz eines    */
  if(!fir_bp(n,ta,low_wg,up_wg))/* Allpass(=1) und eines Bandpass         */
    return FALSE;
  a_k[0] =  1.0 - a_k[0];
  for (k=1;k<n;k++)
    a_k[k] = -a_k[k];
  return TRUE;  
}


void fir_hamming_win(int ordnung)   /* Fensterfunktion                    */
{
  int n;
  for (n=0;n<ordnung;n++)
    a_k[n] *= (0.54+0.46*cos(M_PI*n/ordnung));
}


void fir_hanning_win(int ordnung)   /* Fensterfunktion                    */
{
  int n;
  for (n=0;n<ordnung;n++)
    a_k[n] *= (0.5+0.5*cos(M_PI*n/ordnung));
}


void fir_blackman_win(int ordnung)  /* Fensterfunktion                    */
{
  int n;
  for (n=0;n<ordnung;n++)
    a_k[n] *= (0.42+0.5*cos(M_PI*n/ordnung)+
                         0.08*cos(2*M_PI*n/ordnung));
}


void fir_bartlett_win(int ordnung,double smpl_freq)
{                                   /* Fensterfunktion                    */
  int n;
  double nenner;
  nenner = ordnung * smpl_freq;
  for (n=0;n<ordnung;n++)
    a_k[n] *= (1-fabs(n*smpl_freq)/nenner);
}


void fir_lanczos_win(int ordnung)   /* Fensterfunktion                    */
{
  int n;
  for (n=1;n<ordnung;n++)
    a_k[n] *= (sin(M_PI*n/ordnung)/(M_PI*n/ordnung));
}


void fir_fejer_win(int ordnung)     /* Fensterfunktion                    */
{
  int n;
  for (n=0;n<ordnung;n++)
    a_k[n] *= (1-fabs(n/ordnung));
}

/**************************************************************************/

void do_dialog(void)
{
	int i;
	int exit_obj;
	int change_flag;
	int value;
	int value_low,
			value_up;
	int old_y,old_pos;
	form_center(filterbox,&work.g_x,&work.g_y,&work.g_w,&work.g_h);
	form_dial(FMD_START,0,0,0,0,work.g_x,work.g_y,work.g_w,work.g_h);
	form_dial(FMD_GROW,0,0,0,0,work.g_x,work.g_y,work.g_w,work.g_h);
	hide_mouse();
	objc_draw(filterbox,ROOT,MAX_DEPTH,work.g_x,work.g_y,work.g_w,work.g_h);
	show_mouse();	
	arrow();	
	do
	{
		change_flag = FALSE;
		exit_obj = form_do(filterbox,0);
		switch(exit_obj)
		{
			case	INPLINC	 	:	if(dec_volume(filterbox,INPLPRNT,INPLCHLD,LTGAIN))
													objc_draw(filterbox,INPLPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;
			case	INPLDEC	 	:	if(inc_volume(filterbox,INPLPRNT,INPLCHLD,LTGAIN))
													objc_draw(filterbox,INPLPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;																				
			case	INPRINC	 	: if(dec_volume(filterbox,INPRPRNT,INPRCHLD,RTGAIN))
													objc_draw(filterbox,INPRPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;
			case	INPRDEC	 	:	if(inc_volume(filterbox,INPRPRNT,INPRCHLD,RTGAIN))
													objc_draw(filterbox,INPRPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;
			case	INPLCHLD	:	old_y = filterbox[exit_obj].ob_y;
												value = 1000-hndl_slider(filterbox,INPLPRNT,exit_obj);
												value = (((value * 15)/1000)<<4)&0xF0;
												soundcmd(LTGAIN,value);		
												break;	
			case	INPRCHLD	:	old_y = filterbox[exit_obj].ob_y;
												value = 1000-hndl_slider(filterbox,INPRPRNT,exit_obj);
												value = (((value * 15)/1000)<<4)&0xF0;
												soundcmd(RTGAIN,value);		
												break;							
			case	LOWPASS  	:	filterbox[UPMASK].ob_flags &= ~HIDETREE;
												objc_draw(filterbox,UPMASK,MAX_DEPTH,
																		work.g_x,work.g_y,work.g_w,work.g_h);
												objc_draw(filterbox,LOWMASK,0,
																		work.g_x,work.g_y,work.g_w,work.g_h);	
												filterbox[LOWMASK].ob_flags |= HIDETREE;					
												change_flag = TRUE;
												break;
			case	HIGHPASS 	:	filterbox[LOWMASK].ob_flags &= ~HIDETREE;
												objc_draw(filterbox,LOWMASK,MAX_DEPTH,
																		work.g_x,work.g_y,work.g_w,work.g_h);
												objc_draw(filterbox,UPMASK,0,
																		work.g_x,work.g_y,work.g_w,work.g_h);
												filterbox[UPMASK].ob_flags |= HIDETREE;												
												change_flag = TRUE;
												break;
			case	BANDPASS 	:	
			case 	BANDSTOP 	:	watch_low_high(SET_NEW);
												filterbox[UPMASK].ob_flags &= ~HIDETREE;
												filterbox[LOWMASK].ob_flags &= ~HIDETREE;
												objc_draw(filterbox,LOWMASK,MAX_DEPTH,
																		work.g_x,work.g_y,work.g_w,work.g_h);
												objc_draw(filterbox,UPMASK,MAX_DEPTH,
																		work.g_x,work.g_y,work.g_w,work.g_h);	
												change_flag = TRUE;
												break;
			case 	RECT			:
			case 	HANN			:
			case 	LANCZOS		:
			case 	HAMM			:
			case 	BLACKMAN 	:
			case 	FEJER  		:	change_flag = TRUE;
												break;						
			case	LOWCHILD	:	old_y = filterbox[exit_obj].ob_y;
												flathand();
												value_low = graf_slidebox(filterbox,
																										LOWPARNT,exit_obj,1);
												arrow();														
												filterbox[exit_obj].ob_y = 
													x_mul_div(value_low,filterbox[LOWPARNT].ob_height-
																	filterbox[exit_obj].ob_height,1000);																									
												if(watch_low_high(WATCH) == FALSE)
												  filterbox[exit_obj].ob_y = old_y;
												if(old_y != filterbox[exit_obj].ob_y)
												{
													hide_mouse();										
													do_tedinfo();
													objc_draw(filterbox,LOWINFO,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
													objc_draw(filterbox,LOWPARNT,MAX_DEPTH,
																			work.g_x,work.g_y,work.g_w,work.g_h);											
													show_mouse();			
													change_flag = TRUE;			
												}
												break;	
			case	UPCHILD		:	old_y = filterbox[exit_obj].ob_y;
												flathand();
												value_low = graf_slidebox(filterbox,
																										UPPARNT,exit_obj,1);
												arrow();														
												filterbox[exit_obj].ob_y = 
													x_mul_div(value_low,filterbox[UPPARNT].ob_height-
																	filterbox[exit_obj].ob_height,1000);																									
												if(watch_low_high(WATCH) == FALSE)
												  filterbox[exit_obj].ob_y = old_y;
												if(old_y != filterbox[exit_obj].ob_y)
												{
													do_tedinfo();
													hide_mouse();
													objc_draw(filterbox,UPINFO,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
													objc_draw(filterbox,UPPARNT,MAX_DEPTH,
																			work.g_x,work.g_y,work.g_w,work.g_h);											
													show_mouse();						
													change_flag = TRUE;			
												}	
												break;
			case	ORDCHILD	:	old_y = filterbox[exit_obj].ob_y;
												value = hndl_slider(filterbox,ORDPARNT,exit_obj);
												if(old_y != filterbox[exit_obj].ob_y)
												{
													do_tedinfo();
													objc_draw(filterbox,ORDINFO,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
													change_flag = TRUE;			
												}	
												break;
			case	OUTLINC	 	:	if(inc_volume(filterbox,OUTLPRNT,OUTLCHLD,LTATTEN))
													objc_draw(filterbox,OUTLPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;
			case	OUTLDEC	 	:	if(dec_volume(filterbox,OUTLPRNT,OUTLCHLD,LTATTEN))
													objc_draw(filterbox,OUTLPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;																				
			case	OUTRINC	 	: if(inc_volume(filterbox,OUTRPRNT,OUTRCHLD,RTATTEN))
													objc_draw(filterbox,OUTRPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;
			case	OUTRDEC	 	:	if(dec_volume(filterbox,OUTRPRNT,OUTRCHLD,RTATTEN))
													objc_draw(filterbox,OUTRPRNT,MAX_DEPTH,
																work.g_x,work.g_y,work.g_w,work.g_h);
												break;
			case	OUTLCHLD	:	old_y = filterbox[exit_obj].ob_y;
												value = hndl_slider(filterbox,OUTLPRNT,exit_obj);
												value = (((value * 15)/1000)<<4)&0xf0;
												soundcmd(LTATTEN,value);			
												break;	
			case	OUTRCHLD	:	old_y = filterbox[exit_obj].ob_y;
												value = hndl_slider(filterbox,OUTRPRNT,exit_obj);
												value = (((value * 15)/1000)<<4)&0xf0;
												soundcmd(RTATTEN,value);
												break;																																	
			case	LOWERINC 	:
			case	LOWERDEC 	: 
			case	UPPERINC 	:
			case	UPPERDEC 	: i=0;
												while((slide_obj[i]!=-1)&&(slide_obj[i]!=exit_obj))
													i += 4;
												if(slide_obj[i] != -1)					/* Gefunden				*/
													if(chng_parm(filterbox,slide_obj[i+1],
																					slide_obj[i+2],slide_obj[i+3]))
													{
														objc_draw(filterbox,slide_obj[i+1],MAX_DEPTH,
																			work.g_x,work.g_y,work.g_w,work.g_h);
														if(!(filterbox[UPMASK].ob_flags & HIDETREE))
														  objc_draw(filterbox,UPINFO,MAX_DEPTH,
																	work.g_x,work.g_y,work.g_w,work.g_h);
														if(!(filterbox[LOWMASK].ob_flags & HIDETREE))
														  objc_draw(filterbox,LOWINFO,MAX_DEPTH,
																	work.g_x,work.g_y,work.g_w,work.g_h);	
														change_flag = TRUE;			
													}										
												break;
			case	ORDINC	 	:
			case	ORDDEC		: i=0;
												while((slide_obj[i]!=-1)&&(slide_obj[i]!=exit_obj))
													i += 4;
												if(slide_obj[i] != -1)					/* Gefunden				*/
													if(chng_parm(filterbox,slide_obj[i+1],
																					slide_obj[i+2],slide_obj[i+3]))
													{
														objc_draw(filterbox,ORDPARNT,MAX_DEPTH,
																			work.g_x,work.g_y,work.g_w,work.g_h);		
														objc_draw(filterbox,ORDINFO,MAX_DEPTH,
																			work.g_x,work.g_y,work.g_w,work.g_h);					
														change_flag = TRUE;	
													}				
												break;					
			case	OK				:	objc_change(filterbox,exit_obj,0,
													work.g_x,work.g_y,work.g_w,work.g_h,NORMAL,1);
												break;																		
		}											
		if(change_flag)											
			new_filter();
	}
	while(exit_obj != OK);	
	form_dial(FMD_FINISH,0,0,0,0,work.g_x,work.g_y,work.g_w,work.g_h);
	form_dial(FMD_SHRINK,0,0,0,0,work.g_x,work.g_y,work.g_w,work.g_h);
}  												 

int chng_parm(OBJECT *tree,int parent,int child,int flag)
{
	if(flag == INC)
	{
		if(tree[child].ob_y > 0)
			tree[child].ob_y--;
		else
	 	 	return FALSE;	
		if(watch_low_high(WATCH) == FALSE)
		{
  		tree[child].ob_y++;
  		return FALSE;
  	}
  }
  else
  {
  	if(tree[child].ob_y <  tree[parent].ob_height - tree[child].ob_height)
			tree[child].ob_y++;
		else
		 	return FALSE;
		if(watch_low_high(WATCH) == FALSE)
		{
  		tree[child].ob_y--;
  		return FALSE;
  	} 	
  }	
  do_tedinfo();
  return TRUE;	
}

int inc_volume(OBJECT *tree,int parent,int child,int channel)
{
	int value = soundcmd(channel,INQUIRE);
	if(value == 0x00)
	  return FALSE;
	value = max(value-0x10,0x00);
	soundcmd(channel,value);
	if((channel == RTGAIN) || (channel == LTGAIN))
		value =  1500-(value >> 4) * 100;
	else
		value =  (value >> 4) * 100;
	value = x_mul_div(tree[parent].ob_height - 
										 tree[child].ob_height,value,1500);
	tree[child].ob_y = value;
	return TRUE;
}
	
int dec_volume(OBJECT *tree,int parent,int child,int channel)
{
	int value = soundcmd(channel,INQUIRE);
	if(value == 0xF0)
	  return FALSE;
	value = min(value+0x10,0xF0);
	soundcmd(channel,value);
	if((channel == RTGAIN) || (channel == LTGAIN))
		value =  1500-(value >> 4) * 100;
	else
	  value =  (value >> 4) * 100;	
	value = x_mul_div(tree[parent].ob_height - 
											tree[child].ob_height,value,1500);
	tree[child].ob_y = value;
	return TRUE;
}

int watch_low_high(int flag)
{
	int value_lower,
			value_upper;
	if((filterbox[LOWPASS].ob_state & SELECTED) ||
				(filterbox[HIGHPASS].ob_state & SELECTED))
	  return TRUE;			
	value_lower =	x_mul_div(filterbox[LOWCHILD].ob_y,1000,
								filterbox[LOWPARNT].ob_height-filterbox[LOWCHILD].ob_height);
  value_upper =	x_mul_div(filterbox[UPCHILD].ob_y,1000,
								filterbox[UPPARNT].ob_height-filterbox[UPCHILD].ob_height);

	if(value_upper >= value_lower)
	{
		if(flag == SET_NEW)
		{
			if(value_upper+10 > 1000)  		/* Wenn obere Grenzfrequenz > 990/1000*/
		 	 value_upper -= 10; 					/* oberere Frequenz etwas erhhen...	*/
	  	value_lower = value_upper+10;	/* Untere Frequenz ist jetzt kleiner	*/
			filterbox[LOWCHILD].ob_y = 
						x_mul_div(value_lower,filterbox[LOWPARNT].ob_height -
																filterbox[LOWCHILD].ob_height,1000);	
			filterbox[UPCHILD].ob_y = 
						x_mul_div(value_upper,filterbox[UPPARNT].ob_height -
															filterbox[UPCHILD].ob_height,1000);
			do_tedinfo();													
			return TRUE;
		}
		else
		  return FALSE;
	}	  
	return TRUE;		
}															

int hndl_slider(OBJECT *tree,int parent,int child)
{
	int pos;
	int x_off,y_off;
	flathand();
	pos = graf_slidebox(tree,parent,child,1);
	arrow();
	tree[child].ob_y = 
					x_mul_div(pos,tree[parent].ob_height-tree[child].ob_height,1000);
	hide_mouse();										
	objc_draw(filterbox,parent,MAX_DEPTH,work.g_x,work.g_y,work.g_w,work.g_h);											
	show_mouse();
	return pos;
}

int new_filter(void)
{
	int i;
	long done,count;
	double 	smpl_freq,
					lower_freq,
					upper_freq,
					sum_coeff; 
	int n_coeff;
	n_coeff = atoi(objc_get_text(filterbox,ORDINFO));
	lower_freq = atof(objc_get_text(filterbox,LOWINFO));
	upper_freq = atof(objc_get_text(filterbox,UPINFO));
	smpl_freq = 33.0;	
	sum_coeff = 0.0;
	if(filterbox[LOWPASS].ob_state == SELECTED)
		fir_tp(n_coeff,smpl_freq,upper_freq);
	else	
		if(filterbox[HIGHPASS].ob_state == SELECTED)
			fir_hp(n_coeff,smpl_freq,lower_freq);
		else
		  if(filterbox[BANDPASS].ob_state == SELECTED)
		  {
				if(!fir_bp(n_coeff,smpl_freq,lower_freq,upper_freq))
					return FALSE;
			}	
			else
			  if(filterbox[BANDSTOP].ob_state == SELECTED)
					if(!fir_bs(n_coeff,smpl_freq,lower_freq,upper_freq))
					  return FALSE;
	
	if(filterbox[BARTLETT].ob_state == SELECTED)
		fir_bartlett_win(n_coeff,smpl_freq);
	else	
		if(filterbox[BLACKMAN].ob_state == SELECTED)
			fir_blackman_win(n_coeff);	
		else	
			if(filterbox[FEJER].ob_state == SELECTED)
				fir_fejer_win(n_coeff);	
			else	
				if(filterbox[HAMM].ob_state == SELECTED)
					fir_hamming_win(n_coeff);
				else
					if(filterbox[HANN].ob_state == SELECTED)
						fir_hanning_win(n_coeff);
					else
						if(filterbox[LANCZOS].ob_state == SELECTED)
							fir_lanczos_win(n_coeff);
						else	
							if(filterbox[RECT].ob_state == SELECTED)		/* Default		*/
								;
	for(i=0;i<n_coeff;i++)				/* Betrag der Filterkoefizienten = 1			*/
	  sum_coeff += fabs(a_k[i]);
	sum_coeff = 1.0/sum_coeff;  
	for(i=0;i<n_coeff;i++)				/* Koeffizienten von Double- in						*/
	{															/* 24 Bit Festpunktformat wandeln					*/	
		a_k[i] *= sum_coeff;
	  fpfix((float)a_k[i],coeff[i]);
	}
	host_cmd[0] = XMT_COEFF;			
	host_cmd[1] = (long)n_coeff; 
	Dsp_BlkUnpacked(host_cmd,2L,0L,0L);
	done = count = 0L; 
	Dsp_InStream(&coeff,1L,host_cmd[1],&done);
	while((done != host_cmd[1]) && (count < 10000L))
		count++;
	if(done != host_cmd[1])
	{
	  form_alert(1,err_msg[4]);
	  return FALSE;
	}  	
	return TRUE;
}			

void main(void)
{
	if(!progr_init())
	  return;
	do_dialog();
	progr_exit();
}
