


FITPS(local)        UNIX Programmer's Manual         FITPS(local)



NAME
     fitps - Change dimensions and location of PostScript picture

SYNOPSIS
     fitps [ -l_l_l_x,_l_l_y -u_u_r_x,_u_r_y -m_c|_i -F -D -o <_f_i_l_e_n_a_m_e>
      ]  [ file ]

DESCRIPTION
     _F_i_t_p_s facilitates the alteration of size and positioning of
     a given PostScript program. The general procedure is to
     transform the _b_o_u_n_d_i_n_g _b_o_x which is a natural property of a
     plain PostScript program into another bounding box.  The
     parameters of the intended bounding box must be supplied to
     _f_i_t_p_s.  Information about the original bounding box of the
     PostScript program must be contained in the %%BoundingBox:
     llx lly urx ury header comment field of the PostScript pro-
     gram. Bounding boxes are defined by the coordinates of the
     lower-left and the upper-right corner. Coordinates of the
     original bounding box are dimensioned in _n_a_t_u_r_a_l _P_o_s_t_S_c_r_i_p_t
     _u_n_i_t_s, i.e. 1/72 inches. Metrics for the intended bounding
     box may be specified in _c_e_n_t_i_m_e_t_e_r_s or _i_n_c_h_e_s. Values may be
     given in integral or real format.

     _F_i_t_p_s can be supplied with the necessary parameters in two
     ways: either in _b_a_t_c_h _m_o_d_e or in _i_n_t_e_r_a_c_t_i_v_e _m_o_d_e. In batch
     mode, all parameters must be supplied from the command line.
     In interactive mode, the user is asked for each parameter
     one by one. This is convenient, because _f_i_t_p_s requires a lot
     of parameters at the same time.  If _f_i_t_p_s detects an error
     in command line usage, it automatically enters interactive
     mode.

     The PostScript program resulting from the transformation of
     the original program is sent to standard output unless the
     name of an output file is specified.

     As the proportions of the original and the intended bounding
     box are generally different, _f_i_t_p_s operates on a _c_l_o_s_e_s_t _f_i_t
     basis, i.e. the scale factor for the entire picture is
     selectet such that the picture will not extend the intended
     bounding box.  There is, however,  a special option that
     allows to completely fit the picture in the intended bound-
     ing box, which results in a distortion of the picture.

     The following _o_p_t_i_o_n_s may be used with fitps:

     -l_l_l_x,_l_l_y
          X- and Y-coordinates of the lower-left corner of the
          intended bounding box. Values for X and Y are separated
          by a comma (no white space).  Real numbers have a
          decimal point, e.g 12.4, 10. or .22.




Printed 10/16/87              fitps                             1






FITPS(local)        UNIX Programmer's Manual         FITPS(local)



     -u_u_r_x,_u_r_y
          X- and Y-coordinates of the upper-right corner of the
          intended bounding box.

     -m_c|_i
          Metric system for the coordinates. _c indicates centime-
          ters, _i indicates inches. If this option is omitted,
          the default metric system (in Europe: centimeters) is
          assumed.

     -o   The output shall be directed into the file with the
          given name.  If the filename is '-', or the option is
          omitted, the output is sent to standard output.

     -D   If this option is set, _f_i_t_p_s projects the picture into
          the entire area of the intended bounding box. This will
          in almost any case rersult in a distortion of the ori-
          ginal picture.

     -F   Operate in filter mode. If this option is set, the
          PostScript program is read from standard input. This
          works only on UNIX machines.

DIAGNOSTICS
     _F_i_t_p_s complains if the input file does not look like
     PostScript or if no bounding box information can be located.

SEE ALSO
     mfps(1)

BUGS
     _F_i_t_p_s makes the assumption, that the PostScript program
     describes just one page. The result for multiple-page docu-
     ments is undefined.

AUTHOR
     Axel Mahler
     Technical University Berlin

     _U_U_C_P:     axel@coma.uucp (unido!coma!axel)
     _B_I_T_N_E_T:   axel@db0tui62














Printed 10/16/87              fitps                             2



