JOY_UP		equ 20		;joypad
JOY_DOWN	equ 21
JOY_LEFT	equ 22
JOY_RIGHT	equ 23

FIRE_A		equ 29		;fire buttons
FIRE_B		equ 25
FIRE_C		equ 13
OPTION		equ 9
PAUSE		  equ 28

BITOBJ    equ 0		;Bitmap Object Type
SCBITOBJ  equ 1		;Scaled Bitmap Object Type
GPUOBJ    equ 2		;GPU Interrupt Object Type
BRANCHOBJ equ 3		;Branch Object Type
STOPOBJ   equ 4		;Stop Object Type

O_BREQ		equ 0                   ;(0<<14) ;CC field of BRANCH objects
O_BRGT		equ %100000000000000    ;(1<<14)
O_BRLT		equ %1000000000000000   ;(2<<14)
O_BROP		equ %1100000000000000   ;(3<<14)
O_BRHALF  equ %100000000000000000 ;(4<<14)

O_REFLECT equ $00002000	; OR with top LONG of BITMAP object
O_RMW     equ $00004000
O_TRANS   equ $00008000
O_RELEASE	equ $00010000

O_DEPTH1	equ 0                    ;(0<<12) DEPTH Field for BITMAP objects
O_DEPTH16	equ %100000000000000     ;(4<<12)

O_STOPINTS equ $00000008           ;Enable Interrupts in STOP object

XADDINC   equ $00030000  ;11 - add the increment

XADDPIX   equ $00010000  ;01 - add pixel size (add 1)

CLIP_A1   equ $00000040  ;d06:     A1 clipping enable
SRCEN     equ $00000001  ;d00:     source data read (inner loop)
UPDA1F    equ $00000100  ;d08:     A1 update step fraction
UPDA2     equ $00000400  ;d10:     A2 update step
DSTA2     equ $00000800  ;d11:     reverse usage of A1 and A2

DSTEN     equ $00000008  ;d03:     destination data read (inner loop)

LFU_REPLACE  equ $01800000  ;Source REPLACEs destination

PIXEL16   .equ $00000020  ;n = 4
XADDPHR	  .equ $00000000  ;00 - add phrase width and truncate
ADDDSEL	  .equ $00020000  ;d17:     diagnostic

GOURD     .equ $00001000  ;d12:     enable Gouraud shading
PATDSEL   .equ $00010000  ;d16:     Select pattern data
UPDA1     .equ $00000200  ;d09:     A1 update step
DRAM		  equ $000000	  ; Physical Start of RAM
USERRAM	  equ $004000	  ; Start of Available RAM
ENDRAM	  equ $200000	  ; End of RAM
INITSTACK	equ (ENDRAM-4)	; Recommended Stack Location
LEVEL0		equ $100
USER0		  equ $100	; Pseudonym
VIDTYPE	  equ $10

NTSC_WIDTH  equ 1409		; Width of screen in clocks
NTSC_HMID   equ 823		; Middle of screen in clocks
NTSC_HEIGHT equ 241		; Height of screen in pixels
NTSC_VMID   equ 266		; Middle of screen in half-lines

PAL_WIDTH   equ 1381		; Same as above for PAL
PAL_HMID    equ 843
PAL_HEIGHT  equ 287
PAL_VMID    equ 322


MATRIX3     equ 3
MATROW      equ 0

PITCH1      equ 0
PITCH2      equ 1
PITCH4      equ 2
PITCH3      equ 3

KEY_STAR    equ    16
KEY_7       equ    17
KEY_4       equ    18
KEY_1       equ    19

KEY_0       equ    4
KEY_8       equ    5
KEY_5       equ    6
KEY_2       equ    7

KEY_HASH    equ    0
KEY_9       equ    1
KEY_6       equ    2
KEY_3       equ    3

O_NOGAP   equ %1000000000000000    ;(1<<15) ;Phrase GAP between image phrase
O_1GAP    equ %10000000000000000    ;     (2<<15)
O_2GAP    equ %11000000000000000    ;     (3<<15)
O_3GAP    equ %100000000000000000    ;     (4<<15)
O_4GAP    equ %101000000000000000    ;     (5<<15)
O_5GAP    equ %110000000000000000    ;     (6<<15)
O_6GAP    equ %111000000000000000    ;     (7<<15)

LFU_NAN   equ  $00200000      ;           !source & !destination */
LFU_NA    equ  $00400000      ;           !source &  destination */
LFU_AN    equ  $00800000      ;            source & !destination */
LFU_A     equ  $01000000      ;            source &  destination */

WID2      equ  $00000800      ; 1.00 X 2^1  ( 4<<9) */
WID4      equ  $00001000      ; 1.00 X 2^2  ( 8<<9) */
WID6      equ  $00001400      ; 1.10 X 2^2  (10<<9) */
WID8      equ  $00001800      ; 1.00 x 2^3  (12<<9) */
WID10     equ  $00001A00      ; 1.01 X 2^3  (13<<9) */
WID12     equ  $00001C00      ; 1.10 X 2^3  (14<<9) */
WID14     equ  $00001E00      ; 1.11 X 2^3  (15<<9) */
WID16     equ  $00002000      ; 1.00 X 2^4  (16<<9) */
WID20     equ  $00002200      ; 1.01 X 2^4  (17<<9) */
WID24     equ  $00002400      ; 1.10 X 2^4  (18<<9) */
WID28     equ  $00002600      ; 1.11 X 2^4  (19<<9) */
WID32     equ  $00002800      ; 1.00 X 2^5  (20<<9) */
WID40     equ  $00002A00      ; 1.01 X 2^5  (21<<9) */
WID48     equ  $00002C00      ; 1.10 X 2^5  (22<<9) */
WID56     equ  $00002E00      ; 1.11 X 2^5  (23<<9) */
WID64     equ  $00003000      ; 1.00 X 2^6  (24<<9) */
WID80     equ  $00003200      ; 1.01 X 2^6  (25<<9) */
WID96     equ  $00003400      ; 1.10 X 2^6  (26<<9) */
WID112    equ  $00003600      ; 1.11 X 2^6  (27<<9) */
WID128    equ  $00003800      ; 1.00 X 2^7  (28<<9) */
WID160    equ  $00003A00      ; 1.01 X 2^7  (29<<9) */
WID192    equ  $00003C00      ; 1.10 X 2^7  (30<<9) */
WID224    equ  $00003E00      ; 1.11 X 2^7  (31<<9) */
WID256    equ  $00004000      ; 1.00 X 2^8  (32<<9) */
WID320    equ  $00004200      ; 1.01 X 2^8  (33<<9) */
WID384    equ  $00004400      ; 1.10 X 2^8  (34<<9) */
WID448    equ  $00004600      ; 1.11 X 2^8  (35<<9) */
WID512    equ  $00004800      ; 1.00 X 2^9  (36<<9) */
WID640    equ  $00004A00      ; 1.01 X 2^9  (37<<9) */
WID768    equ  $00004C00      ; 1.10 X 2^9  (38<<9) */
WID896    equ  $00004E00      ; 1.11 X 2^9  (39<<9) */
WID1024   equ  $00005000      ; 1.00 X 2^10 (40<<9) */
WID1280   equ  $00005200      ; 1.01 X 2^10 (41<<9) */
WID1536   equ  $00005400      ; 1.10 X 2^10 (42<<9) */
WID1792   equ  $00005600      ; 1.11 X 2^10 (43<<9) */
WID2048   equ  $00005800      ; 1.00 X 2^11 (44<<9) */
WID2560   equ  $00005A00      ; 1.01 X 2^11 (45<<9) */
WID3072   equ  $00005C00      ; 1.10 X 2^11 (46<<9) */
WID3584   equ  $00005E00      ; 1.11 X 2^11 (47<<9) */

