/*
 * Copyright (c) 1991 by Sozobon, Limited.  Author: Johann Ruegg
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

#include "syms.h"

#define LITTLE_ENDIAN

/*
 * fix alignment and byte order problems in cross environment
 */

/****************************************************************************
 *                                                                          *
 * Convert native long format to big endian                                 *
 *                                                                          *
 ****************************************************************************/

long crossl(char *pcSource)

{
union
    {
    long l;
    char c[4];
    } u;

#ifdef LITTLE_ENDIAN

u.c[0] = pcSource[3];
u.c[1] = pcSource[2];
u.c[2] = pcSource[1];
u.c[3] = pcSource[0];
#else
u.c[0] = pcSource[0];
u.c[1] = pcSource[1];
u.c[2] = pcSource[2];
u.c[3] = pcSource[3];
#endif
return u.l;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void swapw(char *pcData, int iCount)

{
#ifdef LITTLE_ENDIAN
char t;

while(iCount--)
    {
    t = pcData[1];
    pcData[1] = pcData[0];
    pcData[0] = t;
    pcData += 2;
    }
#endif
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void swapl(char *pcData, int iCount)

{
#ifdef LITTLE_ENDIAN
char cTemp;

while(iCount--)
    {
    cTemp = pcData[3];
    pcData[3] = pcData[0];
    pcData[0] = cTemp;

    cTemp = pcData[2];
    pcData[2] = pcData[1];
    pcData[1] = cTemp;
    pcData += 4;
    }
#endif
}

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void symhacki(DRISYMBOL *fp, int n)

{
while(n--)
    {
    fp->value = crossl((char *)&fp->value);
    fp++;
    }
}

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void fixsym(DRISYMBOL *sp)

{
sp->mark = 0;
sp->value = crossl((char *)&sp->value);
}


