#include <tos.h>
#include <stdio.h>
#include <string.h>

#include "mc_drive.h"

typedef struct
{
  char  *ibuf;  /* Zeiger auf den buffer */
  int   size;    /* groesse des Buffers   */
  int   nw;    /* naechste Leseposition    */
  int   nl;    /* naechste Schreibposition */
  int   blow;    /* untere Wassermarke       */
  int   bhig;    /* obere Wassermarke        */
} io_rec;

/* header file for dealing with the cookie jar */
#define BP _BasPag

char			midi_buf[25000];
io_rec 			*midi_io={NULL};
extern long		INTC;

io_rec *INSTALL(long size,char *buff);

static void MSEND(int LEN,char *buff);
static void MIDEIN(void);

int mdstat(void)
{
 int nl,nw;
 nl=midi_io->nl; nw=midi_io->nw;
 if ((INTC!=0) || (nl!=nw)) return(-1);
 else return(0);
}

int fil_request(void)
{
 int nl,nw,size;
 long fuellung;

 nl=midi_io->nl; nw=midi_io->nw;
 
 if ((INTC==0) && (nl==nw)) return(0);
 else
 {
	size=midi_io->ibuf[++nw];
	size<<=8;
	size|=midi_io->ibuf[++nw];
	if ((size<24) || (size>4400)) return(1);

	fuellung=(nw<nl) ? (nl-nw) :(midi_io->size-nw+nl);
	if (fuellung>(size-10)) return(1);
	else return(0);
 }
}

long   LESE(int len,char *buff)
{
int i=0;
long err1=0,err2=0;

do 
{
	if (midi_io->nw!=midi_io->nl)
	{
		midi_io->nw++;
		if (midi_io->nw==midi_io->size) midi_io->nw=0;
		buff[i]=midi_io->ibuf[midi_io->nw];
		i++;
		err1=0;
	}
	else err1++;
} while ((err1<500) && (i<len));

err2=INTC;
if ((err1>=500) || (err2!=0)) return(err1|err2);
	                      	else return(0);
} 

static long install_cookies(void)
{
	COOKIE  *cokie;
	long	found=0;
	int		i=16;
		
	cokie=*CJAR;
	if (!cokie)
	{
		*CJAR=cokie=Malloc(i*8);
		if (cokie)
		{
			cokie->tag.aslong = 0;
			cokie->value=i;
		}
	}
	if (cokie) 
	{
		while (cokie->tag.aslong != 0) 
		{
			if (!strncmp(cokie->tag.aschar, "MCDR",4))
			{
				cokie->value=(long)&port;
				found=1;
			}
			cokie++;
		}
		if (!found)
		{
			strncpy(cokie->tag.aschar,"MCDR",4);
			found=cokie->value;
			cokie->value=(long) &port;
			cokie++;
			cokie->tag.aslong = 0; 
			cokie->value=found; 
		}
	return(0);
	}
	return(-1);
}

void main(void)
{
	Cconws("Schnittstellentreiber\r\n");
	Cconws("     --MIDI--\r\n");
	Cconws("  fr MIDI_COM.ACC\r\n");
	midi_io=INSTALL(sizeof(midi_buf),midi_buf);
	(void)Supexec(install_cookies);
	Ptermres(256L + BP->p_tlen + BP->p_dlen + BP->p_blen, 0);
}