*      MOSTART.S
*
*      Startup Code for "midnight", THE ScreenSaver
*
*      Copyright (c) Hartwig zur Nieden & Mario Adam
*      Clausthal-Zellerfeld/Gttingen  14.11.1992


*>>>>>> Export references <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

        .EXPORT EVNT_ask	* Funktionen aus dem ACC_struct
        .EXPORT rnd24		* nochmal fr einfacheren zugriff
        .EXPORT Sound
        .EXPORT ScreenSave

		.EXPORT MOD_struct	* Pointer auf Modulstruktur des Moduls
							* MOD_struct.U.b sollt in M_INIT mit den
							* Hardware-Flags beschrieben werden, wenn
							* diese != 0x003f sein sollen.

        .EXPORT _BasPag
        .EXPORT errno
        .EXPORT _FilSysVec
        .EXPORT _RedirTab

        .EXPORT __text, __data, __bss

*>>>>>> Import references <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

        .IMPORT MOD_main		* diese 2 Pointer MSSEN im Modul definiert
        .IMPORT Value_s			* und Value_s MUSS bei M_INIT gesetzt werden!
 
        .IMPORT _fpuinit
        .IMPORT _StkSize




*>>>>>> Data structures <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<


* Struktur der Basepage:

		.OFFSET 0

TpaStart:		.DS.L   1
TpaEnd:			.DS.L   1
TextSegStart:	.DS.L   1
TextSegSize:	.DS.L   1
DataSegStart:	.DS.L   1
DataSegSize:	.DS.L   1
BssSegStart:	.DS.L   1
BssSegSize:		.DS.L   1
DtaPtr:			.DS.L   1
PntPrcPtr:		.DS.L   1
Reserved0:		.DS.L   1
EnvStrPtr:		.DS.L   1
Reserved1:		.DS.B   7
CurDrv:			.DS.B   1
Reserved2:		.DS.L   18
CmdLine:
        .DS.B   128



*>>>>>>> Data segment <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

			.BSS
__bss:

_BasPag:	.DS.L	1			* Pointer auf die Basepage
_RedirTab:	.DS.L	6			* Redirection address table


*>>>>>>> Initialized data segment <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

        .DATA
__data:

errno:		.DC.W   0			* globale Errorvariable
_FilSysVec:	.DC.L   0			* Vector zur Filesystem-Deinitialisierung

_Acc_str:	.DC.L	0			* Zwischenspeicher fr den *ACC_str


*>>>>>>> Code segment <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

        .CODE
__text:


******** MOStart ********************************************************

******* midnight-Modul-Struktur MOD_str

MOD_struct:		* hier beginnt das Modul
Start:
		BRA.S   Start0

magic:	.DC.B   "mid_MOD",0			* Erkennungs-Magic

Werte:	.DC.L   0,0,0,0,0,0,0,0		* DIese Werte werden mit/in
BITS:	.DC.W   $3F					* dem Modul abgespeichert

Bilder:	.DC.L   Value_s				* Pointer auf 8 'Value'-Pointer
MyName:	.DC.L   CmdLine				* Modul-Name aus der Commandline

		.EVEN

******* Configuration data


* Redirection array pointer

		.DC.L   _RedirTab

* Stack size entry

		.DC.L   _StkSize




******** Pc startup code

* Setup pointer to base page

Start0:
		movem.l D0/A0,-(A7)				* Parameters ->

* Test if fpu 68881 is present

		tst.w   D0
		bne.s   Start1					* FPU-Init nur bei Mode = M_INIT
		jsr		_fpuinit

******* Execute main program *******************************************

Start1:
		lea		__text-256(PC),A0
		move.l	A0,_BasPag
		lea		128(A0),A0
		move.l	A0,MyName

		movem.l	(A7)+,D0/A0				* Parameter <-
		move.l	A0,_Acc_str
		jsr		MOD_main

******** exit ***********************************************************

exit:
		move.l	D0,-(A7)				* save Return value

* Deinitialize file system

		move.l	_FilSysVec,D0
		beq.s	Exit1

		move.l	D0,A0
		jsr		(A0)

Exit1:

* Program termination with return code in D0

		move.l  (A7)+,D0			* get back Return value
		rts


********************* EVNT_ask ****

EVNT_ask:
		movea.l	_Acc_str(PC),A0
		movea.l	150(A0),A0
		jmp		(A0)				* Jump zum Accessory -> EVNT_ask

********************* rnd24 ********

rnd24:
		movea.l	_Acc_str(PC),A0
		movea.l	154(A0),A0
		jmp		(A0)				* Jump zum Accessory -> rnd24

********************* Sound ********

Sound:
		movea.l	_Acc_str(PC),A1
		movea.l	158(A1),A1
		jmp		(A1)				* Jump to the Accessorys Sound

********************* ScreenSave ***

ScreenSave:
		movea.l	_Acc_str(PC),A1
		movea.l	162(A1),A1
		jmp		(A1)				* Jump zum Accessory -> ScreenSave



******* Module end *****************************************************

        .END
