.TH Fmidipipe 2 "MiNT Programmer's Manual" "Version 1.0" "Feb. 1, 1993"
.SH NAME
Fmidipipe \- redirect MIDI input and output
.SH SYNOPSIS
.nf
LONG Fmidipipe( WORD pid, WORD in, WORD out);
.fi
.SH DESCRIPTION
.I Fmidipipe
changes the MIDI input and output file handles
(GEMDOS file handles -4 and -5 respectively)
for process
.I pid.
.I in
is the GEMDOS handle (for the calling process) which will become
the MIDI input for the receiving process, and
.I out
is the GEMDOS handle which is to become the MIDI output.
.PP
If
.I pid
is 0, then the call affects the current process; in this case, it is
roughly equivalent to the sequence
.nf
	Fforce(-4, in);
	Fforce(-5, out);
.fi
.SH RETURNS
0 on success
.PP
EFILNF if the indicated process is not found
.PP
EIHNDL if either
.I in
or
.I out
is not a valid open handle.
.PP
EACCDN if
.I in
is not open for reading or if
.I out
is not open for writing.
.SH "SEE ALSO"
.IR Fdup (2),
.IR Fforce (2)
.SH BUGS
Any user can change the MIDI input and output of any process.
This will eventually be corrected.
