.TH Psetuid 2 "MiNT Programmer's Manual" "Version 1.0" "Feb. 1, 1993"
.SH NAME
Psetuid, Psetgid \- change a process' user or group id
.SH SYNOPSIS
.nf
WORD Psetuid(WORD uid);
WORD Psetgid(WORD gid);
.fi
.SH DESCRIPTION
.I Psetuid
sets the user id of the current process to
.IR uid ,
which must be a number between 0 and 255 inclusive.
This function call will fail if the user id is not already 0, so once
a process' user id is set it is fixed.
.I Psetuid
returns
.IR uid ,
if the call is successful, and EACCDN if the process does not have
the authority to change its own user id (i.e. if its effective user
id is not 0 at the time of the call).
.PP
Similarly,
.I Psetgid
sets the group id of the current process to
.IR gid ,
which again must be between 0 and 255. The new group id
.I gid
is returned if successful, and EACCDN is returned if
permission to change groups is denied.
.SH "SEE ALSO"
.IR Pgetuid (2)
.SH BUGS
Security in MiNT is a joke; don't rely on these calls to actually protect
you from anything, it's more for informational purposes.
