 (*
"hier gibt's ein Problem:
"in LTOS klappt die Synchronisation nicht, wenn hyperCACHE verwendet wird.
"Obwohl die FPU offenbar bei 1) auf die Datenabholung wartet, tut sie's
"nach dem Lesen immer noch. Erst ein 2. Lesezugriff stellt sie zufrieden.
 *)
 
 (*$C-*)
 module t2;
 (*$F-*)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM SFP004 IMPORT FPUInit;
 FROM StrConv IMPORT StrToReal;
 
 CONST
(fpstat  =  $fffffa40;       (* Response word of MC68881 read *)
(fpstatlo=  $fffffa41;
(fpctrl  =  $fffffa42;       (* Control  word of MC68881 write *)
(fpcmd   =  $fffffa4a;       (* Command  word of MC68881 write *)
(fpcond  =  $fffffa4e;       (* Condition word of MC68881 write *)
(fpop    =  $fffffa50;       (* Operand  long of MC68881 read/write *)
(fpregsel=  $fffffa54;       (* register select long read *)
(
(A2stat  =  -1;            (* Response word of MC68881 read *)
(A2ctrl  =  1;             (* Control  word of MC68881 write *)
(A2cmd   =  9;             (* Command  word of MC68881 write *)
(A2cond  =  $D;            (* Condition word of MC68881 write *)
(A2op    =  $F;            (* Operand  long of MC68881 read/write *)
(A2regsel=  $13;           (* register select long read *)
 
 PROCEDURE @LTOS;
"(*$L-*)
"BEGIN
$ASSEMBLER
 DoDl0   TST.B   fpstatlo
(BEQ     DoDl0
(MOVE.W  #$5500,fpcmd         ; FMOVE.D (A0),FP2
 !DoDl1  TST.B   fpstatlo
(BEQ     DoDl1
(MOVE.L  (A0)+,fpop
(TST.W   fpstat
(MOVE.L  (A0),fpop
 !DoDl3  TST.B   fpstatlo
(BEQ     DoDl3
(MOVE.W  fpstat,D0
(CMPI.W  #$0802,D0
(BNE     DoDErr3
(MOVE.W  #$6500,fpcmd         ; FMOVE.S FP2,D1
 !DoDl5  MOVE.B  fpstatlo,D0
(BEQ     DoDl5
(SUBQ.B  #4,D0
(BNE     DoDErr2
(; 1) die FPU hat das Datum bereitgestellt
(MOVE.L  fpop,D0
(MOVE.W  fpstat,D0
(CMPI.W  #$0802,D0
(BNE     DoDErr
(RTS
 DoDErr3 BREAK
 DoDErr2 BREAK
 !DoDErr LINK    A5,#0
(BREAK
(UNLK    A5
(CLR.L   D0
$END
"END @LTOS;
 (*$L=*)
 
 var f: INTEGER; lr: LONGREAL; sr: REAL; p: CARDINAL; b: BOOLEAN;
 
 begin
"FPUInit;
"sr:= SHORT (lr);
"sr:= SHORT (lr);
"sr:= SHORT (lr);
"sr:= SHORT (lr);
"ASSEMBLER BREAK END;
 
"ASSEMBLER
(MOVEQ   #1,D7
&again:
&
(MOVE.W  #$5500,fpcmd         ; FMOVE.D (A0),FP2
 !DoDl1  TST.B   fpstatlo
(BEQ     DoDl1
(MOVE.L  D0,fpop
(TST.W   fpstat
(MOVE.L  D0,fpop
(MOVE.W  fpstat,D0
(MOVE.W  fpstat,D1
(MOVE.W  fpstat,D2
(MOVE.W  fpstat,D3
(MOVE.W  fpstat,D4
(MOVE.W  fpstat,D5
(MOVE.W  fpstat,D6
(DBRA    D7,again
(BREAK
"END;
 end t2.
  
(* $FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFED2912$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$FFE965DF$000007F6T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000007F6$000005D9$000007F6$00000842$0000052A$FFEBB236$00000916$FFEBB236$FFEBB236$000008EB$FFEBB236$0000090E$000005CF$000005C1$000005DF$00000842*)
