(*
 ****************************************************************************
 *
 *                   "DHRYSTONE" Benchmark Program
 *                   -----------------------------
 *
 *  Version:    Modula, Version 2.1
 *
 *  File:       d_global.def
 *
 *  Date:       June 8, 1989
 *
 *  Author:     Reinhold P. Weicker
 *                      Siemens AG, E STE 35
 *                      Postfach 3220
 *                      8520 Erlangen
 *                      Germany (West)
 *                              Phone:  [xxx-49]-9131-7-20330
 *                                      (8-17 Central European Time)
 *                              Usenet: ..!mcvax!unido!estevax!weicker
 *
 *              Original Version (in Ada) published in
 *              "Communications of the ACM" vol. 27., no. 10 (Oct. 1984),
 *              pp. 1013 - 1030, together with the statistics
 *              on which the distribution of statements etc. is based,
 *
 *              This version uses calls to the Pascal runtime library of the
 *              Berkeley UNIX system (4.3 bsd) for time measurement.
 *              For measurements on other systems, these calls need to be
 *              modified.
 *
 *  Collection of Results:
 *              Reinhold Weicker (address see above) and
 *
 *              Rick Richardson
 *              PC Research. Inc.
 *              94 Apple Orchard Drive
 *              Tinton Falls, NJ 07724
 *                      Phone:  (201) 834-1378 (9-17 EST)
 *                      Usenet: ...!seismo!uunet!pcrat!rick
 *
 *      Please send results to Rick Richardson and/or Reinhold Weicker.
 *      Complete information should be given on hardware and software used.
 *      Hardware information includes: Machine type, CPU, type and size
 *      of caches; for microprocessors: clock frequency, memory speed
 *      (number of wait states).
 *      Software information includes: Compiler (and runtime library)
 *      manufacturer and version, compilation switches, OS version.
 *      The Operating System version may give an indication about the
 *      compiler; Dhrystone itself performs no OS calls in the measurement loop.
 *
 *      The complete output generated by the program should be mailed
 *      such that at least some checks for correctness can be made.
 *
 ****************************************************************************
 *
 *  History:    This version Pascal/2.1 has been made for two reasons:
 *
 *              1) There is a need for a common Pascal version of
 *              Dhrystone. Although translation from the published (Ada)
 *              version to Pascal is straightforward in most aspects,
 *              there are cases where it may not be obvious to everyone.
 *              There should be, as far as possible, only one Pascal version
 *              of Dhrystone such that results can be compared without
 *              restrictions. Also, a Pascal version of Dhrystone has not yet
 *              found a network distribution comparable to the C version
 *              (version 1.1) distributed by Rick Richardson.
 *
 *              2) As far as it is possible without changes to the Dhrystone
 *              statistics, optimizing compilers should be prevented from
 *              removing significant statements.
 *
 *              This Pascal version 2.1 has been made consistent with the
 *              C version 2.1; therefore the acknowledgments for the C version
 *              are due for the Pascal version as well: I thank
 *              Rick Richardson (Tinton Falls, NJ), Chaim Benedelac (Nat.
 *              Semi.), David Ditzel (SUN), Earl Killian and John Mashey (MIPS),
 *              Alan Smith and Rafael Saavedra-Barrera (UC at Berkeley)
 *              for their help with comments on earlier versions of the
 *              benchmark.
 *
 *  Changes:    In the initialization part, this version differs
 *              from the Pascal version previously distributed by Reinhold
 *              Weicker, the number of runs through Dhrystone is obtained
 *              interactively from the terminal. Output of the result
 *              has been changed to conform to the C version (2.1).
 *              The changes in the initialization part and in the printing
 *              of the result have no impact on performance measurement
 *              since they are outside the measaurement loop.
 *
 *              Inside the measurement loop, this version follows the
 *              version previously distributed by Reinhold Weicker.
 *              As a correction to the published version, a statement
 *              initializing Array2Glob [8,7] (outside the measurement
 *              loop) has been added. Otherwise, this array element would
 *              have an undefined value.
 *
 *              At several places in the benchmark, code has been added,
 *              but within the measurement loop only in branches that
 *              are not executed. The intention is that optimizing compilers
 *              should be prevented from moving code out of the measurement
 *              loop, or from removing code altogether. Since the statements
 *              that are executed within the measurement loop have NOT been
 *              changed, all numbers defining the "Dhrystone distribution"
 *              (distribution of statements, operand types and locality)
 *              still hold. Except for sophisticated optimizing compilers,
 *              execution times for this version should be the same as
 *              for previous versions.
 *
 *              Since it has proven difficult to subtract the time for the
 *              measurement loop overhead in a correct way, the loop check
 *              has been made a part of the benchmark. This does have
 *              an impact - though a very minor one - on the distribution
 *              statistics which have been updated for this version.
 *
 *              All changes within the measurement loop are described
 *              and discussed in the companion paper "Rationale for
 *              Dhrystone version 2".
 *
 *              Because of the self-imposed limitation that the order and
 *              distribution of the executed statements should not be
 *              changed, there are still cases where optimizing compilers
 *              may not generate code for some statements. To a certain
 *              degree, this is unavoidable for small synthetic benchmarks.
 *              Users of the benchmark are advised to check code listings
 *              whether code is generated for all statements of Dhrystone.
 *
 *              Version 2.1 is identical to version 2.0 distributed via
 *              the UNIX network Usenet in March 1988 except that it corrects
 *              some minor deficiencies that were found by users of version 2.0.
 *              The only change within the measurement loop is that a
 *              non-executed "else" part was added to the "if" statement in
 *              Func3, and a non-executed "else" part removed from Proc3.
 *
 ***************************************************************************
 *
 *  Compilation model and measurement (IMPORTANT):
 *
 *  This program contains the Dhrystone program, including measurement setup,
 *  in one file. The original (Ada) program contained three packages,
 *  - a package with global type definitions,
 *  - Pack_1, containing the main program (Proc_0 in Ada) and procedures
 *            Proc_1, ... , Proc_5,
 *  - Pack_2, containing Proc_6, ... , Proc_8, Func_1, ..., Func_3.
 *  Since ISO/ANSI Standard Pascal provides no means to express separate
 *  compilation (although many Pascal implementations provide such a feature),
 *  it is not possible to formulate a portable Pascal version with the program
 *  in several modules, corresponding more closely to the Ada and C versions.
 *  Therefore, no attempt has been made to construct a Pascal version with
 *  the program consisting of several modules.
 *
 *  This difference may impact execution time because the compiler can
 *  perform more data flow analysis for a single-module program;
 *  sophisticated compilers may be able to suppress code generation for
 *  some parts of the program.
 *  Users should check machine code listings generated by the compiler
 *  to ensure that code is generated for all parts of the program.
 *
 *  The following "ground rules" apply for measurements:
 *  - No procedure merging
 *  - Otherwise, compiler optimizations are allowed but should be indicated
 *  See the companion paper "Rationale for Dhrystone Version 2" for a more
 *  detailed discussion of these ground rules.
 *
 *  For 16-Bit processors (e.g. 80x86), times for all compilation models
 *  ("small", "medium", "large") should be given if possible, together
 *  with a definition of these models for the compiler system used.
 *
 **************************************************************************
 *
 *  Dhrystone (Pascal version) statistics:
 *
 *  [Comment from the first distribution by Reinhold Weicker,
 *   the distribution statistics have been updated for Version 2.1.
 *   Note that because of language differences, the numbers are different
 *   from the Ada version. The main difference is that the variables that
 *   are local variables of "Proc_0" (Ada) or "main" (C) are global
 *   variables in the Pascal version.]
 *
 *  The following program contains statements of a high level programming
 *  language (here: Pascal) in a distribution considered representative:
 *
 *    assignments                  58
 *    control statements           28
 *    procedure, function calls    15
 *
 *  100 statements are dynamically executed. The program is balanced with
 *  respect to the three aspects:
 *
 *    - statement type
 *    - operand type (for simple data types)
 *    - operand access
 *         operand global, local, parameter, or constant.
 *           There is no static nesting of blocks or procedures,
 *           therefore all variables are either global or local.
 *
 *  The combination of these three aspects is balanced only approximately.
 *
 *  1. Statement Type:
 *  -----------------             number
 *
 *     V1 := V2                   15
 *     V := Constant              12
 *       (incl. V1 := F(..)
 *     Assignment,                 7
 *       with array element
 *     Assignment,                 6
 *       with record component
 *                                --
 *                                40       40
 *
 *     X := Y +|-|and|or Z         5
 *     X := Y +|-|"=" Constant     6
 *     X := X +|- 1                3
 *     X := Y *|/ Z                2
 *     X := Expression,            1
 *          two operators
 *     X := Expression,            1
 *          three operators
 *                                --
 *                                18       18
 *
 *     if .... then ....          14
 *       with "else"      7
 *       without "else"   7
 *           executed        3
 *           not executed    4
 *     for I in 1..N do ...        7  |  counted every time
 *     while ... do ...            4  |  the loop condition
 *     repeat ... until            1  |  is evaluated
 *     case ... end                1
 *     with                        1
 *                                --
 *                                28       28
 *
 *     P (...)  procedure call    10
 *     X := F (...)
 *             function  call      5
 *                                --
 *                                15       15
 *                                        ---
 *                                        101
 *
 *    22 of the 58 assignments have a variable of a constrained
 *    (sub-)type as their destination. In general, discriminant checks
 *    will be necessary in these cases; however, the compiler may
 *    optimize out some of these checks.
 *
 *    The average number of parameters in procedure or function calls
 *    is 1.80 (not counting the function values as implicit parameters).
 *
 *
 *  2. Operators
 *  ------------
 *                          number    approximate
 *                                    percentage
 *
 *    Arithmetic             27          52.9
 *
 *       +                     16          31.4
 *       -                      7          13.7
 *       *                      3           5.9
 *       div                    1           2.0
 *
 *    Comparison             20           39.2
 *
 *       =                      9           17.6
 *       <>                     4            7.8
 *       >                      1            2.0
 *       <                      3            5.9
 *       >=                     1            2.0
 *       <=                     2            3.9
 *
 *    Logic                   4            7.8
 *
 *       AND                    1            2.0
 *       OR                     1            2.0
 *       NOT                    2            3.9
 *
 *                           --          -----
 *                           51           99.9
 *
 *
 *  3. Operand Type (counted once per operand reference):
 *  ---------------
 *                          number    approximate
 *                                    percentage
 *
 *     Integer               135        54.7 %
 *     Character              47        19.0 %
 *     Enumeration            31        12.6 %
 *     Boolean                13         5.3 %
 *     Pointer                11         4.5 %
 *     String30                6         2.4 %
 *     Array                   2         0.8 %
 *     Record                  2         0.8 %
 *                           ---       -------
 *                           247        100.1 %
 *
 *  When there is an access path leading to the final operand (e.g. a record
 *  component), only the final data type on the access path is counted.
 *
 *  There are 16 accesses to components of a record, 9 of them go to
 *  a component in a variant part. For some of these accesses, the
 *  compiler may suppress generation of code checking the tag field
 *  during optimization.
 *
 *
 *  3. Operand Locality:
 *  -------------------
 *
 *     local variable               84        34.0 %
 *     global variable              58        23.5 %
 *     parameter                    45        18.2 %
 *        value                        23         9.3 %
 *        reference                    22         8.9 %
 *     function result               5         2.0 %
 *     constant                     55        22.3 %
 *                                 ---       -------
 *                                 247       100.0 %
 *
 *
 *  The program does not compute anything meaningful, but it is syntactically
 *  and semantically correct. All variables have a value assigned to them
 *  before they are used as a source operand.
 *
 *  There may be cases where a highly optimizing compiler may recognize
 *  unnecessary statements and may not generate code for them.
 *
 *  There has been no explicit effort to account for the effects of a
 *  cache, or to balance the use of long or short displacements for code or
 *  data.
 *
 ****************************************************************************
 *)


DEFINITION MODULE D_Global;

TYPE

  (* Global type definitions *)

  Enumeration           = (Ident1, Ident2, Ident3, Ident4, Ident5);

  OneToThirty           = INTEGER [1..30];
  OneToFifty            = INTEGER [1..50];
  CapitalLetter         = CHAR ['A'..'Z'];

  String30              = ARRAY OneToThirty OF CHAR;

  Array1DimInteger      = ARRAY OneToFifty OF INTEGER;
  Array2DimInteger      = ARRAY OneToFifty, OneToFifty OF INTEGER;

  RecordPointer         = POINTER TO RecordType;

  RecordType            =
      RECORD
        PointerComp:   RecordPointer;
        CASE Discr:    Enumeration OF
          Ident1:         (* only this variant is used,           *)
                          (* but in some cases discriminant       *)
                          (* checks are necessary                 *)
             EnumComp:      Enumeration;
             IntComp:       OneToFifty;
             StringComp:    String30    |
          Ident2:
             Enum2Comp:    Enumeration;
             String2Comp:  String30     |
          Ident3, Ident4, Ident5:
             Char1Comp,
             Char2Comp:    CHAR
        END; (* case *)
      END; (* record *)
END D_Global.
