 MODULE MM2Link; (*$Z+,M+,C-,Q+,P+,V+,R-*)
 
 (*
 IMPORT TOSDebug;
 *)
 
 (*
!* Format der Argumentzeile beim Aufruf:
!*   MM2LINK codename {-M|-V|-H|-F|-0|-1|-2|
!*                     -Oprgname|-Rmaxreloc|-Sargs|-Iargs|
!*                     -Ddatasize|-Ddatafile}
!*)
 
 (* Copyright (c) 1985 Juergen Mueller, 1986 Thomas Tempelmann
 * V#0684
 *
 * 08.12.85 : Juergen Mueller : Grundversion 1.0
 * 27.06.86 : TT              : Atari-Relozier-vers 1.0
 * 21.07.86 : TT              : Atari-Relozier-vers 1.1 (schneller)
 * 21.07.86 : TT              : V1.1 lauffhig fr Atari
 * 23.07.86 : TT              : V1.2 mit untersch. Suffixe f. Impl/Prg
 * 24.10.86 : TT              : V1.3 Fehler in ImportLen behoben; Initmodul
 *                              wird mit eingelinkt; ModLst wird abgelegt f.
 *                              Loader; HeadSkip raus
 * 27.10.86 : TT              : V1.4 neuer name: 'prginint.mod';
 * 08.02.87 : TT              : V1.5, ShortModLst wird anders abgelegt.
 * 11.02.87 : TT              : V1.6, SysVarSpace erweitert
 * 01.03.87 : TT              : V1.7, Exportliste f. Vars nun richtig
 * 09.05.87 : TT              : V1.8, Disk full wird erkannt
 * 23.05.87 : TT              : V1.9, layout-Kennungen fr REAL-Mode ausgewertet
 * 24.05.87 : TT              : Umstellung auf MOS
 * 06.06.87 : TT              : V1.10 Fehleranzeige, wenn Relocate() schiefgeht
 * 07.06.87 : TT              : V1.11 Init-Prg darf importieren
 * 11.06.87 : TT              : V1.12 Init-Mod erscheint nicht in ShModLst,
 *                              dafr endlich letztes Modul.
 * 14.06.87 : TT              : V1.13 ShModLst erweitert
 * 17.06.87 : TT              : V1.14 Nur ein Main-Mod geht jetzt auch richtig.
 * 19.06.87 : TT              : V1.15 Init-Aufrufe korrigiert
 * 21.07.87 : TT              : V1.16 Modnames: nur erste 8 Zeichen signifikant
 * 25.07.87 : TT              : V1.17 PDB um savedSSP,savedSR erweitert
 * 30.08.87 : TT              :       Dateinamen besser behandelt, Codename wird
 *                                    korrekt aus Modulcode geholt.
 * 09.09.87 : TT              : V1.19 Stacksize bestimmbar
 * 26.10.87 : TT              : V1.20 ShModLst: VarAd wird auch reloziert.
 * 02.11.87 : MCH / TT        : V1.21 Accessory-fhig, gend. Layout f. Init-Prg
 * 04.11.87 : TT              : V1.22 Mehrere (>2) Moduln linkbar.
 * 16.01.88 : TT              : V1.24 'sourceName' jetzt gro genug; ShModLst
 *                                    erweitert.
 * 22.01.88 : TT              : V1.25 Main-Mods werden auf ImpPath gesucht
 * 29.05.88 : TT              : V2.0  Mal eben den Optimierer eingebaut;
 *                                    Beim Linken v. 'MOS' o. 'MTP'-Moduln wird
 *                                    automatisch der 'TOS' o. 'TTP' Suffix
 *                                    verwendet.
 * 07.06.88 : TT              :       Variablen-Importe werden beim Optimieren
 *                                    auch bercksichtigt und ggf. ganze Module
 *                                    wegoptimiert.
 * 08.06.88 : TT              :       '-S' Option, um Shell zu linken (ProcSyms
 *                                    werden entfernt). ProcSyms werden mit kor-
 *                                    rigiert beim Optimieren.
 * 10.06.88 : TT              :       ProcSyms bei lokalen Procs werden nicht
 *                                    entfernt.
 * 27.06.88 : TT              : V2.1  Wegoptimierte Module werden auf Bildschirm
 *                                    vorm Relocate gelscht.
 * 14.07.88 : TT              : V2.2  Linken ohne Init-Mod ldt Hauptmod nicht
 *                                    mehr doppelt.
 * 29.07.88 : TT              :       Beim Linken von Mods mit und ohne Opti-
 *                                    mierdaten wird Fehler angezeigt.
 * 09.07.89 : TT              : V2.3  Relozieren etwas beschleunigt
 * 10.07.89 : TT              :       Beim TW.Open nun 'noForce' statt
 *                                    'forceCursor', weil sonst Lschen von opt.
 *                                    Modulen falsch war (liegt an GotoXY in
 *                                    TextWindows).
 *                                    Option f. 'noProcSyms' nun "-M" statt "-S".
 *                                    Optimierung bezgl. 'useCode' verbessert.
 * 06.08.89 : TT              : V2.4  In ShellMsg.MaxLinkMod kann Anzahl der
 *                                    linkbaren Module bestimmt werden.
 * 17.08.89 : TT              : V2.5  Fehler v. 2.4 (Bus-Error b. Reloc) behoben
 * 21.08.89 : TT              : V2.6  Neues Layout, neue ShortModList,
 *                                    $B- erlaubt Entfernung des Body beim
 *                                    selektiven Linken
 * 31.08.89 : TT              : V2.7  .MAC als Endung f. ACCs
 * 09.10.89 : TT              :       Proc-Verkettung und CodeStart (offset 42)
 *                                    werden bezgl. Diff korrig.
 * 19.02.90 : TT              :  2.8  Fastload-Bit wird immer gesetzt
 * 28.02.90 : TT              :       Real-Format wird bercksichtigt, Real-Form
 *                                    & ExtendedCode werden in PDB eingetragen,
 *                                    MM2LnkIO bernimmt Ein-/Ausgaben
 *                                    Mit Ctrl-Tastebeim Besttigen eines Real-
 *                                    Format-Fehlers wird dieser ignoriert.
 * 14.03.90 : TT              :  2.9  Var-Adr wird wieder richtig in ShModList
 *                                    eingetragen (BSSstart addiert);
 *                                    Deutlich krzere ShModLst wird erzeugt,
 *                                    da restliche Daten auch aus verbleibendem
 *                                    Header ermittelt werden knnen.
 * 16.05.90 : TT              :  2.10 CodeID wird in Code eingefgt
 * 16.07.90 : TT              :  2.11 Importliste wird mit bergeben; 1. Modul
 *                                    (meist M2Init) wird auch in ShModList
 *                                    eingetragen; mainMod werden markiert;
 *                                    Format der RealFormat-bergabe verndert.
 * 18.08.90 : TT              :       Output-Name ersetzt HomeSymbol
 * 04.09.90 : TT              :  2.12 PrgHeader-Flags ber Argzeile bestimmbar.
 * 07.10.90 : MCH             :  2.13 Anpassung an neues 'ShellMsg'
 * 11.10.90 : TT              :  2.14 Neue Real-Kennungen ausgewertet
 * 25.03.91 : TT              :  2.15 "-R" erlaubt Angabe der RelocTab-Gre
 * 01.03.91 : M.Seyfried (MS) :       RelRelocTab von 'MM2CLink' ausgewertet.
 * 25.04.91 : TT              :  2.16 Korrektur dialog/Relocate wg. ALLOCATEs,
 *                                    fhrte zu "Out of memory" bei 4 MB.
 * 03.05.91 : TT              :  2.17 Neue Fehlermeldung "Reloc. table overflow"
 * 01.08.91 : TT/MS           :  2.18 Korrektur f. MM2CLink v. MS
 * 16.10.91 : TT              :  2.19 Protokoll/MAP-File
 * 28.11.92 : TT              :  2.20 InitList-Output (Option -I)
 * 28.12.93 : TT              :  2.30 Konstanten hinter Code bercksichtigt, aber
 *                                    noch kein eigenes DATA-Segment.
 * 14.01.94 : TT              :  2.31 "-D" fr DATA-Segment-Erzeugung
 * 26.09.94 :                 :  2.32 s. Notiz zum Datum.
 * 09.01.95 : TT              :  2.33 Abfrage auf Proc-Lnge=0, damit keine End-
 *                                    losschleife beim Opt. entsteht (getProcs).
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, WORD, BYTE, ADR, TSIZE, LONGWORD, CAST;
 FROM SysTypes IMPORT PtrAnyLongType;
 FROM ArgCV     IMPORT PtrArgStr, InitArgCV;
 FROM Storage   IMPORT ALLOCATE, DEALLOCATE, MemAvail;
 FROM Strings   IMPORT Upper, Concat, Compare, Relation, Pos, Empty,
7StrEqual, Split, Assign, Copy, PosLen, String, Append;
 IMPORT FastStrings;
 FROM Files IMPORT Open, Create, Access, Close, Remove, FILE, ReplaceMode,
(State, ResetState;
 FROM Paths IMPORT SearchFile, ListPos;
 FROM PathEnv IMPORT ReplaceHome, HomePath;
 FROM PathCtrl IMPORT PathList;
 FROM Directory IMPORT MakeFullPath;
 FROM FileNames IMPORT SplitPath, SplitName, ConcatName, ConcatPath,
(FileSuffix;
 FROM Binary IMPORT ReadBytes, WriteBytes, Seek, SeekMode, FileSize, WriteBlock;
 FROM ShellMsg IMPORT ModPaths, ImpPaths, LLRange, ShellPath, LinkerParm;
 FROM MOSCtrl IMPORT PDB;
 FROM PrgCtrl IMPORT TermProcess;
 FROM MOSConfig IMPORT DftSfx, ImpSfx, MaxBlSize;
 IMPORT MOSGlobals, StrConv, Block;
 FROM MM2LnkIO IMPORT ClearEOP, Report, Prompt, InitOutput, VerboseOutput,
(Read, ReadString, WriteString, WriteMod,
(ClearMod, DiscardMods, ReportRealFormat, BeginWriting, ReportCodeLen,
(ReportLinkError, ReportIOError, ReportError, WritingOut, EndWriting,
(MaxSymbolLen, ModList, ModDesc, SymbolEntry, SymbolList, LongSet,
(OutputInitList, OutputSymbols;

 CONST PDBlayout = 4;
&version = '2.33';    (* Linker-Version *)
&CodeID = "Megamax Modula-2 V2";
 
 (*
!* Komprimierendes Verfahren beim nicht-vollstndigen Optimieren:
!*
!*   Um z.B. bei der Shell Speicher zu gewinnen, wird im Prinzip
!* der nach der Init-Phase nicht mehr bentigte Speicher freigegeben.
!* Das wren z.B:
!*   - die ShortModList, die nur vom Linker an ModBase
!*     bergeben wird;
!*   - alle Bodies und Hilfsroutinen, die nur vom Body
!*     benutzt und nicht exportiert werden.
!*
!*)
 
 VAR ok: BOOLEAN;
 
 
 PROCEDURE conc (a,b:ARRAY OF CHAR):String;
"VAR c:String;
"BEGIN
$concat (a,b,c,ok);
$RETURN c
"END conc;
 
 
 CONST
 
"SysVarSpace = 52;        (* layout,
>^basePage (f. ArgV),
>^modList (f. Loader),
>Anzahl der Eintrge in modLst,
>processState,
>BottomOfStack,
>TopOfStack,
>termState,
>resident,
>flags,
>TermProcs,
>^prev,
>16 reserved bytes *)
 
"ShModLstSpace = 14;      (* head0: ADDRESS;
>var0: ADDRESS;
>varlen0: LONGCARD;
>flags: BITSET; *)
 
(ESC = 33C;
 
%BadIndex = 1000;
'anykey = 0L;        (* Joker fuer Modul-Key *)
$DefOutSuf = '.PRG';    (* Suffix f. Output, wenn keiner angegeben *)
 
 VAR DefImpInSuf: ARRAY [0..2] OF CHAR; (* Suffix fuer Input Impl. Files *)
$DefPrgInSuf: ARRAY [0..2] OF CHAR; (* Suffix fuer Input Main Files *)
 
&ListMax: CARDINAL;   (* ehemals konstant 1000 *)
 
 TYPE
'tIndex = [0..BadIndex];  (* Index auf die Modul-Liste; BadIndex
Ckodiert Sonderfaelle: kein gueltiger
CIndex bzw. residentes Modul *)
%tModName = string;
 
%ptrModDesc = POINTER TO tModDesc;
%tModDesc = RECORD
2image: address;    (* ^Buffer beim Relozieren *)
1codeAd: address;    (* StartAdr im ROM *)
2varAd: address;    (* StartAdr der Variablen *)
0codeEnd: LONGCARD;   (* entspr. Beginn der DATAs *)
0dataEnd: LONGCARD;   (* Ende v. DATA+Code *)
/varStart: LONGCARD;   (* Start der Variablen im Modul *)
1varLen: LONGCARD;   (* Lnge der Variablen *)
3diff: longcard;   (* Laenge der entfernten Imp.Liste *)
4key: longcard;   (* Key dieses Moduls *)
1modlen: longcard;   (* Code-Lnge dieses Moduls *)
-sourcename: ARRAY [0..11] OF CHAR;
-symbolname: ARRAY [0..11] OF CHAR;
/codename: ARRAY [0..99] OF CHAR;
3name: ARRAY [0..39] OF CHAR;  (* ModulName *)
-symbolRoot: SymbolList;
0procSym: BOOLEAN;
/compopts: LongSet;
.mayRemove: BOOLEAN;    (* FALSE: Body keinesfalls wegoptimieren!*)
0mainMod: BOOLEAN;    (* FALSE: ist'n importiertes Modul *)
.mayCrunch: BOOLEAN;    (* TRUE: Proc-Length-Liste vorhanden *)
/crunched: BOOLEAN;
+varsExported: BOOLEAN;    (* TRUE: Vars werden v. anderen Mods importiert *)
0useCode: BOOLEAN;    (* FALSE: Modulcode wird nicht gebraucht *)
-bodyMarked: BOOLEAN;
1ImpLst: POINTER TO ARRAY tIndex OF tIndex; (* Liste der imp. Module *)
/ImpIndex: tIndex;                 (* Anzahl imp. Module *)
/finalIdx: tIndex;  (* Index fr ModBase *)
/END;
 
$ErrType   = (NotFound, BadFormat, BadVersion, NoSpace, TooManyMods,
1mustnotbeimpl, badlayout, readerr, relocerr, nooptimize,
1badReal);
0
(pLONG = POINTER TO LONGCARD;
 
 VAR
'ModLst: POINTER TO ARRAY tIndex OF tModDesc;  (* Liste der geladenen Module *)
%ModIndex: tIndex;                    (* ^ letzten Eintrag in ModLst *)
$UsedCodes: tIndex;                    (* Anzahl der verw. Modulcodes *)
&InitLst: POINTER TO ARRAY tIndex OF tIndex;    (* Liste der Init-Reihenfolge *)
$InitIndex: tIndex;                    (* ^ letzten Eintrag in InitLst *)
%InitIdx2: tIndex;                    (* ^ auf Second-Mod - InitLst *)
$UsedInits: tIndex;                    (* Anzahl der zu init. Bodies *)
 
&outName: string;                    (* Name des Codefiles *)
!DATAFileName: String;
#CodeSuffix: boolean;
"LoadingMain: BOOLEAN;
%IOResult,
*ior: INTEGER;                   (* ZW fuer IOResults *)
 
%LoadFile,                            (* geladene Module *)
&OutFile: file;                      (* zu schreibendes Codefile *)
 
%protocol: BOOLEAN;
%initList: BOOLEAN;
$symbolBuf: ADDRESS;
$symBufEnd: ADDRESS;
#symBufHead: ADDRESS;
#symBufSize: LONGINT;
#symBufFact: LONGCARD;
"
&DATALen: LONGINT;
$DATAstart,
%BSSstart: LONGCARD;                  (* Start-Adr fuer reloz. Vars *)
&CodeNow,                            (* ^ zu vergebenden Codeplatz *)
'VarNow: address;                   (* ^ zu vergebenden Varplatz *)
"ShModLstLen: Longcard;                  (* Ges.lnge der ModLst f.d. Loader *)
$stacksize: LONGCARD;
%initOffs: LONGCARD;                  (* rel. Adr. des Init-Einsprungs *)
 
&BodyLen: LONGCARD;                  (* testweise f. Lnge aller Bodies *)
"
&pRelTab,
&eRelTab,
%RelocTab: ADDRESS;
!firstRelVal : longcard;
"lastRelVal : longcard;
!
&dt_buf : RECORD   (* disk transfer buffer *)
1dum0 : ARRAY [1..13] OF word;
1flen : LONGCARD;
1dum1 : ARRAY [16..22] OF word
/END;
&
%singleMod: BOOLEAN;
%
)paths: PathList;
 
&optProcs: BOOLEAN;  (* TRUE: Procs optimieren *)
&noHeader: BOOLEAN;  (* TRUE: Header aus Moduln entfernen *)
$noShModLst: BOOLEAN;  (* TRUE: ShortModList aus Moduln entfernen *)
$noProcSyms: BOOLEAN;  (* TRUE: ProcSymbols vor Prozeduren entfernen *)
 
"extendedCode: BOOLEAN;
&realForm: CARDINAL;
 
#HeaderFlags: BITSET;
 
 
 PROCEDURE fputm ( f:file; VAR p:ARRAY OF word; c:LONGCARD );
"BEGIN
$WriteBytes (f, ADR (p), c);
"END fputm;
 
 
 PROCEDURE fput ( f:file; REF p: ARRAY OF BYTE );
"BEGIN
$IF NOT ODD (HIGH (p)) THEN HALT END;
$WriteBlock (f, p);
"END fput;
 
 
 PROCEDURE hasSuffix (s: string): boolean;
"VAR p: cardinal;
"BEGIN
$RETURN length (FileSuffix (s)) > 0;
$(* in den letzten 4 Zeichen von s muss ein Punkt stehen! *)
"END hasSuffix;
 
 
 PROCEDURE entry (Index: address; Displacement: LONGCARD): LongCard;
"(*** Long-Peek mit Displacement ***)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(MOVE.L  (A0),D0
$END
"END entry;
"(*$L=*)
 
 
 PROCEDURE enter (Index: address; Displacement: cardinal; value: LongCard);
"(*** Long-Poke mit Displacement ***)
"VAR p: POINTER TO LongCard;
"BEGIN
$p:= Index + address (long (Displacement));
$p^:= value;
"END enter;
 
 
 PROCEDURE error (client, impmod: ARRAY OF CHAR; t: ErrType);
 
"(*** Fehleranzeige auf dem Bildschirm; danach zurueck zum Aufrufer ***)
"
"VAR msg: String;
"
"BEGIN
$CASE t OF
+badReal: msg:= 'Different real-formats specified'; client[0]:= 0C |
(badversion: msg:= 'Wrong module version' |
)badformat: msg:= 'Wrong module format'; client[0]:= 0C |
*notfound: msg:= 'Module not found'; client[0]:= 0C |
+readerr: msg:= 'File is damaged'; client[0]:= 0C |
+nospace: msg:= 'Out of memory'; client[0]:= 0C |
'toomanymods: msg:= 'Too many modules (enlarge "max. Module")'; client[0]:= 0C|
%mustnotbeimpl: msg:= 'Init-module must be program module'; client[0]:= 0C|
)badlayout: msg:= 'Bad module layout'; client[0]:= 0C|
*relocerr: msg:= 'Error in relocation list'; client[0]:= 0C|
(nooptimize: msg:= 'Old module layout - may not be optimized'; client[0]:= 0C|
$END; (* of case *)
$ReportLinkError (impmod, client, msg)
"END error;
 
 
 PROCEDURE MyError (ior: integer);
"BEGIN
$ReportIOError (ior)
"END MyError;
 
 PROCEDURE RelError0 (REF s: ARRAY OF CHAR);
"BEGIN
$ReportError (s);
$Remove (outfile);
$TermProcess (MOSGlobals.OutOfMemory)
"END RelError0;
 
 PROCEDURE RelError (internalErr: BOOLEAN);
"VAR s: String;
"BEGIN
$s:= 'Out of memory!';
$IF internalErr THEN Append (' (internal error!)', s, ok) END;
$RelError0 (s);
"END RelError;
 
 PROCEDURE RelError2;
"BEGIN
$RelError0 ('Relocation table overflow! Use "-R" option.');
"END RelError2;
 
 
 PROCEDURE GetStr (VAR p: address): tModName;
"(* String aus der Importliste holen *)
"VAR s: tModName;
"BEGIN
$ASSEMBLER
,MOVE.L  p(A6),A1       ;Adresse von p
,MOVE.L  (A1),A2        ;Wert von p
,LEA     s(A6),A0
%!RE13  MOVE.B  (A2)+,D2       ;Zeichen holen
,CMPI.B  #$FE,D2
,BCC     RE12           ; -> Endmarke
,MOVE.B  D2,(A0)+
,BRA     RE13
%!RE12  BNE     RE14
,ADDQ.L  #1,A2
%!RE14  CLR.B   (A0)+
,MOVE.L  A2,(A1)        ;p hochsetzen
$END;
$RETURN s
"END GetStr;
 
 PROCEDURE SkipStr (VAR p: address);
"(* String aus der Importliste berspringen *)
"(*$L-*)
"BEGIN
$ASSEMBLER
,MOVE.L  -(A3),A1       ;Adresse von p
,MOVE.L  (A1),A2        ;Wert von p
%!RE13  CMPI.B  #$FF,(A2)+
,BNE     RE13
,MOVE.L  A2,(A1)        ;p hochsetzen
$END;
"END SkipStr;
"(*$L=*)
 
 PROCEDURE SkipImpList (VAR p: address);
"(* Importliste berspringen *)
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0),A1
%R6 MOVE.W  (A1)+,D0      ;imp. ItemNr
(BEQ     R5            ;fertig mit diesem Import
(MOVE.L  (A1)+,D1      ;importiertes Item
(BRA     R6
%R5 MOVE.L  A1,(A0)
$END;
"END SkipImpList;
"(*$L=*)
 
 
 PROCEDURE SplitFileName ( REF Source: ARRAY OF CHAR; VAR Name,sfx: ARRAY OF Char );
"VAR dummy: MOSGlobals.PathStr;
"BEGIN
$SplitPath (source, dummy, name);
$SplitName (name, name, sfx)
"END SplitFileName;
 
 
 
 PROCEDURE moveMem (olo, ohi, nlo: LONGCARD);
"BEGIN
$ASSEMBLER
(MOVE.L  olo(A6),A0
(MOVE.L  ohi(A6),A1
(MOVE.L  nlo(A6),A2
&L MOVE.W  (A0)+,(A2)+
(CMPA.L  A1,A0
(BCS     L
$END
"END moveMem;
 
 
 PROCEDURE isCLinkMod (modidx: CARDINAL): BOOLEAN;
 (*
!* Wert: TRUE, wenn Modul von 'MM2CLink' erzeugt wurde.
!*)
"BEGIN
$RETURN entry (ModLst^ [modidx].image, 50) # 0;
"END isCLinkMod;
 
 
 PROCEDURE Optimize;
 
"TYPE RelocList = POINTER TO RECORD link: LONGCARD; procAddr: LONGCARD END;
'ProcLenEntry = RECORD start: LONGCARD; len: LONGCARD END;
'ProcLenList = POINTER TO ProcLenEntry;
'ImportTable = POINTER TO RECORD item: CARDINAL; procAddr: LONGCARD END;
 
"(*------------- Aufbau der Listen der relativen Referenzen: ----------
#*
#* In TC-Objektdateien kommen relative Referenzen sehr hufig vor. Diese
#* mssen beim Optimierer sowohl beim Markieren der Procs, als auch bei der
#* Korrektur der Referenzen bercksichtigt werden.
#* TC unterscheidet zwischen 2 Byte (PCRelWordRef) und 4 Byte (PCRelLongRef)
#* relativen Referenzen.
#* Damit die relativen Referenzen durch den Optimierer bercksichtigt werden,
#* gibt es fr die 2 byte und 4 byte relativen Referenzen zwei Listen. Der
#* Zeiger auf die erste Liste (2 byte relative Refs) steht im Modulheader bei
#* Offset 50:
#*
#* WordRelRelocListOffset = entry (image, 50)
#*
#* Der Zeiger auf die zweite Liste (4 byte relative Refs) steht unmittelbar
#* vor der ersten Liste:
#*
#* LongRelRelocListOffset = entry (image, WordRelRelocListOffset - 4)
#*
#* In den relativen Referenzlisten steht immer zuerst die Adresse, auf
#* die sich die Referenz bezieht (Entryadresse). Dann kommt eine Liste von
#* 2 byte bzw. 4 byte Werten, die die Lage der relativen Referenzen relativ
#* zu der Entryadresse angeben. Dabei bedeuten positive Werte, da die
#* Referenzadresse vor der Entryadresse liegt. Um die Referenzadresse relativ
#* zum Modulanfang zu erhalten, sind also die Werte von der Entryadresse zu
#* subtrahieren! Die 2 byte bzw. 4 byte Werte sind absteigend geordnet.
#*
#* RelRelocList = { 4 byte Adresse, relativ zum Modulanfang
#*                  { 2/4 byte Referenzadresse, relativ zu obiger Adresse
#*                  } 2/4 byte Endmarke $0000
#*                } 4 byte Endmarke $00000000
#*
#* Zugriffe auf diese Refernzliste erfolgen mit Hilfe der folgenden
#* Zugriffskennung und fogenden Prozeduren:
#*)
'RelRelocList  = RECORD
9pEntryAddr : POINTER TO LONGCARD; (* ^ Entryadresse *)
9pRelocList : PtrAnyLongType;      (* ^ RelRelocList *)
9long       : BOOLEAN;             (* 4/2 byte Addr  *)
7END;
7
"PROCEDURE RelRefValue (REF hdl: RelRelocList): LONGINT; FORWARD;
"PROCEDURE FirstRelRefValue (VAR hdl: RelRelocList): LONGINT; FORWARD;
"PROCEDURE NextRelRefValue (VAR hdl: RelRelocList): LONGINT; FORWARD;
 
"PROCEDURE NextRelRelocEntry (REF hdl: RelRelocList): RelRelocList;
"(*
#* Eingabe: Zugriffskennung auf relative Referenzliste
#* Wert   : Zugriffskennung auf den nchsten Eintrag in der relativen
#*          Referenzliste.
#*)
$VAR dummy: LONGINT;
(newHdl: RelRelocList;
$BEGIN
&newHdl:= hdl;
&(* restliche Refs. berspringen *)
&IF RelRefValue (newHdl) # 0 THEN
(WHILE NextRelRefValue (newHdl) # 0 DO END;
&END;
&WITH newHdl DO
((* Endekennung berspringen *)
(IF long THEN
*pEntryAddr:= CAST (ADDRESS, pRelocList) + 4;
(ELSE
*pEntryAddr:= CAST (ADDRESS, pRelocList) + 2;
(END;
(IF pEntryAddr^ # 0 THEN
*(* newHdl schon mal auf erste Ref. setzen *)
*dummy:= FirstRelRefValue (newHdl);
*IF pEntryAddr^ = 1 THEN
,(* ausgeketteten Eintrag berspringen *)
,RETURN NextRelRelocEntry (newHdl);
*END;
(END;
&END;
&RETURN newHdl;
$END NextRelRelocEntry;
$
"PROCEDURE FirstRelRelocEntry (image: ADDRESS;
@longList: BOOLEAN): RelRelocList;
"(*
#* Eingabe: image-Adresse; longList = TRUE => Liste mit 4 byte Werten, sonst 2
#* Wert   : Zugriffskennung auf Liste der relativen Referenzen
#*)
$VAR hdl: RelRelocList;
(RelRelocListOffset: LONGCARD;
(dummy: LONGINT;
$BEGIN
&hdl.pEntryAddr:= NIL; (* Initialisierung *)
&RelRelocListOffset:= entry (image, 50);
&IF RelRelocListOffset = 0 THEN RETURN hdl END;
&IF longList THEN
(RelRelocListOffset:= entry (image, RelRelocListOffset - 4);
(IF RelRelocListOffset = 0 THEN RETURN hdl END;
&END;
&WITH hdl DO
(long:= longList;
(pEntryAddr:= image + RelRelocListOffset;
(IF pEntryAddr^ # 0 THEN
*(* hdl schon mal auf erste Ref. setzen *)
*dummy:= FirstRelRefValue (hdl);
*IF pEntryAddr^ = 1 THEN
,(* ausgeketteten Eintrag berspringen *)
,RETURN NextRelRelocEntry (hdl);
*END;
(END;
&END; (* WITH *)
&RETURN hdl;
$END FirstRelRelocEntry;
$
"PROCEDURE DisableRelRelocEntry (REF hdl: RelRelocList);
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Effekt : Der aktuelle Eintrag in der Refernzliste wird ausgekettet
#*)
$BEGIN
&hdl.pEntryAddr^:= 1;
$END DisableRelRelocEntry;
$
"PROCEDURE EmptyRelRelocEntry (REF hdl: RelRelocList): BOOLEAN;
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Wert   : TRUE, wenn keine weiteren Daten in der Liste
#*)
$BEGIN
&WITH hdl DO
(RETURN (pEntryAddr = NIL) OR (pEntryAddr^ = 0);
&END;
$END EmptyRelRelocEntry;
$
"PROCEDURE EntryOffset (REF hdl: RelRelocList): LONGCARD;
"(*
#* Eingabe: Zugriffskennung auf RelRelocList
#* Wert   : Entryadresse relativ zum Modulanfang
#*)
$BEGIN
&RETURN hdl.pEntryAddr^
$END EntryOffset;
$
"PROCEDURE DecEntryOffset (REF hdl: RelRelocList; diff: LONGCARD);
"(*
#* Effekt: Von der aktuellen Entryadresse wird diff abgezogen.
#*)
$BEGIN
&DEC (hdl.pEntryAddr^, diff);
$END DecEntryOffset;
 
"PROCEDURE RelRefValue (REF hdl: RelRelocList): LONGINT;
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Wert   : Adresse der aktuellen Referenz auf EntryOffset (hdl) relativ zu
#*          EntryOffset (hdl) oder 0 nach letztem Eintrag
#*)
$BEGIN
&WITH hdl DO
(IF long THEN
*RETURN pRelocList^.li;
(ELSE
*RETURN pRelocList^.i1;
(END;
&END;
$END RelRefValue;
$
"PROCEDURE RelRefOffset (REF hdl: RelRelocList): LONGCARD;
"(*
#* wie oben, nur relativ zum Modulanfang.
#*)
$VAR offset: LONGINT;
$BEGIN
&offset:= RelRefValue (hdl);
&IF (offset = 0) OR (offset = 1) THEN
(RETURN offset;
&ELSE
(RETURN VAL (LONGCARD, VAL (LONGINT, EntryOffset (hdl)) - offset);
&END;
$END RelRefOffset;
$
"PROCEDURE DecRelRefOffset (REF hdl: RelRelocList;
Aimage: ADDRESS;
Aoffset, diff: LONGINT);
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Effekt : Die Adresse der aktuellen Referenz auf EntryOffset (hdl)
#*          wird um diff erniedrigt.
#*)
$VAR RefImageAddr: PtrAnyLongType;
$BEGIN
&WITH hdl DO
(IF long THEN
*RefImageAddr:= image + CAST (ADDRESS, CAST (LONGINT, pEntryAddr^) -
ApRelocList^.li + offset);
*DEC (RefImageAddr^.li, diff);
*DEC (pRelocList^.li, diff);
(ELSE
*RefImageAddr:= image + CAST (ADDRESS, CAST (LONGINT, pEntryAddr^) -
AVAL (LONGINT, pRelocList^.i1) + offset);
*DEC (RefImageAddr^.i1, diff);
*DEC (pRelocList^.i1, diff);
(END;
&END;
$END DecRelRefOffset;
$
"PROCEDURE DisableRelRef (REF hdl: RelRelocList);
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Effekt : Die aktuelle Referenz wird aus der Liste ausgekettet
#*)
$BEGIN
&WITH hdl DO
(IF long THEN
*pRelocList^.li:= 1;
(ELSE
*pRelocList^.i1:= 1;
(END;
&END;
$END DisableRelRef;
$
"PROCEDURE FirstRelRefValue (VAR hdl: RelRelocList): LONGINT;
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Effekt : Zeiger in Zugriffskennung wird auf erste Referenz gesetzt.
#* Wert   : Adresse der ersten Referenz auf EntryOffset (hdl) relativ zu
#*          EntryOffset (hdl) oder 0 bei leerer Liste
#*)
$VAR offset: LONGINT;
$BEGIN
&WITH hdl DO
(pRelocList:= CAST (ADDRESS, pEntryAddr) + 4;
&END;
&offset:= RelRefValue (hdl);
&IF offset = 1 THEN
((* ausgekettete Referenzen berspringen *)
(RETURN NextRelRefValue (hdl);
&ELSE
(RETURN offset;
&END;
$END FirstRelRefValue;
$
"PROCEDURE FirstRelRefOffset (VAR hdl: RelRelocList): LONGCARD;
"(*
#* wie oben, nur relativ zum Modulanfang
#*)
$VAR dummy: LONGINT;
$BEGIN
&dummy:= FirstRelRefValue (hdl);
&RETURN RelRefOffset (hdl);
$END FirstRelRefOffset;
$
"PROCEDURE NextRelRefValue (VAR hdl: RelRelocList): LONGINT;
"(*
#* Eingabe: Zugriffskennung auf Referenzliste
#* Effekt : Zeiger in Zugriffskennung wird auf nchste Refernz gesetzt
#* Wert   : Adresse der ncksten Refernz auf EntryOffset (hdl) relativ zu
#*          EntryOffset (hdl) oder 0 bei Ende der Liste
#*)
$VAR offset: LONGINT;
$BEGIN
&WITH hdl DO
(IF long THEN
*INC (pRelocList, 4);
(ELSE
*INC (pRelocList, 2);
(END;
&END;
&offset:= RelRefValue (hdl);
&IF offset = 1 THEN
((* ausgekettete Referenzen berspringen *)
(RETURN NextRelRefValue (hdl);
&ELSE
(RETURN offset;
&END;
$END NextRelRefValue;
 
"PROCEDURE NextRelRefOffset (VAR hdl: RelRelocList): LONGCARD;
"(*
#* wie oben, nur relativ zum Modulanfang
#*)
$VAR dummy: LONGINT;
$BEGIN
&dummy:= NextRelRefValue (hdl);
&RETURN RelRefOffset (hdl);
$END NextRelRefOffset;
$
"(*-----------------------------------------------------------------------*)
$
"PROCEDURE pStart (p: ProcLenList): LONGCARD;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0),D0         ; p^.start
(ANDI.L  #$00FFFFFF,D0
&END;
$END pStart;
$(*$L=*)
 
"PROCEDURE pEnd (p: ProcLenList): LONGCARD;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0)+,D0        ; p^.start
(ANDI.L  #$00FFFFFF,D0
(ADD.L   (A0),D0         ; p^.len
&END;
$END pEnd;
$(*$L=*)
 
"PROCEDURE mark (p: ProcLenList; n: CARDINAL);
$(* n: 1='lokal verwendet', 2='von anderem Modul importiert' *)
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.B  D0,(A0)         ; p^.start
&END;
$END mark;
$(*$L=*)
 
"PROCEDURE marked (p: ProcLenList): BOOLEAN;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(TST.B   (A0)            ; p^.start
(SNE     D0
(ANDI    #1,D0
&END;
$END marked;
$(*$L=*)
 
"PROCEDURE markedValue (p: ProcLenList): CARDINAL;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A0
(CLR     D0
(MOVE.B  (A0),D0         ; p^.start
&END;
$END markedValue;
$(*$L=*)
 
"PROCEDURE between (v, lo, hi: LONGCARD): BOOLEAN;
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),D0  ; hi
(MOVE.L  -(A3),D1  ; lo
(MOVE.L  -(A3),D2  ; v
(CMP.L   D1,D2
(BCS     fals
(CMP.L   D0,D2
(BCC     fals
(MOVEQ   #1,D0
(RTS
&fals
(CLR     D0
&END;
$END between;
$(*$L=*)
 
"PROCEDURE advance (p: LONGCARD; VAR prl: ProcLenList);
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  -(A3),A2        ; ADR (prl)
(MOVE.L  -(A3),-(A7)     ; p
(MOVE.L  (A2),A1
&lupo
(MOVE.L  (A7),(A3)+
(MOVE.L  A1,(A3)+
(BSR     pStart/
(MOVE.L  D0,(A3)+
(MOVE.L  A1,(A3)+
(BSR     pEnd/
(MOVE.L  D0,(A3)+
(BSR     between/
(BNE     ende
(ADDQ.L  #8,A1
(BRA     lupo
&ende
(MOVE.L  A1,(A2)
(ADDQ.L  #4,A7
&END
&(*
&WHILE NOT between (p, pStart (prl), pEnd (prl)) DO
(INC (prl, SHORT (SIZE (prl^)))
&END;
&*)
$END advance;
$(*$L=*)
 
"PROCEDURE findListEntry (idx: tIndex; ad: LONGCARD; VAR prl: ProcLenList);
$BEGIN
&WITH ModLst^ [idx] DO
(prl:= image + entry (image, 38)
&END;
&advance (ad, prl)
$END findListEntry;
 
"PROCEDURE markCalls (modidx: tIndex; start, ende: LONGCARD);
 
$PROCEDURE MarkRelRefProcs (image: ADDRESS; long: BOOLEAN);
$(*
%* Eingabe: Image-Adresse des betreffenden Moduls; long = TRUE => 4 byte
%*          relative Adressen.
%* Effekt:  Markiert Prozeduren, die relativ referenziert werden.
%*)
&VAR
*rRelocL: RelRelocList;
*procAddr: LONGCARD;
*prl: ProcLenList;
*link: LONGCARD;
*
&BEGIN
((* Kennung fr RelRelocList *)
(rRelocL:= FirstRelRelocEntry (image, long);
(prl:= image + entry (image, 38); (* Zeiger auf Prozedurlngenliste *)
(WHILE NOT EmptyRelRelocEntry (rRelocL) DO
*(* relative Referenzliste abarbeiten *)
*procAddr:= EntryOffset (rRelocL);
*IF procAddr < entry (image, 6) THEN (* Proc, nicht Var oder Body *)
,advance (procAddr, prl);
,link:= FirstRelRefOffset (rRelocL);
,LOOP
.IF link = 0L THEN
0EXIT
.ELSIF between (link, start, ende) THEN
0IF ~marked (prl) THEN
2mark (prl,1);
2markCalls (modidx, pStart (prl), pEnd (prl));
0END;
0EXIT;
.END;
.link:= NextRelRefOffset (rRelocL);
,END
*END;
*rRelocL:= NextRelRelocEntry (rRelocL);
(END;
&END MarkRelRefProcs;
 
$VAR
&image, impImg: ADDRESS;
&pra: RelocList;
&prl: ProcLenList;
&expl, pri: ADDRESS;
&imptbl: ImportTable;
&link: LONGCARD;
&idx, impIdx: tIndex;
 
$BEGIN
&IF start >= ModLst^ [modidx].codeEnd THEN
((* Dies ist keine Proc sondern wahrscheinlich eine Const -> Abbruch *)
(RETURN
&END;
&
&image:= ModLst^ [modidx].image;
&
&IF ModLst^ [modidx].mayCrunch THEN
((*
)* Nach lokalen Procs/Consts suchen, die vom Aufrufer (start..ende)
)* benutzt werden:
)*)
(pra:= image + entry (image, 22); (* Liste mit Proc-Adr + Aufrufern *)
(prl:= image + entry (image, 38); (* Liste aller Proc-Adr./Lngen *)
(WHILE pra^.link # NIL DO (* alle lokalen Procs/Consts durchgehen *)
*IF pra^.procAddr < ModLst^ [modidx].dataEnd THEN
,(* wir haben eine Proc o. Const *)
,advance (pra^.procAddr, prl); (* Const-/Proc-Lnge (prl) suchen *)
,link:= pra^.link;
,LOOP
.(* Nun prfen, ob diese Proc/Const vom Aufrufer benutzt wird,
/* indem geprft wird, ob die Adr. dieser Proc/Const im Bereich
/* des Aufrufers (start..ende) einzutragen ist. *)
.IF link = 0L THEN
0EXIT (* Ende der Benutzerliste -> nicht gefunden *)
.ELSIF between (link, start, ende) THEN
0(* Gefunden: Die Proc/Const wird vom Aufrufer benutzt *)
0IF ~marked (prl) THEN
2mark (prl,1);
2(* Falls dies eine Proc ist, auch die hiervon benutzten
3* Consts/Procs markieren (Prfung, ob's eine Proc ist,
3* geschieht zu Beginn v. markCalls) *)
2markCalls (modidx, pStart (prl), pEnd (prl))
0END;
0EXIT
.END;
.link:= entry (image, link)
,END
*END;
*INC (pra, 8)
(END;
((*----------- relativ referenzierte Procs markieren --------------*)
(MarkRelRefProcs (image, FALSE); (* fr 2 byte relative Referenzen *)
(MarkRelRefProcs (image, TRUE);  (* fr 4 byte relative Referenzen *)
((*----------------------------------------------------------------*)
&END;
&
&(* Importierte Procs abarbeiten *)
&pri:= image + entry (image, 14);
&FOR idx:= 1 TO ModLst^ [modidx].ImpIndex DO
((* jedes importierte Modul *)
(impIdx:= ModLst^ [modidx].ImpLst^[idx];
(INC (pri, 4); (* key *)
(skipStr (pri);  (* import-Name *)
(WHILE CARDINAL (pri^) # 0 DO
*(* jedes importierte Item *)
*IF ModLst^ [impIdx].mayCrunch THEN
,link:= entry (pri, 2);
,LOOP
.(* jeder Import des Items *)
.IF link = 0L THEN
0EXIT
.ELSIF between (link, start, ende) THEN
0(* Item in importiertem Modul finden *)
0impImg:= ModLst^ [impIdx].image;
0expl:= impImg + entry (impImg, 18);
0WHILE CARDINAL (expl^) # 0 DO
2IF expl^ = pri^ THEN
4(* Item gefunden *)
4IF entry (expl, 2) < ModLst^ [impIdx].dataEnd THEN
6(* Proc/Const *)
6findListEntry (impIdx, entry (expl, 2), prl);
6IF ~marked (prl) THEN
8mark (prl,2);
8markCalls (impIdx, pStart (prl), pEnd (prl))
6ELSE
8mark (prl,2);  (* als importiert markieren *)
6END
4ELSE
6ModLst^ [impIdx].varsExported:= TRUE
4END;
4(* Jetzt gleich den 'Body' d. imp. Mods 'usen' *)
4WITH ModLst^ [impIdx] DO
6IF NOT bodyMarked THEN
8(* wenn bisher unbenutzt, nun seine Calls markieren *)
8useCode:= TRUE;
8bodyMarked:= TRUE;
8markCalls (impIdx, entry (image, 6) (*body*), codeEnd)
6END
4END;
4EXIT
2ELSE
4INC (expl, 6)
2END
0END;
0HALT (* ! Item nicht gefunden *)
.END;
.link:= entry (image, link)
,END; (* LOOP *)
*END; (* IF mayCrunch *)
*INC (pri, 6)
(END; (* WHILE pri^ # 0 *)
(INC (pri, 2)
&END (* FOR *)
 
$END markCalls;
"(*$D-*)
 
 
"PROCEDURE moveCode (modIdx: tIndex; lastEnde, start, ende, newStart: LONGCARD);
 
$PROCEDURE CorrectRelRefs (image: ADDRESS; long: BOOLEAN);
$(*
%* Eingabe: Image-Adresse; long => 4 byte Werte korrigieren
%* Effekt:  Die relativen Referenzen werden korrigiert.
%*)
&VAR
*rRelocL: RelRelocList;
*procAddr: LONGCARD;
*link    : LONGCARD;
*offset  : LONGCARD;
*diff    : LONGCARD;
 
&BEGIN
(diff:= start - lastEnde;  (* um diesen Wert werden Refs korrigiert *)
(offset:= lastEnde - newStart; (* auf link zu addierender Offset *)
(rRelocL:= FirstRelRelocEntry (image, long); (* Zugriffskennung *)
(WHILE NOT EmptyRelRelocEntry (rRelocL) DO
*(* Liste mit relativen Referenzen abarbeiten *)
*procAddr:= EntryOffset (rRelocL); (* Entryadresse merken *)
*IF between (procAddr, lastEnde, start) THEN
,(* Prozedur wird wegoptimiert => keine Referenzen auf diese Proc *)
,DisableRelRelocEntry (rRelocL);
*ELSE
,IF diff > 0 THEN
.link:= FirstRelRefOffset (rRelocL);
.(* Die Referenzen sind nach Codeadressen aufsteigend geordnet!!*)
.IF procAddr < newStart THEN
0WHILE (link # 0) AND (link < newStart) DO
2(* Refs, die nicht ber wegoptimierte Procs gehen berspr. *)
2link:= NextRelRefOffset (rRelocL);
0END;
0WHILE (link # 0) AND (link + offset < start) DO
2(* Refs von wegoptimierter Proc disablen *)
2DisableRelRef (rRelocL);
2link:= NextRelRefOffset (rRelocL);
0END;
0WHILE (link # 0) DO
2(* restliche Refs gehen alle ber wegoptimierte Proc *)
2(* Refs von hheren Adr. zu niedrigeren => diff addieren *)
2DecRelRefOffset (rRelocL, image,
Coffset, - VAL (LONGINT, diff));
2link:= NextRelRefOffset (rRelocL);
0END;
.ELSIF procAddr >= start THEN
0WHILE (link # 0) AND (link < lastEnde) DO
2(* Refs ber wegoptimierte Proc korrigieren *)
2DecRelRefOffset (rRelocL, image,
C- VAL (LONGINT, offset), diff);
2link:= NextRelRefOffset (rRelocL);
0END;
0WHILE (link # 0) AND (link < start) DO
2(* Refs von wegoptimierter Proc disablen *)
2DisableRelRef (rRelocL);
2link:= NextRelRefOffset (rRelocL);
0END;
0(* restliche Refs gehen nicht ber wegoptimierte Proc *)
.ELSE
0HALT; (* reloc-error *)
.END; (* IF *)
,END; (* IF *)
,IF between (procAddr, start, ende) THEN
.DecEntryOffset (rRelocL, offset + diff);
,END; (* IF *)
*END; (* IF *)
*rRelocL:= NextRelRelocEntry (rRelocL);
(END (* WHILE *);
&END CorrectRelRefs;
 
$VAR pri, image: ADDRESS;
(link, offs: LONGCARD;
(p, plink: POINTER TO LONGCARD;
(pra: RelocList;
(idx: tIndex;
(expl: ImportTable;
 
$PROCEDURE correct (VAR n: LONGCARD);
&(*$L-*)
&BEGIN
(ASSEMBLER
.MOVE.L  D2,A0
.MOVE.L  -(A3),A1
.MOVE.L  offs(A0),D0
.SUB.L   D0,(A1)
(END
&END correct;
&(*$L=*)
 
$BEGIN
&ModLst^ [modIdx].crunched:= TRUE;
&image:= ModLst^ [modIdx].image;
&offs:= start - newStart;
&IF offs = 0L THEN HALT END;
&
&(*-------------- relative Relozierliste korrigieren ----------------*)
&CorrectRelRefs (image, FALSE); (* Korrektur fr 2 byte Werte *)
&CorrectRelRefs (image, TRUE);  (* Korrektur fr 4 byte Werte *)
&(*------------------------------------------------------------------*)
&
&(* Relozierliste korrigieren *)
&pra:= image + entry (image, 22);
&WHILE pra^.link # NIL DO
(IF pra^.procAddr # 0L THEN
*IF between (pra^.procAddr, newstart, ende) THEN
,IF pra^.procAddr < start THEN
.pra^.procAddr:= 0  (* Diese Proc nicht mehr relozieren ! *)
,ELSE
.correct (pra^.procAddr)
,END
*END;
*plink:= ADR (pra^.link);
*LOOP
,link:= plink^;
,IF link > entry (image, 22) THEN HALT (* reloc-error *) END;
,IF link < newstart THEN EXIT END;
,IF link < ende THEN
.IF link < start THEN
0WHILE link >= newstart DO
2link:= entry (image, link)
0END;
0(* wegoptimierte Procs aus Ref-Liste nehmen *)
0IF (link = 0L) & (plink = ADR (pra^.link)) THEN
2pra^.procAddr:= 0  (* ganze Ref-Liste auslassen *)
0ELSE
2plink^:= link;  (* unbenutze Ref auslinken *)
0END;
0EXIT
.ELSE
0correct (plink^)
.END
,END;
,plink:= image + link
*END;
(END; (* IF pra^.procAddr # 0L *)
(INC (pra, 8)
&END (* WHILE *);
&
&(* Importliste korrigieren *)
&pri:= image + entry (image, 14);
&FOR idx:= 1 TO ModLst^ [modidx].ImpIndex DO
((* jedes importierte Modul *)
(INC (pri, 4); (* key *)
(skipStr (pri);  (* import-Name *)
(WHILE CARDINAL (pri^) # 0 DO
*(* jedes imp. Item *)
*plink:= pri + 2L;
*LOOP
,link:= plink^;
,IF link > entry (image, 22) THEN HALT (* reloc-error *) END;
,IF link < newstart THEN EXIT END;
,IF link < ende THEN
.IF link < start THEN
0WHILE link >= newstart DO
2link:= entry (image, link)
0END;
0(* wegoptimierte Procs aus Ref-Liste nehmen *)
0plink^:= link;  (* unbenutze Ref auslinken *)
0EXIT
.ELSE
0correct (plink^)
.END
,END;
,plink:= image + link
*END;
*INC (pri, 6)
(END;
(INC (pri, 2)
&END; (* FOR idx *)
&
&(* Exportliste korrigieren *)
&expl:= image + entry (image, 18);
&WHILE expl^.item # 0 DO
(IF between (expl^.procAddr, newstart, ende) THEN
*IF expl^.procAddr < start THEN
,expl^.procAddr:= 0
*ELSE
,correct (expl^.procAddr)
*END
(END;
(INC (expl, 6)
&END (* WHILE *);
&
&(* Liste der Prozedurnamen korrigieren *)
&IF ModLst^ [modIdx].procSym THEN
(link:= entry (image, 6);
(LOOP
*plink:= image + link - 4L;
*link:= plink^;
*IF link > entry (image, 22) THEN HALT (* reloc-error *)
*ELSIF link < newStart THEN EXIT
*ELSIF link < ende THEN
,IF link < start THEN
.WHILE link >= newStart DO
0link:= entry (image, link-4L)
.END;
.(* wegoptimierte Procs aus Liste nehmen *)
.plink^:= link;
.EXIT
,ELSE
.correct (plink^)
,END
*END
(END
&END;
&
&(* Rumpfeinsprung korrigieren *)
&IF between (entry (image, 6), start, ende) THEN
(p:= image + 6L;
(correct (p^)
&END;
&
&(* Code verschieben *)
&moveMem (image + start, image + ende, image + newStart)
$END moveCode;
 
 
"PROCEDURE moveProcs (modIdx: tIndex);
 
$VAR pri, imag: LONGCARD;
(lastFree, freeStart, usedStart, currEnd: ADDRESS;
(prl: ProcLenList;
(lastEnd: ADDRESS;
(offset: LONGCARD;
(hadSyms, remProcSym, procsExported, endOfLenList: BOOLEAN;
(symbol: SymbolList;
(body_prl: ProcLenEntry;
(ch: CHAR;
 
$PROCEDURE getProc (at: LONGCARD; VAR prl: ProcLenList): BOOLEAN;
&(* stellt "prl" auf die Lngen-Info, die zur Proc bei "at" gehrt *)
&(*$L-*)
&BEGIN
(ASSEMBLER
0MOVE.L  -(A3),-(A7)
0MOVE.L  D2,A2
0MOVE.L  -(A3),D2
0
0; der Body erscheint nicht in der Lngenliste, deswegen
0; hierfr zuerst eine Sonderabfrage:
0LEA     body_prl(A2),A1
0MOVE.L  A1,(A3)+
0BSR     pStart/
0CMP.L   D0,D2           ; 'at' = body_prl.start?
0BEQ     tr
0
0; ansonsten in Lngenliste vom Modul suchen
0MOVE.L  imag(A2),A0
0MOVE.L  A0,A1
0ADDA.L  38(A1),A1
0
.lupo
0MOVE.L  A1,(A3)+
0BSR     pStart/
0BEQ     btrf
0CMP.L   D2,D0
0BNE     weiter
0; folg. Abfrage neu in V2.33:
0MOVE.L  A1,(A3)+
0BSR     pEnd/
0CMP.L   D2,D0
0BNE     tr
.weiter:
0ADDQ.L  #8,A1
0BRA     lupo
.tr
0MOVE.L  (A7)+,A0
0MOVE.L  A1,(A0)
0MOVEQ   #1,D0           ; RETURN TRUE
0RTS
.btrf
0MOVE.L  (A7)+,A0
0MOVE.L  A1,(A0)
0MOVE    #1,endOfLenList(A2)
0CLR     D0           ; RETURN FALSE
(END
&END getProc;
&(*$L=*)
 
$PROCEDURE skipProcName (VAR ad: LONGCARD);
&(*$L-*)
&BEGIN
(ASSEMBLER
0MOVE.L  D2,A2
0MOVE.L  imag(A2),A0
0MOVE.L  -(A3),A1
0MOVE.L  (A1),D0
.L ADDQ.L  #2,D0
0TST.B   1(A0,D0.L)
0BNE     L
0ADDQ.L  #6,D0
0MOVE.L  D0,(A1)
(END;
&END skipProcName;
&(*$L=*)
 
$PROCEDURE setBeforeProcName (VAR ad: LONGCARD);
&(*$L-*)
&BEGIN
(ASSEMBLER
0MOVE.L  D2,A2
0MOVE.L  imag(A2),A0
0MOVE.L  -(A3),A1
0MOVE.L  (A1),D0
0SUBQ.L  #6,D0
.L SUBQ.L  #2,D0
0TST.B   0(A0,D0.L)
0BNE     L
0MOVE.L  D0,(A1)
(END;
&END setBeforeProcName;
&(*$L=*)
 
$PROCEDURE delSymAddr (diff: LONGCARD; ende: LONGCARD);
&BEGIN
(IF hadSyms & protocol & (symbol # NIL) THEN
*REPEAT
,symbol^.addr:= $00FFFFFF;
,symbol:= symbol^.next;
*UNTIL (symbol = NIL) OR (symbol^.addr = ende)
(END
&END delSymAddr;
 
$PROCEDURE setSymAddr (diff: LONGCARD; ende: LONGCARD);
&BEGIN
(IF hadSyms & protocol & (symbol # NIL) THEN
*REPEAT
,DEC (symbol^.addr, diff);
,symbol:= symbol^.next;
*UNTIL (symbol = NIL) OR (symbol^.addr = ende)
(END
&END setSymAddr;
 
$VAR movedDiff: LONGCARD; (* Offset d. Verschiebung *)
 
$BEGIN (* moveProcs *)
&WITH ModLst^[modIdx] DO
(imag:= image;
(symbol:= symbolRoot;
(hadSyms:= procSym;
((*IF hadSyms THEN Debug.Active:= TRUE; Debug.Continuous:= FALSE; END;*)
(remProcSym:= noProcSyms & hadSyms;
(IF remProcSym THEN procSym:= FALSE END;
(currEnd:= entry (image, 42); (* Codebeginn *)
(freeStart:= currEnd;
(lastEnd:= currEnd;
(movedDiff:= 0;
(procsExported:= FALSE; (* noch keine Procs exportiert *)
(endOfLenList:= FALSE;
((*
)* Der Code vom Body macht Probleme, weil er nicht in der ProcLenList
)* auftaucht. Deshalb wird hier eine Hilfsvar. "body_prl" eingesetzt,
)* die ggf. v. "getProc" entsprechend benutzt wird:
)*)
(body_prl.start:= entry (imag, 6);
(IF hadSyms THEN (* start mu _vor_ Proc-Name stehen *)
*setBeforeProcName (body_prl.start);
(END;
(body_prl.len:= codeEnd - body_prl.start;
(mark (ADR(body_prl), 1); (* Body als benutzt markieren *)
(REPEAT
*(* Zu entfernende, hintereinander liegende Procs sammeln *)
*WHILE optProcs & getProc (currEnd, prl) & NOT marked (prl) DO
,currEnd:= pEnd (prl);
,delSymAddr (movedDiff, currEnd);
*END;
*usedStart:= currEnd;
*(* usedStart: Ende zu entfernender Procs/Anfang zu erhaltender Procs *)
*(*
,IF (modIdx = 26) & (currEnd>=codeEnd) THEN
.TOSDebug.Active:= TRUE; TOSDebug.Step:= 0; TOSDebug.Continuous:= FALSE
,END;(*$D+*)
**)
*LOOP
,(* zusammenhngende, nicht zu entfernende Procs sammeln *)
,IF ~getProc (currEnd, prl) THEN
.IF currEnd # dataEnd THEN HALT END;
.IF remProcSym THEN
0IF usedStart < codeEnd THEN skipProcName (usedStart) END;
.END;
.EXIT (* -> end of code & data *)
,END;
,IF marked (prl) OR ~optProcs THEN
.(* unbenutzt:
0IF markedValue (prl) = 2 THEN procsExported:= TRUE END;
.*)
.currEnd:= pEnd (prl);
.IF remProcSym THEN
0IF usedStart < codeEnd THEN skipProcName (usedStart) END;
0EXIT (* -> move single proc *)
.ELSIF hadSyms & protocol THEN
0EXIT (* -> move single proc *)
.END
,ELSE
.EXIT (* -> move one or more procs *)
,END
*END;
*setSymAddr (movedDiff, currEnd);
*IF usedStart # freeStart THEN
,moveCode (modIdx, lastEnd, usedStart, currEnd, freeStart);
,INC (movedDiff, LONGCARD(usedStart - lastEnd))
*END;
*(* Diese Abfrage trifft leider auch bei korrekten Modulen zu:
,IF lastEnd = currEnd THEN
.HALT (* Es kam eine leere Proc/Konstante vor! Mu bersprungen werden *)
,END;
**)
*lastEnd:= currEnd;
*lastFree:= freeStart;
*freeStart:= freeStart + (currEnd - usedStart);
(UNTIL endOfLenList;
(IF symbol # NIL THEN HALT END;
(offset:= usedStart - lastFree;
(DEC (codeEnd, offset);
(DEC (dataEnd, offset);
(DEC (varStart, offset);
&END;
$END moveProcs;
"(*$D-*)
 
 
"VAR modidx: tIndex;
 
"BEGIN (* Optimize *)
$IF optProcs THEN
&Report (3, 'Optimizing');
&IF ~noShModLst THEN WriteString (' / leaving data for debugging') END;
&WriteString ('...');
&FOR modidx:= 1 TO ModIndex DO
(WITH ModLst^[modidx] DO
*useCode:= mainMod OR NOT mayRemove
(END
&END;
&FOR modidx:= 1 TO ModIndex DO
(WITH ModLst^[modidx] DO
*IF useCode & NOT bodyMarked THEN
,bodyMarked:= TRUE;
,markCalls (modidx, entry (image, 6) (* Body-Einsprung *), codeEnd)
*END
(END
&END;
$ELSIF noProcSyms THEN
&Report (3, 'Removing procedure labels...');
$END;
$IF optProcs OR noProcSyms OR noHeader OR noShModLst THEN
&FOR modidx:= 1 TO ModIndex DO
(WITH ModLst^[modidx] DO
*IF mayCrunch THEN
,moveProcs (modidx)
*END;
(END
&END;
$END;
"END Optimize;
"(*$D-*)
 
 PROCEDURE GenerateSymbolList;
"VAR modidx: tIndex;
&pn: POINTER TO LONGCARD;
&p: POINTER TO BYTE;
&ps: SymbolList;
&i, len: CARDINAL;
&prevSym: ADDRESS;
&rec: SymbolEntry;
&body: BOOLEAN;
"BEGIN
$(* zuerst Platz fr die einzelnen Modulbeschreibungen (ModDesc) reservieren *)
$INC (symBufHead, ModIndex * TSIZE (ModDesc));
$IF symBufHead >= symBufEnd THEN
&RelError (FALSE);
$END;
$(* nun die Symbole anfgen *)
$FOR modidx:= 1 TO ModIndex DO
&WITH ModLst^[modidx] DO
(IF procSym THEN
*body:= TRUE;
*prevSym:= NIL;
*pn:= image + entry (image, 6) (* ^Body *) - 4;
*LOOP (* jeden Proc-Namen... *)
,len:= SHORT(LONGCARD(ADR (rec.name) - ADR (rec))) + 2;
,p:= ADDRESS(pn) - 2;
,(* Beginn d. Namens finden, Lnge zhlen *)
,IF body THEN
.(* Body wird als "BEGIN" protok., deswg. diese Lnge zhlen: *)
.INC (len, LENGTH ("BEGIN")+1);
.IF ODD(len) THEN INC (len) END
,END;
,REPEAT
.IF ~body THEN INC (len, 2) END;
.DEC (p, 2);
,UNTIL p^ = BYTE(0);
,(* Namen in Symbol-Puffer eintragen, rckwrts verketten *)
,ps:= symBufHead;
,INC (symBufHead, len);
,IF symBufHead >= symBufEnd THEN
.RelError (FALSE);
,END;
,WITH ps^ DO
.typ := 0;
.next:= prevSym;
.addr:= p - image;
.IF body THEN
0body:= FALSE;
0name:= "BEGIN";
.ELSE
0i:= 0;
0REPEAT
2INC (p);
2name[i]:= CHAR(p^);
2INC (i);
0UNTIL (p^ = BYTE(0)) OR (i = MaxSymbolLen);
0name[i]:= 0C;
.END
,END;
,prevSym:= ps;
,(* next symbol... *)
,IF pn^ = 0 THEN EXIT (* end of list *) END;
,pn:= image + pn^ - 4
*END;
*symbolRoot:= ADDRESS(ps);
(END;
&END
$END
"END GenerateSymbolList;
 
 PROCEDURE FixSymbols;
"VAR modidx: tIndex; p: SymbolList;
"BEGIN
$FOR modidx:= 1 TO ModIndex DO
&WITH ModLst^[modidx] DO
(IF useCode THEN
*p:= symbolRoot;
*WHILE p # NIL DO
,IF p^.addr < $FFFFFF THEN DEC (p^.addr, diff) END;
,p:= p^.next
*END;
(END
&END
$END
"END FixSymbols;
 
 PROCEDURE SymbolOutput (REF symarg: ARRAY OF CHAR): BOOLEAN;
"VAR nextMod, m: ModList; modidx: tIndex;
"BEGIN
$(* reservierte ModDesc-Eintrge (s. GenerateSymbolList) ausfllen *)
$m:= symbolBuf;
$FOR modidx:= 1 TO ModIndex DO
&nextMod:= ADDRESS(m) + SIZE (ModDesc);
&IF modidx = ModIndex THEN nextMod:= NIL END;
&WITH ModLst^[modidx] DO
(m^.next:= nextMod;
(m^.codeAdr:= codeAd;
(IF useCode THEN
*m^.codeLen:= codeEnd-codeAd;
(ELSE
*m^.codeLen:= 0
(END;
(m^.varAdr:= varAd;
(m^.varLen:= varLen;
(m^.dataAdr:= NIL;
(m^.dataLen:= 0;
(m^.sourceName:= sourceName;
(m^.codeName:= codeName;
(m^.name:= name;
(m^.symbolRoot:= symbolRoot;
(m^.compOpts:= compOpts;
(m^.mainMod:= mainMod;
&END;
&m:= nextMod
$END;
$RETURN OutputSymbols (symarg, outName, symbolBuf);
"END SymbolOutput;
 
 
 PROCEDURE bit (n: CARDINAL; l: ARRAY OF WORD): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D2
(MOVE.L  -(A3),A0
(MOVE.W  -(A3),D1
(TST     D2
(BEQ     wd
(MOVE.L  (A0),D0
(BRA     lg
%wd MOVE.W  (A0),D0
%lg BTST    D1,D0
(SNE     D0
(ANDI    #1,D0
$END
"END bit;
"(*$L=*)
 
 
 PROCEDURE ExecMod (mname: tModName;       (* Name des gewuenschten Moduls *)
2reqkey: LONGCARD;       (* gewuenschter Key *)
2client: tIndex)         (* Index des Klienten *)
8: tIndex;         (* vergebener Index *)
 
"(* Laedt das Modul "mname" und liefert dessen Index in der "ModLst"
#* als Ergebnis.
#* Der Modulkey "reqkey" wird erwartet und ueberprueft.
#* Falls ein Fehler beim Relozieren oder Laden auftritt,
#* wird der benoetigte Speicher freigegeben und als Ergebnis
#* "BadIndex" geliefert
#*)
$
"VAR
.i: tIndex;
%clientname,
*fname: tModName;
-ad: address;
"
$
"PROCEDURE LoadMod (mname, fname: tModName): tIndex;
 
$(* Laedt ein Modul in den Speicher, ueberprueft das Format
%* und traegt in die Modul-Liste ein. Reloziert nicht!
%* Wenn ein Fehler auftritt, wird der benutzte Speicher
%* freigegeben und als Modul-Index BadIndex geliefert
%*)
 
$PROCEDURE ImportLen (image: address): LongCard;
&
&(* Laenge der Importliste des Moduls, das bei image steht,
)in Bytes ermitteln
&*)
&
&VAR s: address; n: LONGCARD;
&
&BEGIN
(s:= entry (image, 14);
(IF s = NIL THEN
*RETURN 0L
(ELSE
*n:= 4;  (* Platz fr Import-Liste (s. PutMod) *)
*s:= s+image;
*WHILE entry (s, 0) # 0L DO
,inc (s, 4);
,WHILE cardinal (s^) MOD 256 # 255 DO inc (s, 2) END;
,inc (s, 2);
,WHILE cardinal (s^) # 0 DO inc (s, 6) END;
,inc (s, 2);
,INC (n, 4);
*END;
*RETURN s+4L-image-entry (image, 14) - n
(END
&END ImportLen;
$
$VAR    foundkey: LongCard;      (* Key des geladenen Moduls    *)
-ModAdr: Address;       (* Anfang des geladenen Moduls *)
.found: Boolean;       (* fuer FileSearch             *)
,DriveNr: Cardinal;      (*  "                          *)
.VolNr: Cardinal;      (*  "                          *)
0ad1: address;       (* fuer Storage-Anforderungen  *)
0len: longcard;      (*  -"-                        *)
-layout: CARDINAL;
+realCode: CARDINAL;
-mname0: POINTER TO tModName;
,badFile: BOOLEAN;
-dummys: ARRAY [0..127] OF CHAR;
$
$BEGIN (* LoadMod *)
&IF ModIndex < LinkerParm.maxLinkMod THEN
(inc (ModIndex);
&ELSE
((*** Leider ist die Liste bergelaufen: ***)
(error (clientname, mname, TooManyMods);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
&
&SearchFile (fname,paths,fromStart,found,fname);
&Open (loadFile,fname,readonly);
&IF state (loadfile) < 0 THEN
(error (clientname,mname,notfound);
(RETURN BadIndex
&END;
 
&len:= FileSize (loadFile);
&Allocate (ad1, len);
&IF ad1 = NIL THEN
(Close (loadFile);
(error (clientname,mname,nospace);
(RETURN BadIndex
&END;
 
&ReadBytes (loadFile, ad1, len, len);
&ior:= State (loadFile);
&ResetState (loadFile);
&Close (loadFile);
&IF IOR<0 THEN
(error (clientname,mname,readerr);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
 
&ASSEMBLER
(MOVE.L  ad1(A6),A0
(CMPI.L  #$4D4D3243,(A0)+        ; "MM2C"
(BNE     nocode
(CMPI.L  #$6F646500,(A0)+        ; "ode"
&nocode
(SNE     D0
(ANDI    #1,D0
(MOVE    D0,badFile(A6)
&END;
&IF badFile THEN
(error (clientname,mname,badlayout);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
 
&ModAdr:= ad1+8L;
 
&layout:= Short (entry (ModAdr, 0) DIV 65536L);
&ASSEMBLER
(MOVE.W  layout(A6),D0
(LSR.B   #5,D0
(ANDI    #3,D0
(MOVE.W  D0,realCode(A6)
&END;
&(*
(IF (layout DIV 256) < 1 THEN
*error (clientname,mname,badlayout);
*DeAllocate (ad1,0L);
*RETURN BadIndex
(END;
&*)
&
&IF singleMod THEN
(singleMod:= FALSE;
(IF bit (1, layout) THEN
*error (clientname,mname,mustnotbeimpl);
*DeAllocate (ad1,0L);
*RETURN BadIndex
(END
&END;
&
&IF realCode # 0 THEN (* real im Code *)
(IF realForm # 0 THEN (* schon Real benutzt *)
*IF realCode # realForm THEN
,error (clientname,mname,badreal);
,DeAllocate (ad1,0L);
,RETURN BadIndex
*END
(ELSE
*ReportRealFormat (realCode-1);
*realForm:= realCode
(END
&END;
&
&foundkey:= entry (ModAdr, 2);
&IF (reqkey#anykey) & (reqkey#foundkey) THEN
(error (clientname,mname,badversion);
(DeAllocate (ad1,0L);
(RETURN BadIndex
&END;
&
&(*** Modul in ModLst eintragen ***)
*
&WITH ModLst^ [ModIndex] DO
(mainMod:= LoadingMain;
(useCode:= TRUE;
(varsExported:= FALSE;
(image := ModAdr;
(mayCrunch:= (layout DIV 256) >= 2;
(IF optProcs AND NOT mayCrunch THEN
*error (clientname,mname,nooptimize);
*RETURN BadIndex
(END;
(IF noHeader AND mayCrunch THEN
*diff:= entry (image, 42) (* ganzen Header weglassen *)
(ELSE
*diff:= ImportLen (image)
(END;
(varStart:= entry (ModAdr, 22);
(dataEnd:= varStart;
(codeEnd:= entry (ModAdr, 62);
(IF codeEnd = 0 THEN (* Data-Beginn undefiniert? *)
*codeEnd:= varStart;
(END;
(BodyLen:= BodyLen + (codeEnd - entry (ModAdr, 6));
(varAd := VarNow;
(varLen:= entry (ModAdr, 10) - varStart;
(key   := foundkey;
(mname0:= ADDRESS (entry (ModAdr, 26)) + ModAdr;
(SplitPath (mname0^,dummys,sourcename);
(mname0:= ADDRESS (entry (ModAdr, 30)) + ModAdr;
(Assign (mname0^,name,ok);
(mname0:= ADDRESS (entry (ModAdr, 34)) + ModAdr;
(SplitPath (mname0^,dummys,symbolname);
(Assign (fname,codename,ok);
(symbolRoot:= NIL;
(compopts:= LONGSet(entry (ModAdr, 46));
(mayRemove:= NOT bit (2, compopts);
(procSym:= bit (4, layout);
(bodyMarked:= FALSE;
(useCode:= TRUE;
(crunched:= FALSE;
(ImpIndex:= 0;
(ImpLst:= NIL;
(varNow:= varNow + varlen;
(IF isCLinkMod (ModIndex) THEN
*WriteMod (ModIndex, conc ('', name), fname);
(ELSE
*WriteMod (ModIndex, name, fname);
(END;
&END;
&LoadingMain:= FALSE;
&RETURN ModIndex;
$END LoadMod;
 
 
"PROCEDURE ImportMods (myIndex: tIndex): Boolean;
"
$VAR ReqKey: LongCard;
)ImPtr: address;
'ImIndex: tIndex;
,ok: boolean;
-i: cardinal;
 
$BEGIN
&WITH ModLst^ [myIndex] DO
((* Anzahl der importierten Module bestimmen *)
((* und entspr. Speicher allozieren          *)
(ImPtr:= image + entry (image, 14); (* ^ImportListe *)
(ReqKey:= entry (ImPtr, 0);         (* importiertes Modul *)
(i:= 2;
(WHILE ReqKey # 0L DO
*inc (ImPtr, 4);
*SkipStr (ImPtr);
*SkipImpList (ImPtr);
*inc(i);
*ReqKey:= entry (ImPtr, 0)
(END; (* alle Importe abgearbeitet *)
(ALLOCATE (ImpLst, LONG (i) * TSIZE (tIndex));
(IF ImpLst = NIL THEN
*error (clientname,name,nospace)
(END;
 
(ImPtr:= image + entry (image, 14); (* ^ImportListe *)
(ReqKey:= entry (ImPtr, 0);         (* importiertes Modul *)
(ok:= true;
(WHILE (ReqKey # 0L) & ok DO
*inc (ImPtr, 4);
*ImIndex:= ExecMod (getstr (ImPtr), ReqKey, myIndex);
*IF ImIndex # BadIndex THEN
,SkipImpList (ImPtr);
,inc(ImpIndex);
,ImpLst^[ImpIndex]:= ImIndex
*ELSE
,ok:= false
*END;
*ReqKey:= entry (ImPtr, 0)
(END; (* alle Importe abgearbeitet *)
&END;
&RETURN ok
$END ImportMods;
"
"VAR s1,s2: tModName;
"
"BEGIN (* of ExecMod *)
$IF codesuffix THEN
&paths:= ImpPaths;
&ConcatName (mname, DefImpInSuf, fname)
$ELSE
&fname:= mname;
&SplitFileName (fname, mname, s1);
&Upper (s1);
&IF StrEqual (s1,DefImpInSuf) THEN
(paths:= ImpPaths
&ELSE
(paths:= ModPaths
&END
$END;
$codesuffix:= true;
$
$IF client = BadIndex THEN
&clientname:= mname
$ELSE
&Assign (ModLst^ [client].name, clientname, ok)
$END;
$
$Assign (mname,s1,ok);
$Upper (s1);
$FOR i:=1 TO ModIndex DO
&WITH ModLst^ [i] DO
(FastStrings.Assign (name,s2);
(Upper (s2);
(IF StrEqual (s1,s2) THEN
*IF (reqkey#anykey) & (reqkey#key) THEN
,error (clientname,mname,badversion);
,RETURN BadIndex
*ELSE
,(*** tatsaechlich: wir haben das richtige Modul im RAM ***)
,RETURN i
*END
(END
&END
$END;
$
$(*** Hier kommen wir an, wenn Modul nicht im RAM liegt ***)
$
$i:= LoadMod (mname, fname);
$IF i # BadIndex THEN (* Load war erfolgreich *)
&IF ImportMods (i) THEN
(inc (InitIndex);
(InitLst^[InitIndex]:= i;  (* i zum Initialisieren vormerken *)
(RETURN i
&ELSE (* ImportMods ist schiefgegangen *)
(RETURN BadIndex
&END;
$ELSE (* Load ist schiefgegangen *)
&RETURN BadIndex
$END
"END ExecMod;
 
 
 
 (*$L-,R-*)
 PROCEDURE PutIntoRelTab ( v: longcard );
"(* VAR d:longcard; *)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(TST.L   firstRelVal
(BNE     c0
(MOVE.L  D0,firstRelVal
(BRA     e0
 c0      CMP.L   lastRelVal,D0
(BHI     c1
 jErr    CLR     (A3)+
(JMP     RelError                ; Programmende
 c1      MOVE.L  D0,D1
(SUB.L   lastRelVal,D1
(
(MOVE.L  pRelTab,A0
 l1      CMPA.L  eRelTab,A0
(BCC     jErr                    ; Listenberlauf
(CMPI.L  #256,D1
(BCS     c2
(MOVE.B  #1,(A0)+
(SUBI.L  #254,D1
(BRA     l1
 c2      MOVE.B  D1,(A0)+
(MOVE.L  A0,pRelTab
 
 e0      MOVE.L  D0,lastRelVal
$END
"END PutIntoRelTab;
 (*$L+,R+*)
 
 
 (*
!* Globale Vars:
!*)
 VAR    ListTop: POINTER TO ARRAY [1..100000] OF pLONG;
'ListBeg: POINTER TO ARRAY [1..100000] OF pLONG;
%ListIndex: cardinal;
&LastDrop: pLONG;
)eoLists, Lists: pLONG;
 
 
 PROCEDURE dialog(): Boolean;
 
"(*$R-*)
"PROCEDURE ClrList;
$VAR i : cardinal;
$BEGIN
&FOR i:= 1 TO ListIndex DO
(ListTop^[i]:= NIL
&END;
&ListIndex:= 0;
&LastDrop:= Lists
$END ClrList;
 
"(*$R-,L-*)
"PROCEDURE SmallestInList() : LONGCARD;
$BEGIN
&ASSEMBLER
(MOVEQ   #-1,D0
(CLR.W   D1
(MOVEQ   #1,D2
&forloop0
(CMP     listIndex,D2
(BHI     forend0
(MOVE    D2,D3
(SUBQ    #1,D3
(ASL     #2,D3
(MOVE.L  ListTop,A0
(MOVE.L  0(A0,D3.W),A1
(CMPA.L  #NIL,A1
(BEQ     cont0
(MOVE.L  (A1),D4
(CMP.L   D4,D0
(BLS     cont0
(MOVE.L  D4,D0
(MOVE    D2,D1
&cont0
(ADDQ    #1,D2
(BRA     forloop0
&forend0
(TST     D1
(BEQ     ende
(SUBQ    #1,D1
(ASL     #2,D1
(MOVE.L  ListTop,A0
(MOVE.L  0(A0,D1.W),D2
(MOVE.L  ListBeg,A1
(CMP.L   0(A1,D1.W),D2
(BNE     cont1
(CLR.L   0(A0,D1.W)
(BRA     cont2
&cont1
(SUBQ.L  #4,0(A0,D1.W)
&cont2
(RTS
&ende
(CLR.L   D0
&END
$END SmallestInList;
"
"(*$R-,L+*)
"PROCEDURE reloc (myMod, imMod: ptrModDesc; VAR ImPtr: ADDRESS; VAR ok: BOOLEAN);
$BEGIN
&ASSEMBLER
(MOVEM.L D3/D4/D6/A4/A5,-(A7)
 
(MOVE.L  myMod(A6),A4
(MOVE.L  tModDesc.image(A4),A4   ;^ zu relozierendes Modul
(
(MOVE.L  ImPtr(A6),A1
(MOVE.L  (A1),A1
(MOVEQ   #1,D6         ;noch ist alles 'ok'
(
(MOVE.L  A6,-(A7)
(MOVE.L  imMod(A6),A6            ;A6 ist ^ModLst^ [ImIndex]
(MOVE.L  tModDesc.image(A6),A2   ;A2 zeigt auf imp. Modul
!
!!RE6   MOVE.W  (A1)+,D0      ;imp. ItemNr
(BEQ.L   RE5           ;fertig mit diesem Import
(MOVE.L  18(A2),D3     ;Offset zur Exp.liste
(BEQ.L   BAD           ;keine da
(ADD.L   A2,D3
(MOVE.L  (A1)+,D1      ;importiertes Item
(BEQ     RE6           ; wird gar nicht benutzt
 
(MOVE    ListIndex,D4
(CMP.W   ListMax,D4
(BCC.W   relerr2
(ADDQ    #1,ListIndex
(MOVE.L  ListBeg,A5
(MOVE    ListIndex,D4
(SUBQ    #1,D4
(LSL     #2,D4
(CLR.L   0(A5,D4.W)
 
(MOVE.L  D3,A0
!!RE9   MOVE.W  (A0)+,D2      ;Item in Exportliste suchen
(BEQ.W   BAD           ; schade - Liste zuende
(CMP.W   D2,D0
(BEQ     RE10          ;gefunden
(ADDQ.L  #4,A0
(BRA     RE9
!!RE10  MOVE.L  (A0)+,D2      ;abs. ItemAdr ausrechnen
(BEQ     re6           ;wurde wegoptimiert
(CMP.L   22(A2),D2
(BCC     isVa2         ;das ist eine Var-Referenz
(ADD.L   tModDesc.codeAd(A6),D2 ;Prozeduren: + Modulanfang
(SUB.L   tModDesc.diff(A6),D2   ;            - Importlisten-Laenge
(BRA     RE11
!!isVa2 ADD.L   tModDesc.varAd(A6),D2  ;Variablen: + VarAnfang
(ADD.L   BSSstart,D2   ;Offset zu BSS addieren
(SUB.L   22(A2),D2
!!RE11  CMP.L   22(A4),D1     ;liegt Ref innerhalb des Codes ?
(BCC.W   bad
(MOVE.L  0(A4,D1.L),D0 ;ItemAdr im Modul nachtragen
(MOVE.L  D2,0(A4,D1.L)
 
(MOVE.L  (A7),A6
(MOVE.L  A1,-(A7)
(MOVE.L  myMod(A6),A5
(MOVE.L  D1,D4
(ADD.L   tModDesc.codead(A5),D4
(SUB.L   tModDesc.diff(A5),D4
 
(MOVE.L  lastDrop,A5
(CMPA.L  eoLists,A5
(BCC     relerr1
(MOVE.L  D4,(A5)
(MOVE    listIndex,D4
(SUBQ    #1,D4
(ASL     #2,D4
(MOVE.L  ListTop,A1
(MOVE.L  A5,0(A1,D4.W)
(MOVE.L  ListBeg,A1
(TST.L   0(A1,D4.W)
(BNE.S   cont2
(MOVE.L  A5,0(A1,D4.W)
&cont2
(ADDQ.L  #4,lastDrop
 
(MOVE.L  (A7)+,A1
(MOVE.L  imMod(A6),A6            ;A6 ist ^ModLst^ [ImIndex]
 
(MOVE.L  D0,D1
(BNE     RE11
(BRA     RE6
 
&relerr2
(JMP     RelError2
&relerr1
(CLR     (A3)+
(JMP     RelError
 
!!bad   CLR.W   D6            ;FehlerFlag
!!RE5   MOVE.L  (A7)+,A6      ;A6 wieder reparieren
(MOVE.L  ImPtr(A6),A0
(MOVE.L  A1,(A0)
(MOVE.L  ok(A6),A0
(MOVE.W  D6,(A0)
 
(MOVEM.L (A7)+,D3/D4/D6/A4/A5
&END
$END reloc;
 
"(*$R+,L+*)
"PROCEDURE Relocate ( myIndex: tIndex ) : Boolean;
"
$VAR      v: LongCard;
)ImPtr: address;
'ImIndex: tIndex;
,ok: boolean;
-i: cardinal;
!main, importn: tModName;
(ptrMod: ptrModDesc;
(
$BEGIN
&(*** Zuerst die Var/Proc-Liste abarbeiten ***)
&
&ptrMod:= ADR (ModLst^ [myIndex]);
&Assign (ptrMod^.name, main, ok);
&ClrList;
&
&ASSEMBLER
/MOVEM.L D3/D4/D5/D6/A4/A5/A6,-(A7)
/MOVE.L  ListTop,D4
/MOVE.L  ListBeg,D5
/MOVE.W  ListIndex,D6
/MOVE    D6,D3
/SUBQ    #1,D3
/ASL     #2,D3
/MOVE.L  lastDrop,A5
/MOVE.L  ptrMod(A6),A1
 
/MOVE.L  tModDesc.image(A1),A4    ;A4 zeigt auf Modul-Bild im RAM
/MOVE.L  22(A4),A0       ;^Var/ProcListe
/ADDA.L  A4,A0
(!RE3   MOVE.L  (A0)+,D0        ;^letzte Ref
/BEQ.W   RE1             ;Ende der Liste
/
/MOVE.L  (A0)+,D1        ;rel. Adresse
/BEQ     re3             ;wurde wegoptimiert
 
/CMP.W   ListMax,D6      ;ListIndex
/BCC.W   relerr2b
/ADDQ    #1,D6           ;ListIndex
/ADDQ    #4,D3
/MOVE.L  D5,A6
/CLR.L   0(A6,D3.W)
 
/CMP.L   22(A4),D1
/BCC     isVar           ;das ist eine Var-Referenz
/ADD.L   tModDesc.codeAd(A1),D1   ;Prozeduren: + Modulanfang
/SUB.L   tModDesc.diff(A1),D1     ;            - Importlisten-Laenge
/BRA     RE2
(!isVar ADD.L   tModDesc.varAd(A1),D1    ;Variablen: + VarAnfang
/ADD.L   BSSstart,D1     ;Offset zu BSS addieren
/SUB.L   22(A4),D1
(!RE2   CMP.L   22(A4),D0       ;liegt Ref innerhalb des Codes ?
/BCC.S   bad2
/MOVE.L  0(A4,D0.L),D2   ;^naechste Ref
/MOVE.L  D1,0(A4,D0.L)   ;Adresse eintragen
 
/ADD.L   tModDesc.codead(A1),D0
/SUB.L   tModDesc.diff(A1),D0
 
/CMPA.L  eoLists,A5
/BCC.S   relerr
/MOVE.L  D0,(A5)
/MOVE.L  D4,A6
/MOVE.L  A5,0(A6,D3.W)
/MOVE.L  D5,A6
/TST.L   0(A6,D3.W)
/BNE.S   cont
/MOVE.L  A5,0(A6,D3.W)
-cont
/ADDQ.L  #4,A5
 
/MOVE.L  D2,D0
/BNE     RE2             ;weitere Refs auf dieses Objekt
/BRA     RE3             ;pruefe, ob weitere Objekte
 
-relerr
/CLR     (A3)+
/JMP     RelError
-relerr2b
/JMP     RelError2
 
(!bad2
/MOVE.W  D6,ListIndex
/MOVE.L  A5,lastDrop
/MOVEM.L (A7)+,D3/D4/D5/D6/A4/A5/A6
/END; error ('',main,relocerr); ASSEMBLER
/BRA     RE0
 
(!RE1   MOVE.L  A5,lastDrop
/MOVE.W  D6,ListIndex
/MOVEM.L (A7)+,D3/D4/D5/D6/A4/A5/A6
)RE0
&END;
 
((*** Jetzt kmmern wir uns um die Importe ***)
&
&WITH ptrMod^ DO
(ImPtr:= image + entry (image, 14); (* ^ImportListe *)
(i:= 1;
(ok:= TRUE;
(WHILE ( i <= ImpIndex ) & ok DO
*inc (ImPtr, 4);
*Skipstr (ImPtr); (* ImPtr hinter Namen setzen *)
*ImIndex:= ImpLst^[i];
*Assign (ModLst^ [ImIndex].name, importn, ok);
*reloc (ptrMod, ADR (ModLst^ [ImIndex]), ImPtr, ok);
*IF ~ok THEN error (importn,main,relocerr) END;
*inc(i)
(END; (* alle Importe abgearbeitet *)
&END; (* with ModLst^ [myIndex] *)
 
&(* Alle f. dieses Modul relozierten Adressen in RelTab eintragen *)
&
&v:= SmallestInList();
&WHILE v # 0L DO
(PutIntoRelTab(v);
(v:= SmallestInList()
&END;
&
&RETURN ok
$END Relocate;
 
 
"PROCEDURE setCodeAd;
$VAR i: tIndex;
$BEGIN
&FOR i:= 1 TO ModIndex DO
(WITH ModLst^ [i] DO
*IF useCode THEN
,modlen:= dataEnd - diff;
,codeAd:= CodeNow;
,CodeNow:= CodeNow + modlen
*ELSE
,ClearMod (i);
,DEC (UsedCodes);
,DEC (UsedInits);
,modlen:= 0
*END
(END
&END;
$END setCodeAd;
 
 
"PROCEDURE AnotherMod ():BOOLEAN;
$VAR c:CHAR;
$BEGIN
&Prompt (1, 'Another module (Y/N) ? ');
&REPEAT
(Read (c);
(c:=CAP(c);
&UNTIL (c='Y') OR (c='N') OR (c=33C) OR (c=15C);
&RETURN (c='Y') OR (c=15C)
$END AnotherMod;
"
"VAR    i,j: cardinal;
*ln: INTEGER;
%DriveNr: Cardinal;
'VolNr: Cardinal;
)len: Cardinal;
+f: file;
%modName: string;
 nameProvided: BOOLEAN;
"modNameIdx: CARDINAL;
&outsuf: String;
+s: string;
%symargs: String;
 initlistargs: String;
$outFirst: boolean;
%inFirst: boolean;
(argc: CARDINAL;
(argv: ARRAY [0..9] OF PtrArgStr;
%modIdx2: tIndex;
$firstMod: BOOLEAN;
#linkCount: CARDINAL;
%gotLast: BOOLEAN;
%tabSize: LONGCARD;
$l, avail: LONGINT;
 
"PROCEDURE asn (i: CARDINAL; VAR d: ARRAY OF CHAR);
$BEGIN
&IF s[2] # 0C THEN
(INC (argv[i], 2);
(FastStrings.Assign (argv[i]^, d);
&END
$END asn;
 
"BEGIN (* of Dialog *)
$optProcs:= FALSE;
$noHeader:= FALSE;
$noShModLst:= FALSE;
$noProcSyms:= FALSE;
$outname:= '';
$nameProvided:= FALSE;
$modNameIdx:= 0;
$HeaderFlags:= {};
$symBufFact:= 1000;
$DATALen:= 0;
$DATAFileName:= '';
$InitArgCV (argc,argv);
$FOR i:= 1 TO argc-1 DO
&Assign (argv[i]^, s, ok);
&Upper (s);
&IF (s[0] = '-') OR (s[0] = '/') THEN
(CASE s[1] OF
(| '0'..'9':
,j:= 1;
,INCL (HeaderFlags, StrConv.StrToCard (s,j,ok));
(| 'R':
,j:= 2;
,j:= StrConv.StrToCard (s,j,ok);
,IF j >= 100 THEN ListMax:= j END;
(| 'S':
,protocol:= TRUE;
,asn (i, symargs);
(| 'I':
,initList:= TRUE;
,asn (i, initlistargs);
(| 'H':
,optProcs:= TRUE;
(| 'F':
,optProcs:= TRUE;
,noHeader:= TRUE;
,noShModLst:= TRUE;
,noProcSyms:= TRUE;
(| 'M':
,noProcSyms:= TRUE;
(| 'V':
,VerboseOutput;
(| 'O':
,asn (i, outname);
(| 'D':
,j:= 2;
,DATALen:= StrConv.StrToLCard (s,j,ok);
,IF DATALen = 0 THEN
.asn (i, DATAFileName);
.IF Empty (DATAFileName) THEN
0ReportError ("Option 'D' needs a file name or a number for the DATA size");
.ELSE
0Open (f, DATAFileName, readonly);
0IF State (f) < 0 THEN
2ReportError (conc ('Cannot open DATA file: ', DATAFileName));
0ELSE
2DATALen:= FileSize (f);
2Close (f)
0END;
.END
,END
(ELSE
*ReportError (conc ('Illegal option character: ', s[1]));
(END;
(argv[i]^[0]:= 0C
&ELSE
(IF ~nameProvided THEN
*nameProvided:= TRUE;
*modNameIdx:= i;
(ELSE
*ReportError (conc ('Illegal cmdline argument: ', s));
(END;
&END
$END;
$outFirst:= TRUE;
$REPEAT
&IF outFirst & (outname[0] = '') THEN
(SplitPath (argv[modNameIdx]^,s,outName);
(SplitName (outName,outName,outSuf);
(IF outName[0] # '' THEN
*IF Compare (outsuf, 'MOS') = equal THEN
,Append ('.TOS', outname, ok)
*ELSIF Compare (outsuf, 'MTP') = equal THEN
,Append ('.TTP', outname, ok)
*ELSIF Compare (outsuf, 'MAC') = equal THEN
,Append ('.ACC', outname, ok)
*END;
*FastStrings.Insert (s, 0, outname)
(END
&END;
&IF ~outFirst OR (outname[0] = 0C) THEN
(Prompt (0, 'Output file name? ');
(ReadString (outName);
&END;
&outFirst:= FALSE;
&IF outname[0] = 0C THEN
(RETURN false
&ELSIF NOT hasSuffix (outName) THEN
(Append (DefOutSuf, outname, ok)
&END;
&ReplaceHome (outName);
&Report (0, 'Output file name: ');
&Upper (outName);
&WriteString (outName);
&
&Create (outFile, outName, writeOnly, replaceOld);
&
&ior:= State (outFile);
&IF ior<0 THEN
(MyError (ior)
&END;
$UNTIL ior=0;
$ClearEOP;
$
$CodeNow:= 18 + LENGTH (CodeID) + 1 + SysVarSpace;
F(* Platz fuer Start-LEA's/JMP und PDB *)
$VarNow:= 0L;
$BodyLen:= 0;
$
$ModIndex:= 0;
$modIdx2:=0;
$firstMod:= TRUE;
$linkCount:= MIN (LLRange);
$gotLast:= FALSE;
$LOOP
&inFirst:= TRUE;
&REPEAT
(IF inFirst & (nameProvided) THEN
*WHILE (linkCount<=MAX(LLRange)) & ~LinkerParm.linkList[linkCount].valid DO
,INC (linkCount)
*END;
*IF linkCount>MAX(LLRange) THEN
,Assign (ArgV[modNameIdx]^,ModName,ok);
,gotLast:= TRUE
*ELSE
,Assign (LinkerParm.linkList[linkCount].name,ModName,ok);
,INC (linkCount)
*END
(ELSIF nameProvided THEN
*ModName:= '' (* Programmabbruch *)
(ELSE
*Prompt (1, 'Module name? ');
*ReadString (ModName);
(END;
(inFirst:= FALSE;
(IF length (ModName) = 0 THEN
*Remove (outfile);
*RETURN false
(ELSIF NOT hasSuffix (ModName) THEN
*ConcatName (modname, DefPrgInSuf, modname);
(END;
(DiscardMods (modIdx2);
(Report (1, 'Module name: ');
(WriteString (ModName);
(IF firstMod THEN
*singleMod:= TRUE;
*InitIndex:= 0;
*ClearEOP;
(END;
((* Release geladene Moduln: *)
(WHILE ModIndex # modIdx2 DO
*DeAllocate (ModLst^ [ModIndex].ImpLst,0L);
*DeAllocate (ModLst^ [ModIndex].image,0L);
*DEC (ModIndex)
(END;
(LoadingMain:= TRUE;
(CodeSuffix:= false
&UNTIL ExecMod (modname, anykey, BadIndex) # BadIndex;
&IF firstMod THEN
(InitIdx2:= InitIndex
&END;
&IF nameProvided & gotLast THEN
(EXIT
&END;
&IF ~nameProvided & ~AnotherMod () THEN
(EXIT
&END;
&modIdx2:= ModIndex;
&firstMod:= FALSE
$END;
$
$(* Alles geladen, nun kann alles reloziert werden *)
$
$IF initList THEN
&IF NOT OutputInitList (initlistargs, outName, InitLst^, InitIndex, InitIdx2) THEN
(Remove (outfile);
(RETURN false
&END;
$END;
$
$(* Symbole in Liste eintragen *)
$IF protocol THEN
&symBufSize:= INT (MemAvail ()) - $1000;
&IF symBufSize < $1000 THEN RelError (FALSE) END;
&ALLOCATE (symbolBuf, symBufSize);
&symBufEnd:= symbolBuf + ORD(symBufSize);
&symBufHead:= symbolBuf;
&GenerateSymbolList;
$END;
$
$(* evtl. noch optimieren... *)
$Optimize;
$
$(* CodeNow & Adr. der Module ermitteln *)
$UsedCodes:= ModIndex;
$UsedInits:= InitIndex;
$setCodeAd;
$
$(* Symbolliste ausgeben und Speicher wieder freigeben *)
$IF protocol THEN
&FixSymbols;
&IF NOT SymbolOutput (symargs) THEN
(Remove (outfile);
(RETURN false
&END;
&DEALLOCATE (symbolBuf, 0);
$END;
$
$Report (3, 'Relocating...');
$
$tabSize:= SIZE (ListTop^[1]) * ListMax;
$avail:= INT (MemAvail ()) - $2000 - INT (MaxBlSize) - INT(2*tabSize);
$IF avail < $2000 THEN RelError (FALSE) END;
$ALLOCATE (ListTop, tabSize);
$ALLOCATE (ListBeg, tabSize);
$IF (ListTop = NIL) OR (ListBeg = NIL) THEN RelError (TRUE) END;
$DEC (avail, 2*tabSize);
$Allocate ( RelocTab, avail DIV 3 );
$pRelTab:= RelocTab; eRelTab:= RelocTab + ORD(avail) DIV 3 - 4;
$l:= avail - (avail DIV 3); IF ODD (l) THEN DEC (l) END;
$Allocate (Lists, l+4);
$ListIndex:= ListMax; eoLists:= ADDRESS (Lists) + ORD (l);
$IF (RelocTab = NIL)
$OR (Lists = NIL) THEN RelError (TRUE); END;
$
$IF noShModLst THEN
&ShModLstLen:= 0
$ELSE
&ShModLstLen:= long (UsedCodes) * ShModLstSpace;
$END;
$
$DATAStart:= CodeNow + long (4*(UsedInits-1)+8) + ShModLstLen;
$BSSstart:= DATAStart+ORD(DATALen);
$WITH ModLst^ [InitLst^[InitIdx2]] DO
&initOffs:= codeAd + entry (Image, 6) - diff;
$END;
$
$PutIntoRelTab(2L);   (* LEA reloz. *)
$PutIntoRelTab(8L);   (* LEA reloz. *)
$IF initOffs >= 32768 THEN
&PutIntoRelTab(14L);  (* JMP am Code-Anfang reloz. *)
$END;
$IF NOT noShModLst THEN
&PutIntoRelTab(24 + LENGTH (CodeID) + 1);  (* ^ShModLst reloz. *)
$END;
$
$FOR i:=1 TO ModIndex DO
&IF ModLst^ [i].useCode THEN
(IF ~Relocate(i) THEN
*Remove (outfile);
*RETURN false
(END
&END
$END;
$
$DEALLOCATE (ListTop, 0);
$DEALLOCATE (ListBeg, 0);
$DeAllocate (Lists, 0L);
$
$IF ~nameProvided THEN
&REPEAT
(Prompt (2, 'Stack size (0 for default)? ');
(ReadString (s);
(i:=0;
(stacksize:= StrConv.StrToLCard (s,i,ok)
&UNTIL (stacksize=0L) OR (stacksize>255L)
$ELSE
&stacksize:= LinkerParm.linkStackSize
$END;
$RETURN TRUE
"END dialog;
 
 
 PROCEDURE moveProcNames (image: ADDRESS; add: LONGINT);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  6(A0),D1        ; BODY-OFFSET
%l: LEA     -4(A0,D1.L),A1
(MOVE.L  (A1),D1
(ADD.L   D0,(A1)
(TST.L   D1
(BNE     l
$END
"END moveProcNames;
"(*$L=*)
 
 
 PROCEDURE PutMod (i: tIndex);
 
"(*
#*  ImportListe aus dem Modul entfernen, Exportliste umrechnen,
#*  Modul in outfile schreiben
#*)
"
"VAR  s,d, img: address; idx: tIndex; pl: POINTER TO LONGCARD;
"
"BEGIN
$WITH ModLst^ [i] DO
 
&IF procSym AND (diff # 0L) THEN
((*** Proc-Namen-Liste bzgl. 'diff' korrigieren ***)
(moveProcNames (image, -LONGINT(diff));
&END;
 
&IF noHeader & mayCrunch THEN
 
(img:= image + entry (image, 42)
 
&ELSE
&
((*** Importliste loeschen, aber Pointer-Liste anlegen ***)
(
(IF diff # 0L THEN
*pl:= image + entry (image, 14);       (* ^Importliste *)
*FOR idx:= 1 TO ImpIndex DO
,pl^:= ModLst^[ImpLst^[idx]].finalIdx;
,INC (pl,4)
*END;
*pl^:= 0;
*INC (pl,4);
*d:= pl;
*s:= d + diff;
*Block.Copy (s, (image + entry (image, 22)) - s, d);
(END;
(
((*** Exportliste umrechnen ***)
(
(d:= entry (image, 18);
(IF d # NIL THEN
*enter (image, 18, d - diff);                  (* ^ExportListe *)
*d:= d+image-diff;
*WHILE cardinal (d^) # 0 DO
,s:= entry (d, 2);
,IF s # 0L THEN
.IF s < entry (image, 22) THEN (* Procedure/Const *)
0enter (d, 2, s-diff)
.ELSE
0(*$r- die rel. Adressen der Variablen koennen negativ werden *)
0enter (d, 2, VarAd + BSSstart + s - entry (image, 22) - codeAd )
0(*$r=*)
.END;
,END;
,inc (d, 6)
*END
(END;
(
(img:= image
(
&END;
&
&enter (image,  6, entry (image,  6) - diff);    (* ^Modulrumpf  *)
&enter (image, 10, modlen);                      (* ^Modulende   *)
&enter (image, 22, 0);                           (* ^Var/Proc    *)
&enter (image, 42, entry (image, 42) - diff);    (* ^CodeStart   *)
 
&(*** und wegschreiben ***)
 
&fputm (outfile, img^, modlen)
 
$END (* with ModLst^ [i] *)
"END PutMod;
#
#
 PROCEDURE CodeOutput;
 
"(*  Relozierte Module ins Ausgabe-File wegschreiben.
#*  Dabei werden Import- und Relozierlisten entfernt,
#*  Exportlisten muessen umgerechnet werden!
#*)
#
"CONST  bra = $6000;
)nop = $4E71;
)jmp = $4EF9;
)jsr = $4EB9;
)rts = $4E75;
)lea1= $43F9;  (* LEA xxxxxxxx,A1 *)
)lea2= $45F9;  (* LEA xxxxxxxx,A2 *)
)
)bufsize = 4096;
"
"VAR   j,i: tIndex;
%k,wbuf: cardinal;
)li: LONGINT;
'lbuf: longcard;
*p: address;
)ch: CHAR;
)bs: BITSET;
&idBuf: ARRAY [0..LENGTH (CodeID)] OF CHAR;
&dataf: File;
%buffer: ADDRESS;
 
"BEGIN
$(* Command File Header schreiben *)
$wbuf:= $601A;
$fput (outfile, wbuf);
$fput (outfile, DATAstart);  (* Lnge TEXT *)
$fput (outfile, DATALen);    (* Lnge DATA *)
$fput (outfile, VarNow);     (* Lnge BSS *)
$lbuf:= 0L;
$fput (outfile, lbuf);
$lbuf:= 0L;
$fput (outfile, lbuf);
$lbuf:= CARDINAL (HeaderFlags); (* Fastload/Fast Code/Fast Memory-Bits *)
$fput (outfile, lbuf);
$wbuf:= 0;
$fput (outfile, wbuf);
$
$wbuf:= lea1;                (* Zeiger auf import. Moduladr. -> A1 *)
$fput (outfile, wbuf);
$lbuf:= CodeNow + ShModLstLen;
$fput (outfile, lbuf);
$
$wbuf:= lea2;                (* LEA  PDB,A2 *)
$fput (outfile, wbuf);
$fput (outfile, VAL (LONGCARD, 18 + LENGTH (CodeID) + 1));
$
$(* 26.09.94: falls Differenz < 32K, dann BRA statt JMP verwenden, *
%*           damit z.B. Templemon ohne Relozierung laufen kann.   *)
$WITH ModLst^ [InitLst^[InitIdx2]] DO
&lbuf:= codeAd + entry (Image, 6) - diff;
$END;
$IF initOffs # lbuf THEN HALT END; (* Zur Sicherheit *)
$IF initOffs >= 32768 THEN
&wbuf:= jmp;                 (* JMP zum Init-Modul *)
&fput (outfile, wbuf);
&fput (outfile, lbuf);
$ELSE
&wbuf:= nop;
&fput (outfile, wbuf);
&wbuf:= bra;                 (* BRA zum Init-Modul *)
&fput (outfile, wbuf);
&wbuf:= short (lbuf - 16);   (* rel. Offset ab BRA-Instr. bestimmen *)
&fput (outfile, wbuf);
$END;
$
$idBuf:= CodeID;
$fput (outfile, idBuf);
$
$(* PDB anlegen *)
$wbuf:= PDBlayout;
$fput (outfile, wbuf);       (* layout *)
$lbuf:= 0L;
$fput (outfile, lbuf);       (* ^basePage reservieren *)
$IF noShModLst THEN
&lbuf:= 0;
&wbuf:= 0
$ELSE
&lbuf:= codenow;
&wbuf:= UsedCodes;
$END;
$fput (outfile, lbuf);       (* ^ShModLst (f. Loader) *)
$fput (outfile, wbuf);       (* Anzahl der Eintrge in ShModLst *)
$wbuf:= 0;
$fput (outfile, wbuf);       (* processState *)
$lbuf:= 0L;
$fput (outfile, lbuf);       (* BottomOfStack *)
$fput (outfile, stacksize);  (* TopOfStack *)
$fput (outfile, lbuf);       (* termState, resident *)
$ASSEMBLER
(MOVE    realForm,D0
(TST     extendedCode
(BEQ     noExtCode
(ADDQ    #4,D0
&noExtCode
(MOVE.W  D0,wbuf(A6)
$END;
$fput (outfile, wbuf);       (* flags *)
$fput (outfile, lbuf);       (* TermProcs *)
$fput (outfile, lbuf);       (* ^prev *)
$fput (outfile, lbuf);       (* reserved *)
$fput (outfile, lbuf);       (* reserved *)
$fput (outfile, lbuf);       (* reserved *)
$fput (outfile, lbuf);       (* reserved *)
$
$(* finalIdx berechnen *)
$j:= 0;
$FOR i:=1 TO ModIndex DO
&IF ModLst^ [i].useCode THEN
(INC (j);
(ModLst^ [i].finalIdx:= j;
&ELSE
(ModLst^ [i].finalIdx:= 0
&END
$END;
$IF UsedCodes # j THEN HALT END;
$
$(* Codes der Module ablegen *)
$FOR i:=1 TO ModIndex DO
&IF ModLst^ [i].useCode THEN
(WritingOut (i);
(PutMod (i);
(IF IOResult < 0 THEN
*MyError (IOResult);
*Remove (OutFile);
*RETURN
(END
&END
$END;
$
$IF NOT noShModLst THEN
&(* ShModLst ablegen *)
&j:= 0;
&FOR i:= 1 TO ModIndex DO
(WITH ModLst^ [i] DO
*IF useCode THEN
.(* head0: Adr. des Headers *)
0fput (outfile, codead);
0PutIntoRelTab ( codeNow + long (j) * ShModLstSpace );
.(* var0 *)
0lbuf:= varAd + BSSstart;
0fput (outfile, lbuf);
0PutIntoRelTab ( codeNow + long (j) * ShModLstSpace + 4 );
.(* varlen0 *)
0fput (outfile, varlen);
.(* flags *)
0bs:= {};
0IF procSym THEN INCL (bs,0) END;
0IF crunched THEN INCL (bs,1) END;
0IF NOT bit (25, compopts) (* $Y *) THEN INCL (bs, 2) END;
0IF mainMod THEN INCL (bs,3) END;
0fput (outfile, bs);
,INC (j)
*END
(END
&END
$END;
$
$(* Body-Adressen der Module zur Initialisierung in Liste schreiben *)
$
$j:= 0;
$(* vom ersten Modul importierte Moduladr. rausschreiben *)
$FOR i:=1 TO InitIdx2-1 (* Init-Mod nicht *) DO
&WITH ModLst^ [InitLst^[i]] DO
(IF useCode THEN
*lbuf:= CodeAd + entry (Image, 6) (* '-diff' in Putmod erledigt  *);
*fput (outfile, lbuf);
*PutIntoRelTab ( codeNow + ShModLstLen + long (j * 4) );
*INC (j)
(END;
&END;
$END;
$
$lbuf:= 0L;
$fput (outfile, lbuf); (* Endekennung *)
$INC (j);
$
$(* von weiteren Modulen importierte Moduladr. rausschreiben *)
$FOR i:=InitIdx2+1 TO InitIndex DO
&WITH ModLst^ [InitLst^[i]] DO
(IF useCode THEN
*lbuf:= CodeAd + entry (Image, 6) (* '-diff' in Putmod erledigt  *);
*fput (outfile, lbuf);
*PutIntoRelTab ( codeNow + ShModLstLen + long (j * 4) );
*INC (j)
(END
&END;
$END;
$
$lbuf:= 0L;
$fput (outfile, lbuf); (* Endekennung *)
$
$(* DATA-Segment erzeugen *)
$IF DATALen > 0 THEN
&ALLOCATE (buffer, bufsize); (* soviel wird sicher immer frei sein *)
&IF DATAFileName[0] # '' THEN
((* DATA aus Datei kopieren *)
(Open (dataf, DATAFileName, readonly);
&ELSE
((* Leeres DATA-Segment erzeugen *)
(Block.Clear (buffer, bufsize);
&END;
&WHILE DATALen > 0 DO
(li:= DATALen;
(IF li > bufsize THEN li:= bufsize END;
(IF DATAFileName[0] # '' THEN
*ReadBytes (dataf, buffer, li, lbuf)
(END;
(fputm (outfile, buffer^, li);
(DEC (DATALen, li);
&END;
&IF DATAFileName[0] # '' THEN
(Close (dataf)
&END
$END;
$
$(* Reloziertabelle schreiben *)
$lbuf:= pRelTab - RelocTab;
$IF lbuf > 32760L THEN
&ReportError (conc (conc ('Warning! Relocation table is ',
>StrConv.CardToStr (lbuf,0)),
9' bytes long (will not run on TOS 1.0/1.2)'));
$END;
$fput (outfile, firstRelVal);
$fputm (outfile, RelocTab^, lbuf);
$wbuf:= 0;
$fput (outfile, wbuf);
$
$Close (OutFile);
$IF State (outFile) < 0 THEN
&MyError (state(outfile));
&Remove (outfile);
$ELSE
&EndWriting;
$END;
"END CodeOutput;
 
 
 VAR dummy: PDB;
$ch: CHAR;
 
 BEGIN (* ROMLoad *)
"IF SIZE (dummy.ModLst^[1]) # ShModLstSpace THEN HALT END;
"IF TSIZE (PDB) # SysVarSpace THEN HALT END;
"IF NOT ODD (LENGTH (CodeID)) THEN HALT END;
"
"IF LinkerParm.maxLinkMod >= (MAX (tIndex)-1) THEN
$LinkerParm.maxLinkMod:= MAX (tIndex)-2
"END;
"IF LinkerParm.maxLinkMod = 0 THEN LinkerParm.maxLinkMod:= 100 END;
"ListMax:= 1000;
"
"InitOutput (LinkerParm.maxLinkMod, conc ('Megamax Modula-2 Linker ',version));
"
"HomePath:= ShellPath; 
"
"ALLOCATE (ModLst, TSIZE (tModDesc) * LONG (LinkerParm.maxLinkMod+2));
"ALLOCATE (InitLst, TSIZE (tIndex) * LONG (LinkerParm.maxLinkMod+2));
"IF (ModLst = NIL) OR (ModLst = NIL) THEN
$ReportError ('Out of memory');
$TermProcess (MOSGlobals.OutOfMemory)
"END;
"DefPrgInSuf:= DftSfx;
"DefImpInSuf:= ImpSfx;
"RelocTab:= NIL;
"pRelTab:= NIL;
"firstRelVal:= 0L;
"lastRelVal:= 0L;
"realForm:= 0;
"extendedCode:= FALSE;
"IF dialog() THEN
$ReportCodeLen (DATAstart, VarNow, DATALen);
$BeginWriting;
$CodeOutput;
"ELSE
$TermProcess (1)
"END;
 END MM2Link.
 
(* $FFE1220A$0001156A$000125A1$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$00001DD2$FFFD709E$00013BC1$FFFD709E$0000ADB9$FFFD709E$FFFD709E$FFFD709E$FFFD709E$0000FE06$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFFD709E$FFF6AA4D$00009428$FFFD709E$0000A492$FFFD709E$0000AF05$FFFD709E$FFFD709E$00004289$FFFD709E$FFF6AAC9$FFFD709E$00008454$FFFD709E$FFFD709E$FFFD709E$00001D7DT.......T.......T.......T.......T.......T.......T.......T.......T.......T......T$FF77848C$00001DA5$0000A941$0000A9CA$0000A971$00000036$00000049$00000036$00000044$0000A941$0000A9CA$0000AD52$0000ADC5$00001DCE$00001D7D$FF77848C*)
