 MODULE ModRef;
 (*$R-,Z+*)
 
 (* TO DO
!- comp-opts auswerten - zumindest: $N, um Runtime mit in Liste aufzunehmen,
#ansonsten evtl. (optional?) $I, $C, $O, $U
 
!- auch name des make-files bestimmbar machen!
 *)
 
 (*---------------------------------------------------------------------------
!* BuildMakeFile-Utility fr Megamax Modula-2
!*
!*    Holt sich vom Benutzer eine Sourcedatei (per Fileselektor)
!*    und erstellt dazu einen vollstndigen Baum aller Import-
!*    abhngigkeiten. Dieser Baum wird in einer Datei mit der
!*    Endung M2M in einem Format abgelegt, das fr das Make-
!*    Utility lesbar ist (Definition siehe dort).
!*
!* Argumente:   { Sourcefile | ["-"|"/"] Optionchar }
!* Optionchar:  "C"  unterdrckt evtl. Tastenabfrage am Ende
!*              "Q"  unterdrckt ALLE Ein-/Ausgaben
!*--------------------------------------------------------------------------
!* Version 1.4
!*--------------------------------------------------------------------------
!* CD     : Christian Driele
!* TT     : Thomas Tempelmann
!*--------------------------------------------------------------------------
!* Datum      Version  Author  Bemerkung (Arbeitsbericht)
!*--------------------------------------------------------------------------
!* 10.07.89            CD      Programmstruktur erdacht, losprogrammiert.
!* 13.07.89            TT      Programmstruktur berarbeitet, GetTok, Listen.
!* 27.07.89   1.0      CD      Grundversion erstellt.
!* 03.08.89            TT      Programm berarbeitet.
!* 19.08.89            TT      1. Modulsource ist Namensgeber f. Make-File
!*                             (Endung M2M); DefLibName wird auch ShellMsg
!*                             importiert; 1.Source wird mit "-MAIN" deklariert
!* 20.09.89   1.1      TT      Optimierte Token-Routine von Pat Maupin;
!*                             Wildcards bei Cmdline-Namen mglich
!* 23.11.89   1.2      TT      In Comments werden keine Token ausgewertet;
!*                             Bei Syntaxfehler wird Zeilennr. angezeigt.
!* 24.02.90   1.3      TT      Explizit angegebene Def-/Imp-Texte werden auch
!*                             gescanned, so als ob sie importiert wrden
!* 04.03.90            TT      Fehlende Sources werden mit '-NOSRC' gekenn-
!*                             zeichnet, soda nur ihre Codes geprft werden.
!* 10.11.90            TT      $R-,Z+
!* 04.03.91   1.4      TT      Option "-C" verhindert Warten am Ende.
!*)
 
 
 FROM Storage IMPORT ALLOCATE;
 
 FROM GEMEnv IMPORT InitGem, RC, GemHandle, DeviceHandle,
3ExitGem, CurrGemHandle;
 
 FROM MOSGlobals IMPORT defaultDrv, PathStr;
 
 FROM EasyGEM1 IMPORT SelectMask, SelectFile;
 
 FROM Strings IMPORT Upper, String, Assign, Append, StrEqual, Length,
4Empty, Pos, Space, Delete, Insert, Concat,
4Copy, Compare, Relation;
 
 FROM StrConv IMPORT CardToStr;
 
 FROM PathEnv IMPORT HomeReplaced, HomePath;
 FROM PathCtrl IMPORT PathList;
 FROM Paths IMPORT ListPos, SearchFile;
 
 FROM ShellMsg IMPORT DefPaths, ImpPaths, ModPaths, SrcPaths,
5ShellPath, DefLibName, DefSfx, ImpSfx, ModSfx,
5DefSrcSfx, ImpSrcSfx, ModSrcSfx;
 
 FROM Lists IMPORT List, CreateList, DeleteList, ListEmpty, RemoveEntry,
2NextEntry, AppendEntry, ResetList, CurrentEntry;
 
 FROM Files IMPORT File, Access, ReplaceMode, Open, Create, Close, Remove, EOF;
 
 FROM Directory IMPORT DefaultDrive, GetCurrentDir, SearchFirst, SearchNext,
6MakeFullPath, GetDTA, DTA, DirEntry, GetDTAEntry,
6QueryFiles;
 
 FROM FileNames IMPORT SplitName, DriveToStr, SplitPath, PathConc, NameUnique,
6NameConc, FilePrefix, ConcatName, ConcatPath;
 
 FROM AESForms IMPORT FormAlert;
 
 FROM PrgCtrl IMPORT TermProcess;
 
 IMPORT LibFiles;
 
 FROM SYSTEM IMPORT ASSEMBLER, ADR;
 
 FROM Text IMPORT WriteString, Write, WriteLn, ReadString, Read;
 
 FROM ArgCV IMPORT InitArgCV, PtrArgStr;
 
 FROM SysTypes IMPORT CHARSET;
 
 IMPORT InOut;
 
 (* FROM Binary IMPORT ReadBytes; *)
 
 
 TYPE
$ModTypes = (Mod, Imp, Def);
$ModStr   = ARRAY [0..79] OF CHAR;
$ModStrPtr= POINTER TO ModStr;
$CharSet  = SET OF CHAR;
$ErrType  = (outOfMemory);
$ModList  = List (* OF ModStrPtr *);
 
 CONST
$MaxImpEnd = 6;
 
 VAR
$SourceNotFound: BOOLEAN;
$WaitAtEnd  : BOOLEAN;
$DoIO       : BOOLEAN;
$ignoreCase : BOOLEAN;    (* Modulnamen Case-Sensitiv vergleichen? *)
$ok, err    : BOOLEAN;
$res        : INTEGER;
$makef      : File;
$LibOpened  : BOOLEAN;
$Lib        : LibFiles.LibFile;
$argc, argn : CARDINAL;
$DoingSearch: BOOLEAN;
$SearchPath : PathStr;
$argv       : ARRAY [0..20] OF PtrArgStr;
$SystemName : String;
 
 
 PROCEDURE Quit (Str : ARRAY OF CHAR);
"VAR but   : CARDINAL;
&AlStr : ARRAY [0..250] OF CHAR;
"BEGIN
$Remove (makef);
$IF LibOpened THEN LibFiles.CloseLib (Lib) END;
$IF Str [0] # 0C THEN
&Assign ('[3][', AlStr, ok);
&Append (Str, AlStr, ok);
&Append ('][Schade]', AlStr, ok);
&FormAlert (1, AlStr, but);
$END;
$TermProcess (1);
"END Quit;
 
 
 MODULE ModLists;
 
"IMPORT ModList, AppendEntry, ResetList, NextEntry, RemoveEntry, err, Upper,
)ignoreCase, ModStr, StrEqual, Assign, ErrType, ModStrPtr, Quit, ADR,
)ALLOCATE;
 
"EXPORT GetFromModList, InModList, PutInModList;
 
"VAR ok: BOOLEAN;
 
"PROCEDURE InModList (modName: ARRAY OF CHAR; list: ModList): BOOLEAN;
$VAR namePtr: ModStrPtr; name2: ModStr;
$BEGIN
&IF ignoreCase THEN Upper (modName) END;
&ResetList (list);
&LOOP
(namePtr:= NextEntry (list);
(IF namePtr = NIL THEN EXIT END;
(Assign (namePtr^, name2, ok);
(IF ignoreCase THEN Upper (name2) END;
(IF StrEqual (modName, name2) THEN
*RETURN TRUE
(END
&END;
&RETURN FALSE
$END InModList;
 
"PROCEDURE PutInModList (modName: ARRAY OF CHAR; VAR list: ModList);
$VAR namePtr: ModStrPtr;
$BEGIN
&NEW (namePtr);
&IF namePtr = NIL THEN
(Quit (' Kann keine neuen Module | mehr aufnehmen! ');
&END;
&Assign (modName, namePtr^, ok);
&AppendEntry (list, namePtr, err);
&IF err THEN
(Quit (' Kann keine neuen Module | mehr aufnehmen! ');
&END;
$END PutInModList;
 
"PROCEDURE GetFromModList (VAR modName: ARRAY OF CHAR;
<VAR list: ModList): BOOLEAN;
$VAR namePtr: ModStrPtr;
$BEGIN
&ResetList (list);
&namePtr:= NextEntry (list);
&IF namePtr = NIL THEN
(RETURN FALSE
&ELSE
(Assign (namePtr^, modName, ok);
(RemoveEntry (list, ok);
(RETURN TRUE
&END;
$END GetFromModList;
 
"END ModLists;
 
 
 MODULE ProcessedMods;
 
"IMPORT ModList, CreateList, ErrType, Quit, InModList, PutInModList, List;
 
"EXPORT Processed;
 
"VAR processedMods: List;
&err: BOOLEAN;
 
"PROCEDURE Processed (modName: ARRAY OF CHAR): BOOLEAN;
$BEGIN
&IF InModList (modName, processedMods) THEN
(RETURN TRUE
&ELSE
(PutInModList (modName, processedMods);
(RETURN FALSE
&END
$END Processed;
 
"BEGIN
$CreateList (processedMods, err);
$IF err THEN
&Quit (' Kann Liste >processedMods< | nicht anlegen!')
$END;
"END ProcessedMods;
 
 
 MODULE Tokens;
 
"IMPORT
$File, Access, Open, Close, StrEqual, Copy, Length,
$Pos, CHARSET, EOF, InOut, ADR, ReadString, Read,
$ASSEMBLER, Assign, Compare, Relation;
 
"EXPORT
$ImportTerminators, GetNextTok, OpenSrc, CloseSrc, Ident, Idents,
$currentFile, currentLine, linePtr;
 
"TYPE
$Ident  = (Eof, User, Comma, Semicolon, OpenBracket, CloseBracket,
.CommentBegin, CommentEnd,
.Operator, Number, StringConst,
.And, Array, Begin, By, Case, Const, Definition, Div, Do,
.Else, Elsif, End, Exit, Export, For, Forward, From, Goto,
.If, Implementation, Import, In, Loop, Modulo, Module, Not, Of,
.Or, Pervasive, Pointer, Procedure, Qualified, Record, Repeat,
.Return, Set, Table, Then, To, Type, Until, Var, While, With );
 
$Idents = SET OF Ident;
 
"CONST
$DLE = 20C; (* 16 dez. *)
$ImportTerminators = Idents {Export, Forward, Table, Type, Const,
@Module, Var, Procedure, Begin, End};
 
"VAR
$currentFile: ARRAY [0..141] OF CHAR;
$currentLine: CARDINAL;
$line: ARRAY [0..255] OF CHAR;
$linePtr: CARDINAL;
$ok, opened: BOOLEAN;
$src: File;
 
"PROCEDURE newLine (): BOOLEAN;
$VAR c: CHAR;
$BEGIN
&linePtr:= 0;
&LOOP
(IF EOF (src) THEN
*RETURN FALSE
(END;
(ReadString (src, line);
(IF line[0] # DLE THEN
*(*
,InOut.WriteString ('>');
,InOut.WriteString (line);
,InOut.WriteString ('<');
,InOut.WriteLn;
**)
*INC (currentLine);
*RETURN TRUE
(END;
(Read (src, c);
&END;
$END newLine;
 
"PROCEDURE OpenSrc (name: ARRAY OF CHAR);
$VAR dummy: BOOLEAN;
$BEGIN
&IF opened THEN
(HALT
&ELSE
(opened:= TRUE;
(Open (src, name, readSeqTxt);
(currentLine:= 0;
(Assign (name, currentFile, dummy);
(dummy:= newLine ();
&END
$END OpenSrc;
 
"PROCEDURE CloseSrc ();
$BEGIN
&opened:= FALSE;
&Close (src)
$END CloseSrc;
 
"PROCEDURE CheckKeyWord(VAR s: ARRAY OF CHAR): Ident;
$PROCEDURE eq (REF s1: ARRAY OF CHAR): BOOLEAN;
&BEGIN RETURN StrEqual (s, s1) END eq;
$VAR s1: CHAR;
$BEGIN
&s1:= s[1];
&CASE s[0] OF
&| 'A': IF s1 = 'N' THEN
/IF eq ('AND') THEN RETURN And END
-ELSIF s1 = 'R' THEN
/IF eq ('ARRAY') THEN RETURN Array END
-END;
&| 'B': IF s1 = 'E' THEN
/IF eq ('BEGIN') THEN RETURN Begin END
-ELSIF (s1 = 'Y') AND (s[2] = CHR(0)) THEN RETURN By END
&| 'C': IF s1 = 'A' THEN
/IF eq ('CASE') THEN RETURN Case END
-ELSIF s1 = 'O' THEN
/IF eq ('CONST') THEN RETURN Const END
-END;
&| 'D': IF s1 ='E' THEN
/IF eq ('DEFINITION') THEN RETURN Definition END
-ELSIF s1 = 'I' THEN
/IF eq ('DIV') THEN RETURN Div END
-ELSIF (s1 = 'O') AND (s[2] = CHR(0)) THEN RETURN Do END
&| 'E': IF (s1 = 'L') AND (s[2] = 'S') THEN
/IF eq ('ELSE') THEN RETURN Else
/ELSIF eq ('ELSIF') THEN RETURN Elsif END
-ELSIF s1 = 'N' THEN
/IF eq ('END') THEN RETURN End END
-ELSIF s1 = 'X' THEN
/IF eq ('EXIT') THEN RETURN Exit
/ELSIF eq ('EXPORT') THEN RETURN Export END
-END;
&| 'F': IF (s1='O') AND (s[2] = 'R') THEN
/IF s[3] = CHR(0) THEN RETURN For
/ELSIF eq ('FORWARD') THEN RETURN Forward END
-ELSIF s1 = 'R' THEN
/IF eq ('FROM') THEN RETURN From END
-END;
&| 'I': IF s1 = 'F' THEN
/IF s[2] = CHR(0) THEN RETURN If END
-ELSIF (s1 = 'M') AND (s[2] = 'P') THEN
/IF eq ('IMPLEMENTATION') THEN RETURN Implementation
/ELSIF eq ('IMPORT') THEN RETURN Import END
-ELSIF (s1 = 'N') AND (s[2] = CHR(0)) THEN RETURN In END;
&| 'L': IF s1 = 'O' THEN
/IF eq ('LOOP') THEN RETURN Loop END
-END;
&| 'M': IF (s1 = 'O') AND (s[2] = 'D') THEN
/IF s[3] = CHR(0) THEN RETURN Modulo
/ELSIF eq ('MODULE') THEN RETURN Module END
-END;
&| 'N': IF (s1 = 'O') AND (s[2] = 'T') AND (s[3] = CHR(0)) THEN
/RETURN Not
-END;
&| 'O': IF s[2] = CHR(0) THEN
/IF s1 = 'F' THEN RETURN Of
/ELSIF s1 = 'R' THEN RETURN Or END
-END;
&| 'P': IF s1 = 'O' THEN
/IF eq ('POINTER') THEN RETURN Pointer END
-ELSIF s1 = 'R' THEN
/IF eq ('PROCEDURE') THEN RETURN Procedure END
-ELSIF s1 = 'E' THEN
/IF eq ('PERVASIVE') THEN RETURN Pervasive END
-END;
&| 'Q': IF eq ('QUALIFIED') THEN RETURN Qualified END
&| 'R': IF s1 = 'E' THEN
/IF s[2] = 'C' THEN
1IF eq ('RECORD') THEN RETURN Record END
/ELSIF s[2] = 'P' THEN
1IF eq ('REPEAT') THEN RETURN Repeat END
/ELSIF s[2] = 'T' THEN
1IF eq ('RETURN') THEN RETURN Return END
/END
-END;
&| 'S': IF (s1 = 'E') AND (s[2] = 'T') AND (s[3] = CHR(0)) THEN
/RETURN Set
-END;
&| 'T': IF s1 = 'H' THEN
/IF eq ('THEN') THEN RETURN Then END
-ELSIF s1 = 'O' THEN
/IF s[2] = CHR(0) THEN RETURN To END
-ELSIF s1 = 'Y' THEN
/IF eq ('TYPE') THEN RETURN Type END
-ELSIF s1 = 'A' THEN
/IF eq ('TABLE') THEN RETURN Table END
-END;
&| 'U': IF eq ('UNTIL') THEN RETURN Until END
&| 'V': IF (s1 = 'A') AND (s[2] = 'R') AND (s[3] = CHR(0)) THEN
/RETURN Var
-END;
&| 'W': IF s1 = 'H' THEN
/IF eq ('WHILE') THEN RETURN While END
-ELSIF s1 = 'I' THEN
/IF eq ('WITH') THEN RETURN With END
-END
&ELSE
&END;
&RETURN User
$END CheckKeyWord;
 
"CONST
$Alphanumerics = CHARSET {'A'..'Z','a'..'z','0'..'9','_','@'};
$SecondLetters = CHARSET {'A','E','F','H','I','L'..'O','R','U','X','Y'};
 
"PROCEDURE skipComment (): BOOLEAN;
 
$(*$Z-*)
$PROCEDURE pos (REF s1: ARRAY OF CHAR; VAR s2: ARRAY OF CHAR; p: CARDINAL): INTEGER;
&(*$L-*) BEGIN ASSEMBLER JMP Pos END END pos; (*$L=*)
$(*$Z+*)
 
$VAR nest, p: CARDINAL; p1, p2: INTEGER;
 
$BEGIN
&p:= linePtr;
&nest:= 1;
&REPEAT
(p1:= pos ('(*', line, p);
(p2:= pos ('*)', line, p);
(IF (p1 >= 0) OR (p2 >= 0) THEN
*IF (p2 < 0) THEN
,INC (nest);
,p:= p1 + 2
*ELSIF p1 < 0 THEN
,DEC (nest);
,p:= p2 + 2
*ELSE
,IF p1 < p2 THEN
.INC (nest);
.p:= p1 + 2
,ELSE
.DEC (nest);
.p:= p2 + 2
,END
*END
(ELSE
*IF NOT newLine () THEN
,RETURN FALSE
*END;
*p:= linePtr
(END;
&UNTIL nest = 0;
&linePtr:= p;
&RETURN TRUE
$(*$D-*)
$END skipComment;
 
"PROCEDURE GetToken (VAR s: ARRAY OF CHAR): Ident;
$VAR i: CARDINAL;
(ch: CHAR;
(myToken: Ident;
$BEGIN
&LOOP
(ch:= line[linePtr];
(IF ch > ' ' THEN EXIT END;
(IF ch = 0C THEN
*s[0]:= CHR(0);
*IF NOT newLine () THEN
,RETURN Eof
*END;
(ELSE
*INC (linePtr)
(END
&END;
 
&i:= linePtr + 1;
&myToken:= Operator;
&s[0]:= ch;
&s[1]:= 0C;
 
&CASE ch OF
&| '0'..'9': myToken:= Number;
2WHILE line[i] IN Alphanumerics DO
4INC(i)
2END;
2Copy (line, linePtr, i-linePtr, s, ok);
&| 'A'..'Z': WHILE line[i] IN CHARSET{'A'..'Z'} DO
4INC(i)
2END;
2IF line[i] IN Alphanumerics THEN
4REPEAT
6INC(i);
4UNTIL NOT (line[i] IN Alphanumerics);
4Copy (line, linePtr, i-linePtr, s, ok);
4myToken:= User
2ELSE
4(* Slice (s,line,linePtr,i-linePtr); *)
4Copy (line, linePtr, i-linePtr, s, ok);
4linePtr:= i;
4IF s[1] IN SecondLetters THEN
6RETURN CheckKeyWord(s)
4ELSE
6RETURN User
4END;
2END;
&| 'a'..'z',
('@','_':  myToken:= User;
2WHILE line[i] IN Alphanumerics DO
4INC(i)
2END;
2Copy (line, linePtr, i-linePtr, s, ok);
&|  '(':     IF line[i] = '*' THEN
4INC (i);
4myToken:= CommentBegin
2END;
&|  '*':     IF line[i] = ')' THEN
4INC (i);
4myToken:= CommentEnd
2END;
&|  "'",
)'"':     myToken:= StringConst;
2LOOP
4IF line[i] = CHR(0) THEN EXIT END;
4IF line[i] = line[linePtr] THEN
6INC (i);
6EXIT
4END;
4INC (i)
2END;
&|  ',':     myToken:= Comma;
&|  ';':     myToken:= Semicolon;
&|  '[':     myToken:= OpenBracket;
&|  ']':     myToken:= CloseBracket;
&ELSE
(Copy (line, linePtr, i-linePtr, s, ok);
((* InOut.Write ('>'); InOut.WriteCard (ORD(line[linePtr]),0); *)
&END;
&linePtr:= i;
&RETURN myToken
$END GetToken;
 
"PROCEDURE GetNextTok (VAR s: ARRAY OF CHAR): Ident;
$VAR myToken: Ident;
$BEGIN
&LOOP
(myToken:= GetToken (s);
(IF myToken = Eof THEN RETURN Eof END;
(IF myToken = CommentBegin THEN
*IF NOT skipComment () THEN RETURN Eof END;
(ELSE
*RETURN myToken
(END
&END;
$END GetNextTok;
 
"BEGIN
$opened:= FALSE;
"END Tokens;
 
 
 PROCEDURE GetMainName (VAR s: ARRAY OF CHAR): BOOLEAN;
 
"VAR
$path: ARRAY [0..127] OF CHAR;
$name, dummy: ARRAY [0..12] OF CHAR;
$ior: INTEGER; ch: CHAR; fok: BOOLEAN;
 
"PROCEDURE getName;
$VAR dta: DTA; entry: DirEntry;
$BEGIN
&GetDTA (dta);
&GetDTAEntry (dta, entry);
&ConcatPath (SearchPath, entry.name, s)
$END getName;
 
"PROCEDURE notfound;
$BEGIN
&IF DoIO THEN
(InOut.WriteString (s);
(InOut.WriteString (' nicht gefunden!');
(InOut.WriteLn ();
(InOut.FlushKbd ();
(InOut.Read (ch)
&END
$END notfound;
 
"BEGIN
$IF DoingSearch THEN
&SearchNext (ior);
&IF ior >= 0 THEN
(getName;
(RETURN TRUE
&END;
&DoingSearch:= FALSE;
$END;
$IF argc > 1 THEN
&(* Namen aus Cmdline holen *)
&LOOP
(IF argn >= argc THEN
*RETURN FALSE
(ELSE
*Assign (argv[argn]^, path, ok);
*INC (argn);
*IF (path[0] # '-') & (path[0] # '/') THEN
,MakeFullPath (path, ior);
,SearchFile (path, SrcPaths, fromStart, fok, s);
,IF NOT fok THEN
.notfound;
.RETURN FALSE
,END;
,ConcatPath (s, path, s);
,EXIT
*END
(END
&END
$ELSE
&(* Namen erfragen *)
&ConcatPath (SelectMask, NameConc ('*', ModSrcSfx), SelectMask);
&s[0]:= 0C;
&SelectFile ('Whle Hauptmodul', s, fok);
&IF NOT fok THEN
(RETURN FALSE
&END
$END;
$IF NOT NameUnique (s) THEN
&SearchFirst (s, QueryFiles, ior);
&DoingSearch:= (ior >= 0);
&IF DoingSearch THEN
(SplitPath (s, SearchPath, dummy);
(getName
&ELSE
(notfound;
(RETURN FALSE
&END;
$END;
$RETURN TRUE
"END GetMainName;
 
 
 PROCEDURE GetFileName (ModName, Sfx: ARRAY OF CHAR; Paths: PathList;
7VAR FileName: ARRAY OF CHAR; VAR found, inlib: BOOLEAN);
"VAR entry: LibFiles.LibEntry;
"BEGIN
$Assign (ModName, FileName, ok);
$Delete (FileName, 8, 99, ok);
$Append ('.', FileName, ok);
$Append (Sfx, FileName, ok);
$IF LibOpened & StrEqual (Sfx, DefSfx) THEN
&LibFiles.LookUp (Lib, FileName, entry, res);
&inlib:= res>= 0;
&IF inlib THEN RETURN END
$END;
$SearchFile (FileName, Paths, fromStart, found, FileName);
"END GetFileName;
 
 
 PROCEDURE SyntaxError (REF msg, s: ARRAY OF CHAR);
"VAR errStr: ARRAY [0..250] OF CHAR; c: CHAR; but: CARDINAL;
"BEGIN
$errStr:= ' Syntaxfehler in Datei: | ';
$Append (currentFile, errStr, ok);
$CloseSrc;
$IF s[0] # 0C THEN
&Append ('| Zeile: ', errStr, ok);
&Append (CardToStr (currentLine,0), errStr, ok);
&Append (', Spalte: ', errStr, ok);
&Append (CardToStr (linePtr,0), errStr, ok);
$END;
$Append ('| ', errStr, ok);
$Append (msg, errStr, ok);
$IF s[0] # 0C THEN
&Append ('| >', errStr, ok);
&Append (s, errStr, ok);
$END;
$Insert ('[3][', 0, errStr, ok);
$Append ('][Weiter|Abbruch]', errStr, ok);
$FormAlert (1, errStr, but);
$IF but = 2 THEN Quit ('') END;
"END SyntaxError;
 
 PROCEDURE ReadModName (VAR ModName: ModStr; VAR typ: ModTypes): BOOLEAN;
"VAR s: ModStr;
&id: Ident;
&errStr: String;
"BEGIN
$id:= GetNextTok (s);
$IF id = Definition THEN
&typ:= Def;
&id:= GetNextTok (s);
$ELSIF id = Implementation THEN
&typ:= Imp;
&id:= GetNextTok (s);
$ELSE
&typ:= Mod
$END;
$IF id # Module THEN
&SyntaxError ('Moduldeklaration erwartet', s);
&RETURN FALSE
$END;
$id:= GetNextTok (ModName);
$IF id # User THEN
&SyntaxError ('Modulname erwartet', s);
&RETURN FALSE
$END;
$(* Semikolon wird in 'ReadImports' berlesen *)
$RETURN TRUE
"END ReadModName;
 
 PROCEDURE ReadImports (VAR importedMods: List);
 
"VAR Tok, modName: ModStr;
&id: Ident;
&len: CARDINAL;
&firstImp: BOOLEAN;
 
"CONST argOffset = 10; (* Spaces vor Import-Liste *)
 
"PROCEDURE dropName (): BOOLEAN;
$BEGIN
&IF GetNextTok (modName) <> User THEN
(SyntaxError ('Modulname erwartet', modName);
(RETURN FALSE
&ELSE
(IF NOT InModList (modName, importedMods) THEN
*PutInModList (modName, importedMods);
*IF firstImp THEN
,WriteString (makef, '  -IMPORT');
,len:= argOffset;
,firstImp:= FALSE
*END;
*IF (len # argOffset) & (len + Length (modName) > 77) THEN
,WriteLn (makef);
,WriteString (makef, '         ');
,len:= argOffset;
*END;
*INC (len, Length (modName) + 1);
*Write (makef, ' ');
*WriteString (makef, modName);
(END;
(RETURN TRUE
&END;
$END dropName;
 
"BEGIN
$id:= GetNextTok (Tok);      (* Semikolon berlesen *)
$IF id = OpenBracket THEN    (* es war ein '[' *)
&id:= GetNextTok (Tok);    (* Priority berlesen *)
&IF id # Number THEN SyntaxError ('Zahl erwartet', Tok); RETURN END;
&id:= GetNextTok (Tok);    (* Priority berlesen *)
&IF id # CloseBracket THEN SyntaxError ('"]" erwartet', Tok); RETURN END;
&id:= GetNextTok (Tok);      (* Semikolon berlesen *)
$END;
$IF id # Semicolon THEN SyntaxError ('";" erwartet', Tok); RETURN END;
 
$firstImp:= TRUE;
$LOOP
&id:= GetNextTok (Tok);
&IF id = Eof THEN SyntaxError ('Dateiende erreicht', Tok); EXIT END;
 
&(* Dabei gefundene Import-Namen in die Liste 'importedMods' einfgen: *)
&(* & Import-Namen merken *)
&IF id = From THEN
(IF NOT dropName () THEN EXIT END;
(id:= GetNextTok (Tok); (* Den Identifier IMPORT lesen *)
(REPEAT
*id:= GetNextTok (Tok);
*IF id = Eof THEN SyntaxError ('Dateiende erreicht', Tok); EXIT END;
(UNTIL id = Semicolon
&ELSIF id = Import THEN
(LOOP
*IF NOT dropName () THEN EXIT END;
*id:= GetNextTok (Tok);
*IF id = Semicolon THEN
,EXIT
*ELSIF id # Comma THEN
,SyntaxError ('"," erwartet', Tok);
,EXIT
*END
(END;
&ELSE
(IF NOT (id IN ImportTerminators) THEN
*SyntaxError ('unbekanntes Schlsselwort', Tok)
(END;
(EXIT
&END;
$END;
$IF NOT firstImp THEN
&WriteString (makef, ';');
&WriteLn (makef);
$END
"END ReadImports;
 
 PROCEDURE ProcessModule (mainModName: ARRAY OF CHAR);
 
"VAR
$importedMods: List;
$modName     : ModStr;
$typ         : ModTypes;
$fileName    : String;
$ignore      : BOOLEAN;
$upperMainName: ModStr;
 
"PROCEDURE reportMissingSource (typ: ModTypes);
$BEGIN
&SourceNotFound:= TRUE;
&IF DoIO THEN
(IF typ = Def THEN
*InOut.WriteString ('Definitions-')
(ELSIF typ = Imp THEN
*InOut.WriteString ('Implementations-')
(END;
(InOut.WriteString ('Source zu ');
(InOut.WriteString (mainModName);
(InOut.WriteString (' fehlt.');
(InOut.WriteLn ();
&END
$END reportMissingSource;
 
"BEGIN
$IF NOT Processed (mainModName) THEN
 
&Assign (mainModName, upperMainName, ok);
&IF ignoreCase THEN Upper (upperMainName) END;
&
&WriteString (makef, mainModName);
&WriteLn (makef);
 
&(* Das SYSTEM-Modul ignorieren! *)
&ignore:= StrEqual (SystemName, upperMainName);
 
&(* DEF-Code finden und ggf. merken *)
&IF ~ignore THEN
(GetFileName (mainModName, DefSfx, DefPaths, fileName, ok, ignore)
&END;
 
&(* Befindet sich das Modul in der DEF-Library, wird es ignoriert *)
&IF ignore THEN
(WriteString (makef, '  -IGNORE');
(WriteLn (makef);
&ELSE
 
((*
*InOut.WriteString ('Import: ');
*InOut.WriteString (mainModName);
*InOut.WriteLn ();
(*)
 
(WriteString (makef, '  -DEF    ');
(WriteString (makef, fileName);
(WriteLn (makef);
 
((* Liste f. importierte Module anlegen *)
(CreateList (importedMods, err);
(IF err THEN
*Quit (' Kann Liste >importedMods< | nicht anlegen!')
(END;
 
((* DEF-Source finden und ggf. merken *)
(GetFileName (mainModName, DefSrcSfx, SrcPaths, fileName, ok, err);
(IF ok THEN
*WriteString (makef, '  -SOURCE ');
*WriteString (makef, fileName);
*WriteLn (makef);
 
*(* Falls Source vorhanden, diesen scannen *)
*OpenSrc (fileName);
*IF ReadModName (modName, typ) THEN
,IF typ # Def THEN
.SyntaxError ('Def-Modul erwartet', '')
,ELSE
.IF ignoreCase THEN Upper (modName) END;
.IF NOT StrEqual (modName, upperMainName) THEN
0SyntaxError ('Falsches Modul! Erwartet:', mainModName)
.ELSE
0ReadImports (importedMods)
.END
,END
*END;
*CloseSrc;
(ELSE
*WriteString (makef, '  -NOSRC');
*WriteLn (makef);
*reportMissingSource (Def)
(END;
 
((* IMP-Codes finden und ggf. merken *)
(WriteString (makef, '  -IMP    ');
(GetFileName (mainModName, ImpSfx, ImpPaths, fileName, ok, err);
(WriteString (makef, fileName);
(WriteLn (makef);
 
((* IMP-Source finden und ggf. merken *)
(GetFileName (mainModName, ImpSrcSfx, SrcPaths, fileName, ok, err);
(IF ok THEN
*WriteString (makef, '  -SOURCE ');
*WriteString (makef, fileName);
*WriteLn (makef);
 
*(* Falls IMP-Source vorhanden, diesen scannen *)
*OpenSrc (fileName);
*IF ReadModName (modName, typ) THEN
,IF ignoreCase THEN Upper (modName) END;
,IF typ # Imp THEN
.SyntaxError ('Impl-Modul erwartet', '')
,ELSE
.IF ignoreCase THEN Upper (modName) END;
.IF NOT StrEqual (modName, upperMainName) THEN
0SyntaxError ('Falsches Modul! Erwartet:', mainModName)
.ELSE
0ReadImports (importedMods)
.END
,END
*END;
*CloseSrc;
(ELSE
*WriteString (makef, '  -NOSRC');
*WriteLn (makef);
*reportMissingSource (Imp)
(END;
 
((* Nun die importierten Moduln bearbeiten *)
(WHILE GetFromModList (modName, importedMods) DO
*ProcessModule (modName);
(END;
 
(DeleteList (importedMods, ok)
&END
$END
"END ProcessModule;
 
 
 PROCEDURE ProcessMainSource (mainSourceName: ARRAY OF CHAR;
=first: BOOLEAN);
 
"VAR
$importedMods : List;
$modName      : ModStr;
$fileName     : String;
$typ          : ModTypes;
 
"BEGIN
 
$(* Liste f. importierte Module anlegen *)
$CreateList (importedMods, err);
$IF err THEN
&Quit (' Kann Liste >ImportedMods< | nicht anlegen!| (Speichermangel) ')
$END;
$
$OpenSrc (mainSourceName);
$IF ReadModName (modName, typ) THEN
&IF typ = Mod THEN
(IF NOT Processed (modName) THEN
*IF DoIO THEN
,InOut.WriteString ('Main:   ');
,InOut.WriteString (modName);
,InOut.WriteLn ();
*END;
*WriteString (makef, modName);
*WriteLn (makef);
*WriteString (makef, '  -MAIN');
*WriteLn (makef);
*IF typ = Mod THEN
,WriteString (makef, '  -MOD    ');
,GetFileName (modName, ModSfx, ModPaths, fileName, ok, err);
*(*
*ELSE
,WriteString (makef, '  -IMPMOD ');
,GetFileName (modName, ImpSfx, ImpPaths, fileName, ok, err);
**)
*END;
*WriteString (makef, fileName);
*WriteLn (makef);
*WriteString (makef, '  -SOURCE ');
*WriteString (makef, mainSourceName);
*WriteLn (makef);
*(* Source scannen *)
*ReadImports (importedMods);
(END;
&ELSE
((*
)* Imp/Def-Module werden wie importierte Module behandelt
)*)
(PutInModList (modName, importedMods);
&END;
$END;
$CloseSrc;
$
$(* Nun die importierten Module bearbeiten *)
$WHILE GetFromModList (modName, importedMods) DO
&ProcessModule (modName);
$END;
"
$DeleteList (importedMods, ok);
"END ProcessMainSource;
 
 
 PROCEDURE GetOptions;
"VAR argn: CARDINAL; s: String;
"BEGIN
$argn:= 1;
$WHILE argn < argc DO
&Assign (argv[argn]^, s, ok);
&INC (argn);
&IF (s[0] = '-') OR (s[0] = '/') THEN
(IF CAP (s[1]) = 'C' THEN
*WaitAtEnd:= FALSE
(ELSIF CAP (s[1]) = 'Q' THEN
*DoIO:= FALSE
(END
&END
$END
"END GetOptions;
 
 
 VAR
$DevHdl  : DeviceHandle;
$GemHdl  : GemHandle;
$first   : BOOLEAN;
$int     : INTEGER;
$c       : CHAR;
$fn,
$modName : String;
 
 BEGIN
"InitGem (RC, DevHdl, ok);
"IF ~ ok THEN HALT END;
"GemHdl:= CurrGemHandle ();
 
"HomePath:= ShellPath;
"
"InitArgCV (argc, argv);
"argn:= 1;
"DoingSearch:= FALSE;
"WaitAtEnd:= TRUE;
"DoIO:= TRUE;
"SourceNotFound:= FALSE;
"first:= TRUE;
"ignoreCase:= TRUE;
"
"GetOptions;
"
 (*
"Comp[1]:= 'TYPE';
"Comp[2]:= 'CONST';
"Comp[3]:= 'VAR';
"Comp[4]:= 'PROCEDURE';
"Comp[5]:= 'BEGIN';
"Comp[6]:= 'END';
"From   := 'FROM';
"Import := 'IMPORT';
"Module := 'MODULE';
"Implem := 'IMPLEMENTATION';
 *)
 
"SystemName:= 'SYSTEM';
 
"IF DoIO THEN
$InOut.WriteLn ();
$InOut.WriteString (' ModRef V1.4 fr Megamax Modula-2');
$InOut.WriteLn ();
$InOut.WriteString (' Erstellt 7/1989 von Christian Driele & Thomas Tempelmann');
$InOut.WriteLn ();
$InOut.WriteLn ();
"END;
 
"makef:= File (NIL);
 
"LibFiles.OpenLib (Lib, HomeReplaced (DefLibName), res);
"LibOpened:= res >= 0;
"
"WHILE GetMainName (modName) DO
$IF first THEN
&ConcatName (modName, 'M2M', fn);
&MakeFullPath (fn, int);
&Create (makef, fn, writeSeqTxt, replaceOld);
&IF DoIO THEN
(InOut.WriteString ('Erzeuge ');
(InOut.WriteString (fn);
(InOut.WriteLn ();
&END
$END;
$ProcessMainSource (modName, first);
$first:= FALSE;
"END;
 
"IF DoIO & SourceNotFound THEN
$InOut.WriteString ('Die fehlenden Sources werden vom Make-Programm ignoriert!');
$IF WaitAtEnd THEN
&InOut.WriteLn;
&InOut.WriteString ('Taste...');
&InOut.FlushKbd ();
&InOut.Read (c)
$END
"END;
 
"LibFiles.CloseLib (Lib);
"Close (makef);
"ExitGem (GemHdl);
 END ModRef.
  
(* $FFEE9443$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFEC50C9$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFEEF582$FFF029D2$FFF029D2$FFF029D2$00001C6E$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$00002EFA$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$FFF029D2$0000653AT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00006343$FFED074A$00006358$0000631B$000064DE$0000653A$0000652F$FFED074A$FFED074A$FFED074A$00003F5D$00006382$000062DD$000062ED$0000633A$00006331*)
