 IMPLEMENTATION MODULE EventHandler;
 (*$L-, Y+*)
 
 (*  Implementation des 'EventHandler's der Megamax Modula-2 Biblothek
!*
!*  geschrieben von Manuel Chakravarty          Created: 9.9.87
!*
!*  Version 2.2    V#0129
!*)
!
 (* 09.09.87     | Definitionen
!* 13.09.87     | 'InstallWatchDog' und 'DeInstallWatchDog' implementiert
!* 21.09.87     | 'commonHandler' und seine Benutzer impl.+ time/msgHdler
!* 22.09.87     | 'HandleEvents' impl.
!* 28.09.87     | Message-Install's lsen bei einem 'HandleEvents' jetzt
!*                autom. eine Abfrage nach Message-Events aus, diese Eve-
!*                nts werden falls nicht Abgefangen noch mal mittels
!*                'WriteToAppl' gesendet. 'ShareTime' impl.
!* 30.09.87     | SysInstall impl.
!* 07.11.87     | Anpassung an GEM V 0.10
!* 19.01.88 TT  | levelCounter: deInstall korrgiert, searchList optimiert
!* 30.03.88     | 'HandleEvents' ruft jetzt bei Msg.events nur noch die
!*                Proc's auf, die fr den aufgetrettenen Msg.event-Typ
!*                angemeldet sind (einzige Ausnahme 'unspecMessage').
!* 23.12.88     | 'ReadFromAppl' wird beim message add wirklich nur aufge-
!*                rufen, falls die Nachricht lnger als 16 Byte ist. Auerdem
!*                wird des HIGH-Wert fr die open arrays richtig bergeben.
!* 01.03.89     | *** Def-nderung *** auf 2.00. Neu: 'FlushEvents'
!* 17.08.89     | 'KeyboardProc' um 'keys' erweitert
!* 15.02.90     | Anpassung an Compilerversion 4.0
!* 21.05.93 TT  | Reentry bei ShareTime/FlushEvents verhindert.
!*)
 
 
 FROM SYSTEM     IMPORT ASSEMBLER, WORD,
7ADR;
 
 FROM Storage    IMPORT ALLOCATE, DEALLOCATE;
 
 FROM PrgCtrl    IMPORT EnvlpCarrier, TermCarrier,
7CatchProcessTerm, SetEnvelope;
 
 FROM ResCtrl    IMPORT RemovalCarrier,
7CatchRemoval;
 
 FROM MOSGlobals IMPORT OutOfMemory, MemArea;
 
 FROM GrafBase   IMPORT Point, Rectangle,
7Rect;
2
 FROM GEMGlobals IMPORT GemChar, MButtonSet, SpecialKeySet;
4
 IMPORT GEMShare;
 
 FROM GEMEnv     IMPORT ApplicationID;
 
 FROM AESEvents  IMPORT unspecMessage, menuSelected, windRedraw, windTopped,
7windClosed, windFulled, windArrowed, windHSlid,
7windVSlid, windSized, windMoved, windNewTop, accOpen,
7accClose, Event, EventSet, ArrowedMode, MessageBuffer,
7RectEnterMode,
7MultiEvent;
 
 FROM AESMisc    IMPORT ReadFromAppl, WriteToAppl;
 
 
 
 TYPE    ptrCarrier      =POINTER TO carrier;
(carrier         =RECORD
;proc         :PROC;   (* Da Aufruf per JSR, sind *
R* die Param. egal.        *)
;CASE (*messageEvent*):BOOLEAN OF
=FALSE : |
=TRUE  : msgType:CARDINAL|
;END;
;next         :ptrCarrier;
;level        :INTEGER;
;(*future     :LONGWORD;*)
9END;
9
 VAR     keyboardList,buttonList,stRectList,
(ndRectList,messageList,timerList        :ptrCarrier;
(
(watchDogExecuted: BOOLEAN; (*  Semaphore between 'FlushEvents' and
D*  the watch dog servers. *)
(flushExecuted   : INTEGER; (*  semaphore f. FlushEvents/ShareTime *)
(
(modLevel        : INTEGER;
(
(voidI           : INTEGER;
(
(
 (*  commonHandler - Fhrt Handling fr 'keyboard', 'mouseButton', 'firstRect'
!*                  'secondRect' durch. 'data' sind die Daten, die
!*                  an die einzelnen Proc's als Parameter bergeben werden
!*                  sollen. 'list' ist die zu bearbeitende Proc-Liste.
!*)
 (*$J-*)
 PROCEDURE commonHandler(REF data: ARRAY OF WORD; list: ptrCarrier): BOOLEAN;
 (*$J=*)
 
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0        ; 'list' -> A0
(MOVE.W  -(A3),D1        ; HIGH(data) -> D1
(MOVE.L  -(A3),A1        ; ADR(data) -> A1
(CMPA.L  #NIL,A0
(BEQ     endTRUE         ; Leere List -> RETURN TRUE
(
(MOVE.W  #TRUE, watchDogExecuted
 loop
(MOVE.W  D1,D2           ; kopiere Param. auf A3-Stack
(MOVE.L  A1,A2
 loop2
(MOVE.W  (A2)+,(A3)+
(DBF     D2,loop2
(MOVE.L  carrier.proc(A0),A2 ; Hole Proceduraddresse
(MOVEM.L D1/A0-A1,-(A7)
(JSR     (A2)                ; und springe Userproc. an
(MOVEM.L (A7)+,D1/A0-A1
(MOVE.L  carrier.next(A0),A0 ; hole Zeiger auf nchstes Listenelement
(CMPA.L  #NIL,A0
(BEQ     ende            ; Listenende? => Fertig.
(TST.W   -(A3)
(BNE     loop            ; Falls Userproc. keinen Abbruch wnscht weiter
(MOVE.W  #FALSE,(A3)+
(BRA     ende
(
 endTRUE
(MOVE.W  #TRUE,(A3)+
 ende
$END;
"END commonHandler;
(
 (*$J-*)
 PROCEDURE keyboardHandler(VAR ch: GemChar; VAR keys: SpecialKeySet): BOOLEAN;
 (*$J=*)
 
 CONST   noParamB        =8;
(noParamW        =noParamB DIV 2 - 1; (* -1, da HIGH mit 0 beginnt *)
 
 BEGIN
"ASSEMBLER
(LEA     -noParamB(A3),A0
(MOVE.L  A0,(A3)+
(MOVE.W  #noParamW,(A3)+
(MOVE.L  keyboardList,(A3)+
(JSR     commonHandler
(MOVE.W  -(A3),D0
(SUBQ.L  #noParamB,A3
(MOVE.W  D0,(A3)+
"END;
 END keyboardHandler;
 
 (*$J-*)
 PROCEDURE buttonHandler(clicks:CARDINAL;loc:Point;buts:MButtonSet;
8specials:SpecialKeySet):BOOLEAN;
 (*$J=*)
8
 CONST   noParamB        =10;
(noParamW        =noParamB DIV 2 - 1;
 
 BEGIN
"ASSEMBLER
(LEA     -noParamB(A3),A0
(MOVE.L  A0,(A3)+
(MOVE.W  #noParamW,(A3)+
(MOVE.L  buttonList,(A3)+
(JSR     commonHandler
(MOVE.W  -(A3),D0
(SUBA.W  #noParamB,A3
(MOVE.W  D0,(A3)+
"END;
 END buttonHandler;
 
 (*$J-*)
 PROCEDURE stRectHandler(loc:Point;buts:MButtonSet;
8specials:SpecialKeySet):BOOLEAN;
 (*$J=*)
 
 CONST   noParamB        =8;
(noParamW        =noParamB DIV 2 - 1;
 
 BEGIN
"ASSEMBLER
(LEA     -noParamB(A3),A0
(MOVE.L  A0,(A3)+
(MOVE.W  #noParamW,(A3)+
(MOVE.L  stRectList,(A3)+
(JSR     commonHandler
(MOVE.W  -(A3),D0
(SUBQ.L  #noParamB,A3
(MOVE.W  D0,(A3)+
"END;
 END stRectHandler;
 
 (*$J-*)
 PROCEDURE ndRectHandler(loc:Point;buts:MButtonSet;
8specials:SpecialKeySet):BOOLEAN;
 (*$J=*)
 
 CONST   noParamB        =8;
(noParamW        =noParamB DIV 2 - 1;
 
 BEGIN
"ASSEMBLER
(LEA     -noParamB(A3),A0
(MOVE.L  A0,(A3)+
(MOVE.W  #noParamW,(A3)+
(MOVE.L  ndRectList,(A3)+
(JSR     commonHandler
(MOVE.W  -(A3),D0
(SUBQ.L  #noParamB,A3
(MOVE.W  D0,(A3)+
"END;
 END ndRectHandler;
 
 (*$J-*)
 PROCEDURE messageHandler(msg:MessageBuffer):BOOLEAN;
 (*$J=*)
 
 BEGIN
"ASSEMBLER
(LEA     -16(A3),A0      ; ADR(msg) -> A0
(MOVE.W  (A0),D0         ; msg[0] (type of the message) -> D0
@; CASE msg[0] OF
(CMP.W   #menuSelected,D0
(BEQ     copy2
(CMP.W   #windRedraw,D0
(BEQ     copy5
(CMP.W   #windTopped,D0
(BEQ     copy1
(CMP.W   #windClosed,D0
(BEQ     copy1
(CMP.W   #windFulled,D0
(BEQ     copy1
(CMP.W   #windArrowed,D0
(BEQ     copy2
(CMP.W   #windHSlid,D0
(BEQ     copy2
(CMP.W   #windVSlid,D0
(BEQ     copy2
(CMP.W   #windSized,D0
(BEQ     copy5
(CMP.W   #windMoved,D0
(BEQ     copy5
(CMP.W   #windNewTop,D0
(BEQ     copy1
(CMP.W   #accOpen,D0
(BEQ     copy1from4
(CMP.W   #accClose,D0
(BEQ     copy1
(
(MOVEQ   #unspecMessage,D0  ; keine message vom AES
(LEA     (A0),A1
(MOVEQ   #7,D1
(BRA     cont
(
 copy1
(LEA     6(A0),A1        ; ab msg[3]
(MOVEQ   #0,D1           ; 1 Wort
(BRA     cont
(
 copy1from4
(LEA     8(A0),A1
(MOVEQ   #0,D1
(BRA     cont
(
 copy2
(LEA     6(A0),A1
(MOVEQ   #1,D1
(BRA     cont
 
 copy5
(LEA     6(A0),A1
(MOVEQ   #4,D1
(
 cont
(MOVEQ   #TRUE,D2        ; init. momentanes Ergebnis
(MOVE.L  messageList,A2
(
 loop
(CMPA.L  #NIL,A2
(BEQ     ende            ; Falls Listenende, dann Fertig.
(CMP.W   carrier.msgType(A2),D0
(BEQ     typeMatch       ; springe, falls Listenelem.typ = ges. Typ
(TST.W   carrier.msgType(A2)
(BNE     skipElem        ; springe, falls Listenelem.typ # unspecMessage
(MOVEM.L D0-D1/A0-A2,-(A7)
(MOVE.L  A0,A1           ; Kopierparam. fr 'unspecMessage'
(MOVEQ   #7,D1
(BRA     loop2
(
 typeMatch
(MOVEM.L D0-D1/A0-A2,-(A7)
 loop2
(MOVE.W  (A1)+,(A3)+     ; kopiere Param.
(DBF     D1,loop2
(MOVE.L  carrier.proc(A2),A2
(JSR     (A2)            ; springe Userproc. an
(MOVEM.L (A7)+,D0-D1/A0-A2
(MOVE.W  -(A3),D2        ; neues momentanes Ergebnis -> D2
 skipElem
(MOVE.L  carrier.next(A2),A2 ; nchstes Listenelem.
(TST.W   D2
(BNE     loop            ; nochmal, falls momentanes Ergebnis # FALSE
(
(MOVE.W  #TRUE, watchDogExecuted
 ende
(MOVE.L  A0,A3           ; A3-Stack korrigieren
(MOVE.W  D2,(A3)+        ; momentanes Ergebnis zurckgeben
"END;
 END messageHandler;
 
 (*$J-*)
 PROCEDURE timerHandler():BOOLEAN;
 (*$J=*)
 
 BEGIN
"ASSEMBLER
(MOVE.L  timerList,A0
(CMPA.L  #NIL,A0
(BEQ     endTRUE         ; Leere List -> RETURN TRUE
(
 loop
(MOVE.L  carrier.proc(A0),A2 ; Hole Proceduraddresse
(MOVE.L  A0,-(A7)
(JSR     (A2)                ; und springe Userproc. an
(MOVE.L  (A7)+,A0
(MOVE.L  carrier.next(A0),A0 ; hole Zeiger auf nchstes Listenelement
(CMPA.L  #NIL,A0
(BEQ     ende            ; Listenende? => Fertig.
(TST.W   -(A3)
(BNE     loop            ; Falls Userproc. keinen Abbruch wnscht weiter
(MOVE.W  #FALSE,(A3)+
(BRA     ende
(
 endTRUE
(MOVE.W  #TRUE,(A3)+
 ende
"END;
 END timerHandler;
 
 
 PROCEDURE InstallWatchDog(VAR handle:WatchDogCarrier;proc:EventProc);
 
 BEGIN
"ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),D0
(MOVE.W  D0,-(A7)
(SWAP    D0              ; 'proc.event' -> D0
(CMP.W   #keyboard,D0    ; CASE proc.event OF
(BEQ     installKey
(CMP.W   #mouseButton,D0
(BEQ     installBut
(CMP.W   #firstRect,D0
(BEQ.W   installSt
(CMP.W   #secondRect,D0
(BEQ.W   installNd
(CMP.W   #message,D0
(BEQ.W   installMsg
(CMP.W   #timer,D0
(BEQ.W   installTime
(TST.W   (A7)+           ; an diesen Punkt kommt man theoretisch nie
(TST.L   (A7)+
(BRA.W   ende
(
 installKey                      ; install keyboard watch dog
(TST.L   keyboardList
(BNE     keyActive       ; jump if 'keyboardList#NIL' (already plugged)
(LEA     keyboardHandler,A0
(MOVE.L  A0,keyboardPlug ; plug into the 'GEMshare.keyboardPlug'
(MOVE.W  #TRUE,keyboardPlugActive
 keyActive
(MOVE.L  -(A3),A0        ; ADR(handle) -> A0
(MOVE.W  modLevel,carrier.level(A0)
(MOVE.L  (A7)+,carrier.proc(A0) ; init. carrier and make it first
(TST.W   (A7)+                  ; element of the keyboard carrier list
(MOVE.L  keyboardList,carrier.next(A0)
(MOVE.L  A0,keyboardList
(BRA.W   ende
(
 installBut                      ; install mouse button watch dog
(TST.L   buttonList
(BNE     butActive
(LEA     buttonHandler,A0
(MOVE.L  A0,buttonPlug
(MOVE.W  #TRUE,buttonPlugActive
 butActive
(MOVE.L  -(A3),A0
(MOVE.W  modLevel,carrier.level(A0)
(MOVE.L  (A7)+,carrier.proc(A0)
(TST.W   (A7)+
(MOVE.L  buttonList,carrier.next(A0)
(MOVE.L  A0,buttonList
(BRA.W   ende
(
 installSt
(TST.L   stRectList
(BNE     stActive
(LEA     stRectHandler,A0
(MOVE.L  A0,firstRectPlug
(MOVE.W  #TRUE,firstRectPlugActive
 stActive
(MOVE.L  -(A3),A0
(MOVE.W  modLevel,carrier.level(A0)
(MOVE.L  (A7)+,carrier.proc(A0)
(TST.W   (A7)+
(MOVE.L  stRectList,carrier.next(A0)
(MOVE.L  A0,stRectList
(BRA.W   ende
(
 installNd
(TST.L   ndRectList
(BNE     ndActive
(LEA     ndRectHandler,A0
(MOVE.L  A0,secondRectPlug
(MOVE.W  #TRUE,secondRectPlugActive
 ndActive
(MOVE.L  -(A3),A0
(MOVE.W  modLevel,carrier.level(A0)
(MOVE.L  (A7)+,carrier.proc(A0)
(TST.W   (A7)+
(MOVE.L  ndRectList,carrier.next(A0)
(MOVE.L  A0,ndRectList
(BRA     ende
(
 installMsg                      ; install message event watch dog
(TST.L   messageList
(BNE     msgActive       ; already plugged ?
(LEA     messageHandler,A0 ; if not plug in
(MOVE.L  A0,messagePlug
(MOVE.W  #TRUE,messagePlugActive
 msgActive
(MOVE.L  -(A3),A0        ; ADR(handle) -> A0
(MOVE.W  modLevel,carrier.level(A0)
(MOVE.W  (A7)+,carrier.msgType(A0) ; save type of message event -> handle
(MOVE.L  (A7)+,carrier.proc(A0)    ; procedure address -> handle
(MOVE.L  messageList,carrier.next(A0) ; insert into message list
(MOVE.L  A0,messageList
(BRA     ende
(
 installTime
(TST.L   timerList
(BNE     timeActive
(LEA     timerHandler,A0
(MOVE.L  A0,timerPlug
(MOVE.W  #TRUE,timerPlugActive
 timeActive
(MOVE.L  -(A3),A0
(MOVE.W  modLevel,carrier.level(A0)
(MOVE.L  (A7)+,carrier.proc(A0)
(TST.W   (A7)+
(MOVE.L  timerList,carrier.next(A0)
(MOVE.L  A0,timerList
(
 ende
"END;
 END InstallWatchDog;
 
 PROCEDURE SysInstallWatchDog(VAR handle:WatchDogCarrier;proc:EventProc);
 
 BEGIN
"ASSEMBLER
(MOVE.L  -12(A3),-(A7)
(JSR     InstallWatchDog
(MOVE.L  (A7)+,A0
(CLR     carrier.level(A0)
"END;
 END SysInstallWatchDog;
 
 PROCEDURE DeInstallWatchDog(VAR handle:WatchDogCarrier);
 
 BEGIN
"ASSEMBLER
(MOVE.L  -(A3),D1
(MOVEQ   #5,D0   ; There are 5+1 lists
(PEA     keyboardList
(PEA     buttonList
(PEA     ndRectList
(PEA     stRectList
(PEA     messageList
(PEA     timerList
 loop
(MOVE.L  (A7)+,A0
 loop2
(MOVE.L  (A0),A1
(CMPA.L  #NIL,A1
(BEQ     listEnd
(CMP.L   A1,D1
(BEQ     foundHandle
(LEA     carrier.next(A1),A0
(BRA     loop2
 listEnd
(DBF     D0,loop
(BRA     ende                    ; handle was not installed
 
 foundHandle
(LSL.W   #2,D0           ; pop remaining list pointer from the stack
(ADDA.W  D0,A7           ; A7:=A7+D0*4
(MOVE.L  carrier.next(A1),(A0)  ; delete 'handle' out of the list
(TST.L   timerList
(BNE     cont1
(CLR.W   timerPlugActive
 cont1
(TST.L   messageList
(BNE     cont2
(CLR.W   messagePlugActive
 cont2
(TST.L   ndRectList
(BNE     cont3
(CLR.W   secondRectPlugActive
 cont3
(TST.L   stRectList
(BNE     cont4
(CLR.W   firstRectPlugActive
 cont4
(TST.L   buttonList
(BNE     cont5
(CLR.W   buttonPlugActive
 cont5
(TST.L   keyboardList
(BNE     ende
(CLR.W   keyboardPlugActive
 ende
"END;
 END DeInstallWatchDog;
 
 PROCEDURE HandleEvents (    noClicks  : CARDINAL;
<butMask,
<butState  : MButtonSet;
<moveDirec1: RectEnterMode;
<rect1Size : Rectangle;
<moveDirec2: RectEnterMode;
<rect2Size : Rectangle;
<time      : LONGCARD;
8REF procs     : ARRAY OF EventProc;
<usedProcs : CARDINAL);
8
 CONST   procRecSize     = 8; (* Lnge des 'eventProc'-Typs *)
 
 VAR     msg             : MessageBuffer;
(mouseLoc        : Point;
(buttons         : MButtonSet;
(keyState        : SpecialKeySet;
(key             : GemChar;
(doneClicks, i   : CARDINAL;
(eventResult     : EventSet;
(handlerResult   : BOOLEAN;
(momEvent        : Event;
(
(msgAdd          : BOOLEAN;
(a7Store         : LONGCARD;
7
 (*$L+*)
 BEGIN
"ASSEMBLER
8; last used index of 'procs' -> 'usedProcs' and D0
(MOVE.W  usedProcs(A6),D0
(MOVE.W  procs+4(A6),D1
(TST.W   D0
(BEQ     takeHigh
(SUBQ.W  #1,D0
(CMP.W   D0,D1
(BCC     cont
 takeHigh
(MOVE.W  D1,D0
 cont
(MOVE.W  D0,usedProcs(A6)
8; Rufe MultiEvent auf, Ergebnis in 'eventResult'
(CLR.W   D1              ; registrierte events
(MOVE.L  procs(A6),A0
 loop1
(MOVE.W  EventProc.event(A0),D2
(BSET    D2,D1           ; registriere den gefundenen Event
(ADDQ.L  #procRecSize,A0 ; nchstes Arrayelement
(DBF     D0,loop1
<; Zustzlich message event falls ntig
(CLR.W   msgAdd(A6)
(BTST    #message,D1
(BNE     noMsgAdd        ; message event schon gesetzt => springe
(TST.L   messageList
(BEQ     noMsgAdd        ; message Liste leer => springe
(MOVE.W  #TRUE,msgAdd(A6); message add erforderlich
(BSET    #message,D1
 noMsgAdd
 
(MOVE.B  D1,(A3)+
(ADDQ.L  #1, A3          ; possible events auf den Stack
(LEA     noClicks(A6),A0
(MOVEQ   #12,D0          ; 'noClicks' bis 'rect2Size' auf den Stack
 loop2
(MOVE.W  (A0)+,(A3)+
(DBF     D0,loop2
(LEA     msg(A6),A0
(MOVE.L  A0,(A3)+
(MOVE.L  time(A6),(A3)+
(LEA     mouseLoc(A6),A0
(MOVE.L  A0,(A3)+
(LEA     buttons(A6),A0
(MOVE.L  A0,(A3)+
(LEA     keyState(A6),A0
(MOVE.L  A0,(A3)+
(LEA     key(A6),A0
(MOVE.L  A0,(A3)+
(LEA     doneClicks(A6),A0
(MOVE.L  A0,(A3)+
(LEA     eventResult(A6),A0
(MOVE.L  A0,(A3)+                ; 'eventResult' als VAR-Parameter
(JSR     MultiEvent
(MOVE.B  eventResult(A6),D0
(
8; beachte message add
(TST.W   msgAdd(A6)
(BEQ.W   noMsgAdd2
(BTST    #message,D0
(BEQ.W   noMsgAdd2
(BCLR    #message,eventResult(A6)
(MOVEQ   #0,D0
(MOVE.W  msg+4(A6),D0
(ADD.L   #16,D0          ; msg[2]+16 (Lnge der message) -> D0
(MOVE.L  A7,A0
(SUBA.L  D0,A0
(SUBA.W  #300,A0         ; 300 Byte Sicherheitszone fr Stack
(CMPA.L  A3,A0
(BCC     enoughStack
(LEA     a7Store(A6),A0
(MOVE.L  A0,(A3)+
(MOVE.L  D0,(A3)+
(JSR     ALLOCATE
(MOVE.L  a7Store(A6),A0  ; ADR(buffer) -> A0
(CLR.L   a7Store(A6)     ; Bedeutet: Bentigter Speicher nicht vom Stack
(CMPA.L  #NIL,A0
(BNE     allocOk
(TRAP    #noErrorTrap
(DC.W    OutOfMemory
(BRA.W   noMsgAdd2
 enoughStack
(MOVE.L  A7,a7Store(A6)
(SUBA.L  D0,A7
(MOVE.L  A7,A0           ; ADR(buffer) -> A0
 allocOk
(MOVE.L  msg(A6),(A0)
(MOVE.L  msg+4(A6),4(A0)
(MOVE.L  msg+8(A6),8(A0)
(MOVE.L  msg+12(A6),12(A0)
(
(MOVE.L  A0,-(A7)
(TST.W   msg+4(A6)
(BEQ     noReadFromAppl
(
(JSR     ApplicationID
(MOVE.L  (A7)+,A0
(MOVE.L  A0,D0
(ADD.L   #16,D0
(MOVE.L  D0,(A3)+
(MOVE.W  msg+4(A6),(A3)+
(SUBQ.W  #1,-2(A3)       ; HIGH-Value is "no. elem.s" - 1
(CLR.W   (A3)+
(MOVE.L  A0,-(A7)
(JSR     ReadFromAppl    ; ReadFromAppl(Appl...ID(),buffer[16..],0)
 
 noReadFromAppl
(JSR     ApplicationID
(MOVE.L  (A7)+,A0
(MOVE.L  A0,(A3)+
(MOVE.W  msg+4(A6),D0
(ADD.W   #16,D0
(MOVE.W  D0,(A3)+
(SUBQ.W  #1,-2(A3)       ; HIGH-Value is "no. elem.s" - 1
(CLR.W   (A3)+
(MOVE.L  A0,-(A7)
(JSR     WriteToAppl     ; WriteToAppl(ApplicationID(),buffer,0)
(MOVE.L  (A7)+,A0
(
(MOVE.L  a7Store(A6),D0
(BEQ     dealloc
(MOVE.L  D0,A7
(BRA     noMsgAdd2
 dealloc
(MOVE.L  A0,(A3)+
(CLR.L   (A3)+
(JSR     DEALLOCATE
 noMsgAdd2
@; call procs
(CLR.W   i(A6)
 loop3
(MOVE.W  i(A6),D0
(MOVE.W  usedProcs(A6),D1
(CMP.W   D0,D1
(BCS.W   ende
(MOVEQ   #0,D2
(MOVE.B  eventResult(A6),D2      ; eventResult -> D2
(BEQ.W   ende
(MOVE.W  D0,D1
(MULU    #procRecSize,D1
(MOVE.L  procs(A6),A0
(ADDA.W  D1,A0
(MOVE.W  EventProc.event(A0),D1  ; proc[i].event -> D1
(MOVE.W  D1,momEvent(A6)         ; momEvent:=proc[i].event
(BTST    D1,D2
(BEQ.W   noMatch
(MOVE.L  2(A0),A1   ; proc[i].proc -> A1 (proc[i].event#message)
(CMP.W   #keyboard,D1
(BEQ     keyCall
(CMP.W   #mouseButton,D1
(BEQ     butCall
(CMP.W   #firstRect,D1
(BEQ     stRCall
(CMP.W   #secondRect,D1
(BEQ     ndRCall
(CMP.W   #message,D1
(BEQ     msgCall
(CMP.W   #timer,D1
(BEQ.W   tmrCall
(BRA.W   noMatch
 keyCall
(LEA     key(A6),A0
(MOVE.L  A0,(A3)+
(LEA     keyState(A6),A0
(MOVE.L  A0,(A3)+
(JSR     (A1)
(BRA.W   caseEnd
 butCall
(MOVE.W  doneClicks(A6),(A3)+
(MOVE.L  mouseLoc(A6),(A3)+
(MOVE.B  buttons(A6),(A3)+
(ADDQ.L  #1, A3
(MOVE.B  keyState(A6),(A3)+
(ADDQ.L  #1, A3
(JSR     (A1)
(BRA.W   caseEnd
 stRCall
 ndRCall
(MOVE.L  mouseLoc(A6),(A3)+
(MOVE.B  buttons(A6),(A3)+
(ADDQ.L  #1, A3
(MOVE.B  keyState(A6),(A3)+
(ADDQ.L  #1, A3
(JSR     (A1)
(BRA.W   caseEnd
 
 msgCall                 ; in A0 ist noch ADR(proc[i])
(MOVE.W  EventProc.msgType(A0),D1
(
(; Ist die Proc. vom Typ 'uspecMessage', so bekommt sie den Msg.event
(; sowieso, egal von welchem Typ er ist.
(
(CMP.W   #unspecMessage,D1
(BEQ     copy8from0
(
(; Sonst, mu der Typ des Msg.events gleich dem Typ sein, fr den die
(; Proc. angemeldet ist.
(
(CMP.W   msg(A6),D1      ; Proc-Typ = Event-Typ ?
(BNE.W   noMatch         ; Nein! => Kein Aufruf der Proc.
(
(CMP.W   #menuSelected,D1
(BEQ     copy2
(CMP.W   #windRedraw,D1
(BEQ     copy5
(CMP.W   #windTopped,D1
(BEQ     copy1
(CMP.W   #windClosed,D1
(BEQ     copy1
(CMP.W   #windFulled,D1
(BEQ     copy1
(CMP.W   #windArrowed,D1
(BEQ     copy2
(CMP.W   #windHSlid,D1
(BEQ     copy2
(CMP.W   #windVSlid,D1
(BEQ     copy2
(CMP.W   #windSized,D1
(BEQ     copy5
(CMP.W   #windMoved,D1
(BEQ     copy5
(CMP.W   #windNewTop,D1
(BEQ     copy1
(CMP.W   #accOpen,D1
(BEQ     copy1from4
(CMP.W   #accClose,D1
(BEQ     copy1
(BRA.W   noMatch
'
 copy8from0
(LEA     msg(A6),A2
(MOVEQ   #7,D1
(BRA     doIt
(
 copy1
(LEA     msg+6(A6),A2    ; ab msg[3]
(MOVEQ   #0,D1           ; 1 Wort
(BRA     doIt
(
 copy1from4
(LEA     msg+8(A6),A2
(MOVEQ   #0,D1
(BRA     doIt
(
 copy2
(LEA     msg+6(A6),A2
(MOVEQ   #1,D1
(BRA     doIt
 
 copy5
(LEA     msg+6(A6),A2
(MOVEQ   #4,D1
 doIt
(MOVE.L  4(A0),A1        ; proc[i].proc -> A1
 copyLoop
(MOVE.W  (A2)+,(A3)+
(DBF     D1,copyLoop
(JSR     (A1)
(BRA.W   caseEnd
 tmrCall
(JSR     (A1)
 caseEnd
(TST.W   -(A3)
(BNE     noMatch
(MOVE.W  momEvent(A6),D0
(BCLR    D0,eventResult(A6)
 noMatch
(ADDQ.W  #1,i(A6)
(BRA.W   loop3
 ende
"END;
 END HandleEvents;
 (*$L=*)
 
 
 (*$L+*)
 
 (*$J-*)
 PROCEDURE dummy (): BOOLEAN;
 (*$J=*)
 
"BEGIN
$RETURN TRUE;
"END dummy;
 
 PROCEDURE ShareTime (time: LONGCARD);
"
"VAR     theProc: EventProc;
"
"BEGIN
$IF flushExecuted <= 2 THEN (* erlaubt 2 Rekursionslevel *)
&INC (flushExecuted);
&theProc.event := timer;
&theProc.timeHdler := dummy;
&HandleEvents(0, MButtonSet{}, MButtonSet{},
3lookForEntry, Rect(0,0,0,0), lookForEntry, Rect(0,0,0,0),
3time, theProc, 0);
&DEC (flushExecuted);
$END
"END ShareTime;
 
 PROCEDURE FlushEvents;
 
"BEGIN
&REPEAT
(watchDogExecuted := FALSE;
(ShareTime (0L);
&UNTIL NOT watchDogExecuted;
"END FlushEvents;
"
 
8(*  misc. managment  *)
8(*  ===============  *)
 
 PROCEDURE levelCounter(start,child:BOOLEAN; VAR id:INTEGER);
 
"PROCEDURE searchList(list:ptrCarrier);
"
$VAR  nlist: ptrCarrier;
"
$BEGIN
&WHILE list # NIL DO
(nlist:=list^.next;
(IF list^.level>=modLevel THEN
*ASSEMBLER
,MOVE.L  list(A6),(A3)+
,JSR     DeInstallWatchDog
*END
(END;
(list:= nlist
&END
$END searchList;
"
"BEGIN
$IF child THEN
&IF start THEN INC(modLevel)
&ELSE
(searchList(keyboardList);
(searchList(buttonList);
(searchList(stRectList);
(searchList(ndRectList);
(searchList(messageList);
(searchList(timerList);
(DEC(modLevel);
&END;
$END;
"END levelCounter;
 
 PROCEDURE termProc;
 
"BEGIN
$levelCounter(FALSE,TRUE, voidI);
"END termProc;
 
 PROCEDURE removalProc;
"
"BEGIN
$(*  Current 'modID = 0'. That means all init.s are released.
%*)
$levelCounter (FALSE, TRUE, voidI);
"END removalProc;
"
 VAR     envlpHdl        : EnvlpCarrier;
(termHdl         : TermCarrier;
(removalHdl      : RemovalCarrier;
(wsp             : MemArea;
 
 
 BEGIN
"keyboardList := NIL;
"buttonList := NIL;
"stRectList := NIL;
"ndRectList := NIL;
"messageList := NIL;
"timerList := NIL;
"
"modLevel := 1;
"CatchProcessTerm (termHdl, termProc, wsp);
"SetEnvelope (envlpHdl, levelCounter, wsp);
"CatchRemoval (removalHdl, removalProc, wsp);
 END EventHandler.
 
(* $FFF7C95C$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$000051E4$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$FFF8416E$0000516E........T.......T......TT.......T.......T.......T.......T.......T.......T.......$00000B9B$0000515E$00005170$0000519D$0000516E$0000519D$000051AF$00005198$FFEEDCC0$0000527D$00005268$00005195$00005170$000005FA$000000D8$FFEEDCC0*)
