 IMPLEMENTATION MODULE WindowLists;
 (*$Y+*)
 
 (*
 FROM Terminal IMPORT WriteString, WriteLn, Read;
 FROM StrConv IMPORT IntToStr, CardToStr;
!*)
 
 (*  --------------------------------------------------------------------------
!*  System-Version: MOS 1.1
!*  --------------------------------------------------------------------------
!*  Version       : 1.4 
!*  --------------------------------------------------------------------------
!*  Text-Version  : V#0246
!*  --------------------------------------------------------------------------
!*  Modul-Holder  : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Copyright July 1988 by Manuel Chakravarty
!*  Vertriebsrechte fr ATARI ST unter MEGAMAX Modula-2
!*                  liegen bei Application Systems Heidelberg
!*  --------------------------------------------------------------------------
!*  MCH : Manuel Chakravarty
!*  --------------------------------------------------------------------------
!*  Datum    Autor  Version  Bemerkung (Arbeitsbericht)
!*
!*  23.07.88 MCH    0.01     bernahme der Routine aus der MShell V1.1, sowie
!*                           die Mod.levelverwaltung aus 'WindowBase'
!*  24.07.88 MCH    0.01     Erste lauffhige Version
!*  25.07.88 MCH    0.02     Selektion mit Mauszeiger
!*  04.08.88 MCH    0.03     'SelectWListArea' Def. + Impl.
!*  29.08.88 MCH    0.04     'GetWListSize' Def. + Impl. + shrinking korrekt
!*  30.08.88 MCH    0.04     'modID' wird richtig in carrier bernommen
!*  20.11.88 MCH    0.05     Umstellung von 'TextWindows' auf 'WindowBase'
!*                           als grundlegendes Modul
!*  22.11.88 MCH    0.05     Anpassung auf 'WindowBase' V0.06 (Sliderberechnung)
!*  23.11.88 MCH    0.06     Modul baut eigene Listen auf
!*  24.11.88 MCH    0.07     Vereinheitlichte Namensgebung. Einfhrung der
!*                           Listenoperationen.
!*  28.11.88 MCH    0.07     Vervollstndigung der Impl. vom 24.11.
!*  01.12.88 MCH    0.07     'SysAlloc' und 'DEALLOCATE' werden jetzt mit
!*                           richtiger Speicherbereichslnge aufgerufen.
!*                           'CreateWL' kann 'CenterWindowWL' und 'MaxWindowWL'
!*                           als Spezialwert bergeben werden.
!*  05.12.88 MCH    0.08     Erweiterung der Parameter von 'DetectWindowWL'
!*                           um 'empty'.
!*                           Impl. von 'QueryListWL' + 'GetEntryBoxWL'.
!*                           Der 'box'-Parameter ist bei 'SelectEntryProcWL'
!*                           weggefallen und 'EntryToStr' ist keine Fkt. mehr.
!*  06.12.88 MCH    0.08     Bei allen eine Liste vernderten Routinen wird
!*                           diese Liste jetzt als VAR-Parm. bergeben.
!*  08.12.88 MCH    0.09     'charFrac' wird in 'scroll' jetzt richtig be-
!*                           rechnet.
!*                           'ShowListWL' liefert keinen 'success'-Parm.
!*                           sondern setzt den state richtig, genauso
!*                           'CreateWL'.
!*  06.02.89 MCH    0.09     In der 'scroll'-Prozedur wird 'charFrac' nun
!*                           frh genug berechnet.
!*  15.02.89 MCH    0.09     Maximalbreite der Fenster wird auf maximale
!*                           Entry-String-Lnge begrenzt.
!*  20.02.89 MCH    0.09     'killListWithAttrs' gibt jetzt auch die Listen-
!*                           Carrier frei.
!*  27.06.89 MCH    0.10     'ResCtrl' wird benutzt.
!*  02.08.89 MCH    0.11     'CreateWL' initializes 'wl^.state';
!*                           'SysCreateWL', 'PutWindowOnTopWL',
!*                           'SetWindowSizeWL' def. + impl.
!*  03.08.89 MCH    0.11     In 'CreateWL' wird 'wl^.height' init.
!*  05.08.89 MCH    0.11     Ghost-Entries raus
!*  11.08.89 MCH    0.12     'ViewLineWL' def. und impl.
!*  15.08.89 MCH    0.13     An 'WindowBase' V0.12 angepat
!*  16.08.89 MCH    0.13     Korrekturen in 'checkSpec', 'update';
!*                           def. + impl. fr Info-Zeile
!*  17.08.89 MCH    0.13     'WindowSizeWL' rundet geshickter; 'infoLine' wird
!*                           korrekt gesetzt
!*  15.02.90 MCH    1.1      Anpassung auf Compilerversion 4.0
!*  19.03.90 MCH    1.1      'modID' als INTEGER
!*  05.10.90 MCH    1.2      VAR-Parm. in QueryProc
!*  26.11.90 TT     1.3      careOfExitGem sorgt fr rechtzeitige Freigabe
!*                           des GEM, da sonst mit installiertem ModLoad die
!*                           MM2Shell beim Ende einen Fehler meldet (der Gem-
!*                           handle ist dann beim exitGem-Aufruf beim Removal
!*                           ungltig).
!*  10.12.90 MCH    1.4      'EnhancedOutputWL' von Dirk Steins bernommen
!*  17.12.90 TT              FastGEM0-Import erstmal entfernt, da immer noch
!*                           Fehler bei Bigscreen
!*  17.12.90 TT              lineToViewPos korrigiert: DEC statt INC, ELSE neu.
!*  23.05.93 TT              Add/Append/RemoveEntryWL funktionieren nun
!*                           ('height' (Elem-Anz) wurde nicht aktualisiert).
!*  24.05.93 TT              Font kann mit SetListWL gesetzt werden.
!*  14.01.94 TT              checkSpec korrigiert.
!*  --------------------------------------------------------------------------
!*  Modul-Beschreibung:
!*
!*  Dieses Modul stellt eine einfache Listenverwaltung dar. Alle Listen
!*  werden, allerdings ohne kontrollierendes Eingreifen des anwendenden
!*  Moduls, in Textfenstern dargestellt. Anwendung z.B. Directory-Fenster.
!*
!*  --------------------------------------------------------------------------
!*)
 
 (*  =========== ZU TUN: ==============
!*
!*  -- Was passiert, wenn auf ein offenes Fenster ein 'GetListWL' gemacht
!*     wird und dann ein redraw eintrifft, bevor ein 'SetListWL' durchge-
!*     fhrt wurde. Evtl. Laufzeitfehler auslsen.
!*
!*  -- 'WLTest' so erweitern, da es wirklich alle Funktionen austestet.
!*
!*  -- Wird in 'queryServer' bei einem Element die Attr.s gendert, so wird
!*     es sofort neugezeichnet. Besser wre es abzuwarten, ob nicht das 
!*     nchste Element auch neugezeichnet werden mu und dann beide zusammen
!*     zu zeichnen.
!*
!*  =========== DOCU: ================
!*
!*  -- Listen drfen zwischen 'SetWindowList' und 'GetWindowList' vom Clienten
!*     nicht mehr verndert werden. Dasselbe gilt fr die Listenelemente.
!*
!*  -- Vom User bergebene entries drfen in einer Liste nie doppelt vorkommen
!*     und nicht NIL sein. Sollten also immer echte Zeiger auf verschiedene
!*     Speicherbereiche sein.
!*
!*  -- Fehler die mit 'StateWL' abgefragt werden knnen, fhren erst einen
!*     Befehl zu spt zu einem Laufzeitfehler.
!*
!*  -- In Query, Selektionsprozedur u.. drfen nur die Liste nicht verndernde
!*     Listenoperationen benutzt werden.
!*)
 
 
 FROM SYSTEM             IMPORT ASSEMBLER, ADDRESS,
?ADR;
 
 (*  MOS  *)
 
 FROM Storage            IMPORT SysAlloc, DEALLOCATE;
 
 FROM MOSGlobals         IMPORT IllegalPointer, OutOfMemory, GeneralErr, MemArea;
 
 FROM PrgCtrl            IMPORT EnvlpCarrier, TermCarrier,
?SetEnvelope, CatchProcessTerm;
 
 FROM ResCtrl            IMPORT RemovalCarrier,
?CatchRemoval;
 
 FROM Strings            IMPORT String,
?Assign;
 
 FROM Lists              IMPORT List, LDir, LCarrier,
?ResetList, CreateList, DeleteList, NoOfEntries,
?NextEntry, FirstEntry, FindEntry, InsertEntry,
?RemoveEntry, CurrentEntry, PrevEntry,
?AppendEntry, ScanEntries;
 
 
 (*  Graphic & GEM  *)
 
 FROM GrafBase           IMPORT WritingMode, Point, Rectangle, black, white,
?MemFormDef, BitOperation, LongPnt, LongRect,
?Rect, Pnt, MinPoint, MaxPoint, TransRect,
?ClipRect, LPnt, LRect;
5
 FROM GEMGlobals         IMPORT THorJust, TVertJust,
?FillType, TEffectSet, TextEffect, MaxStr;
 
 FROM GEMEnv             IMPORT DeviceHandle, GemHandle, RC, GDOSAvailable,
?SysInitGem, ExitGem, CurrGemHandle,
?PtrDevParm, DeviceParameter, SetCurrGemHandle;
 
 FROM VDIAttributes      IMPORT SetTextColor, SetFillColor, SetFillType,
?SetPtsTHeight, SetAbsTHeight, SetTextFace,
?SetFillPerimeter, SetWritingMode,
?SetTextEffects;
 
 FROM VDIControls        IMPORT LoadFonts, SetClipping, DisableClipping;
 
 FROM VDIOutputs         IMPORT GrafText, FillRectangle;
 
 FROM VDIInquires        IMPORT GetTextStyle, GetFaceName, GetFaceInfo;
 
 (*  beyond GEM  *)
 
 FROM EasyGEM0           IMPORT DeskSize, CharSize;
 
 FROM WindowBase         IMPORT Window, WdwElement, WdwElemSet, WindowScrollMode,
?WdwFlag, WdwFlagSet, NoWindow, WindowSpec,
?WindowCopyMode, MaxWdw, CenterWdw, SetWdwStrMode,
?DetectWdwResult, WdwState, OldWindowSlider,
?SysCreateWindow, OpenWindow, CloseWindow,
?DeleteWindow, SetWindowSpec, WindowWorkArea,
?GetWindowSpec, SetWindowString, WindowFlags,
?RedrawWindow, DetectWindow, WindowState,
?ResetWindowState, PutWindowOnTop, UpdateWindow,
?SetWindowSliderPos, CalcScreenCoor,
?CalcWindowCoor, SetWindowWorkArea;
 
 FROM VDIRasters  IMPORT CopyOpaque;
 
 FROM Strings IMPORT StrEqual;
 
 IMPORT AESWindows, GEMBase;
 
 CONST   TestVersion     = FALSE; (*  Debugging?  *)
 
 (*$?  NOT TestVersion:  (*$R- *)
!*)
 
 
 CONST   wlMagic         = 1097755233L;          (*  What's that?  *)
 
(noErrorTrap     = 6;
(
(noGem           = GemHandle (NIL);
 
 
 TYPE    ptrMaxString    = POINTER TO ARRAY[0..MaxCard] OF CHAR;
 
(WindowList      = POINTER TO windowList;
(windowList      = RECORD
<clientList,                 (*  list from client  *)
<list        : List;         (*  list with attr.s  *)
<set         : BOOLEAN;
<wdw         : Window;
<entryToStr  : EntryToStrProcWL;
<closeWList  : CloseProcWL;
<selectEntry : SelectEntryProcWL;
<environment : ADDRESS;
<enhanced    : BOOLEAN;
<
<(* Font infos *)
<fontHdl      : CARDINAL;
<fontSize     : CARDINAL;  (* Gre in Pts *)
<charW, charH, baseLine: INTEGER;
 
<
<(*  Window contains a info line?
=*)
<infoLine    : BOOLEAN;
<
<(*  If # 0, then the next 'SetListWL' trys to
=*  center the window to this line number.
=*)
<viewLine    : CARDINAL;
<
<(*  width of an entry is spec. by the caller.
=*  height of the list is the number of elem.s.
=*)
<width,
<height      : CARDINAL;
<
<state       : ErrorStateWL;
<modID       : INTEGER;  (*  0 = SysCreate  *)
<magic       : LONGCARD;
<next        : WindowList;
:END;
"
((*  An element of the list created by 'WindowLists'.
)*)
(element         = RECORD
<entry: ADDRESS;
<attrs: AttributesWL;
:END;
(ptrElement      = POINTER TO element;
 
 
 VAR     windowListRoot  : WindowList;   (*  root of list of 'WindowList's  *)
(
(gemHdl          : GemHandle;
(dev             : DeviceHandle;
(stdMFDB         : MemFormDef;
(Fonts           : CARDINAL;
(StdFontHdl      : CARDINAL;
(StdFontHeight   : CARDINAL;
(stdCharW, stdCharH: CARDINAL;
(
(modID, initID   : INTEGER;      (*  0 = SysLevel  *)
(
((*  global dummy var.s  *)
(
(voidADR : ADDRESS;
(voidO   : BOOLEAN;
(voidC   : CARDINAL;
(voidI   : INTEGER;
(voidList: List;
(
 (*$? TestVersion: voidCH: CHAR;  *)
 
 
0(*  Misc. Proc.s  *)
0(*  ============  *)
 
 (*  raiseError -- Reports a runtime error.
!*)
 
 PROCEDURE raiseError (state: ErrorStateWL);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D0
(CMP.W   #listNotSetWL,D0
(BEQ     listNotSet
(CMP.W   #wdwNotOpenWL,D0
(BEQ     wdwNotOpen
(CMP.W   #unkownEntryWL,D0
(BEQ     unkownEntry
(CMP.W   #listFaultWL,D0
(BEQ     listFault
(CMP.W   #outOfMemoryWL,D0
(BEQ.W   outOfMemory
(BRA.W   ende
 
 listNotSet
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     'WindowLists: WList not set!'
(SYNC
(BRA     ende
 
 wdwNotOpen
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     'WindowLists: WList not open!'
(SYNC
(BRA     ende
 
 unkownEntry
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     'WindowLists: Unkown entry!'
(SYNC
(BRA     ende
 
 listFault
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $C000
(ACZ     'WindowLists: List fault!'
(SYNC
(BRA     ende
 
 outOfMemory
(TRAP    #noErrorTrap
(DC.W    OutOfMemory - $4000
(BRA.W   ende
(
 ende
$END;
"END raiseError;
"(*$L=*)
"
 (*  notValid -- Test if 'wl' is a valid window list handle. If it is neither
!*              NIL nor valid let a runtime error (Illegal Pointer) occure.
!*              If the handle is valid, then reset the 'wdw.state'.
!*)
 
 PROCEDURE notValid (wl: WindowList): BOOLEAN;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.W  #TRUE,(A3)+
(MOVE.L  A0,D1
(BEQ     ende                    ; 'wl = NIL'
(
(AND.L   #1,D1
(BNE     illegal                 ; odd addr.
(
(MOVE.L  #wlMagic,D1
(CMP.L   WindowList.magic(A0),D1
(BNE     illegal
(
(CLR.W   -2(A3)
(MOVEQ   #okWL,D1
(CMP.W   WindowList.state(A0),D1
(BEQ     ende                    ; end, if error state is cleared
(
(MOVE.W  WindowList.state(A0),(A3)+
(MOVE.W  D1,WindowList.state(A0)
(JSR     raiseError
(BRA     ende
(
 illegal
(TRAP    #noErrorTrap
(DC.W    IllegalPointer-$4000
 
 ende
$END;
"END notValid;
"(*$L=*)
 
 
 (*  reportOutOfMem -- Raises a 'Out of memory' runtime error.
!*                    It is possible to continue from the error.
!*)
!
 PROCEDURE reportOutOfMem;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TRAP    #noErrorTrap
(DC.W    OutOfMemory - $4000
$END;
"END reportOutOfMem;
"(*$L=*)
"
 (*  notSet -- Tests if the 'WindowList' set flag is set, if not an error
!*            is flagged in the window state.
!*)
 
 PROCEDURE notSet (wl: WindowList): BOOLEAN;
 
"BEGIN
$IF ~ wl^.set THEN wl^.state := listNotSetWL END;
$RETURN ~ wl^.set
"END notSet;
 
 PROCEDURE notValidOrSet (wl: WindowList): BOOLEAN;
 
"BEGIN
$RETURN notValid (wl) OR notSet (wl)
"END notValidOrSet;
"
 (*  isOpen -- Tests if the 'WindowList' window is open.
!*)
 
 PROCEDURE isOpen (wl: WindowList): BOOLEAN;
"
"VAR   flags: WdwFlagSet;
"
"BEGIN
$flags := WindowFlags (wl^.wdw);
$RETURN NOT (hiddenWdw IN flags)
"END isOpen;
"
"
 (*  notOpen -- Tests if the 'WindowList' window is open, if not an error
!*             is flagged in the window state.
!*)
 
 PROCEDURE notOpen (wl: WindowList): BOOLEAN;
 
"VAR   notOpen: BOOLEAN;
 
"BEGIN
$notOpen := ~ isOpen (wl);
$IF notOpen THEN wl^.state := wdwNotOpenWL END;
$RETURN notOpen
"END notOpen;
 
 
0(*  GEM operations  *)
0(*  ==============  *)
 
 PROCEDURE cantInitGem;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "Can't init. GEM (WindowLists)!"
(SYNC
$END;
"END cantInitGem;
"(*$L=*)
"
 PROCEDURE careOfInitGem;
 
"VAR   success: BOOLEAN;
(width  : INTEGER;
(w, h, c : CARDINAL;
(devpar  : PtrDevParm;
(mode    : WritingMode;
(hor     : THorJust;
(vert    : TVertJust;
(
"BEGIN
$IF gemHdl = noGem THEN
$
 (*$? TestVersion:
"WriteString ("'WindowLists': Connecting to GEM...");
!*)
&SysInitGem (RC, dev, success);
&IF ~ success THEN cantInitGem END;
 (*$? TestVersion:
"WriteString ("...connected.");
!*)
&gemHdl := CurrGemHandle ();
&initID:= modID; (* merken, wann initGem gemacht wurde *)
&
&AESWindows.UpdateWindow (TRUE);
&
&IF GDOSAvailable () THEN
(LoadFonts (dev, 0, Fonts)
&ELSE
(Fonts:= 0;
&END;
&devpar:= DeviceParameter (dev);
&INC (Fonts, devpar^.fonts); (* Anzahl der Fonts: Systemfonts mitzhlen *)
&
&IF StdFontHeight = 0 THEN
((* Systemfont ermitteln *)
(GetTextStyle (dev, StdFontHdl, w, w, hor, vert, mode,
6stdCharW, stdCharH, w, w);
(GetFaceInfo (dev, voidC,voidC,voidC,voidC,voidC,voidC, StdFontHeight,
5voidI,voidI,voidI,voidI);
&END;
&
&SetFillPerimeter (dev, FALSE);
&
&AESWindows.UpdateWindow (FALSE);
&
$END;
"END careOfInitGem;
 
 PROCEDURE exitGem;
 
"BEGIN
$IF gemHdl # noGem THEN
&ExitGem (gemHdl)
$END;
"END exitGem;
 
 PROCEDURE careOfExitGem;
 
"BEGIN
$IF (initID = modID) & (windowListRoot = NIL) THEN
&exitGem;
$END;
"END careOfExitGem;
 
"
 (*  saveCurrHdl -- Rettet das aktuelle GEM-Hdl. in 'saveArea' und setzt
!*                 stattdessen das handle von 'WindowLists' ein. Tritt
!*                 beim Setzen ein Fehler auf, so wird ein Laufzeitfehler
!*                 ausgelt.
!*)
 
 PROCEDURE saveCurrHdl (VAR saveArea : GemHandle);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     CurrGemHandle
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
(
(MOVE.L  gemHdl,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetCurrGemHandle
(TST.W   (A7)+
(BNE     ende
(
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "Can't set own GEM-Hdl:WindowLists"
(SYNC
(
 ende
$END;
"END saveCurrHdl;
"(*$L=*)
 
 (*  restoreCurrHdl -- Setzt 'saveArea' als GEM-Hdl. ein. Falls dabei ein
!*                    Fehlere auftritt, wird ein Laufzeitfehler ausgelt.
!*)
(
 PROCEDURE restoreCurrHdl (saveArea : GemHandle);
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST.L   -4(A3)
(BEQ     ende            ; jump, if 'saveArea = noGem'
(
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetCurrGemHandle
(TST.W   (A7)+
(BNE     ende
(
(TRAP    #noErrorTrap
(DC.W    GeneralErr - $E000
(ACZ     "Can't set GEM-Hdl (WindowLists)!"
(SYNC
(
 ende
$END;
"END restoreCurrHdl;
"(*$L=*)
 
 
0(*  graphic routines  *)
0(*  ================  *)
 
 PROCEDURE textWithAttributesWL (    loc  : Point;
Dattrs: AttributesWL;
Dwidth: CARDINAL;
@REF str  : ARRAY OF CHAR);
 
"VAR   effects: TEffectSet;
(frame  : Rectangle;
 
"BEGIN
$effects := TEffectSet {};
$IF disabledWL IN attrs THEN INCL (effects, lightText) END;
$IF markedWL IN attrs THEN INCL (effects, thickText) END;
$SetTextEffects (dev, effects);
$IF selectedWL IN attrs THEN SetWritingMode (dev, reverseWrt) END;
$GrafText (dev, loc, str);
$IF selectedWL IN attrs THEN SetWritingMode (dev, replaceWrt) END;
"END textWithAttributesWL;
"
 
0(*  primitive list operations  *)
0(*  =========================  *)
 
 (*  findListEntryNo -- Finds the list entry number 'no'. The found
!*                     entry is thereafter the current entry.
!*                     If there is no such entry ('no' to high')
!*                     then is root the current entry.
!*)
!
 PROCEDURE findListEntryNo (VAR wl: WindowList; no: CARDINAL);
 
((*  BEMERKUNG: Nummerierung beginnt bei 1  *)
 
"BEGIN
$WITH wl^
$DO
&ResetList (list);
&IF no > height THEN RETURN
&ELSE
(WHILE no # 0 DO DEC (no); voidADR := NextEntry (list) END;
&END;
$END;
"END findListEntryNo;
 
 (*  listEntryPos -- returns the position (number) of 'entry'.
!*                  0 ~ illegal 'entry'
!*                  1 ~ first list 'entry', etc.
!*)
 
 PROCEDURE listEntryPos (VAR wl: WindowList; entry: ADDRESS): CARDINAL;
 
"VAR   res : CARDINAL;
(elem: ptrElement;
 
"BEGIN
$WITH wl^ DO
&res := 0;
&ResetList (list);
&REPEAT
(elem := NextEntry (list);
(INC (res);
&UNTIL (elem = NIL) OR (elem^.entry = entry);
&IF elem = NIL THEN res := 0 END;
$END;
$RETURN res
"END listEntryPos;
 
 (*  killListWithAttrs -- Frees a list, that has 'ptrElement' as entries.
!*)
 
 PROCEDURE killListWithAttrs (VAR list: List);
 
"VAR   elem: ptrElement;
 
"BEGIN
$ResetList (list);
$elem := PrevEntry (list);
$WHILE elem # NIL DO
&RemoveEntry (list, voidO);
&DEALLOCATE (elem, SIZE (elem^));
&elem := CurrentEntry (list);
$END;
$DeleteList (list, voidO);
"END killListWithAttrs;
"
 (*  createListWithAttrs -- Gets a normal list and creates a copy of the list,
!*                         but with 'ptrElement' as entries.
!*)
 
 PROCEDURE createListWithAttrs (VAR list      : List;
?VAR clientList: List;
?VAR success   : BOOLEAN);
 
"VAR   entry: ADDRESS;
(elem : ptrElement;
 
"BEGIN
$CreateList (list, success); success := ~ success;
$IF ~ success THEN RETURN END;
$
$ResetList (clientList);
$LOOP
&(*  next entry, if one left.
'*)
&entry := NextEntry (clientList);
&IF entry = NIL THEN EXIT END;
&
&(*  create and insert new elem.
'*)
&SysAlloc (elem, SIZE (elem^)); success := (elem # NIL);
&IF success THEN
(AppendEntry (list, elem, success); success := ~ success;
&END;
&IF ~ success THEN
(killListWithAttrs (list);
(RETURN
&END;
&elem^.entry := entry; elem^.attrs := AttributesWL{};
$END;
"END createListWithAttrs;
 
 PROCEDURE isEntryInElement (entry, info: ADDRESS): BOOLEAN;
 
"VAR   elem: ptrElement;
 
"BEGIN
$elem := ptrElement (entry);
$RETURN info = elem^.entry
"END isEntryInElement;
"
 PROCEDURE findEntryInListWithAttrs (VAR l      : List;
Hentry  : ADDRESS;
DVAR success: BOOLEAN);
 
"BEGIN
$ResetList (l);
$ScanEntries (l, forward, isEntryInElement, entry, success);
"END findEntryInListWithAttrs;
"
"
((*  primitive window operations  *)
((*  ===========================  *)
 
 (*  detect -- Tests, if at the pixel position 'loc' is the window list window
!*            'target'. If it is, then 'match = TRUE'.
!*            If 'loc' is not only in 'target', but within the work area of
!*            'target' pointing at an list entry, then this list entry is
!*            returned in 'entry' and the bounding box of its first char.
!*            is returned in 'matchBox'.
!*)
!
 PROCEDURE detect (    target  : WindowList;
6loc     : Point;
2VAR match   : BOOLEAN;
2VAR elem    : ptrElement;
2VAR empty   : BOOLEAN);
"
"VAR   wdw     : Window;
(result  : DetectWdwResult;
(wdwLoc  : LongPnt;
(matchRow: CARDINAL;
(legal   : BOOLEAN;
"
"BEGIN
$IF notValid (target) THEN RETURN END;
$
$DetectWindow (target^.wdw, 0, loc, wdw, result);
$match := (result = foundWdwDWR);
$empty := (result = noWdwDWR);
$
$IF match THEN
$
&(*  Calc. wdw. coor. of 'loc' and use them to calc. the matched row.
'*)
&CalcWindowCoor (wdw, loc, wdwLoc, legal);
&IF NOT legal THEN elem := NIL;
&ELSE
&
(matchRow := SHORT (wdwLoc.y DIV LONG (target^.charH));
(
((*  find entry
)*)
(findListEntryNo (target, matchRow + 1);
(elem := CurrentEntry (target^.list);
'
&END;
$END;
"END detect;
 
 (*  redrawEntries -- Forces the redraw of a part of a 'WindowList'.
!*                   Validity of 'start' and 'end' is not tested.
!*                   'start' and 'end' are user entries not elements.
!*                   If 'end = NIL', then the redraw beginns at 'start'
!*                   and ends at the bottom border of the window.
!*                   If the enhanced mode is on, all redraw requests are
!*                   supressed.
!*)
 
 FORWARD update (wdw: Window; env: ADDRESS; source, dest, new: Rectangle);
 
 PROCEDURE redrawEntries (wl: WindowList; start, end: ADDRESS);
 
"VAR   startPos,
(endPos  : CARDINAL;
(frame   : LongRect;
(spec    : WindowSpec;
(bottom  : Point;
 
"BEGIN
$WITH wl^ DO
&IF NOT wl^.enhanced THEN
&
(startPos := listEntryPos (wl, start);
(frame.x := 0L;
(frame.y := LONG (INTEGER (startPos - 1)) * LONG (charH);
(frame.w := LONG (INTEGER (width)) * LONG (charW);
(IF end = NIL THEN
*
*(*  Calc. the end of the window (in window coor.).
+*)
*GetWindowSpec (wdw, spec);
*frame.h := spec.visible.y + spec.visible.h - frame.y;
*IF frame.h <= 0L THEN frame.h := 1L END;
*
(ELSE
(
*(*  Calc. position of 'end'.
+*)
*endPos := listEntryPos (wl, end);
*frame.h := LONG (INTEGER (endPos - startPos + 1)) * LONG (charH);
*
(END;
(UpdateWindow (wdw, update, wl, frame, noCopyWdw, 0L);
(
&END;(*IF*)
$END;(*WITH*)
"END redrawEntries;
"
 PROCEDURE setWindowSize (wl: WindowList; size: Rectangle);
 
"BEGIN
$WITH size DO
&IF x # CenterWindowWL THEN x := x * INT(stdCharW) ELSE x := CenterWdw END;
&IF y # CenterWindowWL THEN y := y * INT(stdCharH) ELSE y := CenterWdw END;
&IF w # MaxWindowWL THEN w := w * wl^.charW ELSE w := MaxWdw END;
&IF h # MaxWindowWL THEN h := h * wl^.charH ELSE h := MaxWdw END;
$END;
$SetWindowWorkArea (wl^.wdw, size);
"END setWindowSize;
 
 (*  lineToViewPos -- From a given window line the vertical "slider" position
!*                   is calculated, that places the line as near in the
!*                   middle of the window as possible.
!*
!*                   'line' must not be 0.
!*)
!
 PROCEDURE lineToViewPos (wl: WindowList; line: CARDINAL): LONGINT;
 
"VAR   frame   : Rectangle;
(m       : CARDINAL;
(
"BEGIN
$frame := WindowWorkArea (wl^.wdw);
$m := CARDINAL (frame.h) DIV CARDINAL (wl^.charH * 2);
$IF line <= m THEN
&line := 1
$ELSIF line < wl^.height - m THEN
&DEC (line, m) 
$ELSE
&line := wl^.height - m
$END;
$RETURN (line - 1) * CARDINAL (wl^.charH)
"END lineToViewPos;
 
 PROCEDURE setFont (hdl, size: INTEGER);
"VAR c: CARDINAL;
"BEGIN
$SetTextFace (dev, hdl);
$SetAbsTHeight (dev, size, c, c, c, c); (* Gre setzen *)
"END setFont;
 
0(*  the window server  *)
0(*  =================  *)
 
 PROCEDURE update (wdw: Window; env: ADDRESS; source, dest, new: Rectangle);
 
"VAR   wdwLoc     : LongPnt;
(loc        : Point;
(row        : CARDINAL;
((*$Reg*) i : CARDINAL;
(wl         : WindowList;
(elem       : ptrElement;
(str        : MaxStr;
(listCurrent: LCarrier;
"
(oldHdl     : GemHandle;
 
"BEGIN
 (*$? TestVersion:
"WriteLn;
"WriteString ("'WindowLists': 'update' called...");
!*)
$wl := WindowList (env);
$saveCurrHdl (oldHdl);
$
$IF source.w # 0 THEN
 (*$? TestVersion:
"WriteString ("with copy task");
"WriteLn;
!*)
&DisableClipping (dev);
&CopyOpaque (dev, ADR (stdMFDB), ADR (stdMFDB), source, dest, onlyS);
 (*$? TestVersion:
$ELSE
"WriteString ("no copy neccessary");
"WriteLn;
!*)
$END;
$
$SetWritingMode (dev, replaceWrt);
$SetFillColor (dev, white);
$SetFillType (dev, solidFill);
$FillRectangle (dev, new);
$
 (*$? TestVersion:
"WriteString ("coor. transformation starting...");
!*)
$WITH wl^ DO
$
&setFont (fontHdl, baseLine);
&SetClipping (dev, new);
&SetTextColor (dev, black);
&CalcWindowCoor (wdw, MinPoint (new), wdwLoc, voidO);
&row := SHORT (wdwLoc.y DIV LONG (charH));
&loc := MaxPoint (new);
&CalcWindowCoor (wdw, loc, wdwLoc, voidO);
&i := CARDINAL (SHORT (wdwLoc.y DIV LONG (charH))) - row + 1;
&findListEntryNo (wl, row + 1);
&CalcScreenCoor (wdw, LPnt (0L, LONG (INTEGER (row))
E* LONG (charH) + LONG (baseLine)),
Aloc, voidO);
$
 (*$? TestVersion:
"WriteString ("writing entries...");
!*)
$
&elem := CurrentEntry (list);
&WHILE (i # 0) AND (elem # NIL) DO
&
(listCurrent := list.current;
(wl^.entryToStr (elem^.entry, environment, str);
(list.current := listCurrent;
(
(textWithAttributesWL (loc, elem^.attrs, width, str);
(elem := NextEntry (list);
(DEC (i); loc.y := loc.y + charH;
(
&END;
&
$END;(*WITH*)
$DisableClipping (dev);
 (*$? TestVersion:
"WriteString ("done");
"WriteLn;
!*)
$
$restoreCurrHdl (oldHdl);
 (*$? TestVersion:
"WriteString ("normal termination of 'update'.");
"WriteLn;
!*)
"END update;
 
 PROCEDURE activated (wdw: Window; env: ADDRESS);
 
"END activated;
 
 PROCEDURE close (wdw: Window; env: ADDRESS);
 
"VAR   wl  : WindowList;
 
"BEGIN
$wl := WindowList (env);
$wl^.closeWList (wl, wl^.environment);
"END close;
 
 PROCEDURE checkSpec (    wdw   : Window;
9env   : ADDRESS;
5VAR spec  : WindowSpec;
9border: LongRect  );
"
"CONST charAlign       = 8L;   (*  byte aligning  *)
"
"VAR   wl: WindowList;
(amt: LONGINT;
"
"BEGIN
$wl := WindowList (env);
$WITH spec DO
$
&IF visible.w > LONG (INTEGER (wl^.width)) * LONG (wl^.charW)
&THEN visible.w := LONG (INTEGER (wl^.width)) * LONG (wl^.charW) END;
$
&(*  Umrechnen in Weltkoor.
'*)
&INC (virtual.x, visible.x);
&INC (virtual.y, visible.y);
&
&border.w := border.x + border.w - 1L;
&border.h := border.y + border.h - 1L;
&IF virtual.x < border.x THEN virtual.x := border.x END;
&IF virtual.y < border.y THEN virtual.y := border.y END;
&IF virtual.x > border.w THEN virtual.x := border.w END;
&IF virtual.y > border.h THEN virtual.y := border.h END;
&(* 'visible' erst nach _korrigiertem_ 'virtual' bestimmen: 14.01.94 TT *)
&visible.w := virtual.x + visible.w - 1L;
&visible.h := virtual.y + visible.h - 1L;
&IF visible.w < border.x THEN visible.w := border.x END;
&IF visible.h < border.y THEN visible.h := border.y END;
&IF visible.w > border.w THEN visible.w := border.w END;
&IF visible.h > border.h THEN visible.h := border.h END;
&visible.w := visible.w - virtual.x + 1L;
&visible.h := visible.h - virtual.y + 1L;
&
&INC (virtual.x, charAlign - 1L); DEC (virtual.x, virtual.x MOD charAlign);
&
&DEC (virtual.x, visible.x);
&DEC (virtual.y, visible.y);
&
&amt := visible.x MOD LONG (wl^.charW);
&INC (virtual.x, amt); DEC (visible.x, amt);
&amt := visible.y MOD LONG (wl^.charH);
&INC (virtual.y, amt); DEC (visible.y, amt);
&
&DEC (visible.w, visible.w MOD LONG (wl^.charW));
&DEC (visible.h, visible.h MOD LONG (wl^.charH));
&
$END;
"END checkSpec;
 
 PROCEDURE scrollAmt (wdw    : Window;
5env    : ADDRESS;
5toDo   : WindowScrollMode): LONGINT;
"
"VAR   spec: WindowSpec;
(wl: WindowList;
(
"BEGIN
$wl := WindowList (env);
$GetWindowSpec (wdw, spec);
$CASE toDo OF
&pageLeftWdw,
&pageRightWdw  : RETURN spec.visible.w|
&pageUpWdw,
&pageDownWdw   : RETURN spec.visible.h|
&columnLeftWdw,
&columnRightWdw: RETURN LONG (wl^.charW)|
&rowUpWdw,
&rowDownWdw    : RETURN LONG (wl^.charH)|
$END;
"END scrollAmt;
 
 
0(*  the exported procedures  *)
0(*  =======================  *)
(
((*  management  *)
 
 PROCEDURE CreateWL (VAR wl      : WindowList;
8infoLin0: BOOLEAN;
8size    : Rectangle);
 
"VAR   success: BOOLEAN;
(elems  : WdwElemSet;
(width0: INTEGER;
(top, bottom : CARDINAL;
(
"BEGIN
$careOfInitGem;
$
$SysAlloc (wl, SIZE (wl^));          (*  Alloc.  *)
$IF wl = NoWindowList THEN RETURN END;
$
$WITH wl^ DO                          (*  Init.  *)
&infoLine := infoLin0;
&set := FALSE;
&state := okWL;
&
&AESWindows.UpdateWindow (TRUE);
&setFont (StdFontHdl, StdFontHeight);
&fontHdl:= StdFontHdl;
&fontSize:= 0;
&GetFaceInfo (dev, voidC,voidC, bottom,voidC,voidC,voidC, top,
3width0, voidI,voidI,voidI);
&AESWindows.UpdateWindow (FALSE);
&charW := width0;
&charH := INTEGER (top) + INTEGER (bottom) + 1;
&baseLine := INTEGER (top);
&
&elems := WdwElemSet {closeElem, titleElem, scrollElem, moveElem,
;sizeElem};
&IF infoLine THEN INCL (elems, infoElem) END;
&SysCreateWindow (wdw, elems,
7update, checkSpec, scrollAmt, activated, close, wl);
&IF WindowState (wdw) # okWdw THEN DISPOSE (wl); RETURN END;
&
&width := MaxCard DIV (8 * CARDINAL (charW));
&height := MaxCard DIV (8 * CARDINAL (charH));
&setWindowSize (wl, size);
&
&enhanced:= FALSE;
&viewLine := 0;
 
&magic := wlMagic;
&next := windowListRoot;
&windowListRoot := wl;
$END;
$wl^.modID := modID;
"END CreateWL;
 
 PROCEDURE SysCreateWL (VAR wl      : WindowList;
;infoLine: BOOLEAN;
;size    : Rectangle);
 
"BEGIN
$CreateWL (wl, infoLine, size);
$IF wl # NoWindowList THEN wl^.modID := 0 END;
"END SysCreateWL;
"
 PROCEDURE SetListWL (    wl            : WindowList;
9l             : List;
9newEntryToStr : EntryToStrProcWL;
9newCloseWList : CloseProcWL;
9newSelectEntry: SelectEntryProcWL;
9newEnvironment: ADDRESS;
9newWidth      : CARDINAL;
5REF title         : ARRAY OF CHAR);
 
"VAR   success: BOOLEAN;
(spec   : WindowSpec;
(fontname: ARRAY [0..64] OF CHAR;
(fontnr  : CARDINAL;
(w, h, c : CARDINAL;
(top, bottom: CARDINAL;
(width0  : INTEGER;
(ch      : CHAR;
(aespb   : GEMBase.AESPB;
(vdipb   : GEMBase.VDIPB;
((* size: Rectangle; *)
 
"BEGIN
$IF notValid (wl) & ((ADDRESS(newEntryToStr)#NIL) OR (wl # NIL)) THEN RETURN END;
$
$IF (ADDRESS(newEntryToStr)=NIL) THEN
&(*
'* Font setzen
'*)
&IF wl = NIL THEN careOfInitGem; END;
&GEMBase.GetPBs (gemHdl, vdipb, aespb); (* fr "GetFaceName" *)
&FOR fontnr:= 1 TO Fonts DO
(GetFaceName (dev, fontnr, fontname);
(IF StrEqual (fontname, title) THEN
*IF wl = NIL THEN
,StdFontHdl:= vdipb.iooff^[0];
,SetTextFace (dev, StdFontHdl);
,SetPtsTHeight (dev, newWidth, c, c, c, c); (* Gre setzen *)
,GetFaceInfo (dev, voidC,voidC,voidC,voidC,voidC,voidC,
0StdFontHeight,voidI,voidI,voidI,voidI);
,RETURN
*ELSE
,WITH wl^ DO
.IF (fontHdl # ORD (vdipb.iooff^[0]))
.OR (fontSize # newWidth) THEN
0fontHdl:= vdipb.iooff^[0];
0fontSize:= newWidth;
0
0(* size:= WindowSizeWL (wl); *)
0SetTextFace (dev, fontHdl);
0SetPtsTHeight (dev, fontSize, voidC, voidC, voidC, voidC);
0GetFaceInfo (dev, voidC,voidC, bottom,voidC,voidC,voidC, top,
=width0, voidI,voidI,voidI);
0charW := width0;
0charH := INTEGER (top) + INTEGER (bottom) + 1;
0baseLine := INTEGER (top);
0width := MaxCard DIV (8 * CARDINAL (charW));
0height := MaxCard DIV (8 * CARDINAL (charH));
0(* setWindowSize (wl, size); *)
0RedrawWindow (wdw);
.END
,END;
,RETURN
*END
(END;
&END;
 
$ELSE
$
&WITH wl^ DO
&
(IF set THEN GetListWL (wl, voidList) END;
(
(clientList := l;
(createListWithAttrs (list, clientList, success);
(IF ~ success THEN state := outOfMemoryWL; RETURN END;
(entryToStr := newEntryToStr;
(closeWList := newCloseWList;
(selectEntry := newSelectEntry;
(environment := newEnvironment;
(SetWindowString (wdw, titleWdwStr, title);
(
(width := newWidth;
(height := NoOfEntries (list);
(
(set := TRUE;
(
(GetWindowSpec (wdw, spec);
(IF viewLine # 0 THEN
*INC (spec.virtual.y, spec.visible.y);
*spec.visible.y := lineToViewPos (wl, viewLine);
*DEC (spec.virtual.y, spec.visible.y);
*viewLine := 0;
(END;
(spec.virtual.w := LONG (INTEGER (width)) * LONG (charW);
(spec.virtual.h := LONG (INTEGER (height)) * LONG (charH);
(SetWindowSpec (wdw, spec);
&
&END;(*WITH*)
(
&IF isOpen (wl) THEN ShowWindowWL (wl) END;
$END
"END SetListWL;
 
 PROCEDURE GetListWL (wl: WindowList; VAR l: List);
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$l := wl^.clientList;
$killListWithAttrs (wl^.list);
$
$wl^.set := FALSE;
"END GetListWL;
 
 PROCEDURE ShowWindowWL (wl: WindowList);
 
"VAR   entry           : ADDRESS;
(c, r, w, h      : INTEGER;
 
"BEGIN
 (*$? TestVersion:
"WriteLn;
"WriteString ("'WindowLists': 'ShowWindowWL' called...");
!*)
$IF notValidOrSet (wl) THEN RETURN END;
$
$WITH wl^ DO
$
&IF ~ isOpen (wl)
&THEN
 (*$? TestVersion:
"WriteString ("for a closed window.");
"WriteLn;
!*)
$
(OpenWindow (wdw);
(IF WindowState (wdw) # okWdw THEN
*ResetWindowState (wdw);
*state := cantShowWL;
(END;
(
&ELSE
 (*$? TestVersion:
"WriteString ("for a already open window.");
"WriteLn;
!*)
(RedrawWindow (wdw);
&END;
&
$END;(*WITH*)
 (*$? TestVersion:
"WriteString ("normal termination of 'ShowWindowWL'.");
"WriteLn;
!*)
"END ShowWindowWL;
 
 PROCEDURE HideWindowWL (wl: WindowList);
 
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$IF isOpen (wl) THEN CloseWindow (wl^.wdw) END;
"END HideWindowWL;
"
 PROCEDURE DeleteWL (VAR wl: WindowList);
 
"PROCEDURE delist (VAR elem: WindowList);
"
$BEGIN
&IF elem = NoWindowList THEN HALT          (*  fatal error  *)
&ELSIF elem = wl THEN elem := wl^.next
&ELSE delist (elem^.next) END;
$END delist;
$
 
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$IF isOpen (wl) THEN HideWindowWL (wl) END;
$IF wl^.set THEN killListWithAttrs (wl^.list) END;
$DeleteWindow (wl^.wdw);
$
$delist (windowListRoot);
$wl^.magic := 0L;
$DISPOSE (wl);
$wl := NoWindowList;
"END DeleteWL;
"
 PROCEDURE EnhancedOutputWL (wl: WindowList; enhanced: BOOLEAN);
 
"VAR frame : LongRect;
&spec  : WindowSpec;
&
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$wl^.enhanced := enhanced;   (*  remember enhanced mode  *)
$IF NOT enhanced             (*  redraw if enhanced mode is switched off  *)
$THEN
&GetWindowSpec (wl^.wdw, spec);
&frame := spec.visible;
&UpdateWindow (wl^.wdw, update, wl, frame, noCopyWdw, 0L);
$END;
"END EnhancedOutputWL;
 
(
 PROCEDURE StateWL (wl: WindowList): ErrorStateWL;
 
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.W  #invalidWL,(A3)+
(MOVE.L  A0,D1
(BEQ     ende                    ; 'wl = NIL'
(
(AND.L   #1,D1
(BNE     ende                    ; odd addr.
(
(MOVE.L  #wlMagic,D1
(CMP.L   WindowList.magic(A0),D1
(BNE     ende
(
(MOVE.W  WindowList.state(A0),-2(A3)
(
 ende
$END;
"END StateWL;
"(*$L=*)
"
 PROCEDURE ResetStateWL (wl: WindowList);
 
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$wl^.state := okWL;
"END ResetStateWL;
"
 
((*  list operations  *)
 
 (*  rules for list op.s:
!*
!*  -- First search in the 'wl^.list'. Not found raises 'unkownEntryWL'.
!*
!*  -- Not found in 'wl^.clientList' means to raise 'listFaultWL'.
!*)
 
 PROCEDURE AddEntryWL (wl: WindowList; entry, predEntry: ADDRESS);
 
"VAR   success,
(err    : BOOLEAN;
(elem   : ptrElement;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$WITH wl^ DO
$
&(*  find insert pos.
'*)
&IF predEntry = NIL THEN ResetList (list); ResetList (clientList);
&ELSE
(findEntryInListWithAttrs (list, predEntry, success);
(IF ~ success THEN state := unkownEntryWL; RETURN END;
(FindEntry (clientList, predEntry, success);
(IF ~ success THEN state := listFaultWL; RETURN END;
&END;
&
&(*  create new elem.
'*)
&SysAlloc (elem, SIZE (elem^));
&IF elem = NIL THEN state := outOfMemoryWL; RETURN END;
&elem^.entry := entry; elem^.attrs := AttributesWL {};
&
&(*  insert elem.
'*)
&InsertEntry (list, elem, err);
&IF err THEN
(wl^.state := outOfMemoryWL;
(DEALLOCATE (elem, SIZE (elem^));
(RETURN
&END;
&InsertEntry (clientList, entry, err);
&IF err THEN
(wl^.state := outOfMemoryWL;
(RemoveEntry (list, voidO);
(DEALLOCATE (elem, SIZE (elem^));
(RETURN
&END;
$
&INC (height);
$
$END;
$IF isOpen (wl) THEN redrawEntries (wl, entry, entry) END;
"END AddEntryWL;
"
 PROCEDURE AppendEntryWL (wl: WindowList; entry: ADDRESS);
 
"VAR   err    : BOOLEAN;
(elem   : ptrElement;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$WITH wl^ DO
$
&(*  create new elem.
'*)
&SysAlloc (elem, SIZE (elem^));
&IF elem = NIL THEN state := outOfMemoryWL; RETURN END;
&elem^.entry := entry; elem^.attrs := AttributesWL {};
&
&(*  append elem.
'*)
&AppendEntry (list, elem, err);
&IF err THEN
(state := outOfMemoryWL;
(DEALLOCATE (elem, SIZE (elem^));
(RETURN
&END;
&AppendEntry (clientList, entry, err);
&IF err THEN
(state := outOfMemoryWL;
(RemoveEntry (list, voidO);
(DEALLOCATE (elem, SIZE (elem^));
(RETURN
&END;
$
&INC (height);
$
$END;
$IF isOpen (wl) THEN redrawEntries (wl, entry, entry) END;
"END AppendEntryWL;
"
 PROCEDURE RemoveEntryWL (wl: WindowList; entry: ADDRESS);
 
"VAR   err,
(success: BOOLEAN;
(elem   : ptrElement;
"
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$WITH wl^ DO
$
&(*  find and remove from list with attr.s.
'*)
&findEntryInListWithAttrs (list, entry, success);
&IF ~ success THEN
(state := unkownEntryWL;
(RETURN
&END;
&RemoveEntry (list, voidO);
&elem := NextEntry (list);
$
&(*  remove from client list.
'*)
&FindEntry (clientList, entry, err);
&IF err THEN state := listFaultWL END;
&RemoveEntry (clientList, voidO);
&
&DEC (height);
&
$END;
$
$IF isOpen (wl) THEN redrawEntries (wl, elem^.entry, NIL) END;
"END RemoveEntryWL;
"
 PROCEDURE ReplaceEntryWL (wl        : WindowList;
:oldEntry,
:newEntry  : ADDRESS;
:keepAttrs : BOOLEAN);
 
"VAR   success: BOOLEAN;
(elem   : ptrElement;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$WITH wl^ DO
$
&(*  Replace in the attr-list.
'*)
&findEntryInListWithAttrs (list, oldEntry, success);
&IF ~ success THEN state := unkownEntryWL; RETURN END;
&elem := CurrentEntry (list);
&elem^.entry := newEntry;
&IF ~ keepAttrs THEN elem^.attrs := AttributesWL {} END;
&
&(*  Replace in the client list.
'*)
&FindEntry (clientList, oldEntry, success);
&IF ~ success THEN state := listFaultWL; RETURN END;
&RemoveEntry (clientList, voidO);
&InsertEntry (clientList, newEntry, voidO);
&
$END;
$
$IF isOpen (wl) THEN redrawEntries (wl, newEntry, newEntry) END;
"END ReplaceEntryWL;
 
 TYPE    serverEnvRec    = RECORD
<wl          : WindowList;
<proc        : QueryProcWL;
<procEnv     : ADDRESS;
<entry       : ADDRESS;
:END;
(ptrServerEnv    = POINTER TO serverEnvRec;
 
 PROCEDURE queryServer (element, env: ADDRESS): BOOLEAN;
 
"VAR   serverEnv  : ptrServerEnv;
(elem       : ptrElement;
(continue   : BOOLEAN;
(listCurrent: LCarrier;
(oldAttrs   : AttributesWL;
 
"BEGIN
$serverEnv := ptrServerEnv (env);
$elem := ptrElement (element);
$
$WITH serverEnv^ DO
$
&(*  Save curr. entry in your environment and call the client proc.,
'*  but ensure the invariability of the ref. to current list elem.
'*  of the queried list.
'*  If the attr.s are changed from the query proc., then redraw the
'*  current element.
'*)
&entry := elem^.entry;
&listCurrent := wl^.list.current;
&oldAttrs := elem^.attrs;
&continue := proc (entry, procEnv, elem^.attrs);
&
&IF oldAttrs # elem^.attrs
&THEN
(redrawEntries (wl, elem^.entry, elem^.entry);
&END;
&
&wl^.list.current := listCurrent;
$END;
$
$RETURN ~ continue
"END queryServer;
"
 PROCEDURE QueryListWL (    wl   : WindowList;
;dir  : QueryDirectionWL;
;proc : QueryProcWL;
;env  : ADDRESS;
7VAR cut  : BOOLEAN;
7VAR entry: ADDRESS);
 
"VAR   direc    : LDir;
(serverEnv: serverEnvRec;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$IF dir = forwardWL THEN direc := forward ELSE direc := backward END;
$serverEnv.wl := wl;
$serverEnv.proc := proc;
$serverEnv.procEnv := env;
$ResetList (wl^.list);
$ScanEntries (wl^.list, direc, queryServer, ADR (serverEnv), cut);
$entry := serverEnv.entry;
"END QueryListWL;
"
 PROCEDURE EntryAttributesWL (wl: WindowList; entry: ADDRESS): AttributesWL;
 
"VAR   success: BOOLEAN;
(elem   : ptrElement;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN AttributesWL{} END;
 
$WITH wl^ DO
&
&(*  Find. 'entry'.
'*)
&findEntryInListWithAttrs (list, entry, success);
&IF ~ success THEN state := unkownEntryWL; RETURN AttributesWL{} END;
&elem := CurrentEntry (list);
&
&RETURN elem^.attrs
&
$END;
"END EntryAttributesWL;
"
 PROCEDURE SetEntryAttributesWL (wl   : WindowList;
@entry: ADDRESS;
@attrs: AttributesWL);
 
"VAR   success: BOOLEAN;
(elem   : ptrElement;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$
$WITH wl^ DO
&
&(*  Find. 'entry'.
'*)
&findEntryInListWithAttrs (list, entry, success);
&IF ~ success THEN state := unkownEntryWL; RETURN END;
&elem := CurrentEntry (list);
&
&(*  Set new attr.s, if necessary.
'*)
&IF attrs # elem^.attrs THEN
(elem^.attrs := attrs;
(redrawEntries (wl, elem^.entry, elem^.entry);
&END;
&
$END;
"END SetEntryAttributesWL;
"
 PROCEDURE GetEntryBoxWL (    wl     : WindowList;
=entry  : ADDRESS;
9VAR box    : Rectangle;
9VAR visible: BOOLEAN);
 
"VAR   pos  : CARDINAL;
(frame: Rectangle;
(loc  : Point;
 
"BEGIN
$IF notValidOrSet (wl) THEN RETURN END;
$WITH wl^ DO
&pos := listEntryPos (wl, entry);
&IF pos = 0 THEN state := unkownEntryWL; RETURN END;
&
&CalcScreenCoor (wdw, LPnt (0, LONG (INTEGER (pos - 1)) * LONG (charH)),
6loc, voidO);
&box := TransRect (Rect (0, 0, INTEGER (width) * charW, charH), loc);
&frame := ClipRect (box, WindowWorkArea (wdw));
&visible := (frame.w > 0);
$END
"END GetEntryBoxWL;
"
"
((*  window operations  *)
 
 PROCEDURE SetInfoLineWL (wl: WindowList; REF infoStr: ARRAY OF CHAR);
 
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$IF wl^.infoLine THEN SetWindowString (wl^.wdw, infoWdwStr, infoStr) END;
"END SetInfoLineWL;
"
 PROCEDURE ViewLineWL (wl: WindowList; line: CARDINAL);
 
"BEGIN
$IF notValid (wl) OR (line = 0) THEN RETURN END;
$
$IF wl^.set THEN
 
&SetWindowSliderPos (wl^.wdw, OldWindowSlider, lineToViewPos (wl, line));
$
$ELSE wl^.viewLine := line END;
"END ViewLineWL;
"
 PROCEDURE SetWindowSizeWL (wl: WindowList; size: Rectangle);
 
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$setWindowSize (wl, size);
"END SetWindowSizeWL;
"
 PROCEDURE PutWindowOnTopWL (wl: WindowList);
 
"BEGIN
$IF notValid (wl) THEN RETURN END;
$
$PutWindowOnTop (wl^.wdw);
"END PutWindowOnTopWL;
"
 PROCEDURE WindowSizeWL (wl: WindowList): Rectangle;
%
"VAR   frame: Rectangle;
 
"BEGIN
$IF notValid (wl) THEN RETURN Rect (0, 0, 0, 0) END;
$
$frame := WindowWorkArea (wl^.wdw);
$WITH frame DO
&x := (x + INT(stdCharW) DIV 2) DIV INT(stdCharW);
&y := (y) DIV INT(stdCharH);
&w := w DIV wl^.charW;
&h := h DIV wl^.charH;
$END;
$
$RETURN frame
"END WindowSizeWL;
"
 PROCEDURE IsTopWindowWL (wl: WindowList): BOOLEAN;
 
"BEGIN
$IF notValid (wl) THEN RETURN FALSE END;
$
$RETURN topWdw IN WindowFlags (wl^.wdw)
"END IsTopWindowWL;
 
 PROCEDURE DetectWindowWL (REF targets: ARRAY OF WindowList; noTrg: CARDINAL;
>loc    : Point;
>mode   : DetectModeWL;
>selMode: LONGCARD;
:VAR wl     : WindowList;
:VAR entry,
>env    : ADDRESS;
:VAR empty  : BOOLEAN);
 
"VAR   (*$Reg*) i: CARDINAL;
(matchWdw  : Window;
(match     : BOOLEAN;
(elem      : ptrElement;
(
"BEGIN
$IF noTrg = 0 THEN noTrg := HIGH (targets) ELSE DEC (noTrg) END;
$
$(*  Look for a wdw. at 'loc'.
%*)
$i := 0; match := FALSE;
$WHILE (i <= noTrg) AND ~ match DO
&detect (targets[i], loc, match, elem, empty);
&INC (i);
$END;
$DEC (i);
$
$(*  If you found a wdw., then return found parm.s and call
%*  selection proc. if necessary.
%*)
$wl := NoWindowList; entry := NIL;
$IF match THEN
&IF elem # NIL THEN entry := elem^.entry END;
&wl := targets[i]; env := targets[i]^.environment;
&IF (mode = selectWL) AND (entry # NIL) AND ~ (disabledWL IN elem^.attrs)
&THEN
(targets[i]^.selectEntry (wl, entry, env, selMode)
&END;
$END;
"END DetectWindowWL;
 
"
((*  operations for open windows only  *)
 
 PROCEDURE SelectAreaWL (wl          : WindowList;
8area        : Rectangle;
8firstSelMode,
8restSelMode : LONGCARD);
 
"VAR   elem1, elem2  : ptrElement;
(selMode       : LONGCARD;
(match1, match2: BOOLEAN;
(listCurrent   : LCarrier;
(
"BEGIN
$IF notValid (wl) OR notOpen (wl) THEN RETURN END;
$
$WITH wl^ DO
&detect (wl, MinPoint (area), match1, elem1, voidO);
2
&detect (wl, Pnt (area.x, area.y + area.h - 1), match2, elem2, voidO);
&(*  If not in wdw., then use last visible row in 'wl'. If that row is
'*  not used, then 'entry2' = "last entry of 'list'".
'*)
&IF ~ match2 OR (elem2 = NIL) THEN
(detect (wl, MaxPoint (WindowWorkArea (wdw)), match2, elem2, voidO);
(IF ~ match2 OR (elem2 = NIL) THEN
*ResetList (list);
*elem2 := PrevEntry (list);
(END;
&END;
2
&IF match1 AND (elem1 # NIL) THEN
(
(selMode := firstSelMode;
(FindEntry (list, elem1, voidO);
(
(REPEAT
*
*elem1 := CurrentEntry (list);
*IF ~ (disabledWL IN elem1^.attrs) THEN
*
,(*  Save ref. to curr. list elem. and thereafter call the
-*  selection proc. At the end restore the ref. to curr.
-*  (Cause the sel. proc. might use the same list).
-*)
,listCurrent := list.current;
,wl^.selectEntry (wl, elem1^.entry, environment, selMode);
,list.current := listCurrent;
,
*END;
*
*voidADR := NextEntry (list);
*selMode := restSelMode;
*
(UNTIL  elem1 = elem2;
(
&END;(*IF*)
$END;(*WITH*)
0
"END SelectAreaWL;
"
"
((*  Misc. Managment  *)
((*  ===============  *)
(
 PROCEDURE envlpProc (start, child:BOOLEAN; VAR id:INTEGER);
 
"VAR     ptr     : WindowList;
"
"BEGIN
$IF child THEN
&IF start THEN INC (modID)           (*  new module  *)
&ELSE
(
(ptr := windowListRoot;
(LOOP
*IF ptr = NIL THEN EXIT            (*  Ready *)
*ELSIF ptr^.modID >= modID THEN
,DeleteWL (ptr);
,ptr := windowListRoot;          (*  Again!  *)
*ELSE ptr := ptr^.next END;        (*  Next  *)
(END;
(
(careOfExitGem;
(DEC (modID);                      (*  release module  *)
(
&END;
$END;
"END envlpProc;
 
 PROCEDURE termProc;
 
"BEGIN
 (*$? TestVersion:
"WriteString ("'WindowLists' terminating."); WriteLn;
!*)
$envlpProc (FALSE, TRUE, voidI);
"END termProc;
 
 PROCEDURE removalProc;
 
"BEGIN
"
 (*$? TestVersion:
"WriteString ("'WindowLists' removing..."); WriteLn;
!*)
!
$envlpProc (FALSE, TRUE, voidI);
$exitGem;
$
 (*$? TestVersion:
"WriteString ("...'WindowLists' removed."); WriteLn;
!*)
!
"END removalProc;
 
 
 VAR     termCrr         : TermCarrier;
(envlpCrr        : EnvlpCarrier;
(removalCrr      : RemovalCarrier;
(wsp             : MemArea;
!
 BEGIN
"SetEnvelope (envlpCrr, envlpProc, wsp);
"CatchProcessTerm (termCrr, termProc, wsp);
"CatchRemoval (removalCrr, removalProc, wsp);
"
"modID := 1;
"gemHdl := noGem;
"stdMFDB.start := NIL; (*  logical screen  *)
"
"windowListRoot := NIL;
 END WindowLists.
 
(* $000079DD$00003BD9$00007BCF$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$00003D78$FFF7016F$FFF7016F$FFF7016F$FFF7016F$0000AF82$FFF7016F$FFF7016F$FFF7016F$FFF6B0D9$FFF6B0D9$FFF6B0D9$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF7016F$FFF6B0D9$FFF6B0D9$FFF7016F$FFF6B0D9$0000ABBF$FFF7016F$FFF7016F$000014CET.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFDF398E$00006E39$FFDF398E$FFDF398E$FFDF398E$00006E39$0000149D$000014A8$000014CE$FFDF398E$00006B3A$000070DF$000070F4$00007088$0000709D$00006CB5*)
