 MODULE LANMonitor; (*$H+,Z+,R-*)
 
 (*
 NOTES
 -----
 - Testen auch ohne Interrupts - nur Polling!
 - Die CRC-Prfung scheint nicht zu klappen. Zumindest wird kein Fehler angezeigt,
"wenn beim empf. Dataframe das 1.Byte fehlt.
"-> Evtl. wird overrun gelmeldet und nicht erkannt?
 - Wenn 'excessCollsns' gemeldet wird, kann das auch heien, da
"der Partner berhaupt nicht geantwortet hat (also kein CTS auf's RTS
"gesandt hat).
 - oft passiert es, da das CTS zu spt kommt. Dann wird in 'GetFrame'
"'fAdrInUse' gesetzt, weil man annimmt, da jemand anderes auf ein RTS
"geantwortet hat (denn 'fCTSexpected ist schon FALSE).
"Das ist eigentlich OK, nur da das *erwartete* CTS offenbar dann zu spt kam.
 - seltsamerweise klappt beim TransmitPacket immer der erste RTS nicht.
"Es kommt dann kein CTS? Bei weiteren RTS klappt's dafr immer.
 *)
 
 (*
 IMPORT TOSDebug;
 *)
 
 IMPORT SYSTEM;
 FROM SYSTEM IMPORT ASSEMBLER, ADR, BYTE;
 
 IMPORT MOSGlobals, PrgCtrl;
 
 IMPORT TOSIO; (*$E MOS *)
 IMPORT InOut, FuncStrings, StrConv;
 FROM InOut IMPORT WriteLn, Write, WriteCard, ReadCard, ReadLCard, Read,
0GotoXY, WritePg, WriteString, WriteHex, WriteLHex,
0KeyPressed, Done, WriteNum, WriteLNum;
 
 FROM GEMDOS IMPORT Super;
 IMPORT VT52; FROM VT52 IMPORT Codes;
 FROM Storage IMPORT ALLOCATE;
 
 
 CONST NMI_Mask = $0700; (* !!! $0700 *)
 
 
 (*****************************************************************************)
 
 
 MODULE SCC;
 (*$L-*)
 
 FROM SYSTEM IMPORT WORD, ADDRESS, ASSEMBLER;
 
 IMPORT Super;
 FROM PrgCtrl IMPORT TermCarrier, CatchProcessTerm;
 FROM MOSGlobals IMPORT MemArea;
 
 EXPORT QUALIFIED Reg, SetReg, CTLA;
 
 CONST CTLA = $FFFF8C81;
 
 PROCEDURE Reg (n: CARDINAL): CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE    SR,-(A7)
(MOVE    #$2500,SR
(MOVEA.W #CTLA,A1
(MOVE.W  -(A3),D0
(BEQ     read0
(MOVE.B  D0,(A1)          ; SCC A control
&read0:
(MOVE.B  (A1),D0
(MOVE    (A7)+,SR
$END;
"END Reg;
 
 PROCEDURE SetReg (no, value: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE    SR,-(A7)
(MOVE    #$2500,SR
(MOVEA.W #CTLA,A1
(MOVE.W  -(A3),D1        ; value
(MOVE.W  -(A3),D0        ; no
(BEQ     write0
(MOVE.B  D0,(A1)         ; SCC A control
&write0:
(MOVE.B  D1,(A1)
(MOVE    (A7)+,SR
$END;
"END SetReg;
 
 (*$L=*)
 
 (****** Vorsicht: ab hier $L+ ******)
 
 PROCEDURE term;
"VAR ssp: LONGCARD;
"BEGIN
$ssp:= Super (0);
$SetReg (9, $C0);
$ssp:= Super (ssp)
"END term;
 
 VAR carrier: TermCarrier;
 
 BEGIN
"CatchProcessTerm (carrier, term, MemArea{NIL,0});
 END (* MODULE *) SCC;
 
 (*****************************************************************************)
 
 MODULE ALAP;
 
 FROM SYSTEM IMPORT ADR, ASSEMBLER, BITNUM, BYTE, WORD, LONGWORD, ADDRESS, SHIFT;
 IMPORT SCC;
 FROM SCC IMPORT CTLA;
 IMPORT Super, ALLOCATE;
 IMPORT NMI_Mask;
 
 (* I/O-Routinen fr Testausgaben *)
 IMPORT InOut;
 FROM FuncStrings IMPORT ConcStr;
 FROM StrConv IMPORT CardToStr;
 
 EXPORT QUALIFIED
"WriteFrame, WriteStatus,
"Init, TransmitStatus, TransmitPacket, ReceiveFrame, ReceivePacket,
"myAddress, fAdrValid, fAdrInUse, FramesReceived, Interrupts,
"maxIFGtime, test, NewPacketBuffer, FrameStatus, anAddress, aLAPtype,
"packetBuffers, aDataField, lapENQ,
"aRxFrame, aTxFrame, aPacket, ptrPacket, maxDataSize, headPacket, tailPacket,
"deferCount, collsnCount, DataFramesOut, CTSFramesOut, RTSFramesOut;
"
 
 
 CONST   minFrameSize = 3;
(maxDataSize = 600;
(maxFrameSize = maxDataSize+5;
(
((* alle Zeitwerte sind in s angegeben *)
(bitTime = 5 (* 4.34 *);
(byteTime = 39;
(IDGslottime = 300;
(maxIFGtime = 500; (* 200 ist fr ENQ->ACK offenbar zu klein. *)
(minIDGtime = 2*maxIFGtime;
(
(maxDefers = 32;
(maxCollsns = 32;
(lapENQ = BYTE($81);
(lapACK = BYTE($82);
(lapRTS = BYTE($84);
(lapCTS = BYTE($85);
(wksTries = 20;
(
(rxEnable = $DD;
(setRTS   = $62;
(txEnable = $6B;
 
 TYPE    TransmitStatus = (transmitOK, excessDefers, excessCollsns, dupAddress);
(ReceiveStatus = (receiveOK, receiving, nullReceive, frameError);
(FrameStatus = (noFrame, lapDATAframe, lapENQframe, lapACKframe,
(lapRTSframe, lapCTSframe, badframeCRC, badframeSize, badframeType,
(overrunError, underrunError, lostAddress, undefined);
(
(bitVector = SET OF BITNUM[0..7];
(octet = BYTE;
(anAddress = octet;
(aLAPtype = octet;
(aDataField = ARRAY [1..maxDataSize] OF octet;
(ptrDataField = POINTER TO aDataField;
 
(frameInterpretation = (raw, structured);
(aRxFrame = RECORD
5CASE :frameInterpretation OF
7raw:
9rawData: ARRAY [1..maxFrameSize] OF octet|
7structured:
9dstAddr: anAddress;
9srcAddr: anAddress;
9lapType: aLAPtype;
9dataField: aDataField
5END
3END;
(
(aCtrlFrame = RECORD
7dstAddr: anAddress;
7srcAddr: anAddress;
7lapType: aLAPtype;
5END;
 
(ptrPacket = POINTER TO aPacket;
(aPacket = RECORD
4status: FrameStatus;
4length: [0..maxFrameSize];
4next  : ptrPacket;
4frame : aRxFrame;
4no    : CARDINAL;
2END;
 
(aTxFrame = RECORD
5ctrl: aCtrlFrame;
5dataCnt: CARDINAL;
5dataPtr: ptrDataField
3END;
 
 VAR     myAddress: anAddress;
(backoff: INTEGER;
(fAdrValid: BOOLEAN;
(fAdrInUse: BOOLEAN;
(fCTSexpected: BOOLEAN;
(deferCount, collsnCount: CARDINAL;
(DataFramesOut, RTSFramesOut, CTSFramesOut: CARDINAL;
(deferHistory, collsnHistory: bitVector;
(deferTries, collsnTries, lclbackoff: INTEGER;
(RTSframe: aTxFrame;
(seed: LONGCARD;
(packetBuffers: CARDINAL;
(tailPacket: ptrPacket;  (* zeigt aufs lteste gltige Paket *)
(headPacket: ptrPacket;  (* zeigt hinter jngstes Paket *)
*(* wenn head = tail, stehen keine neuen Pakete an. *)
(
(FramesReceived, Interrupts: CARDINAL;
(test: BOOLEAN;
(
(IR_Vector [$360]: PROC;
 
 (* -------------------------------------------------- *)
 
 PROCEDURE resetRx;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVEA.W #CTLA,A1
(; resetRx
(MOVE.B  #3,(A1)
(MOVE.B  #$D0,(A1)       ; disableRx
(MOVEQ   #2,D0
&flushFIFO:
(TST.B   2(A1)
(DBRA    D0,flushFIFO
(MOVE.B  #$30,(A1)       ; reset error
(MOVE.B  #$20,(A1)       ; enable IR on next Rx
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)  ; enableRx
$END
"END resetRx;
"(*$L=*)
"
 
 CONST  rnda = 1664525;     (* Knuth S.102 Zeile 26 *)
'rndc = 117;         (* teilerfremd mit 2^32 fr max. Periode 2^32 *)
 
 PROCEDURE random;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; IN: D0.W max-Wert minus 1, OUT: D0.W 0..max-1
(MOVE.W  D0,-(A7)
(MOVE.L  seed,D0
(BNE     isInit
(; seek initialisieren
(MOVEM.L A0-A2,-(A7)
(MOVE    #17,-(A7)
(TRAP    #14
(ADD.L   D0,seed
(TRAP    #14
(ADDQ.L  #2,A7
(MOVEM.L (A7)+,A0-A2
(LSL.L   #8,D0
(ADD.L   D0,seed
&isInit:
(MOVE.L  D0,D1
(MOVE.L  D0,D2
(SWAP    D2
(MOVE.L  D3,-(A7)
(MOVE.L  #rnda,D3
(MULU    D3,D0
(MULU    D3,D2
(SWAP    D3
(MULU    D3,D1
(MOVE.L  (A7)+,D3
(SWAP    D1
(CLR.W   D1
(SWAP    D2
(CLR.W   D2
(ADD.L   D1,D0
(ADD.L   D2,D0
(ADDI.L  #rndc,D0
(MOVE.L  D0,seed
(MOVE.W  (A7)+,D1
(BEQ     rtn0
(MOVE.W  D0,D2
(CLR.W   D0
(SWAP    D0
(DIVU    D1,D0
(MOVE.W  D2,D0
(DIVU    D1,D0
(SWAP    D0
(RTS
&rtn0
(MOVEQ   #0,D0
$END
"END random;
"(*$L=*)
 
 PROCEDURE Wr (REF s: ARRAY OF CHAR);
"BEGIN
$InOut.WriteString (s);
$InOut.WriteLn;
"END Wr;
 
 PROCEDURE WriteFrame (REF packet: aPacket; no: CARDINAL);
"VAR n: CARDINAL;
"BEGIN
$FOR n:= 1 TO 5 DO
&IF n > packet.length THEN
(InOut.WriteString ('   ');
&ELSE
(InOut.WriteHex (LONG (packet.frame.rawData [n]), 3);
&END
$END;
$FOR n:= 6 TO no DO
&IF n <= packet.length THEN
(InOut.WriteHex (LONG (packet.frame.rawData [n]), 3);
(IF (ORD (packet.frame.rawData [n]) >= 32) AND
+(ORD (packet.frame.rawData [n]) < 128) THEN
*InOut.Write ('/');
*InOut.Write (CHAR(packet.frame.rawData [n]));
(END
&END
$END;
$InOut.WriteString (' ');
"END WriteFrame;
 
 PROCEDURE WriteStatus (status: FrameStatus);
"BEGIN
$CASE status OF
&|badframeCRC: InOut.WriteString ('>badframeCRC<')
&|badframeSize: InOut.WriteString ('>badframeSize<');
&|badframeType: InOut.WriteString ('>badframeType<')
&|overrunError: InOut.WriteString ('>overrunError<')
&|underrunError: InOut.WriteString ('>underrunError<')
&|lostAddress: InOut.WriteString ('>lost address<')
&|lapACKframe: InOut.WriteString ('>ACKframe<')
&|lapENQframe: InOut.WriteString ('>ENQframe<');
&|lapRTSframe: InOut.WriteString ('>RTSframe<');
&|lapCTSframe: InOut.WriteString ('>CTSframe<');
&|lapDATAframe: InOut.WriteString ('>DATAframe<');
&|noFrame: InOut.WriteString ('no frame!');
$ELSE
&InOut.WriteString ('unknown frame!');
$END;
"END WriteStatus;
 
 (* --------------------------- *)
 
 FORWARD AcquireAddress;
 FORWARD TransmitPacket;
 FORWARD TransmitFrame;
 FORWARD ReceiveFrame (VAR packet: ptrPacket): FrameStatus;
 FORWARD ReceiveLinkMgmt (VAR packet: ptrPacket): ReceiveStatus;
 FORWARD IR_Handler;
 FORWARD GetFrame;
 
 PROCEDURE NewPacketBuffer;
"VAR p, prev, last: ptrPacket; sr: CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE    SR,sr(A6)
(MOVE    #$2500,SR
$END;
$NEW (p);
$IF p # NIL THEN
&IF packetBuffers = 0 THEN
(headPacket:= p;
(tailPacket:= p;
(last:= p
&ELSE
(prev:= headPacket;
(WHILE prev^.next # tailPacket DO
*prev:= prev^.next
(END;
(last:= prev^.next;
(prev^.next:= p
&END;
&INC (packetBuffers);
&WITH p^ DO
(next:= last;
(status:= undefined;
(no:= packetBuffers
&END;
$END;
$ASSEMBLER
(MOVE    sr(A6),SR
$END;
"END NewPacketBuffer;
 
 PROCEDURE ResetReceiveBuffer;
"BEGIN
$tailPacket:= headPacket
"END ResetReceiveBuffer;
 
 TABLE.W SCCInitData:
*$09C0, $0420, $0AE0, $0600, $077E, $0C06, $0D00, $0EC0,
*$03D0, $0B70, $0E21, $0560, $0F00, $0108,
*$0200 + ADR (IR_Vector) DIV 4, $0908, $0300+rxEnable, 0;
 
 (*$L-*)
 
 PROCEDURE Init;
"(* IN: D0.B: proposed address, 0 if none *)
"BEGIN
$ASSEMBLER
(MOVE.B  D0,myAddress
(CLR     backoff
(CLR.B   deferHistory
(CLR.B   collsnHistory
(
(JSR     NewPacketBuffer
(JSR     NewPacketBuffer
(JSR     NewPacketBuffer
$
(; Init Timer A
(MOVEA.W #$FA00,A0
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
(ANDI.B  #$DF,$13(A0)    ; IMRA: Mask Timer A IR
(ORI.B   #$20,$07(A0)    ; IERA: Enable Timer-A Pending Bit
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
 
%; *** SCC initialisieren ***
%;
%; Die Clock an RTxCA ist 3.672 MHz, bentigte Baudrate ist 230400 Bit/s.
%; Dazu mte die Clock auf 1/16 geteilt werden.
%; Da fr Receive DPLL verwendet wird, und DPLL den 16fachen Clk
%; braucht, wird trotzdem kein Teiler verwendet. Stattdessen wird
%; ber den BRG geteilt.
%;
%; Der SCC arbeitet im Interrupt-Betrieb. Es wird der Non-Auto-Vektor-
%; Modus verwendet, auf Adr. $360. Der IR luft im Level 5.
%; Da nur eine einzige IR-Quelle benutzt wird (IR on 1st Rx Char or
%; special condition), wird die vector-includes-status-Option nicht
%; verwerdet.
%;
 
(; GIOffBit ($7F);
(MOVE.W  #$7F,-(A7)
(MOVE    #29,-(A7)
(TRAP    #14
(ADDQ.L  #4,A7
(
(MOVE.L  #IR_Handler,IR_Vector
(
(LEA     SCCInitData,A0
(MOVEA.W #CTLA,A1
$l1: MOVE.W  (A0)+,D0
(BEQ     e1
(MOVE.W  D0,D1
(LSR     #8,D1
(MOVE.B  D1,(A1)
(NOP
(MOVE.B  D0,(A1)
(BRA     l1
$e1:
(MOVE.B  myAddress,D0
(JSR     AcquireAddress
(
(CLR     deferCount
(CLR     collsnCount
(CLR     DataFramesOut
(CLR     RTSFramesOut
(CLR     CTSFramesOut
$END
"END Init;
 
 VAR acqFrame: aTxFrame;
 
 PROCEDURE AcquireAddress;
"(* IN: D0.B: proposed address, 0 if none *)
"BEGIN
$ASSEMBLER
(; *** choose address ***
(BSR     getNewAddress
(CLR     fAdrValid
(SUBQ    #2,A7
&acqlp2:
(CLR     fAdrInUse
(MOVE.W  #wksTries,(A7)
&acqlp:
(; TransmitPacket (myAddress, lapENQ, ENQframe.dataField, 0)
(LEA     acqFrame,A0
(MOVE.B  myAddress,D0
(MOVE.B  D0,aTxFrame.ctrl.dstAddr(A0)
(MOVE.B  D0,aTxFrame.ctrl.srcAddr(A0)
(MOVE.B  #lapENQ,aTxFrame.ctrl.lapType(A0)
(CLR.W   aTxFrame.dataCnt(A0)
(JSR     TransmitPacket
(CMPI    #transmitOK,D0
(BEQ     adrIsUsed
(TST     fAdrInUse
(BEQ     adrNotUsed
 adrIsUsed:
(MOVEQ   #0,D0
(BSR     getNewAddress
(BRA     acqlp2
 adrNotUsed:
(SUBQ    #1,(A7)
(BNE     acqlp
(ADDQ    #2,A7
(MOVE    #1,fAdrValid
(RTS
 
 getNewAddress:
(TST.B   D0
(BNE     takeIt
(MOVEQ   #127,D0
(JSR     random
(ADDQ    #1,D0
&takeIt:
(MOVE.B  D0,myAddress
(; setAddress
(MOVEA.W #CTLA,A1
(MOVE.B  #6,(A1)
(MOVE.B  myAddress,(A1)
$END;
"END AcquireAddress;
 
 PROCEDURE TransmitPacket;
"(* IN:  A0: ^aTxFrame
%OUT: D0.W TransmitStatus *)
 
"PROCEDURE BitCount;
$BEGIN
&ASSEMBLER
*; In: D0.B, Out: D1.W /D0-D2/
*MOVEQ   #0,D1
*MOVEQ   #7,D2
'l: LSR.B   #1,D0
*BCC     c
*ADDQ    #1,D1
'c: DBRA    D2,l
&END
$END BitCount;
"
"BEGIN (* TransmitPacket *)
$ASSEMBLER
(TST     fAdrInUse
(BEQ     notInUse
(MOVEQ   #dupAddress,D0
(RTS
&notInUse:
(MOVE.L  A0,-(A7)
(
(LEA     RTSframe,A1
(MOVE.B  aTxFrame.ctrl.dstAddr(A0),aTxFrame.ctrl.dstAddr(A1)
(MOVE.B  myAddress,aTxFrame.ctrl.srcAddr(A1)
(MOVE.B  #lapRTS,aTxFrame.ctrl.lapType(A1)
(CLR.W   aTxFrame.dataCnt(A1)
(
(MOVE.B  collsnHistory,D0
(BSR     BitCount
(CMPI    #2,D1
(BLS     c1
(
(; increase backoff because of too many collisions
(CLR.B   collsnHistory
(MOVE.W  backoff,D0
(BEQ     c2
(LSL     #1,D0
(CMPI    #16,D0
(BLS     c3
(MOVEQ   #16,D0
(BRA     c3
$c2: MOVEQ   #2,D0
$c3: MOVE    D0,backoff
(
$c1: MOVE.B  deferHistory,D0
(BSR     BitCount
(CMPI    #2,D1
(BCC     c4
(
(; decrease backoff if no defers recently
(CLR.B   deferHistory
(LSR.W   backoff
(
$c4: ; shift history data
(LSL     collsnHistory
(LSL     deferHistory
(
(CLR.W   deferTries
(CLR.W   collsnTries
(MOVE.W  backoff,lclbackoff
(
(MOVEA.W #CTLA,A1
(MOVEA.W #$FA00,A2
(
 again1: ; *** main loop ***
(
(; *** defer while there are other transmissions in progress ***
(
(; carrierSense?
(BTST    #4,CTLA
(BNE.W   noCarrier
(
(BRA     defer1
(
&defer2:
(ADDQ.W  #1,deferCount
(ADDQ.W  #1,deferTries
(CMPI.W  #maxDefers,deferTries
(BLS     defer1
(
(; *** Error: too many defers ***
(MOVE.W  #excessDefers,D0
(BRA.W   exit
(
&defer1:
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; defer
(CMPI    #2,lclbackoff
(BCC     c5
(MOVE    #2,lclbackoff
&c5:
(BSET    #0,deferHistory
(
(; wait for packet to pass
(; Delay: maxFrameSize * 1.5 * byteTime (39s) = maxFrameSize * 58.5 Zyklen
(MOVE    #maxFrameSize,D1
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #36,$1F(A2)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
(BRA     c6
$l6: BTST    #4,CTLA
(BNE     c7              ; kein Carrier mehr
(BTST    #5,$0B(A2)
(BEQ     c6
(MOVE.B  #$DF,$0B(A2)    ; time over: Clear Timer-A Pending Bit
$c6: DBRA    D1,l6
(
(; something is wrong: ResetRx
(JSR     resetRx
$c7: MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
&noCarrier:
(
(; resetMissingClock
(MOVE.B  #14,(A1)
(MOVE.B  #$41,(A1)
(
(; wait for min. IDG time after packet or idle line
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #minIDGtime DIV 4,$1F(A2)      ; Set Timer Count
(MOVE.B  #2,$19(A2)      ; TACR: Timer Start (Teiler: 1/10)
$l7: BTST    #4,CTLA
(BEQ     defer1          ; erneut Carrier aufgetreten
(BTST    #5,$0B(A2)      ; IPRA
(BEQ     l7
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; wait additional backoff time, deferring to others
(MOVE    lclbackoff,D0
(JSR     random
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #IDGslottime DIV 4,$1F(A2)      ; Set Timer Count
(MOVE.B  #2,$19(A2)      ; TACR: Timer Start (Teiler: 1/10)
(BRA     c8
$l8: BTST    #4,CTLA
(BEQ     defer2          ; erneut Carrier aufgetreten
(BTST    #5,$0B(A2)      ; IPRA
(BEQ     l8
(MOVE.B  #$DF,$0B(A2)    ; time over: Clear Timer-A Pending Bit
$c8: DBRA    D0,l8
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; missing clock?
(MOVE.B  #10,(A1)
(TST.B   (A1)            ; RR10
(BMI     defer2
(
(; *** send RTS ***
(
(MOVE.L  (A7),A0
(CMPI.B  #lapENQ,aTxFrame.ctrl.lapType(A0)
(BEQ     sndENQ
(LEA     RTSframe,A0
 sndENQ: MOVE    SR,D2
(ORI     #NMI_Mask,SR
(ADDQ.W  #1,RTSFramesOut
(JSR     TransmitFrame
(
(; enableRx
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)
(
(MOVE    #1,fCTSexpected
(MOVE    D2,SR
(; *** wait for CTS ***
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(MOVEM.L A1/A2,-(A7)
(JSR     ReceiveFrame/
(MOVEM.L (A7)+,A1/A2
(ADDQ.L  #4,A7
(CLR     fCTSexpected
(
(TST     fAdrInUse
(BEQ     noDup
(
(; *** Error: duplicate address ***
(MOVE.W  #dupAddress,D0
(BRA.W   exit
(
 noDup:  MOVE.L  (A7),A0
(CMPI.B  #$FF,aTxFrame.ctrl.dstAddr(A0)
(BNE     chkCTS
(; broadcast-Transmit auswerten
(CMPI    #noFrame,D0
(BNE     error1
(BRA     send2
 chkCTS: CMPI    #lapCTSframe,D0
(BNE     error1
(CMPI.B  #lapENQ,aTxFrame.ctrl.lapType(A0)
(BEQ     error1
(
 send2:  ; *** eigentliches Paket senden ***
(MOVE    SR,D2
(ORI     #NMI_Mask,SR
(ADDQ.W  #1,DataFramesOut
(JSR     TransmitFrame
(
(; enableRx
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)
(
(MOVE    D2,SR
(MOVE.W  #transmitOK,D0
(BRA.W   exit
(
 error1  ; assume collision because we didn't receive the expected CTS
(ADDQ    #1,collsnCount
(BSET    #0,collsnHistory
(ADDQ    #1,collsnTries
(CMPI    #maxCollsns,collsnTries
(BHI     excssC
(
(MOVE.W  lclbackoff,D0
(BEQ     c12
(LSL     #1,D0
(CMPI    #16,D0
(BLS     c13
(MOVEQ   #16,D0
(BRA     c13
#c12: MOVEQ   #2,D0
#c13: MOVE    D0,lclbackoff
(
(BRA     again1
(
 excssC: ; *** Error: too many collisions ***
(MOVE.W  #excessCollsns,D0
 exit:   ADDQ.L  #4,A7
$END;
"END TransmitPacket;
 
 PROCEDURE TransmitFrame;
"BEGIN
$ASSEMBLER
(; A0: ^aTxFrame, A1: CTLA, A2: $FFFFFA00
(; enableTxDrivers
(MOVE.B  #5,(A1)
(MOVE.B  #setRTS,(A1)
(
(; Pause f. Sync-Pulse (1 Bit: 1.5 * bitTime (6.51s) = 16 Zyklen)
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #4,$1F(A2)      ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l: BTST    #5,$0B(A2)      ; IPRA
(BEQ     l
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; disableTxDrivers
(MOVE.B  #5,(A1)
(MOVE.B  #$60,(A1)
(
(; Pause f. Sync-Pulse (1 Bit: 1.5 * bitTime (6.51s) = 16 Zyklen)
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #4,$1F(A2)      ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l2 BTST    #5,$0B(A2)      ; IPRA
(BEQ     l2
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; enableTxDrivers, enableTx
(MOVE.B  #5,(A1)
(MOVE.B  #txEnable,(A1)
(
(; disableRx
(MOVE.B  #3,(A1)
(MOVE.B  #$D0,(A1)
(
(; 2 * txFlag
(; Delay: 2 * 1.5 * byteTime (39s) = 116 Zyklen
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #70,$1F(A2)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l3 BTST    #5,$0B(A2)      ; IPRA
(BEQ     l3
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; resetCRC
(MOVE.B  #$80,(A1)
(
(BSR     TxChar
(BSR     TxChar
(BSR     TxChar
(ADDQ.L  #1,A0
(MOVE.W  (A0)+,D0
(DBRA    D0,nextChar2
(BRA     allSent
%nextChar2:
(MOVE.L  (A0)+,A0
%nextChar:
(BTST    #2,(A1)
(BEQ     nextChar
(MOVE.B  (A0)+,2(A1)
(DBRA    D0,nextChar
%allSent:
(
(; resetUnderrun
(MOVE.B  #$C0,(A1)
(
(; TxFCS: wait for underrun
%notUnder:
(BTST    #6,(A1)
(BEQ     notUnder
(
(; TxFlag (?)
%notEmpty2:
(BTST    #2,(A1)
(BEQ     notEmpty2
(
(; enableTxDrivers, disableTx
(MOVE.B  #5,(A1)
(MOVE.B  #setRTS,(A1)
(
(; txONEs (?)
(; Delay: 1.5 * byteTime (39s) = 58 Zyklen
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #35,$1F(A2)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l4 BTST    #5,$0B(A2)      ; IPRA
(BEQ     l4
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; disableTxDrivers
(MOVE.B  #5,(A1)
(MOVE.B  #$60,(A1)
(
(; resetMissingClock
(MOVE.B  #14,(A1)
(MOVE.B  #$41,(A1)
(RTS
(
%TxChar:
(BTST    #2,(A1)
(BEQ     TxChar
(MOVE.B  (A0)+,2(A1)
$END;
"END TransmitFrame;
 
 (*$L+*)
 
 PROCEDURE ReceivePacket (VAR dstParam: anAddress;
9VAR srcParam: anAddress;
9VAR typeParam: aLAPtype;
9VAR dataParam: aDataField;
9VAR dataLength: INTEGER);
"VAR status: ReceiveStatus; packet: ptrPacket;
"BEGIN
$REPEAT UNTIL (ReceiveLinkMgmt (packet) = receiveOK) OR InOut.KeyPressed ();
$WITH packet^.frame DO
&dstParam:= dstAddr;
&srcParam:= srcAddr;
&typeParam:= lapType;
&dataParam:= dataField (*!!! hier werden 600 Byte kopiert -> Ptr verw.*)
$END;
"END ReceivePacket;
 
 PROCEDURE ReceiveLinkMgmt (VAR packet: ptrPacket): ReceiveStatus;
"
"VAR status: ReceiveStatus;
&rcvdStatus: FrameStatus;
&sr: CARDINAL;
"
"BEGIN
$ASSEMBLER
(MOVE    SR,sr(A6)
(MOVE    #$2500,SR
$END;
$status:= receiving;
$REPEAT
&rcvdStatus:= ReceiveFrame (packet);
&IF rcvdStatus # noFrame THEN
(InOut.WriteCard (packet^.no, 1); InOut.Write (' ');
(WriteFrame (packet^,99);
(InOut.WriteLn;
(WriteStatus (rcvdStatus); InOut.WriteLn;
&END;
&CASE rcvdStatus OF
&|badframeCRC, badframeSize, badframeType, overrunError, underrunError,
'lostAddress:
(status:= frameError
&|lapACKframe:
&|lapENQframe:
((* wird nun schon beim Empfang erledigt *)
(HALT
((*
*IF fAdrValid THEN
,WITH ACKframe DO
.dstAddr:= packet^.frame.srcAddr;
.srcAddr:= myAddress;
.lapType:= lapACK
,END;
,TransmitFrame (ACKframe, 3);
*ELSE
,fAdrInUse:= TRUE
*END;
*status:= nullReceive
(*)
&|lapRTSframe:
((* wird nun schon beim Empfang erledigt *)
(HALT
((*
*IF fAdrValid THEN
,WITH CTSframe DO
.dstAddr:= headPacket^.frame.srcAddr;
.srcAddr:= myAddress;
.lapType:= lapCTS
,END;
,TransmitFrame (CTSframe, 3);
*ELSE
,fAdrInUse:= TRUE;
,status:= nullReceive
*END;
(*)
&|lapDATAframe:
(IF fAdrValid THEN
*status:= receiveOK
(ELSE
*ASSEMBLER
+;BREAK
*END;
*fAdrInUse:= TRUE;
*status:= nullReceive
(END;
&|noFrame:
(status:= nullReceive
&ELSE
&END
$UNTIL status # receiving;
$ASSEMBLER
(MOVE    sr(A6),SR
$END;
$RETURN status
"END ReceiveLinkMgmt;
 
 PROCEDURE ReceiveFrame (VAR packet: ptrPacket): FrameStatus;
"
"VAR status: FrameStatus;
 
"BEGIN
$ASSEMBLER
(MOVEA.W #CTLA,A1
(MOVEA.W #$FA00,A2
(MOVE.L  tailPacket,A0
(
(; *** warten auf Frame-Empfang (IR o. Polling) ***
(
(MOVEQ   #0,D1
(
$l1: MOVE.B  #$DF,$0B(A2)               ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #maxIFGtime DIV 4,$1F(A2)  ; TADR: Set Timer Count
(MOVE.B  #2,$19(A2)                 ; TACR: Timer Start (Teiler: 1/10)
$l0: ; zuerst prfen, ob evtl. noch ein Frame zu pollen ist,
(; auch wenn noch weitere Pakete schon im Puffer warten.
(MOVE.B  #3,(A1)
(BTST.B  #5,(A1)         ; RR3: Rx IR pending?
(BNE     pollFrame
(CMPA.L  headPacket,A0
(BNE     gotFrame
(BTST    #5,$0B(A2)      ; time over?
(BEQ     l0
(; IR-Receive nochmal prfen, falls IR zw. vorigem CMP und Time-Chk kam.
(CMPA.L  headPacket,A0
(BNE     gotFrame
(
((*
(TST     test
(BEQ     timeout
(
(ADDQ    #1,D1
(BRA     l1
(*)
(
$timeout:
(; time out
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(MOVE.L  packet(A6),A0
(CLR.L   (A0)
(MOVE    #noFrame,status(A6)
(BRA.W   exit2
(
$gotFrame:
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(BRA     exit
(
$pollFrame:
(MOVE    SR,D2
(ORI     #NMI_Mask,SR
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(JSR     GetFrame
(MOVE.B  #1,(A1)
(MOVE.B  #$08,(A1)
(MOVE    D2,SR
(
$exit:
(MOVE.L  tailPacket,D0
(MOVE.L  packet(A6),A0
(MOVE.L  D0,(A0)
(MOVE.L  D0,A0
(MOVE    aPacket.status(A0),status(A6)
(MOVE.L  aPacket.next(A0),tailPacket
(
$exit2:
$END;
$RETURN status 
"END ReceiveFrame;
 
 PROCEDURE IR_Handler;
"(*$L-*)
"BEGIN
$ASSEMBLER
(ORI     #NMI_Mask,SR
(MOVEM.L A0-A2/D0-D1,-(A7)
(
(MOVEA.W #$FA00,A2
(MOVEA.W #CTLA,A1
(JSR     GetFrame
(
(ADDQ.W  #1,Interrupts
(
(MOVEM.L (A7)+,A0-A2/D0-D1
(RTE
$END;
"END IR_Handler;
"(*$L=*)
 
 PROCEDURE GetFrame;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; overrun?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #5,(A1)
(BNE     isOverrun
(
(MOVE.L  headPacket,A0
(
(MOVE.B  2(A1),D0                ; 1. char sofort holen
(MOVE.B  D0,aPacket.frame(A0)
(
(MOVE.B  #2,4(A1)
(BTST.B  #0,4(A1)                ; RR2B
(BNE     specCond
(
(MOVEQ   #100,D1
&wait2:
(BTST    #0,(A1)
(DBNE    D1,wait2
(; overrun?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #5,(A1)
(BNE     isOverrun
(
(MOVE.B  2(A1),aPacket.frame+1(A0)
(
(MOVEQ   #2,D0
(BRA     nextChar
(
$specCond:
(
$again:
(CLR     D0
(
$loop2:
(; overrun?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #5,(A1)
(BEQ     noOverrun
(
$isOverrun:
(MOVE    D0,aPacket.length(A0)
(MOVE.W  #overrunError,aPacket.status(A0)
(BRA.W   exit2
(
$timeOut:
(MOVE    D0,aPacket.length(A0)
(MOVE.W  #noFrame,aPacket.status(A0)
(BRA.W   exit2
(
$noOverrun:
(MOVEQ   #100,D1 ;!!! Wert OK?
&wait4:
(BTST    #0,(A1)
(DBNE    D1,wait4
(BEQ     timeOut
(
(; *** read data ***
(CMPI.W  #maxFrameSize,D0        ; incomingLength
(BCS     getChar
(
$sizeError:
(MOVE    D0,aPacket.length(A0)
(MOVE.W  #badframeSize,aPacket.status(A0)
(BRA.W   exit2
(
$getChar:
(; headPacket^.frame.rawData [incomingLength]:= rxData ()
(MOVE.B  2(A1),aPacket.frame(A0,D0.W)  ; RR8
(ADDQ.W  #1,D0             ; incomingLength
(
$nextChar:
$noDataNow:
(; end of frame?
(MOVE.B  #1,(A1)   ; RR1
(TST.B   (A1)
(BPL     loop2
(
(SUBQ.W  #2,D0           ; incomingLength
(MOVE    D0,aPacket.length(A0)
(
(CMPI.W  #minFrameSize,D0
(BCS     sizeError
(
(; resetRx
(MOVE.B  #3,(A1)
(MOVE.B  #$D0,(A1)       ; disableRx
(
(; CRC OK?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #6,(A1)
(BEQ     crcOK
(
(MOVE.W  #badframeCRC,aPacket.status(A0)
(BRA.W   exit2
(
$crcOK:
(; Stimmt 1. Byte (unsere Adr. oder #$FF)?
(MOVE.B  aPacket.frame(A0),D0
(CMPI.B  #$FF,D0
(BEQ     adrOK
(CMP.B   myAddress,D0
(BEQ     adrOK
(
(MOVE.W  #lostAddress,aPacket.status(A0)
(BRA.W   exit2
(
%adrOK:
(; *** frameDone ***
(
(TST.W   fAdrValid
(BEQ     notValid
(
(MOVE.B  aPacket.frame.lapType(A0),D0
(BMI     ctrlFrame
(
(MOVE.W  #lapDATAframe,aPacket.status(A0)
(BRA.W   exit2
(
&ctrlFrame:
(CMPI.B  #lapENQ,D0
(BEQ     isENQ
(CMPI.B  #lapACK,D0
(BEQ     isACK
(CMPI.B  #lapRTS,D0
(BEQ     isRTS
(CMPI.B  #lapCTS,D0
(BEQ     isCTS
&badFrame:
(MOVE.W  #badframeType,aPacket.status(A0)
(BRA     exit2
&isENQ:
(MOVE.W  #lapENQframe,aPacket.status(A0)
(
(BRA     exit2
&isACK:
(MOVE.W  #lapACKframe,aPacket.status(A0)
(MOVE.W  #1,fAdrInUse
(BRA     exit2
&isRTS:
(MOVE.W  #lapRTSframe,aPacket.status(A0)
(BRA     exit2
&isCTS:
(MOVE.W  #lapCTSframe,aPacket.status(A0)
(TST.W   fCTSexpected
(BNE     exit2
(; das mu wieder hier rein (s. NOTES):
(MOVE.W  #1,fAdrInUse
(BRA     badFrame
(BRA     isNoFrame ;!!!testweise
(
&notValid:
(CMPI.B  #$FF,aPacket.frame.dstAddr(A0)
(BEQ     exit2
(
(;BREAK
(MOVE    #1,fAdrInUse
&isNoFrame
(MOVE.W  #noFrame,aPacket.status(A0)
(
$exit2:
(
(MOVEQ   #2,D0
&flushFIFO:
(TST.B   2(A1)
(DBRA    D0,flushFIFO
(
(; resetMissingClock
(;MOVE.B  #14,(A1)
(;MOVE.B  #$41,(A1)
(
(; reset error
(MOVE.B  #$30,(A1)
(
(; reset IUS
(MOVE.B  #$38,(A1)
(
(; resetMissingClock
(MOVE.B  #14,(A1)
(MOVE.B  #$41,(A1)
(
(
(CMPI.W  #lapENQframe,aPacket.status(A0)
(BNE     noENQ
(
(; ACK senden
(
(CLR.W   -(A7)
(MOVE.B  #lapACK,-(A7)
(BRA     sendCtrlFrame
(
&noENQ:
(
(CMPI.W  #lapRTSframe,aPacket.status(A0)
(BNE     noRTS
(
(; CTS senden, falls kein Broadcast
(
(CMPI.B  #$FF,aPacket.frame.dstAddr(A0)
(BEQ     noCTS
(CLR.W   -(A7)
(MOVE.B  #lapCTS,-(A7)
&sendCtrlFrame:
(MOVE.B  aPacket.frame.srcAddr(A0),D0
(LSL     #8,D0
(MOVE.B  myAddress,D0
(MOVE.W  D0,-(A7)
(MOVE.L  A7,A0
(ADDQ.W  #1,CTSFramesOut
(JSR     TransmitFrame
(ADDQ.L  #6,A7
(MOVE.L  headPacket,A0
&noCTS:
(MOVE.W  #noFrame,aPacket.status(A0)
(
&noRTS:
(
(ADDQ.W  #1,FramesReceived
(
(MOVE.L  aPacket.next(A0),A0
(MOVE.L  A0,headPacket
(
(MOVE.B  #$20,(A1)         ; enable IR on next Rx
(
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)  ; enableRx
(
(; more IRs?
(BTST    #0,(A1)
(BNE     again
$END
"END GetFrame;
"(*$L=*)
 
 BEGIN
"packetBuffers:= 0;
 END (* MODULE *) ALAP;
 
 (*****************************************************************************)
 
 TYPE BS = SET OF [0..7];
%RegSet = SET OF [0..15];
 
 CONST ReadRegs  = RegSet {0,1,2,3,8,10,12,13,15};
&WriteRegs = RegSet {0..15};
&
&RegsToDisplay = RegSet {0,1,2,3,8,10,12,13,15};
&
 
 PROCEDURE WriteReg (n: CARDINAL);
"VAR reg: CARDINAL;
"BEGIN
$reg:= SCC.Reg (n);
$WriteNum (reg, 16, 2, '0');
$WriteString ('  ');
$WriteNum (reg, 2, 8, '0');
"END WriteReg;
 
 
 VAR ch: CHAR;
$rxIdx, n, c: CARDINAL;
$lc: LONGCARD;
$i: INTEGER;
$ssp, li: LONGINT;
$redraw, quit, ok, b: BOOLEAN;
$by: BS;
$myaddr, outaddr: CARDINAL;
$sentDatas,sendTrials,rcvdDatas: LONGCARD;
$
$txFrame: ALAP.aTxFrame;
$packet: ALAP.ptrPacket;
$dstParam, srcParam: ALAP.anAddress;
$typeParam: ALAP.aLAPtype;
$dataParam: ALAP.aDataField;
$txStatus: ALAP.TransmitStatus;
$frameStatus: ALAP.FrameStatus;
$dataLength: INTEGER;
 
 BEGIN
"WritePg;
"ssp:= Super (0);
"
"(*
"WriteLn;
"WriteString ('Start...');
"FOR c:= 1 TO 5 DO
$FOR n:= 1 TO 5*1000 DO
&ASSEMBLER
(MOVEA.W #$FA00,A2
(MOVEQ   #50,D0
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  D0,$1F(A2)      ; TADR: Set Timer Count
(MOVE.B  #2,$19(A2)      ; TACR: Timer Start (Teiler: 1/10)
$l0: BTST    #5,$0B(A2)      ; time over?
(BEQ     l0
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
&END;
$END;
"END;
"WriteString ('Stop!');
"WriteLn;
"*)
"
"WriteLn;
"WriteString ('Init...');
"WriteLn;
"
"ASSEMBLER
(MOVEQ   #0,D0
(JSR     ALAP.Init;
"END;
"
"ALAP.NewPacketBuffer;
"ALAP.NewPacketBuffer;
"ALAP.NewPacketBuffer;
"ALAP.NewPacketBuffer;
"
"WriteString ('OK');
"WriteLn;
"
"rxIdx:= 0;
"redraw:= TRUE;
"quit:= FALSE;
"REPEAT
$IF redraw THEN
&GotoXY (4,0);
&WriteString (' interrupts');
&GotoXY (4,1);
&WriteString (' frames received');
&GotoXY (0,2);
&FOR n:= 0 TO 15 DO
(IF n IN ReadRegs THEN
*WriteString ('Reg '); WriteNum (n, 16, 1, '0'); WriteString (': '); WriteLn;
(END
&END;
&WriteString (VT52.Seq[clearEOS]);
&
&c:= 2;
&FOR n:= 0 TO 15 DO
(IF n IN ReadRegs THEN
*IF n IN RegsToDisplay THEN GotoXY (7,c); WriteReg (n) END;
*INC (c);
(END;
&END;
&
&GotoXY (0, 11);
&WriteString ('myAddress: '); WriteHex (LONG (ALAP.myAddress), 3);
&WriteString (', dest-Addr: '); WriteHex (outaddr, 3);
&GotoXY (0, 12);
&WriteString ('collsns:   , defers:');
&GotoXY (0, 13);
&WriteString ('RTS:   , CTS:   , Data:');
&redraw:= FALSE
$END;
$GotoXY (0,0);
$WriteCard (ALAP.Interrupts, 4);
$GotoXY (0,1);
$WriteCard (ALAP.FramesReceived, 4);
$GotoXY (8,12);
$WriteCard (ALAP.collsnCount,3);
$GotoXY (20,12);
$WriteCard (ALAP.deferCount,3);
$GotoXY (4,13);
$WriteCard (ALAP.RTSFramesOut,3);
$GotoXY (13,13);
$WriteCard (ALAP.CTSFramesOut,3);
$GotoXY (23,13);
$WriteCard (ALAP.DataFramesOut,3);
$
$ASSEMBLER MOVE SR,-(A7) ORI.W #$0700,SR END;
$IF ALAP.headPacket # ALAP.tailPacket THEN
&frameStatus:= ALAP.ReceiveFrame (packet);
&GotoXY (40, rxIdx);
&WriteCard (rxIdx, 2);
&INC (rxIdx);
&WriteString (': ');
&ALAP.WriteFrame (packet^, 5);
&InOut.WriteCard (packet^.no, 1); InOut.Write (' ');
&ALAP.WriteStatus (packet^.status);
$END;
$ASSEMBLER MOVE.W (A7)+,SR END;
$
$IF KeyPressed() THEN
&GotoXY (0,14);
&WriteString (VT52.Seq[clearEOS]);
&WriteLn;
&Read (ch); ch:= CAP (ch);
&IF ch = 'Q' THEN
(quit:= TRUE;
&ELSIF ch = 'T' THEN
(WriteLn;
(WriteString ('Transmitting...');
(WriteLn;
(
((*txStatus:= ALAP.TransmitPacket (outaddr, BYTE($10), dataParam, 0);*)
(WITH txFrame DO
*ctrl.srcAddr:= ALAP.myAddress;
*ctrl.dstAddr:= SHORT (outaddr);
*ctrl.lapType:= BYTE ($10);
*dataCnt:= 2;
*dataPtr:= ADR (dataParam);
*dataParam[1]:= BYTE ($12);
*dataParam[2]:= BYTE ($34);
(END;
(ASSEMBLER
*LEA   txFrame,A0
*JSR   ALAP.TransmitPacket
*MOVE  D0,txStatus
(END;
(
(ALAP.fAdrInUse:= FALSE;
(WriteString ('Status: ');
(CASE txStatus OF
(| ALAP.transmitOK: WriteString ('transmitOK')
(| ALAP.excessDefers: WriteString ('excessDefers')
(| ALAP.excessCollsns: WriteString ('excessCollsns')
(| ALAP.dupAddress: WriteString ('dupAddress')
(END;
(WriteLn;
&ELSIF ch = 'R' THEN
(WriteLn;
(WriteString ('Receiving...');
(WriteLn;
(ALAP.ReceivePacket (dstParam, srcParam, typeParam, dataParam, dataLength);
(IF InOut.KeyPressed () THEN
*WriteString ('Aborted');
*Read (ch)
(ELSE
*WriteString ('OK');
(END
&ELSIF ch = 'G' THEN
(WriteLn;
(WriteString ('Getting Addresses on Bus...');
(WriteLn;
(FOR n:= $01 TO $7F DO
*
*(*txStatus:= ALAP.TransmitPacket (SHORT(n), BYTE($81), dataParam, 0);*)
*WITH txFrame DO
,ctrl.srcAddr:= ALAP.myAddress;
,ctrl.dstAddr:= SHORT (n);
,ctrl.lapType:= ALAP.lapENQ;
,dataCnt:= 0
*END;
*ASSEMBLER
,LEA   txFrame,A0
,JSR   ALAP.TransmitPacket
,MOVE  D0,txStatus
*END;
*
*IF txStatus = ALAP.dupAddress THEN
,Write ('>'); WriteHex (n, 3); Write ('<'); WriteLn;
*END;
*ALAP.fAdrInUse:= FALSE;
(END;
(WriteLn;
(WriteString ('OK.');
(WriteLn;
&ELSIF ch = ' ' THEN
(WritePg;
(rxIdx:= 0;
(redraw:= TRUE
&ELSIF ch = 'I' THEN
(WriteString ('Address? ');
(ReadCard (myaddr);
(IF Done THEN
*ASSEMBLER
,MOVE  myaddr,D0
,JSR   ALAP.Init
*END
(END
&ELSIF ch = 'A' THEN
(WriteString ('Dest-Address? ');
(ReadCard (outaddr);
&ELSIF ch = '0' THEN
((*
*Test-Modus.
*sieht NUR mit Polling nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(ASSEMBLER MOVE SR,-(A7) ORI.W #$0500,SR END;
(LOOP
*frameStatus:= ALAP.ReceiveFrame (packet);
*IF frameStatus = ALAP.lapDATAframe THEN
,INC (rcvdDatas);
,WriteHex (LONG(packet^.frame.srcAddr),3);
,IF packet^.frame.lapType = BYTE ($11) THEN EXIT END;
*END;
(END;
(ASSEMBLER MOVE.W (A7)+,SR END;
(WriteLn;
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '1' THEN
((*
*Test-Modus.
*sieht mit Polling nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(LOOP
*frameStatus:= ALAP.ReceiveFrame (packet);
*IF frameStatus = ALAP.lapDATAframe THEN
,INC (rcvdDatas);
,WriteHex (LONG(packet^.frame.srcAddr),3);
,IF packet^.frame.lapType = BYTE ($11) THEN EXIT END;
*END;
*IF KeyPressed() THEN EXIT END;
(END;
(WriteLn;
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '2' THEN
((*
*Test-Modus.
*sieht NUR im Interrupt nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(LOOP
*ASSEMBLER MOVE SR,-(A7) ORI.W #$0700,SR END;
*WHILE ALAP.headPacket # ALAP.tailPacket DO
,frameStatus:= ALAP.ReceiveFrame (packet);
,IF frameStatus = ALAP.lapDATAframe THEN
.INC (rcvdDatas);
.WriteHex (LONG(packet^.frame.srcAddr),3);
.IF packet^.frame.lapType = BYTE ($11) THEN
0ASSEMBLER MOVE.W (A7)+,SR END;
0EXIT
.END;
,END;
*END;
*ASSEMBLER MOVE.W (A7)+,SR END;
*IF KeyPressed() THEN EXIT END;
(END;
(WriteLn;
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '3' THEN
((*
*Test-Modus.
*Jede Station sendet ununterbrochen;
*sieht jedesmal nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(sentDatas:= 0;
(sendTrials:= 0;
(WITH txFrame DO
*ctrl.srcAddr:= ALAP.myAddress;
*ctrl.dstAddr:= SHORT (outaddr);
*ctrl.lapType:= BYTE ($10);
*dataCnt:= 3;
*dataPtr:= ADR (dataParam);
*dataParam[1]:= BYTE ($12);
*dataParam[2]:= BYTE ($34);
*dataParam[3]:= BYTE ($56);
(END;
(LOOP
*ASSEMBLER LEA txFrame,A0 JSR ALAP.TransmitPacket MOVE D0,txStatus END;
*INC (sendTrials);
*IF ALAP.fAdrInUse THEN Write ('#'); ALAP.fAdrInUse:= FALSE; END;
*CASE txStatus OF
*| ALAP.transmitOK: Write ('.'); INC (sentDatas)
*| ALAP.excessDefers: Write ('+')
*| ALAP.excessCollsns: Write ('-')
*| ALAP.dupAddress:
*END;
*ASSEMBLER MOVE SR,-(A7) ORI.W #$0700,SR END;
*WHILE ALAP.headPacket # ALAP.tailPacket DO
,frameStatus:= ALAP.ReceiveFrame (packet);
,IF frameStatus = ALAP.lapDATAframe THEN
.INC (rcvdDatas);
.WriteHex (LONG(packet^.frame.srcAddr),3);
.IF packet^.frame.lapType = BYTE ($11) THEN EXIT END;
,END;
*END;
*ASSEMBLER MOVE.W (A7)+,SR END;
*IF KeyPressed() THEN EXIT END;
(END;
(WriteLn;
(WriteCard (sendTrials,0); WriteString (' frames tried to sent, ');
(WriteCard (sentDatas,0); WriteString (' frames sent, ');
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '4' THEN
((*
*Send Abort to all (Broadcast)
(*)
(WITH txFrame DO
*ctrl.srcAddr:= ALAP.myAddress;
*ctrl.dstAddr:= BYTE ($FF);
*ctrl.lapType:= BYTE ($11);
*dataCnt:= 0;
(END;
(ASSEMBLER LEA txFrame,A0 JSR ALAP.TransmitPacket MOVE D0,txStatus END;
&(*
&ELSIF (ch >= '0') & (ch <= '9') OR (ch >= 'A') & (ch <= 'F') THEN
(Write (10C); (* BS *)
(n:= ORD (ch) - ORD ('0'); IF n > 9 THEN DEC (n, 7) END;
(IF n IN WriteRegs THEN
*WriteString ('Write Reg '); WriteNum (n, 16, 1, '0');
*WriteString ('? ');
*ReadCard (c);
*IF Done & (c <= 255) THEN
,SCC.SetReg (n, c);
*ELSE
,WriteString ('No write!'); WriteLn
*END
(END
&*)
&END;
$END;
"UNTIL quit;
"ssp:= Super (ssp)
 END LANMonitor.
  
(* $FFF006F0$0000432B$00003D8D$FFF006F0$0000692A$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00008928$FFF006F0$00002C6C$FFF006F0$00000DC7$FFF006F0$00006E39$FFF006F0$00005DAA$00005CA8$00002600$00005833$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00003185$FFF006F0$00004EAE$FFF006F0$0000451D$FFF006F0$000013E6$00001C5B$FFF006F0$FFF006F0$00008854T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFF006F0$FFF006F0$00008FC0$FFF006F0$00008493$0000845F$00008660$000088B0$00008D88$0000849D$000088BE$000088A2$00008881$00008854$0000527C$0000656A*)
