 MODULE TimerA;
 (*$Z+,R-*)
 
 (*
!* Der MFP ist mit 2.4576 MHz getaktet.
!* Da "bitTime" 4.34s ist und das kleinste bentigte Delay 1.5*bitTime,
!* ergibt das genau 16 Timer-Zyklen. Diese sind ber einen Teiler von 4
!* oder 16 zu erreichen.
!*)
 
 (*$E MOS *) IMPORT TOSIO; FROM InOut IMPORT Write, WriteCard;
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM GEMDOS IMPORT Super;
 
 
 PROCEDURE Delay1Bit;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; Delay: 1.5 * bitTime (6.51s) = 16 Zyklen
(MOVEA.W #$FA00,A0
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #4,$1F(A0)      ; TADR: Set Timer Count
(MOVE.B  #1,$19(A0)      ; TACR: Timer Start (Teiler: 1/4)
%l: BTST    #5,$0B(A0)      ; IPRA
(BEQ     l
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
$END
"END Delay1Bit;
"(*$L=*)
 
 PROCEDURE Delay1Byte;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; Delay: 1.5 * byteTime (39s) = 58 Zyklen
(MOVEA.W #$FA00,A0
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #35,$1F(A0)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A0)      ; TACR: Timer Start (Teiler: 1/4)
%l: BTST    #5,$0B(A0)      ; IPRA
(BEQ     l
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
$END
"END Delay1Byte;
"(*$L=*)
 
 PROCEDURE DelayBytes (n: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(; Delay: n * 1.5 * byteTime (39s) = n * 58.5 Zyklen
(MOVE.W  -(A3),D0        ; n
(MOVEA.W #$FA00,A0
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #36,$1F(A0)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A0)      ; TACR: Timer Start (Teiler: 1/4)
(BRA     s
%l: BTST    #5,$0B(A0)      ; IPRA
(BEQ     l
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
%s: DBRA    D0,l
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
$END
"END DelayBytes;
"(*$L=*)
 
 PROCEDURE Delay (teiler, count: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVEA.W #$FA00,A0
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.W  -(A3),D0
(MOVE.W  -(A3),D1
(MOVE.B  D0,$1F(A0)      ; TADR: Set Timer Count
(MOVE.B  D1,$19(A0)      ; TACR: Timer Start
%l: BTST    #5,$0B(A0)      ; IPRA
(BEQ     l
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
$END
"END Delay;
"(*$L=*)
 
 PROCEDURE Start (teiler, count: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVEA.W #$FA00,A0
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.W  -(A3),D0
(MOVE.W  -(A3),D1
(MOVE.B  D0,$1F(A0)      ; TADR: Set Timer Count
(MOVE.B  D1,$19(A0)      ; TACR: Timer Start
%l: END
"END Start;
"(*$L=*)
 
 PROCEDURE Stop;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.B  #$00,$FFFA19    ; TACR: Timer Stop
$END
"END Stop;
"(*$L=*)
 
 PROCEDURE Down (): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
(BTST    #5,$FFFA0B      ; IPRA
(BEQ     no
(BCLR    #5,$FFFA0B      ; IPRA: Clear Timer-A Pending Bit
(MOVEQ   #1,D0
(RTS
$no: CLR     D0
$END
"END Down;
"(*$L=*)
 
 (* nur mit dieser optimierten Schleife sind auf dem Mega STE die
!* 1.5*bitTime zu messen:
"Start (1,4);
"ASSEMBLER
(MOVE.L  n,D1
(MOVE.L  l,D0
(MOVEQ   #5,D2
(LEA     $FFFA0B,A0
$lo: BTST    D2,(A0)         ; IPRA
(BEQ     lo
(BCLR    D2,(A0)         ; IPRA: Clear Timer-A Pending Bit
(ADDQ.L  #1,D1
(CMP.L   hz200,D0
(BHI     lo
(MOVE.L  D1,n
"END;
 *)
 
 PROCEDURE Init;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVEA.W #$FA00,A0
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
(ANDI.B  #$DF,$13(A0)    ; IMRA: Mask Timer A IR
(ORI.B   #$20,$07(A0)    ; IERA: Enable Timer-A Pending Bit
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
$END
"END Init;
 
 VAR n, l, hz200[$4BA]: LONGCARD;
$sr: CARDINAL;
$ssp: LONGINT;
 
 BEGIN
"ssp:= Super (0);
"Init;
"n:= 0;
"ASSEMBLER MOVE SR,sr MOVE #$2500,SR END;
"l:= hz200 + 200; (* 1s *)
"(*
"Start (1,4);
"REPEAT
$IF Down () THEN
&INC (n);
$END;
"UNTIL hz200 >= l;
"*)
"Stop;
"ASSEMBLER MOVE sr,SR END;
"WriteCard (n, 0);
"ssp:= Super (ssp)
 END TimerA.
 
(* $FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00000DF3T.......T.......T.......T.......TT......T.......T.......T.......T.......T.......$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00000EC0$FFF006F0$00000DF3$FFF006F0$FFF006F0$FFF006F0*)
