 IMPLEMENTATION MODULE Calls; (* V#055 *)
 (*$Y+,L-,C-,H+*)
 
 (*
"24.5.88: Stack bei CallSuperVisor mu nun 128 statt 512 Byte gro sein.
"29.8.88: Wirkung v. SysNewCaller und NewCaller war vertauscht; Funktionen
+nun lauffhig.
"26.7.89: Sys/NewCaller legen Entry-Prg im wsp ab - nun kein ALLOCATE mehr
+ntig
"10.5.90: CallExternal & CallSystem entfernt
"13.6.90: EnterSupervisorMode-Aufrufe raus
"24.10.90: $H+ eingebaut
"21.11.90: Korrektur bei NewCaller (Stack-Pointer und Call-Adr. wurden wg.
,Entfernung von $M- nicht mehr an die richtige Adr. gesetzt).
 *)
 
 FROM SYSTEM IMPORT LONGWORD, ASSEMBLER, ADDRESS;
 
 FROM MOSGlobals IMPORT OutOfStack, MemArea;
 
 (*
 PROCEDURE CallExternal ( func: ADDRESS ): LONGWORD;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0        ; Adr. der aufzurufenden Funktion
(MOVE.L  (A7)+,(A3)+     ; Rcksprungadr. auf anderen Stack retten
(MOVE.L  (A7)+,(A3)+     ; gerettetes A6
(JSR     (A0)
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A3)+
(JMP     (A0)            ; Zurck zum Aufrufer
$END
"END CallExternal;
 *)
 
 PROCEDURE CallExtRegs ( pro: ADDRESS; VAR regs: Registers );
 BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  -(A3),A1        ; Adr. der aufzurufenden Funktion
(MOVEM.L D3-D7/A3-A6,-(A7)
(MOVE.L  A0,-(A7)
(PEA     ret(PC)
(PEA     (A1)
(MOVEM.L (A0),D0-A6
(RTS
&ret:
(MOVE.L  A6,-(A7)
(MOVE.L  4(A7),A6
(MOVEM.L D0-A5,(A6)
(MOVE.L  (A7)+,56(A6)
(ADDQ.L  #4,A7
(MOVEM.L (A7)+,D3-D7/A3-A6
$END
"END CallExtRegs;
 
 
 (*
 VAR trapHelp: RECORD
0t1:CARDINAL; (* TRAP    #n                               *)
0t2:CARDINAL; (* ADDQ.L  #2,A7      ; Funktionsnr. runter *)
0t3:CARDINAL; (* MOVE.L  -(A3),-(A7); gerettetes A6       *)
0t5:CARDINAL; (* MOVE.L  -(A3),A0   ; Rcksprungadr.      *)
0t6:CARDINAL; (* MOVE.L  D0,(A3)+   ; Ergebnis auf Stack  *)
0t7:CARDINAL  (* JMP     (A0)                             *)
.END;
.
 PROCEDURE CallSystem ( trapNo, func:CARDINAL ): LONGWORD;
"BEGIN
$ASSEMBLER
(MOVEM.L (A7)+,D0/D2     ; Rcksprungadr. + gerettetes A6 laden
(MOVE.W  -(A3),-(A7)
(MOVE.W  -(A3),D1
(ORI     #$4E40,D1       ; TRAP #0
(LEA     trapHelp,A0
(MOVE.W  D1,(A0)         ; TRAP-Instr. setzen
(MOVEM.L D0/D2,(A3)      ; Rcksprungadr. auf anderen Stack retten
(ADDQ.L  #8,A3
(JMP     (A0)
$END
"END CallSystem;
 *)
 
 PROCEDURE CallProc ( func: AddrProc; p: ADDRESS; REF workSpace: MemArea );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0        ; workSpace
(MOVE.L  -(A3),A2        ; p
(MOVE.L  -(A3),D2        ; StatLink ('func')
(MOVE.L  -(A3),A1        ; ADR ('func')
(
(; Stack anlegen
(MOVE.L  A3,-(A7)                ; A3 retten
(MOVE.L  A7,D1                   ; alten SP laden zum Retten
(
(TST.L   MemArea.bottom(A0)      ; neuen SP-Bottom
(BEQ     stckerr                 ; Fehler
(MOVE.L  MemArea.length(A0),D0
(BEQ     stckerr                 ; Fehler
(
(CMPI.L  #16,D0          ; Den Rest checkt die aufzurufende Prozedur
(BCS     stckerr
(
(; neuen SP verwenden
(MOVE.L  MemArea.bottom(A0),A3
(ADD.L   MemArea.bottom(A0),D0
(MOVE.L  D0,A7
(
&useOld
(; para auf Stack
(MOVE.L  A2,(A3)+
(
(MOVE.L  D1,-(A7)                ; alten SP retten
(
(; Funktion aufrufen
(JSR     (A1)                    ; static link steht schon in D2
(
(MOVE.L  (A7)+,A7
(MOVE.L  (A7)+,A3
(RTS
(
&stckerr:
(TRAP    #6
(DC.W    OutOfStack      ; continue erlaubt
(BRA     useOld
$END
"END CallProc;
 
 PROCEDURE CallSupervisor ( proc: AddrProc; data: ADDRESS; REF wsp: MemArea );
"BEGIN
$ASSEMBLER
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  A7,USP
(MOVE.L  D0,A7
(
(MOVE.L  -(A3),A2        ; workSpace
(MOVE.L  -(A3),D1        ; para
(MOVE.L  -(A3),D2        ; StatLink ('func')
(MOVE.L  -(A3),A1        ; Funktionsadr.
(
(MOVE.L  A3,-(A7)
(
(; Stack anlegen
(MOVE.L  A7,A0                   ; alten SSP laden zum Retten
(MOVE.L  USP,A7                  ; USP ist default-SP
(
(TST.L   MemArea.bottom(A2)      ; neuen SP-Bottom
(BEQ     useOld
(MOVE.L  MemArea.length(A2),D0
(BEQ     useOld
(
(CMPI.L  #128,D0          ; Mu schon da sein fr evtl. Interrupts
(BCS     stckerr
(
(; neuen SP verwenden
(MOVE.L  MemArea.bottom(A0),A3
(ADD.L   MemArea.bottom(A0),D0
(MOVE.L  D0,A7
(
&useOld:
(; para auf Stack
(MOVE.L  D1,(A3)+
(
(MOVE.L  A0,-(A7)                ; alten SP retten
(
(; Funktion aufrufen
(JSR     (A1)                    ; static link steht schon in D2
(
(MOVE.L  (A7)+,A7                ; alten SSP wiederherstellen
(MOVE.L  (A7)+,A3
(
(ANDI    #$CFFF,SR
(RTS
(
&stckerr:
(TRAP    #6
(DC.W    OutOfStack      ; continue erlaubt
(BRA     useOld
$END
"END CallSupervisor;
 
 
 PROCEDURE hdlCaller1;
"BEGIN
$ASSEMBLER
(PEA     (A6)            ; A6 auf Stack
(LEA     regs(PC),A6     ; Adr f. zu rettende Regs D0-A7
(MOVEM.L D0-A5,(A6)      ; regs D0-A5 retten
(MOVE.L  (A7)+,Registers.regA6(A6) ; A6 von Stack retten
(MOVE.L  A7,A4           ; SP merken
(LEA     $F1210000,A3    ; neuen Stack laden
(LEA     $F1210000,A7
(LEA     4(A4),A0
(MOVE.L  A0,Registers.parm(A6) ; alten SP als A7 merken
(MOVE.L  A6,(A3)+
(; SUBA.L  A5,A5           ; LINK-^ lschen (f. Error-Scanner)
(JSR     $F1210000
(MOVE.L  A4,A7           ; alten SP zurck
(MOVEM.L (A6),D0-A6
(RTS
&regs:
(DS      64
$END
"END hdlCaller1;
 
 PROCEDURE hdlCaller1E; END hdlCaller1E;
 
 PROCEDURE hdlCaller2; (* fr Supervisormode -> Usermode *)
"BEGIN
$ASSEMBLER
(PEA     (A6)            ; A6 auf Stack
(LEA     regs(PC),A6
(MOVEM.L D0-A5,(A6)
(MOVE.L  (A7)+,Registers.regA6(A6)
(MOVE.L  A7,A4           ; alter SSP
(MOVE.L  USP,A5          ; alter USP
(
(ANDI    #$CFFF,SR       ; User Mode
(LEA     $F1210000,A3    ; neuen Stack laden
(LEA     $F1210000,A7
(LEA     4(A4),A0
(MOVE.L  A0,Registers.parm(A6)
(MOVE.L  A6,(A3)+
(JSR     $F1210000
(
(; zurck in den Supervisor-Mode
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(
(MOVE.L  A5,USP
(MOVE.L  A4,A7           ; alten SSP zurck
(
(MOVEM.L (A6),D0-A6
(RTS
&regs:
(DS      64
$END
"END hdlCaller2;
 
 PROCEDURE hdlCaller2E; END hdlCaller2E;
 
 (*$H-*)
 PROCEDURE NewCaller (     m2Proc       : RegsProc;
:enterUserMode: BOOLEAN;
:wsp          : MemArea;
6VAR entry        : ADDRESS );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)     ; ADR (entry)
(MOVE.L  -(A3),D2        ; wsp.length
(MOVE.L  -(A3),A0        ; wsp.bottom
(MOVE.W  -(A3),D0        ; enterUserMode
(MOVE.L  -(A3),-(A7)     ; m2Proc
 
(MOVE.L  4(A7),A1
(CLR.L   (A1)            ; entry:= NIL
 
(TST.W   D0
(BEQ     noEnter
(LEA     hdlCaller2,A1   ; p1
(LEA     hdlCaller2E,A2  ; p2
(BRA     entCont
&noEnter
(LEA     hdlCaller1,A1
(LEA     hdlCaller1E,A2
&entCont
 
(MOVE.L  A2,D0
(SUB.L   A1,D0           ; l: Lnge der Eintrittsprozedur
 
(MOVE.L  A0,D1           ; wsp.bottom
(BEQ     noStack
(MOVE.L  D0,D1           ; l
(ADDI.L  #512,D1
(CMP.L   D1,D2           ; l, wsp.length
(BCS     noStack
 
(MOVE.L  A0,-(A7)
&l0:
(MOVE.W  (A1)+,(A0)+     ; (p1)+ -> (wsp.bottom)+
(CMPA.L  A2,A1
(BCS     l0
(MOVE.L  (A7)+,D0        ; wsp.bottom
 
(MOVE.L  4(A7),A1
(MOVE.L  D0,(A1)         ; entry:= wsp.bottom
 
(; Jetzt suchen wir nach Kennungen, wo Adressen nachzutragen sind.
(MOVE.L  D0,A1           ; wsp.bottom
#sea1 CMPI.W  #$F121,(A1)+
(BNE     sea1
(MOVE.L  A0,-2(A1)       ; wsp.bottom+l -> stcklo
#sea2 CMPI.W  #$F121,(A1)+
(BNE     sea2
(ADD.L   D0,D2
(MOVE.L  D2,-2(A1)       ; wsp.bottom+wsp.length -> stckhi
#sea3 CMPI.W  #$F121,(A1)+
(BNE     sea3
(MOVE.L  (A7),-2(A1)     ; call
(BRA     ende
 
&noStack
(TRAP    #6
(DC.W    OutOfStack      ; continue erlaubt
&ende
(ADDQ.L  #8,A7
$END;
$(*
(IF enterUserMode THEN
*p1:= ADDRESS (hdlCaller2);
*p2:= ADDRESS (hdlCaller2E)
(ELSE
*p1:= ADDRESS (hdlCaller1);
*p2:= ADDRESS (hdlCaller1E)
(END;
(l:=p2-p1;
(IF l+512L > wsp.length THEN
*ASSEMBLER
,TRAP    #6
,DC.W    OutOfStack      ; continue erlaubt
*END
(END;
(entry:= wsp.bottom;
(IF entry # NIL THEN
*ASSEMBLER
,MOVE.L  p1(A6),A0
,MOVE.L  entry(A6),A1
,MOVE.L  (A1),A1
,MOVE.L  p2(A6),A2
*l0:
,MOVE.W  (A0)+,(A1)+
,CMPA.L  A2,A0
,BCS     l0
*END;
*p3:= entry + l - 14L;
*p3^:= entry + l;
*INC (p3,4);
*p3^:= entry+wsp.length;
*INC (p3,4);
*p3^:= ADDRESS(m2Proc)
(END
$*)
"END NewCaller;
 
 PROCEDURE SysNewCaller ( m2Proc: RegsProc; enterUserMode: BOOLEAN; wsp: MemArea; VAR entry: ADDRESS );
"BEGIN
$ASSEMBLER
(JMP     NewCaller
$END
"END SysNewCaller;
 
 PROCEDURE DisposeCaller ( VAR entry: ADDRESS );
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A3
$END
"END DisposeCaller;
 
 BEGIN
"(*
$trapHelp.t2:= $548F; (* ADDQ.L  #2,A7 *)
$trapHelp.t3:= $2F23; (* MOVE.L  -(A3),-(A7) *)
$trapHelp.t5:= $2063; (* MOVE.L  -(A3),A0 *)
$trapHelp.t6:= $26C0; (* MOVE.L  D0,(A3)+ *)
$trapHelp.t7:= $4ED0; (* JMP     (A0) *)
"*)
 END Calls.
 
(* $FFFA9A0B$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$00002113$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$FFFC277D$000014DAT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001DB1$00001E08$00001E53$000014DA$000014C5$00001DE7$00001CEA$00001492$00001713$00001CD8$00001DE7$00001D71$00001D36$00001D71$00001D33$00001DD5*)
