 IMPLEMENTATION MODULE EasyExceptions;
 (*$Y+,R-,H+*)
 
 (*
!* Laufzeitfehler-Behandlung fr Megamax Modula-2
!* Programmiert von Thomas Tempelmann nach einem Vorschlag von K. John Gough
!*
!* 24.09.90: installiert nun auch bei residenten Modulen den Handler neu,
!*           falls er durch's Deinit schon wieder entfernt wurde.
!* 01.03.90: Aufgerumt
!* 05.07.89: IllegalCall nun als eigener Fehler
!*)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADR;
 FROM HdlError IMPORT ReleaseCatcher, GetErrorMsg, SysCatchErrors;
 FROM ErrBase IMPORT RaiseError, ErrResp, RtnCond;
 FROM SysTypes IMPORT ExcDesc;
 FROM PrgCtrl IMPORT Accessory, CatchProcessTerm, TermCarrier;
 IMPORT MOSGlobals;
 FROM SysBuffers IMPORT HdlErrorStack;
 FROM SysUtil2 IMPORT JumpBuf, SetJump, LongJump;
 FROM SystemError IMPORT OutOfMemory;
 
 TYPE Exception = LONGINT;
 
%PtrContext = POINTER TO Context;
%Context = RECORD
1prev: PtrContext;
1buf: JumpBuf;
/END;
 
 VAR ID: INTEGER;
$installed: BOOLEAN;
$jmpPtr: PtrContext;
$normalReturn: Exception;
$wsp: MOSGlobals.MemArea;
 
 
 PROCEDURE catch (errNo: INTEGER; msg: ARRAY OF CHAR; causer: ErrResp;
1cont: RtnCond; VAR excData: ExcDesc ): BOOLEAN;
"VAR tmp: PtrContext;
"BEGIN
$IF (jmpPtr # NIL) & (errNo # MOSGlobals.UserBreak) THEN
&LongJump (jmpPtr^.buf, errNo);
$END;
$RETURN TRUE (* Diese Fehler werden nicht durch dies Modul behandelt *)
"END catch;
 
 
 PROCEDURE install (): BOOLEAN;
"BEGIN
$RETURN SysCatchErrors (catch, wsp)
"END install;
 
 PROCEDURE release;
"BEGIN
$installed:= FALSE;
$ReleaseCatcher (catch)
"END release;
 
 
 PROCEDURE Call (p: PROC; VAR result: Exception);
"VAR res: INTEGER; con: Context;
"BEGIN
$IF ~installed THEN
&IF ~install () THEN
(result:= MOSGlobals.OutOfMemory;
(RETURN
&END
$END;
$con.prev:= jmpPtr;
$jmpPtr:= ADR (con);
$res:= SetJump (jmpPtr^.buf);
$IF res = 0 THEN
&p;
&result:= normalReturn
$ELSE
&result:= res
$END;
$jmpPtr:= jmpPtr^.prev;
$IF ~installed THEN release END
"END Call;
 
 
 PROCEDURE Raise (reason: Exception);
"BEGIN
$RaiseError (SHORT (reason), '', callerCaused, mayContinue)
"END Raise;
 
 PROCEDURE New (VAR id: Exception);
"BEGIN
$id:= ID;
$INC (ID);
$IF ID > MAX (INTEGER) THEN
&ID:= 2
$END
"END New;
 
 PROCEDURE StdErrNo (id: Exception): INTEGER;
"BEGIN
$IF id = normalReturn THEN
&RETURN 0
$ELSE
&RETURN SHORT (id)
$END
"END StdErrNo;
 
 PROCEDURE NormalReturn ()  : Exception;
"BEGIN RETURN normalReturn END NormalReturn;
 
 PROCEDURE RealValueError ()  : Exception;
"BEGIN RETURN MOSGlobals.GenFPErr END RealValueError;
 
 PROCEDURE CaseSelectError () : Exception;
"BEGIN RETURN MOSGlobals.CaseSelectErr END CaseSelectError;
 
 PROCEDURE StringOverflow ()  : Exception;
"BEGIN RETURN MOSGlobals.StringOverflow END StringOverflow;
 
 PROCEDURE RangeError ()    : Exception;
"BEGIN RETURN MOSGlobals.OutOfRange END RangeError;
 
 PROCEDURE Overflow ()      : Exception;
"BEGIN RETURN MOSGlobals.Overflow END Overflow;
 
 PROCEDURE DivByZero ()     : Exception;
"BEGIN RETURN MOSGlobals.DivByZero END DivByZero;
 
 PROCEDURE StackOverflow () : Exception;
"BEGIN RETURN MOSGlobals.OutOfStack END StackOverflow;
 
 PROCEDURE StorageError ()  : Exception;
"BEGIN RETURN MOSGlobals.OutOfMemory END StorageError;
 
 PROCEDURE IOError ()       : Exception;
"BEGIN RETURN MOSGlobals.FileSystemErr END IOError;
 
 
 VAR termHdl: TermCarrier;
 
 BEGIN
"jmpPtr:= NIL;
"ID:= 1; (* ID darf nicht Null sein! *)
"New (normalReturn);
"wsp.bottom:= ADR (HdlErrorStack);
"wsp.length:= SIZE (HdlErrorStack);
"IF NOT Accessory () THEN
$(* damit ganz normal bei Prozeende der
%* SysCatchErrors wieder freigegeben wird: *)
$CatchProcessTerm (termHdl, release, wsp);
$IF NOT install () THEN
&OutOfMemory
$END;
$installed:= TRUE
"END;
 END EasyExceptions.
 
(* $FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$00000EDB$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$FFEF7B70$00000EDBT.......T.....T.T.......T.......T.......T.......T.......T.......T.......T.......$0000033B$0000032C$00000337$000005B0$000005C3$000005E1$000006C9$0000070A$FFE67A63$00000C9D$00000EDB$00000033$000005A1$00000ED0$00000EF3$00000EE2*)
