 IMPLEMENTATION MODULE HdlError; (* V#062 *)
 (*$Y+,R-,M-*)
 
 (*
!* Wenn ein Fehler nicht abgefangen wird, wird das Programm sofort mit
!* der Fehlernummer als Exitcode beendet.
!*
!* 25.11.90 TT  Um vorige Abfrage richtig zu machen (f. ModLoad), wird nun
!*              'Accessory' aus MOSCtrl statt der Funktion aus PrgCtrl
!*              abgefragt, weil PrgCtrl den akt. Status, MOSCtrl den Status
!*              des Base-Prozesses liefert.
!* 01.03.90 TT  In ACCs werden Exceptions nicht automatisch installiert
!* 17.06.89 TT  Undefinierte Fehlernummern bei GetErrorMsg werden nicht mehr
!*              abgeschnitten.
!* 25.10.88 TT  CatchRemoval-Aufruf
!* 01.09.88 TT  Sys-Funktion meldet nicht autom. ab, ebenso bleibt ErrHdl-
!*              Vektor erhalten, wenn bei Prozeende nicht alle Catcher
!*              abgemeldet sind.
!*)
 
 FROM SYSTEM IMPORT ADR,ADDRESS,BYTE,LONGWORD,TSIZE, WORD, ASSEMBLER;
 
 FROM PrgCtrl IMPORT CatchProcessTerm, SetEnvelope, TermProcess,
(TermCarrier, EnvlpCarrier;
 
 FROM MOSCtrl IMPORT BaseIsAccessory;
 
 FROM SystemError IMPORT OutOfMemory;
 
 FROM ResCtrl IMPORT RemovalCarrier, CatchRemoval;
 
 FROM MOSGlobals IMPORT MemArea;
 
 FROM MOSConfig IMPORT RuntimeErrMsg;
 
 FROM Storage IMPORT SysAlloc, DEALLOCATE;
 
 FROM SysTypes IMPORT ExcDesc;
 
 FROM ErrBase IMPORT ErrResp, RtnCond, ErrHdl, ErrHdlProc, ExcInstalled,
0InstallExc, RemoveExc;
 
 FROM Lists IMPORT SysCreateList, DeleteList, NextEntry, LCarrier, LDir,
(PrevEntry, AppendEntry, ResetList, List, ScanEntries, RemoveEntry,
(ListEmpty, CurrentEntry, EndOfList;
 
 FROM StrConv IMPORT IntToStr;
 
 FROM Strings IMPORT Assign, Pos, Delete, Insert;
 
 (*
 TYPE    ErrProc = PROCEDURE (     (* errNo:   *) INTEGER,
B(* msg:     *) ARRAY OF CHAR,
B(* causer:  *) ErrResp,
B(* cont:    *) RtnCond,
>VAR (* excData: *) ExcDesc ): BOOLEAN;
 *)
 
 TYPE ProcList  = POINTER TO ProcField;
%ProcField = RECORD
3call : ErrProc;
3stck : MemArea;
3level: INTEGER;
1END;
 
 VAR ErrProcs: List;
$oldHdl: ErrHdlProc;
$Level: INTEGER;
 
 PROCEDURE findProc ( p0,info:ADDRESS ):BOOLEAN;
"VAR p: ProcList;
"BEGIN
$p:=p0;
$RETURN ADDRESS(p^.call) = info;
"END findProc;
 
 PROCEDURE install ( call:ErrProc; workSpace:MemArea; level:INTEGER ): BOOLEAN;
"VAR p: ProcList;
&err: BOOLEAN;
"BEGIN
$IF (workSpace.bottom#NIL) & (workSpace.length>=50L) THEN
&ResetList (ErrProcs);
&ScanEntries (ErrProcs,forward,findProc,ADDRESS(call),err);
&IF err THEN (* gefunden *) RETURN TRUE END;
&SysAlloc (p,SIZE(p^));
&IF p#NIL THEN
(AppendEntry (ErrProcs,p,err);
(IF err THEN
*DISPOSE (p)
(ELSE
*p^.call := call;
*p^.level:= level;
*p^.stck := workSpace;
*InstallExc;
*RETURN ExcInstalled
(END
&END
$END;
$RETURN FALSE
"END install;
 
 PROCEDURE SysCatchErrors ( call: ErrProc; workSpace: MemArea ): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; RETURN install (call,workSpace,0)
(MOVE    #-1,(A3)+
(JMP     install
$END
"END SysCatchErrors;
"(*$L=*)
 
 PROCEDURE CatchErrors ( call: ErrProc; workSpace: MemArea ): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; RETURN install (call,workSpace,Level)
(MOVE    Level,(A3)+
(JMP     install
$END
"END CatchErrors;
"(*$L=*)
 
 
 PROCEDURE ReleaseCatcher ( call: ErrProc );
"VAR p: ProcList; fnd:BOOLEAN;
"BEGIN
$ResetList (ErrProcs);
$ScanEntries (ErrProcs,forward,findProc,ADDRESS(call),fnd);
$IF fnd THEN (* gefunden *)
&p:= CurrentEntry (ErrProcs);
&DISPOSE (p);
&RemoveEntry (ErrProcs,fnd);
$END;
$IF BaseIsAccessory & ListEmpty (ErrProcs) THEN
&RemoveExc
$END
"END ReleaseCatcher;
 
 
 PROCEDURE getSt2 (ad:ADDRESS; n:INTEGER; VAR msg:ARRAY OF CHAR): BOOLEAN;
"VAR s: POINTER TO ARRAY [0..31] OF CHAR; ok:BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  ad(A6),A0
(MOVE.W  n(A6),D0
(
%l: CMP.W   (A0)+,D0
(BNE     c
(
(; gefunden
(MOVE.L  A0,s(A6)
(BRA     e
(
%c: TST.B   (A0)    ; Listenende ?
(BEQ     f       ; Ja, -> nicht gefunden
(
%m: ADDA.W  #32,A0
(BRA     l
(
%f: CLR.L   s(A6)
%e:
$END;
$IF s#NIL THEN
&Assign (s^,msg,ok);
&RETURN TRUE
$ELSE
&RETURN FALSE
$END
"END getSt2;
 
 PROCEDURE GetErrorMsg ( n: INTEGER; VAR msg: ARRAY OF CHAR );
"VAR p:INTEGER; m:POINTER TO RECORD no:INTEGER; t:ARRAY [0..31] OF CHAR END;
$ok:BOOLEAN;
"BEGIN
$msg[0]:=0C;
$IF RuntimeErrMsg=NIL THEN
&Assign ('Error #@',msg,ok)
$ELSE
&IF ~getSt2 (RuntimeErrMsg,n,msg) THEN
(m:=RuntimeErrMsg;
(Assign (m^.t,msg,ok)
&END
$END;
$p:=Pos ('@',msg,0);
$IF p>=0 THEN
&Delete (msg,p,1,ok);
&Insert (IntToStr(n,0),p,msg,ok)
$END
"END GetErrorMsg;
 
 
 PROCEDURE catch (no: INTEGER; msg: ARRAY OF CHAR; causer: ErrResp;
1cont: RtnCond; VAR info: ExcDesc);
"
"VAR ret: BOOLEAN;
"
"PROCEDURE callSub ( subRoutine: ErrProc; VAR wsp: MemArea );
$(*$L-*)
$BEGIN
&ASSEMBLER
*MOVE.L  -(A3),A0                ; ^wsp
*MOVE.L  -(A3),A1                ; subRoutine
*
*MOVE.L  A3,-(A7)                ; A3 retten
*MOVE.L  A7,D1                   ; alten SP laden zum Retten
*
*MOVE.L  MemArea.bottom(A0),A3   ; neuen SP-Bottom
*MOVE.L  A3,A7
*ADDA.L  MemArea.length(A0),A7
*
*; Parameter draufschaufeln
*MOVE    no(A6),(A3)+
*MOVE.L  msg(A6),(A3)+
*MOVE    msg+4(A6),(A3)+
*MOVE    causer(A6),(A3)+
*MOVE    cont(A6),(A3)+
*MOVE.L  info(A6),(A3)+
*
*MOVE.L  D1,-(A7)                ; alten SP retten
*JSR     (A1)
*MOVE    -(A3),D0
*EORI    #1,D0
*MOVE    D0,ret(A6)
*MOVE.L  (A7)+,A7
*MOVE.L  (A7)+,A3
&END
$END callSub;
$(*$L+*)
$
"VAR p: ProcList;
"BEGIN
$ResetList (ErrProcs);
$REPEAT
&p:= PrevEntry (ErrProcs);
&IF p=NIL THEN TermProcess (no) END;
&callSub (p^.call (*no,msg,causer,cont,info*), p^.stck );
$UNTIL ret
"END catch;
 
 
 PROCEDURE tstLevel ( p0,info:ADDRESS ):BOOLEAN;
"VAR p: ProcList;
"BEGIN
$p:=p0;
$RETURN p^.level >= Level
"END tstLevel;
 
 PROCEDURE ReleaseLevel;
"VAR p: ProcList; fnd:BOOLEAN;
"BEGIN
$ResetList (ErrProcs);
$REPEAT
&ScanEntries (ErrProcs,forward,tstLevel,NIL,fnd);
&IF fnd THEN (* gefunden *)
(p:= CurrentEntry (ErrProcs);
(DISPOSE (p);
(RemoveEntry (ErrProcs,fnd);
&END
$UNTIL EndOfList (ErrProcs);
$IF BaseIsAccessory & ListEmpty (ErrProcs) THEN
&RemoveExc
$END
"END ReleaseLevel;
 
 PROCEDURE ChgLevel ( start: BOOLEAN; inChild:BOOLEAN; VAR exitCode:INTEGER );
"BEGIN
$IF inChild THEN
&IF start THEN
(INC (Level);
&ELSE
(ReleaseLevel;
(DEC (Level)
&END
$END
"END ChgLevel;
 
 PROCEDURE freeSys;
"VAR ok: BOOLEAN;
"BEGIN
$Level:= MinInt;
$ReleaseLevel;
$DeleteList (ErrProcs, ok);
$ErrHdl:= oldHdl
"END freeSys;
 
 VAR err:BOOLEAN;
$wsp: MemArea;
$rHdl: RemovalCarrier;
$termHdl: TermCarrier;
$envHdl: EnvlpCarrier;
 
 BEGIN
"Level:=0;
"wsp.bottom:=NIL;
"SysCreateList (ErrProcs, err);
"IF err THEN OutOfMemory END;
"oldHdl:= ErrHdl;
"ErrHdl:= catch;
"SetEnvelope (envHdl,ChgLevel,wsp);
"CatchProcessTerm (termHdl,ReleaseLevel,wsp);
"CatchRemoval (rHdl,freeSys,wsp);
"IF NOT BaseIsAccessory THEN
$InstallExc;
$IF NOT ExcInstalled THEN
&OutOfMemory
$END
"END
 END HdlError.
 
(* $FFF2E42F$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$00000B61$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$FFFA7DF8$000001CAT.......T.......T.......T...T...T.......T.......T.......T.......T.......T.......$00000DE7$00000360$000001CD$000000C6$000001CA$FFEAC45A$000001CA$0000042E$00000DE7$00001828$00001B57$FFEA4FD0$00001831$00000DE7$00001831$00001B4A*)
