 
 IMPLEMENTATION MODULE LibFiles;
 (*$Y+,R-,H+*)
 
 (*
"TT 20.08.89 Kennungs-String nun 0-terminiert
"TT 24.10.90 userData hinzugefgt
"TT 03.11.90 find korrigiert: LookUp funktioniert endlich, AddFile erkennt
0doppelte Datei
 *)
 
 FROM Files IMPORT File;
 IMPORT Files, MOSGlobals, Binary;
 FROM Directory IMPORT FileAttrSet;
 FROM FileNames IMPORT SplitPath;
 FROM Storage IMPORT ALLOCATE, DEALLOCATE, MemAvail;
 FROM SYSTEM IMPORT ASSEMBLER, TSIZE, ADR, ADDRESS, BYTE;
 FROM Strings IMPORT Upper, StrEqual;
 FROM SysUtil0 IMPORT CopyVar, ClearVar;
 
 (*
 TYPE    LibFile = RECORD
4f: File;
4private: ADDRESS
2END;
 
(LibEntry = RECORD
5name: ARRAY [0..11] OF CHAR;
5attr: FileAttrSet;
5time: CARDINAL; (* gepacktes Format! *)
5date: CARDINAL; (* gepacktes Format! *)
5size: LONGCARD;
5start: LONGCARD
3END;
 
(LibQueryProc = PROCEDURE ( (* entry: *) LibEntry ): BOOLEAN;
 *)
 
 TYPE
(DirBuffer = POINTER TO RECORD
6n: CARDINAL;
6d: ARRAY [1..2000] OF LibEntry;
4END;
 
(LibHead = RECORD
4str: ARRAY [0..7] OF CHAR;
4layout: CARDINAL;
4fileSize: LONGCARD;
4start: LONGCARD;
4entries: CARDINAL;
4userData: UserData;
2END;
 
 CONST
(DBLen = 2L;  (* Gre v. DirBuffer ohne 'd'-Array *)
 
 VAR glob_di: LibHead;
 
 PROCEDURE open ( VAR handle: LibFile; REF libraryName: ARRAY OF CHAR;
1VAR reply: INTEGER; mode: Files.Access; loaddir: BOOLEAN );
 
"VAR len, read: LONGCARD;
&cmp: ARRAY [0..5] OF CHAR;
&dir: DirBuffer;
 
"PROCEDURE ok (): BOOLEAN;
$BEGIN
&RETURN Files.State ( handle.f ) >= 0
$END ok;
 
"BEGIN
$handle.private:= NIL;
$Files.Open ( handle.f, libraryName, mode );
$IF ok() THEN
&Binary.ReadBlock ( handle.f, glob_di );
&IF ok() THEN
(cmp:= 'MM2Lib';
(IF ~ StrEqual ( cmp, glob_di.str ) OR ( glob_di.layout # $1A01 ) THEN
*reply:= MOSGlobals.fBadOp;
*Files.Close ( handle.f );
*RETURN
(END;
(IF loaddir THEN
*Binary.Seek ( handle.f, glob_di.start, Binary.fromBegin );
*IF ok() THEN
,len:= LONG ( glob_di.entries ) * TSIZE ( LibEntry );
,ALLOCATE ( handle.private, len + DBLen );
,IF handle.private = NIL THEN
.reply:= MOSGlobals.fOutOfMem;
.Files.Close ( handle.f );
.RETURN
,END;
,dir:= handle.private;
,Binary.ReadBytes ( handle.f, ADR ( dir^.d ), len, read );
,IF read # len THEN
.DEALLOCATE ( handle.private, 0L );
.reply:= MOSGlobals.fEndOfFile;
.Files.Close ( handle.f );
.RETURN
,ELSE
.dir^.n:= glob_di.entries
,END
*END
(END
&END
$END;
$reply:= Files.State ( handle.f );
$IF reply < 0 THEN
&DEALLOCATE ( handle.private, 0L );
&Files.ResetState ( handle.f );
&Files.Close ( handle.f );
$END;
"END open;
 
 PROCEDURE OpenLib ( VAR handle: LibFile; REF libraryName: ARRAY OF CHAR;
4VAR reply: INTEGER );
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  #Files.readOnly,(A3)+
(MOVE    #TRUE,(A3)+
(JMP     open
$END
"END OpenLib;
"(*$L=*)
 
 
 PROCEDURE writeHeader (f: File; VAR damaged: BOOLEAN; VAR reply: INTEGER);
"BEGIN
$Binary.Seek ( f, 0L, Binary.fromBegin );
$IF Files.State (f) >= 0 THEN
&Binary.WriteBlock ( f, glob_di );
&IF Files.State (f) >= 0 THEN
(damaged:= FALSE;
&END
$END;
$reply:= Files.State (f);
"END writeHeader;
 
 
 PROCEDURE SetUserData ( REF libraryName: ARRAY OF CHAR;
8REF inData: ARRAY OF BYTE; VAR reply: INTEGER );
"
"VAR hdl: LibFile; all, dam: BOOLEAN;
"
"BEGIN
$open ( hdl, libraryName, reply, Files.readWrite, FALSE );
$IF reply >= 0 THEN
&CopyVar (inData, glob_di.userData, all);
&IF NOT all THEN
(ASSEMBLER
0TRAP    #6
0DC.W    MOSGlobals.StringOverflow
(END
&END;
&Binary.WriteBlock (hdl.f, glob_di);
&writeHeader (hdl.f, dam, reply);
&CloseLib (hdl);
$END
"END SetUserData;
 
 PROCEDURE GetUserData ( REF libraryName: ARRAY OF CHAR;
8VAR outData: ARRAY OF BYTE; VAR reply: INTEGER );
"
"VAR hdl: LibFile; all: BOOLEAN;
"
"BEGIN
$open ( hdl, libraryName, reply, Files.readOnly, FALSE );
$IF reply >= 0 THEN
&CopyVar (glob_di.userData, outData, all);
&CloseLib (hdl);
$END
"END GetUserData;
 
 
 TYPE STR12 = ARRAY [0..11] OF CHAR;
 
 PROCEDURE find ( REF name: STR12; dir: DirBuffer; VAR info: LibEntry ): BOOLEAN;
"VAR res: BOOLEAN; pe: POINTER TO LibEntry;
"BEGIN
$(*
&pn:= ADR ( dir^.d [1].name );
&FOR i:= 1 TO dir^.n DO
(IF StrEqual ( pn^, name ) THEN
*info:= dir^.d [i];
*RETURN TRUE
(END;
(INC ( pn, SHORT ( TSIZE ( LibEntry ) ) )
&END;
&RETURN FALSE
$*)
$res:= FALSE;
$ASSEMBLER
(SUBQ.L  #2,A7
(MOVE.L  name(A6),A1             ; A1: ADR (name)
(MOVE.B  (A1)+,D1                ; D1: name[0]
(BEQ     ret
(MOVE.L  A1,A2
(MOVEQ   #0,D2
(MOVEQ   #10,D0
&len
(ADDQ    #1,D2                   ; D2: Length (name)
(TST.B   (A2)+
(DBEQ    D0,len
(BEQ     nullTerm
(ADDQ    #1,D2
&nullTerm
(MOVE    D2,(A7)
(MOVE.L  dir(A6),A0              ; A0: ADR (DirBuffer.d)
(MOVE.W  (A0)+,D0                ; D0: dir.n
(BRA     start
&loop
(MOVE.L  A0,A2
(CMP.B   (A0)+,D1
(BNE     notequ
(MOVE    (A7),D2
(SUBQ    #2,D2
(BCS     equ
(MOVE.L  A1,-(A7)
&l2
(CMPM.B  (A1)+,(A0)+
(DBNE    D2,l2
(MOVE.L  (A7)+,A1
(BNE     notequ
&equ
(CMPI.W  #12,(A7)
(BEQ     equ2
(TST.B   (A0)
(BNE     notequ
&equ2
(MOVE    #TRUE,res(A6)
(MOVE.L  A2,pe(A6)
(BRA     ret
&notequ
(MOVE.L  A2,A0
(ADDA.W  #TSIZE (LibEntry),A0
&start
(DBRA    D0,loop
&ret
(ADDQ.L  #2,A7
$END;
$IF res THEN
&info:= pe^
$END;
$RETURN res
"END find;
 
 PROCEDURE LookUp ( VAR handle: LibFile; REF fileName: ARRAY OF CHAR;
3VAR info: LibEntry; VAR reply: INTEGER );
"VAR dir: DirBuffer;
&path: ARRAY [0..64] OF CHAR;
&name: ARRAY [0..11] OF CHAR;
"BEGIN
$dir:= handle.private;
$IF dir # NIL THEN
&SplitPath ( fileName, path, name );
&Upper (name);
&IF find ( name, dir, info ) THEN
(reply:= 0
&ELSE
(reply:= MOSGlobals.fFileNotFound
&END
$ELSE
&reply:= MOSGlobals.fFileNotOpen
$END
"END LookUp;
 
 
 PROCEDURE LibQuery ( VAR handle: LibFile; proc: LibQueryProc;
5VAR reply: INTEGER );
"VAR i: CARDINAL;
&dir: DirBuffer;
"BEGIN
$dir:= handle.private;
$IF dir # NIL THEN
&reply:= 0;
&FOR i:= 1 TO dir^.n DO
(IF NOT proc ( dir^.d [i] ) THEN RETURN END
&END
$ELSE
&reply:= MOSGlobals.fFileNotOpen
$END
"END LibQuery;
 
 
 PROCEDURE CloseLib ( VAR handle: LibFile );
"BEGIN
$DEALLOCATE ( handle.private, 0L );
$Files.ResetState ( handle.f );
$Files.Close ( handle.f );
"END CloseLib;
 
 
 PROCEDURE RemoveFile ( REF libraryName, fileName: ARRAY OF CHAR;
7VAR damaged: BOOLEAN; VAR reply: INTEGER );
"VAR dir: DirBuffer;
&buf: ADDRESS;
&hdl: LibFile;
&i: CARDINAL;
&path: ARRAY [0..64] OF CHAR;
&name: ARRAY [0..11] OF CHAR;
 
"PROCEDURE remove (i: CARDINAL);
 
$PROCEDURE ok (): BOOLEAN;
&BEGIN
(reply:= Files.State ( hdl.f );
(RETURN reply >= 0
&END ok;
 
$VAR j: CARDINAL; r, st, offs: LONGCARD;
 
$BEGIN
&(* Files runterschieben *)
&WITH dir^.d [i] DO
(st:= start;
(offs:= size
&END;
&r:= MemAvail () DIV 2L; IF ODD (r) THEN DEC (r) END;
&ALLOCATE ( buf, r );
&IF buf = NIL THEN reply:= MOSGlobals.fOutOfMem; RETURN END;
&Binary.Seek ( hdl.f, st, Binary.fromBegin );
&IF NOT ok () THEN RETURN END;
&REPEAT
(Binary.Seek ( hdl.f, offs, Binary.fromPos );
(IF NOT ok () THEN RETURN END;
(Binary.ReadBytes ( hdl.f, buf, r, r );
(IF NOT ok () THEN RETURN END;
(Binary.Seek ( hdl.f, -LONGINT(r)-LONGINT(offs), Binary.fromPos );
(IF NOT ok () THEN RETURN END;
(Binary.WriteBytes ( hdl.f, buf, r );
(IF NOT ok () THEN RETURN END;
&UNTIL r = 0L;
&DEALLOCATE ( buf, 0L );
&
&(* Dir-Eintrag 'i' lschen *)
&FOR j:= i+1 TO dir^.n DO
(dir^.d [j-1]:= dir^.d [j]
&END;
&DEC ( dir^.n );
&
&(* Dir-Eintrge korrigieren *)
&FOR j:= 1 TO dir^.n DO
(WITH dir^.d [j] DO
*IF start >= st THEN
,start:= start - offs
*END
(END
&END;
&glob_di.start:= glob_di.start - offs;
&glob_di.fileSize:= glob_di.fileSize - offs;
&glob_di.entries:= dir^.n;
&
&(* Dir neu schreiben *)
&r:= LONG ( dir^.n ) * TSIZE ( LibEntry );
&Binary.Seek ( hdl.f, glob_di.start, Binary.fromBegin );
&IF ok () THEN
(damaged:= TRUE;
(Binary.WriteBytes ( hdl.f, ADR ( dir^.d ), r );
(IF ok () THEN
*writeHeader (hdl.f, damaged, reply);
(END;
&END;
$END remove;
"
"BEGIN
$damaged:= FALSE;
$open ( hdl, libraryName, reply, Files.readWrite, TRUE );
$IF reply >= 0 THEN
&dir:= hdl.private;
&SplitPath ( fileName, path, name );
&Upper (name);
&FOR i:= 1 TO dir^.n DO
(IF StrEqual ( dir^.d [i].name, name ) THEN
*buf:= NIL;
*remove (i);
*DEALLOCATE ( buf, 0L );
*CloseLib ( hdl );
*RETURN
(END
&END;
&CloseLib ( hdl );
&reply:= MOSGlobals.fFileNotFound
$END
"END RemoveFile;
 
 
 PROCEDURE CopyLib ( REF sourceLib, destLib: ARRAY OF CHAR; VAR reply: INTEGER );
"BEGIN
$HALT
"END CopyLib;
 
 
 PROCEDURE AddFile ( REF libraryName: ARRAY OF CHAR; VAR info: LibEntry;
4VAR damaged: BOOLEAN; VAR reply: INTEGER );
"VAR dir: DirBuffer;
&hdl: LibFile;
&dummy: LibEntry;
 
"PROCEDURE ok (): BOOLEAN;
$BEGIN
&reply:= Files.State ( hdl.f );
&RETURN reply >= 0
$END ok;
 
"BEGIN
$damaged:= FALSE;
$open ( hdl, libraryName, reply, Files.readWrite, TRUE );
$IF reply >= 0 THEN
&dir:= hdl.private;
&Upper (info.name);
&IF find ( info.name, dir, dummy ) THEN
(reply:= MOSGlobals.fFileExists
&ELSE
(info.start:= glob_di.start;
(glob_di.start:= glob_di.start + info.size;
(glob_di.fileSize:= glob_di.fileSize + info.size;
(INC ( glob_di.entries );
(Binary.Seek ( hdl.f, glob_di.start, Binary.fromBegin );
(IF ok () THEN
*damaged:= TRUE;
*Binary.WriteBytes ( hdl.f, ADR ( dir^.d ),
>LONG ( dir^.n ) * TSIZE ( LibEntry ) );
*IF ok () THEN
,Binary.WriteBlock ( hdl.f, info );
,writeHeader (hdl.f, damaged, reply);
*END
(END
&END;
&CloseLib ( hdl );
$END
"END AddFile;
 
 PROCEDURE CreateLib ( REF libraryName: ARRAY OF CHAR; VAR reply: INTEGER );
 
"VAR f: File; di: LibHead;
 
"PROCEDURE ok (): BOOLEAN;
$BEGIN
&reply:= Files.State ( f );
&RETURN reply >= 0
$END ok;
 
"BEGIN
$Files.Create ( f, libraryName, Files.writeOnly, Files.noReplace );
$IF ok () THEN
&WITH di DO
(str:= 'MM2Lib';
(layout:= $1A01;
(fileSize:= SIZE (di);
(start:= fileSize;
(entries:= 0;
(ClearVar (userData)
&END;
&Binary.WriteBlock ( f, di );
&IF ok () THEN
(Files.Close ( f );
&ELSE
(Files.Remove ( f );
&END;
$END;
"END CreateLib;
 
 
 END LibFiles.
  
(* $000020E2$FFEE3A6E$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$00001724$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$FFF6A80C$000000EBT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000C18$00001A25$00000BBE$00000C5B$00000C33$00000032$00000091$00000099$000000EB$00001161$00000CF6$00000D0B$00000EF8$0000048C$00000BD5$FFEE3A6E*)
