 IMPLEMENTATION MODULE Runtime;
 (*$Y+,J-,L-,R-,N+,C-,X+*)
 
 (**********************************************************************
 
,Runtime Support fuer Atari Modula-Compiler   V#390
 
!30.10.86   Version fuer Atari, mit neuem Stringformat:
,CAP, STAS angepasst,
,RangeCheck fuer CHR.
"1.11.86   STAS fuer Stringlaenge > 32K korrigiert;
,Prozeduren zur Coroutinen-Unterstuetzung als Dummy.
"3.11.86   CHR und CAP fuer neue Char-Darstellung (mit folgendem SyncByte)
!30.11.86   Set-Operationen verkraften ungerade Laengenangaben
!19.12.86   TrapCode 7 fuer Zugriff ueber NIL-Pointer definiert
!22.01.87   TRAP-Auswertung wieder impl.
!04.02.87   STAS: BCS ok2 statt BEQ ok2.
!27.02.87   TRAP 15: trp0->trp9; GEM-Alert impl.; DivByZero,TRAPV,Addr- und
,Bus-Error abgefangen; Vektor-Restauration per SetTerminateProc;
,trp7 (access via NIL-Ptr) raus.
!02.03.87   Traps:USP wird gerettet; Scan-Aufruf impl.
!19.03.87   Fehlerbehandlung -> GEMError-Modul
!09.05.87   TRAP-Nummern gendert
!19.06.87   neue Real-Arithmetik
!30.06.87   IOTransfer impl.
!08.07.87   D7->#1; bei Fehler wird Aufrufer angescanned.
!22.07.87   IOTransfer, LISTEN, usw. impl.;
!23.07.87   @PRIO impl, IOTransfer kann auch auf Vektoren >= $400 ange-
,wendet werden.
!11.08.87   abermals D7->#1 in Set-Funktionen (wie kam D7 da wieder hin ??)
!29.08.87   @IDIV korrigiert (UNLK u. MOVEM vertauscht)
!08.09.87   @IOCA neu
!27.10.87   FLOAT und TRUNC auf LONGCARD-Parameter umgestellt
!13.11.87   @LSTN decr. IR um Eins
!16.12.87   Realvergleiche korrigiert (Null galt als grer als Zahlen
-mit negativem Exponenten): RELE, REGE, RELT, REGT
!17.12.87   Realvergleiche jetzt hoffentlich ok
!16.01.88   @PRIO geht auch im Superv.-Mode
!01.04.88   @FPDIV fr negativen Divisor korrigiert; @IOCA geht jetzt.
!09.04.88   Coroutinen-Anpassung f. 68020.
!28.05.88   @RES1 und @RES2 fr Procedure Entries (ab Comp 3.6a) verwendet
!19.07.88   @SMEM, @LRLE, @LRGE, @LRLT, @LRGT zerstren nicht mehr D3/D4.
!12.08.88   CAP bercksichtigt auch nicht-deutsche Umlaute.
!01.01.88   TRUNC lst Runtime-Error bei neg. Arg. aus
!19.01.89   881-Untersttzung von MR (26.8.88) bernommen (Cond: A68881)
!15.06.89   Include-File f. Prozessoren
!16.06.89   881-Routinen berarbeitet (optimiert, Errors)
!04.07.89   @STAS korrigiert - machte bei ungeradem Source-String Mist
!19.08.89   Runtime luft nun gleichzeitg mit 68000 & 68020
!30.11.89   Optimierungen in Long-Mul/Div/Mod (LINK verlagert)
!05.12.89   neue Long- & Set-Ops mit Reg-bergabe;
!07.01.90   @RES2 nimmt nun D0.L statt D0.W
!11.02.90   ShortReals impl.; Automatische Verwenmdung einer in-/externen FPU
!18.02.90   MOD/DIV f. LONG/WORD implementiert; FLOAT/TRUNC vervollst.;
,LongDiv/Mod: LSL #1 durch ADD ersetzt
!15.05.90   Alle Error-Meldungen machen LINK nun auf abgerumten Stack, damit
,scanning korrekt geht; Fehler in @LADD behoben; Die Grundrechen-
,arten fr Shortreals zerstren nicht mehr das Highword v. D3/D4.
!28.05.90   REAL-Routinen verwenden nun FP2 statt FP0
!13.06.90   Coroutinen benutzen nicht mehr "EnterSupervisorMode"
!17.06.90   Shortreals: 0.64 * 200. geht jetzt
!17.07.90   @LTOS: Null-Erkennung korrigiert (sollte Exp-Word testen, tat es
,aber mit Bits 32-47)
!20.07.90   @SEQL: Nun wordweise
!23.07.90   @LDIV: Bei 0./0. wird nun Div by zero gemeldet
!12.09.90   Bei einigen der Real-Routinen fehlte die A68881-Condition
!10.10.90   CaughtExceptions werden f. TT-FPU erweitert; ST-FPU-Routinen
,sind mit Conditionals auch bei TT-FPU verwendbar, allerdings nur,
,wenn der Cache abgeschaltet ist!
!15.10.90   Fehler in 'hdlCall' (IOTRANSFER) behoben: Wenn Aufruf bei Soft-
,Vektoren aus Usermode kam, wurden Regs zerstrt -> Absturz;
,Bei TT-FPU-Code wird Fehler gemeldet, wenn FPU nicht vorhanden
!05.11.90   Nochn Fehler in 'hdlCall' behoben: Bei Call aus User-Mode wurde
,A6 statt A0 als dest^ gemerkt.
!17.12.90   Alle MOVE from SR-Instr. wg. 68020 entfernt
!20.02.91   Warteschleifen bei ST-FPU hinzugefgt, damit's auch mit dem
,hyperCACHE 030 luft.
!02.03.91   @RES1 f. Vergleich von lok. Proc-Vars
!27.03.91   Korrekturen bei ST-FPU - nix ging mehr.
!09.04.91   @ROTA/@SHFT implementiert, aber erstmal nur fr vollstndige
,Bytes/Words/Longs.
!18.04.91   Wenn M68881, dann werden auch schnellere 68020-Mul/Div-Instrs verw.;
,@IMLW setzt nun Overflow- statt Carry-Bit, @IMLL erkennt berlufe,
,@IMLW geht auch korrekt mit neg. Long-Operand (in D0), @IDVW/@CDVW/
,@IMDW/@CMDW korrigiert und getestet.
!11.08.91   MOVE from SR-Instr. in NEWPROCESS durch MOVE #$2300 ersetzt.
!14.02.92   GEMDOS.Super-Aufrufe statt Supexec wg. MinT.
!07.07.92   MOVE #$2300 in NEWPROCESS durch #$0300 ersetzt.
!08.02.94   Kein Byte-Zugriff mehr auf fpstat+1 wg. STE. Dabei auch die Warte-
,schleifen bei @Fxxx gendert: Offenbar ist es nicht ntig, _vor_
,dem Setzen des cmds zu warten, sondern erst danach -> bessere
,Performance.
 ***********************************************************************)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, WORD;
 
 FROM MOSConfig IMPORT CoroutineTrapNo, CaughtExceptions;
 
 FROM MOSSupport IMPORT ToSuper, ToUser;
 
 FROM SysTypes IMPORT
"ExcSet, BSUnExc, FPZeroDivide, OpError, FPOverflow, NANExc;
 
 FROM SystemError IMPORT Abort;
 
 IMPORT MOSGlobals, SysInfo, Block;
 
 FROM SFP004 IMPORT FPUError, FPUReset, FPUInit;
 
 FROM ResCtrl IMPORT CatchRemoval, RemovalCarrier;
 
 
 
 CONST   DftSF = $0010;
(rtsCode = $4E75;
 
 (*$I FPU.CNF *)
 
 CONST   Code20 = M68881;
(IEEEReal = M68881 OR A68881;
(SoftReal = NOT IEEEReal;
(AutoFPU = FALSE;
 
 VAR     useSF: BOOLEAN;
 
 (*$? AutoFPU:
(fpu: INTEGER;    (* -1: soft, 0: external, 1: internal *)
 *)
 
 (*$? M68881:
((*
)* Puffer fr generische FPU-Cmds (f. interne FPU mit $F+)
)* Vorsicht: Reihenfolge nicht vertauschen!
)*)
(cpGEN0: CARDINAL;                       (* $F200: cpGEN      *)
(cpGEN1: CARDINAL;                       (* F-Instr (Word)    *)
(cpGEN2: CARDINAL;                       (* RTS               *)
(
(cpScc0: CARDINAL;                       (* $F240: cpScc D0   *)
(cpScc1: CARDINAL;                       (* Condition Code    *)
(cpScc2: CARDINAL;                       (* RTS               *)
 
(cpGENL0: CARDINAL;                     (* $F210: cpGEN (A0) *)
(cpGENL1: CARDINAL;                     (* F-Instr (Word)    *)
(cpGENL2: CARDINAL;                     (* RTS               *)
 
(cpGENS0: CARDINAL;                     (* $F201: cpGEN D1   *)
(cpGENS1: CARDINAL;                     (* F-Instr (Word)    *)
(cpGENS2: CARDINAL;                     (* RTS               *)
 
(cpPsh70: CARDINAL;                     (* $F227: cpGEN 4(A7)*)
(cpPsh71: CARDINAL;                     (* F-Instr (Word)    *)
(cpPsh72: CARDINAL;                     (* 4 (offset)        *)
(cpPsh73: CARDINAL;                     (* RTS               *)
 
(cpPsh30: CARDINAL;                     (* $F21B: cpGEN (A3)+*)
(cpPsh31: CARDINAL;                     (* F-Instr (Word)    *)
(cpPsh32: CARDINAL;                     (* RTS               *)
 *)
 
 (*$? A68881:
 CONST
(fpstat  =  $fffa40;       (* Response word of MC68881 read *)
(fpctrl  =  $fffa42;       (* Control  word of MC68881 write *)
(fpcmd   =  $fffa4a;       (* Command  word of MC68881 write *)
(fpcond  =  $fffa4e;       (* Condition word of MC68881 write *)
(fpop    =  $fffa50;       (* Operand  long of MC68881 read/write *)
(fpregsel=  $fffa54;       (* register select long read *)
(
(A2stat  =  0;             (* Response word of MC68881 read *)
(A2ctrl  =  2;             (* Control  word of MC68881 write *)
(A2cmd   =  10;            (* Command  word of MC68881 write *)
(A2cond  =  14;            (* Condition word of MC68881 write *)
(A2op    =  16;            (* Operand  long of MC68881 read/write *)
(A2regsel=  $14;           (* register select long read *)
 *)
 
 (************** Coroutinen-Unterstuetzung **************)
 
 
 VAR superTrapV: ADDRESS;
 
 (*
!* PROCEDURE super ();
!*
!* Geht in den Supervisor-Modus; der SSP wird dabei zum A7;
!* A0 wird verndert; D0 liefert altes SR
!*)
 VAR super: ARRAY [0..2] OF WORD; (* hierin steht die richtige Super-Routine *)
 
 PROCEDURE superCopy;
"BEGIN
$ASSEMBLER
(MOVE.L  (A7)+,A0
(TRAP    #0              ; dieser Wert wird gepatched!
(JMP     (A0)
$END
"END superCopy;
 
 PROCEDURE HdlSuper;
"BEGIN
$ASSEMBLER
(ASC     'XBRA'  ; XBRA-Kennung
(ASC     'MM2C'  ; eigene Kennung
(DC.L    0       ; old vector
(MOVE    (A7),D0 ; altes SR nach D0
(BSET    #5,(A7)
(RTE
$END
"END HdlSuper;
 
 PROCEDURE LinkOut;
"BEGIN
$ASSEMBLER
(TST.L   superTrapV
(BEQ     rtn             ; nicht installiert
(SUBQ.L  #4,A7
(JSR     ToSuper
(
(LEA     HdlSuper,A2
(ADDA.W  #12,A2
(MOVE.L  superTrapV,A0
%l: MOVE.L  (A0),A1
(CMPA.L  A2,A1           ; 'entry' gefunden?
(BEQ     f
(CMPI.L  #$58425241,-12(A1) ; Ist dies ein XBRA-Eintrag?
(BNE     n               ; Nein -> entry hier trotzdem austragen
(LEA     -4(A1),A0       ; Vorige Vektoradr. nach A0
(BRA     l
%n: MOVE.L  A2,A1
%f: MOVE.L  -4(A1),(A0)     ; Entry.old eintragen
(CLR.L   superTrapV
(
(JSR     ToUser
(ADDQ.L  #4,A7
%rtn:
$END
"END LinkOut;
 
 PROCEDURE LinkIn;
"BEGIN
$ASSEMBLER
(TST.L   superTrapV
(BNE     rtn             ; bereits installiert
(
(SUBQ.L  #4,A7
(JSR     ToSuper
(
(MOVE.W  CoroutineTrapNo,D0
(MOVE    D0,D1
(LSL.W   #2,D0           ; mal 4
(ADDI.W  #$80,D0         ; plus TRAP #0
(MOVE.W  D0,A0
(MOVE.L  A0,superTrapV
(; 'super'-Routine mit richtigem TRAP-Befehl im BSS erzeugen
(LEA     superCopy,A1
(LEA     super,A2
(MOVE.W  (A1)+,(A2)+     ; MOVE.L  (A7)+,A0
(MOVE.W  (A1)+,D0
(OR.W    D1,D0
(MOVE.W  D0,(A2)+        ; TRAP    #<D1>
(MOVE.W  (A1)+,(A2)+     ; JMP     (A0)
(LEA     HdlSuper,A1
(ADDA.W  #12,A1
(MOVE.L  (A0),-4(A1)     ; alten Vektor retten (in XBRA-Struktur)
(MOVE.L  A1,(A0)
$
(JSR     ToUser
(ADDQ.L  #4,A7
%rtn:
$END
"END LinkIn;
 
 
 PROCEDURE BadReturn;  (* RTS aus CoRoutine anmeckern *)
"BEGIN
$ASSEMBLER
(TRAP    #6
(DC.W    -15-$6000       ; kein cont, scan prev
$END
"END BadReturn;
 
 (*
#Transferdaten beim Usermode:
(2  Byte - 0: zeigt Usermode an / 1: Vektor zus. restaurieren
(4  Byte - PC
(2  Byte - SR
(4  Byte - A6
(56 Byte - D0-A5
&{ 60 Byte - FP3-FP7 }  (* wenn SwitchFPUContext = TRUE *)
 
#Transferdaten beim Supervisormode:
(2  Byte - $FFxx, zeigt Supervisormode an
(4  Byte - USP
(60 Byte - D0-A6
(4  Byte - Dummy
(2  Byte - SR
(4  Byte - PC
&{ 60 Byte - FP3-FP7 }  (* wenn SwitchFPUContext = TRUE *)
 *)
 
 (* Kennung:      Zustand:
$0             Normal u. Exc-Rckkehr - Usermode
$1             Warten auf Exc - Usermode, Vektor restaurieren
$$FF           Exc-Rckkehr - Supervisormode
 *)
 
 PROCEDURE @NEWP ( p:PROC; a:ADDRESS; n:LONGCARD; VAR prc:ADDRESS );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(
(MOVE.L  -(A3),A1        ; 'prc'
(MOVE.L  -(A3),A0        ; SIZE (workspace)
(MOVE.L  A0,D1
(BCLR    #0,D1
(MOVE.L  -(A3),D0        ; ADR (workspace)
(ADDQ.L  #1,D0
(BCLR    #0,D0
(ADDA.L  D0,A0           ; ENDADR (workspace)
(MOVE.L  -(A3),D2        ; ADR (procedure)
(CMPI.L  #90,D1          ; ist workspace gro genug ?
(BCC     wspOk
(
(TRAP    #6
(DC.W    -10-$4000       ; 'out of stack'
(UNLK    A5
(RTS
(
&wspOk:
(MOVEM.L A3/A5,-(A7)
(
(MOVE.L  D0,A3
(
(MOVE.L  D2,-(A0)         ;Adresse fr scan
(ADDQ.L  #2,(A0)          ;scan-Adr etwas vorsetzen
(CLR.L   -(A0)            ;voriges A5
(MOVE.L  A0,A5            ;fr UNLK in backScan()
(MOVE.L  #BadReturn,-(A0) ;Fehlerbehandlung bei RTS aus Coroutine
(
(MOVEM.L D0-A5,-(A0)      ; Bis auf A3,A5 nur Dummy-Werte
(MOVE.L  A6,-(A0)
(MOVE.W  #$0300,-(A0)     ; Default-SR
(MOVE.L  D2,-(A0)
(CLR.W   -(A0)
(
(; nun den SP in 'prc' ablegen
(MOVE.L  A0,(A1)
(
(JSR     LinkIn          ; Supervisor-TRAP installieren
(
(MOVEM.L (A7)+,A3/A5
(UNLK    A5
$END
"END @NEWP;
 
 
 
 PROCEDURE @TRAN ( VAR source,dest:ADDRESS );  (* Transfer *)
"BEGIN
$ASSEMBLER
(; Aufruf erfolgt immer im Usermode, der zu startende Proze
(; kann in beiden Modi ablaufen
(
(MOVE.L  -(A3),A2        ; dest
(MOVE.L  -(A3),A1        ; source
(
(JSR     super
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden
(MOVE.L  USP,A0
(MOVE.L  (A0)+,D1        ; Rcksprungadr. hinter TRANSFER
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D0,-(A0)        ; altes SR
(MOVE.L  D1,-(A0)
(CLR.W   -(A0)
(
(MOVE.L  (A2),D0         ; zuerst retten, falls A1=A2
(MOVE.L  A0,(A1)
(MOVE.L  D0,A6
(
(; neuen Proze starten
(TST.W   (A6)+
(BEQ     stUsr
(BMI     stSup
(
(; starte Usermode, vorher Vektor restaurieren
(MOVE.L  (A6)+,D0        ; alter Vektor
(MOVE.L  4+2+4+4(A6),A0  ; D1: Vektoradr.
(MOVE.L  D0,(A0)
(TST     useSF
(BEQ     no20
(MOVE    #DftSF,-(A7)
 no20:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stUsr:  ; starte Usermode
(TST     useSF
(BEQ     no20b
(MOVE    #DftSF,-(A7)
 no20b:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stSup:  ; starte Supervisormode
(MOVE.L  A6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  A0,USP
(MOVEM.L (A7)+,D0-A6
(ADDQ.L  #4,A7
(TST     useSF
(BEQ     no20c
(MOVE.W  (A7),-(A7)
(MOVE.L  4(A7),2(A7)
(MOVE    #DftSF,6(A7)
 no20c:
(RTE
$END
"END @TRAN;
 
 PROCEDURE hdlExc;
"(* Fr IOTRANSFER-Auslsungen per Exception *)
"BEGIN
$ASSEMBLER
(; Der Aufruf kann aus beiden Modi kommen, der zu startende
(; Proze ist immer im Usermode
(
(BTST.B  #5,4(A7)        ; aus welchem mode ?
(BNE     frSup
(
((*
(ADDQ.L  #4,A7
(JMP     $FC429C
(*)
(
(; Entry aus User mode
(
(; Daten auf den USP retten
(MOVE.L  A6,-(A7)
(MOVE.L  USP,A6
(MOVEM.L D0-A5,-(A6)
(MOVE.L  (A7)+,-(A6)
(MOVE.L  (A7)+,A0        ; ^Transfer-Daten
(MOVE    (A7)+,-(A6)     ; SR
(MOVE.L  (A7)+,-(A6)     ; PC
(CLR.W   -(A6)
(
(; A0 zeigt auf:
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2  ; A2: alter dest^
(MOVE.L  A6,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20d
(MOVE    #DftSF,-(A7)
 no20d:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 frSup:  ; Entry aus Supervisor mode
(
(; Daten auf den SSP retten
(MOVEM.L D0-A6,-(A7)
(MOVE.L  USP,A6
(MOVE.L  A6,-(A7)
(ST.B    -(A7)
(
(MOVE.L  2+4+60(A7),A0         ; ^Transfer-Daten
(
(; A0: (s.o.)
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2   ; A2: alter dest^
(MOVE.L  A7,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20e
(MOVE    #DftSF,-(A7)
 no20e:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
$END
"END hdlExc;
 
 PROCEDURE hdlCall;
"(* Fr IOTRANSFER-Auslsungen per JSR *)
"BEGIN
$ASSEMBLER
(; Der Aufruf kann aus beiden Modi kommen, der zu startende
(; Proze ist immer im Usermode
(
(MOVEM.L D0/A0,-(A7)
(JSR     super
(BTST    #13,D0          ; aus welchem Mode ?
(BNE     frSup
(
(; Entry aus User mode
(
(; Aktiven Proze beenden, Daten auf den USP retten
(; auf USP stehen noch: D0/A0, ^Dest-Transfer-Daten, PC.L
(MOVE.L  USP,A0
(MOVE.L  (A0)+,-(A7)     ; D0 retten
(MOVE.L  (A0)+,-(A7)     ; A0 retten
(MOVE.L  (A0)+,-(A7)     ; ^Transfer-Daten
(MOVE.L  (A0)+,-(A7)     ; PC retten
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D0,-(A0)        ; SR
(MOVE.L  (A7)+,-(A0)     ; PC
(MOVE.L  (A7)+,A1        ; ^neue Transfer-Daten
(MOVE.L  (A7)+,42(A0)    ; A0 in Transfer-Daten ablegen
(MOVE.L  (A7)+,10(A0)    ; D0 in Transfer-Daten ablegen
(CLR.W   -(A0)
(
(; A1 zeigt auf:
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(MOVE.L  2+4+4+2+4+32+8(A1),A2  ; A2: alter dest^
(MOVE.L  A0,(A2)
(
(MOVE.L  2+4+4+2+4+4(A1),A3  ; D1: Vektoradr.
(LEA     2(A1),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20f
(MOVE    #DftSF,-(A7)
 no20f:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 frSup:  ; Entry aus Supervisor mode
(
(MOVEM.L (A7)+,D0/A0
(SUBQ.L  #2,A7
(MOVE.L  2(A7),(A7)      ; ^Transfer-Daten 2 Byte tiefer
(MOVE    SR,4(A7)        ; SR darber
(
(; aktiven Proze beenden, Daten auf den SSP retten
(MOVEM.L D0-A6,-(A7)
(MOVE.L  USP,A0
(MOVE.L  A0,-(A7)
(ST.B    -(A7)
(
(MOVE.L  2+4+60(A7),A0         ; ^Transfer-Daten
(
(; A0: (s.o.)
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2   ; A2: alter dest^
(MOVE.L  A7,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20g
(MOVE    #DftSF,-(A7)
 no20g:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
$END
"END hdlCall;
 
 
 PROCEDURE @IOTR ( VAR source,dest:ADDRESS; vecAddr:ADDRESS );
"CONST JSRInstr = $4EB9;
"BEGIN
$ASSEMBLER
(; Aufruf erfolgt immer im Usermode, der zu startende Proze
(; kann in beiden Modi ablaufen
(
(MOVE.L  -(A3),D1        ; vector
(MOVE.L  -(A3),A2        ; dest
(MOVE.L  -(A3),A1        ; source
(
(JSR     super
(
(; Daten fr 'hdlExc' und 'hdlCall':
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden
(MOVE.L  USP,A0
(MOVE.L  (A0)+,D2        ; Rcksprungadr. hinter IOTRANSFER
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D0,-(A0)        ; altes SR
(MOVE.L  D2,-(A0)        ; PC
(
(MOVE.L  D1,A3
(MOVE.L  (A3),-(A0)      ; alten vektor retten
(
(MOVE    #1,-(A0)
(
(MOVE.L  (A2),A6         ; zuerst retten, falls A1=A2
(MOVE.L  A0,(A1)
(
(CMPA.W  #$400,A3
(BCS     isExc
(MOVE.L  #hdlCall,-(A0)
(BRA     cont0
 isExc   MOVE.L  #hdlExc,-(A0)
 cont0   MOVE    #JSRInstr,-(A0)
(
(MOVE.L  A0,(A3)         ; neuen vektor auf 'JSR hdlExc/hdlCall'
(
(; neuen Proze starten
(TST.W   (A6)+
(BEQ     stUsr
(BMI     stSup
(
(; starte Usermode, vorher Vektor restaurieren
(MOVE.L  (A6)+,D0        ; alter Vektor
(MOVE.L  4+2+4+4(A6),A0  ; D1: Vektoradr.
(MOVE.L  D0,(A0)
 stUsr:  ; starte Usermode
(TST     useSF
(BEQ     no20h
(MOVE    #DftSF,-(A7)
 no20h:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stSup:  ; starte Supervisormode
(MOVE.L  A6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  A0,USP
(MOVEM.L (A7)+,D0-A6
(ADDQ.L  #4,A7           ; Transfer-Ptr berspringen
(TST     useSF
(BEQ     no20j
(MOVE.W  (A7),-(A7)
(MOVE.L  4(A7),2(A7)
(MOVE    #DftSF,6(A7)
 no20j:
(RTE
$END
"END @IOTR;
 
 (*
 PROCEDURE @TRAN ( VAR source,dest:ADDRESS );  (* Transfer *)
"BEGIN
$ASSEMBLER
(; Aufruf erfolgt immer im Usermode, der zu startende Proze
(; kann in beiden Modi ablaufen
(
(JSR     super
(MOVE.L  USP,A0
(MOVE    D0,D2
(
(MOVE.L  -(A3),A2        ; dest
(MOVE.L  -(A3),A1        ; source
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden
(MOVE.L  (A0)+,D0        ; Rcksprungadr. hinter TRANSFER
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D2,-(A0)
(MOVE.L  D0,-(A0)
(CLR.W   -(A0)
(
(MOVE.L  (A2),D0         ; zuerst retten, falls A1=A2
(MOVE.L  A0,(A1)
(MOVE.L  D0,A6
(
(; neuen Proze starten
(TST.W   (A6)+
(BEQ     stUsr
(BMI     stSup
(
(; starte Usermode, vorher Vektor restaurieren
(MOVE.L  (A6)+,D0        ; alter Vektor
(MOVE.L  4+2+4+4(A6),A0  ; D1: Vektoradr.
(MOVE.L  D0,(A0)
(TST     useSF
(BEQ     no20
(MOVE    #DftSF,-(A7)
 no20:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stUsr:  ; starte Usermode
(TST     useSF
(BEQ     no20b
(MOVE    #DftSF,-(A7)
 no20b:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stSup:  ; starte Supervisormode
(MOVE.L  A6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  A0,USP
(MOVEM.L (A7)+,D0-A6
(ADDQ.L  #4,A7
(TST     useSF
(BEQ     no20c
(MOVE.W  (A7),-(A7)
(MOVE.L  4(A7),2(A7)
(MOVE    #DftSF,6(A7)
 no20c:
(RTE
$END
"END @TRAN;
 
 PROCEDURE hdlExc;
"(* Fr IOTRANSFER-Auslsungen per Exception *)
"BEGIN
$ASSEMBLER
(; Der Aufruf kann aus beiden Modi kommen, der zu startende
(; Proze ist immer im Usermode
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(BTST.B  #5,4(A7)        ; aus welchem mode ?
(BNE     frSup
(
(; Entry aus User mode
(
(; Daten auf den USP retten
(MOVE.L  A6,-(A7)
(MOVE.L  USP,A6
(MOVEM.L D0-A5,-(A6)
(MOVE.L  (A7)+,-(A6)
(MOVE.L  (A7)+,A0        ; ^Transfer-Daten
(MOVE    (A7)+,-(A6)     ; SR
(MOVE.L  (A7)+,-(A6)     ; PC
(CLR.W   -(A6)
(
(; A0 zeigt auf:
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2  ; A2: alter dest^
(MOVE.L  A6,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20d
(MOVE    #DftSF,-(A7)
 no20d:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 frSup:  ; Entry aus Supervisor mode
(
(; Daten auf den USP retten
(MOVEM.L D0-A6,-(A7)
(MOVE.L  USP,A6
(MOVE.L  A6,-(A7)
(ST.B    -(A7)
(
(MOVE.L  2+4+60(A7),A0         ; ^Transfer-Daten
(
(; A0: (s.o.)
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2   ; A2: alter dest^
(MOVE.L  A7,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20e
(MOVE    #DftSF,-(A7)
 no20e:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
$END
"END hdlExc;
 
 
 PROCEDURE hdlCall;
"(* Fr IOTRANSFER-Auslsungen per JSR *)
"BEGIN
$ASSEMBLER
(; Der Aufruf kann aus beiden Modi kommen, der zu startende
(; Proze ist immer im Usermode
(
(MOVE.L  D1,-(A7)
(
(MOVEM.L D0/D2/A0-A2,-(A7)
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(TST.W   D0
(BNE     frSup
(
(; Entry aus User mode
(
(MOVE.W  D0,4(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  D0,D1
(MOVEM.L (A7)+,D0/D2/A0-A2
(MOVE.L  A7,USP
(MOVE.L  D1,A7           ; SSP wiederherstellen
(
(MOVE    SR,D1
(ANDI    #$CFFF,D1
(
(;BREAK
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; Aktiven Proze beenden, Daten auf den USP retten
(; auf USP stehen noch: D1.L, ^Dest-Transfer-Daten, PC.L
(MOVE.L  A0,-(A7)
(MOVE.L  USP,A0
(MOVE.L  (A0)+,-(A7)     ; D1 retten
(MOVE.L  (A0)+,-(A7)     ; ^Transfer-Daten
(MOVE.L  (A0)+,-(A7)     ; PC retten
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D1,-(A0)        ; SR
(MOVE.L  (A7)+,-(A0)     ; PC
(MOVE.L  (A7)+,14(A0)    ; D1 in Transfer-Daten ablegen
(MOVE.L  (A7)+,A1        ; ^Transfer-Daten
(MOVE.L  (A7)+,42(A0)    ; A0 in Transfer-Daten ablegen
(CLR.W   -(A0)
(
(; A1 zeigt auf:
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE.L  2+4+4+2+4+32+8(A1),A2  ; A2: alter dest^
(MOVE.L  A0,(A2)
(
(MOVE.L  2+4+4+2+4+4(A1),A3  ; D1: Vektoradr.
(LEA     2(A1),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20f
(MOVE    #DftSF,-(A7)
 no20f:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 frSup:  ; Entry aus Supervisor mode
(
(ADDQ.L  #6,A7
(MOVEM.L (A7)+,D0/D2/A0-A2
(
(MOVE.L  (A7),D1
(ADDQ.L  #2,A7
(MOVE.L  2(A7),(A7)      ; ^Transfer-Daten 2 Byte tiefer
(MOVE    SR,4(A7)        ; SR darber
(
(;BREAK
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden, Daten auf den USP retten
(MOVEM.L D0-A6,-(A7)
(MOVE.L  USP,A0
(MOVE.L  A0,-(A7)
(ST.B    -(A7)
(
(MOVE.L  2+4+60(A7),A0         ; ^Transfer-Daten
(
(; A0: (s.o.)
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2   ; A2: alter dest^
(MOVE.L  A7,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     useSF
(BEQ     no20g
(MOVE    #DftSF,-(A7)
 no20g:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
$END
"END hdlCall;
 
 
 PROCEDURE @IOTR ( VAR source,dest:ADDRESS; vecAddr:ADDRESS );
"CONST JSRInstr = $4EB9;
"BEGIN
$ASSEMBLER
(; Aufruf erfolgt immer im Usermode, der zu startende Proze
(; kann in beiden Modi ablaufen
(
(JSR     super
(MOVE.L  USP,A0
(MOVE    D0,D2
(
(MOVE.L  -(A3),D1        ; vector
(MOVE.L  -(A3),A2        ; dest
(MOVE.L  -(A3),A1        ; source
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; Daten fr 'hdlExc' und 'hdlCall':
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(; aktiven Proze beenden
(MOVE.L  (A0)+,D0        ; Rcksprungadr. hinter IOTRANSFER
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D2,-(A0)
(MOVE.L  D0,-(A0)
(
(MOVE.L  D1,A3
(MOVE.L  (A3),-(A0)      ; alten vektor retten
(
(MOVE    #1,-(A0)
(
(MOVE.L  (A2),D0         ; zuerst retten, falls A1=A2
(MOVE.L  A0,(A1)
(MOVE.L  D0,A6
(
(CMPA.W  #$400,A3
(BCS     isExc
(MOVE.L  #hdlCall,-(A0)
(BRA     cont0
 isExc   MOVE.L  #hdlExc,-(A0)
 cont0   MOVE    #JSRInstr,-(A0)
(
(MOVE.L  A0,(A3)         ; neuen vektor auf 'JSR hdlExc/hdlCall'
(
(; neuen Proze starten
(TST.W   (A6)+
(BEQ     stUsr
(BMI     stSup
(
(; starte Usermode, vorher Vektor restaurieren
(MOVE.L  (A6)+,D0        ; alter Vektor
(MOVE.L  4+2+4+4(A6),A0  ; D1: Vektoradr.
(MOVE.L  D0,(A0)
(TST     useSF
(BEQ     no20h
(MOVE    #DftSF,-(A7)
 no20h:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stUsr:  ; starte Usermode
(TST     useSF
(BEQ     no20i
(MOVE    #DftSF,-(A7)
 no20i:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stSup:  ; starte Supervisormode
(MOVE.L  A6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  A0,USP
(MOVEM.L (A7)+,D0-A6
(ADDQ.L  #4,A7
(TST     useSF
(BEQ     no20j
(MOVE.W  (A7),-(A7)
(MOVE.L  4(A7),2(A7)
(MOVE    #DftSF,6(A7)
 no20j:
(RTE
$END
"END @IOTR;
 *)
 
 PROCEDURE @LSTN;
"BEGIN
$ASSEMBLER
(CLR.L   -(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(MOVE.L  D0,2(A7)
(MOVE    SR,D1
(MOVE    D1,D0
(ANDI    #$0700,D0
(BEQ     ok
(MOVE    D1,D0
(SUBI    #$0100,D0
(MOVE    D0,SR
(NOP
(NOP
&ok:
(MOVE    D1,SR
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END @LSTN;
 
 PROCEDURE @IOCA ( vecAddr:ADDRESS );
"BEGIN
$ASSEMBLER
(MOVE.L  (A7)+,A2        ; PC vom USP
(JSR     super
(CMPI.L  #$400,-(A3)
(BCS     isExc
(MOVE.L  A2,-(A7)        ; PC und SR auf den SSP
(MOVE    D0,-(A7)
(MOVEM.L D3-D7/A3-A6,-(A7)
(MOVE.L  (A3),A1
(MOVE.L  (A1),A1
(JSR     (A1)            ; Benutzt den SSP als SP
(MOVEM.L (A7)+,D3-D7/A3-A6
(RTE
&isExc:
(MOVE.L  (A3),A1
(MOVE.L  (A1),A1
(TST     useSF
(BEQ     no20k
(MOVE    #DftSF,-(A7)
 no20k:  MOVE.L  A2,-(A7)        ; PC und SR auf den SSP
(MOVE    D0,-(A7)        ; Routine verwendet SSP als SP
(JMP     (A1)            ; rettet sicherlich alle Register
$END
"END @IOCA;
 
 PROCEDURE @PRIO;  (* Set Interrupt Priority *)
"BEGIN
$(* IR-level in D1, auf Bitpos. wie SR; D0, D2 nicht verndern ! *);
$ASSEMBLER
(MOVE.L  D2,-(A7)
(MOVE.L  D0,-(A7)
(
(MOVE.W  D1,-(A7)
(
(MOVEQ   #1,D0
(MOVE.L  D0,-(A7)
(MOVE    #$20,-(A7)
(TRAP    #1
(TST     D0
(BNE     alreadySuper
(
(MOVE.W  D0,4(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.W  (A7)+,D1
(
(MOVE.L  A7,USP
(MOVE.L  D0,A7           ; SSP wiederherstellen
(
(MOVE    SR,D0
(ANDI    #$C0FF,D0
(ANDI    #$0F00,D1
(OR      D1,D0
(MOVE    D0,SR
(MOVE.L  (A7)+,D0
(MOVE.L  (A7)+,D2
(RTS
(
&alreadySuper
(ADDQ.L  #6,A7
(MOVE.W  (A7)+,D1
(MOVE    SR,D0
(ANDI    #$F0FF,D0
(ANDI    #$0F00,D1
(OR      D1,D0
(MOVE    D0,SR
(MOVE.L  (A7)+,D0
(MOVE.L  (A7)+,D2
$END
"END @PRIO;
 
 (**********************  Ende der Coroutinen  ***********************)
 
 
 PROCEDURE @STK1;  (* Stack-Check mit festem $200-Space *)
"BEGIN
$ASSEMBLER
(LEA     $200(A3),A0
(CMPA.L  A7,A0
(BCC     stackerror
(RTS
&stackerror
(TRAP    #6
(DC.W    $BFF6    ; Stack overflow, caller caused
$END
"END @STK1;
 
 PROCEDURE @STK2;  (* Stack-Check mit variablem Space *)
"BEGIN
$ASSEMBLER
(; A0: Check-Wert
(ADDA.L  A3,A0
(CMPA.L  A7,A0
(BCC     stackerror
(RTS
&stackerror
(TRAP    #6
(DC.W    $BFF6    ; Stack overflow, caller caused
$END
"END @STK2;
 
 
 PROCEDURE @ROTA;
"BEGIN
$ASSEMBLER
(; D0: Argument, D1: Weite, D2: maxBitNr, (A0: minBitNr)
(TST.W   D1
(BMI     right
(BEQ     ende
(SUBQ.W  #7,D2
(BEQ     bytel
(SUBQ.W  #8,D2
(BEQ     wordl
(ROL.L   D1,D0
(RTS
 bytel:  ROL.B   D1,D0
(RTS
 wordl:  ROL.W   D1,D0
 ende:   RTS
 right:  NEG.W   D1
(SUBQ.W  #7,D2
(BEQ     byter
(SUBQ.W  #8,D2
(BEQ     wordr
(ROR.L   D1,D0
(RTS
 byter:  ROR.B   D1,D0
(RTS
 wordr:  ROR.W   D1,D0
$END
"END @ROTA;
 
 PROCEDURE @SHFT;
"BEGIN
$ASSEMBLER
(; D0: Argument, D1: Weite, D2: maxBitNr, (A0: minBitNr)
(TST.W   D1
(BMI     right
(BEQ     ende
(CMP.W   D2,D1
(BHI     null
(LSL.L   D1,D0
(RTS
 null:   MOVEQ   #0,D0
 ende:   RTS
 right:  NEG.W   D1
(CMP.W   D2,D1
(BHI     null
(LSR.L   D1,D0
$END
"END @SHFT;
 
 
 PROCEDURE @LENW;
"BEGIN
$ASSEMBLER
(; A0: Ptr auf String, D0.W: HIGH (String) / Erg., D1 ist frei
(MOVE.L  A0,D1
 l       TST.B   (A0)+
(DBEQ    D0,l
(BNE     c
(SUBQ.L  #1,A0
 c       MOVE.L  A0,D0
(SUB.L   D1,D0
$END
"END @LENW;
 
 PROCEDURE @LENL;
"BEGIN
$ASSEMBLER
(; A0: Ptr auf String, D0.L: HIGH (String) / Erg., D1 ist frei
(MOVE.L  A0,D1
(BRA     l
 l2      SWAP    D0
 l       TST.B   (A0)+
(DBEQ    D0,l
(BEQ     d
(SWAP    D0
(DBRA    D0,l2
(BRA     c
 d       SUBQ.L  #1,A0
 c       MOVE.L  A0,D0
(SUB.L   D1,D0
$END
"END @LENL;
 
 
 (*****************************************************************************)
 (***                          SET - Operationen                            ***)
 (*****************************************************************************)
 
 
 PROCEDURE @EXCL; (* Exclude Element aus Set *)
"BEGIN
$ASSEMBLER
(; A0: Ptr auf Set; D0.W: Element; D1 frei
(; Range-Check mu auerhalb gemacht werden!
(MOVE.W  D0,D1
(LSR.W   #3,D0
(BCLR    D1,0(A0,D0.W)
$END
"END @EXCL;
"
 PROCEDURE @INCL; (* Include Element in Set *)
"BEGIN
$ASSEMBLER
(; A0: Ptr auf Set; D0.W: Element; D1 frei
(; Range-Check mu auerhalb gemacht werden!
(MOVE.W  D0,D1
(LSR.W   #3,D0
(BSET    D1,0(A0,D0.W)
&END
$END @INCL;
 
 PROCEDURE @SIRG; (* INCL (set, lo..hi) *)
"BEGIN
$ASSEMBLER
(; A0: ^Set, D0: lo, D1: hi, D2: Size(set), A1,A2 frei
(; A0 nicht zerstren!
(CMP     D1,D0
(BHI.W   over            ; Lo > Hi
(
(LSL     #3,D2
(CMP     D2,D1
(BCS     sizeOK
(MOVE    D2,D1
(SUBQ    #1,D1
(LINK    A5,#0
(TRAP    #6
(DC.W    -6-$4000          ; Out of range
(UNLK    A5
&sizeOK
(
(MOVE.L  A0,A2
(MOVE.L  A0,A1
(MOVE    D0,D2
(LSR     #3,D2
(ADDA.W  D2,A2
(MOVE    D1,D2
(LSR     #3,D2
(ADDA.W  D2,A1
(
(ANDI    #7,D0
(ANDI    #7,D1
(
(CMPA.L  A2,A1
(BEQ     lastByte
(
(; das erste Byte mit einzelnen BSETs setzen, wenn es nicht vollst.
(; gefllt wird
(TST     D0
(BEQ     fullByte
(
(MOVE.B  (A2),D2
&partByte
(BSET    D0,D2
(ADDQ    #1,D0
(CMPI.B  #8,D0
(BNE     partByte
(MOVE.B  D2,(A2)+
(CLR     D0
(
(CMPA.L  A2,A1
(BEQ     lastByte
(
&fullByte
(MOVE.L  A1,D2
(SUB.L   A2,D2
(SUBQ    #1,D2
&fullFill
(MOVE.B  #$FF,(A2)+
(DBRA    D2,fullFill
(
&lastByte
(CMPI    #7,D1
(BEQ     lastFull
(
(MOVE.B  (A2),D2
&lastLoop
(BSET    D0,D2
(ADDQ    #1,D0
(CMP     D1,D0
(BLS     lastLoop
(MOVE.B  D2,(A2)
(BRA     ende
(
&lastFull
(MOVE.B  #$FF,(A2)
(
&ende
(
&over      ; Lo > Hi
$END
"END @SIRG;
 
 PROCEDURE @SMEM; (* IN-Operator auf Sets *)
"BEGIN
$ASSEMBLER
(; A0: Ptr auf Set; D1.W: Lnge des Sets in Bytes;
(; D0.W: Element; D2 frei;
(; Ergebnis in Z-Flag: ne -> TRUE
(; Die Routine ist fr variable Elementnr. vorgesehen und dazu wird
(; hierin auch geprft, ob die Elementnr. auerhalb des Sets liegt.
(; Bei konstanter Elementnr. sollte dagegen der Code direkt erzeugt
(; werden.
(MOVE.W  D0,D2
(LSR.W   #3,D0
(CMP.W   D1,D0
(BCC     NOMEM
(BTST    D2,0(A0,D0.W)
(RTS
&NOMEM
(MOVEQ   #0,D1   ; FALSE (eq)
$END
"END @SMEM;
 
 PROCEDURE @SEQL; (* '=' auf Sets *)
"BEGIN
$ASSEMBLER
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Bytes - 1 DIV 2
(; Ergebnis in Z-Flag: eq -> TRUE
&L CMPM.W  (A0)+,(A1)+
(DBNE    D0,L
$END
"END @SEQL;
 
 PROCEDURE @SLEQ; (* '<=' auf Sets *)
"BEGIN
$ASSEMBLER
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; D1 ist frei; Ergebnis in Z-Flag
&L MOVE    (A1)+,D1
(NOT     D1
(AND     (A0)+,D1
(DBNE    D0,L
$END
"END @SLEQ;
 
 
 PROCEDURE @SAN1; (* '*' auf Sets *)
"BEGIN
$ASSEMBLER
(; rechter Wert auf A3, linker in Var -> auf A3 berschreiben
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A1: Ziel-Set; D1 frei
&L MOVE    (A0),D1
(AND     D1,(A1)+
(DBRA    D0,L
$END
"END @SAN1;
 
 PROCEDURE @SAN2;
"BEGIN
$ASSEMBLER
(; linker Wert schon auf A3, rechter in Var -> auf A3 berschreiben
(; auch verwenden, wenn rechter auf A3: dann erst A3 korrigieren
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A0: Ziel-Set; D1 frei
&L MOVE    (A1)+,D1
(AND     D1,(A0)+
(DBRA    D0,L
$END
"END @SAN2;
 
 PROCEDURE @SAND;
"BEGIN
$ASSEMBLER
(; beide Wert in Vars -> Erg. nach (A3)+
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; D1 frei
&L MOVE    (A1)+,D1
(AND     (A0)+,D1
(MOVE    D1,(A3)+
(DBRA    D0,L
$END
"END @SAND;
 
 PROCEDURE @SXO1; (* '/' auf Sets *)
"BEGIN
$ASSEMBLER
(; rechter Wert auf A3, linker in Var -> auf A3 berschreiben
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A1: Ziel-Set; D1 frei
&L MOVE    (A0),D1
(EOR     D1,(A1)+
(DBRA    D0,L
$END
"END @SXO1;
 
 PROCEDURE @SXO2;
"BEGIN
$ASSEMBLER
(; linker Wert schon auf A3, rechter in Var -> auf A3 berschreiben
(; auch verwenden, wenn rechter auf A3: dann erst A3 korrigieren
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A0: Ziel-Set; D1 frei
&L MOVE    (A1)+,D1
(EOR     D1,(A0)+
(DBRA    D0,L
$END
"END @SXO2;
 
 PROCEDURE @SXOR;
"BEGIN
$ASSEMBLER
(; beide Wert in Vars -> Erg. nach (A3)+
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; D1,D2 frei
&L MOVE    (A1)+,D1
(MOVE    (A0)+,D2
(EOR     D2,D1
(MOVE    D1,(A3)+
(DBRA    D0,L
$END
"END @SXOR;
 
 PROCEDURE @SSU1; (* '+' auf Sets *)
"BEGIN
$ASSEMBLER
(; rechter Wert auf A3, linker in Var -> auf A3 berschreiben
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A1: Ziel-Set; D1 frei
&L MOVE    (A0),D1
(OR      D1,(A1)+
(DBRA    D0,L
$END
"END @SSU1;
 
 PROCEDURE @SSU2;
"BEGIN
$ASSEMBLER
(; linker Wert schon auf A3, rechter in Var -> auf A3 berschreiben
(; auch verwenden, wenn rechter auf A3: dann erst A3 korrigieren
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A0: Ziel-Set; D1 frei
&L MOVE    (A1)+,D1
(OR      D1,(A0)+
(DBRA    D0,L
$END
"END @SSU2;
 
 PROCEDURE @SSUM;
"BEGIN
$ASSEMBLER
(; beide Wert in Vars -> Erg. nach (A3)+
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; D1 frei
&L MOVE    (A1)+,D1
(OR      (A0)+,D1
(MOVE    D1,(A3)+
(DBRA    D0,L
$END
"END @SSUM;
 
 PROCEDURE @SDI1; (* '-' auf Sets *)
 BEGIN
$ASSEMBLER
(; rechter Wert auf A3, linker in Var -> auf A3 berschreiben
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A1: Ziel-Set; D1 frei
&L MOVE    (A1),D1
(NOT     D1
(AND     (A0)+,D1
(MOVE    D1,(A1)+
(DBRA    D0,L
$END
"END @SDI1;
 
 PROCEDURE @SDI2;
"BEGIN
$ASSEMBLER
(; linker Wert schon auf A3, rechter in Var -> auf A3 berschreiben
(; auch verwenden, wenn rechter auf A3: dann erst A3 korrigieren
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; A0: Ziel-Set; D1 frei
&L MOVE    (A1)+,D1
(NOT     D1
(AND     D1,(A0)+
(DBRA    D0,L
$END
"END @SDI2;
 
 PROCEDURE @SDIF;
"BEGIN
$ASSEMBLER
(; beide Wert in Vars -> Erg. nach (A3)+
(; A0, A1: Ptr auf Sets; D0.W: Setlnge in Words - 1
(; D1 frei
&L MOVE    (A1)+,D1
(NOT     D1
(AND     (A0)+,D1
(MOVE    D1,(A3)+
(DBRA    D0,L
$END
"END @SDIF;
 
 
 
 (*********** Longint - Arithmetik ***********)
 
 PROCEDURE @IMLW;
"BEGIN
$ASSEMBLER
 (*$? Code20:
(EXT.L   D1
(MULS.L  D1,D0
 *)
 (*$? NOT Code20:
(; D1 mu positiv und <= MaxInt sein!
(TST.L   D0
(BPL.S   mul
(NEG.L   D0
(BSR.S   mul
(BVS     ende
(NEG.L   D0
!ende   RTS
!mul    MOVE.W  D0,D2
(MULU    D1,D2   ; loD1 * loD0
(SWAP    D0
(MULU    D1,D0   ; loD1 * hiD0
(SWAP    D0
(TST.W   D0
(BNE.S   over
(ADD.L   D2,D0
(BMI     over
(RTS
!over   MOVEQ   #0,D0
(ORI     #2,CCR  ; Overflow-Bit setzen
 *)
$END
"END @IMLW;
 
 PROCEDURE @CMLW;
"BEGIN
$ASSEMBLER
 (*$? Code20:
(MOVEQ   #0,D2
(MOVE.W  D1,D2
(MULU.L  D2,D0
(BVS     over
(RTS
 *)
 (*$? NOT Code20:
(MOVE.W  D0,D2
(MULU    D1,D2   ; loD1 * loD0
(SWAP    D0
(MULU    D1,D0   ; loD1 * hiD0
(SWAP    D0
(TST.W   D0
(BNE.S   over
(ADD.L   D2,D0
(RTS
 *)
!over   MOVEQ   #0,D0
(ORI     #1,CCR  ; Carry-Bit setzen
$END
"END @CMLW;
 
 PROCEDURE @IDVW;
"BEGIN
$ASSEMBLER
(; D1 darf nicht Null sein
 (*$? Code20:
(EXT.L   D1
(DIVS.L  D1,D0
 *)
 (*$? NOT Code20:
(; D0.L := D0.L / D1.W
(DIVS    D1,D0   ; erstmal probiern, ob's so geht
(BVS     over
(EXT.L   D0
(RTS
&over              ; ging nicht -> dann eben anders
(; das geht so:
(;  ab / c = ?
(; zuerst wird a/c gerechnet, das Erg. als High-Word genommen.
(; ein berlauf kann dabei nicht auftreten.
(; dann wird der Rest genommen, ins High-Word getan, b aufaddiert
(; und das wieder durch c geteilt. Das ist dann das Low-Word des
(; Ergebnisses. Ein berlauf drfte auch hier nicht auftreten.
(SWAP    D0      ; b retten, a ins Low-Word laden
(MOVE.W  D0,D2
(EXT.L   D2
(DIVS    D1,D2   ; a / c : D2.uW = Rest, D2.lW = Erg.
(MOVE.W  D2,D0   ; 1. Teil vom Erg.
(SWAP    D0      ; b zurck, High-Word vom Erg. setzen
(MOVE.W  D0,D2   ; 'b' auf Rest addieren
(DIVU    D1,D2   ; b / c
(MOVE    D2,D0   ; Low-Word vom Erg. einsetzen
 *)
$END
"END @IDVW;
 
 PROCEDURE @CDVW;
"BEGIN
$ASSEMBLER
 (*$? Code20:
(MOVEQ   #0,D2
(MOVE.W  D1,D2
(DIVU.L  D2,D0
 *)
 (*$? NOT Code20:
(; D0.L := D0.L / D1.W
(DIVU    D1,D0   ; erstmal probiern, ob's so geht
(BVS     over
(SWAP    D0
(CLR.W   D0
(SWAP    D0
(RTS
&over              ; ging nicht -> dann eben anders
(SWAP    D0      ; b retten, a ins Low-Word laden
(MOVEQ   #0,D2
(MOVE.W  D0,D2
(DIVU    D1,D2   ; a / c : D2.uW = Rest, D2.lW = Erg.
(MOVE.W  D2,D0   ; 1. Teil vom Erg.
(SWAP    D0      ; b zurck, High-Word vom Erg. setzen
(MOVE.W  D0,D2   ; 'b' auf Rest addieren
(DIVU    D1,D2   ; b / c
(MOVE    D2,D0   ; Low-Word vom Erg. einsetzen
 *)
$END
"END @CDVW;
 
 PROCEDURE @IMDW;
"BEGIN
$ASSEMBLER
(; D0.L := D0.L MOD D1.W (D1#0)
 (*$? Code20:
(EXT.L   D1
(DIVSL.L D1,D1:D0
(MOVE.L  D1,D0
 *)
 (*$? NOT Code20:
(DIVS    D1,D0   ; erstmal probiern, ob's so geht
(BVS     over
(SWAP    D0      ; Erg. pat immer in WORD
(EXT.L   D0
(RTS
&over              ; ging nicht -> dann eben anders
(; das geht so:
(;  ab / c = ? -> Rest liefern
(; zuerst wird a/c gerechnet. ein berlauf kann dabei nicht auftreten.
(; dann wird der Rest genommen, ins High-Word getan, b aufaddiert
(; und das wieder durch c geteilt. Nun haben wir den Rest im High-Word,
(; der nur noch umgeladen werden mu (das Erg. ist IMMER Word-Size!)
(MOVE.W  D0,D2   ; b retten
(SWAP    D0      ; a ins Low-Word laden
(EXT.L   D0
(DIVS    D1,D0   ; a / c : D0.uW = Rest
(MOVE.W  D2,D0   ; 'b' auf Rest addieren
(DIVS    D1,D0   ; b / c
(SWAP    D0      ; High-Word (Rest) als Erg. liefern
(EXT.L   D0
 *)
$END
"END @IMDW;
 
 PROCEDURE @CMDW;
"BEGIN
$ASSEMBLER
(; D0.L := D0.L MOD D1.W (D1#0)
 (*$? Code20:
(MOVEQ   #0,D2
(MOVE.W  D1,D2
(DIVUL.L D2,D1:D0
(MOVE.L  D1,D0
 *)
 (*$? NOT Code20:
(DIVU    D1,D0   ; erstmal probiern, ob's so geht
(BVS     over
(CLR.W   D0
(SWAP    D0      ; Erg. pat immer in WORD
(RTS
&over              ; ging nicht -> dann eben anders
(; das geht so:
(;  ab / c = ? -> Rest liefern
(; zuerst wird a/c gerechnet. ein berlauf kann dabei nicht auftreten.
(; dann wird der Rest genommen, ins High-Word getan, b aufaddiert
(; und das wieder durch c geteilt. Nun haben wir den Rest im High-Word,
(; der nur noch umgeladen werden mu (das Erg. ist IMMER Word-Size!)
(MOVE.W  D0,D2   ; b retten
(CLR.W   D0
(SWAP    D0      ; a ins Low-Word laden
(DIVU    D1,D0   ; a / c : D0.uW = Rest
(MOVE.W  D2,D0   ; 'b' auf Rest addieren
(DIVU    D1,D0   ; b / c
(CLR.W   D0
(SWAP    D0      ; High-Word (Rest) als Erg. liefern
 *)
$END
"END @CMDW;
 
 PROCEDURE @IMLL;
"BEGIN
$ASSEMBLER
 (*$? Code20:
(MULS.L  D1,D0
 *)
 (*$? NOT Code20:
(TST.L   D0
(BPL.S   l1
(NEG.L   D0
(TST.L   D1
(BPL.S   l2
(NEG.L   D1
(BRA.S   mul
%l1 TST.L   D1
(BPL.S   mul
(NEG.L   D1
%l2 BSR.S   mul
(BVS     ende
(NEG.L   D0
#ende RTS
 
$mul MOVE.W  D0,D2
(MULU    D1,D2   ; loD1 * loD0
(SWAP    D0
(TST.W   D0
(BEQ.S   d0word  ; hiD0 = 0  ->  hiD1 * loD0 
(MULU    D1,D0   ; loD1 * hiD0
(SWAP    D0
(TST.W   D0
(BNE.S   over
(SWAP    D1
(TST.W   D1
(BNE     over    ; hiD1 # 0  -> overflow
(ADD.L   D2,D0
(BMI     over
(RTS
!d0word SWAP    D0
(SWAP    D1
(MULU    D1,D0   ; hiD1 * loD0
(SWAP    D0
(TST.W   D0
(BNE     over
(ADD.L   D2,D0
(BMI     over
(RTS
!over   MOVEQ   #0,D0
(ORI     #2,CCR  ; Overflow-Bit setzen
 *)
$END
"END @IMLL;
 
 PROCEDURE @CMLL;
"BEGIN
$ASSEMBLER
 (*$? Code20:
(MULU.L  D1,D0
(BVS     over
(RTS
 *)
 (*$? NOT Code20:
(MOVE.W  D0,D2
(MULU    D1,D2   ; loD1 * loD0
(SWAP    D0
(TST.W   D0
(BEQ.S   d0word  ; hiD0 = 0  ->  hiD1 * loD0 
(MULU    D1,D0   ; loD1 * hiD0
(SWAP    D0
(TST.W   D0
(BNE.S   over
(SWAP    D1
(TST.W   D1
(BNE     over    ; hiD1 # 0  -> overflow
(ADD.L   D2,D0
(RTS
!d0word SWAP    D0
(SWAP    D1
(MULU    D1,D0   ; hiD1 * loD0
(SWAP    D0
(TST.W   D0
(BNE     over
(ADD.L   D2,D0
(RTS
 *)
!over   MOVEQ   #0,D0
(ORI     #1,CCR  ; Carry-Bit setzen
$END
"END @CMLL;
 
 
 PROCEDURE @IDVL;
 BEGIN
#ASSEMBLER
 (*$? Code20:
(TST.L   D1
(BEQ     zero
(DIVS.L  D1,D0
(RTS
 *)
 (*$? NOT Code20:
(MOVEM.L D4-D5,-(A7)
(CLR.W  D5
(TST.L  D1
(BEQ    IDERR
(BPL    IDIV5
(NEG.L  D1
(MOVEQ  #1,D5
 !IDIV5  TST.L  D0
(BPL    IDIV6
(NEG.L  D0
(BCHG   #0,D5
 !IDIV6  CLR.L  D2
(CLR.L  D4
(CMP.L  D1,D0
(BLS    IDIV2
 !IDIV1  ADD.L  D1,D1
(ADDQ.W #1,D2
(CMP.L  D1,D0
(BHI    IDIV1
(BRA    IDIV2
 !IDIV3  LSR.L  #1,D1
 !IDIV2  ADD.L  D4,D4
(CMP.L  D1,D0
(BCS    IDIV4
(SUB.L  D1,D0
(ADDQ.W #1,D4
 !IDIV4  DBF    D2,IDIV3
(TST.W  D5
(BEQ    IDIV7
(NEG.L  D4
 !IDIV7  MOVE.L D4,D0
(MOVEM.L (A7)+,D4-D5
(RTS
(
 !IDERR  MOVEM.L (A7)+,D4-D5
 *)
 zero    LINK    A5,#0
(TRAP    #6          ; Div by zero
(DC.W    -5-$4000
(MOVEQ   #0,D0
(UNLK    A5
$END
 END @IDVL;
 
 PROCEDURE @CDVL;
 BEGIN
 ASSEMBLER
 (*$? Code20:
(TST.L   D1
(BEQ     zero
(DIVU.L  D1,D0
(RTS
 *)
 (*$? NOT Code20:
'MOVE.L D3,-(A7)
'TST.L  D1
'BEQ    CDERR
'CLR.L  D2
'CLR.L  D3
'TST.L  D1
'BMI    CDIV2
 !CDIV1 CMP.L  D1,D0
'BLS    CDIV2
'ADDQ   #1,D2
'ADD.L  D1,D1
'BPL    CDIV1
 !CDIV2 ADD.L  D3,D3
'CMP.L  D1,D0
'BCS    CDIV3
'SUB.L  D1,D0
'ADDQ   #1,D3
 !CDIV3 LSR.L  #1,D1
'DBF    D2,CDIV2
'MOVE.L D3,D0
'MOVE.L (A7)+,D3
'RTS
'
 !CDERR MOVE.L (A7)+,D3
 *)
 zero   LINK   A5,#0
'TRAP    #6          ; Div by zero
'DC.W    -5-$4000
'MOVEQ   #0,D0
'UNLK   A5
 END
 END @CDVL;
 
 PROCEDURE @IMDL;
 BEGIN
 ASSEMBLER
 (*$? Code20:
(TST.L   D1
(BEQ     zero
(DIVSL.L D1,D1:D0
(MOVE.L  D1,D0
(RTS
 *)
 (*$? NOT Code20:
'MOVE.L D5,-(A7)
'CLR.W  D5
'CLR.L  D2
'TST.L  D1
'BEQ    IMODER
'BPL    IMOD2
'NEG.L  D1
 !IMOD2 TST.L  D0
'BPL    IMOD1
'NEG.L  D0
'MOVEQ  #1,D5
'CMP.L  D1,D0
'BLS    IMOD5
 !IMOD1 ADD.L  D1,D1
'ADDQ.W #1,D2
'CMP.L  D1,D0
'BHI    IMOD1
'BRA    IMOD5
 !IMOD3 LSR.L  #1,D1
 !IMOD5 CMP.L  D1,D0
'BCS    IMOD4
'SUB.L  D1,D0
 !IMOD4 DBEQ   D2,IMOD3
'TST.W  D5
'BEQ    IMOD6
'NEG.L  D0
 !IMOD6 MOVE.L (A7)+,D5
'RTS
'
 IMODER MOVE.L (A7)+,D5
 *)
 zero   LINK   A5,#0
'TRAP    #6          ; Div by zero
'DC.W    -5-$4000
'MOVEQ   #0,D0
'UNLK   A5
#END
 END @IMDL;
 
 PROCEDURE @CMDL;
 BEGIN
 ASSEMBLER
 (*$? Code20:
(TST.L   D1
(BEQ     zero
(DIVUL.L D1,D1:D0
(MOVE.L  D1,D0
(RTS
 *)
 (*$? NOT Code20:
'MOVE.L D3,-(A7)
'TST.L  D1
'BEQ    CMERR
'CLR.L  D2
'MOVE.L D1,D3
'BMI    CMOD2
 !CMOD1 CMP.L  D1,D0
'BLS    CMOD2
'ADDQ   #1,D2
'ADD.L  D1,D1
'BPL    CMOD1
 !CMOD2 CMP.L  D1,D0
'BCS    CMOD3
'SUB.L  D1,D0
 !CMOD3 LSR.L  #1,D1
'CMP.L  D0,D3
'DBHI   D2,CMOD2
'
'MOVE.L (A7)+,D3
'RTS
'
 !CMERR MOVE.L (A7)+,D3
 *)
 zero   LINK   A5,#0
'TRAP    #6          ; Div by zero
'DC.W    -5-$4000
'MOVEQ   #0,D0
'UNLK   A5
#END
 END @CMDL;
 
 
 PROCEDURE @IMUL (a,b:LONGINT):LONGINT;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(JSR     @IMLL
(MOVE.L  D0,(A3)+
$END
"END @IMUL;
 
 PROCEDURE @CMUL (a,b:LONGCARD):LONGCARD;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(JSR     @CMLL
(MOVE.L  D0,(A3)+
$END
"END @CMUL;
 
 PROCEDURE @IDIV (a,b:LONGINT):LONGINT;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(JSR     @IDVL
(MOVE.L  D0,(A3)+
$END
"END @IDIV;
 
 PROCEDURE @CDIV (a,b:LONGCARD):LONGCARD;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(JSR     @CDVL
(MOVE.L  D0,(A3)+
$END
"END @CDIV;
 
 PROCEDURE @IMOD (a,b:LONGINT):LONGINT;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(JSR     @IMDL
(MOVE.L  D0,(A3)+
$END
"END @IMOD;
 
 PROCEDURE @CMOD (a,b:LONGCARD):LONGCARD;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(JSR     @CMDL
(MOVE.L  D0,(A3)+
$END
"END @CMOD;
 
 
 PROCEDURE @STAS;
 (* D0: LAENGE DES SOURCESTRING/BYTE; D1: LAENGE DEST.STRING/BYTE *)
 BEGIN
#ASSEMBLER
'JMP     HALT
 (*
'MOVE.L  A3,A0
'MOVE.L  D0,D2
'ADDQ.L  #1,D0     ; D0 als StackOffset: muss synch. werden!
'ANDI.W  #$FFFE,D0 ; nicht BCLR verwenden, sonst Fehler bei DBEQ (unten)
'SUBA.L  D0,A0     ; A0 zeigt auf Sourcestring
'BRA     y
$
$z  SWAP    D1        ;*** Kopierschleife
$x  SUBQ.L  #1,D2
'BCS     ok2       ; Source-Ende, Dest. muss Endmarke bekommen
'MOVE.B  (A0)+,(A4)+
$y  DBEQ    D1,x
'BEQ     ok        ; Endmarke der Source wurde eben kopiert
'SWAP    D1
'DBF     D1,z
'
'TST.L   D2        ;*** Ende der Schleife, weil Dest voll
'BEQ     ok        ; Source komplett kopiert (hatte keine Endmarke)
'TST.B   (A0)
'BEQ     ok        ; sonst muss die Endmarke das naechste Zeichen sein
'SUBA.L  D0,A3     ; leider nein: String Overflow
'TRAP    #6
'DC.W    -8-$4000
#ok2 CLR.B   (A4)+
#ok  SUBA.L  D0,A3
 *)
#END
 END @STAS;
 
 (* ************************************************************************ *)
 (*
!*   Kopieren von Open Arrays
!*)
 
 PROCEDURE @CWOP;
"BEGIN
$ASSEMBLER
(; Byte-Open Array auf Stack kopieren: Ptr/High auf A3, Daten auf A7
(; A0: Ptr auf Source-Desc aus Ptr und High.W, D0 nicht benutzen,
(; D1/D2/A1/A2 frei
(MOVE.L  (A0)+,A1        ; Ptr auf Source-Array
(MOVE.W  (A0),D1         ; HIGH
(
(ADDQ.L  #4,A3
(MOVE.W  D1,(A3)+
(
(LSR.W   #1,D1           ; HIGH durch 2 teilen f. Kopierschl. m. 2 Bytes
(
(; HIGH / 2 + 1 * 2 von A7 als Ziel-Stack abziehen
(MOVE.L  (A7)+,A2
(MOVEQ   #0,D2
(MOVE    D1,D2
(ADDQ.W  #1,D2
(ADD.L   D2,D2
(SUBA.L  D2,A7
(MOVE.L  A7,A0
(
(MOVE.L  A7,-6(A3)
(
(MOVE.W  A1,D2           ; bei gerader Adr. Words kopieren
(LSR.W   #1,D2
(BCS.S   ODDL
(
&EVL
(MOVE.W  (A1)+,(A0)+
(DBRA    D1,EVL
(JMP     (A2)
(
&ODDL
(MOVE.B  (A1)+,(A0)+
(MOVE.B  (A1)+,(A0)+
(DBRA    D1,ODDL
(JMP     (A2)
$END
"END @CWOP;
 
 PROCEDURE @CLOP;
"BEGIN
$ASSEMBLER
(; Byte-Open Array auf Stack kopieren: Ptr/High auf A3, Daten auf A7
(; A0: Ptr auf Source-Desc aus Ptr und High.L, D0 nicht benutzen,
(; D1/D2/A1/A2 frei
(MOVE.L  (A0)+,A1        ; Ptr auf Source-Array
(MOVE.L  (A0),D1         ; HIGH
(
(ADDQ.L  #4,A3
(MOVE.L  D1,(A3)+
(
(LSR.L   #1,D1           ; HIGH durch 2 teilen f. Kopierschl. m. 2 Bytes
(
(; HIGH / 2 + 1 * 2 von A7 als Ziel-Stack abziehen
(MOVE.L  (A7)+,A2
(MOVE.L  D1,D2
(ADDQ.L  #1,D2
(ADD.L   D2,D2
(SUBA.L  D2,A7
(MOVE.L  A7,A0
(
(MOVE.L  A7,-8(A3)
(
(MOVE.W  A1,D2           ; bei gerader Adr. Words kopieren
(LSR.W   #1,D2
(BCC.S   EVL
(BRA.S   ODDL
(
&ODDL2
(SWAP    D1
&ODDL
(MOVE.B  (A1)+,(A0)+
(MOVE.B  (A1)+,(A0)+
(DBRA    D1,ODDL
(SWAP    D1
(DBRA    D1,ODDL2
(JMP     (A2)
(
&EVL2
(SWAP    D1
&EVL
(MOVE.W  (A1)+,(A0)+
(DBRA    D1,EVL
(SWAP    D1
(DBRA    D1,EVL2
(JMP     (A2)
$END
"END @CLOP;
 
 PROCEDURE @PS7B;
"BEGIN
$ASSEMBLER
(; -- push onto A7 --
(; A0: addr of ptr to copied data
(; A1: source
(; D2,A2: free
(; D1.L: count
(
(move.l  (a7)+,A2          ;Ruecksprung-Adr
(
(; Platzbedarf ausrechnen
(
(addq.l  #1,d1             ;lnge in byte synchronisieren
(bclr    #0,d1
(
(; Platz reservieren, Pointer bereitstellen
&
(suba.l  d1,a7
(move.l  a7,(a0)
(movea.l a7,a0             ;^ fuer Kopierschleife
(
(; Kopierschleife
(
(bra     lp2
#lp1  swap    d1
#lp   move.b  (A1)+,(a0)+       ;schoen langsam umkopieren...
#lp2  dbf     d1,lp
(swap    d1
(dbf     d1,lp1
(
(jmp     (A2)              ;zurueck zum Aufrufer
$END
"END @PS7B;
 
 PROCEDURE @PS7W;
"BEGIN
$ASSEMBLER
(; -- push onto A7 --
(; A0: addr of ptr to copied data
(; A1: source
(; D2,A2: free
(; D1.L: count
(
(move.l  (a7)+,A2          ;Ruecksprung-Adr
(
(; Platz reservieren, Pointer bereitstellen
&
(move.l  d1,d2
(add.l   d2,d2
(suba.l  d2,a7
(move.l  a7,(a0)
(movea.l a7,a0             ;^ fuer Kopierschleife
(
(; Kopierschleife
(
(bra     lp2
#lp1  swap    d1
#lp   move.w  (A1)+,(a0)+
#lp2  dbf     d1,lp
(swap    d1
(dbf     d1,lp1
(
(jmp     (A2)              ;zurueck zum Aufrufer
$END
"END @PS7W;
 
 PROCEDURE @PS7L;
"BEGIN
$ASSEMBLER
(; -- push onto A7 --
(; A0: addr of ptr to copied data
(; A1: source
(; D2,A2: free
(; D1.L: count
(
(move.l  (a7)+,A2          ;Ruecksprung-Adr
(
(; Platz reservieren, Pointer bereitstellen
&
(move.l  d1,d2
(lsl.l   #2,d2
(suba.l  d2,a7
(move.l  a7,(a0)
(movea.l a7,a0             ;^ fuer Kopierschleife
(
(; Kopierschleife
(
(bra     lp2
#lp1  swap    d1
#lp   move.l  (A1)+,(a0)+
#lp2  dbf     d1,lp
(swap    d1
(dbf     d1,lp1
(
(jmp     (A2)              ;zurueck zum Aufrufer
$END
"END @PS7L;
 
 
 PROCEDURE @PS3B;
"BEGIN
$ASSEMBLER
(; -- push onto A3 --
(; A1: source
(; D1.L: count
(
(; Kopierschleife
(
(addq.l  #1,d1             ;lnge in byte synchronisieren
(bclr    #0,d1
(
(bra     lp2
#lp1  swap    d1
#lp   move.b  (A1)+,(a3)+       ;schn langsam umkopieren...
#lp2  dbf     d1,lp
(swap    d1
(dbf     d1,lp1
$END
"END @PS3B;
 
 PROCEDURE @PS3W;
"BEGIN
$ASSEMBLER
(; -- push onto A3 --
(; A1: source
(; D1.L: count
(
(; Kopierschleife
(
(bra     lp2
#lp1  swap    d1
#lp   move.w  (A1)+,(a3)+
#lp2  dbf     d1,lp
(swap    d1
(dbf     d1,lp1
$END
"END @PS3W;
 
 PROCEDURE @PS3L;
"BEGIN
$ASSEMBLER
(; -- push onto A3 --
(; A1: source
(; D1.L: count
(
(; Kopierschleife
(
(bra     lp2
#lp1  swap    d1
#lp   move.l  (A1)+,(a3)+
#lp2  dbf     d1,lp
(swap    d1
(dbf     d1,lp1
$END
"END @PS3L;
 
 (* ************************************************************************ *)
 
 PROCEDURE @COPW;
"BEGIN
$ASSEMBLER
(; A0: dest, A1: source, D0.W: bytes
(; D1 ist frei
(; A0 mu hinterher hinter Ziel zeigen!
(MOVE.W  A0,D1
(LSR.W   #1,D1
(BCS.S   ODD0
(MOVE.W  A1,D1
(LSR.W   #1,D1
(BCC.S   EVEN
(BRA.S   ODD0
&ODDL
(MOVE.B  (A1)+,(A0)+
&ODD0
(DBRA    D0,ODDL
(RTS
&EVEN
(MOVE    D0,D1
(ANDI    #3,D1
(LSR.W   #2,D0
(BRA     EV2
&EVL
(MOVE.L  (A1)+,(A0)+
&EV2
(DBRA    D0,EVL
(DBRA    D1,EV3
(RTS
&EV3
(MOVE.B  (A1)+,(A0)+
(DBRA    D1,EV3
$END
"END @COPW;
 
 PROCEDURE @COPL;
"BEGIN
$ASSEMBLER
(; A0: dest, A1: source, D0.L: bytes
(; D1/D2/A2 sind frei
(; A0 mu hinterher hinter Ziel zeigen!
(MOVE.L  A1,(A3)+
(MOVE.L  D0,(A3)+
(MOVE.L  A0,(A3)+
(ADDA.L  D0,A0
(MOVE.L  A0,-(A7)
(JSR     Block.Copy
(MOVE.L  (A7)+,A0
$END
"END @COPL;
 
 (* ************************************************************************ *)
 
 PROCEDURE @CAP;
 BEGIN
"ASSEMBLER
(LEA     tab(PC),A2
(MOVE.B  0(A2,D0.W),D0
(RTS
"
"tab:  DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B ' ','!','"','#','$','%','&',$27,'(',')','*','+',',','-','.','/'
(DC.B '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?'
(DC.B '@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','[','\',']','^','_'
(DC.B '`','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','{','|','}','~',''
(DC.B '','','','A','','','','','E','E','E','I','I','I','',''
(DC.B '','','','O','','O','U','U','','','','','','','',''
(DC.B 'A','I','O','U','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
"END
 END @CAP;
 
 
 PROCEDURE HALT;
 BEGIN
"ASSEMBLER
(LINK    A5,#0
(TRAP    #6
(DC.W    -11-$4000
(UNLK    A5
"END
 END HALT;
 
 
 
 PROCEDURE @LC2S;      (* LC(D0.L) -> SR(D0.L) *)
 (*
#d0 (unsigned) -> d0 (ffp)
#FP2, d1 is destroyed
 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(; Da FMOVE immer mit Vorzeichen geschieht, mu der Wert gewandelt werden
(ADDI.L  #$80000000,D0
(FMOVE.L D0,FP2
(FSUB.L  #$80000000,FP2
(FMOVE.S FP2,D0
(RTS
 *)
 (*$? SoftReal:
 soft    moveq #$df,d1   ; setup positive high exponent ($80+64+31)
(tst.l d0        ; integer a zero ?
(beq.s itortn    ; return same result if so
(bmi.s itorti1   ; branch maximum negative number
(cmp.l #$00007fff,d0 ; possible 17 bits zero ?
(bhi.s itolp     ; branch if not
(swap.w d0       ; quick shift by swap
(sub.b #16,d1    ; deduct 16 shifts from exponent
 itolp   add.l d0,d0     ; shift mantissa up
(dbmi d1,itolp   ; loop until normalized
(tst.b d0        ; test for round up
(bpl.s itorti2   ; branch no rounding needed
(add.l #$100,d0  ; round up
(bcc.s itorti2   ; branch no overflow
(roxr.l #1,d0    ; adjust down one bit
 itorti1 addq.b #1,d1    ; reflect right shift in exponent bias
 itorti2 move.b d1,d0    ; insert sign & exponent
 itortn  RTS
 *)
 (*$? A68881:
 external
(; Da FMOVE immer mit Vorzeichen geschieht, mu der Wert gewandelt werden
(ADDI.L  #$80000000,D0
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(; FMOVE.L D0,FP2    ; kein Runtime-Fehler mglich
(MOVE.W  #$4100,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  D0,fpop
(TST.W   fpstat
(; FSUB.L  #$80000000,FP2
(MOVE.W  #$4128,fpcmd
 DoDl2   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl2
(MOVE.L  #$80000000,fpop
(TST.W   fpstat
(MOVE.W  #$6500,fpcmd         ; FMOVE.S FP2,D0
 DoDl3   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl3
(MOVE.L  fpop,D0
(TST.W   fpstat
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
 *)
$END
"END @LC2S;
 
 PROCEDURE @LI2S;     (* LI(D0.L) -> SR(D0.L) *)
 (*
#d0 (integer 2's complement) -> d0 (ffp)
#fp2, d1 is destroyed
 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE.L D0,FP2    ; kein Runtime-Fehler mglich
(FMOVE.S FP2,D0
(RTS
 *)
 (*$? SoftReal:
 soft    moveq #$df,d1  ; setup positive high exponent ($80+64+31)
(tst.l d0        ; integer a zero ?
(beq.s itortn    ; return same result if so
(bpl.s itopls    ; branch if positive integer
(moveq #$5f,d1   ; setup negative high exponent 64+31
(neg.l d0        ; find positive value
(bvs.s itorti2   ; branch maximum negative number
 itopls  cmp.l #$00007fff,d0 ; possible 17 bits zero ?
(bhi.s itolp     ; branch if not
(swap.w d0       ; quick shift by swap
(sub.b #16,d1    ; deduct 16 shifts from exponent
 itolp   add.l d0,d0     ; shift mantissa up
(dbmi d1,itolp   ; loop until normalized
(tst.b d0        ; test for round up
(bpl.s itorti    ; branch no rounding needed
(add.l #$100,d0  ; round up
(bcc.s itorti    ; branch no overflow
(roxr.l #1,d0    ; adjust down one bit
 itorti2 addq.b #1,d1    ; reflect right shift in exponent bias
 itorti  move.b d1,d0    ; insert sign & exponent
 itortn  RTS
 *)
 (*$? A68881:
 external
(; FMOVE.L D0,FP2    ; kein Runtime-Fehler mglich
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$4100,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  D0,fpop
(TST.W   fpstat
(; FMOVE.S FP2,D0
(MOVE.W  #$6500,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(MOVE.L  fpop,D0
(TST.W   fpstat
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
 *)
$END
"END @LI2S;
 
 
 PROCEDURE @LC2D;      (* LC(D0.L) -> LR(A0)  /D1,FP2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(; Da FMOVE immer mit Vorzeichen geschieht, mu der Wert gewandelt werden
(ADDI.L  #$80000000,D0
(FMOVE.L D0,FP2
(FSUB.L  #$80000000,FP2
(FMOVE.D FP2,(A0)
(RTS
 *)
 (*$? SoftReal:
 soft
(MOVE.L D0,D1
(MOVE.W #$0102,D0  ;Exponent 32
(TST.L  D1
(BEQ    ZERO
(BMI    Large      ;ist linksbndig
"POS   SUBQ.W #8,D0      ;linksbndig machen
(ADD.L  D1,D1
(BPL    POS
"Large SWAP   D0
(SWAP   D1
(MOVE.W D1,D0
(CLR.W  D1
(MOVE.L D0,(A0)+
(MOVE.L D1,(A0)
(RTS
"!ZERO CLR.L (A0)+
(CLR.L (A0)
(RTS
 *)
 (*$? A68881:
 external
(; Da FMOVE immer mit Vorzeichen geschieht, mu der Wert gewandelt werden
(ADDI.L  #$80000000,D0
(; FMOVE.L D0,FP2    ; kein Runtime-Fehler mglich
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$4100,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  D0,fpop
(TST.W   fpstat
(; FSUB.L  #$80000000,FP2
(MOVE.W  #$4128,fpcmd
 DoDl2   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl2
(MOVE.L  #$80000000,fpop
(TST.W   fpstat
(; FMOVE.D FP2,(A0)
(MOVE.W  #$7500,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(MOVE.L  fpop,(A0)+
(TST.W   fpstat
(MOVE.L  fpop,(A0)
(TST.W   fpstat
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A0)+
(CLR.L   (A0)
 *)
$END
"END @LC2D;
 
 PROCEDURE @LI2D;    (* LI(D0.L) -> LR(A0) /D1,FP2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE.L D0,FP2    ; kein Runtime-Fehler mglich
(FMOVE.D FP2,(A0)
(RTS
 *)
 (*$? SoftReal:
 soft    MOVE.L D0,D1
(MOVE.W #$0102,D0  ;Exponent 32
(TST.L  D1
(BEQ    ZERO
(SMI    -(A7)      ;Vorz. merken
(BPL    POS
(NEG.L  D1
(BMI    noadj
"POS   SUBQ.W #8,D0      ;linksbndig machen
(ADD.L  D1,D1
(BPL    POS
"noadj TST.B  (A7)+
(BEQ    notNeg
(TST.W  D0         ;Exp.
(BEQ    notNeg
(BSET   #0,D0      ;Vorzeichen auf Minus
!notNeg SWAP   D0
(SWAP   D1
(MOVE.W D1,D0
(CLR.W  D1
(MOVE.L D0,(A0)+
(MOVE.L D1,(A0)
(RTS
"!ZERO CLR.L (A0)+
(CLR.L (A0)
(RTS
 *)
 (*$? A68881:
 external
(; FMOVE.L D0,FP2    ; kein Runtime-Fehler mglich
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$4100,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  D0,fpop
(TST.W   fpstat
(; FMOVE.D FP2,(A0)
(MOVE.W  #$7500,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(MOVE.L  fpop,(A0)+
(TST.W   fpstat
(MOVE.L  fpop,(A0)
(TST.W   fpstat
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A0)+
(CLR.L   (A0)
 *)
$END
"END @LI2D;
 
 
 PROCEDURE @S2LC;      (* SR(D0.L) -> LC(D0.L) *)
 (*
#d0 (ffp) -> d0 (unsigned)
#FP2, d1 is destroyed
 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FINTRZ.S D0,FP2
(FADD.L  #$80000000,FP2
(FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(SUBI.L  #$80000000,D0
(RTS
 *)
 (*$? SoftReal:
 soft    tst.l d0
(beq.s fpirtn    ; return if zero
(move.b d0,d1    ; save sign & exponent
(bpl.s over      ; branch if minus value
(clr.b d0        ; clear for shift
(sub.b #$c1,d1   ; exponent -1 to binary (subtract sign bit too)
(blt.s fpirt0    ; return zero for fraction
(sub.b #31,d1    ; overflow ?
(bge.s over2     ; branch if too large
(neg.b d1        ; adjust for shift
(lsr.l d1,d0     ; finalize integer
 fpirtn  rts
 ; negative or positive overflow
 over2   beq     fpirtn  ; no shifts needed
 over    LINK    A5,#0
(TRAP    #6
(DC.W    -6-$4000          ; Out of range
(UNLK    A5
 fpirt0  moveq.l #0,d0   ; return zero
(RTS
 *)
 (*$? A68881:
 external
(; FINTRZ.S D0,FP2
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$4503,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  D0,fpop
(TST.W   fpstat
(; FADD.L  #$80000000,FP2
(MOVE.W  #$4122,fpcmd
 DoDl2   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl2
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  #$80000000,fpop
(TST.W   fpstat
(; FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(MOVE.W  #$6100,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  fpop,D0
(SUBI.L  #$80000000,D0
(CMPI.W  #$0802,fpstat
(BNE     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
 *)
$END
"END @S2LC;
 
 PROCEDURE @S2LI;     (* SR(D0.L) -> LI(D0.L) *)
 (*
#d0 (ffp) -> d0 (signed)
#FP2, d1 is destroyed
 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FINTRZ.S D0,FP2
(FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(RTS
 *)
 (*$? SoftReal:
 soft    tst.l d0
(beq.s fpirtn    ; return if zero
(move.b d0,d1    ; save sign & exponent
(bpl.s fpimi     ; branch if minus value
(clr.b d0        ; clear for shift
(sub.b #$c1,d1   ; exponent -1 to binary (subtract sign bit too)
(blt.s fpirt0    ; return zero for fraction
(sub.b #31,d1    ; overflow ?
(bge.s fpiovp    ; branch if too large
(neg.b d1        ; adjust for shift
(lsr.l d1,d0     ; finalize integer
 fpirtn  rts
 ; positive overflow
 fpiovp  LINK    A5,#0
(TRAP    #6
(DC.W    -6-$4000          ; Out of range
(UNLK    A5
 ; fraction only returns zero
 fpirt0  moveq.l #0,d0   ; return zero
(rts
 ; input is a minus integer
 fpimi   clr.b d0        ; clear for clean shift
(sub.b #$41,d1   ; exponent - 1 to binary
(blt.s fpirt0    ; return zero for fraction
(sub.b #31,d1    ; overflow ?
(bge.s fpichm    ; branch possible minus overflow
(neg.b d1        ; adjust for shift count
(lsr.l d1,d0     ; shift to proper magnitude
(neg.l d0        ; to minus now
(rts
 ; check for maximum minus number or minus overflow
 fpichm  bne.s fpiovm    ; branch minus overflow
(neg.l d0        ; attempt convert to negative
(tst.l d0        ; clear overflow bit
(bmi.s fpirtn    ; return if maximum negative integer
 fpiovm  LINK    A5,#0
(TRAP    #6
(DC.W    -6-$4000          ; Out of range
(UNLK    A5
(MOVEQ   #0,D0
(RTS
 *)
 (*$? A68881:
 external
(; FINTRZ.D D0,FP2
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$4503,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  D0,fpop
(TST.W   fpstat
(; FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(MOVE.W  #$6100,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  fpop,D0
(CMPI    #$0802,fpstat
(BNE     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
 *)
$END
"END @S2LI;
 
 
 PROCEDURE @D2LI;     (* LR(A0) -> LI(D0.L) /FP2,D1/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FINTRZ.D (A0),FP2
(FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(RTS
 *)
 (*$? SoftReal:
 soft    TST.W   (A0)
(BEQ     ZERO
(BCLR    #0,1(A0)
#ZERO SNE     -(A7)            ; $FF auf Stack -> op war neg.
(JSR     @D2LC
(TST.L   D0
(BMI     err
(TST.B   (A7)+
(BEQ     X
(NEG.L   D0
&X RTS
"
"wasMinInt
(TST.B   (A7)+           ; negieren?
(BEQ     err2            ; nein, dann ist $80000000 zu gro
(ADDQ.L  #1,D0
(RTS
"
"!ERR  SUBQ.L  #1,D0
(BPL     wasMinInt         ; $80000000 ist noch als Neg. Wert erlaubt!
(ADDQ.L  #2,A7
#err2 LINK    A5,#0
(TRAP    #6
(DC.W    -6-$4000          ; Out of range
(UNLK    A5
(CLR.L   D0
(RTS
 *)
 (*$? A68881:
 external
(; FINTRZ.D (A0),FP2
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$5503,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #8,D1
(BNE     error
(MOVE.L  (A0)+,fpop
(TST.W   fpstat
(MOVE.L  (A0),fpop
(TST.W   fpstat
(; FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(MOVE.W  #$6100,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  fpop,D0
(CMPI.W  #$0802,fpstat
(BNE     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
 *)
$END
"END @D2LI;
 
 
 PROCEDURE @D2LC;      (* LR(A0) -> LC(D0.L) /FP2,D1,D2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FINTRZ.D (A0),FP2
(FADD.L  #$80000000,FP2
(FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(SUBI.L  #$80000000,D0
(RTS
 *)
 (*$? SoftReal:
 soft
(MOVEM.L D3-D4,-(A7)
(MOVE.L (A0)+,D1
(MOVE.L (A0),D0
(SWAP   D1
(BTST   #0,D1
(BNE    nega      ;Zahl ist negativ -> Fehler
(ASR.W  #3,D1
(MOVE.W #32,D4
(SUB.W  D1,D4
(BLT    Err       ;Exponent war > 32: 0.FFF.. * 2^32 ist MaxLCard
(CMP.W  #32,D4
(BCC    ZERO      ;Exponent war <= 0
(MOVE.L D1,D2
(SWAP   D0
(MOVE.W D0,D2
(LSR.L  D4,D2
(BRA    X
"!ERR
"!NEGA MOVEM.L (A7)+,D3-D4
(LINK    A5,#0
(TRAP    #6
(DC.W    -6-$4000          ; Out of range
(UNLK    A5
(CLR.L  D0
(RTS
 
"!ZERO CLR.L  D2
"!X    MOVE.L D2,D0
(MOVEM.L (A7)+,D3-D4
(RTS
 *)
 (*$? A68881:
 external
(; FINTRZ.D (A0),FP2
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$5503,fpcmd
(MOVE.W  fpstat,D1
(SUBQ.B  #8,D1
(BNE     error
(MOVE.L  (A0)+,fpop
(TST.W   fpstat
(MOVE.L  (A0),fpop
(TST.W   fpstat
(; FADD.L  #$80000000,FP2
(MOVE.W  #$4122,fpcmd
 DoDl2   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl2
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  #$80000000,fpop
(TST.W   fpstat
(; FMOVE.L FP2,D0          ; extrahiert immer mit Vorzeichen!
(MOVE.W  #$6100,fpcmd
 DoDl3   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(SUBQ.B  #4,D1
(BNE     error
(MOVE.L  fpop,D0
(SUBI.L  #$80000000,D0
(CMPI.W  #$0802,fpstat
(BNE     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
 *)
$END
"END @D2LC;
 
 
 (********* Real-Vergleiche *********)
 
 (*$? A68881:
 PROCEDURE DoComp;
 (* A0: ^right, A1: ^left, Ergebnis als BOOLEAN in D0, FP2 zerstrt *)
 BEGIN
"ASSEMBLER
 DoDl0   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl0
(MOVE.W  #$5500,fpcmd        ;FMOVE (A1),FP2
(MOVE.W  fpstat,D0
(SUBQ.B  #8,D0
(BNE     DoCError
(MOVE.L  (A1)+,fpop
(TST.W   fpstat
(MOVE.L  (A1),fpop
(TST.W   fpstat
(MOVE.W  #$5538,fpcmd        ;FCMP  (A0),FP2
 DoCl2   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoCl2
(SUBQ.B  #8,D0
(BNE     DoCError
(MOVE.L  (A0)+,fpop
(TST.W   fpstat
(MOVE.L  (A0),fpop
(TST.W   fpstat
(MOVE.W  D1,fpcond           ;FBcc
(MOVE.W  fpstat,D0           ;Bool-Wert abholen
(ANDI    #1,D0
(RTS
 DoCError LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR     D0
"END;
 END DoComp;
 *)
 
 PROCEDURE @LREQ;
"BEGIN
$ASSEMBLER
(; Bei IEEE sind +0.0 und -0.0 nicht identisch -> Pech
(MOVE.L (A0)+,D0
(CMP.L  (A1)+,D0
(BNE    NE
(MOVE.L (A0),D0
(CMP.L  (A1),D0
(BNE    NE
(MOVEQ  #true,D0
(RTS
$!NE CLR.W  D0
$END
"END @LREQ;
 
 PROCEDURE @LRNE;
"BEGIN
$ASSEMBLER
(; Bei IEEE sind +0.0 und -0.0 nicht identisch -> Pech
(MOVE.L (A0)+,D0
(CMP.L  (A1)+,D0
(BNE    NE
(MOVE.L (A0),D0
(CMP.L  (A1),D0
(BNE    NE
(CLR.W  D0
(RTS
$!NE MOVEQ  #true,D0
$END
"END @LRNE;
 
 
 PROCEDURE @LRLE;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE   (A1),FP2
(FCMP    (A0),FP2
(FSLE    D0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(MOVEQ  #$15,D1     ;Conditional LE
(JMP    DoComp
 *)
 (*$? SoftReal:
 soft    MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L (A0)+,D1    ;rechter Operand
(BEQ    zer2
(MOVE.L (A0),D0
(MOVE.L (A1)+,D3    ;linker Operand
(BEQ    zer1
(MOVE.L (A1),D2
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BLS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BLS    neg3
!neg2   CLR.W  D0          ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   MOVE.L (A1),D3
(BEQ    neg3        ;Op1 = Op2 = 0
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0; Op1 < 0
(BRA    neg2
!zer1   BTST   D4,D1       ;Op1 Null, Op2 # 0: ist Op2 < 0?
(BNE    neg2        ; ja
!neg3   MOVEM.L (A7)+,D3/D4
(MOVEQ  #TRUE,D0
 *)
$END
"END @LRLE;
 
 PROCEDURE @LRGE;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE   (A1),FP2
(FCMP    (A0),FP2
(FSGE    D0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(MOVEQ  #$13,D1     ;Conditional GE
(JMP    DoComp
 *)
 (*$? SoftReal:
 soft    MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L (A0)+,D1    ;rechter Operand
(BEQ    zer2
(MOVE.L (A0),D0
(MOVE.L (A1)+,D3    ;linker Operand
(BEQ    zer1
(MOVE.L (A1),D2
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BCS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BCS    neg3
!neg2   MOVEQ  #true,D0    ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   ;Op2 Null, Op1 <= 0 ?
(MOVE.L (A1),D3
(BEQ    neg2        ;beide Null
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0, Op1 < 0
(BRA    neg2        ;Op2 = 0, Op1 > 0
!zer1   BTST   D4,D1       ;Op1 = 0, Op2 # 0: ist Op2 > 0?
(BNE    neg2        ; nein
!neg3   CLR.W  D0          ;Op1 negativ, Op2 positiv
(MOVEM.L (A7)+,D3/D4
 *)
$END
"END @LRGE;
 
 PROCEDURE @LRLT;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE   (A1),FP2
(FCMP    (A0),FP2
(FSLT    D0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(MOVEQ  #$14,D1     ;Conditional LT
(JMP    DoComp
 *)
 (*$? SoftReal:
 soft    MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L (A0)+,D1    ;rechter Operand
(BEQ    zer2
(MOVE.L (A0),D0
(MOVE.L (A1)+,D3    ;linker Operand
(BEQ    zer1
(MOVE.L (A1),D2
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BCS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BCS    neg3
!neg2   CLR.W  D0          ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   ;Op2 Null, Op1 <= 0 ?
(MOVE.L (A1),D3
(BEQ    neg2        ;beide Null
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0, Op1 < 0
(BRA    neg2        ;Op2 = 0, Op1 > 0
!zer1   BTST   D4,D1       ;Op1 = 0, Op2 # 0: ist Op2 > 0?
(BNE    neg2        ; nein
!neg3   MOVEQ  #TRUE,D0    ;Op1 negativ, Op2 positiv
(MOVEM.L (A7)+,D3/D4
 *)
$END
"END @LRLT;
 
 PROCEDURE @LRGT;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE   (A1),FP2
(FCMP    (A0),FP2
(FSGT    D0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(MOVEQ  #$12,D1     ;Conditional GT
(JMP    DoComp
 *)
 (*$? SoftReal:
 soft    MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L (A0)+,D1    ;rechter Operand
(BEQ    zer2
(MOVE.L (A0),D0
(MOVE.L (A1)+,D3    ;linker Operand
(BEQ    zer1
(MOVE.L (A1),D2
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BLS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BLS    neg3
!neg2   MOVEQ  #true,D0    ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   ;Op2 Null, Op1 <= 0 ?
(MOVE.L (A1),D3
(BEQ    neg3        ;beide Null
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0, Op1 < 0
(BRA    neg2        ;Op2 = 0, Op1 > 0
!zer1   BTST   D4,D1       ;Op1 = 0, Op2 # 0: ist Op2 > 0?
(BNE    neg2        ; nein
!neg3   CLR.W  D0          ;Op1 negativ, Op2 positiv
(MOVEM.L (A7)+,D3/D4
 *)
$END
"END @LRGT;
 
 
 (********* LongReal-Arithmetik *********)
 
 PROCEDURE @LNEG;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BPL     ieee
 *)
 (*$? SoftReal:
(TST.W  (A0)
(BEQ    ZERO
(BCHG   #0,1(A0)
#ZERO RTS
 *)
 (*$? IEEEReal:
#ieee BCHG    #7,(A0)
 *)
$END
"END @LNEG;
 
 PROCEDURE @LABS;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BPL     ieee
 *)
 (*$? SoftReal:
(TST.W  (A0)
(BEQ    ZERO
(BCLR   #0,1(A0)
#ZERO RTS
 *)
 (*$? IEEEReal:
#ieee BCLR    #7,(A0)
 *)
$END
"END @LABS;
 
 
 (*$? A68881:
 PROCEDURE LongDouble;
"(* Erwartet in Register D1 eine Co-Instruction,
#* in A0: ^right, A1: ^left/ziel *)
"BEGIN
$ASSEMBLER
 DoDl0   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl0
(MOVE.W  #$5400,fpcmd         ; FMOVE.D (A1),FP0
(MOVE.W  fpstat,D0
(SUBQ.B  #8,D0
(BNE     DoDErr
(MOVE.L  (A1)+,fpop
(TST.W   fpstat
(MOVE.L  (A1),fpop
(TST.W   fpstat
(MOVE.W  D1,fpcmd             ; Fxxxx.D (A0),FP0
(MOVE.W  fpstat,D0
(SUBQ.B  #8,D0
(BNE     DoDErr
(MOVE.L  (A0)+,fpop
(TST.W   fpstat
(MOVE.L  (A0),fpop
(TST.W   fpstat
(MOVE.W  #$7400,fpcmd         ; FMOVE.D FP0,(A1)
 !DoDl3  MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl3
(SUBQ.B  #8,D0
(BNE     DoDErr
 !GoBack MOVE.L  fpop,-4(A1)
(TST.W   fpstat
(MOVE.L  fpop,(A1)
(CMPI.W  #$0802,fpstat
(BNE     DoDErr
(RTS
 DoDErr  CLR.L   -4(A1)        ; RETURN 0.0
(CLR.L   (A1)
(LINK    A5,#0
(JSR     FPUError
(UNLK    A5
$END;
"END LongDouble;
 *)
 
 (*$? A68881:
 PROCEDURE ShortDouble;
"(* Erwartet auf dem A7-Stack eine Co-Instruction,
#* in D0: ^right, D1: ^left/ziel *)
"BEGIN
$ASSEMBLER
 DoDl0   MOVE.W  fpstat,D2
(TST.B   D2
(BEQ     DoDl0
(MOVE.W  #$4400,fpcmd         ; FMOVE.S D1,FP0
(MOVE.W  fpstat,D2
(SUBQ.B  #4,D2
(BNE     DoDErr2
(MOVE.L  D1,fpop
(TST.W   fpstat
(MOVE.W  (A7)+,fpcmd          ; Fxxxx.S D0,FP0
 !DoDl2  MOVE.W  fpstat,D2
(TST.B   D2
(BEQ     DoDl2
(MOVE.L  D0,fpop
(TST.W   fpstat
(MOVE.W  #$6400,fpcmd         ; FMOVE.S FP0,D1
 !DoDl3  MOVE.W  fpstat,D2
(TST.B   D2
(BEQ     DoDl3
(SUBQ.B  #4,D2
(BNE     DoDErr
 !GoBack MOVE.L  fpop,D1
(CMPI.W  #$0802,fpstat
(BNE     DoDErr
(RTS
 DoDErr2 ADDQ.L  #2,A7
 DoDErr  LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D1
$END;
"END ShortDouble;
 *)
 
 
 PROCEDURE @LMUL;
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
+TST     fpu
+BEQ     external
+BMI     soft
 *)
 (*$? M68881:
+FMOVE.D (A1),FP0
+FMUL.D  (A0),FP0
+FMOVE.D FP0,(A1)
+RTS
 *)
 (*$? A68881:
 external
+MOVE.W  #$5423,D1
+JMP     LongDouble
 *)
 (*$? SoftReal:
 soft       MOVEM.L D3-D7,-(A7)
+
+; linker Wert, Ziel
+MOVE.L  A1,A2
+MOVE.W  (A1)+,D0
+MOVE.W  (A1)+,D1
+MOVE.W  (A1)+,D2
+MOVE.W  (A1),D3
+; rechter Wert
+MOVE.W  (A0)+,D4
+MOVE.W  (A0)+,D5
+MOVE.W  (A0)+,D6
+MOVE.W  (A0),D7
+
+TST.W   D0           ;Op1 = 0 ?
+BEQ.L   ZERO
+TST.W   D4           ;Op2 = 0 ?
+BEQ.L   ZERO
+ADD.W   D0,D4        ;vorl. Exponent; neues Sign in bit0
+BVS.L   range        ;Ueber/Unterlauf
+MOVE.W  D4,-(A7)
+MOVE.W  D3,D4
+MULU    D7,D4
+CLR.W   D4
+SWAP    D4
+CLR.W   D5
+MOVE.W  D3,D0
+MULU    D6,D0
+ADD.L   D0,D4
+BCC     L0
+ADDQ.W  #1,D5
"!L0      MOVE.W  D2,D0
+MULU    D7,D0
+ADD.L   D0,D4
+BCC     L1
+ADDQ.W  #1,D5
"!L1      MOVE.W  D5,D4
+SWAP    D4
+CLR.W   D5
+MULU    D1,D7
+ADD.L   D7,D4
+BCC     L2
+ADDQ.W  #1,D5
"!L2      MOVE.W  -4(A0),D7
+MOVE.W  D2,D0
+MULU    D6,D0
+ADD.L   D0,D4
+BCC     L3
+ADDQ.W  #1,D5
"!L3      MULU    D7,D3
+ADD.L   D3,D4
+BCC     L4
+ADDQ.W  #1,D5
"!L4      MOVE.W  D4,D3
+MOVE.W  D5,D4
+SWAP    D4
+CLR.W   D5
+MULU    D7,D2
+ADD.L   D2,D4
+BCC     L5
+ADDQ.W  #1,D5
"!L5      MULU    D1,D6
+ADD.L   D6,D4
+BCC     L6
+ADDQ.W  #1,D5
"!L6      MOVE.W  D4,D6
+MOVE.W  D5,D4
+SWAP    D4
+MULU    D7,D1
+
+MOVE.W  (A7)+,D7
+ADD.L   D1,D4
+BMI     ISADJ
+ADD.W   D3,D3
+ADDX.W  D6,D6
+ADDX.L  D4,D4
+SUBQ.W  #8,D7
+BVS     ZERO
"!ISADJ   TST.W   D3
+BPL     NORND
+ADDQ.W  #1,D6
+BCC     NORND
+ADDQ.L  #1,D4
+BCC     NORND
+ADDQ.W  #8,D7
+BSET    #31,D4
"!NORND   BSET    #1,D7        ;markiere als # 0
+BCLR    #2,D7        ;loesche Schutzbit
+MOVE.W  D7,(A2)+
+MOVE.L  D4,(A2)+
+MOVE.W  D6,(A2)
+MOVEM.L (A7)+,D3-D7
+RTS
+
"range    BPL     zero
+;Summe der Exponenten war so gross,
+;dass sie ins negative ueberlief
+
"ovfl     MOVEM.L (A7)+,D3-D7
+LINK    A5,#0
+TRAP    #6
+DC.W    -7-$4000     ;overflow
+UNLK    A5
+CLR.L   (A2)+
+CLR.L   (A2)
+RTS
 
"zero     CLR.L   (A2)+
+CLR.L   (A2)
+MOVEM.L (A7)+,D3-D7
 *)
"END
 END @LMUL;
 
 
 PROCEDURE @LDIV;
 BEGIN
"ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE.D (A1),FP0
(FDIV.D  (A0),FP0
(FMOVE.D FP0,(A1)
(RTS
 *)
 (*$? A68881:
 external
(MOVE.W   #$5420,D1
(JMP      LongDouble
 *)
 (*$? SoftReal:
 soft    MOVEM.L D3-D7,-(A7)
(
(; rechter Wert
(MOVE.W  (A0)+,D1
(MOVE.L  (A0)+,D4
(MOVE.W  (A0),D5
(
(; linker Wert, Ziel
(MOVE.L  A1,A2
(MOVE.W  (A1)+,D0
(MOVE.L  (A1)+,D2
(MOVE.W  (A1),D3
(
(TST.W   D1
(BEQ.L   DIVBY0
(TST.W   D0
(BEQ.L   ZERO1
(BCLR    #1,D1        ; !TT 01.04.88
(SUB.W   D1,D0        ;vorl. Exponent und Sign in D0
(BVS.L   range        ;Ueber/Unterlauf
(CLR.L   D7
(MOVEQ   #49,D1
(BRA     L1
 !L0     ADD.L   D7,D7
(ADDX.L  D6,D6
(ADD.W   D3,D3
(ADDX.L  D2,D2
(BCS     ONEBIT
 !L1     CMP.L   D2,D4
(BHI     ZERBIT
(BNE     ONEBIT
(CMP.W   D3,D5
(BHI     ZERBIT
 !ONEBIT SUB.W   D5,D3
(SUBX.L  D4,D2
(ADDQ.B  #1,D7
 !ZERBIT DBF     D1,L0
(BTST    #17,D6
(BEQ     LESS05
(LSR.L   #1,D6
(ROXR.L  #1,D7
(ADDQ.W  #8,D0
(BVS     ovfl
 !LESS05 LSR.L   #1,D6
(ROXR.L  #1,D7
(BCC     NORND
(ADDQ.L  #1,D7
(BCC     NORND
(ADDQ.W  #1,D6
(BCC     NORND
(ROXR.W  #1,D6
(ADDQ.W  #8,D0
(BVS     ovfl
 noRnd   BSET    #1,D0
(BCLR    #2,D0
(MOVE.W  D0,(A2)+
(MOVE.W  D6,(A2)+
(MOVE.L  D7,(A2)
(MOVEM.L (A7)+,D3-D7
(RTS
(
 range   BMI     ovfl         ;Differenz der Exponenten war so gross,
=;dass sie ins negative ueberlief
 zero1   CLR.L   (A2)+
(CLR.L   (A2)
(MOVEM.L (A7)+,D3-D7
(RTS
(
 ovfl    MOVEM.L (A7)+,D3-D7
(LINK    A5,#0
(TRAP    #6
(DC.W    -7-$4000     ;overflow
(BRA     errend
(
 DivBy0  MOVEM.L (A7)+,D3-D7
(LINK    A5,#0
(TRAP    #6
(DC.W    -5-$4000
 errend: UNLK    A5
(CLR.L   (A2)+
(CLR.L   (A2)
 
 *)
"END
 END @LDIV;
 
 PROCEDURE LsoftADD;
"BEGIN
$ASSEMBLER
); MOVEM.L D3-D7,-(A7)  dies wird schon beim Aufrufer gemacht!
+
+MOVE.L  A1,A2
+; rechter Wert
); MOVE.W  (A0)+,D4    dies wird schon beim Aufrufer gemacht!
+MOVE.W  D4,-(A7)     ; wird spter noch gebraucht
+ANDI    #$FFFE,D4
+BEQ.L   RETN0        ;rechter Wert ist Null -> fertig
+MOVE.L  (A0)+,D5
+MOVE.W  (A0),D7
+; linker Wert, Ziel
+MOVE.W  (A1)+,D0
+ANDI    #$FFFE,D0
+BEQ.L   RETN2        ;ein Argument ist 0
+MOVE.L  (A1)+,D1
+MOVE.W  (A1),D3
+
+CLR.W   D6
+CMP.W   D0,D4
+BLT     PASST
+BNE     TAUSCH
+CMP.L   D1,D5
+BCS.L   PASST1
+BNE     TAUSCH
+CMP.W   D3,D7
+BLS.L   PASST1
"!TAUSCH  EXG     D0,D4
+EXG     D1,D5
+EXG     D3,D7
+MOVE.W  (A2),D2
+MOVE.W  (A7),(A2)
+MOVE.W  D2,(A7)
"
"!PASST   SUB.W   D4,D0        ;Exp.differenz immer positiv!
+LSR     #3,D0
+BEQ.L   PASST1
+CMP.W   #16,D0
+BEQ     S16
+BHI     SGT16
+SWAP    D7
+MOVE.W  D5,D7
+SWAP    D7
+LSR.L   D0,D5
+LSR.L   D0,D7
+BRA.L   DONE
"!S16     ADD.W   D7,D7
+MOVE.W  D5,D7
+CLR.W   D5
+SWAP    D5
+BRA     DONE
"!SGT16   CMP.W   #32,D0
+BEQ     S32
+BHI     SGT32
+SUB.W   #16,D0
+LSR.L   D0,D5
+MOVE.W  D5,D7
+CLR.W   D5
+SWAP    D5
+BRA     DONE
"!S32     ADD.W   D5,D5
+SWAP    D5
+MOVE.W  D5,D7
+CLR.L   D5
+BRA     DONE
"!S48     CLR.L   D5
+CLR.W   D7
+MOVEQ   #$FF,D6
+BRA     PASST1
"!SGT32   CMP.W   #48,D0
+BEQ     S48
+BHI.L   RETN1
+SUB.W   #32,D0
+SWAP    D5
+MOVE.W  D5,D7
+CLR.L   D5
+LSR.W   D0,D7
"!DONE    ROXR.W  #1,D6
"!PASST1  MOVE.W  (A2),D2   ;Vorzeichen beider Operanden gleich?
+MOVE.W  (A7),D0
+ADD.W   D2,D0
+BTST    #0,D0
+BNE     SUBTR
+ADD.W   D7,D3
+ADDX.L  D5,D1
+BCC     NOFL
+ROXR.L  #1,D1
+ROXR.W  #1,D3
+BCC     INCEX
+ADDQ.W  #1,D3
+BCC     INCEX
+ADDQ.L  #1,D1
"!INCEX   ADDQ.W  #8,D2        ;D2 ist Exp. der betr.mig greren Zahl
+BVS.L   OVFL
"!FERTIG  MOVE.W  D2,(A2)+
+MOVE.L  D1,(A2)+
+MOVE.W  D3,(A2)
"!RETN0   ADDQ.L  #2,A7
+MOVEM.L (A7)+,D3-D7
+RTS
+
"!NOFL    TST.W   D6
+BPL     FERTIG
+ADDQ.W  #1,D3
+BCC     FERTIG
+ADDQ.L  #1,D1
+BCC     FERTIG
+ROXR.L  #1,D1
+BRA     INCEX
"
"!SUBTR   ADD.W   D6,D6
+SCS     D6
+SUBX.W  D7,D3
+SUBX.L  D5,D1
+TST.L   D1
+BMI     FERTIG
+SUBQ.W  #8,D2
+ADD.W   D6,D6
+ADDX.W  D3,D3
+ADDX.L  D1,D1
+BMI.L   fertig
+BEQ     LGT32        ;Ausloeschung in der Mantisse.. normalisieren
+SWAP    D1
+TST.W   D1
+BNE     LLT16
+MOVE.W  D3,D1
+CLR.W   D3
+SUB.W   #128,D2      ;8 * (16 bit Shift)
+BVS     zero
+TST.L   D1
+BMI     fertig
"!L0      SUBQ.W  #8,D2
+BVS     zero
+ADD.L   D1,D1
+BPL     L0
+BRA     fertig
"!LLT16   SWAP    D1
"!L1      SUBQ.W  #8,D2
+BVS     zero
+ADD.W   D3,D3
+ADDX.L  D1,D1
+BPL     L1
+BRA     fertig
"!LGT32   SUB.W   #256,D2      ;8 * (32 bit Shift)
+BVS     zero
+MOVE.W  D3,D1
+BEQ     ZERO
+BMI     L3
"!L2      SUBQ.W  #8,D2
+BVS     zero
+ADD.W   D1,D1
+BPL     L2
"!L3      SWAP    D1
+CLR.W   D3
+BRA     fertig
"!ZERO    CLR.L   (A2)+
+CLR.L   (A2)
+ADDQ.L  #2,A7
+MOVEM.L (A7)+,D3-D7
+RTS
+
"!RETN1   ;Exponent stimmt schon
+ADDQ.L  #2,A2
+MOVE.L  D1,(A2)+     ;Mantisse mu (bei Ausgang 2 hierher)
+MOVE.W  D3,(A2)      ; noch getauscht werden!
+ADDQ.L  #2,A7
+MOVEM.L (A7)+,D3-D7
+RTS
+
"!RETN2   MOVE.W  (A7)+,(A2)+
+MOVE.L  D5,(A2)+
+MOVE.W  D7,(A2)+
+MOVEM.L (A7)+,D3-D7
+RTS
+
"!OVFL    ADDQ.L  #2,A7
+MOVEM.L (A7)+,D3-D7
+LINK    A5,#0
+TRAP    #6
+DC.W    -7-$4000      ;overflow
+UNLK    A5
+CLR.L   (A2)+
+CLR.L   (A2)
$END
"END LsoftADD;
 
 PROCEDURE @LADD;
 BEGIN
%ASSEMBLER
 (*$? AutoFPU:
+TST     fpu
+BEQ     external
+BMI     soft
 *)
 (*$? M68881:
+FMOVE.D (A1),FP0
+FADD.D  (A0),FP0
+FMOVE.D FP0,(A1)
+RTS
 *)
 (*$? A68881:
 external   MOVE.W  #$5422,D1
+JMP     LongDouble
 *)
 (*$? SoftReal:
 soft       MOVEM.L D3-D7,-(A7)
+; rechter Wert
+MOVE.W  (A0)+,D4
+JMP     LsoftADD
 *)
"END
 END @LADD;
 
 PROCEDURE @LSUB;
 BEGIN
"ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
(BMI     soft
 *)
 (*$? M68881:
(FMOVE.D (A1),FP0
(FSUB.D  (A0),FP0
(FMOVE.D FP0,(A1)
(RTS
 *)
 (*$? SoftReal:
 soft    MOVEM.L D3-D7,-(A7)
(; rechter Wert
 
(MOVE.W  (A0)+,D4
(BEQ     N
(BCHG    #0,D4
&N JMP     LsoftADD
 *)
 (*$? A68881:
 external
(MOVE.W #$5428,D1
(JMP    LongDouble
 *)
"END
 END @LSUB;
 
 
 PROCEDURE @STOL;
"(* D0 -> (A0), /D1,FP2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     externl
(BMI     soft
 *)
 (*$? M68881:
(FMOVE.S D0,FP2
(FMOVE.D FP2,(A0)
(RTS
 *)
 (*$? A68881:
 externl
 DoDl0   MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl0
(MOVE.W  #$4500,fpcmd         ; FMOVE.S D0,FP2
(MOVE.W  fpstat,D1
(SUBQ.B  #4,D1
(BNE     DoDErr
(MOVE.L  D0,fpop
(TST.W   fpstat
(MOVE.W  #$7500,fpcmd         ; FMOVE.D FP2,(A0)
 !DoDl3  MOVE.W  fpstat,D1
(TST.B   D1
(BEQ     DoDl3
(SUBQ.B  #8,D1
(BNE     DoDErr
 !GoBack MOVE.L  fpop,(A0)+
(TST.W   fpstat
(MOVE.L  fpop,(A0)
(CMPI.W  #$0802,fpstat
(BNE     DoDErr2
(RTS
 DoDErr  CLR.L   (A0)+
(CLR.L   (A0)
 DoDErr2 LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(RTS
 *)
 (*$? SoftReal:
 soft    MOVE.L D0,D1    ; save mantissa
(beq.s null      ; branch if zero
(and.w #$7f,D0   ; mask exponent
(sub.w #$40,D0   ; sub bias $40
(lsl.w #3,D0     ; shift signed exponent
(bset #1,D0      ; set #0 bit
(tst.b D1        ; test sign
(bmi posit       ; skip if positive
(bset.l #0,D0    ; insert negative sign
 posit   swap.w D0       ; swap exponent & sign into high word
(clr.b D1        ; clear ffp sign & exponent
(swap.w D1       ; get most significand 16 mantissa bits
(move.w D1,D0    ; high order long word now ok
(clr.w D1        ; remaining 8 mantissa bits in highest byte
 null    MOVE.L D0,(A0)+
(MOVE.L D1,(A0)
 *)
$END
"END @STOL;
 
 PROCEDURE @LTOS;
 (*
#(A0) (atari floating point format) -> D0 (ffp format), /D1,D2,FP2/
 
#D1: sign, exp+$1000, 16 bit mantissa
#D0: 32 bit mantissa
 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     externl
(BMI     soft
 *)
 (*$? M68881:
(FMOVE.D (A0),FP2
(FMOVE.S FP2,D0
(RTS
 *)
 (*$? A68881:
 externl
 DoDl0   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl0
(MOVE.W  #$5500,fpcmd         ; FMOVE.D (A0),FP2
(MOVE.W  fpstat,D0
(SUBQ.B  #8,D0
(BNE     DoDErr
(MOVE.L  (A0)+,fpop
(TST.W   fpstat
(MOVE.L  (A0),fpop
 !DoDl3  TST.W   fpstat
(BMI     DoDl3
(MOVE.W  #$6500,fpcmd         ; FMOVE.S FP2,D0
 !DoDl5  MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     DoDl5
(SUBQ.B  #4,D0
(BNE     DoDErr
 !GoBack MOVE.L  fpop,D0
(CMPI.W  #$0802,fpstat
(BNE     DoDErr
(RTS
 !DoDErr LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   D0
(RTS
 *)
 (*$? SoftReal:
 soft    move.l (A0)+,d1
(move.l (A0),d0
(swap.w d1       ; get exponent into low word
(move.w d1,d2    ; prepare exponent calculation
(beq.s null      ; branch if exponent is zero
(
(asr.w #3,d2
(add.w #$40,d2   ; add bias
(bmi.s null      ; still neg.: underflow
(cmp.w #$80,d2   ; compare with maximum ffp exponent
(bcc.s overfl    ; branch if exponent too high
(btst #0,d1      ; test sign bit
(bne isneg
(addi.b #$80,d2
"isneg swap.w d0       ; get mantissa bit 16..24
(move.w d0,d1    ; now complete mantissa
(tst.b d1        ; must we round up ?
(bpl.s noround   ; skip rounding up
(add.l #$100,d1  ; round it up
(bcc.s noround   ; were there all ones ?
(bset.l #31,d1   ; division by two
(addq.b #1,d2    ; correct exponent
(bvs.s overfl    ; exponent overflow
 noround move.b d2,d1    ; place sign & exponent
(move.l  d1,d0
(rts
 overfl  LINK    A5,#0
(TRAP    #6
(DC.W    -7-$4000     ;overflow
(UNLK    A5
 null    MOVEQ   #0,D0   ; get a true zero
 *)
$END
"END @LTOS;
 
 PROCEDURE @SRLE;  (* D1 <= D0? -> D0  /D2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST    fpu
(BPL    ieee
 *)
 (*$? SoftReal:
(MOVE.B D0,D2
(OR.B   D1,D2
(BMI.S  onepos      ; mindestens ein Operand positiv: normal
(EXG.L  D0,D1       ; beide negativ: tauschen
!onepos CMP.B  D0,D1
(BNE.S  eval
(CMP.L  D0,D1
#eval SLS    D0
(ANDI.W #1,D0
(RTS
 *)
 (*$? IEEEReal:
#ieee TST.L  D0
(BPL    ie1
(TST.L  D1
(BPL    ie1
(EXG.L  D0,D1
$ie1 CMP.L  D0,D1
(SLE    D0
(ANDI   #1,D0
 *)
$END
"END @SRLE;
 
 PROCEDURE @SRGE;  (* D1 >= D0? -> D0  /D2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST    fpu
(BPL    ieee
 *)
 (*$? SoftReal:
(MOVE.B D0,D2
(OR.B   D1,D2
(BMI.S  onepos      ; mindestens ein Operand positiv: normal
(EXG.L  D0,D1       ; beide negativ: tauschen
!onepos CMP.B  D0,D1
(BNE.S  eval
(CMP.L  D0,D1
#eval SCC    D0
(ANDI.W #1,D0
(RTS
 *)
 (*$? IEEEReal:
#ieee TST.L  D0
(BPL    ie1
(TST.L  D1
(BPL    ie1
(EXG.L  D0,D1
$ie1 CMP.L  D0,D1
(SGE    D0
(ANDI   #1,D0
 *)
$END
"END @SRGE;
 
 PROCEDURE @SRLT;  (* D1 < D0? -> D0  /D2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST    fpu
(BPL    ieee
 *)
 (*$? SoftReal:
(MOVE.B D0,D2
(OR.B   D1,D2
(BMI.S  onepos      ; mindestens ein Operand positiv: normal
(EXG.L  D0,D1       ; beide negativ: tauschen
!onepos CMP.B  D0,D1
(BNE.S  eval
(CMP.L  D0,D1
#eval SCS    D0
(ANDI.W #1,D0
(RTS
 *)
 (*$? IEEEReal:
#ieee TST.L  D0
(BPL    ie1
(TST.L  D1
(BPL    ie1
(EXG.L  D0,D1
$ie1 CMP.L  D0,D1
(SLT    D0
(ANDI   #1,D0
 *)
$END
"END @SRLT;
 
 PROCEDURE @SRGT;  (* D1 > D0? -> D0  /D2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST    fpu
(BPL    ieee
 *)
 (*$? SoftReal:
(MOVE.B D0,D2
(OR.B   D1,D2
(BMI.S  onepos      ; mindestens ein Operand positiv: normal
(EXG.L  D0,D1       ; beide negativ: tauschen
!onepos CMP.B  D0,D1
(BNE.S  eval
(CMP.L  D0,D1
#eval SHI    D0
(ANDI.W #1,D0
(RTS
 *)
 (*$? IEEEReal:
#ieee TST.L  D0
(BPL    ie1
(TST.L  D1
(BPL    ie1
(EXG.L  D0,D1
$ie1 CMP.L  D0,D1
(SGT    D0
(ANDI   #1,D0
 *)
$END
"END @SRGT;
 
 PROCEDURE @SNEG; (* D0 -> D0 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BPL     ieee
 *)
 (*$? SoftReal:
(TST.L   D0
(BEQ     ZERO
(EORI.B  #$80,D0
#zero RTS
 *)
 (*$? IEEEReal:
#ieee BCHG    #31,D0
 *)
$END
"END @SNEG;
 
 PROCEDURE @SABS; (* D0 -> D0 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BPL     ieee
 *)
 (*$? SoftReal:
(TST.L   D0
(BEQ     ZERO         ; auer bei Null ...
(ORI.B   #$80,D0      ; pos. Vorzeichenbit setzen
#zero RTS
 *)
 (*$? IEEEReal:
#ieee BCLR    #31,D0
 *)
$END
"END @SABS;
 
 PROCEDURE @SMUL; (* D1 * D0 -> D1, /D2,A0/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BMI     soft
(BEQ     externl
 *)
 (*$? M68881:
(FMOVE.S D1,FP0
(FSGLMUL.S D0,FP0
(FMOVE.S FP0,D1
(RTS
 *)
 (*$? A68881:
 externl MOVE.W  #$4427,-(A7)
(JMP     ShortDouble
 *)
 (*$? SoftReal:
 soft    TST.L   D1
(BEQ     zero
(MOVE.L  D0,D2        ; Exponenten holen, auch Nulltest
(BEQ     zero
(
(MOVE.L  D3,-(A7)
(
(; Vorzeichen des Ergebnisses in A0.B vorbereiten
(
(EOR.B   D1,D2
(MOVEQ   #$80,D3
(AND.B   D3,D2
(EOR.B   D3,D2        ; kippen wegen inv. Sign: Sign in D2
(MOVE    D2,A0
(
(; vorlufigen Exponenten in D0.B vorbereiten
(
(MOVEQ   #$7F,D3
(AND.B   D3,D1        ; Vorzeichen weg
(AND.B   D3,D0
(ADD.B   D1,D0        ; Exponenten addieren
(SUB.B   #$40,D0      ; einen Bias abziehen: vorl. Exponent in D0
(BCS     zero2        ; Underflow
=; Overflow erst spter abfragen; kann durch
=; Normalisieren des Ergebnisses verschwinden
(
(MOVE.L  D1,D3        ; Argument 1
(SWAP    D3           ; high Bytes
(MOVE.L  D0,D2        ; Argument 0
(CLR.B   D2
(MULU    D3,D2        ; 1H * 0L in D2
(SWAP    D0
(MULU    D0,D3        ; 0H * 1H in D3
(CLR.B   D1
(MULU    D0,D1        ; 0H * 1L in D1
(SWAP    D0           ; Exponent wieder im LowByte
(ADD.L   D2,D1        ; niederwertige Teilprodukte addieren
(CLR.W   D1           ; die unteren Bits weg
(ADDX.B  D1,D1        ; aber den Carry der Addition mitnehmen
(SWAP    D1           ; richtige Wertigkeit
(ADD.L   D3,D1        ; Hherwertiges Teilprodukt dazu
(BPL     normali
(ADD.L   #$80,D1      ; aufrunden
(BCC     setexp
(BRA     roundov
 normali SUBQ.B  #1,D0        ; Exponent dekrementieren
(BCS     zero2        ; underflow
(ADD.L   #$40,D1      ; Rundungsbit
(ADD.L   D1,D1
(BCC     setexp       ; alles klar
 roundov ROXR.L  #1,D1        ; berlauf wegen zus. Rundung
(ADDQ.B  #1,D0        ; alles zurck...
!setexp MOVE.B  D0,D1        ; Exponent bernehmen
(BMI     ovfl
(
(MOVE    A0,D2
(OR.B    D2,D1
(MOVE.L  (A7)+,D3
(RTS
 
#ovfl MOVE.L  (A7)+,D3
(LINK    A5,#0
(TRAP    #6
(DC.W    -7-$4000     ;overflow
(UNLK    A5
(MOVEQ   #0,D1
(RTS
 
"zero2 MOVE.L  (A7)+,D3
#zero MOVEQ   #0,D1
 *)
$END
"END @SMUL;
 
 PROCEDURE @SDIV; (* D1 / D0 -> D1, /D2,A0/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BMI     soft
(BEQ     externl
 *)
 (*$? M68881:
(FMOVE.S D1,FP0
(FSGLDIV.S D0,FP0
(FMOVE.S FP0,D1
(RTS
 *)
 (*$? A68881:
 externl MOVE.W  #$4424,-(A7)
(JMP     ShortDouble
 *)
 (*$? SoftReal:
 soft    TST.L   D0           ; Divisor
(BEQ     DivBy0
(
(; Vorzeichen bestimmen
(
(MOVE.L  D1,D2        ; Exponenten holen
(BEQ     zero1
(MOVE.L  D3,-(A7)     ; zwischendurch mal die Regs retten
(MOVE.L  D4,-(A7)
(EOR.B   D0,D2
(MOVEQ   #$80,D3      ;... und weiter mit der Vorzeichen-Bestimmung
(AND.B   D3,D2
(EOR.B   D3,D2        ; kippen wegen inv. Sign: Sign in D2
(MOVE    D2,A0        ; D2 freimachen
(
(; Exponenten berechnen
(
(MOVEQ   #$7F,D3
(AND.B   D3,D0
(AND.B   D1,D3
(SUB.B   D0,D3        ; Exponenten subtrahieren
(ADD.B   #$40,D3      ; einen Bias addieren: vorl. Exponent in D3
(BVS     ovfl         ; Overflow
=; Underflow erst spter abfragen; kann durch
=; Normalisieren des Ergebnisses verschwinden
=
(; Mantissen vorbereiten fr 16 bit-Division
(
(CLR.B   D0
(CLR.B   D1
(SWAP    D0
(SWAP    D1
(CMP.W   D0,D1        ; wird Ergebnis >= 1 ?
(BCS     less1
(ADDQ.B  #1,D3        ; wrde berlauf bei DIVU geben: vorher korrig.
(BVS     ovfl
(ROR.L   #1,D1
(
(; erste Schtzung: D1.24 bit durch D0.16 bit
(
"less1 SWAP    D1           ; Dividend restaurieren
(MOVE.L  D1,D2        ; Kopie des Dividenden
(DIVU    D0,D2        ;  ... durch 16 bit Divisor teilen
(MOVE.W  D2,D4        ; vorl. Ergebnis retten
(
(; vorl. Ergebnis * D0.24 bit, um den Fehler zu sehen
(
(MULU    D0,D2        ; D0.high * Testergebnis
(SUB.L   D2,D1        ; das schon mal vom Dividenden abziehen
(SWAP    D0           ; Divisor jetzt restauriert
(SWAP    D1
(MOVE.W  D0,D2        ; D0.low
(CLR.B   D2
(MULU    D4,D2        ;  * Testergebnis
(SUB.L   D2,D1        ;
(BCC     estok        ; Schtzung war korrekt; bleibt noch ein Rest
(
(; Schtzung zu gro: Ergebnis korrigieren,
(; zum Rest einen Divisor wieder aufaddieren
(
(SUBQ.W  #1,D4        ; vorl. Ergebnis korrigiert
(ADD.L   D0,D1        ; Rest um Divisor erhhen
(
(; Rest durch 16 bit Divisor teilen
(
"estok SWAP    D0           ; 16 high Bits des Divisors
(CLR.W   D1
(DIVU    D0,D1
(
(; Ergebnis zusammenbauen und ggf. normalisieren
(
(SWAP    D4
(BMI     isnorm
(MOVE.W  D1,D4        ; nicht normalisiert: selten!
(ADD.L   D4,D4
(SUBQ.B  #1,D3
(MOVE.W  D4,D1        ; trken fr folgenden Befehl
!isnorm MOVE.W  D1,D4
(ADD.L   #$80,D4
(MOVE.B  D3,D4
(BMI     zero2
(MOVE    A0,D2
(EOR.B   D2,D4
(MOVE.L  D4,D1
(MOVE.L  (A7)+,D4
(MOVE.L  (A7)+,D3
"zero1 RTS
 
!DivBy0 LINK    A5,#0
(TRAP    #6
(DC.W    -5-$4000
(UNLK    A5
 
#zero MOVEQ   #0,D1
(RTS
"
"zero2 MOVE.L  (A7)+,D4
(MOVE.L  (A7)+,D3
(BRA     zero
 
#Ovfl MOVE.L  (A7)+,D4
(MOVE.L  (A7)+,D3
(
(LINK    A5,#0
(TRAP    #6
(DC.W    -7-$4000     ;overflow
(UNLK    A5
(
(MOVEQ   #0,D1
 *)
$END
"END @SDIV;
 
 (*$? SoftReal:
 PROCEDURE MYSADD; (* Nur fr Soft-ShortReals *)
"BEGIN
%ASSEMBLER
(; stelle |D0| >= |D1| sicher
(
(MOVE.L  D0,D2        ; Vorzeichen retten
(BEQ     Retn1        ; zweiter Summand ist Null
(
(MOVE.L  D3,-(A7)
(
(MOVE.L  D1,D3
(BEQ     Retn2        ; erster Summand ist Null
(
(MOVE.L  D4,-(A7)
(
(MOVEQ   #$7F,D4
(AND.B   D4,D0        ; Vorzeichen wegmaskieren
(AND.B   D4,D1
(CMP.B   D1,D0
(BHI     passt        ; klar grer
(BNE     change       ; klar kleiner
(CMP.L   D1,D0        ; Mantissen vergleichen
(BCC     passt        ; grer oder gleich
!change EXG     D0,D1
(EXG     D2,D3
(
(; jetzt ist |D0| >= |D1|, und D2.B enthlt das dominante Vorzeichen
(; Mantisse D1 stellenrichtig anpassen
(
"passt SUB.B   D1,D0        ; Differenz der Exponenten
(BEQ     shift0       ; gleich gro: nix zu tun
(CMPI.B  #16,D0
(BCC     shift16
(CLR.B   D1
"small LSR.L   D0,D1
(
(; Mantissen stehen; D2 enthlt dominantes Sign/Exponent.
(; Jetzt addieren/subtrahieren.
(; Das gelschte Sign Bit in D0 wirkt als Puffer
(; gegen berlufe aus dem Low Byte.
(
!passt2 CLR.B   D0
(EOR.B   D2,D3        ; Vorzeichen gleich?
(BMI     difsgn       ;  nein, subtrahieren
(ADD.L   D1,D0        ;  ja, addieren
(BCC     ok
(ROXR.L  #1,D0        ; berlauf bei Addition: High Bit zurckholen
(ADDQ.B  #1,D2        ;  ... und Exponenten korrigieren
(BVS     ovfl         ; das kann berlauf ergeben!
(BCC     ok           ;  wg. Vorzeichenbit mu V+C geprft werden
 
#ovfl MOVE.L  (A7)+,D4
(MOVE.L  (A7)+,D3
(LINK    A5,#0
(TRAP    #6
(DC.W    -7-$4000     ;overflow
(UNLK    A5
(MOVEQ   #0,D1
(RTS
 
"Retn2 MOVE.L  (A7)+,D3
(MOVE.L  D0,D1
"Retn1 RTS
 
!shift0 CLR.B   D1
(BRA     passt2
(
 shift16 CMPI.B  #24,D0
(BHI     ok           ; vernachlssigen: gib D0,D2 zurck
(BEQ     shift24      ; nur ein Rundungsbit zu bercksichtigen
(CLR.W   D1           ; 16..23 Shifts: 16 Stck schnell
(SWAP    D1
(SUBI.B  #16,D0
(BRA     small
(
 shift24 MOVE.L  #$80,D1      ; kleines Argument: High Bit SHR 24
(BRA     passt2
#
!difsgn SUB.L   D1,D0        ; ungleiche Vorzeichen: subtrahieren
(BMI     ok           ; Mantisse ist normalisiert
(MOVE.B  D2,D3        ; Vorzeichen retten fr Underflow Check
(SUBQ.B  #1,D2        ; DBMI-Korrektur (s.u.)
(CLR.B   D0           ; erstmal die ungltigen Low-Bits weg
(CMPI.L  #$7FFF,D0    ; mehr als 16 Shifts ntig?
(BHI     small1
(TST.W   D0
(BEQ     zero
(SWAP    D0
(SUBI.B  #16,D2
!small1 ADD.L   D0,D0        ; Shift 1 Bit
(DBMI    D2,small1
(EOR.B   D2,D3
(BMI     zero         ; Vorzeichen gekippt: Exponent Underflow
(
%ok MOVE.B  D2,D0        ; Exponent des greren Arguments restaurieren
(MOVE.L  (A7)+,D4
(MOVE.L  (A7)+,D3
(MOVE.L  D0,D1
(RTS
 
#zero MOVE.L  (A7)+,D4
(MOVE.L  (A7)+,D3
(MOVEQ   #0,D1
$END
"END MYSADD;
 *)
 
 PROCEDURE @SADD; (* D1 + D0 -> D1, /D2/ *)
"BEGIN
%ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BMI     soft
(BEQ     externl
 *)
 (*$? M68881:
(FMOVE.S D1,FP0
(FADD.S  D0,FP0
(FMOVE.S FP0,D1
(RTS
 *)
 (*$? A68881:
 externl MOVE.W  #$4422,-(A7)
(JMP     ShortDouble
 *)
 (*$? SoftReal:
 soft    JMP     MYSADD
 *)
$END
"END @SADD;
 
 PROCEDURE @SSUB; (* D1 - D0 -> D1, /D2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BMI     soft
(BEQ     externl
 *)
 (*$? M68881:
(FMOVE.S D1,FP0
(FSUB.S  D0,FP0
(FMOVE.S FP0,D1
(RTS
 *)
 (*$? A68881:
 extern  MOVE.W  #$4428,-(A7)
(JMP     ShortDouble
 *)
 (*$? SoftReal:
 soft    TST.L  D0
(BEQ    ZERO
(EORI.B #$80,D0      ; kippe Vorzeichen des zweiten Arguments
(JMP    MYSADD
#zero                     ; zweites Argument Null: das ist einfach
 *)
$END
"END @SSUB;
 
 (*
!* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!*
!*                              S T - F P U
!*                             _____________
!* Erkenntnisse:
!*
!* Wird eine Operation ausgefhrt, die zu einem Fehler fhrt, z.B.
!* DivBy0, Operand Error, Overflow, dann wird die Exeption nicht sofort
!* nach dem Empfang von Befehl und Argument angezeigt, sondern erst beim
!* Senden des nchsten Befehls.
!* Das heit: 1. Die Exc geht nicht verloren, wenn man vor der Abfrage den
!* neuen Befehl bergibt. 2. Dort, wo sicher ist, da ein Dialog beendet
!* ist, also das CA-Bit gelscht ist, braucht auch kein Exception-Check
!* mehr gemacht werden - nach der bergabe des 1. Commands mu jedoch
!* immer eine Exc. geprft werden.
!*
!* Durch das Lesen des Statusregs werden CPU und FPU synchronisiert! Das
!* heit: Die FPU lt ggf. die CPU warten, bis die FPU ihre Zyklen
!* abgearbeitet hat. Dadurch ist auch eine Funktionsfhigkeit bei sehr
!* schneller CPU gewhrleistet, allerdings nur bei der 68881 (bei 68882
!* darf CPU nur 1.5 mal schneller sein).
!* Allerdings darf man nicht berall damit rechnen, da eine genau
!* abzhlbare Anzahl von Status-Reads erforderlich ist. So scheint das
!* zwar zu funktionieren, wenn Daten zw. CPU und FPU bertragen werden
!* (dann braucht nur jew. ein Lesezugriff zw. den Transfers erfolgen),
!* jedoch z.B. nicht, wenn ein FMOVE FPn,<ea> abgesetzt wurde: hier mu
!* dann auf den bertragungsbefehl in einer Schleife gewartet werden!
!*)
 
 PROCEDURE @FNUL;       (* F-Instr. in D0 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGEN1
(JMP     cpGEN0
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx  FPn
(MOVE.W  D0,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #2,D0
(BHI     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FNUL;
 
 PROCEDURE @FCPN;       (* F-Instr. in D0, Cond. in D2 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGEN1
(MOVE    D2,cpScc1
(JSR     cpGEN0
(JSR     cpScc0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx  FPn
(MOVE.W  D0,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #2,D0
(BHI     error
(MOVE.W  D2,A2cond(A2)       ;FBcc
(MOVE.W  (A2),D0           ;Bool-Wert abholen
(ANDI    #1,D0
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(MOVEQ   #0,D0
 *)
$END
"END @FCPN;
 
 PROCEDURE @FOPS;       (* F-Instr. in D0, <ea>.S in D1 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGENS1
(JMP     cpGENS0
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.S D1,FPn
(MOVE.W  D0,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #4,D0
(BNE     error
(MOVE.L  D1,A2op(A2)
(TST.W   (A2)
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FOPS;
 
 PROCEDURE @FCPS;       (* F-Instr. in D0, Cond. in D2, <ea>.S in D1 *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGENS1
(MOVE    D2,cpScc1
(JSR     cpGENS0
(JSR     cpScc0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(JSR     @FOPS
(MOVE.W  D2,A2cond(A2)           ;FBcc
(MOVE.W  (A2),D0           ;Bool-Wert abholen
(ANDI    #1,D0
 *)
$END
"END @FCPS;
 
 PROCEDURE @FOPD;       (* F-Instr. in D0, <ea>.D in (A0) /A2/ *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGENL1
(JMP     cpGENL0
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.D (A0),FPn
(MOVE.W  D0,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #8,D0
(BNE     error
(MOVE.L  (A0)+,A2op(A2)
(TST.W   (A2)
(MOVE.L  (A0),A2op(A2)
(TST.W   (A2)
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FOPD;
 
 PROCEDURE @FCPD;       (* F-Instr. in D0, Cond. in D2, <ea>.D in (A0) *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGENL1
(MOVE    D2,cpScc1
(JSR     cpGENL0
(JSR     cpScc0
(ANDI    #1,D0
(RTS
 *)
 (*$? A68881:
 external
(JSR     @FOPD
(MOVE.W  D2,A2cond(A2)           ;FBcc
(MOVE.W  (A2),D0           ;Bool-Wert abholen
(ANDI    #1,D0
 *)
$END
"END @FCPD;
 
 PROCEDURE @FMVS;       (* F-Instr. in D0, <ea>.S nach (A0) *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGENL1
(JMP     cpGENL0
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.S FPn,(A0)
(MOVE.W  D0,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #4,D0
(BNE     error
(MOVE.L  A2op(A2),(A0)
(CMPI.W  #$0802,(A2)
(BNE     error
(RTS
 error   CLR.L   (A0)
(LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FMVS;
 
 PROCEDURE @FMVD;       (* F-Instr. in D0, <ea>.D nach (A0) *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D0,cpGENL1
(JMP     cpGENL0
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.D FPn,(A0)
(MOVE.W  D0,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #8,D0
(BNE     error
(MOVE.L  A2op(A2),(A0)+
(TST.W   (A2)
(MOVE.L  A2op(A2),(A0)
(CMPI.W  #$0802,(A2)
(BNE     error2
(RTS
 error   CLR.L   (A0)+
(CLR.L   (A0)
 error2  LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FMVD;
 
 
 PROCEDURE @FP7S;       (* Push FPn auf A7. Opcode in D2 ("FMOVE.S FPn,ea") *)
"BEGIN
$ASSEMBLER
(MOVE.L  (A7),-(A7)
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D2,cpPsh71
(JMP     cpPsh70
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.S FPn,4(A7)
(MOVE.W  D2,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D2
(TST.B   D2
(BEQ     DoDl1
(SUBQ.B  #4,D2
(BNE     error
(MOVE.L  A2op(A2),4(A7)
(CMPI.W  #$0802,(A2)
(BNE     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   4(A7)
 *)
$END
"END @FP7S;
 
 PROCEDURE @FP7D;       (* Push FPn auf A7. Opcode in D2 ("FMOVE.D FPn,ea") *)
"BEGIN
$ASSEMBLER
(SUBQ.L  #8,A7
(MOVE.L  8(A7),(A7)
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D2,cpPsh71
(JMP     cpPsh70
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.D FPn,4(A7)
(MOVE.W  D2,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D2
(TST.B   D2
(BEQ     DoDl1
(SUBQ.B  #8,D2
(BNE     error
(MOVE.L  A2op(A2),4(A7)
(TST.W   (A2)
(MOVE.L  A2op(A2),8(A7)
(CMPI.W  #$0802,(A2)
(BNE     error
(RTS
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   4(A7)
(CLR.L   8(A7)
 *)
$END
"END @FP7D;
 
 
 PROCEDURE @FP3S;       (* Push FPn auf A3. Opcode in D2 ("FMOVE.S FPn,ea") *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D2,cpPsh31
(JMP     cpPsh30
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.S FPn,(A3)+
(MOVE.W  D2,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D2
(TST.B   D2
(BEQ     DoDl1
(SUBQ.B  #4,D2
(BNE     error
(MOVE.L  A2op(A2),(A3)+
(CMPI.W  #$0802,(A2)
(BNE     error2
(RTS
 error2  SUBQ.L  #4,A3
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A3)+
 *)
$END
"END @FP3S;
 
 PROCEDURE @FP3D;       (* Push FPn auf A7. Opcode in D2 ("FMOVE.D FPn,ea") *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(MOVE    D2,cpPsh31
(JMP     cpPsh30
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; Fxxxx.D FPn,(A3)+
(MOVE.W  D2,A2cmd(A2)
 DoDl1   MOVE.W  (A2),D2
(TST.B   D2
(BEQ     DoDl1
(SUBQ.B  #8,D2
(BNE     error
(MOVE.L  A2op(A2),(A3)+
(TST.W   (A2)
(MOVE.L  A2op(A2),(A3)+
(CMPI.W  #$0802,(A2)
(BNE     error2
(RTS
 error2  SUBQ.L  #8,A3
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A3)+
(CLR.L   (A3)+
 *)
$END
"END @FP3D;
 
 
 PROCEDURE @FP7M; (* FMOVEM: Push FP-list auf A7. Opcode in D0, A1/A2 benutzt *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(LINK    A5,#0
(TRAP    #6
(DC.W    -24-$6000       ; ConfigErr: caller caused, no cont
(UNLK    A5
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; FMOVEM.X <static list>,-(A7)
(MOVE.W  D0,A2cmd(A2)
(TST.W   (A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(CMPI.B  #$0C,D0
(BNE     error
(MOVE.L  (A7)+,D0        ; save return-address
(TST.W   A2regsel(A2)
(MOVEA.W #$FA50,A1
 again   SUBQ.L  #8,A7
(MOVE.L  (A1),-(A7)
(TST.W   (A2)
(MOVE.L  (A1),4(A7)
(TST.W   (A2)
(MOVE.L  (A1),8(A7)
(CMPI.W  #$0802,(A2)
(BNE     again
(MOVE.L  D0,A2
(JMP     (A2)
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FP7M;
 
 PROCEDURE @FG7M; (* FMOVEM: Load FP-list von A7. Opcode in D0, A1/A2 benutzt *)
"BEGIN
$ASSEMBLER
 (*$? AutoFPU:
(TST     fpu
(BEQ     external
 *)
 (*$? M68881:
(LINK    A5,#0
(TRAP    #6
(DC.W    -24-$6000       ; ConfigErr: caller caused, no cont
(UNLK    A5
 *)
 (*$? A68881:
 external
(MOVEA.W #$FA40,A2
(; FMOVEM.X (A7)+,<static list>
(MOVE.W  D0,A2cmd(A2)
(TST.W   (A2)
 DoDl1   MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(CMPI.B  #$0C,D0
(BNE     error
(MOVE.L  (A7)+,D0        ; save return-address
(TST.W   A2regsel(A2)
(MOVEA.W #$FA50,A1
 again   MOVE.L  (A7)+,(A1)
(TST.W   (A2)
(MOVE.L  (A7)+,(A1)
(TST.W   (A2)
(MOVE.L  (A7)+,(A1)
(CMPI.W  #$0802,(A2)
(BNE     again
(MOVE.L  D0,A2
(JMP     (A2)
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
 *)
$END
"END @FG7M;
 
 PROCEDURE @FG7S; BEGIN HALT END @FG7S;
 PROCEDURE @FG7D; BEGIN HALT END @FG7D;
 PROCEDURE @FG3S; BEGIN HALT END @FG3S;
 PROCEDURE @FG3D; BEGIN HALT END @FG3D;
 
 
 PROCEDURE @VFPU;
"(*
"BEGIN
$ASSEMBLER
(; FPU-Benutzung initialisieren, damit bei TRANSFER
(; auch die FPU-Regs gesichert werden
(TST     fpu
(BMI     error
(
(; MOVE    #1,SwitchFPUContext
(RTS
(
&error
(TRAP    #6
(DC.W    -24-$A000       ; Config-Error, text follows, no cont
(ACZ     'program needs FPU'
$END
"*)
"END @VFPU;
 
 PROCEDURE @V020;
"(*
"BEGIN
$ASSEMBLER
(; Prfen, ob 68020 vorhanden ist
(
(TST     useSF
(BNE     ok
(
(TRAP    #6
(DC.W    -24-$E000       ; Config-Error, text follows, caller, no cont
(ACZ     'program needs 68020'
(SYNC
&ok
$END
"*)
"END @V020;
 
 
 PROCEDURE @RES1;
"(* Vergleich fr lok. Proc-Parms *)
"BEGIN
$ASSEMBLER
(CMPM.L  (A0)+,(A1)+
(BNE     ende
(CMPM.L  (A0)+,(A1)+
&ende
$END
"END @RES1;
 
 PROCEDURE @RES2; BEGIN HALT END @RES2;
 PROCEDURE @RES3; BEGIN HALT END @RES3;
 PROCEDURE @RES4; BEGIN HALT END @RES4;
 PROCEDURE @RES5; BEGIN HALT END @RES5;
 PROCEDURE @RES6; BEGIN HALT END @RES6;
 PROCEDURE @RES7; BEGIN HALT END @RES7;
 
 
 VAR remCarrier: RemovalCarrier;
 
 BEGIN
"useSF:= SysInfo.UseStackFrame ();
"CoroutineTrapNo:= 4;
"(*$? AutoFpu:
$fpu:= INTEGER (SysInfo.FPU ()) - 1;
$(* SwitchFPUContext:= FALSE; *)
$IF fpu = 0 THEN
&FPUInit
$ELSIF fpu > 0 THEN
&(* interne FPU initialisieren: *)
&ASSEMBLER FMOVE #$0000F400,FPCR (* s.o.*) END;
&(* >> Autom. Exc bei Overflow, DivBy0, Operand Error,
,signalling NAN, Bcc/Scc on unordered *)
&CaughtExceptions:=
0CaughtExceptions +
0ExcSet {BSUnExc, FPZeroDivide, OpError, FPOverflow, NANExc};
$END;
"*)
"(*$? AutoFpu & SoftReal:
$!!! hier nochmal setzen?
$fpu:= -1;
"*)
"(*$? M68881:
$(*$? AutoFpu:
&!!! hier nochmal setzen?
&fpu:= 1;
$*)
$IF SysInfo.FPU () # SysInfo.internalFPU THEN
&ASSEMBLER
(MOVE.W  #MOSGlobals.fUnknownDevice,(A3)+
(JMP     Abort
&END
$END;
$ASSEMBLER FMOVE #$0000F400,FPCR (* s.o.*) END;
$CaughtExceptions:=
0CaughtExceptions +
0ExcSet {BSUnExc, FPZeroDivide, OpError, FPOverflow, NANExc};
$cpGEN2:= rtsCode;
$cpScc2:= rtsCode;
$cpGENS2:= rtsCode;
$cpGENL2:= rtsCode;
$cpPsh72:= 4;
$cpPsh73:= rtsCode;
$cpPsh32:= rtsCode;
$cpGEN0:= $F200;
$cpScc0:= $F240;
$cpGENL0:= $F210;
$cpGENS0:= $F201;
$cpPsh70:= $F22F;
$cpPsh30:= $F21B;
"*)
"(*$? A68881:
$(*$? AutoFpu:
&!!! hier nochmal setzen?
&fpu:= 0;
$*)
$FPUInit;
"*)
"CatchRemoval (remCarrier, LinkOut, MOSGlobals.MemArea {NIL,0});
 END Runtime.
 
(* $0000DAA6$0001952B$0001951F$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$00001362$FFFB3F34$0001BEDD$FFFB3F34$00019E3C$FFFB3F34$FFFB3F34$FFFB3F34$00003CD3$FFFB3F34$000053CB$FFFB3F34$FFFB3F34$FFFB3F34$0000652C$FFFB3F34$FFFB3F34$FFEE513D$FFFB3F34$00002A93$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$00004D96$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$0000135FT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$0001A83C$0001AAA6$0001ACEE$0001ACCA$0001ACC2$FFE55FC0$0001AFCE$FFE55FC0$FFE55FC0$0001AFAA$0001AFE1$0001AFA7$0001B32C$0000135F$000012E4$0000135F*)
