 IMPLEMENTATION MODULE SysCtrl;
 (*$Y+,N+,L-*)
 
 (*
"14.02.92 TT: ToSuper, ToUser statt Supexec wg. MiNT.
"28.09.90 TT: ExcToScanAddr neu
"13.06.90 TT: EnterSupervisorMode entfernt
"01.05.90 TT: MSByte bei restoreTrap wird vor Vergleich ggf. gelscht
"14.07.89 TT: XBRA-Installation in TRAP #4 (Kennung: "MM2Y")
"25.10.88 TT: CatchRemoval-Aufruf zum Restaurieren des alten TRAP 4-Vektors
"09.04.88 TT: trapHandler und ScanBack laufen nun auch mit 68020.
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM SysTypes IMPORT ScanDesc, ExcDesc;
 FROM MOSSupport IMPORT ToSuper, ToUser;
 
 PROCEDURE GetScanAddr ( VAR info: ScanDesc );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A1
(LEA     4(A7),A0
(MOVE.L  A0,ScanDesc.stack(A1)      ; stack:= A7+4
(MOVE.L  A5,ScanDesc.link(A1)       ; link:= A5
(MOVE.L  (A7),ScanDesc.pc(A1)       ; pc:= RTS-Wert = (A7)
$END
"END GetScanAddr;
 
 PROCEDURE ScanBack ( VAR info: ScanDesc ): BOOLEAN;
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A7
(JSR     ToSuper
(
(LEA     err2(PC),A0
(MOVE.L  8,-(A7)
(MOVE.L  A0,8            ; Bus error
(MOVE.L  12,D1
(MOVE.L  A0,12           ; Addr error
(MOVE.L  A7,D0
(
(MOVE.L  -(A3),A1
(MOVE.L  ScanDesc.stack(A1),A2   ; stack A7
(MOVE.L  ScanDesc.link(A1),A0    ; link A5
(CMPA.L  A2,A0           ; A5 >= A7 ?
(BCS     err             ; n
(
(MOVE.L  (A0)+,ScanDesc.link(A1) ; UNLK A5
(MOVE.L  (A0)+,ScanDesc.pc(A1)   ; RTS-Adr
(MOVE.L  A0,ScanDesc.stack(A1)
(
(MOVEQ   #TRUE,D0
(BRA     ende
(
&err2
(MOVE.L  D0,A7           ; Bus/Addr-Error, SSP korrigieren
&err
(MOVEQ   #FALSE,D0
&ende
(MOVE.L  (A7)+,8            ; Bus error
(MOVE.L  D1,12           ; Addr error
(MOVE    D0,(A3)+
$
(JSR     ToUser
(ADDQ.L  #4,A7
$END
"END ScanBack;
 
 
 PROCEDURE ExcToScanAddr ( REF exc: ExcDesc; VAR info: ScanDesc );
"BEGIN
$ASSEMBLER
(; globalScan.pc:= excData.regPC;
(; globalScan.link:= excData.regA5.ad;
(; globalScan.stack:= excData.parm;
(MOVE.L  -(A3),A0        ;info
(MOVE.L  -(A3),A1        ;ref
(MOVE.L  ExcDesc.regPC(A1),ScanDesc.pc(A0)
(MOVE.L  ExcDesc.regA5(A1),ScanDesc.link(A0)
(MOVE.L  ExcDesc.regUSP(A1),ScanDesc.stack(A0)
$END
"END ExcToScanAddr;
 
 END SysCtrl.
 
(* $FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$00000846$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$FFF2CAD2$0000006ET.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000250$0000003B$00000048$0000006F$000003E6$FFEFB644$000003C7$FFEFB644$000003E6$00000489$000006C1$00000250$FFEFB644$FFEFB644$00000250$FFEFB644*)
