 IMPLEMENTATION MODULE CompTree;
 
 (*$Y+,H+,Z+*)
 
 (*
 IMPORT TOSDebug;
 *)
 
 (*$N+*)
 IMPORT Runtime;
 FROM SYSTEM IMPORT ADDRESS, ASSEMBLER, BYTE;
 FROM Strings IMPORT String, StrEqual, Assign, Append;
 FROM Storage IMPORT ALLOCATE, DEALLOCATE, MemAvail;
 IMPORT Files, Binary;
 
 TYPE PtrPtr = POINTER TO PtrItem;
 
 VAR Code: ADDRESS;
$ok: BOOLEAN;
 
 PROCEDURE ptr (item: PtrItem; ofs: LONGINT): PtrItem;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(ADDA.L  TreeBase,A0
(MOVE.L  (A0),D0
$END
"END ptr;
"(*$L=*)
 
 PROCEDURE long (item: PtrItem; ofs: LONGINT): LONGCARD;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(ADDA.L  TreeBase,A0
(MOVE.L  (A0),D0
$END
"END long;
"(*$L=*)
 
 PROCEDURE card (item: PtrItem; ofs: LONGINT): CARDINAL;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(ADDA.L  TreeBase,A0
(MOVE.W  (A0),D0
$END
"END card;
"(*$L=*)
 
 PROCEDURE int (item: PtrItem; ofs: LONGINT): INTEGER;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(ADDA.L  TreeBase,A0
(MOVE.W  (A0),D0
$END
"END int;
"(*$L=*)
 
 PROCEDURE byte (item: PtrItem; ofs: LONGINT): BYTE;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(ADDA.L  -(A3),A0
(ADDA.L  TreeBase,A0
(MOVE.B  (A0),D0
$END
"END byte;
"(*$L=*)
 
 (*$D-*)
 
 PROCEDURE ScanWholeTree (scanner: TreeProc; new: NewTreeProc);
"VAR tr: PtrItem; sp: PtrPtr; tt: TreeType;
"BEGIN
$sp:= PtrPtr (DisplayStack);
$LOOP
&tr:= sp^;
&IF tr = 1 THEN EXIT END;
&INC (sp, SIZE (sp^));
&IF tr = 0 THEN
(IF new (newscope) THEN END
&ELSE
(IF sp^ = 1 THEN tt:= global ELSE tt:= local END;
(IF new (tt) THEN
*ScanLocalTree (scanner, tr)
(END
&END
$END;
$(* Relocation Stack abarbeiten (lokale Module) *)
$sp:= RelocationStack;
$WHILE sp^ # NoItem DO
&IF new (module) THEN
(ScanLocalTree (scanner, sp^);
&END;
&INC (sp, SIZE (sp^))
$END;
$IF new (pervasive) THEN
&ScanLocalTree (scanner, 0);  (* pervasives *)
$END
"END ScanWholeTree;
 
 PROCEDURE fetch (VAR ptr: PtrItem; VAR name: ARRAY OF CHAR);
"(*
#* Liest Namen aus Baum ein. 'ptr' mu auf das Zeichen vor dem Namen zeigen
#* hinterher zeigt 'ptr' hinter den Text.
#*)
"VAR (*$Reg*)c: CARDINAL; (*$Reg*)by: BYTE;
"BEGIN
$c:= 0;
$LOOP
&IF (c+1) > HIGH (name) THEN HALT END;
&DEC (ptr);
&by:= byte (ptr, 0);
&IF ORD (by) >= $FE THEN
(IF ORD (byte (ptr, 0)) = $FE THEN DEC (ptr); END;
(IF c = 0 THEN
*name[0]:= '*';        (* anonym-Kennung *)
*c:= 1
(END;
(name[c]:= 0C;
(RETURN
&END;
&name [c]:= CHR (ORD (by));
&INC (c)
$END
"END fetch;
 
 (*$D-*)
 
 PROCEDURE ScanLocalTree (scanner: TreeProc; tree: PtrItem);
 
"FORWARD scan (tree: PtrItem);
 
"PROCEDURE doit (it: PtrItem);
$VAR name: String; c: CARDINAL;
$BEGIN
&fetch (it, name);
&(* Relays werden direkt gemeldet
(IF ORD (byte (it, -1)) = 0 THEN
*(* relay *)
*it:= ptr (it, -6)
(END;
&*)
&(* IF int (it, -2) < 0 THEN (* kein Modula-Wort, sondern User-ID *) *)
((* auch dies mu der 'scanner' selbst veranlassen
*c:= ORD (byte (it, -1));
*IF (c=15) (* lok.Modul *) OR (c=16) (* qualifier *) THEN
,IF ptr (it, -6) # NoItem THEN scan (ptr (it, -6)) END
*END;
(*)
(scanner (name, it)
&(* END *)
$END doit;
 
"PROCEDURE scan (tree: PtrItem);
$(* lokale Funktion, um Stackplatz f. Rekursion zu sparen *)
$VAR it: PtrItem;
$BEGIN
&(* linker Ast *)
&it:= ptr (tree, -4);
&IF it # NoItem THEN
(scan (it);
&END;
&(* rechter Ast *)
&it:= ptr (tree, -8);
&IF it # NoItem THEN
(scan (it);
&END;
&doit (tree - 8)
$END scan;
$
"BEGIN
$scan (tree);
"END ScanLocalTree;
 
 PROCEDURE FindItemByName (REF name: ARRAY OF CHAR; VAR item: PtrItem);
"
"PROCEDURE scanTree (REF currname: ARRAY OF CHAR; curritem: PtrItem);
$BEGIN
&(* nur ersten gefundenen Namen bernehmen *)
&IF item = NoItem THEN
(IF StrEqual (name, currname) THEN
*item:= curritem
(END
&END
$END scanTree;
"
"PROCEDURE newTree (typ: TreeType): BOOLEAN;
$BEGIN
&(* nur lokale/globale Level *)
&RETURN (typ <= global)
$END newTree;
"
"BEGIN
$item:= NoItem;
$ScanWholeTree (scanTree, newTree);
"END FindItemByName;
 
 PROCEDURE GetNameOfItem (item: PtrItem;
9VAR name: ARRAY OF CHAR; VAR found: BOOLEAN);
"
"PROCEDURE scanTree (REF currname: ARRAY OF CHAR; curritem: PtrItem);
$BEGIN
&IF item = curritem THEN
(found:= TRUE;
(Assign (currname, name, ok)
&END
$END scanTree;
"
"PROCEDURE newTree (typ: TreeType): BOOLEAN;
$BEGIN
&(* alle Level *)
&RETURN TRUE
$END newTree;
"
"BEGIN
$found:= FALSE;
$name[0]:= 0C;
$ScanWholeTree (scanTree, newTree);
"END GetNameOfItem;
 
 PROCEDURE GetItemDesc (item: PtrItem; VAR desc: ItemDesc): BOOLEAN;
"BEGIN
$IF item = NoItem THEN
&RETURN FALSE
$ELSE
&WITH desc DO
(flag:= ItemFlags (byte (item, -2));
(kind:= ORD (byte (item, -1))
&END;
&RETURN TRUE
$END
"END GetItemDesc;
 
 PROCEDURE SystemType (REF desc: ItemDesc): BOOLEAN;
"TYPE FS = SET OF [0..63];
"BEGIN
$RETURN desc.kind IN FS {1,2,3,4,21,22,23,24,25,26,27,29,
<30,31,33,34,35,36,37,38,39,40,41,43}
"END SystemType;
"
 PROCEDURE Kind (REF desc: ItemDesc): String;
"VAR name: String;
"BEGIN
$CASE desc.kind OF
$| 0: name:= "Relay"
$| 1: name:= "LONGINT"
$| 2: name:= "LONGREAL"
$| 3: name:= "CHAR"
$| 4: name:= "ZZ"
$| 5: name:= "SET(large)"
$| 6: name:= "Prozedur"
$| 7: name:= "Parameter"
$| 8: name:= "Opaque"
$| 9: name:= "Enum-Typ"
$|10: name:= "Enum-Elem"
$|11: name:= "Subrange"
$|12: name:= "ARRAY"
$|13: name:= "RECORD"
$|14: name:= "Rec-Feld"
$|15: name:= "Lok.Modul"
$|16: name:= "Qualifier"
$|17: name:= "Variable"
$|18: name:= "CONST(old)"
$|19: name:= "PROCEDURE"
$|20: name:= "POINTER"
$|21: name:= "WORD"
$|22: name:= "LONGCARD"
$|23: name:= "ADDRESS"
$|24: name:= "BOOLEAN"
$|25: name:= "Opaque"
$|26: name:= "LONGWORD"
$|27: name:= "String"
$|28: name:= "TABLE"
$|29: name:= "Asm-Label"
$|30: name:= "LONGBOTH"
$|31: name:= "StrConst"
$|32: name:= "OpenArray"
$|33: name:= "INTEGER"
$|34: name:= "CARDINAL"
$|35: name:= "SHORTBOTH"
$|36: name:= "StdFunc"
$|37: name:= "StdFunc-Parm"
$|38: name:= "BYTE"
$|39: name:= "BYTE(signed)"
$|40: name:= "REAL"
$|41: name:= "BITNUM"
$|42: name:= "LongOpArr"
$|43: name:= "StructConst"
$|44: name:= "Long-PROC-Typ"
$|45: name:= "SET(32Bit)"
$|46: name:= "Tag-Field"
$|47: name:= "Rec-Variante"
$|50: name:= "CONST(new)"
$ELSE
&name:= "???"
$END;
$RETURN name;
"END Kind;
 
 PROCEDURE flag (REF desc: ItemDesc; flagNo: CARDINAL): String;
"VAR name: String;
"BEGIN
$WITH desc DO
&CASE flagNo OF
&| 7: name:= "Userdef"
&| 6: name:= "Exported"
&| 5: name:= "Imported"
&| 4: name:= "External"
&| 3: name:= "VAR-Parm"
&| 2: name:= "Type"
&| 1: IF 2 IN flag THEN name:= "Anonym" ELSE name:= "Global" END
&| 0: IF 2 IN flag THEN name:= "Scalar" ELSIF kind = 17 THEN
,name:= "Read-only" ELSE name:= "D0-Return" END
&END
$END;
$RETURN name;
"END flag;
 
 PROCEDURE Flags (REF desc: ItemDesc): String;
"VAR name: String; i: CARDINAL; first: BOOLEAN;
"BEGIN
$name[0]:= 0C;
$first:= TRUE;
$FOR i:= 7 TO 0 BY -1 DO
&IF i IN desc.flag THEN
(IF NOT first THEN Append ('/', name, ok); END;
(Append (flag (desc, i), name, ok);
(first:= FALSE
&END
$END;
$RETURN name;
"END Flags;
 
 PROCEDURE ItemTable;
"(*$L-*)
"BEGIN
$ASSEMBLER
(DC.W    0,1,0             ;Relay
(DC.W    6,2,1,1,2,7,8,0   ;PROC
(DC.W    5,2,1,0       ;SET
(DC.W    45,2,1,0      ;SET (neue Ordnung)
(DC.W    7,1,1,3,0     ;PARAM
(DC.W    8,2,0         ;REDECLARABLE OPAQUE
(DC.W    9,2,2,5,0     ;ENUM
(DC.W    10,3,1,5,0    ;ENUM.ELEMENT
(DC.W    11,2,2,2,1,0  ;SUBR
(DC.W    12,2,1,1,0    ;ARRAY
(DC.W    13,2,1,4,0    ;RECORD
(DC.W    14,2,1,1,0    ;REC.FELD
(DC.W    15,4,0        ;Lok. Modul
(DC.W    16,4,0        ;Qualifier
(DC.W    17,2,1,2,7,2,0;VAR
(DC.W    18,1,6,0      ;CONST
(DC.W    19,2,1,1,0    ;PROC.TYPE
(DC.W    20,2,1,0      ;PTR
(DC.W    25,2,0        ;OPAQUE
(DC.W    27,2,2,0      ;STRING
(DC.W    32,1,0        ;OPEN ARRAY
(DC.W    42,1,0        ;OPEN LONGARRAY
(DC.W    1,2,0         ;LINT
(DC.W    2,2,0         ;LONGREAL
(DC.W    3,2,0         ;CHAR
(DC.W    4,2,0         ;ZZ
(DC.W    21,2,0        ;WORD
(DC.W    22,2,0        ;LCARD
(DC.W    23,2,1,0      ;ADDRESS
(DC.W    24,2,0        ;BOOLEAN
(DC.W    26,2,0        ;LONG
(DC.W    30,2,0        ;LBOTH
(DC.W    33,2,0        ;SINT
(DC.W    34,2,0        ;SCARD
(DC.W    35,2,0        ;SBOTH
(DC.W    36,3,1,0      ;StandardProc
(DC.W    37,1,1,1,0    ;StandardProcParams
(DC.W    38,2,0        ;BYTE
(DC.W    39,2,0        ;Signed BYTE
(DC.W    40,2,0        ;REAL
(DC.W    41,2,0        ;BITNUM
(DC.W    43,2,0        ;untyped Constant
(DC.W    44,2,1,0      ;PROC.TYPE bei Parametern (8 Byte Lnge)
(DC.W    46,1,2,2,1,0  ;Record-Tag
(DC.W    47,2,1,1,1,1,0;Rec-Variante
(DC.W    50,2,1,7,4,6,0 ;CONST neu (nun incl. String-Literals)
(DC.W    63,0          ;Dummy-Eintrag
(DC.W    0
$END
"END ItemTable;
"(*$L=*)
 
 PROCEDURE ScanItem (scanner: ItemProc; item: PtrItem);
"VAR no: CARDINAL; pt: POINTER TO CARDINAL; entry: ItemEntry; ofs: INTEGER;
"BEGIN
$no:= ORD (byte (item, -1));
$(* zuerst die Item-Beschreibung in der Tabelle suchen *)
$ASSEMBLER
(LEA     ItemTable,A0
(MOVE.L  A0,pt(A6)
$END;
$LOOP
&IF no = pt^ THEN EXIT END;
&REPEAT INC (pt, 2); UNTIL pt^ = 0;
&INC (pt, 2);
&IF pt^ = 0 THEN HALT END (* Nicht gefunden! *)
$END;
$INC (pt, 2);
$ofs:= -2;
$LOOP
&no:= pt^;
&IF no = 0 THEN EXIT END;
&INC (pt, 2);
&WITH entry DO
(name:= '';
(CASE no OF
(| 1,5: type:= pointer; DEC (ofs, 4); ptrVal:= ptr (item, ofs);
(| 2: type:= const; DEC (ofs, 4); constVal:= long (item, ofs);
(| 3: type:= const; DEC (ofs, 2); constVal:= card (item, ofs);
(| 4: type:= scope; DEC (ofs, 4); ptrVal:= ptr (item, ofs);
(| 6: DEC (ofs, 2);
(| 7: DEC (ofs, pt^); INC (pt, 2);
(ELSE
*HALT
(END
&END;
&IF no <= 5 THEN scanner (entry, pt^ # 0) END;
$END;
"END ScanItem;
 
 PROCEDURE LoadDef (REF name: ARRAY OF CHAR);
"VAR size, l: LONGCARD; f: Files.File;
"BEGIN
$IF Buffer # NIL THEN DEALLOCATE (Buffer, 0) END;
$
$size:= MemAvail () DIV 2; IF ODD (size) THEN DEC (size) END;
$ALLOCATE (Buffer, size);
$IF Buffer = NIL THEN HALT END;
$
$Files.Open (f, name, Files.readOnly);
$IF Binary.FileSize (f) * 4 > size THEN HALT END;
$Binary.ReadBytes (f, Buffer, Binary.FileSize (f), l);
$IF Binary.FileSize (f) # l THEN HALT END;
$Files.Close (f);
$
$Code:= Buffer + 8;
$
$(* chz! *)
$
"END LoadDef;
 
 END CompTree.
  
(* $FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$00002315$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$FFEB02EE$00001631T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001630$00001923$00002315$000022D9$00000CA6$00000ACD$00000B08$00000759$FFE9B44A$FFE9B44A$FFE9B44A$00000759$000005C3$000013FD$0000190C$00001923*)
