 MODULE SignumRead;
 
 (*
!* 19.02.92: '1' und '2' waren vertauscht.
!*)
 
 (*
!* '#' markieren Funoten
!* '@' stehen dort, wo Zeichen dichter als ihre Proportionen aufeinander liegen
!* '@@@' markiert einen Bruch im Text
!*)
 
 IMPORT TOSIO, SimpleError;
 
 FROM InOut IMPORT Write, WriteLn, WriteString, WriteCard, FlushKbd, WritePg,
(WriteLHex, BusyRead, Read;
 
 FROM SYSTEM IMPORT ADDRESS, ADR, TSIZE, BYTE, WORD, LONGWORD, ASSEMBLER;
 
 FROM GEMEnv IMPORT RC, InitGem, DeviceHandle;
 
 FROM EasyGEM0 IMPORT HideMouse;
 
 FROM EasyGEM1 IMPORT SelectMask, SelectFile;
 
 FROM FileNames IMPORT ConcatPath;
 
 FROM Strings IMPORT Compare, Relation, String, Concat, Assign, Insert, Empty,
(Append;
 
 FROM Binary IMPORT ReadBytes, ReadBlock, FilePos, FileSize;
 
 IMPORT Text;
 
 FROM Files IMPORT File, Open, Create, Close, Access, ReplaceMode,
(EOF, State, ResetState;
 
 FROM Storage IMPORT DEALLOCATE;
 IMPORT Storage;
 
 PROCEDURE ALLOCATE (VAR ad: ADDRESS; l: LONGCARD);
"BEGIN
$WriteLn;
$WriteString ('ALLOCATE: ');
$WriteCard (l,0);
$WriteLn;
$Storage.ALLOCATE (ad, l)
"END ALLOCATE;
 
 
 VAR out: File;
$chsnames: ARRAY [0..7], [0..9] OF CHAR;
$chOffset: ARRAY [0..7], [0..127] OF LONGCARD;
$font: ARRAY [0..7] OF ADDRESS;
$spaceWidth: INTEGER;
 
 TYPE Str255 = ARRAY [0..255] OF CHAR;
 
 PROCEDURE Space ( n: INTEGER ): Str255;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(MOVE.L  A3,A0
(ADDA.W  #256,A3
(MOVEQ   #' ',D1
(BRA     C
&L MOVE.B  D1,(A0)+
&C SUBQ    #1,D0
(BPL     L
(CLR.B   (A0)+
$END
"END Space;
"(*$L=*)
 
 PROCEDURE wait;
"VAR c: CHAR;
"BEGIN
$FlushKbd;
$Read (c)
"END wait;
 
 TYPE
 
 (*
"DocHead =     RECORD
2kenn: ARRAY [0..7] OF CHAR;
2lg: LONGCARD;
2div: ARRAY [0..127] OF CHAR
0END;
 
"ChsBlock =    RECORD
2kenn: ARRAY [0..3] OF CHAR;
2lg: LONGCARD;
0END;
 
"Par1Block =   RECORD
2kenn: ARRAY [0..3] OF CHAR;
2lg: LONGCARD;
2tabs: ARRAY [1..40] OF INTEGER;
2list: ARRAY [1..15] OF INTEGER;
0END;
 
"PageBlock =   RECORD
2kenn: ARRAY [0..3] OF CHAR;
2lg: LONGCARD;
2pages: LONGCARD;
2kl: LONGCARD;
2firstPnr: LONGCARD;
2unused: ARRAY [0..5] OF LONGCARD
0END;
 
"Page =        RECORD
2index: INTEGER;
2physPnr: INTEGER;
2logPnr: INTEGER;
2lines: INTEGER;
2lmargin: INTEGER;
2rmargin: INTEGER;
2tmargin: INTEGER;
2bmargin: INTEGER;
2numbpos: INTEGER;
2kapitel: INTEGER;
2intern: INTEGER;
2unused: ARRAY [1..8] OF INTEGER
0END;
 
"TextHead =    RECORD
2kenn: ARRAY [0..3] OF CHAR;
2lg: LONGCARD;
2lines: LONGCARD;
2text: WORD (* ... *)
0END;
 
"Zeile =       RECORD
2blLines: CARDINAL;
2codeLen: CARDINAL;
2code: CHAR (*...*)
0END;
 
"LineBit =     (unused0, unused1,
1hauptZeile, absatz, formel, pgEnd, pgBegin, nonEdit);
"LineBits =    SET OF LineBit;
 
"DescBits =    SET OF [0..7];
"DescWord =    WORD;
 *)
 
"Char =        RECORD
2CASE : CARDINAL OF
2| 1: mode: INTEGER;  (* negativ -> 'short' Modus *)
2| 2: short: WORD
2| 4: low: WORD; high: WORD
2END;
0END;
 
"PtrChar = POINTER TO Char;
 
 
 PROCEDURE taste (): BOOLEAN;
"VAR ch: CHAR;
"BEGIN
$BusyRead (ch);
$IF ch # 0C THEN
&FlushKbd;
&IF ch = 33C THEN RETURN TRUE END;
&Read (ch);
&IF ch = 33C THEN RETURN TRUE END;
$END;
$RETURN FALSE
"END taste;
 
 PROCEDURE toASCII (no: CARDINAL): CHAR;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(LEA     tab(PC),A0
(MOVE.B  0(A0,D0.W),(A3)+
(ADDQ.L  #1,A3
(RTS
&tab:
(ASC     ' ()/*0123456789'
(ASC     '()/*0123456789'
(ASC     '+-.!"#$'
(ASC     "%&'()*+,-./"
(ASC     '0123456789'
(ASC     ':;<=>?'
(ASC     'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
(ASC     '^_`'
(ASC     'abcdefghijklmnopqrstuvwxyz'
(ASC     '|~@@@@@@@@@@@@@@@@@@@@@'
(SYNC
$END
"END toASCII;
"(*$L=*)
 
 PROCEDURE decode (VAR sc: Char;
2VAR ofs: INTEGER; VAR chNo: CARDINAL; VAR width: INTEGER;
2VAR footNote: BOOLEAN): BOOLEAN;
"VAR fontNo: INTEGER;
&ok: BOOLEAN;
&p: POINTER TO CHAR;
"BEGIN
$ASSEMBLER
(MOVE.L  footNote(A6),A2
(MOVE.L  sc(A6),A0
(
(MOVE.W  (A0),D2
(MOVE.W  D2,D1
(ANDI    #$7F,D2
(BEQ     error
(MOVE.L  chNo(A6),A1
(MOVE    D2,(A1)
(
(MOVE.L  (A0),D0
(BPL     l
(
(SWAP    D0
(ROL.W   #7,D0
(ANDI    #$003F,D0
(LSR.W   #7,D1
(ANDI    #3,D1
(CLR.W   (A2)            ; keine Funote
(BRA     e
 
%error
(CLR     ok(A6)
(BRA     ee
 
%l  BTST    #10,D1
(SNE     D2
(ANDI    #1,D2
(MOVE    D2,(A2)         ; Funote
(
(BTST    #11,D0
(BEQ     n1
(BTST    #12,D0
(BNE     error           ; gro- und kleinschrift geht nicht
%n1 MOVE    D1,D2
(ANDI    #0011100000000000%,D2
(BNE     error           ; reserviert - mssen Null sein
 
(ANDI    #$07FF,D0
(LSR.W   #7,D1
(ANDI    #7,D1
(
%e  MOVE.L  ofs(A6),A0
(MOVE    D0,(A0)
(MOVE    D1,fontNo(A6)
(MOVE    #1,ok(A6)
 
%ee
$END;
$IF NOT ok OR (font [fontNo] = NIL) THEN
&RETURN FALSE
$END;
$p:= font [fontNo] + chOffset [fontNo][chNo] + 2L;
$width:= ORD (p^);
$(*
&Write (toASCII (sc));
&WriteCard (chNo, 4);
&WriteCard (fontNo, 2);
&WriteCard (spc, 3);
&IF taste () THEN HALT END;
&ASSEMBLER
*MOVE.L p(A6),A0
*BREAK
&END;
&WriteCard (ORD (p^), 3);
&WriteLn;
$*)
$RETURN TRUE
"END decode;
 
 PROCEDURE advChar (VAR p: PtrChar);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVE.L  (A0),A1
(TST.W   (A1)
(BMI     w
(ADDQ.L  #4,(A0)
(RTS
&w ADDQ.L  #2,(A0)
$END
"END advChar;
"(*$L=*)
 
 PROCEDURE peek (VAR p: ADDRESS; VAR d: ARRAY OF BYTE);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1
(MOVE.L  -(A3),A0
(MOVE.L  (A0),A2
&L MOVE.B  (A2)+,(A1)+
(DBRA    D1,L
(MOVE.L  A2,(A0)
$END
"END peek;
"(*$L=*)
 
 PROCEDURE wrln;
"BEGIN
$Text.WriteLn (out);
"END wrln;
 
 PROCEDURE wrstr (s: ARRAY OF CHAR);
"BEGIN
$Text.WriteString (out, s)
"END wrstr;
 
 PROCEDURE wr (c: CHAR);
"BEGIN
$Text.Write (out, c)
"END wr;
 
 PROCEDURE wrpg;
"BEGIN
$Text.WritePg (out)
"END wrpg;
 
 PROCEDURE beginOfPage (p: ADDRESS): BOOLEAN;
"BEGIN
$INC (p,2);
$IF p^ # WORD (4) THEN RETURN FALSE END;
$INC (p,2);
$IF p^ # WORD ($C080) THEN RETURN FALSE END;
$INC (p,2);
$RETURN p^ # WORD (0)
"END beginOfPage;
 
 
 PROCEDURE parseText (ad: ADDRESS; len: LONGCARD);
"
"VAR p: PtrChar;
&lastp, endp: ADDRESS;
&lastseite, seite: CARDINAL;
&error: BOOLEAN;
 
"PROCEDURE scan (VAR p: PtrChar): BOOLEAN;
$VAR chNo, blankLines, c1, c2, c3: CARDINAL;
(ofs, lastWidth, width, i1, i2, i3: INTEGER;
(l1, l2, l3: LONGCARD;
(ch: CHAR;
(sc: Char;
(flag: SET OF [0..7];
(p2: ADDRESS;
(pos: CARDINAL;
(lastFoot, footNote, ok: BOOLEAN;
(s: ARRAY [0..255] OF CHAR;
$BEGIN
&(* Zeilenbeginn *)
&peek (p, blankLines);
&peek (p, c1);
&IF c1 > 10000 THEN RETURN FALSE END;
&p2:= ADDRESS (p) + LONG (c1);
&peek (p, flag);
&IF 7 IN flag THEN
(IF 5 IN flag THEN
*(*
,wrpg ();
**)
(ELSIF 6 IN flag THEN
*WriteString ('Seite ');
*WriteCard (seite,0);
*WriteLn;
*INC (seite)
(ELSE
*(* eines von beiden mu es sein! *)
*error:= TRUE;
*RETURN FALSE;
(END
&ELSIF 3 IN flag THEN
(wrln () (* Absatz *)
&END;
&peek (p, flag);
&FOR c2:= 0 TO 7 DO
(IF c2 IN flag THEN
*peek (p, c3);
(END
&END;
&pos:= 0; lastWidth:= 0;
&lastFoot:= FALSE;
&LOOP
(IF ADDRESS (p) >= p2 THEN EXIT END;
((* jedes Zeichen der Zeile *)
(IF NOT decode (p^, ofs, chNo, width, footNote) THEN
*error:= TRUE;
*RETURN FALSE
(END;
(IF ofs < lastWidth THEN
*s[pos]:= '@';
*INC (pos)
(ELSE
*FOR i2:= 1 TO (ofs - lastWidth + spaceWidth - 4) DIV spaceWidth DO
,IF pos >= SIZE (s) THEN RETURN FALSE END;
,s[pos]:= ' ';
,INC (pos);
*END;
(END;
(IF pos >= SIZE (s) THEN RETURN FALSE END;
(lastWidth:= width;
(IF footNote THEN
*IF NOT lastFoot THEN
,lastFoot:= TRUE;
,s[pos]:= '#';
,INC (pos);
,IF pos >= SIZE (s) THEN RETURN FALSE END;
*END
(ELSE
*lastFoot:= FALSE
(END;
(s[pos]:= toASCII (chNo);
(INC (pos);
(IF pos >= SIZE (s) THEN RETURN FALSE END;
(advChar (p);
&END;
&
&IF pos > 0 THEN
(s[pos]:= 0C;
(wrstr (s);
&END;
&wrln ();
$
&IF error THEN RETURN FALSE END;
$
&RETURN TRUE
$END scan;
 
"BEGIN
$endp:= ad + len;
$(* rest vom header berlesen *)
$seite:= 1;
$p:= ad + 4L;
$ASSEMBLER
*MOVE.L  p(A6),A0
*; BREAK
$END;
$
$(* zeilen lesen *)
$REPEAT
&
&error:= FALSE;
&
&LOOP
(lastp:= p;
(
((*
*IF ~(scan (p) & scan (p) & scan (p) & scan (p) & scan (p) & scan (p)) THEN
,p:= lastp+2;
*END;
(*)
(IF scan (p) THEN END;
(
(IF p >= endp THEN EXIT END;
&END; (* LOOP *)
&
&IF error THEN
(wrln ();
(wrstr ('@@@');
(wrln ();
(wrln ();
(WriteString ('Bruch!'); WriteLn;
(
(IF ODD (p) THEN INC (p) END;
((*
(REPEAT
*INC (p,2);
(UNTIL beginOfPage (p) OR (ADDRESS (p) >= endp)
(*)
&END;
 
$UNTIL ADDRESS (p) >= endp;
"END parseText;
 
 PROCEDURE readFont (n: CARDINAL);
"VAR
$s8: ARRAY [0..7] OF CHAR;
$len, lc: LONGCARD;
$buf: ADDRESS;
$ok: BOOLEAN;
$s: String;
$f: File;
"BEGIN
$Concat (chsnames [n], '.E24', s, ok);
$ConcatPath (SelectMask, s, SelectMask);
$SelectFile ('Font?', s, ok);
$WritePg;
$IF NOT ok THEN RETURN END;
$Open (f, s, readOnly);
$
$ReadBlock (f, s8);
$IF Compare ('eset0001', s8) # equal THEN
&WriteString ("Dies ist keine Font-Datei!");
&wait;
&RETURN
$END;
$
$ReadBlock (f, lc);
$ALLOCATE (buf, lc);
$IF buf = NIL THEN WriteString ('Out of mem'); wait; RETURN END;
$ReadBytes (f, buf, lc, len);
$IF lc # len THEN
&WriteString ("EOF!");
&wait;
$END;
$DEALLOCATE (buf, lc);
$
$ReadBlock (f, chOffset[n]);
$ALLOCATE (font[n], chOffset[n][0]);
$IF font[n] = NIL THEN WriteString ('Out of mem'); wait; RETURN END;
$ReadBytes (f, font[n], chOffset[n][0], len);
$IF chOffset[n][0] # len THEN
&WriteString ("EOF!");
&wait;
$END;
$Close (f);
"END readFont;
 
 VAR f: File;
$ok: BOOLEAN;
$s: String;
$s8: ARRAY [0..7] OF CHAR;
$s4: ARRAY [0..3] OF CHAR;
$c: CARDINAL;
$i: CARDINAL;
$len, lc: LONGCARD;
$fonts: BOOLEAN;
$buf: ADDRESS;
$dev: DeviceHandle;
 
 BEGIN
"InitGem (RC, dev, ok);
"HideMouse;
"WritePg;
"SelectMask:= '*.sdo';
"s:= '';
"SelectFile ('Signum-Datei zum Lesen', s, ok);
"WritePg;
"IF NOT ok THEN RETURN END;
"Open (f, s, readOnly);
"
"spaceWidth:= 9;
"
"ReadBlock (f, s8);
"IF Compare ('sdoc0001', s8) # equal THEN
$WriteString ("Dies ist keine Signum-Datei!");
$wait;
$RETURN
"END;
"
"(* Info-Blocks berlesen *)
"s4:= '';
"fonts:= FALSE;
"LOOP
$ReadBlock (f, lc);
$IF Compare ('cset', s4) = equal THEN
&fonts:= TRUE;
&ReadBlock (f, chsnames);
&FOR i:= 0 TO 6 DO
(IF NOT Empty (chsnames[i]) THEN
*readFont (i);
(END
&END
$ELSE
&(* geht nur, wenn die Blcke fehlerfrei sind:
(ALLOCATE (buf, lc);
(IF buf = NIL THEN WriteString ('Out of mem'); wait; RETURN END;
(ReadBytes (f, buf, lc, len);
(IF lc # len THEN
*WriteString ("EOF vor 'tebu'!");
*wait;
*RETURN
(END;
(DEALLOCATE (buf, lc);
&*)
&IF fonts THEN
(EXIT (* damit werden auch die restlichen Blocks als Text geladen *)
&END
$END;
$ReadBlock (f, s4);
$IF Compare ('tebu', s4) = equal THEN EXIT END;
"END;
"
"(*
#* Text einlesen
#*)
"(* Lnge der Text-Daten:  ReadBlock (f, lc); *)
"lc:= FileSize (f) - FilePos (f); (* Ganzen Datei-Rest lesen *)
"WriteString ('Textpos: '); WriteLHex (FilePos(f), 0); WriteLn;
"WriteString ('Textlnge: '); WriteLHex (lc, 0); WriteLn;
"ALLOCATE (buf, lc);
"IF buf = NIL THEN WriteString ('Out of mem'); wait; RETURN END;
"ReadBytes (f, buf, lc, len);
"IF lc # len THEN
$WriteString ("Datei ist zu kurz! Weiter...");
$wait;
$WriteLn;
"END;
"
"Close (f);
 
"SelectMask:= '*.txt';
"s:= 'output.txt';
"SelectFile ('Ausgabe-Datei', s, ok);
"WritePg;
"IF NOT ok THEN RETURN END;
"Create (out, s, writeOnly, replaceOld);
"WriteString ('Start...');
"WriteLn;
"parseText (buf, len);
"Close (out);
 
"WriteLn;
"WriteString ('Ende');
"wait
 END SignumRead.
 
(* $FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$00001AB9$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$FFED8BD7$00000050T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000026CD$0000289A$000028FE$00002A91$00002ADD$00002ABD$00000E11$00000050$00002B34$00002ADD$00002096$00002111$0000208C$000026D7$000028AB$0000289A*)
