 MODULE XBRATest;
 
 (*
!* Demo-Programm fr XBRA-Modul
!*)
 
 IMPORT XBRA;
 
 FROM SYSTEM IMPORT ADDRESS, ADR;
 FROM InOut IMPORT WriteString, WriteLn, WriteLHex, Read;
 
 VAR v: PROC;
$at, entry: ADDRESS;
$removable, ok: BOOLEAN;
$carr2, carrier: XBRA.Carrier;
 
 PROCEDURE info (s: ARRAY OF CHAR);
"BEGIN
$WriteString (s);
$WriteLn;
"END info;
 
 PROCEDURE WriteAddr (a: ADDRESS);
"BEGIN
$WriteLHex (a,7);
"END WriteAddr;
 
 PROCEDURE step (at: ADDRESS; name: XBRA.ID): BOOLEAN;
"BEGIN
$WriteString ('  Vektor: ');
$WriteAddr (at);
$WriteString (', ID:');
$WriteString (name);
$WriteString (', Funktion: ');
$WriteAddr (XBRA.Called (at));
$WriteString (', Vorgnger: ');
$WriteAddr (XBRA.PreviousEntry ( XBRA.Entry (at) ));
$WriteLn;
$RETURN TRUE
"END step;
 
 PROCEDURE check;
"BEGIN
$WriteString ('Query...');
$WriteLn;
$XBRA.Query (ADR (v), step)
"END check;
 
 PROCEDURE test;
"BEGIN
$info ('  Dies ist die Test-Routine 1');
"END test;
 
 PROCEDURE test2;
"BEGIN
$info ('  Dies ist die Test-Routine 2')
"END test2;
 
 PROCEDURE doit;
"BEGIN
$v:= test2;
$
$check;
$
$IF NOT XBRA.Installed ('Test', ADR (v), at) THEN
&info ('Installiere 1');
&XBRA.Create (carrier, 'Test', ADDRESS (test), entry);
&XBRA.Install (entry, at)
$END;
$check;
$
$info ('Aufruf');
$v;
$
$IF NOT XBRA.Installed ('Tes2', ADR (v), at) THEN
&info ('Installiere 2');
&XBRA.Create (carr2, 'Tes2', ADDRESS (test2), entry);
&XBRA.Install (entry, at)
$END;
$check;
$
$info ('Aufruf');
$v;
$
$IF XBRA.Installed ('Test', ADR (v), at) THEN
&info ('1 Wird entfernt');
&XBRA.Remove (at)
$ELSE
&info ('1 Nicht installiert')
$END;
$check;
$
$info ('Aufruf');
$v;
$
$IF XBRA.Installed ('Tes2', ADR (v), at) THEN
&info ('2 Wird entfernt');
&XBRA.Remove (at)
$ELSE
&info ('2 Nicht installiert')
$END;
$check;
"END doit;
 
 VAR ch:CHAR;
 BEGIN
"doit;
"Read (ch)
 END XBRATest.
 