{ +--------------------------------------------+ }
{ | (C)1990 TommySoftware Thomas Maier, Berlin | }
{ |  Version 3.00  Letzte nderung 29.06.1990  | }
{ +--------------------------------------------+ }


{ Dieses Programm erzeugt die Informationsdatei 'MEGA_01.MOD'. Diese enthlt
  alle Informationen, die MegaPaint bentigt, um das Modul 'MEGA_01.PRG'
  aufrufen zu knnen. Bei diesem handelt es sich um ein Beispielmodul, das
  die Modulstruktur von MegaPaint verdeutlichen soll.
  Siehe dazu 'MEGA_01.PAS'. }


program Make_Mod_Version_3_00;

type
     str7=string[7];
    str31=string[31];
   str127=string[127];

 mod_file=record
        kennung:str7;                   { 'MOD 3.0' }
         memory:long_integer;           { Bentigter Speicher }
           name:str31;                  { Namenseintrag im Men }
            anz:integer;                { Anzahl bentigter Dateinamen }
          files:array[0..7]of str7;     { Endungen fr die Dateinamen }
          types:array[0..7]of integer;  { Typen fr die Dateinamen, s.u. }
          texts:array[0..7]of str127;   { berschriften fr GET_FILENAME }
          dummy:integer;                { Reserviert }
          end;

var     
        feld:mod_file;
        disk:file of mod_file;

begin
  with feld do begin

    kennung:='MOD 3.0';                 { In Hex: $07 4d 4f 44 20 33 2e 30 }

     memory:=20000;                     { Bentigter Speicherplatz fr
                                          Programmcode, Stack und Heap
                                          in Bytes }

       name:='Vektorisierung';          { Eintrag, der im Untermen zu
                                          EXTERNES MODUL auftauchen soll,
                                          maximal 31 Zeichen }

        anz:=3;                         { Es sollen vor dem Aufruf drei 
                                          Dateinamen eingelesen werden }

    types[0]:=2;                        { Bilddatei *.BLD oder *.BL1 }
    files[0]:='';                       { Wird automatisch auf *.BL? gesetzt }
    texts[0]:='Vektorisierung, Rasterbild whlen';
                                        { berschrift in der Dateiauswahlbox,
                                          maximal 63 Zeichen }

    types[1]:=1;                        { Angegebene Endung vorgeschrieben }
    files[1]:='.VEK';                   { Gewnschte Endung angeben }
    texts[1]:='Vektorisierung, Vektordatei whlen';
                                        { berschrift in der Dateiauswahlbox,
                                          maximal 63 Zeichen }

    types[2]:=0;                        { Beliebige Endung }
    files[2]:='';                       { Wird automatisch auf *.* gesetzt }
    texts[2]:='Vektorisierung, Protokolldatei';
                                        { berschrift in der Dateiauswahlbox,
                                          maximal 63 Zeichen }

       dummy:=0;                        { Dummy, am besten auf 0 setzen }
  end;
  rewrite(disk,'I:\MEGA_01.MOD');
  disk^:=feld;put(disk);
end.

