;devpac 2.08 !!
;Convertet to DEVPAC 1.1.1991
; ********************************************
; *              NMI MEMORY-SAVE             *
; *     Idee und Source von Jrgen Meyer     *
; * Erschienen am 10/Oktober 1988-ST MAGAZIN *
; *                                          *
; * Screensave Routine des Snapshot.acc ein- *
; * gebunden von  U L Y S S E S am ??.??.88  *
; ********************************************

	section	text
	BRA	L1			;Installation der Routine

NMI:
	move.w	(sp)+,SR_B		;Status-Register sichern
	move.l	(sp)+,RETADD+2		;Rcksprung-Adresse sichern
	move.l	#MSAVE,-(sp)		;Rcksprung auf Routine 'biegen'
	move.w	#$2700,-(sp)		;Supervisor ein, Interrupts aus
	rte

MSAVE:	movem.l	d0-d7/a0-a6,RBUFF	;Registersatz sichern
	move.l	sp,SSTACK		;Stack separat speichern
	move.l	RETADD+2,PCB		;Programm-Counter sichern
	movea.l	STACK,sp		;neuen Stack einrichten
	bsr.s	SAVE			;Daten schreiben
QUIT:	movem.l	RBUFF,d0-d7/a0-a6	;Register restaurieren
	movea.l	SSTACK,sp		;Stack separat laden
	move.w	SR_B,sr			;Statusregister restaurieren
RETADD:	jmp	$ffffff			;... und weiter im Hauptprg.

SAVE:
	tst.w	$44c			;320x200-Modus ?
	bne	NO320			;Nein --> Weiter

	move.l	$ff8240,PALETTE
	and.l	#$07770777,PALETTE
	move.l	$ff8244,PALETTE+4
	and.l	#$07770777,PALETTE+4
	move.l	$ff8248,PALETTE+8
	and.l	#$07770777,PALETTE+8
	move.l	$ff824c,PALETTE+12
	and.l	#$07770777,PALETTE+12
	move.l	$ff8250,PALETTE+16
	and.l	#$07770777,PALETTE+16
	move.l	$ff8254,PALETTE+20
	and.l	#$07770777,PALETTE+20
	move.l	$ff8258,PALETTE+24
	and.l	#$07770777,PALETTE+24
	move.l	$ff825c,PALETTE+28
	and.l	#$07770777,PALETTE+28

	clr.w	-(sp)			;R/W-Status
 	pea	DEGASNAME		;Dateiname
 	move.w	#$3c,-(sp)		;Create-Funktion
	trap	#1			;Gemdos
	addq.l	#8,sp
 	tst.w	d0			;Fehler ?
	bmi	DPEXIT			;Ja --> Ende
	move.w	d0,HANDLE		;Handle merken
	addi.b	#1,DEGASNAME+7		;Neuer Name
	cmpi.b	#91,DEGASNAME+7		;Kein Buchstabe ?
	bne.s	NAMEOK			;Nein --> Weiter
	move.b	#65,DEGASNAME+7		;Auf A setzen

NAMEOK:	pea	EMPTY			;Adresse retten
	move.l	#34,-(sp)		;34 Bytes schreiben
	move.w	HANDLE,-(sp)		;Dateihandle
	move.w	#$40,-(sp)		;FWRITE-Funktion
	trap	#1			;GEMDOS
	adda.l	#12,sp			;Stapelkorrektur
	tst.w	d0			;Fehler ?
	bmi.s	DPEXIT			;Ja --> Ende

	bra.s	CONTINUE		;Rest schreiben

NO320:	clr.w	-(sp)			;R/W-Status
	pea	DOODLENAME		;Dateiname
	move.w	#$3c,-(sp)		;Create-Funktion
	trap	#1			;Gemdos
	addq.l	#8,sp
	tst.w	d0			;Fehler ?
 	bmi.s	DPEXIT			;Ja --> Ende
	move.w	d0,HANDLE		;Handle merken
	addi.b	#1,DOODLENAME+7		;Neuer Name
	cmpi.b	#91,DOODLENAME+7	;Kein Buchstabe ?
 	bne.s	CONTINUE		;Nein --> Weiter
	move.b	#65,DOODLENAME+7	;Auf A setzen

CONTINUE:
	move.l	$44e,-(sp)		;Bildschirmstart
	move.l	#32000,-(sp)		;Bildschirmgre
	move.w	HANDLE,-(sp)		;Dateihandle
	move.w	#$40,-(sp)		;Fwrite
 	trap	#1			;Gemdos
	adda.l	#12,sp

	move.w	HANDLE,-(sp)		;Dateihandle
	move.w	#$3e,-(sp)		;Fclose
	trap	#1			;Gemdos
 	addq.l	#4,sp

DPEXIT:	rts
	section	data
SSTACK:	dc.l	0			;Buffer fr den aktuellen Stack
SR_B:	dc.w	0			;Buffer fr das Status-Register
RBUFF:	dcb.l	15,0			;Buffer fr Register D0-D7/A0-A6
PCB:	dc.l	0			;Buffer fr den Programm-Counter
STACK:	dc.l	0			;Buffer fr Programmstack
LEN:	dc.l	0			;Lnge des Programms
DBSEC:	dc.l	0
EMPTY:	dc.w	0 

PALETTE:	ds.w	16
ERROR:		ds.l	1
HANDLE:		ds.w	1
		ds.l	40

	section	text       
L1:	dc.w	$a00a			;Maus ausschalten
	movea.l	sp,a5			;Speicherplatzberechnung
	movea.l	4(a5),a5		;Adresse der BASEPAGE
	move.l	12(a5),d0		;Lnge des TEXT-Bereiches
 	add.l	20(a5),d0		;Lnge des DATA-Bereiches
 	add.l	28(a5),d0		;Lnge des BSS-Bereiches
	addi.l	#$710,d0		;BASEPAGE, Stack und Disk-Buffer
	move.l	d0,d1			;Lnge nach D1 kopieren
	add.l	a5,d1			;plus Anfang des Programms
	andi.l	#-2,d1			;Gerade Adresse erzeugen
	subq.l	#8,d1			;Sicher ist sicher ...
	move.l	d1,STACK		;D1 = neue Stack-Adresse
	subi.l	#$600,d1		;Disk-Buffer reservieren
	move.l	d1,DBSEC
	move.l	d0,LEN
	move.l	d0,-(sp)
	move.l	a5,-(sp)
	clr.w	-(sp)
	move.w	#$4a,-(sp)
	trap	#1
	adda.l	#12,sp
	movea.l	STACK,sp
	pea	NMI
	move.w	#$1f,-(sp)
	move.w	#$05,-(sp)
	trap	#13
	addq.l	#8,sp
	pea	NMI
 	move.w	#$18,-(sp)
	move.w	#$05,-(sp)
	trap	#13
	addq.l	#8,sp

;Es hat sich durch Tests gezeigt, dass durch die Elektronik des Tasters
;zeitweilig auch einen SPURIOS-Interrupt erzeugt (Vektor $18 statt
;Vektor $1f fr den NMI) wird, deshalb wird der entsprechende Vektor
;ebenfalls 'umgebogen'.
;Ausserdem wird zuweilen beim Drcken des Tasters auch ein Address-Error
;erzeugt. Aus Sicherheitsgrnden wird dieser Vektor nicht 'umgebogen',
;da dies recht selten vorkommt; ausserdem sollte die eigentliche Bedeu-
;tung des address-Errors (3 Bomben) nicht verndert werden.

;Soll der ADDRESS-ERROR-Vektor trotzdem gendert werden, so mssen noch
;folgende Zeilen mitassembliert werden :

	pea	NMI			;Adresse der neuen Routine
	move.w	#$03,-(sp)		;ADDRESS-ERROR-Vektor
	move.w	#$05,-(sp)		;SETEXEC
	trap	#13			;BIOS Aufrufen
	addq.l	#8,sp			;Stack restaurieren

	pea	TEXT
	move.w	#9,-(sp)
 	trap	#1
	addq.l	#6,sp
	move.w	#7,-(sp)
	trap	#1
	addq.l	#2,sp
	clr.w	-(sp)
	move.l	LEN,-(sp)
	move.w	#$31,-(sp)
	trap	#1
;-------------------------
	section	data
TEXT:
	dc.b	27,69,27,102,32,10,27,"p NMI MEMORY-SAVE aktiv ",27,113
	dc.b	13,10,10," Von Jrgen Meyer",13,10,10,10
	dc.b	" Exklusiv fr MARKT & TECHNIK",13,10,10
	dc.b	10,10," Bitte Taste drcken ...",0
 	even

DEGASNAME:	dc.b	"DEGASL_A.PI1",0
DOODLENAME:	dc.b	"DOODLE_A.DOO",0
	even