/*      FILE: atari.c
        
        Routines: This file contains the following routines:
                eihalt()
                kbread()
                clksec()
                restore()
                stxrdy()
                disable()
                memstat()
                a_tmpfile()
                check_time()
                getds()
                doshell()
                dodir()
                docd(argc, argv)

    Modifications:
    07 Dec 90   Herbert Thielen     dta_fd() adapted to Turbo-C 2.0
                                    Includes adapted to TC 2.0
*/


#include <stdio.h>
#include <stdlib.h>
#include <tos.h>
#include <ext.h>
#include <string.h>
#include <ctype.h>
#include <linea.h>
#include "global.h"
#include "cmdparse.h"
#include "iface.h"
#include "types.h"
#include "dir.h"
#include <time.h>
#include "session.h"
#include "atari.h"
#include "ping.h"
#include "icmp.h"
#include "icmpcmd.h"
#include "tcp.h"
#include "ip.h"
#include "eth.h"

#define TMP_ENV "TMP"		
#define TMP_DIR "\\TMP"			/* keine '\\' am Ende! */
#define TMP_NAME "NET_TMP."		/* es werden 3 Zeichen angehngt! */
static char tmp_dir[MAXPATH];
/* falls die Environment-Variable TMP=<tmpdir> existiert, werden dort   */
/* temporre Files abgespeichert. Sonst in <startdrive>:<TMP_DIR>       */
/* oder, falls dieses nicht existiert, in <startdirectory>.			    */

#define SHELL_PRG "C:\\BIN\\COMMAND.PRG"	/* Shell command */
#define a_L_tmpnam 64+12+1	/* Path, Name, 0-Byte */
#define TTY_COOKED 0

#define CD_ERROR "Path doesn't exist!"

extern char startup[], userfile[], hosts[];
extern char *startupname, *userfilename, *hostsname;
extern char prompt[], fprompt[];
extern int  mput_state;

extern void berr_catch(void);	/* bus error handler for ST */

#define MPUT_PASSIV 0
#define MPUT_AKTIV 1
#define MPUT_DONE  2


struct interface *ifaces;

static DTA dta;
static struct RemoveIt {
        struct RemoveIt *next;
        char *name_ptr;
} *Head;

/* lokale Prototypen */
static void iorestart(void);
static void listdir (char *p_name, char *datn, char ext);
static int  next_state(int cm, int fq, int fa, int fn, int fd);/* Zeile 641 */
static int chdir_and_drv( char *newdir);

void (* old_berr)();		 /* old bus error handler */
int memok;                   /* bus-error-flag 		  */


void eihalt( void )
{
}


int kbread(void)
{
        static unsigned char    next;
        unsigned char           c;
        unsigned long           inval;

        if ( (c = next) != '\0' )
        {

                next = '\0';
                return ((int)c);
        }

        if ( Cconis() == 0 )
                return (-1);

        inval = Crawcin();

        if ( (c = (char)inval) == '\0' )
        {
                /* may be a special key ... */
                
/*              switch ( scancode = (int)(inval>>16) )  */
                switch ( (int)(inval>>16) & 0xFF )              /* HT */
                {
                case 44:        /* alt-Y */						/* HT */
                case 46:        /* alt-C */					    /* HT */
                        return (int)(inval >> 8);
                case 59:        /* F1 */
                        next = '1';
                        break;
                case 60:        /* F2 */
                        next = '2';
                        break;
                case 61:        /* F3 */
                        next = '3';
                        break;
                case 62:        /* F4 */
                        next = '4';
                        break;
                case 63:        /* F5 */
                        next = '5';
                        break;
                case 64:        /* F6 */
                        next = '6';
                        break;
                case 65:        /* F7 */
                        next = '7';
                        break;
                case 66:        /* F8 */
                        next = '8';
                        break;
                case 67:        /* F9 */
                        next = '9';
                        break;
                case 68:        /* F10 */
                        next = '0';
                        break;
                case 71:        /* Clr Home */
                        next = 'Z';
                        break;
                case 72:        /* Cursor up */
                        next = 'A';
                        break;
                case 75:        /* Cursor left */
                        next = 'D';
                        break;
                case 77:        /* Cursor right */
                        next = 'C';
                        break;
                case 80:        /* Cursor down */
                        next = 'B';
                        break;
                case 82:        /* Insert */
                        next = 'I';
                        break;
                case 97:        /* Undo (Escape character) */
                        return (escape);
                case 98:        /* Help */
                        next = 'H';
                        break;
                default: 		/* unbekannte ALT-Taste */
                        return ((int)c);	/* 0x00 */
                }
                c = '\033';
        }
        return ((int)c);
}


int clksec( void )
{
        long tim;

        (void)time(&tim);
        return ((int) tim);
}


void restore(int i_state)
{
}


int stxrdy( void )
{
	return(1);
}


int disable( void )
{
	return 0;
}


int memstat(int argc, char** argv)
{
        printf("%lu bytes free memory\n", Malloc(-1L));
        return(0);
}


/* a_tmpfile: create a temporary file.  Remember it so we can delete 
   it later because the mac does not allow the file to be deleted 
   when it is open.
 */
 
void a_tmpfile (char *name) /* tmpfile() exists in turbo-c stdio.h */
{
        struct RemoveIt *rptr;
             static int tmp_count=0; 	/* Zhler fr tmp-files */
                   char s[17];			/* String-Hilfsvar. */

        do {
          /* tmp-Filenamen erzeugen */        
          strcpy(name, tmp_dir);
          strcat(name, TMP_NAME);
          strncat(name, itoa(tmp_count++,s,36), 3);		/* Extension */
        } while( Fsfirst(name,0) == 0 );

        /* Namen in Lschliste einhngen */
        rptr = Head;
        while(rptr->next != NULL )
        {
                rptr = rptr->next;
        }
        
        if ( (rptr->next = (struct RemoveIt *)malloc(sizeof (struct RemoveIt)) ) == NULL)
                return;
        rptr = rptr->next;
        rptr->next = NULL;
        if ( (rptr->name_ptr = malloc(strlen(name)+1) ) == NULL)
                return;
        strcpy (rptr->name_ptr, name);
}


/* checks the time then ticks and updates ISS */

static int clkval = 0;

void check_time( void )
{
        int32 iss();

        if(clkval != clksec())
        {
                clkval = clksec();
                icmpclk();
                tick();
                (void)iss();
        }
}


int getds( void )
{
        return (0);
}


void audit( void )
{
}


int doshell(int argc, char **argv)
{
        char    program[80];
        char    command[256];
        int     status;

        if ( argc == 1 )
                strcpy (program, SHELL_PRG);
        else
        {
                strcpy (program, argv[1]);
                strcat (program, ".PRG");
        }
        command[0] = '\0';

        iostop ();

        status = (int)Pexec (0, program, command, "path=\0");

        iorestart ();

        switch (status)
        {
        case -33:
                printf ("\nshell: %s not found\n", program);
                break;
        case -39:
                printf ("\nshell: not enough memory\n");
                break;
        case -32:
        case -66:
                printf ("\nshell: %s not executable\n", program);
                break;
        default:
                /* clear screen */
                printf ("\033E");
        }
        return (status);
}

int dodir(int argc, char **argv)
{
        if( argc >= 2)
                listdir (argv[1], "stdout", 'l');
        else
                listdir (".", "stdout", 'l');
        return 0;
}


int docd(int argc, char **argv)
{
        char tmp[MAXPATH];
        int  error = 0;

        if( argc > 1 ) error = chdir_and_drv (argv[1]);
        if( (getcwd(tmp,MAXPATH)) == NULL )
                return (-1);
        puts ( (error == 0) ? tmp : CD_ERROR );
        if(current != NULLSESSION &&
           current->type==FTP && mput_state==MPUT_PASSIV)
            printf(fprompt,32);
        fflush(stdout);
        return (0);
}

void ioinit( void )
{ 
  char path[MAXPATH];		/* current dir, wenn NET startet */
  char *p_tmpdir;	        		/* temporary directory */
      
  /* Kartentest */
  memok = 0;
  old_berr = Setexc(2,(void (*)())(-1)); 	/* Alten Buserror-Vektor sichern */
  Setexc(2,berr_catch);   				/* auf berr_catch verbiegen 			*/

  RAP = CSR0;       			 /* Error -> berr_catch setzt memok */
  
  Setexc(2,old_berr);      /* richtigen Vektor wieder einsetzen */   

  if (memok==0)            /* kein Fehler aufgetreten -> Karte da */
  {
    printf(" TUM-LPR-Ethernetcard found ! \n");
  }  
  else		  							 /* Buserror -> keine Karte da 					*/
  {
    printf("Sorry, TUM-LPR-Ethernetcard not found !\n");
 	exit(-1);									
  }        


        /* hide mouse */
        linea_init();
        hide_mouse();

        Head = malloc (sizeof (struct RemoveIt));
        Head->next = NULL;
        Head->name_ptr = NULL;

        getcwd (path,MAXPATH);
		/* path wird mit "\\" abgeschlossen, falls das Root-Directory
		   aktuelles Directory ist! Also abschneiden.
		*/
		if(path[strlen(path)-1]=='\\') path[strlen(path)-1]='\0';
        sprintf (startup, "%s\\%s", path, startupname);
        sprintf (userfile, "%s\\%s", path, userfilename);
        sprintf (hosts, "%s\\%s", path, hostsname);

        /* tmp-Directory herausfinden */
        if( ((p_tmpdir=getenv(TMP_ENV)) != NULL) &&
            (chdir_and_drv(p_tmpdir) == 0) )
           /* Environment-Variable vorhanden und Pfad exisitiert */
           strncpy(tmp_dir, p_tmpdir, MAXPATH);
        else
        {	/* Testen, ob <startdrv>:<TMP_DIR> existiert */
            tmp_dir[0] = path[0]; tmp_dir[1] = ':';
            strncat(tmp_dir, TMP_DIR, MAXPATH-2);
            
            /* Falls nicht, Start-Pfad nehmen */
            if( chdir_and_drv(tmp_dir) != 0 )
               strcpy(tmp_dir, path);
        }
        if(tmp_dir[strlen(tmp_dir)-1]!='\\') strcat(tmp_dir,"\\");
        /* zurck in current directory */
        chdir_and_drv(path);

        Fsetdta (&dta);				/* zur Sicherheit vorbelegen */

        printf("\033E");
        Cursconf( 1, 0);
}


void
iostop( void )
{
        struct interface *interface;
        struct RemoveIt *rptr, *fptr;
        
        interface = ifaces;
        while(interface != NULLIF){
                if(interface->stop != (int(*)(int16))0)
                        (*interface->stop)(interface->dev);
                interface = interface->next;
        }

        /*
         * I want to close down all the files and then remove the (possibly still existing) files
         * because the MAC will not allow the file to be removed when it still has an open file
         * descriptor
         */
         
        rptr = Head;
        do
        {
                if ( rptr->name_ptr != NULL)
                {
                        unlink(rptr->name_ptr);
                        free (rptr->name_ptr);
                }
                fptr = rptr;
                rptr = rptr->next;
                free (fptr);
        }
        while( rptr != NULL);       
        show_mouse(1);
        Cursconf (0, 0);
}

static void
iorestart( void )
{
        struct interface *interface;

        interface = ifaces;
        while (interface != NULLIF)
        { 
                if(interface->init != 0)
                        (*interface->init)(interface);
                interface = interface->next;
        }

        Head = malloc (sizeof (struct RemoveIt));
        Head->next = NULL;
        Head->name_ptr = NULL;

        hide_mouse();
        Cursconf (1, 0);
}


/* Create a directory listing in a temp file and return the resulting file
 * descriptor. If full == 1, give a full listing; else return just a list
 * of names.
 */
FILE*
dir(char *path, int full)
{
        char name[a_L_tmpnam];

        a_tmpfile (name);

        if ( path[0] == '\0' )
                path = ".";

        if (full)
                listdir( path, name, 'l');
        else
                listdir( path, name, 's');

        return (fopen (name,"r"));
}


static void
listdir (char *p_name, char *datn, char ext)
{
        char p_old[MAXDIR];
        int  drive, old_drive;
        char *f_name = "*.*";
        FILE *fd;
        DTA *old_dtap;

        if ( strcmp (datn, "stdout") == 0 )
                fd = stdout;
        else
        {
                fd = fopen (datn, "w");
                if ( fd == NULLFILE ){
                        printf("Can't open %s",datn);
                        return;
                }
        }

        /* set drive */

        old_drive = Dgetdrv();
        if( p_name[1] == ':' )          /* drive included */
        {
            drive = toupper(*p_name)-'A';
            p_name += 2;
        }    
        else drive = old_drive;
        
        if( getcurdir(drive+1, p_old) )
        {
            fputs (" no such drive\n", fd);
            if(fd!=stdout) fclose(fd);
            return;
        }

        Dsetdrv(drive);
        
        /* test if single pathname */

        if ( (*p_name != 0) && (chdir (p_name) < 0) )
        {

                /* may be "path\file(s)" combination */

                if ( (f_name = strrchr (p_name, '\\')) != NULL )
                {
                        *f_name = '\0';
                        f_name++;
                        if ( chdir (p_name) < 0 )
                        {
                                fputs (" no such directory\n", fd);
                                Dsetdrv(old_drive);
                                if(fd!=stdout) fclose(fd);
                                return;
                        }
                }
                else
                        f_name = p_name;
        }

        old_dtap = Fgetdta();
        Fsetdta (&dta);				/* zur Sicherheit vorbelegen */
        if ( Fsfirst (f_name, 0x10) < 0 )
                fputs( "\n", fd);
        else
        {
                dta_fd (fd, ext);
                while ( Fsnext() >= 0 )
                        dta_fd(fd, ext);
        }
        Fsetdta (old_dtap);			/* wieder auf alten Wert */

        chdir(p_old);               /* restore current directory */
        Dsetdrv(old_drive);         /* and current drive         */
        if ( fd != stdout )
                fclose(fd);
        if(current != NULLSESSION &&
           current->type==FTP && mput_state==MPUT_PASSIV)
            printf(fprompt,33);
        fflush(stdout);
}


static void
dta_fd(FILE *fd, char ext) /* write directory entry to file */
{
        char         line[80];
        char         *tp, *linp;

        linp = line;

        if ( (! strcmp (dta.d_fname, ".")) || (! strcmp (dta.d_fname, "..")) )
                return;
        if ( ext != 'l' )
                sprintf (linp, "%s\n", dta.d_fname);
        else
        {
                if ( dta.d_attrib & FA_SUBDIR )
                        sprintf (linp, "d");
                else
                        sprintf (linp, "-");
                linp++;

                if ( dta.d_attrib & FA_READONLY )
                        sprintf (linp, "r-");
                else
                        sprintf (linp, "rw");
                linp += 2;

                sprintf (linp, "%7lu", dta.d_length);
                linp += 7;

                /* convert file timestamp */
                tp = asctime(ftimtotm((struct ftime *)&dta.d_time));
                tp += 4;
                sprintf (linp, " %20s", tp);
                linp += 21;

                sprintf (linp, " %s\n", dta.d_fname);
        }

        for (linp = line; *linp != '\0'; linp++)
                *linp = tolower (*linp);
        fputs (line, fd);
}


/* state machine for matching pattern
 * Return value : ok!
 *              ok = 1:  pattern and mask match
 *              ok = 0:  pattern and mask dont match
 *              ok = -1: illegal mask
 *              ok = -2: error in state machine
 */

#define Z0 0
#define Z1 1
#define Z2 2
#define Z3 3
#define Z4 4
#define Z5 5
#define Z6 6
#define Z7 7
#define Z8 8
#define Z9 9

int
match( char *pattern, char *mask)
{
        char *p_p, *p_m, cp, cm;
        int state, ok;

        p_m = mask;
        p_p = pattern;
        ok = 1;                 /* optimistic start */

        state = Z0;
        while( (ok == 1) && ( state != Z8) ){
                switch(state){
                        case Z0:
                                cm = *p_m++;    /* naechstes mask Zeichen */
                                state = next_state(cm, Z4, Z1, Z9, Z3);
                                break;
                        case Z1:
                                cm = *p_m++;            /* naechstes mask Zeichen */
                                state = next_state(cm, Z9, Z9, Z6, Z2);
                                break;
                        case Z2:
                                ok = 0; /* pesimistic */
                                while( (ok==0) && ((cp = *p_p++) != 0) ){
                                        if(cp == cm)
                                                ok = 1; /* pesimist was wrong */
                                }
                                cm = *p_m++;            /* naechstes mask Zeichen */
                                state = next_state(cm, Z4, Z5, Z7, Z3);
                                break;
                        case Z3:
                                if(cm != *p_p++)
                                        ok = 0;
                                cm = *p_m++;            /* naechstes mask Zeichen */
                                state = next_state(cm, Z4, Z5, Z7, Z3);
                                break;
                        case Z4:
                                if( *p_p++ != 0)
                                        ;
                                else
                                        ok = 0;
                                cm = *p_m++;            /* naechstes mask Zeichen */
                                state = next_state(cm, Z4, Z9, Z7, Z3);
                                break;
                        case Z5:
                                cm = *p_m++;            /* naechstes mask Zeichen */
                                state = next_state(cm, Z9, Z9, Z6, Z2);
                                break;
                        case Z6:
                                state = Z8;
                                break;
                        case Z7:
                                if( *p_p++ != 0)
                                        ok = 0;
                                state = Z8;
                                break;
                        case Z8:
                                state = Z8;
                                break;
                        case Z9:
                                ok = -1;
                                state = Z9;
                                break;
                        default:
                                ok = -2;
                                state = Z9;
                                printf("state machine crashes\n");
                                break;
                }
        }

        return ok;
}




/* Folgezustand:
 *              fq: Folgezustand nach '?'
 *              fa: Folgezustand nach '*'
 *              fn: Folgezustand nach '\0'
 *              fd: Folgzustand nach beliebigen Zeichen
 */
static int
next_state(int cm, int fq, int fa, int fn, int fd)
{
        switch(cm){
                case '?':
                        return fq;
                        /* break; */
                case '*':
                        return fa;
                        /* break; */
                case '\0':
                        return fn;
                        /* break; */
                default:
                        return fd;
                        /* break; */
        }
}

static int
chdir_and_drv( char *newdir)
{
    int olddrv;
    char *p;

    p = newdir;
    olddrv = Dgetdrv();         /* get current drive */
    if( p[1] == ':' )           /* 1st char is new drive */
    {
        Dsetdrv( toupper(*p) -'A' );    /* set new drive */
        p += 2;                 /* behind ':' */
    }
    if( (*p != 0) && (chdir(p) != 0) )
    {
        Dsetdrv(olddrv);        /* set old drive again */
        return(-1);
    }  
    return(0);
}
