/* Stuff generic to all Ethernet controllers */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "misc.h"
#include "enet.h"

char ether_bdcst[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

/* Convert Ethernet header in host form to network mbuf */
struct mbuf *
htonether(struct ether *ether)
{
	struct mbuf *bp;
	register char *cp;

	bp = alloc_mbuf(ETHERLEN);
	bp->cnt = ETHERLEN;
	cp = bp->data;

	memcpy(cp,ether->dest,EADDR_LEN);
	cp += EADDR_LEN;
	memcpy(cp,ether->source,EADDR_LEN);
	cp += EADDR_LEN;
	put16(cp,ether->type);

	return bp;
}
/* Extract Ethernet header */
int
ntohether(struct ether *ether, struct mbuf **bpp)
{
	pullup(bpp,ether->dest,EADDR_LEN);
	pullup(bpp,ether->source,EADDR_LEN);
	ether->type = pull16(bpp);
	return ETHERLEN;
}

/* Format an Ethernet address into a printable ascii string */
int
pether(char *out, char *addr)
{
	sprintf(out,"%02x:%02x:%02x:%02x:%02x:%02x",
		addr[0] & 0xff,
		addr[1] & 0xff,
		addr[2] & 0xff,
		addr[3] & 0xff,
		addr[4] & 0xff,
		addr[5] & 0xff,
		addr[6] & 0xff);
    return 0;
}

/* Convert an Ethernet address from Hex/ASCII to binary */
void
gether(register char *out, register char *cp)
{
	register int i;

	for(i=6; i!=0; i--){
		*out++ = htoi(cp);
		if((cp = index(cp,':')) == NULLCHAR)	/* Find delimiter */
			break;
		cp++;			/* and skip over it */
	}
}
/* Version of gether for ARP, matches passed args */
int
gaether(char *out, char *in[], int cnt)
{
	gether(out,in[0]);
	return 0;
}

