/* Ring- und Buffergroessen */
#define BGR 1518 /* Muss sein damit kein data chaining */
		 /* incl crc bei rbuf                  */
#define T_BANZ 8
#define T_LEN 3
#define R_BANZ 32
#define R_LEN 5

/* LANCE Register */
#define CSR0 0
#define CSR1 1
#define CSR2 2
#define CSR3 3

/* LANCE I/O Ports */
#define RAP (*((int*)0xfffdf2L))
#define RDP (*((int*)0xfffdf0L))
#define EAP (*((int*)0xfffdf4L))

/* CSR0 Bits */
#define INIT 0x0001
#define STRT 0x0002
#define STOP 0x0004
#define TDMD 0x0008
#define TXON 0x0010
#define RXON 0x0020
#define INEA 0x0040
#define INTR 0x0080
#define IDON 0x0100
#define TINT 0x0200
#define RINT 0x0400
#define MERR 0x0800
#define MISS 0x1000
#define CERR 0x2000
#define BABL 0x4000
#define SERR 0x8000

/* CSR3 Bits */
#define BCON 0x1
#define ACON 0x2
#define BSWP 0x4

/* RD1, TD1 Bits */
#define ENP   0x01 /* RD1 & TD1 */
#define STP   0x02 /* RD1 & TD1 */
#define RBUFF 0x04 /* RD1 */
#define DEF   0x04 /* TD1 */
#define CRC   0x08 /* RD1 */
#define ONE   0x08 /* TD1 */
#define OFLO  0x10 /* RD1 */
#define MORE  0x10 /* TD1 */
#define FRAM  0x20 /* RD1 */
#define DERR  0x40 /* RD1 & TD1 */
#define OWN   0x80 /* RD1 & TD1 */

/* TD3 Bits */
#define TDR   0X0300
#define RTRY  0x0400
#define LCAR  0x0800
#define LCOL  0x1000
#define UFLO  0x4000
#define TBUFF 0x8000
#define ONES  0xf000

/* soft error flags */
#define F1  0x0001
#define F2  0x0002
#define F3  0x0004
#define F4  0x0008
#define F5  0x0010
#define F6  0x0020
#define F7  0x0040
#define F8  0x0080
#define F9  0x0100
#define F10 0x0200
#define F11 0x0400
#define F12 0x0800
#define F13 0x1000
#define F14 0x2000
#define F15 0x4000
#define F16 0x8000

/* Initialisierungsblock */
typedef struct {
		int 	mode,
			pad[3],
			lad[4];
		int rr_lw;
		char rr_len;
		char rr_hb;
		int tr_lw;
		char tr_len;
		char tr_hb;
} IOPB;

/* Deskriptorringeintrag */
typedef struct {
		int b_lw;
		char status;
		char b_hb;
		int bcnt;
		int ertdmc;
} DRE;

struct ecb
{
	int tb_w;
	int tb_r;
	int rb_r;
	int ind_w;
	int ind_r;
};

struct statistics {
	int	fflags;
	long	t_count,
		r_count,
		bdcasts;
	int	babl,
		cerr,
		miss,
		merr,
		fram,
		oflo,
		crc,
		rbuff,
		more,
		one,
		def,
		tbuff,
		uflo,
		lcol,
		lcar,
		rtry;
};

/* ************** Prototypen ************* */

int eth_init(struct interface *interface);

int eth_send (
	     struct mbuf *bp,         /* Buffer to send */
    struct interface *interface,  /* Pointer to interface control block */
               int32 gateway,     /* IP address of next hop */
                char precedence,
                char delay,
                char throughput,
                char reliability);

int eth_output(
	struct interface *interface,
                char dest[],
                char source[],
               int16 type,
         struct mbuf *bp);

int eth_raw(struct interface *interface, struct mbuf *bp);
void eth_isr( int );
int eth_recv(struct interface *interface);
int eth_stop(int16 dev);
int eth_attach(int argc, char *argv[]);
DRE* ring_init(char art, DRE deskr[]);
/* int weiter(int zeiger, int maximum); */
int rint(int index, struct interface *interface);
int fehler( void );
int doetherstat(int argc, char** argv);
/* Ende Prototypen */

